/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.cpu.CPU;
import jdos.cpu.Flags;
import jdos.hardware.Memory;

public class CPU_Regs
extends Flags {
    public static final int CF = 1;
    public static final int PF = 4;
    public static final int AF = 16;
    public static final int ZF = 64;
    public static final int SF = 128;
    public static final int OF = 2048;
    public static final int TF = 256;
    public static final int IF = 512;
    public static final int DF = 1024;
    public static final int IOPL = 12288;
    public static final int NT = 16384;
    public static final int VM = 131072;
    public static final int AC = 262144;
    public static final int ID = 0x200000;
    public static final int FMASK_TEST = 2261;
    public static final int FMASK_NORMAL = 266197;
    public static final int FMASK_ALL = 294869;
    public static final int es = 0;
    public static final int cs = 1;
    public static final int ss = 2;
    public static final int ds = 3;
    public static final int fs = 4;
    public static final int gs = 5;
    public static final Reg reg_eax = new Reg("eax");
    public static final Reg reg_ebx = new Reg("ebx");
    public static final Reg reg_ecx = new Reg("ecx");
    public static final Reg reg_edx = new Reg("edx");
    public static final Reg reg_esi = new Reg("esi");
    public static final Reg reg_edi = new Reg("edi");
    public static final Reg reg_esp = new Reg("esp");
    public static final Reg reg_ebp = new Reg("ebp");
    public static final Reg reg_ah = new Reg(reg_eax);
    public static final Reg reg_bh = new Reg(reg_ebx);
    public static final Reg reg_ch = new Reg(reg_ecx);
    public static final Reg reg_dh = new Reg(reg_edx);
    public static int reg_eip;
    public static int flags;

    public static void SETFLAGBIT(int flag, boolean set) {
        flags = set ? (flags |= flag) : (flags &= ~flag);
    }

    public static int GETFLAG(int flag) {
        return flags & flag;
    }

    public static boolean GETFLAGBOOL(int flag) {
        return (flags & flag) != 0;
    }

    public static int GETFLAG_IOPL() {
        return (flags & 0x3000) >> 12;
    }

    public static int RealMakeSegDS(int off) {
        return Memory.RealMake(CPU.Segs_DSval, off);
    }

    public static int RealMakeSegSS(int off) {
        return Memory.RealMake(CPU.Segs_SSval, off);
    }

    public static void SegSet16ES(int val) {
        CPU.Segs_ESval = val;
        CPU.Segs_ESphys = val << 4;
    }

    public static void SegSet16CS(int val) {
        CPU.Segs_CSval = val;
        CPU.Segs_CSphys = val << 4;
    }

    public static void SegSet16SS(int val) {
        CPU.Segs_SSval = val;
        CPU.Segs_SSphys = val << 4;
    }

    public static void SegSet16DS(int val) {
        CPU.Segs_DSval = val;
        CPU.Segs_DSphys = val << 4;
    }

    public static void SegSet16FS(int val) {
        CPU.Segs_FSval = val;
        CPU.Segs_FSphys = val << 4;
    }

    public static void SegSet16GS(int val) {
        CPU.Segs_GSval = val;
        CPU.Segs_GSphys = val << 4;
    }

    public static int reg_ip() {
        return reg_eip & 0xFFFF;
    }

    public static void reg_ip(int value) {
        reg_eip = value & 0xFFFF | reg_eip & 0xFFFF0000;
    }

    public static final class Reg {
        Reg parent;
        String name = null;
        public int dword;

        public Reg() {
        }

        public Reg(String name) {
            this.name = name;
        }

        public Reg(Reg parent) {
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public Reg getParent() {
            return this.parent;
        }

        public void set8(short s) {
            if (this.parent == null) {
                this.low(s);
            } else {
                this.parent.high(s);
            }
        }

        public short get8() {
            if (this.parent == null) {
                return this.low();
            }
            return this.parent.high();
        }

        public final void dword(long l) {
            this.dword = (int)l;
        }

        public final void word_dec() {
            this.word(this.word() - 1);
        }

        public final int word() {
            return this.dword & 0xFFFF;
        }

        public final void word(int value) {
            this.dword = value & 0xFFFF | this.dword & 0xFFFF0000;
        }

        public final short low() {
            return (short)((long)this.dword & 0xFFL);
        }

        public final void low(int value) {
            this.dword = value & 0xFF | this.dword & 0xFFFFFF00;
        }

        public final short high() {
            return (short)((long)(this.dword >> 8) & 0xFFL);
        }

        public final void high(int value) {
            this.dword = (value & 0xFF) << 8 | this.dword & 0xFFFF00FF;
        }
    }
}

