/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Core_normal;
import jdos.cpu.Flags;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.Cache;
import jdos.cpu.core_dynamic.CacheBlockDynRec;
import jdos.cpu.core_dynamic.CodePageHandlerDynRec;
import jdos.cpu.core_dynamic.Decoder;
import jdos.cpu.core_dynamic.Decoder_basic;
import jdos.cpu.core_share.Data;
import jdos.misc.Log;

public class Core_dynamic {
    public static final int CACHE_MAXSIZE = 8192;
    public static final int CACHE_PAGES = 512;
    public static final int CACHE_BLOCKS = 131072;
    public static final int CACHE_ALIGN = 16;
    public static final int DYN_HASH_SHIFT = 4;
    public static final int DYN_PAGE_HASH = 256;
    public static final int DYN_LINKS = 16;
    public static final int SMC_CURRENT_BLOCK = 65535;
    public static int instruction_count = 128;
    private static final CodePageHandlerDynRecRef chandlerRef = new CodePageHandlerDynRecRef();
    public static final CPU.CPU_Decoder CPU_Core_Dynrec_Trap_Run = new CPU.CPU_Decoder(){

        public int call() {
            int oldCycles = CPU.CPU_Cycles;
            CPU.CPU_Cycles = 1;
            CPU.cpu.trap_skip = false;
            int ret = Core_normal.CPU_Core_Normal_Run.call();
            if (!CPU.cpu.trap_skip) {
                CPU.CPU_HW_Interrupt(1);
            }
            CPU.CPU_Cycles = oldCycles - 1;
            CPU.cpudecoder = CPU_Core_Dynamic_Run;
            return ret;
        }
    };
    public static final CPU.CPU_Decoder CPU_Core_Dynamic_Run = new CPU.CPU_Decoder(){

        public int call() {
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            block7: while (CPU.CPU_Cycles > 0) {
                int ip_point = CPU.Segs_CSphys + CPU_Regs.reg_eip;
                Paging.PageHandler handler2 = Paging.get_tlb_readhandler(ip_point);
                CodePageHandlerDynRec chandler = null;
                int page_ip_point = ip_point & 0xFFF;
                if (handler2 != null && handler2 instanceof CodePageHandlerDynRec) {
                    chandler = (CodePageHandlerDynRec)handler2;
                }
                if (chandler == null) {
                    if (Decoder_basic.MakeCodePage(ip_point, chandlerRef)) {
                        CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
                        continue;
                    }
                    chandler = chandlerRef.value;
                }
                if (chandler == null) {
                    return Core_normal.CPU_Core_Normal_Run.call();
                }
                CacheBlockDynRec block = chandler.FindCacheBlock(page_ip_point);
                int ret = 0;
                if (block == null) {
                    if (chandler.invalidation_map == null || chandler.invalidation_map.p[page_ip_point] < 4) {
                        block = Decoder.CreateCacheBlock(chandler, ip_point, instruction_count);
                    } else {
                        int old_cycles = CPU.CPU_Cycles;
                        CPU.CPU_Cycles = 1;
                        int nc_retcode = Core_normal.CPU_Core_Normal_Run.call();
                        if (nc_retcode == 0) {
                            CPU.CPU_Cycles = old_cycles - 1;
                            continue;
                        }
                        CPU.CPU_CycleLeft += old_cycles;
                        return nc_retcode;
                    }
                }
                block8: while (true) {
                    if (block != null) {
                        ret = block.code.call();
                    }
                    switch (ret) {
                        case 1: {
                            CacheBlockDynRec next;
                            if (block == null || (block = (next = block.link1.to) == null ? Core_dynamic.LinkBlocks(block, ret) : next) == null || CPU.CPU_Cycles <= 0) continue block7;
                            continue block8;
                        }
                        case 2: {
                            CacheBlockDynRec next;
                            if (block == null || (block = (next = block.link2.to) == null ? Core_dynamic.LinkBlocks(block, ret) : next) == null || CPU.CPU_Cycles <= 0) continue block7;
                            continue block8;
                        }
                        case 3: 
                        case 4: {
                            break block8;
                        }
                        case 5: {
                            Flags.FillFlags();
                            return Data.callback;
                        }
                        case 6: {
                            CPU.CPU_Exception(6, 0);
                            break block8;
                        }
                        default: {
                            Log.exit("Invalid return code " + ret);
                            break block8;
                        }
                    }
                    break;
                }
            }
            Flags.FillFlags();
            return 0;
        }
    };

    public static void CPU_Core_Dynamic_Init() {
    }

    public static void CPU_Core_Dynamic_Cache_Init(boolean enable_cache) {
        Cache.cache_init(enable_cache);
    }

    public static void CPU_Core_Dynamic_Cache_Close() {
    }

    private static CacheBlockDynRec LinkBlocks(CacheBlockDynRec running, int ret) {
        CacheBlockDynRec block = null;
        int temp_ip = CPU.Segs_CSphys + CPU_Regs.reg_eip;
        Paging.PageHandler handler2 = Paging.get_tlb_readhandler(temp_ip);
        if (handler2 instanceof CodePageHandlerDynRec) {
            CodePageHandlerDynRec temp_handler = (CodePageHandlerDynRec)handler2;
            if ((temp_handler.flags & 8) != 0) {
                block = temp_handler.FindCacheBlock(temp_ip & 0xFFF);
                if (block == null) {
                    return null;
                }
                running.LinkTo(ret == 2 ? 1 : 0, block);
                return block;
            }
        }
        return null;
    }

    public static final class CodePageHandlerDynRecRef {
        public CodePageHandlerDynRec value;
    }
}

