/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.LazyFlags;
import jdos.misc.Log;

public class Flags {
    public static LazyFlags lflags = new LazyFlags();
    static short[] parity_lookup = new short[]{4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4};
    public static final int t_UNKNOWN = 0;
    public static final int t_ADDb = 1;
    public static final int t_ADDw = 2;
    public static final int t_ADDd = 3;
    public static final int t_ORb = 4;
    public static final int t_ORw = 5;
    public static final int t_ORd = 6;
    public static final int t_ADCb = 7;
    public static final int t_ADCw = 8;
    public static final int t_ADCd = 9;
    public static final int t_SBBb = 10;
    public static final int t_SBBw = 11;
    public static final int t_SBBd = 12;
    public static final int t_ANDb = 13;
    public static final int t_ANDw = 14;
    public static final int t_ANDd = 15;
    public static final int t_SUBb = 16;
    public static final int t_SUBw = 17;
    public static final int t_SUBd = 18;
    public static final int t_XORb = 19;
    public static final int t_XORw = 20;
    public static final int t_XORd = 21;
    public static final int t_CMPb = 22;
    public static final int t_CMPw = 23;
    public static final int t_CMPd = 24;
    public static final int t_INCb = 25;
    public static final int t_INCw = 26;
    public static final int t_INCd = 27;
    public static final int t_DECb = 28;
    public static final int t_DECw = 29;
    public static final int t_DECd = 30;
    public static final int t_TESTb = 31;
    public static final int t_TESTw = 32;
    public static final int t_TESTd = 33;
    public static final int t_SHLb = 34;
    public static final int t_SHLw = 35;
    public static final int t_SHLd = 36;
    public static final int t_SHRb = 37;
    public static final int t_SHRw = 38;
    public static final int t_SHRd = 39;
    public static final int t_SARb = 40;
    public static final int t_SARw = 41;
    public static final int t_SARd = 42;
    public static final int t_ROLb = 43;
    public static final int t_ROLw = 44;
    public static final int t_ROLd = 45;
    public static final int t_RORb = 46;
    public static final int t_RORw = 47;
    public static final int t_RORd = 48;
    public static final int t_RCLb = 49;
    public static final int t_RCLw = 50;
    public static final int t_RCLd = 51;
    public static final int t_RCRb = 52;
    public static final int t_RCRw = 53;
    public static final int t_RCRd = 54;
    public static final int t_NEGb = 55;
    public static final int t_NEGw = 56;
    public static final int t_NEGd = 57;
    public static final int t_DSHLw = 58;
    public static final int t_DSHLd = 59;
    public static final int t_DSHRw = 60;
    public static final int t_DSHRd = 61;
    public static final int t_MUL = 62;
    public static final int t_DIV = 63;
    public static final int t_NOTDONE = 64;
    public static final int t_LASTFLAG = 65;

    public static short lf_var1b() {
        return (short)(Flags.lflags.var1 & 0xFF);
    }

    public static void lf_var1b(int b) {
        Flags.lflags.var1 &= 0xFFFFFF00;
        Flags.lflags.var1 |= b & 0xFF;
    }

    public static short lf_var2b() {
        return (short)(Flags.lflags.var2 & 0xFF);
    }

    public static void lf_var2b(int b) {
        Flags.lflags.var2 &= 0xFFFFFF00;
        Flags.lflags.var2 |= b & 0xFF;
    }

    public static short lf_resb() {
        return (short)(Flags.lflags.res & 0xFF);
    }

    public static void lf_resb(int b) {
        Flags.lflags.res &= 0xFFFFFF00;
        Flags.lflags.res |= b & 0xFF;
    }

    public static int lf_var1w() {
        return Flags.lflags.var1 & 0xFFFF;
    }

    public static void lf_var1w(int s) {
        Flags.lflags.var1 &= 0xFFFF0000;
        Flags.lflags.var1 |= s & 0xFFFF;
    }

    public static int lf_var2w() {
        return Flags.lflags.var2 & 0xFFFF;
    }

    public static void lf_var2w(int s) {
        Flags.lflags.var2 &= 0xFFFF0000;
        Flags.lflags.var2 |= s & 0xFFFF;
    }

    public static int lf_resw() {
        return Flags.lflags.res & 0xFFFF;
    }

    public static void lf_resw(int s) {
        Flags.lflags.res &= 0xFFFF0000;
        Flags.lflags.res |= s & 0xFFFF;
    }

    static long lf_var1d() {
        return (long)Flags.lflags.var1 & 0xFFFFFFFFL;
    }

    public static void lf_var1d(long v) {
        Flags.lflags.var1 = (int)v;
    }

    public static long lf_var2d() {
        return (long)Flags.lflags.var2 & 0xFFFFFFFFL;
    }

    public static void lf_var2d(long v) {
        Flags.lflags.var2 = (int)v;
    }

    static long lf_resd() {
        return (long)Flags.lflags.res & 0xFFFFFFFFL;
    }

    public static void lf_resd(long v) {
        Flags.lflags.res = (int)v;
    }

    public static void SETFLAGSb(int FLAGB) {
        CPU_Regs.SETFLAGBIT(2048, Flags.get_OF());
        Flags.lflags.type = 0;
        CPU.CPU_SetFlags(FLAGB, 213);
    }

    public static void LoadCF() {
        CPU_Regs.SETFLAGBIT(1, Flags.get_CF());
    }

    public static void LoadZF() {
        CPU_Regs.SETFLAGBIT(64, Flags.get_ZF());
    }

    public static void LoadSF() {
        CPU_Regs.SETFLAGBIT(128, Flags.get_SF());
    }

    public static void LoadOF() {
        CPU_Regs.SETFLAGBIT(2048, Flags.get_OF());
    }

    public static void LoadAF() {
        CPU_Regs.SETFLAGBIT(16, Flags.get_AF());
    }

    public static boolean get_CF() {
        switch (Flags.lflags.type) {
            case 0: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 62: {
                return CPU_Regs.GETFLAG(1) != 0;
            }
            case 1: {
                return Flags.lf_resb() < Flags.lf_var1b();
            }
            case 2: {
                return Flags.lf_resw() < Flags.lf_var1w();
            }
            case 3: {
                return Flags.lf_resd() < Flags.lf_var1d();
            }
            case 7: {
                return Flags.lf_resb() < Flags.lf_var1b() || Flags.lflags.oldcf && Flags.lf_resb() == Flags.lf_var1b();
            }
            case 8: {
                return Flags.lf_resw() < Flags.lf_var1w() || Flags.lflags.oldcf && Flags.lf_resw() == Flags.lf_var1w();
            }
            case 9: {
                return Flags.lf_resd() < Flags.lf_var1d() || Flags.lflags.oldcf && Flags.lf_resd() == Flags.lf_var1d();
            }
            case 10: {
                return Flags.lf_var1b() < Flags.lf_resb() || Flags.lflags.oldcf && Flags.lf_var2b() == 255;
            }
            case 11: {
                return Flags.lf_var1w() < Flags.lf_resw() || Flags.lflags.oldcf && Flags.lf_var2w() == 65535;
            }
            case 12: {
                return Flags.lf_var1d() < Flags.lf_resd() || Flags.lflags.oldcf && Flags.lf_var2d() == 0xFFFFFFFFL;
            }
            case 16: 
            case 22: {
                return Flags.lf_var1b() < Flags.lf_var2b();
            }
            case 17: 
            case 23: {
                return Flags.lf_var1w() < Flags.lf_var2w();
            }
            case 18: 
            case 24: {
                return Flags.lf_var1d() < Flags.lf_var2d();
            }
            case 34: {
                if (Flags.lf_var2b() > 8) {
                    return false;
                }
                return (Flags.lf_var1b() >> 8 - Flags.lf_var2b() & 1) != 0;
            }
            case 35: {
                if (Flags.lf_var2b() > 16) {
                    return false;
                }
                return (Flags.lf_var1w() >> 16 - Flags.lf_var2b() & 1) != 0;
            }
            case 36: 
            case 58: 
            case 59: {
                return (Flags.lf_var1d() >>> 32 - Flags.lf_var2b() & 1L) != 0L;
            }
            case 37: 
            case 52: {
                return (Flags.lf_var1b() >> Flags.lf_var2b() - 1 & 1) != 0;
            }
            case 38: 
            case 53: {
                return (Flags.lf_var1w() >> Flags.lf_var2b() - 1 & 1) != 0;
            }
            case 39: 
            case 54: 
            case 60: 
            case 61: {
                return (Flags.lf_var1d() >>> Flags.lf_var2b() - 1 & 1L) != 0L;
            }
            case 40: {
                return (Flags.lf_var1b() >> Flags.lf_var2b() - 1 & 1) != 0;
            }
            case 41: {
                return (Flags.lf_var1w() >> Flags.lf_var2b() - 1 & 1) != 0;
            }
            case 42: {
                return (Flags.lf_var1d() >> Flags.lf_var2b() - 1 & 1L) != 0L;
            }
            case 55: {
                return Flags.lf_var1b() != 0;
            }
            case 56: {
                return Flags.lf_var1w() != 0;
            }
            case 57: {
                return Flags.lf_var1d() != 0L;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: {
                return false;
            }
            case 63: {
                return false;
            }
        }
        Log.log(8, 2, "get_CF Unknown " + Flags.lflags.type);
        return false;
    }

    public static boolean get_AF() {
        switch (Flags.lflags.type) {
            case 0: {
                return CPU_Regs.GETFLAG(16) != 0;
            }
            case 1: 
            case 7: 
            case 10: 
            case 16: 
            case 22: {
                return ((Flags.lf_var1b() ^ Flags.lf_var2b() ^ Flags.lf_resb()) & 0x10) != 0;
            }
            case 2: 
            case 8: 
            case 11: 
            case 17: 
            case 23: {
                return ((Flags.lf_var1w() ^ Flags.lf_var2w() ^ Flags.lf_resw()) & 0x10) != 0;
            }
            case 3: 
            case 9: 
            case 12: 
            case 18: 
            case 24: {
                return ((Flags.lf_var1d() ^ Flags.lf_var2d() ^ Flags.lf_resd()) & 0x10L) != 0L;
            }
            case 25: {
                return (Flags.lf_resb() & 0xF) == 0;
            }
            case 26: {
                return (Flags.lf_resw() & 0xF) == 0;
            }
            case 27: {
                return (Flags.lf_resd() & 0xFL) == 0L;
            }
            case 28: {
                return (Flags.lf_resb() & 0xF) == 15;
            }
            case 29: {
                return (Flags.lf_resw() & 0xF) == 15;
            }
            case 30: {
                return (Flags.lf_resd() & 0xFL) == 15L;
            }
            case 55: {
                return (Flags.lf_var1b() & 0xF) != 0;
            }
            case 56: {
                return (Flags.lf_var1w() & 0xF) != 0;
            }
            case 57: {
                return (Flags.lf_var1d() & 0xFL) != 0L;
            }
            case 34: 
            case 37: 
            case 40: {
                return (Flags.lf_var2b() & 0x1F) != 0;
            }
            case 35: 
            case 38: 
            case 41: {
                return (Flags.lf_var2w() & 0x1F) != 0;
            }
            case 36: 
            case 39: 
            case 42: {
                return (Flags.lf_var2d() & 0x1FL) != 0L;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return false;
            }
        }
        Log.log(8, 2, "get_AF Unknown " + Flags.lflags.type);
        return false;
    }

    public static boolean get_ZF() {
        switch (Flags.lflags.type) {
            case 0: {
                return CPU_Regs.GETFLAG(64) != 0;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 55: {
                return Flags.lf_resb() == 0;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 56: 
            case 58: 
            case 60: {
                return Flags.lf_resw() == 0;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 57: 
            case 59: 
            case 61: {
                return Flags.lf_resd() == 0L;
            }
            case 62: 
            case 63: {
                return false;
            }
        }
        Log.log(8, 2, "get_ZF Unknown " + Flags.lflags.type);
        return false;
    }

    public static boolean get_SF() {
        switch (Flags.lflags.type) {
            case 0: {
                return CPU_Regs.GETFLAG(128) != 0;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 55: {
                return (Flags.lf_resb() & 0x80) != 0;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 56: 
            case 58: 
            case 60: {
                return (Flags.lf_resw() & 0x8000) != 0;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 57: 
            case 59: 
            case 61: {
                return (Flags.lf_resd() & 0x80000000L) != 0L;
            }
            case 62: 
            case 63: {
                return false;
            }
        }
        Log.log(8, 2, "get_SF Unkown " + Flags.lflags.type);
        return false;
    }

    public static boolean get_OF() {
        switch (Flags.lflags.type) {
            case 0: 
            case 62: {
                return CPU_Regs.GETFLAG(2048) != 0;
            }
            case 1: 
            case 7: {
                return ((Flags.lf_var1b() ^ Flags.lf_var2b() ^ 0x80) & (Flags.lf_resb() ^ Flags.lf_var2b()) & 0x80) != 0;
            }
            case 2: 
            case 8: {
                return ((Flags.lf_var1w() ^ Flags.lf_var2w() ^ 0x8000) & (Flags.lf_resw() ^ Flags.lf_var2w()) & 0x8000) != 0;
            }
            case 3: 
            case 9: {
                return ((Flags.lf_var1d() ^ Flags.lf_var2d() ^ 0x80000000L) & (Flags.lf_resd() ^ Flags.lf_var2d()) & 0x80000000L) != 0L;
            }
            case 10: 
            case 16: 
            case 22: {
                return ((Flags.lf_var1b() ^ Flags.lf_var2b()) & (Flags.lf_var1b() ^ Flags.lf_resb()) & 0x80) != 0;
            }
            case 11: 
            case 17: 
            case 23: {
                return ((Flags.lf_var1w() ^ Flags.lf_var2w()) & (Flags.lf_var1w() ^ Flags.lf_resw()) & 0x8000) != 0;
            }
            case 12: 
            case 18: 
            case 24: {
                return ((Flags.lf_var1d() ^ Flags.lf_var2d()) & (Flags.lf_var1d() ^ Flags.lf_resd()) & 0x80000000L) != 0L;
            }
            case 25: {
                return Flags.lf_resb() == 128;
            }
            case 26: {
                return Flags.lf_resw() == 32768;
            }
            case 27: {
                return Flags.lf_resd() == 0x80000000L;
            }
            case 28: {
                return Flags.lf_resb() == 127;
            }
            case 29: {
                return Flags.lf_resw() == Short.MAX_VALUE;
            }
            case 30: {
                return Flags.lf_resd() == Integer.MAX_VALUE;
            }
            case 55: {
                return Flags.lf_var1b() == 128;
            }
            case 56: {
                return Flags.lf_var1w() == 32768;
            }
            case 57: {
                return Flags.lf_var1d() == 0x80000000L;
            }
            case 34: {
                return ((Flags.lf_resb() ^ Flags.lf_var1b()) & 0x80) != 0;
            }
            case 35: 
            case 58: 
            case 60: {
                return ((Flags.lf_resw() ^ Flags.lf_var1w()) & 0x8000) != 0;
            }
            case 36: 
            case 59: 
            case 61: {
                return ((Flags.lf_resd() ^ Flags.lf_var1d()) & 0x80000000L) != 0L;
            }
            case 37: {
                if ((Flags.lf_var2b() & 0x1F) == 1) {
                    return Flags.lf_var1b() > 128;
                }
                return false;
            }
            case 38: {
                if ((Flags.lf_var2b() & 0x1F) == 1) {
                    return Flags.lf_var1w() > 32768;
                }
                return false;
            }
            case 39: {
                if ((Flags.lf_var2b() & 0x1F) == 1) {
                    return Flags.lf_var1d() > 0x80000000L;
                }
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: {
                return false;
            }
            case 63: {
                return false;
            }
        }
        Log.log(8, 2, "get_OF Unkown " + Flags.lflags.type);
        return false;
    }

    public static boolean get_PF() {
        switch (Flags.lflags.type) {
            case 0: {
                return CPU_Regs.GETFLAG(4) != 0;
            }
        }
        return parity_lookup[Flags.lf_resb()] != 0;
    }

    private static void DOFLAG_PF() {
        CPU_Regs.flags = CPU_Regs.flags & 0xFFFFFFFB | parity_lookup[Flags.lf_resb()];
    }

    private static void DOFLAG_AF() {
        CPU_Regs.flags = CPU_Regs.flags & 0xFFFFFFEF | (Flags.lf_var1b() ^ Flags.lf_var2b() ^ Flags.lf_resb()) & 0x10;
    }

    private static void DOFLAG_ZFb() {
        CPU_Regs.SETFLAGBIT(64, Flags.lf_resb() == 0);
    }

    private static void DOFLAG_ZFw() {
        CPU_Regs.SETFLAGBIT(64, Flags.lf_resw() == 0);
    }

    private static void DOFLAG_ZFd() {
        CPU_Regs.SETFLAGBIT(64, Flags.lf_resd() == 0L);
    }

    private static void DOFLAG_SFb() {
        CPU_Regs.flags = CPU_Regs.flags & 0xFFFFFF7F | Flags.lf_resb() & 0x80;
    }

    private static void DOFLAG_SFw() {
        CPU_Regs.flags = CPU_Regs.flags & 0xFFFFFF7F | (Flags.lf_resw() & 0x8000) >> 8;
    }

    private static void DOFLAG_SFd() {
        CPU_Regs.flags = (int)((long)(CPU_Regs.flags & 0xFFFFFF7F) | (Flags.lf_resd() & 0x80000000L) >>> 24);
    }

    public static boolean TFLG_O() {
        return Flags.get_OF();
    }

    public static boolean TFLG_NO() {
        return !Flags.get_OF();
    }

    public static boolean TFLG_B() {
        return Flags.get_CF();
    }

    public static boolean TFLG_NB() {
        return !Flags.get_CF();
    }

    public static boolean TFLG_Z() {
        return Flags.get_ZF();
    }

    public static boolean TFLG_NZ() {
        return !Flags.get_ZF();
    }

    public static boolean TFLG_BE() {
        return Flags.get_CF() || Flags.get_ZF();
    }

    public static boolean TFLG_NBE() {
        return !Flags.get_CF() && !Flags.get_ZF();
    }

    public static boolean TFLG_S() {
        return Flags.get_SF();
    }

    public static boolean TFLG_NS() {
        return !Flags.get_SF();
    }

    public static boolean TFLG_P() {
        return Flags.get_PF();
    }

    public static boolean TFLG_NP() {
        return !Flags.get_PF();
    }

    public static boolean TFLG_L() {
        return Flags.get_SF() != Flags.get_OF();
    }

    public static boolean TFLG_NL() {
        return Flags.get_SF() == Flags.get_OF();
    }

    public static boolean TFLG_LE() {
        return Flags.get_ZF() || Flags.get_SF() != Flags.get_OF();
    }

    public static boolean TFLG_NLE() {
        return !Flags.get_ZF() && Flags.get_SF() == Flags.get_OF();
    }

    private static void SET_FLAG(int flag, boolean set) {
        CPU_Regs.SETFLAGBIT(flag, set);
    }

    public static int FillFlags() {
        switch (Flags.lflags.type) {
            case 0: {
                break;
            }
            case 1: {
                Flags.SET_FLAG(1, Flags.lf_resb() < Flags.lf_var1b());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, ((Flags.lf_var1b() ^ Flags.lf_var2b() ^ 0x80) & (Flags.lf_resb() ^ Flags.lf_var1b()) & 0x80) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 2: {
                Flags.SET_FLAG(1, Flags.lf_resw() < Flags.lf_var1w());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_var1w() ^ Flags.lf_var2w() ^ 0x8000) & (Flags.lf_resw() ^ Flags.lf_var1w()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 3: {
                Flags.SET_FLAG(1, Flags.lf_resd() < Flags.lf_var1d());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_var1d() ^ Flags.lf_var2d() ^ 0x80000000L) & (Flags.lf_resd() ^ Flags.lf_var1d()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                break;
            }
            case 7: {
                Flags.SET_FLAG(1, Flags.lf_resb() < Flags.lf_var1b() || Flags.lflags.oldcf && Flags.lf_resb() == Flags.lf_var1b());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, ((Flags.lf_var1b() ^ Flags.lf_var2b() ^ 0x80) & (Flags.lf_resb() ^ Flags.lf_var1b()) & 0x80) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 8: {
                Flags.SET_FLAG(1, Flags.lf_resw() < Flags.lf_var1w() || Flags.lflags.oldcf && Flags.lf_resw() == Flags.lf_var1w());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_var1w() ^ Flags.lf_var2w() ^ 0x8000) & (Flags.lf_resw() ^ Flags.lf_var1w()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 9: {
                Flags.SET_FLAG(1, Flags.lf_resd() < Flags.lf_var1d() || Flags.lflags.oldcf && Flags.lf_resd() == Flags.lf_var1d());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_var1d() ^ Flags.lf_var2d() ^ 0x80000000L) & (Flags.lf_resd() ^ Flags.lf_var1d()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                break;
            }
            case 10: {
                Flags.SET_FLAG(1, Flags.lf_var1b() < Flags.lf_resb() || Flags.lflags.oldcf && Flags.lf_var2b() == 255);
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, ((Flags.lf_var1b() ^ Flags.lf_var2b()) & (Flags.lf_var1b() ^ Flags.lf_resb()) & 0x80) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 11: {
                Flags.SET_FLAG(1, Flags.lf_var1w() < Flags.lf_resw() || Flags.lflags.oldcf && Flags.lf_var2w() == 65535);
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_var1w() ^ Flags.lf_var2w()) & (Flags.lf_var1w() ^ Flags.lf_resw()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 12: {
                Flags.SET_FLAG(1, Flags.lf_var1d() < Flags.lf_resd() || Flags.lflags.oldcf && Flags.lf_var2d() == 0xFFFFFFFFL);
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_var1d() ^ Flags.lf_var2d()) & (Flags.lf_var1d() ^ Flags.lf_resd()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                break;
            }
            case 16: 
            case 22: {
                Flags.SET_FLAG(1, Flags.lf_var1b() < Flags.lf_var2b());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, ((Flags.lf_var1b() ^ Flags.lf_var2b()) & (Flags.lf_var1b() ^ Flags.lf_resb()) & 0x80) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 17: 
            case 23: {
                Flags.SET_FLAG(1, Flags.lf_var1w() < Flags.lf_var2w());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_var1w() ^ Flags.lf_var2w()) & (Flags.lf_var1w() ^ Flags.lf_resw()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 18: 
            case 24: {
                Flags.SET_FLAG(1, Flags.lf_var1d() < Flags.lf_var2d());
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_var1d() ^ Flags.lf_var2d()) & (Flags.lf_var1d() ^ Flags.lf_resd()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                break;
            }
            case 4: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 5: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 6: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 13: 
            case 31: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 14: 
            case 32: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 15: 
            case 33: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 19: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 20: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 21: {
                Flags.SET_FLAG(1, false);
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                break;
            }
            case 34: {
                if (Flags.lf_var2b() > 8) {
                    Flags.SET_FLAG(1, false);
                } else {
                    Flags.SET_FLAG(1, (Flags.lf_var1b() >> 8 - Flags.lf_var2b() & 1) != 0);
                }
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, ((Flags.lf_resb() ^ Flags.lf_var1b()) & 0x80) != 0);
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2b() & 0x1F) != 0);
                break;
            }
            case 35: {
                if (Flags.lf_var2b() > 16) {
                    Flags.SET_FLAG(1, false);
                } else {
                    Flags.SET_FLAG(1, (Flags.lf_var1w() >> 16 - Flags.lf_var2b() & 1) != 0);
                }
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_resw() ^ Flags.lf_var1w()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2w() & 0x1F) != 0);
                break;
            }
            case 36: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> 32 - Flags.lf_var2b() & 1L) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_resd() ^ Flags.lf_var1d()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2d() & 0x1FL) != 0L);
                break;
            }
            case 58: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> 32 - Flags.lf_var2b() & 1L) != 0L);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_resw() ^ Flags.lf_var1w()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 59: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> 32 - Flags.lf_var2b() & 1L) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_resd() ^ Flags.lf_var1d()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                break;
            }
            case 37: {
                Flags.SET_FLAG(1, (Flags.lf_var1b() >> Flags.lf_var2b() - 1 & 1) != 0);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                if ((Flags.lf_var2b() & 0x1F) == 1) {
                    Flags.SET_FLAG(2048, Flags.lf_var1b() >= 128);
                } else {
                    Flags.SET_FLAG(2048, false);
                }
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2b() & 0x1F) != 0);
                break;
            }
            case 38: {
                Flags.SET_FLAG(1, (Flags.lf_var1w() >> Flags.lf_var2b() - 1 & 1) != 0);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                if ((Flags.lf_var2w() & 0x1F) == 1) {
                    Flags.SET_FLAG(2048, Flags.lf_var1w() >= 32768);
                } else {
                    Flags.SET_FLAG(2048, false);
                }
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2w() & 0x1F) != 0);
                break;
            }
            case 39: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> Flags.lf_var2b() - 1 & 1L) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                if ((Flags.lf_var2d() & 0x1FL) == 1L) {
                    Flags.SET_FLAG(2048, Flags.lf_var1d() >= 0x80000000L);
                } else {
                    Flags.SET_FLAG(2048, false);
                }
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2d() & 0x1FL) != 0L);
                break;
            }
            case 60: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> Flags.lf_var2b() - 1 & 1L) != 0L);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, ((Flags.lf_resw() ^ Flags.lf_var1w()) & 0x8000) != 0);
                Flags.DOFLAG_PF();
                break;
            }
            case 61: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> Flags.lf_var2b() - 1 & 1L) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, ((Flags.lf_resd() ^ Flags.lf_var1d()) & 0x80000000L) != 0L);
                Flags.DOFLAG_PF();
                break;
            }
            case 40: {
                Flags.SET_FLAG(1, (Flags.lf_var1b() >> Flags.lf_var2b() - 1 & 1) != 0);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2b() & 0x1F) != 0);
                break;
            }
            case 41: {
                Flags.SET_FLAG(1, (Flags.lf_var1w() >> Flags.lf_var2b() - 1 & 1) != 0);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2w() & 0x1F) != 0);
                break;
            }
            case 42: {
                Flags.SET_FLAG(1, (Flags.lf_var1d() >>> Flags.lf_var2b() - 1 & 1L) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, false);
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2d() & 0x1FL) != 0L);
                break;
            }
            case 25: {
                Flags.SET_FLAG(16, (Flags.lf_resb() & 0xF) == 0);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, Flags.lf_resb() == 128);
                Flags.DOFLAG_PF();
                break;
            }
            case 26: {
                Flags.SET_FLAG(16, (Flags.lf_resw() & 0xF) == 0);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, Flags.lf_resw() == 32768);
                Flags.DOFLAG_PF();
                break;
            }
            case 27: {
                Flags.SET_FLAG(16, (Flags.lf_resd() & 0xFL) == 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, Flags.lf_resd() == 0x80000000L);
                Flags.DOFLAG_PF();
                break;
            }
            case 28: {
                Flags.SET_FLAG(16, (Flags.lf_resb() & 0xF) == 15);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, Flags.lf_resb() == 127);
                Flags.DOFLAG_PF();
                break;
            }
            case 29: {
                Flags.SET_FLAG(16, (Flags.lf_resw() & 0xF) == 15);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, Flags.lf_resw() == Short.MAX_VALUE);
                Flags.DOFLAG_PF();
                break;
            }
            case 30: {
                Flags.SET_FLAG(16, (Flags.lf_resd() & 0xFL) == 15L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, Flags.lf_resd() == Integer.MAX_VALUE);
                Flags.DOFLAG_PF();
                break;
            }
            case 55: {
                Flags.SET_FLAG(1, Flags.lf_var1b() != 0);
                Flags.SET_FLAG(16, (Flags.lf_resb() & 0xF) != 0);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.SET_FLAG(2048, Flags.lf_var1b() == 128);
                Flags.DOFLAG_PF();
                break;
            }
            case 56: {
                Flags.SET_FLAG(1, Flags.lf_var1w() != 0);
                Flags.SET_FLAG(16, (Flags.lf_resw() & 0xF) != 0);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.SET_FLAG(2048, Flags.lf_var1w() == 32768);
                Flags.DOFLAG_PF();
                break;
            }
            case 57: {
                Flags.SET_FLAG(1, Flags.lf_var1d() != 0L);
                Flags.SET_FLAG(16, (Flags.lf_resd() & 0xFL) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.SET_FLAG(2048, Flags.lf_var1d() == 0x80000000L);
                Flags.DOFLAG_PF();
                break;
            }
            case 62: 
            case 63: {
                break;
            }
            default: {
                Log.log(8, 2, "Unhandled flag type " + Flags.lflags.type);
                return 0;
            }
        }
        Flags.lflags.type = 0;
        return CPU_Regs.flags;
    }

    public static void FillFlagsNoCFOF() {
        switch (Flags.lflags.type) {
            case 0: {
                return;
            }
            case 1: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 2: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 3: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 7: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 8: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 9: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 10: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 11: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 12: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 16: 
            case 22: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 17: 
            case 23: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 18: 
            case 24: {
                Flags.DOFLAG_AF();
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 4: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 5: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 6: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 13: 
            case 31: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 14: 
            case 32: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 15: 
            case 33: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 19: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 20: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 21: {
                Flags.SET_FLAG(16, false);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 34: {
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2b() & 0x1F) != 0);
                break;
            }
            case 35: {
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2w() & 0x1F) != 0);
                break;
            }
            case 36: {
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2d() & 0x1FL) != 0L);
                break;
            }
            case 58: {
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 59: {
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 37: {
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2b() & 0x1F) != 0);
                break;
            }
            case 38: {
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2w() & 0x1F) != 0);
                break;
            }
            case 39: {
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2d() & 0x1FL) != 0L);
                break;
            }
            case 60: {
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 61: {
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 40: {
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2b() & 0x1F) != 0);
                break;
            }
            case 41: {
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2w() & 0x1F) != 0);
                break;
            }
            case 42: {
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                Flags.SET_FLAG(16, (Flags.lf_var2d() & 0x1FL) != 0L);
                break;
            }
            case 25: {
                Flags.SET_FLAG(16, (Flags.lf_resb() & 0xF) == 0);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 26: {
                Flags.SET_FLAG(16, (Flags.lf_resw() & 0xF) == 0);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 27: {
                Flags.SET_FLAG(16, (Flags.lf_resd() & 0xFL) == 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 28: {
                Flags.SET_FLAG(16, (Flags.lf_resb() & 0xF) == 15);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 29: {
                Flags.SET_FLAG(16, (Flags.lf_resw() & 0xF) == 15);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 30: {
                Flags.SET_FLAG(16, (Flags.lf_resd() & 0xFL) == 15L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 55: {
                Flags.SET_FLAG(16, (Flags.lf_resb() & 0xF) != 0);
                Flags.DOFLAG_ZFb();
                Flags.DOFLAG_SFb();
                Flags.DOFLAG_PF();
                break;
            }
            case 56: {
                Flags.SET_FLAG(16, (Flags.lf_resw() & 0xF) != 0);
                Flags.DOFLAG_ZFw();
                Flags.DOFLAG_SFw();
                Flags.DOFLAG_PF();
                break;
            }
            case 57: {
                Flags.SET_FLAG(16, (Flags.lf_resd() & 0xFL) != 0L);
                Flags.DOFLAG_ZFd();
                Flags.DOFLAG_SFd();
                Flags.DOFLAG_PF();
                break;
            }
            case 62: 
            case 63: {
                break;
            }
            default: {
                Log.log(8, 2, "Unhandled flag type " + Flags.lflags.type);
            }
        }
        Flags.lflags.type = 0;
    }

    public static void DestroyConditionFlags() {
        Flags.lflags.type = 0;
    }
}

