/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.cpu.CPU_Regs;
import jdos.cpu.Flags;
import jdos.cpu.Table_ea;
import jdos.cpu.core_dynamic.Op;
import jdos.cpu.core_normal.Prefix_helpers;
import jdos.util.LongHelper;
import jdos.util.OverflowException;

public class Instructions
extends Table_ea {
    public static short ADDB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l + op2 & 0xFF);
        Instructions.lflags.type = 1;
        return Instructions.lf_resb();
    }

    public static short ADCB(short op2, short l) {
        Instructions.lflags.oldcf = Instructions.get_CF();
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l + op2 + (Instructions.lflags.oldcf ? 1 : 0) & 0xFF);
        Instructions.lflags.type = 7;
        return Instructions.lf_resb();
    }

    public static short SBBB(short op2, short l) {
        Instructions.lflags.oldcf = Instructions.get_CF();
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l - (op2 + (Instructions.lflags.oldcf ? (short)1 : 0)) & 0xFF);
        Instructions.lflags.type = 10;
        return Instructions.lf_resb();
    }

    public static short SUBB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l - op2 & 0xFF);
        Instructions.lflags.type = 16;
        return Instructions.lf_resb();
    }

    public static short ORB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd((l | op2) & 0xFF);
        Instructions.lflags.type = 4;
        return Instructions.lf_resb();
    }

    public static short XORB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd((l ^ op2) & 0xFF);
        Instructions.lflags.type = 19;
        return Instructions.lf_resb();
    }

    public static short ANDB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l & op2 & 0xFF);
        Instructions.lflags.type = 13;
        return Instructions.lf_resb();
    }

    public static void CMPB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l - op2 & 0xFF);
        Instructions.lflags.type = 22;
    }

    public static void TESTB(short op2, short l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l & op2 & 0xFF);
        Instructions.lflags.type = 31;
    }

    public static int ADDW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l + op2 & 0xFFFF);
        Instructions.lflags.type = 2;
        return Instructions.lf_resw();
    }

    public static int ADCW(int op2, int l) {
        Instructions.lflags.oldcf = Instructions.get_CF();
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l + op2 + (Instructions.lflags.oldcf ? 1 : 0) & 0xFFFF);
        Instructions.lflags.type = 8;
        return Instructions.lf_resw();
    }

    public static int SBBW(int op2, int l) {
        Instructions.lflags.oldcf = Instructions.get_CF();
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l - (op2 + (Instructions.lflags.oldcf ? 1 : 0)) & 0xFFFF);
        Instructions.lflags.type = 11;
        return Instructions.lf_resw();
    }

    public static int SUBW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l - op2 & 0xFFFF);
        Instructions.lflags.type = 17;
        return Instructions.lf_resw();
    }

    public static int ORW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd((l | op2) & 0xFFFF);
        Instructions.lflags.type = 5;
        return Instructions.lf_resw();
    }

    public static int XORW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd((l ^ op2) & 0xFFFF);
        Instructions.lflags.type = 20;
        return Instructions.lf_resw();
    }

    public static int ANDW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l & op2 & 0xFFFF);
        Instructions.lflags.type = 14;
        return Instructions.lf_resw();
    }

    public static void CMPW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l - op2 & 0xFFFF);
        Instructions.lflags.type = 23;
    }

    public static void TESTW(int op2, int l) {
        Instructions.lf_var1d(l);
        Instructions.lf_var2d(op2);
        Instructions.lf_resd(l & op2 & 0xFFFF);
        Instructions.lflags.type = 32;
    }

    public static int ADDD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l + op2;
        Instructions.lflags.type = 3;
        return Instructions.lflags.res;
    }

    public static int ADCD(int op2, int l) {
        Instructions.lflags.oldcf = Instructions.get_CF();
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l + op2 + (Instructions.lflags.oldcf ? 1 : 0);
        Instructions.lflags.type = 9;
        return Instructions.lflags.res;
    }

    public static int SBBD(int op2, int l) {
        Instructions.lflags.oldcf = Instructions.get_CF();
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l - (op2 + (Instructions.lflags.oldcf ? 1 : 0));
        Instructions.lflags.type = 12;
        return Instructions.lflags.res;
    }

    public static int SUBD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l - op2;
        Instructions.lflags.type = 18;
        return Instructions.lflags.res;
    }

    public static int ORD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l | op2;
        Instructions.lflags.type = 6;
        return Instructions.lflags.res;
    }

    public static int XORD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l ^ op2;
        Instructions.lflags.type = 21;
        return Instructions.lflags.res;
    }

    public static int ANDD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l & op2;
        Instructions.lflags.type = 15;
        return Instructions.lflags.res;
    }

    public static void CMPD(int op2, int op1) {
        Instructions.lflags.var1 = op1;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = op1 - op2;
        Instructions.lflags.type = 24;
    }

    public static void TESTD(int op2, int op1) {
        Instructions.lflags.var1 = op1;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = op1 & op2;
        Instructions.lflags.type = 33;
    }

    public static short INCB(short l) {
        Instructions.LoadCF();
        Instructions.lf_var1b(l);
        Instructions.lf_resb(Instructions.lf_var1b() + 1);
        Instructions.lflags.type = 25;
        return Instructions.lf_resb();
    }

    public static int INCW(int l) {
        Instructions.LoadCF();
        Instructions.lf_var1w(l);
        Instructions.lf_resw(Instructions.lf_var1w() + 1);
        Instructions.lflags.type = 26;
        return Instructions.lf_resw();
    }

    public static int INCD(int l) {
        Instructions.LoadCF();
        Instructions.lflags.var1 = l;
        Instructions.lflags.res = l + 1;
        Instructions.lflags.type = 27;
        return Instructions.lflags.res;
    }

    public static short DECB(short l) {
        Instructions.LoadCF();
        Instructions.lf_var1d(l);
        Instructions.lf_resd(l - 1 & 0xFF);
        Instructions.lflags.type = 28;
        return Instructions.lf_resb();
    }

    public static int DECW(int l) {
        Instructions.LoadCF();
        Instructions.lf_var1d(l);
        Instructions.lf_resd(l - 1 & 0xFFFF);
        Instructions.lflags.type = 29;
        return Instructions.lf_resw();
    }

    public static int DECD(int l) {
        Instructions.LoadCF();
        Instructions.lflags.var1 = l;
        Instructions.lflags.res = l - 1;
        Instructions.lflags.type = 30;
        return Instructions.lflags.res;
    }

    public static boolean valid_ROLB(int op1, int op2) {
        if ((op2 & 7) == 0) {
            if ((op2 & 0x18) != 0) {
                Instructions.FillFlagsNoCFOF();
                CPU_Regs.SETFLAGBIT(1, (op1 & 1) != 0);
                CPU_Regs.SETFLAGBIT(2048, (op1 & 1 ^ op1 >>> 7) != 0);
            }
            return false;
        }
        return true;
    }

    public static short do_ROLB(int op2, short l) {
        Instructions.FillFlagsNoCFOF();
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2 & 7);
        Instructions.lf_resb(Instructions.lf_var1b() << Instructions.lf_var2b() | Instructions.lf_var1b() >> 8 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_resb() & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, (Instructions.lf_resb() & 1 ^ Instructions.lf_resb() >> 7) != 0);
        return Instructions.lf_resb();
    }

    public static void ROLB(int op1, short op2, loadb l, saveb s) {
        if (Instructions.valid_ROLB(op1, op2)) {
            s.call(Instructions.do_ROLB(op2, l.call()));
        }
    }

    public static boolean valid_ROLW(int op1, int op2) {
        if ((op2 & 0xF) == 0) {
            if ((op2 & 0x10) != 0) {
                Instructions.FillFlagsNoCFOF();
                CPU_Regs.SETFLAGBIT(1, (op1 & 1) != 0);
                CPU_Regs.SETFLAGBIT(2048, (op1 & 1 ^ op1 >>> 15) != 0);
            }
            return false;
        }
        return true;
    }

    public static int do_ROLW(int op2, int l) {
        Instructions.FillFlagsNoCFOF();
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2 & 0xF);
        Instructions.lf_resw(Instructions.lf_var1w() << Instructions.lf_var2b() | Instructions.lf_var1w() >> 16 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_resw() & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, (Instructions.lf_resw() & 1 ^ Instructions.lf_resw() >> 15) != 0);
        return Instructions.lf_resw();
    }

    public static void ROLW(int op1, int op2, loadw l, savew s) {
        if (Instructions.valid_ROLW(op1, op2)) {
            s.call(Instructions.do_ROLW(op2, l.call()));
        }
    }

    public static int ROLD(int op2, int l) {
        Instructions.FillFlagsNoCFOF();
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l << op2 | l >>> 32 - op2;
        CPU_Regs.SETFLAGBIT(1, (Instructions.lflags.res & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, (Instructions.lflags.res & 1 ^ Instructions.lflags.res >>> 31) != 0);
        return Instructions.lflags.res;
    }

    public static boolean valid_RORB(int op1, int op2) {
        if ((op2 & 7) == 0) {
            if ((op2 & 0x18) != 0) {
                Instructions.FillFlagsNoCFOF();
                CPU_Regs.SETFLAGBIT(1, op1 >> 7 != 0);
                CPU_Regs.SETFLAGBIT(2048, (op1 >> 7 ^ op1 >>> 6 & 1) != 0);
            }
            return false;
        }
        return true;
    }

    public static short do_RORB(int op2, short l) {
        Instructions.FillFlagsNoCFOF();
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2 & 7);
        Instructions.lf_resb(Instructions.lf_var1b() >> Instructions.lf_var2b() | Instructions.lf_var1b() << 8 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_resb() & 0x80) != 0);
        CPU_Regs.SETFLAGBIT(2048, ((Instructions.lf_resb() ^ Instructions.lf_resb() << 1) & 0x80) != 0);
        return Instructions.lf_resb();
    }

    public static void RORB(int op1, short op2, loadb l, saveb s) {
        if (Instructions.valid_RORB(op1, op2)) {
            s.call(Instructions.do_RORB(op2, l.call()));
        }
    }

    public static boolean valid_RORW(int op1, int op2) {
        if ((op2 & 0xF) == 0) {
            if ((op2 & 0x10) != 0) {
                Instructions.FillFlagsNoCFOF();
                CPU_Regs.SETFLAGBIT(1, op1 >> 15 != 0);
                CPU_Regs.SETFLAGBIT(2048, (op1 >> 15 ^ op1 >>> 14 & 1) != 0);
            }
            return false;
        }
        return true;
    }

    public static int do_RORW(int op2, int l) {
        Instructions.FillFlagsNoCFOF();
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2 & 0xF);
        Instructions.lf_resw(Instructions.lf_var1w() >> Instructions.lf_var2b() | Instructions.lf_var1w() << 16 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_resw() & 0x8000) != 0);
        CPU_Regs.SETFLAGBIT(2048, ((Instructions.lf_resw() ^ Instructions.lf_resw() << 1) & 0x8000) != 0);
        return Instructions.lf_resw();
    }

    public static void RORW(int op1, int op2, loadw l, savew s) {
        if (Instructions.valid_RORW(op1, op2)) {
            s.call(Instructions.do_RORW(op2, l.call()));
        }
    }

    public static int RORD(int op2, int l) {
        Instructions.FillFlagsNoCFOF();
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l >>> op2 | l << 32 - op2;
        CPU_Regs.SETFLAGBIT(1, (Instructions.lflags.res & Integer.MIN_VALUE) != 0);
        CPU_Regs.SETFLAGBIT(2048, ((Instructions.lflags.res ^ Instructions.lflags.res << 1) & Integer.MIN_VALUE) != 0);
        return Instructions.lflags.res;
    }

    public static boolean valid_RCLB(int op2) {
        return op2 % 9 != 0;
    }

    public static short do_RCLB(int op2, short l) {
        int cf = Instructions.FillFlags() & 1;
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2 % 9);
        Instructions.lf_resb(Instructions.lf_var1b() << Instructions.lf_var2b() | cf << Instructions.lf_var2b() - 1 | Instructions.lf_var1b() >> 9 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_var1b() >> 8 - Instructions.lf_var2b() & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, (CPU_Regs.flags & 1 ^ Instructions.lf_resb() >> 7) != 0);
        return Instructions.lf_resb();
    }

    public static void RCLB(short op2, loadb l, saveb s) {
        if (Instructions.valid_RCLB(op2)) {
            s.call(Instructions.do_RCLB(op2, l.call()));
        }
    }

    public static boolean valid_RCLW(int op2) {
        return op2 % 17 != 0;
    }

    public static int do_RCLW(int op2, int l) {
        int cf = Instructions.FillFlags() & 1;
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2 % 17);
        Instructions.lf_resw(Instructions.lf_var1w() << Instructions.lf_var2b() | cf << Instructions.lf_var2b() - 1 | Instructions.lf_var1w() >> 17 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_var1w() >> 16 - Instructions.lf_var2b() & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, (CPU_Regs.flags & 1 ^ Instructions.lf_resw() >> 15) != 0);
        return Instructions.lf_resw();
    }

    public static void RCLW(int op2, loadw l, savew s) {
        if (Instructions.valid_RCLW(op2)) {
            s.call(Instructions.do_RCLW(op2, l.call()));
        }
    }

    public static int RCLD(int op2, int l) {
        int cf = Instructions.FillFlags() & 1;
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = op2 == 1 ? l << 1 | cf : l << op2 | cf << op2 - 1 | l >>> 33 - op2;
        CPU_Regs.SETFLAGBIT(1, (l >>> 32 - op2 & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, (CPU_Regs.flags & 1 ^ Instructions.lflags.res >>> 31) != 0);
        return Instructions.lflags.res;
    }

    public static boolean valid_RCRB(int op2) {
        return op2 % 9 != 0;
    }

    public static short do_RCRB(int op2, short l) {
        int cf = Instructions.FillFlags() & 1;
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2 % 9);
        Instructions.lf_resb(Instructions.lf_var1b() >> Instructions.lf_var2b() | cf << 8 - Instructions.lf_var2b() | Instructions.lf_var1b() << 9 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_var1b() >> Instructions.lf_var2b() - 1 & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, ((Instructions.lf_resb() ^ Instructions.lf_resb() << 1) & 0x80) != 0);
        return Instructions.lf_resb();
    }

    public static void RCRB(short op2, loadb l, saveb s) {
        if (Instructions.valid_RCRB(op2)) {
            s.call(Instructions.do_RCRB(op2, l.call()));
        }
    }

    public static boolean valid_RCRW(int op2) {
        return op2 % 17 != 0;
    }

    public static int do_RCRW(int op2, int l) {
        int cf = Instructions.FillFlags() & 1;
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2 % 17);
        Instructions.lf_resw(Instructions.lf_var1w() >> Instructions.lf_var2b() | cf << 16 - Instructions.lf_var2b() | Instructions.lf_var1w() << 17 - Instructions.lf_var2b());
        CPU_Regs.SETFLAGBIT(1, (Instructions.lf_var1w() >> Instructions.lf_var2b() - 1 & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, ((Instructions.lf_resw() ^ Instructions.lf_resw() << 1) & 0x8000) != 0);
        return Instructions.lf_resw();
    }

    public static void RCRW(int op2, loadw l, savew s) {
        if (Instructions.valid_RCRW(op2)) {
            s.call(Instructions.do_RCRW(op2, l.call()));
        }
    }

    public static int RCRD(int op2, int l) {
        int cf = Instructions.FillFlags() & 1;
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = op2 == 1 ? l >>> 1 | cf << 31 : l >>> op2 | cf << 32 - op2 | l << 33 - op2;
        CPU_Regs.SETFLAGBIT(1, (l >> op2 - 1 & 1) != 0);
        CPU_Regs.SETFLAGBIT(2048, ((Instructions.lflags.res ^ Instructions.lflags.res << 1) & Integer.MIN_VALUE) != 0);
        return Instructions.lflags.res;
    }

    public static boolean valid_SHLB(int op2) {
        return op2 != 0;
    }

    public static short do_SHLB(int op2, short l) {
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2);
        Instructions.lf_resb(Instructions.lf_var1b() << Instructions.lf_var2b());
        Instructions.lflags.type = 34;
        return Instructions.lf_resb();
    }

    public static void SHLB(short op2, loadb l, saveb s) {
        if (Instructions.valid_SHLB(op2)) {
            s.call(Instructions.do_SHLB(op2, l.call()));
        }
    }

    public static boolean valid_SHLW(int op2) {
        return op2 != 0;
    }

    public static int do_SHLW(int op2, int l) {
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2);
        Instructions.lf_resw(Instructions.lf_var1w() << Instructions.lf_var2b());
        Instructions.lflags.type = 35;
        return Instructions.lf_resw();
    }

    public static void SHLW(int op2, loadw l, savew s) {
        if (Instructions.valid_SHLW(op2)) {
            s.call(Instructions.do_SHLW(op2, l.call()));
        }
    }

    public static int SHLD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l << op2;
        Instructions.lflags.type = 36;
        return Instructions.lflags.res;
    }

    public static boolean valid_SHRB(int op2) {
        return op2 != 0;
    }

    public static short do_SHRB(int op2, short l) {
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2);
        Instructions.lf_resb(Instructions.lf_var1b() >> Instructions.lf_var2b());
        Instructions.lflags.type = 37;
        return Instructions.lf_resb();
    }

    public static void SHRB(short op2, loadb l, saveb s) {
        if (Instructions.valid_SHRB(op2)) {
            s.call(Instructions.do_SHRB(op2, l.call()));
        }
    }

    public static boolean valid_SHRW(int op2) {
        return op2 != 0;
    }

    public static int do_SHRW(int op2, int l) {
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2);
        Instructions.lf_resw(Instructions.lf_var1w() >> Instructions.lf_var2b());
        Instructions.lflags.type = 38;
        return Instructions.lf_resw();
    }

    public static void SHRW(int op2, loadw l, savew s) {
        if (Instructions.valid_SHRW(op2)) {
            s.call(Instructions.do_SHRW(op2, l.call()));
        }
    }

    public static int SHRD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l >>> op2;
        Instructions.lflags.type = 39;
        return Instructions.lflags.res;
    }

    public static boolean valid_SARB(int op2) {
        return op2 != 0;
    }

    public static short do_SARB(int op2, short l) {
        Instructions.lf_var1b(l);
        Instructions.lf_var2b(op2);
        if (Instructions.lf_var2b() > 8) {
            Instructions.lf_var2b(8);
        }
        if ((Instructions.lf_var1b() & 0x80) != 0) {
            Instructions.lf_resb(Instructions.lf_var1b() >> Instructions.lf_var2b() | 255 << 8 - Instructions.lf_var2b());
        } else {
            Instructions.lf_resb(Instructions.lf_var1b() >> Instructions.lf_var2b());
        }
        Instructions.lflags.type = 40;
        return Instructions.lf_resb();
    }

    public static void SARB(short op2, loadb l, saveb s) {
        if (Instructions.valid_SARB(op2)) {
            s.call(Instructions.do_SARB(op2, l.call()));
        }
    }

    public static boolean valid_SARW(int op2) {
        return op2 != 0;
    }

    public static int do_SARW(int op2, int l) {
        Instructions.lf_var1w(l);
        Instructions.lf_var2b(op2);
        if (Instructions.lf_var2b() > 16) {
            Instructions.lf_var2b(16);
        }
        if ((Instructions.lf_var1w() & 0x8000) != 0) {
            Instructions.lf_resw(Instructions.lf_var1w() >> Instructions.lf_var2b() | 65535 << 16 - Instructions.lf_var2b());
        } else {
            Instructions.lf_resw(Instructions.lf_var1w() >> Instructions.lf_var2b());
        }
        Instructions.lflags.type = 41;
        return Instructions.lf_resw();
    }

    public static void SARW(int op2, loadw l, savew s) {
        if (Instructions.valid_SARW(op2)) {
            s.call(Instructions.do_SARW(op2, l.call()));
        }
    }

    public static int SARD(int op2, int l) {
        Instructions.lflags.var1 = l;
        Instructions.lflags.var2 = op2;
        Instructions.lflags.res = l >> op2;
        Instructions.lflags.type = 42;
        return Instructions.lflags.res;
    }

    public static void DAA() {
        if ((CPU_Regs.reg_eax.low() & 0xF) > 9 || Instructions.get_AF()) {
            if (CPU_Regs.reg_eax.low() > 153 || Instructions.get_CF()) {
                CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() + 96);
                CPU_Regs.SETFLAGBIT(1, true);
            } else {
                CPU_Regs.SETFLAGBIT(1, false);
            }
            CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() + 6);
            CPU_Regs.SETFLAGBIT(16, true);
        } else {
            if (CPU_Regs.reg_eax.low() > 153 || Instructions.get_CF()) {
                CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() + 96);
                CPU_Regs.SETFLAGBIT(1, true);
            } else {
                CPU_Regs.SETFLAGBIT(1, false);
            }
            CPU_Regs.SETFLAGBIT(16, false);
        }
        CPU_Regs.SETFLAGBIT(128, (CPU_Regs.reg_eax.low() & 0x80) != 0);
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
        CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
        Instructions.lflags.type = 0;
    }

    public static void DAS() {
        int osigned = CPU_Regs.reg_eax.low() & 0x80;
        if ((CPU_Regs.reg_eax.low() & 0xF) > 9 || Instructions.get_AF()) {
            if (CPU_Regs.reg_eax.low() > 153 || Instructions.get_CF()) {
                CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() - 96);
                CPU_Regs.SETFLAGBIT(1, true);
            } else {
                CPU_Regs.SETFLAGBIT(1, CPU_Regs.reg_eax.low() <= 5);
            }
            CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() - 6);
            CPU_Regs.SETFLAGBIT(16, true);
        } else {
            if (CPU_Regs.reg_eax.low() > 153 || Instructions.get_CF()) {
                CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() - 96);
                CPU_Regs.SETFLAGBIT(1, true);
            } else {
                CPU_Regs.SETFLAGBIT(1, false);
            }
            CPU_Regs.SETFLAGBIT(16, false);
        }
        CPU_Regs.SETFLAGBIT(2048, osigned != 0 && (CPU_Regs.reg_eax.low() & 0x80) == 0);
        CPU_Regs.SETFLAGBIT(128, (CPU_Regs.reg_eax.low() & 0x80) != 0);
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
        CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
        Instructions.lflags.type = 0;
    }

    public static void AAA() {
        CPU_Regs.SETFLAGBIT(128, CPU_Regs.reg_eax.low() >= 122 && CPU_Regs.reg_eax.low() <= 249);
        if ((CPU_Regs.reg_eax.low() & 0xF) > 9) {
            CPU_Regs.SETFLAGBIT(2048, (CPU_Regs.reg_eax.low() & 0xF0) == 112);
            CPU_Regs.reg_eax.word(CPU_Regs.reg_eax.word() + 262);
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
            CPU_Regs.SETFLAGBIT(16, true);
        } else if (Instructions.get_AF()) {
            CPU_Regs.reg_eax.word(CPU_Regs.reg_eax.word() + 262);
            CPU_Regs.SETFLAGBIT(2048, false);
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(64, false);
            CPU_Regs.SETFLAGBIT(16, true);
        } else {
            CPU_Regs.SETFLAGBIT(2048, false);
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
            CPU_Regs.SETFLAGBIT(16, false);
        }
        CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
        CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() & 0xF);
        Instructions.lflags.type = 0;
    }

    public static void AAS() {
        if ((CPU_Regs.reg_eax.low() & 0xF) > 9) {
            CPU_Regs.SETFLAGBIT(128, CPU_Regs.reg_eax.low() > 133);
            CPU_Regs.reg_eax.word(CPU_Regs.reg_eax.word() - 262);
            CPU_Regs.SETFLAGBIT(2048, false);
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(16, true);
        } else if (Instructions.get_AF()) {
            CPU_Regs.SETFLAGBIT(2048, CPU_Regs.reg_eax.low() >= 128 && CPU_Regs.reg_eax.low() <= 133);
            CPU_Regs.SETFLAGBIT(128, CPU_Regs.reg_eax.low() < 6 || CPU_Regs.reg_eax.low() > 133);
            CPU_Regs.reg_eax.word(CPU_Regs.reg_eax.word() - 262);
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(16, true);
        } else {
            CPU_Regs.SETFLAGBIT(128, CPU_Regs.reg_eax.low() >= 128);
            CPU_Regs.SETFLAGBIT(2048, false);
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(16, false);
        }
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
        CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
        CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() & 0xF);
        Instructions.lflags.type = 0;
    }

    public static void AAM(int op1) {
        if (op1 == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        CPU_Regs.reg_eax.high(CPU_Regs.reg_eax.low() / op1);
        CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() % op1);
        CPU_Regs.SETFLAGBIT(128, (CPU_Regs.reg_eax.low() & 0x80) != 0);
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
        CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
        CPU_Regs.SETFLAGBIT(1, false);
        CPU_Regs.SETFLAGBIT(2048, false);
        CPU_Regs.SETFLAGBIT(16, false);
        Instructions.lflags.type = 0;
    }

    public static int AAMr(Op op, int op1) {
        if (op1 != 0) {
            CPU_Regs.reg_eax.high(CPU_Regs.reg_eax.low() / op1);
            CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() % op1);
            CPU_Regs.SETFLAGBIT(128, (CPU_Regs.reg_eax.low() & 0x80) != 0);
            CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
            CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
            CPU_Regs.SETFLAGBIT(16, false);
            Instructions.lflags.type = 0;
            return 4;
        }
        return op.EXCEPTION(0);
    }

    public static void AAD(int op1) {
        int ax1 = CPU_Regs.reg_eax.high() * op1;
        int ax2 = ax1 + CPU_Regs.reg_eax.low();
        CPU_Regs.reg_eax.low(ax2);
        CPU_Regs.reg_eax.high(0);
        CPU_Regs.SETFLAGBIT(1, false);
        CPU_Regs.SETFLAGBIT(2048, false);
        CPU_Regs.SETFLAGBIT(16, false);
        CPU_Regs.SETFLAGBIT(128, CPU_Regs.reg_eax.low() >= 128);
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
        CPU_Regs.SETFLAGBIT(4, parity_lookup[CPU_Regs.reg_eax.low()] != 0);
        Instructions.lflags.type = 0;
    }

    public static void MULB(short l) {
        CPU_Regs.reg_eax.word(CPU_Regs.reg_eax.low() * l);
        Instructions.FillFlagsNoCFOF();
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.low() == 0);
        if ((CPU_Regs.reg_eax.word() & 0xFF00) != 0) {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        } else {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        }
    }

    public static void MULW(int l) {
        int tempu = CPU_Regs.reg_eax.word() * l;
        CPU_Regs.reg_eax.word(tempu);
        CPU_Regs.reg_edx.word(tempu >>> 16);
        Instructions.FillFlagsNoCFOF();
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.word() == 0);
        if (CPU_Regs.reg_edx.word() != 0) {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        } else {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        }
    }

    public static void MULD(int l) {
        long tempu = ((long)CPU_Regs.reg_eax.dword & 0xFFFFFFFFL) * ((long)l & 0xFFFFFFFFL);
        CPU_Regs.reg_eax.dword = (int)tempu;
        CPU_Regs.reg_edx.dword = (int)(tempu >> 32);
        Instructions.FillFlagsNoCFOF();
        CPU_Regs.SETFLAGBIT(64, CPU_Regs.reg_eax.dword == 0);
        if (CPU_Regs.reg_edx.dword != 0) {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        } else {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        }
    }

    public static void DIVB(short l) {
        short val = l;
        if (val == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        int quo = CPU_Regs.reg_eax.word() / val;
        int rem = CPU_Regs.reg_eax.word() % val;
        int quo8 = quo & 0xFF;
        if (quo > 255) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        CPU_Regs.reg_eax.high(rem);
        CPU_Regs.reg_eax.low(quo8);
    }

    public static void DIVW(int val) {
        if (val == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        long num = (long)CPU_Regs.reg_edx.word() << 16 | (long)CPU_Regs.reg_eax.word();
        long quo = num / (long)val;
        int rem = (int)(num % (long)val);
        int quo16 = (int)(quo & 0xFFFFL);
        if (quo != (long)quo16) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        CPU_Regs.reg_edx.word(rem);
        CPU_Regs.reg_eax.word(quo16);
    }

    public static void DIVD(int val) {
        if (val == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        long num = (long)CPU_Regs.reg_edx.dword << 32 | (long)CPU_Regs.reg_eax.dword & 0xFFFFFFFFL;
        try {
            long quo = LongHelper.divideLongByInt(num, val);
            CPU_Regs.reg_edx.dword = (int)(quo >> 32);
            CPU_Regs.reg_eax.dword = (int)quo;
        }
        catch (OverflowException e) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
    }

    public static void IDIVB(short l) {
        byte val = (byte)l;
        if (val == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        int quo = (short)CPU_Regs.reg_eax.word() / val;
        byte rem = (byte)((short)CPU_Regs.reg_eax.word() % val);
        byte quo8s = (byte)(quo & 0xFF);
        if (quo != (short)quo8s) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        CPU_Regs.reg_eax.high(rem);
        CPU_Regs.reg_eax.low(quo8s);
    }

    public static void IDIVW(int l) {
        short val = (short)l;
        if (val == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        int num = CPU_Regs.reg_edx.word() << 16 | CPU_Regs.reg_eax.word();
        int quo = num / val;
        short rem = (short)(num % val);
        short quo16s = (short)quo;
        if (quo != quo16s) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        CPU_Regs.reg_edx.word(rem);
        CPU_Regs.reg_eax.word(quo16s);
    }

    public static void IDIVD(int val) {
        if (val == 0) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        long num = (long)CPU_Regs.reg_edx.dword << 32 | (long)CPU_Regs.reg_eax.dword & 0xFFFFFFFFL;
        long quo = num / (long)val;
        int rem = (int)(num % (long)val);
        int quo32s = (int)(quo & 0xFFFFFFFFL);
        if (quo != (long)quo32s) {
            Prefix_helpers.EXCEPTION(0);
            throw new Prefix_helpers.ContinueException();
        }
        CPU_Regs.reg_edx.dword = rem;
        CPU_Regs.reg_eax.dword = quo32s;
    }

    public static int DIVBr(Op op, short l) {
        short val = l;
        if (val == 0) {
            return op.EXCEPTION(0);
        }
        int quo = CPU_Regs.reg_eax.word() / val;
        int rem = CPU_Regs.reg_eax.word() % val;
        int quo8 = quo & 0xFF;
        if (quo > 255) {
            return op.EXCEPTION(0);
        }
        CPU_Regs.reg_eax.high(rem);
        CPU_Regs.reg_eax.low(quo8);
        return 4;
    }

    public static int DIVWr(Op op, int val) {
        if (val == 0) {
            return op.EXCEPTION(0);
        }
        long num = (long)CPU_Regs.reg_edx.word() << 16 | (long)CPU_Regs.reg_eax.word();
        long quo = num / (long)val;
        int rem = (int)(num % (long)val);
        int quo16 = (int)(quo & 0xFFFFL);
        if (quo != (long)quo16) {
            return op.EXCEPTION(0);
        }
        CPU_Regs.reg_edx.word(rem);
        CPU_Regs.reg_eax.word(quo16);
        return 4;
    }

    public static int DIVDr(Op op, int val) {
        if (val == 0) {
            return op.EXCEPTION(0);
        }
        long num = (long)CPU_Regs.reg_edx.dword << 32 | (long)CPU_Regs.reg_eax.dword & 0xFFFFFFFFL;
        try {
            long quo = LongHelper.divideLongByInt(num, val);
            CPU_Regs.reg_edx.dword = (int)(quo >> 32);
            CPU_Regs.reg_eax.dword = (int)quo;
        }
        catch (OverflowException e) {
            return op.EXCEPTION(0);
        }
        return 4;
    }

    public static int IDIVBr(Op op, short l) {
        byte val = (byte)l;
        if (val == 0) {
            return op.EXCEPTION(0);
        }
        int quo = (short)CPU_Regs.reg_eax.word() / val;
        byte rem = (byte)((short)CPU_Regs.reg_eax.word() % val);
        byte quo8s = (byte)(quo & 0xFF);
        if (quo != (short)quo8s) {
            return op.EXCEPTION(0);
        }
        CPU_Regs.reg_eax.high(rem);
        CPU_Regs.reg_eax.low(quo8s);
        return 4;
    }

    public static int IDIVWr(Op op, int l) {
        short val = (short)l;
        if (val == 0) {
            return op.EXCEPTION(0);
        }
        int num = CPU_Regs.reg_edx.word() << 16 | CPU_Regs.reg_eax.word();
        int quo = num / val;
        short rem = (short)(num % val);
        short quo16s = (short)quo;
        if (quo != quo16s) {
            return op.EXCEPTION(0);
        }
        CPU_Regs.reg_edx.word(rem);
        CPU_Regs.reg_eax.word(quo16s);
        return 4;
    }

    public static int IDIVDr(Op op, int val) {
        if (val == 0) {
            return op.EXCEPTION(0);
        }
        long num = (long)CPU_Regs.reg_edx.dword << 32 | (long)CPU_Regs.reg_eax.dword & 0xFFFFFFFFL;
        long quo = num / (long)val;
        int rem = (int)(num % (long)val);
        int quo32s = (int)(quo & 0xFFFFFFFFL);
        if (quo != (long)quo32s) {
            return op.EXCEPTION(0);
        }
        CPU_Regs.reg_edx.dword = rem;
        CPU_Regs.reg_eax.dword = quo32s;
        return 4;
    }

    public static void IMULB(short l) {
        CPU_Regs.reg_eax.word((byte)CPU_Regs.reg_eax.low() * (byte)l);
        Instructions.FillFlagsNoCFOF();
        if ((CPU_Regs.reg_eax.word() & 0xFF80) == 65408 || (CPU_Regs.reg_eax.word() & 0xFF80) == 0) {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        } else {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        }
    }

    public static void IMULW(int l) {
        int temps = (short)CPU_Regs.reg_eax.word() * (short)l;
        CPU_Regs.reg_eax.word((short)temps);
        CPU_Regs.reg_edx.word((short)(temps >> 16));
        Instructions.FillFlagsNoCFOF();
        if ((temps & Short.MIN_VALUE) == Short.MIN_VALUE || (temps & Short.MIN_VALUE) == 0) {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        } else {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        }
    }

    public static void IMULD(int l) {
        long temps = (long)CPU_Regs.reg_eax.dword * (long)l;
        CPU_Regs.reg_eax.dword = (int)temps;
        CPU_Regs.reg_edx.dword = (int)(temps >> 32);
        Instructions.FillFlagsNoCFOF();
        if (CPU_Regs.reg_edx.dword == -1 && (CPU_Regs.reg_eax.dword & Integer.MIN_VALUE) != 0) {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        } else if (CPU_Regs.reg_edx.dword == 0 && CPU_Regs.reg_eax.dword > 0) {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        } else {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        }
    }

    public static int DIMULW(int op2, int op3) {
        int res = (short)op2 * (short)op3;
        Instructions.FillFlagsNoCFOF();
        if (res > Short.MIN_VALUE && res < Short.MAX_VALUE) {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        } else {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        }
        return res & 0xFFFF;
    }

    public static int DIMULD(int op2, int op3) {
        long res = (long)op2 * (long)op3;
        Instructions.FillFlagsNoCFOF();
        if (res > Integer.MIN_VALUE && res < Integer.MAX_VALUE) {
            CPU_Regs.SETFLAGBIT(1, false);
            CPU_Regs.SETFLAGBIT(2048, false);
        } else {
            CPU_Regs.SETFLAGBIT(1, true);
            CPU_Regs.SETFLAGBIT(2048, true);
        }
        return (int)res;
    }

    public static int DSHLD(int op2, int val, int l) {
        Instructions.lf_var2b(val);
        Instructions.lflags.var1 = l;
        Instructions.lflags.res = l << val | op2 >>> 32 - val;
        Instructions.lflags.type = 59;
        return Instructions.lflags.res;
    }

    public static int DSHRD(int op2, int val, int l) {
        Instructions.lf_var2b(val);
        Instructions.lflags.var1 = l;
        Instructions.lflags.res = l >>> val | op2 << 32 - val;
        Instructions.lflags.type = 61;
        return Instructions.lflags.res;
    }

    public static boolean valid_DSHLW(int op3) {
        return (op3 & 0x1F) != 0;
    }

    public static int do_DSHLW(int op2, int op3, int l) {
        int val = op3 & 0x1F;
        Instructions.lf_var2b(val);
        Instructions.lflags.var1 = l << 16 | op2;
        long tempd = (long)Instructions.lflags.var1 << Instructions.lf_var2b();
        if (Instructions.lf_var2b() > 16) {
            tempd |= (long)(op2 << Instructions.lf_var2b() - 16);
        }
        Instructions.lf_resw((int)(tempd >>> 16));
        Instructions.lflags.type = 58;
        return Instructions.lf_resw();
    }

    public static void DSHLW(int op2, int op3, loadw l, savew s) {
        if (Instructions.valid_DSHLW(op3)) {
            s.call(Instructions.do_DSHLW(op2, op3, l.call()));
        }
    }

    public static boolean valid_DSHRW(int op3) {
        return (op3 & 0x1F) != 0;
    }

    public static int do_DSHRW(int op2, int op3, int l) {
        short val = (short)(op3 & 0x1F);
        Instructions.lf_var2b(val);
        Instructions.lflags.var1 = op2 << 16 | l;
        long tempd = Instructions.lflags.var1 >>> Instructions.lf_var2b();
        if (Instructions.lf_var2b() > 16) {
            tempd |= (long)(op2 << 32 - Instructions.lf_var2b());
        }
        Instructions.lf_resw((int)tempd);
        Instructions.lflags.type = 60;
        return Instructions.lf_resw();
    }

    public static void DSHRW(int op2, int op3, loadw l, savew s) {
        if (Instructions.valid_DSHRW(op3)) {
            s.call(Instructions.do_DSHRW(op2, op3, l.call()));
        }
    }

    public static int BSWAPW(int op1) {
        return 0;
    }

    public static int BSWAPD(int op1) {
        return op1 >>> 24 | op1 >> 8 & 0xFF00 | op1 << 8 & 0xFF0000 | op1 << 24 & 0xFF000000;
    }

    public static int Negd(int op1) {
        Flags.lflags.type = 57;
        Instructions.lflags.var1 = op1;
        Instructions.lflags.res = 0 - op1;
        return Instructions.lflags.res;
    }

    public static short Negb(short op1) {
        Flags.lflags.type = 55;
        Flags.lf_var1b(op1);
        Flags.lf_resb(0 - Flags.lf_var1b());
        return Flags.lf_resb();
    }

    public static int Negw(int op1) {
        Flags.lflags.type = 56;
        Flags.lf_var1w(op1);
        Flags.lf_resw(0 - Flags.lf_var1w());
        return Flags.lf_resw();
    }

    public static interface savew {
        public void call(int var1);
    }

    public static interface loadw {
        public int call();
    }

    public static interface saveb {
        public void call(short var1);
    }

    public static interface loadb {
        public short call();
    }
}

