/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.cpu.CPU;
import jdos.cpu.core_normal.Prefix_helpers;
import jdos.hardware.IO;
import jdos.hardware.Memory;
import jdos.misc.Log;

public class StringOp
extends Prefix_helpers {
    public static final int R_OUTSB = 1;
    public static final int R_OUTSW = 2;
    public static final int R_OUTSD = 3;
    public static final int R_INSB = 4;
    public static final int R_INSW = 5;
    public static final int R_INSD = 6;
    public static final int R_MOVSB = 7;
    public static final int R_MOVSW = 8;
    public static final int R_MOVSD = 9;
    public static final int R_LODSB = 10;
    public static final int R_LODSW = 11;
    public static final int R_LODSD = 12;
    public static final int R_STOSB = 13;
    public static final int R_STOSW = 14;
    public static final int R_STOSD = 15;
    public static final int R_SCASB = 16;
    public static final int R_SCASW = 17;
    public static final int R_SCASD = 18;
    public static final int R_CMPSB = 19;
    public static final int R_CMPSW = 20;
    public static final int R_CMPSD = 21;
    public static int inString = 0;

    protected static void DoString(int type) {
        StringOp.DoString(prefixes, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DoString(int prefixes, int type) {
        try {
            ++inString;
            if ((prefixes & 1) == 0) {
                StringOp.DoString16(prefixes, type);
            } else {
                StringOp.DoString32(prefixes, type);
            }
        }
        finally {
            --inString;
        }
    }

    public static void DoString16(int prefixes, int type) {
        int si_base = base_ds;
        int di_base = CPU.Segs_ESphys;
        long count = reg_ecx.word();
        if ((prefixes & 2) == 0) {
            count = 1L;
        } else {
            ++CPU.CPU_Cycles;
        }
        int add_index = CPU.cpu.direction;
        if (count != 0L) {
            switch (type) {
                case 1: {
                    while (count > 0L) {
                        IO.IO_WriteB(reg_edx.word(), Memory.mem_readb(si_base + reg_esi.word()));
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 2: {
                    add_index <<= 1;
                    while (count > 0L) {
                        IO.IO_WriteW(reg_edx.word(), Memory.mem_readw(si_base + reg_esi.word()));
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 3: {
                    add_index <<= 2;
                    while (count > 0L) {
                        IO.IO_WriteD(reg_edx.word(), Memory.mem_readd(si_base + reg_esi.word()));
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 4: {
                    while (count > 0L) {
                        Memory.mem_writeb(di_base + reg_edi.word(), IO.IO_ReadB(reg_edx.word()));
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 5: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writew(di_base + reg_edi.word(), IO.IO_ReadW(reg_edx.word()));
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 6: {
                    add_index <<= 2;
                    while (count > 0L) {
                        Memory.mem_writed(di_base + reg_edi.word(), IO.IO_ReadD(reg_edx.word()));
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 13: {
                    while (count > 0L) {
                        Memory.mem_writeb(di_base + reg_edi.word(), reg_eax.low());
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 14: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writew(di_base + reg_edi.word(), reg_eax.word());
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 15: {
                    add_index <<= 2;
                    while (count > 0L) {
                        Memory.mem_writed(di_base + reg_edi.word(), StringOp.reg_eax.dword);
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 7: {
                    while (count > 0L) {
                        Memory.mem_writeb(di_base + reg_edi.word(), Memory.mem_readb(si_base + reg_esi.word()));
                        reg_edi.word(reg_edi.word() + add_index);
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 8: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writew(di_base + reg_edi.word(), Memory.mem_readw(si_base + reg_esi.word()));
                        reg_edi.word(reg_edi.word() + add_index);
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 9: {
                    add_index <<= 2;
                    while (count > 0L) {
                        Memory.mem_writed(di_base + reg_edi.word(), Memory.mem_readd(si_base + reg_esi.word()));
                        reg_edi.word(reg_edi.word() + add_index);
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 10: {
                    while (count > 0L) {
                        reg_eax.low(Memory.mem_readb(si_base + reg_esi.word()));
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 11: {
                    add_index <<= 1;
                    while (count > 0L) {
                        reg_eax.word(Memory.mem_readw(si_base + reg_esi.word()));
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 12: {
                    add_index <<= 2;
                    while (count > 0L) {
                        StringOp.reg_eax.dword = Memory.mem_readd(si_base + reg_esi.word());
                        reg_esi.word(reg_esi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        --count;
                    }
                    break;
                }
                case 16: {
                    short val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val2 = Memory.mem_readb(di_base + reg_edi.word());
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        if (reg_eax.low() == val2 == rep_zero) continue;
                    }
                    StringOp.CMPB(val2, reg_eax.low());
                    break;
                }
                case 17: {
                    add_index <<= 1;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val2 = Memory.mem_readw(di_base + reg_edi.word());
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        if (reg_eax.word() == val2 == rep_zero) continue;
                    }
                    StringOp.CMPW(val2, reg_eax.word());
                    break;
                }
                case 18: {
                    add_index <<= 2;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val2 = Memory.mem_readd(di_base + reg_edi.word());
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        if (StringOp.reg_eax.dword == val2 == rep_zero) continue;
                    }
                    StringOp.CMPD(val2, StringOp.reg_eax.dword);
                    break;
                }
                case 19: {
                    short val1 = 0;
                    short val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val1 = Memory.mem_readb(si_base + reg_esi.word());
                        val2 = Memory.mem_readb(di_base + reg_edi.word());
                        reg_esi.word(reg_esi.word() + add_index);
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        if (val1 == val2 == rep_zero) continue;
                    }
                    StringOp.CMPB(val2, val1);
                    break;
                }
                case 20: {
                    add_index <<= 1;
                    int val1 = 0;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val1 = Memory.mem_readw(si_base + reg_esi.word());
                        val2 = Memory.mem_readw(di_base + reg_edi.word());
                        reg_esi.word(reg_esi.word() + add_index);
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        if (val1 == val2 == rep_zero) continue;
                    }
                    StringOp.CMPW(val2, val1);
                    break;
                }
                case 21: {
                    add_index <<= 2;
                    int val1 = 0;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val1 = Memory.mem_readd(si_base + reg_esi.word());
                        val2 = Memory.mem_readd(di_base + reg_edi.word());
                        reg_esi.word(reg_esi.word() + add_index);
                        reg_edi.word(reg_edi.word() + add_index);
                        if ((prefixes & 2) != 0) {
                            reg_ecx.word_dec();
                        }
                        if (val1 == val2 == rep_zero) continue;
                    }
                    StringOp.CMPD(val2, val1);
                    break;
                }
                default: {
                    Log.log(8, 2, "Unhandled string op " + type);
                    Log.exit("Unhandled string op " + type);
                }
            }
        }
    }

    public static void DoString32(int prefixes, int type) {
        int si_base = base_ds;
        int di_base = CPU.Segs_ESphys;
        long count = (long)StringOp.reg_ecx.dword & 0xFFFFFFFFL;
        if ((prefixes & 2) == 0) {
            count = 1L;
        } else {
            ++CPU.CPU_Cycles;
        }
        int add_index = CPU.cpu.direction;
        if (count != 0L) {
            switch (type) {
                case 1: {
                    while (count > 0L) {
                        IO.IO_WriteB(reg_edx.word(), Memory.mem_readb(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 2: {
                    add_index <<= 1;
                    while (count > 0L) {
                        IO.IO_WriteW(reg_edx.word(), Memory.mem_readw(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 3: {
                    add_index <<= 2;
                    while (count > 0L) {
                        IO.IO_WriteD(reg_edx.word(), Memory.mem_readd(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 4: {
                    while (count > 0L) {
                        Memory.mem_writeb(di_base + StringOp.reg_edi.dword, IO.IO_ReadB(reg_edx.word()));
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 5: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writew(di_base + StringOp.reg_edi.dword, IO.IO_ReadW(reg_edx.word()));
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 6: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writed(di_base + StringOp.reg_edi.dword, IO.IO_ReadD(reg_edx.word()));
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 13: {
                    while (count > 0L) {
                        Memory.mem_writeb(di_base + StringOp.reg_edi.dword, reg_eax.low());
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 14: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writew(di_base + StringOp.reg_edi.dword, reg_eax.word());
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 15: {
                    add_index <<= 2;
                    while (count > 0L) {
                        Memory.mem_writed(di_base + StringOp.reg_edi.dword, StringOp.reg_eax.dword);
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 7: {
                    while (count > 0L) {
                        Memory.mem_writeb(di_base + StringOp.reg_edi.dword, Memory.mem_readb(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_edi.dword += add_index;
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 8: {
                    add_index <<= 1;
                    while (count > 0L) {
                        Memory.mem_writew(di_base + StringOp.reg_edi.dword, Memory.mem_readw(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_edi.dword += add_index;
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 9: {
                    add_index <<= 2;
                    while (count > 0L) {
                        Memory.mem_writed(di_base + StringOp.reg_edi.dword, Memory.mem_readd(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_edi.dword += add_index;
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 10: {
                    while (count > 0L) {
                        reg_eax.low(Memory.mem_readb(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 11: {
                    add_index <<= 1;
                    while (count > 0L) {
                        reg_eax.word(Memory.mem_readw(si_base + StringOp.reg_esi.dword));
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 12: {
                    add_index <<= 2;
                    while (count > 0L) {
                        StringOp.reg_eax.dword = Memory.mem_readd(si_base + StringOp.reg_esi.dword);
                        StringOp.reg_esi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        --count;
                    }
                    break;
                }
                case 16: {
                    short val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val2 = Memory.mem_readb(di_base + StringOp.reg_edi.dword);
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        if (reg_eax.low() == val2 == rep_zero) continue;
                    }
                    StringOp.CMPB(val2, reg_eax.low());
                    break;
                }
                case 17: {
                    add_index <<= 1;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val2 = Memory.mem_readw(di_base + StringOp.reg_edi.dword);
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        if (reg_eax.word() == val2 == rep_zero) continue;
                    }
                    StringOp.CMPW(val2, reg_eax.word());
                    break;
                }
                case 18: {
                    add_index <<= 2;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val2 = Memory.mem_readd(di_base + StringOp.reg_edi.dword);
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        if (StringOp.reg_eax.dword == val2 == rep_zero) continue;
                    }
                    StringOp.CMPD(val2, StringOp.reg_eax.dword);
                    break;
                }
                case 19: {
                    short val1 = 0;
                    short val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val1 = Memory.mem_readb(si_base + StringOp.reg_esi.dword);
                        val2 = Memory.mem_readb(di_base + StringOp.reg_edi.dword);
                        StringOp.reg_esi.dword += add_index;
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        if (val1 == val2 == rep_zero) continue;
                    }
                    StringOp.CMPB(val2, val1);
                    break;
                }
                case 20: {
                    add_index <<= 1;
                    int val1 = 0;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val1 = Memory.mem_readw(si_base + StringOp.reg_esi.dword);
                        val2 = Memory.mem_readw(di_base + StringOp.reg_edi.dword);
                        StringOp.reg_esi.dword += add_index;
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        if (val1 == val2 == rep_zero) continue;
                    }
                    StringOp.CMPW(val2, val1);
                    break;
                }
                case 21: {
                    add_index <<= 2;
                    int val1 = 0;
                    int val2 = 0;
                    while (count > 0L) {
                        --count;
                        --CPU.CPU_Cycles;
                        val1 = Memory.mem_readd(si_base + StringOp.reg_esi.dword);
                        val2 = Memory.mem_readd(di_base + StringOp.reg_edi.dword);
                        StringOp.reg_esi.dword += add_index;
                        StringOp.reg_edi.dword += add_index;
                        if ((prefixes & 2) != 0) {
                            --StringOp.reg_ecx.dword;
                        }
                        if (val1 == val2 == rep_zero) continue;
                    }
                    StringOp.CMPD(val2, val1);
                    break;
                }
                default: {
                    Log.log(8, 2, "Unhandled string op " + type);
                    Log.exit("Unhandled string op " + type);
                }
            }
        }
    }
}

