/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.cpu.Core;

public class Table_ea
extends Core {
    public static boolean EA16 = true;
    static final long SIBZero = 0L;

    public static int getEaa32(int rm) {
        if (rm < 64) {
            switch (rm & 7) {
                case 0: {
                    return base_ds + Table_ea.reg_eax.dword;
                }
                case 1: {
                    return base_ds + Table_ea.reg_ecx.dword;
                }
                case 2: {
                    return base_ds + Table_ea.reg_edx.dword;
                }
                case 3: {
                    return base_ds + Table_ea.reg_ebx.dword;
                }
                case 4: {
                    return Table_ea.Sib(0);
                }
                case 5: {
                    return base_ds + Table_ea.Fetchd();
                }
                case 6: {
                    return base_ds + Table_ea.reg_esi.dword;
                }
                case 7: {
                    return base_ds + Table_ea.reg_edi.dword;
                }
            }
        } else if (rm < 128) {
            switch (rm & 7) {
                case 0: {
                    return base_ds + Table_ea.reg_eax.dword + Table_ea.Fetchbs();
                }
                case 1: {
                    return base_ds + Table_ea.reg_ecx.dword + Table_ea.Fetchbs();
                }
                case 2: {
                    return base_ds + Table_ea.reg_edx.dword + Table_ea.Fetchbs();
                }
                case 3: {
                    return base_ds + Table_ea.reg_ebx.dword + Table_ea.Fetchbs();
                }
                case 4: {
                    int temp = Table_ea.Sib(1);
                    return temp + Table_ea.Fetchbs();
                }
                case 5: {
                    return base_ss + Table_ea.reg_ebp.dword + Table_ea.Fetchbs();
                }
                case 6: {
                    return base_ds + Table_ea.reg_esi.dword + Table_ea.Fetchbs();
                }
                case 7: {
                    return base_ds + Table_ea.reg_edi.dword + Table_ea.Fetchbs();
                }
            }
        } else {
            switch (rm & 7) {
                case 0: {
                    return base_ds + Table_ea.reg_eax.dword + Table_ea.Fetchds();
                }
                case 1: {
                    return base_ds + Table_ea.reg_ecx.dword + Table_ea.Fetchds();
                }
                case 2: {
                    return base_ds + Table_ea.reg_edx.dword + Table_ea.Fetchds();
                }
                case 3: {
                    return base_ds + Table_ea.reg_ebx.dword + Table_ea.Fetchds();
                }
                case 4: {
                    int temp = Table_ea.Sib(2);
                    return temp + Table_ea.Fetchds();
                }
                case 5: {
                    return base_ss + Table_ea.reg_ebp.dword + Table_ea.Fetchds();
                }
                case 6: {
                    return base_ds + Table_ea.reg_esi.dword + Table_ea.Fetchds();
                }
                case 7: {
                    return base_ds + Table_ea.reg_edi.dword + Table_ea.Fetchds();
                }
            }
        }
        return 0;
    }

    public static int getEaa16(int rm) {
        if (rm < 64) {
            switch (rm & 7) {
                case 0: {
                    return base_ds + (reg_ebx.word() + (short)reg_esi.word() & 0xFFFF);
                }
                case 1: {
                    return base_ds + (reg_ebx.word() + (short)reg_edi.word() & 0xFFFF);
                }
                case 2: {
                    return base_ss + (reg_ebp.word() + (short)reg_esi.word() & 0xFFFF);
                }
                case 3: {
                    return base_ss + (reg_ebp.word() + (short)reg_edi.word() & 0xFFFF);
                }
                case 4: {
                    return base_ds + reg_esi.word();
                }
                case 5: {
                    return base_ds + reg_edi.word();
                }
                case 6: {
                    return base_ds + Table_ea.Fetchw();
                }
                case 7: {
                    return base_ds + reg_ebx.word();
                }
            }
        } else if (rm < 128) {
            switch (rm & 7) {
                case 0: {
                    return base_ds + (reg_ebx.word() + (short)reg_esi.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 1: {
                    return base_ds + (reg_ebx.word() + (short)reg_edi.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 2: {
                    return base_ss + (reg_ebp.word() + (short)reg_esi.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 3: {
                    return base_ss + (reg_ebp.word() + (short)reg_edi.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 4: {
                    return base_ds + (reg_esi.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 5: {
                    return base_ds + (reg_edi.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 6: {
                    return base_ss + (reg_ebp.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
                case 7: {
                    return base_ds + (reg_ebx.word() + Table_ea.Fetchbs() & 0xFFFF);
                }
            }
        } else {
            switch (rm & 7) {
                case 0: {
                    return base_ds + (reg_ebx.word() + (short)reg_esi.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 1: {
                    return base_ds + (reg_ebx.word() + (short)reg_edi.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 2: {
                    return base_ss + (reg_ebp.word() + (short)reg_esi.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 3: {
                    return base_ss + (reg_ebp.word() + (short)reg_edi.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 4: {
                    return base_ds + (reg_esi.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 5: {
                    return base_ds + (reg_edi.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 6: {
                    return base_ss + (reg_ebp.word() + Table_ea.Fetchws() & 0xFFFF);
                }
                case 7: {
                    return base_ds + (reg_ebx.word() + Table_ea.Fetchws() & 0xFFFF);
                }
            }
        }
        return 0;
    }

    public static int getEaa(int rm) {
        if (EA16) {
            return Table_ea.getEaa16(rm);
        }
        return Table_ea.getEaa32(rm);
    }

    private static int Sib(int mode) {
        short sib = Table_ea.Fetchb();
        int base = 0;
        switch (sib & 7) {
            case 0: {
                base = base_ds + Table_ea.reg_eax.dword;
                break;
            }
            case 1: {
                base = base_ds + Table_ea.reg_ecx.dword;
                break;
            }
            case 2: {
                base = base_ds + Table_ea.reg_edx.dword;
                break;
            }
            case 3: {
                base = base_ds + Table_ea.reg_ebx.dword;
                break;
            }
            case 4: {
                base = base_ss + Table_ea.reg_esp.dword;
                break;
            }
            case 5: {
                if (mode == 0) {
                    base = base_ds + Table_ea.Fetchd();
                    break;
                }
                base = base_ss + Table_ea.reg_ebp.dword;
                break;
            }
            case 6: {
                base = base_ds + Table_ea.reg_esi.dword;
                break;
            }
            case 7: {
                base = base_ds + Table_ea.reg_edi.dword;
            }
        }
        int index = sib >> 3 & 7;
        switch (index) {
            case 0: {
                base += Table_ea.reg_eax.dword << (sib >> 6);
                break;
            }
            case 1: {
                base += Table_ea.reg_ecx.dword << (sib >> 6);
                break;
            }
            case 2: {
                base += Table_ea.reg_edx.dword << (sib >> 6);
                break;
            }
            case 3: {
                base += Table_ea.reg_ebx.dword << (sib >> 6);
                break;
            }
            case 4: {
                base = (int)((long)base + (0L << (sib >> 6)));
                break;
            }
            case 5: {
                base += Table_ea.reg_ebp.dword << (sib >> 6);
                break;
            }
            case 6: {
                base += Table_ea.reg_esi.dword << (sib >> 6);
                break;
            }
            case 7: {
                base += Table_ea.reg_edi.dword << (sib >> 6);
            }
        }
        return base;
    }

    protected static int GetEADirect() {
        if ((prefixes & 1) != 0) {
            return base_ds + Table_ea.Fetchd();
        }
        return base_ds + Table_ea.Fetchw();
    }

    public static interface GetEAHandler {
        public int call();
    }
}

