/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.core_dynamic.CacheBlockDynRec;
import jdos.cpu.core_dynamic.CodePageHandlerDynRec;
import jdos.misc.Log;

public class Cache {
    public Block block = new Block();
    int pos;
    CodePageHandlerDynRec free_pages;
    CodePageHandlerDynRec used_pages;
    CodePageHandlerDynRec last_page;
    public static Cache cache = new Cache();
    public static boolean cache_initialized = false;
    private static CacheBlockDynRec[] cache_blocks = null;

    public static void cache_init(boolean enable) {
        if (enable) {
            CacheBlockDynRec block;
            int i;
            if (cache_initialized) {
                return;
            }
            cache_initialized = true;
            if (cache_blocks == null) {
                try {
                    cache_blocks = new CacheBlockDynRec[131072];
                    for (i = 0; i < cache_blocks.length; ++i) {
                        Cache.cache_blocks[i] = new CacheBlockDynRec();
                    }
                }
                catch (Throwable e) {
                    Log.exit("Allocating cache_blocks has failed");
                }
                Cache.cache.block.free = cache_blocks[0];
                for (i = 0; i < 131071; ++i) {
                    Cache.cache_blocks[i].cache.next = cache_blocks[i + 1];
                }
            }
            Cache.cache.block.first = block = Cache.cache_getblock();
            Cache.cache.block.active = block;
            block.cache.next = null;
            Cache.cache.free_pages = null;
            Cache.cache.last_page = null;
            Cache.cache.used_pages = null;
            for (i = 0; i < 512; ++i) {
                CodePageHandlerDynRec newpage = new CodePageHandlerDynRec();
                newpage.next = Cache.cache.free_pages;
                Cache.cache.free_pages = newpage;
            }
        }
    }

    public static void cache_addunusedblock(CacheBlockDynRec block) {
        block.cache.next = Cache.cache.block.free;
        Cache.cache.block.free = block;
    }

    public static CacheBlockDynRec cache_openblock() {
        CacheBlockDynRec block = Cache.cache.block.active;
        CacheBlockDynRec nextblock = block.cache.next;
        if (block.page.handler != null) {
            block.Clear();
        }
        block.cache.next = nextblock;
        return block;
    }

    public static CacheBlockDynRec cache_getblock() {
        CacheBlockDynRec ret = Cache.cache.block.free;
        if (ret == null) {
            Log.exit("Ran out of CacheBlocks");
        }
        Cache.cache.block.free = ret.cache.next;
        ret.cache.next = null;
        return ret;
    }

    public static void cache_closeblock() {
        CacheBlockDynRec block = Cache.cache.block.active;
        block.link[0].to = null;
        block.link[1].to = null;
        block.link[0].from = null;
        block.link[1].from = null;
        if (block.cache.next == null) {
            CacheBlockDynRec newblock = Cache.cache_getblock();
            newblock.cache.next = block.cache.next;
            block.cache.next = newblock;
        }
        Cache.cache.block.active = block.cache.next;
    }

    public static class Block {
        public CacheBlockDynRec first;
        public CacheBlockDynRec active;
        public CacheBlockDynRec free;
    }
}

