/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.Cache;
import jdos.cpu.core_dynamic.CacheBlockDynRec;
import jdos.cpu.core_dynamic.DecodeBlock;
import jdos.hardware.Memory;
import jdos.util.Ptr;

public final class CodePageHandlerDynRec
extends Paging.PageHandler {
    public static int activeCount = 0;
    public static int usedCount = 0;
    public Ptr write_map = new Ptr(4096);
    public Ptr invalidation_map = null;
    CodePageHandlerDynRec next;
    CodePageHandlerDynRec prev;
    private Paging.PageHandler old_pagehandler;
    private CacheBlockDynRec[] hash_map = new CacheBlockDynRec[257];
    private int active_blocks;
    private int active_count;
    private int hostmem;
    private int phys_page;

    public void SetupAt(int _phys_page, Paging.PageHandler _old_pagehandler) {
        this.phys_page = _phys_page;
        this.old_pagehandler = _old_pagehandler;
        this.flags = this.old_pagehandler.flags | 8;
        this.flags &= 0xFFFFFFFD;
        this.active_blocks = 0;
        this.active_count = 16;
        this.invalidation_map = null;
    }

    void InvalidateRange(int start, int end) {
        boolean is_current_block = false;
        int ip_point = CPU.Segs_CSphys + CPU_Regs.reg_eip & 0xFFF;
        for (int index = 1 + (end >> 4); index >= 0; --index) {
            int map = 0;
            for (int count = start; count <= end; ++count) {
                map += this.write_map.p[count];
            }
            if (map == 0) {
                if (is_current_block) {
                    DecodeBlock.smc = true;
                }
                return;
            }
            CacheBlockDynRec block = this.hash_map[index];
            while (block != null) {
                CacheBlockDynRec nextblock = block.hash.next;
                if (start <= block.page.end && end >= block.page.start) {
                    if (ip_point <= block.page.end && ip_point >= block.page.start) {
                        is_current_block = true;
                    }
                    block.Clear();
                }
                block = nextblock;
            }
        }
        if (is_current_block) {
            DecodeBlock.smc = true;
        }
    }

    public void writeb(int address, int val) {
        int addr = address & 0xFFF;
        if (Memory.host_readb(this.hostmem + addr) == (val & 0xFF)) {
            return;
        }
        Memory.host_writeb(this.hostmem + addr, (short)val);
        if (this.write_map.readb(addr) == 0) {
            if (this.active_blocks != 0) {
                return;
            }
            --this.active_count;
            if (this.active_count == 0) {
                this.Release();
            }
            return;
        }
        if (this.invalidation_map == null) {
            this.invalidation_map = new Ptr(4096);
        }
        int n = addr;
        this.invalidation_map.p[n] = (byte)(this.invalidation_map.p[n] + 1);
        this.InvalidateRange(addr, addr);
    }

    public void writew(int address, int val) {
        int addr = address & 0xFFF;
        if (Memory.host_readw(this.hostmem + addr) == (val & 0xFFFF)) {
            return;
        }
        Memory.host_writew(this.hostmem + addr, val);
        if (this.write_map.readw(addr) == 0) {
            if (this.active_blocks != 0) {
                return;
            }
            --this.active_count;
            if (this.active_count == 0) {
                this.Release();
            }
            return;
        }
        if (this.invalidation_map == null) {
            this.invalidation_map = new Ptr(4096);
        }
        this.invalidation_map.writew(addr, this.invalidation_map.readw(addr) + 257);
        this.InvalidateRange(addr, addr + 1);
    }

    public void writed(int address, int val) {
        int addr = address & 0xFFF;
        if (Memory.host_readd(this.hostmem + addr) == (val & 0xFFFFFFFF)) {
            return;
        }
        Memory.host_writed(this.hostmem + addr, val);
        if (this.write_map.readd(addr) == 0) {
            if (this.active_blocks != 0) {
                return;
            }
            --this.active_count;
            if (this.active_count == 0) {
                this.Release();
            }
            return;
        }
        if (this.invalidation_map == null) {
            this.invalidation_map = new Ptr(4096);
        }
        this.invalidation_map.writed(addr, this.invalidation_map.readd(addr) + 0x1010101);
        this.InvalidateRange(addr, addr + 3);
    }

    void AddCacheBlock(CacheBlockDynRec block) {
        int index = 1 + (block.page.start >> 4);
        block.hash.next = this.hash_map[index];
        block.hash.index = index;
        this.hash_map[index] = block;
        block.page.handler = this;
        ++this.active_blocks;
        ++activeCount;
        if (++usedCount % 1000 == 0) {
            System.out.println("Dynamic code cache: " + activeCount + "/" + usedCount);
        }
    }

    void AddCrossBlock(CacheBlockDynRec block) {
        block.hash.next = this.hash_map[0];
        block.hash.index = 0;
        this.hash_map[0] = block;
        block.page.handler = this;
        ++this.active_blocks;
    }

    void DelCacheBlock(CacheBlockDynRec block) {
        --activeCount;
        --this.active_blocks;
        this.active_count = 16;
        if (this.hash_map[block.hash.index] == block) {
            this.hash_map[block.hash.index] = block.hash.next;
        } else {
            CacheBlockDynRec parent = this.hash_map[block.hash.index];
            CacheBlockDynRec bwhere = parent.hash.next;
            while (bwhere != block) {
                parent = bwhere;
                bwhere = parent.hash.next;
            }
            parent.hash.next = block.hash.next;
        }
        if (block.cache.wmapmask != null) {
            for (int i = block.page.start; i < block.cache.maskstart; ++i) {
                if (this.write_map.p[i] == 0) continue;
                int n = i;
                this.write_map.p[n] = (byte)(this.write_map.p[n] - 1);
            }
            int maskct = 0;
            int i = block.cache.maskstart;
            while (i <= block.page.end) {
                if (this.write_map.p[i] != 0 && (maskct >= block.cache.masklen || block.cache.wmapmask[maskct] == 0)) {
                    int n = i;
                    this.write_map.p[n] = (byte)(this.write_map.p[n] - 1);
                }
                ++i;
                ++maskct;
            }
            block.cache.wmapmask = null;
        } else {
            for (int i = block.page.start; i <= block.page.end; ++i) {
                if (this.write_map.p[i] == 0) continue;
                int n = i;
                this.write_map.p[n] = (byte)(this.write_map.p[n] - 1);
            }
        }
    }

    public void Release() {
        Memory.MEM_SetPageHandler(this.phys_page, 1, this.old_pagehandler);
        Paging.PAGING_ClearTLB();
        if (this.prev != null) {
            this.prev.next = this.next;
        } else {
            Cache.cache.used_pages = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        } else {
            Cache.cache.last_page = this.prev;
        }
        this.next = Cache.cache.free_pages;
        Cache.cache.free_pages = this;
        this.prev = null;
    }

    public void ClearRelease() {
        for (int index = 0; index < 257; ++index) {
            CacheBlockDynRec block = this.hash_map[index];
            while (block != null) {
                CacheBlockDynRec nextblock = block.hash.next;
                block.Clear();
                block = nextblock;
            }
        }
        this.Release();
    }

    public CacheBlockDynRec FindCacheBlock(int start) {
        CacheBlockDynRec block = this.hash_map[1 + (start >> 4)];
        while (block != null) {
            if (block.page.start == start) {
                return block;
            }
            block = block.hash.next;
        }
        return null;
    }

    public int GetHostReadPt(int phys_page) {
        this.hostmem = this.old_pagehandler.GetHostReadPt(phys_page);
        return this.hostmem;
    }

    public int GetHostWritePt(int phys_page) {
        return this.GetHostReadPt(phys_page);
    }
}

