/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.util.LinkedList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Instructions;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.DecodeBlock;
import jdos.cpu.core_dynamic.Decoder;
import jdos.cpu.core_dynamic.Eaa;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Grp2;
import jdos.cpu.core_dynamic.Grp3;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Inst1;
import jdos.cpu.core_dynamic.Inst2;
import jdos.cpu.core_dynamic.Inst3;
import jdos.cpu.core_dynamic.Inst4;
import jdos.cpu.core_dynamic.Loader;
import jdos.cpu.core_dynamic.Op;
import jdos.cpu.core_dynamic.Strings;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;

public class Compiler
extends Helper {
    public static int compiledMethods = 0;
    public static boolean saveClasses = false;
    public static int min_block_size = 1;
    private static Thread[] compilerThread = null;
    private static LinkedList compilerQueue = new LinkedList();
    private static final int processorCount = 1;
    private static int cacheCount;
    private static ClassPool pool;
    static MessageDigest md;
    private static int count;
    public static final Section.SectionFunction Compiler_Init;
    static /* synthetic */ Class class$jdos$Dosbox;

    private static byte[] getOpCode(int start, int len) {
        byte[] opCode = new byte[len];
        int src = Paging.getDirectIndexRO(start);
        if (src >= 0) {
            Memory.host_memcpy(opCode, 0, src, len);
        } else {
            Memory.MEM_BlockRead(start, opCode, len);
        }
        return opCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compile(DecodeBlock block) {
        if (block == null) {
            for (int i = 0; i < compilerThread.length; ++i) {
                try {
                    compilerThread[i].join();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        LinkedList linkedList = compilerQueue;
        synchronized (linkedList) {
            compilerQueue.add(block);
            compilerQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void do_compile(Op op) {
        Op prev = op;
        op = op.next;
        StringBuffer method = new StringBuffer();
        int count = 0;
        Op start = prev;
        while (op != null) {
            try {
                Op compiled;
                boolean jump = false;
                ++count;
                if (start == null) {
                    start = prev;
                }
                method.append("{");
                if (Compiler.compile_op(op, method)) {
                    method.append("CPU_Regs.reg_eip+=");
                    method.append(op.eip_count);
                    method.append(";}\n  ");
                    continue;
                }
                method.append("}");
                jump = true;
                if (op.next != null) {
                    Log.exit("Instruction " + Integer.toHexString(op.c) + " jumped but there was another instruction after it: " + Integer.toHexString(op.next.c));
                }
                if (count >= min_block_size && (compiled = Compiler.compileMethod(start, method, jump)) != null) {
                    if (!jump) {
                        compiled.next = op;
                    }
                    start.next = compiled;
                    if (++compiledMethods % 250 == 0) {
                        System.out.println("Compiled " + compiledMethods + " blocks");
                    }
                }
                if (method.length() > 0) {
                    method = new StringBuffer();
                }
                start = null;
                count = 0;
            }
            finally {
                prev = op;
                op = op.next;
            }
        }
    }

    private static String nameGet8(CPU_Regs.Reg reg) {
        if (reg.getParent() == null) {
            return "CPU_Regs.reg_" + reg.getName() + ".low()";
        }
        return "CPU_Regs.reg_" + reg.getParent().getName() + ".high()";
    }

    private static String nameGet16(CPU_Regs.Reg reg) {
        return "CPU_Regs.reg_" + reg.getName() + ".word()";
    }

    private static String nameGet32(CPU_Regs.Reg reg) {
        if (reg.getName() == null) {
            return String.valueOf(reg.dword);
        }
        return "CPU_Regs.reg_" + reg.getName() + ".dword";
    }

    private static String nameSet8(CPU_Regs.Reg reg, String value) {
        if (reg.getParent() == null) {
            return "CPU_Regs.reg_" + reg.getName() + ".low(" + value + ")";
        }
        return "CPU_Regs.reg_" + reg.getParent().getName() + ".high(" + value + ")";
    }

    private static String nameSet16(CPU_Regs.Reg reg, String value) {
        return "CPU_Regs.reg_" + reg.getName() + ".word(" + value + ")";
    }

    private static String nameSet32(CPU_Regs.Reg reg, String value) {
        return "CPU_Regs.reg_" + reg.getName() + ".dword=" + value;
    }

    private static String nameRef(CPU_Regs.Reg reg) {
        return "CPU_Regs.reg_" + reg.getName();
    }

    private static void toStringValue(EaaBase eaa, StringBuffer method) {
        if (eaa instanceof Eaa.EA_16_00_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+(short)CPU_Regs.reg_esi.word()) & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_01_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+(short)CPU_Regs.reg_edi.word()) & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_02_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+(short)CPU_Regs.reg_esi.word()) & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_03_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+(short)CPU_Regs.reg_edi.word()) & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_04_n) {
            method.append("Core.base_ds+(CPU_Regs.reg_esi.word())");
        } else if (eaa instanceof Eaa.EA_16_05_n) {
            method.append("Core.base_ds+(CPU_Regs.reg_edi.word())");
        } else if (eaa instanceof Eaa.EA_16_06_n) {
            method.append("Core.base_ds+");
            method.append(((Eaa.EA_16_06_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_16_07_n) {
            method.append("Core.base_ds+(CPU_Regs.reg_ebx.word())");
        } else if (eaa instanceof Eaa.EA_16_40_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+(short)CPU_Regs.reg_esi.word()+");
            method.append(((Eaa.EA_16_40_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_41_n) {
            method.append(" Core.base_ds+((CPU_Regs.reg_ebx.word()+(short)CPU_Regs.reg_edi.word()+");
            method.append(((Eaa.EA_16_41_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_42_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+(short)CPU_Regs.reg_esi.word()+");
            method.append(((Eaa.EA_16_42_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_43_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+(short)CPU_Regs.reg_edi.word()+");
            method.append(((Eaa.EA_16_43_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_44_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_esi.word()+");
            method.append(((Eaa.EA_16_44_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_45_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_edi.word()+");
            method.append(((Eaa.EA_16_45_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_46_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+");
            method.append(((Eaa.EA_16_46_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_47_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+");
            method.append(((Eaa.EA_16_47_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_80_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+(short)CPU_Regs.reg_esi.word()+");
            method.append(((Eaa.EA_16_80_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_81_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+(short)CPU_Regs.reg_edi.word()+");
            method.append(((Eaa.EA_16_81_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_82_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+(short)CPU_Regs.reg_esi.word()+");
            method.append(((Eaa.EA_16_82_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_83_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+(short)CPU_Regs.reg_edi.word()+");
            method.append(((Eaa.EA_16_83_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_84_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_esi.word()+");
            method.append(((Eaa.EA_16_84_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_85_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_edi.word()+");
            method.append(((Eaa.EA_16_85_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_86_n) {
            method.append("Core.base_ss+((CPU_Regs.reg_ebp.word()+");
            method.append(((Eaa.EA_16_86_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_16_87_n) {
            method.append("Core.base_ds+((CPU_Regs.reg_ebx.word()+");
            method.append(((Eaa.EA_16_87_n)eaa).i);
            method.append(") & 0xFFFF)");
        } else if (eaa instanceof Eaa.EA_32_00_n) {
            method.append("Core.base_ds+CPU_Regs.reg_eax.dword");
        } else if (eaa instanceof Eaa.EA_32_01_n) {
            method.append("Core.base_ds+CPU_Regs.reg_ecx.dword");
        } else if (eaa instanceof Eaa.EA_32_02_n) {
            method.append("Core.base_ds+CPU_Regs.reg_edx.dword");
        } else if (eaa instanceof Eaa.EA_32_03_n) {
            method.append("Core.base_ds+CPU_Regs.reg_ebx.dword");
        } else if (eaa instanceof Eaa.EA_32_04_n) {
            Eaa.EA_32_04_n o = (Eaa.EA_32_04_n)eaa;
            if (o.ds) {
                method.append("Core.base_ds+");
            } else {
                method.append("Core.base_ss+");
            }
            method.append(Compiler.nameGet32(o.reg));
            method.append("+(");
            method.append(Compiler.nameGet32(o.reg2));
            if (o.sib > 0) {
                method.append(" << ");
                method.append(o.sib);
            }
            method.append(")");
        } else if (eaa instanceof Eaa.EA_32_05_n) {
            method.append("Core.base_ds+");
            method.append(((Eaa.EA_32_05_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_06_n) {
            method.append("Core.base_ds+CPU_Regs.reg_esi.dword");
        } else if (eaa instanceof Eaa.EA_32_07_n) {
            method.append("Core.base_ds+CPU_Regs.reg_edi.dword");
        } else if (eaa instanceof Eaa.EA_32_40_n) {
            method.append("Core.base_ds+CPU_Regs.reg_eax.dword+");
            method.append(((Eaa.EA_32_40_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_41_n) {
            method.append("Core.base_ds+CPU_Regs.reg_ecx.dword+");
            method.append(((Eaa.EA_32_41_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_42_n) {
            method.append("Core.base_ds+CPU_Regs.reg_edx.dword+");
            method.append(((Eaa.EA_32_42_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_43_n) {
            method.append("Core.base_ds+CPU_Regs.reg_ebx.dword+");
            method.append(((Eaa.EA_32_43_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_44_n) {
            Eaa.EA_32_44_n o = (Eaa.EA_32_44_n)eaa;
            if (o.ds) {
                method.append("Core.base_ds+");
            } else {
                method.append("Core.base_ss+");
            }
            method.append(Compiler.nameGet32(o.reg));
            method.append("+(");
            method.append(Compiler.nameGet32(o.reg2));
            if (o.sib > 0) {
                method.append(" << ");
                method.append(o.sib);
            }
            method.append(")+");
            method.append(o.i);
        } else if (eaa instanceof Eaa.EA_32_45_n) {
            method.append("Core.base_ss+CPU_Regs.reg_ebp.dword+");
            method.append(((Eaa.EA_32_45_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_46_n) {
            method.append("Core.base_ds+CPU_Regs.reg_esi.dword+");
            method.append(((Eaa.EA_32_46_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_47_n) {
            method.append("Core.base_ds+CPU_Regs.reg_edi.dword+");
            method.append(((Eaa.EA_32_47_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_80_n) {
            method.append("Core.base_ds+CPU_Regs.reg_eax.dword+");
            method.append(((Eaa.EA_32_80_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_81_n) {
            method.append("Core.base_ds+CPU_Regs.reg_ecx.dword+");
            method.append(((Eaa.EA_32_81_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_82_n) {
            method.append("Core.base_ds+CPU_Regs.reg_edx.dword+");
            method.append(((Eaa.EA_32_82_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_83_n) {
            method.append("Core.base_ds+CPU_Regs.reg_ebx.dword+");
            method.append(((Eaa.EA_32_83_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_84_n) {
            Eaa.EA_32_84_n o = (Eaa.EA_32_84_n)eaa;
            if (o.ds) {
                method.append("Core.base_ds+");
            } else {
                method.append("Core.base_ss+");
            }
            method.append(Compiler.nameGet32(o.reg));
            method.append("+(");
            method.append(Compiler.nameGet32(o.reg2));
            if (o.sib > 0) {
                method.append(" << ");
                method.append(o.sib);
            }
            method.append(")+");
            method.append(o.i);
        } else if (eaa instanceof Eaa.EA_32_85_n) {
            method.append("Core.base_ss+CPU_Regs.reg_ebp.dword+");
            method.append(((Eaa.EA_32_85_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_86_n) {
            method.append("Core.base_ds+CPU_Regs.reg_esi.dword+");
            method.append(((Eaa.EA_32_86_n)eaa).i);
        } else if (eaa instanceof Eaa.EA_32_87_n) {
            method.append("Core.base_ds+CPU_Regs.reg_edi.dword+");
            method.append(((Eaa.EA_32_87_n)eaa).i);
        }
    }

    private static void compile(Inst1.JumpCond16_b op, String cond, StringBuffer method) {
        method.append("if (");
        method.append(cond);
        method.append(") {");
        method.append("CPU_Regs.reg_ip(CPU_Regs.reg_ip()+");
        method.append(op.offset);
        method.append("+");
        method.append(op.eip_count);
        method.append(");");
        method.append("return Constants.BR_Link1;}");
        method.append("CPU_Regs.reg_ip(CPU_Regs.reg_ip()+");
        method.append(op.eip_count);
        method.append(");return Constants.BR_Link2;");
    }

    private static void compile(Inst2.JumpCond16_w op, String cond, StringBuffer method) {
        method.append("if (");
        method.append(cond);
        method.append(") {");
        method.append("CPU_Regs.reg_ip(CPU_Regs.reg_ip()+");
        method.append(op.offset);
        method.append("+");
        method.append(op.eip_count);
        method.append(");");
        method.append("return Constants.BR_Link1;}");
        method.append("CPU_Regs.reg_ip(CPU_Regs.reg_ip()+");
        method.append(op.eip_count);
        method.append(");return Constants.BR_Link2;");
    }

    private static void compile(Inst3.JumpCond32_b op, String cond, StringBuffer method) {
        method.append("if (");
        method.append(cond);
        method.append(") {");
        method.append("CPU_Regs.reg_eip+=");
        method.append(op.offset);
        method.append("+");
        method.append(op.eip_count);
        method.append(";");
        method.append("return Constants.BR_Link1;}");
        method.append("CPU_Regs.reg_eip+=");
        method.append(op.eip_count);
        method.append(";return Constants.BR_Link2;");
    }

    private static void compile(Inst4.JumpCond32_d op, String cond, StringBuffer method) {
        method.append("if (");
        method.append(cond);
        method.append(") {");
        method.append("CPU_Regs.reg_eip+=");
        method.append(op.offset);
        method.append("+");
        method.append(op.eip_count);
        method.append(";");
        method.append("return Constants.BR_Link1;}");
        method.append("CPU_Regs.reg_eip+=");
        method.append(op.eip_count);
        method.append(";return Constants.BR_Link2;");
    }

    /*
     * Opcode count of 29089 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static boolean compile_op(Op op, StringBuffer method) {
        switch (op.c) {
            case 0: 
            case 512: {
                if (op instanceof Inst1.Addb_reg) {
                    Inst1.Addb_reg o = (Inst1.Addb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ADDB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AddEbGb_mem)) break;
                Inst1.AddEbGb_mem o = (Inst1.AddEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.ADDB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 1: {
                if (op instanceof Inst1.Addw_reg) {
                    Inst1.Addw_reg o = (Inst1.Addw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ADDW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AddEwGw_mem)) break;
                Inst1.AddEwGw_mem o = (Inst1.AddEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.ADDW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 2: 
            case 514: {
                if (op instanceof Inst1.Addb_reg) {
                    Inst1.Addb_reg o = (Inst1.Addb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ADDB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AddGbEb_mem)) break;
                Inst1.AddGbEb_mem o = (Inst1.AddGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.ADDB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 3: {
                if (op instanceof Inst1.Addw_reg) {
                    Inst1.Addw_reg o = (Inst1.Addw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ADDW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AddGwEw_mem)) break;
                Inst1.AddGwEw_mem o = (Inst1.AddGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.ADDW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 4: 
            case 516: {
                if (!(op instanceof Inst1.AddAlIb)) break;
                Inst1.AddAlIb o = (Inst1.AddAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.ADDB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 5: {
                if (!(op instanceof Inst1.AddAxIw)) break;
                Inst1.AddAxIw o = (Inst1.AddAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.ADDW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 6: {
                if (!(op instanceof Inst1.PushES)) break;
                Inst1.PushES o = (Inst1.PushES)op;
                method.append("CPU.CPU_Push16(CPU.Segs_ESval);");
                return true;
            }
            case 7: {
                if (!(op instanceof Inst1.PopES)) break;
                Inst1.PopES o = (Inst1.PopES)op;
                method.append("if (CPU.CPU_PopSegES(false)) return RUNEXCEPTION();");
                return true;
            }
            case 8: 
            case 520: {
                if (op instanceof Inst1.Orb_reg) {
                    Inst1.Orb_reg o = (Inst1.Orb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ORB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.OrEbGb_mem)) break;
                Inst1.OrEbGb_mem o = (Inst1.OrEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.ORB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 9: {
                if (op instanceof Inst1.Orw_reg) {
                    Inst1.Orw_reg o = (Inst1.Orw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ORW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.OrEwGw_mem)) break;
                Inst1.OrEwGw_mem o = (Inst1.OrEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.ORW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 10: 
            case 522: {
                if (op instanceof Inst1.Orb_reg) {
                    Inst1.Orb_reg o = (Inst1.Orb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ORB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.OrGbEb_mem)) break;
                Inst1.OrGbEb_mem o = (Inst1.OrGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.ORB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 11: {
                if (op instanceof Inst1.Orw_reg) {
                    Inst1.Orw_reg o = (Inst1.Orw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ORW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.OrGwEw_mem)) break;
                Inst1.OrGwEw_mem o = (Inst1.OrGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.ORW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 12: 
            case 524: {
                if (!(op instanceof Inst1.OrAlIb)) break;
                Inst1.OrAlIb o = (Inst1.OrAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.ORB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 13: {
                if (!(op instanceof Inst1.OrAxIw)) break;
                Inst1.OrAxIw o = (Inst1.OrAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.ORW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 14: {
                if (!(op instanceof Inst1.PushCS)) break;
                Inst1.PushCS o = (Inst1.PushCS)op;
                method.append("CPU.CPU_Push16(CPU.Segs_CSval);");
                return true;
            }
            case 15: 
            case 527: {
                break;
            }
            case 16: 
            case 528: {
                if (op instanceof Inst1.Adcb_reg) {
                    Inst1.Adcb_reg o = (Inst1.Adcb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ADCB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AdcEbGb_mem)) break;
                Inst1.AdcEbGb_mem o = (Inst1.AdcEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.ADCB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 17: {
                if (op instanceof Inst1.Adcw_reg) {
                    Inst1.Adcw_reg o = (Inst1.Adcw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ADCW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AdcEwGw_mem)) break;
                Inst1.AdcEwGw_mem o = (Inst1.AdcEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.ADCW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 18: 
            case 530: {
                if (op instanceof Inst1.Adcb_reg) {
                    Inst1.Adcb_reg o = (Inst1.Adcb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ADCB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AdcGbEb_mem)) break;
                Inst1.AdcGbEb_mem o = (Inst1.AdcGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.ADCB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 19: {
                if (op instanceof Inst1.Adcw_reg) {
                    Inst1.Adcw_reg o = (Inst1.Adcw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ADCW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AdcGwEw_mem)) break;
                Inst1.AdcGwEw_mem o = (Inst1.AdcGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.ADCW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 20: 
            case 532: {
                if (!(op instanceof Inst1.AdcAlIb)) break;
                Inst1.AdcAlIb o = (Inst1.AdcAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.ADCB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 21: {
                if (!(op instanceof Inst1.AdcAxIw)) break;
                Inst1.AdcAxIw o = (Inst1.AdcAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.ADCW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 22: {
                if (!(op instanceof Inst1.PushSS)) break;
                Inst1.PushSS o = (Inst1.PushSS)op;
                method.append("CPU.CPU_Push16(CPU.Segs_SSval);");
                return true;
            }
            case 23: {
                if (!(op instanceof Inst1.PopSS)) break;
                Inst1.PopSS o = (Inst1.PopSS)op;
                method.append("if (CPU.CPU_PopSegSS(false)) return RUNEXCEPTION();Core.base_ss=CPU.Segs_SSphys;");
                return true;
            }
            case 24: 
            case 536: {
                if (op instanceof Inst1.Sbbb_reg) {
                    Inst1.Sbbb_reg o = (Inst1.Sbbb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.SBBB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SbbEbGb_mem)) break;
                Inst1.SbbEbGb_mem o = (Inst1.SbbEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.SBBB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 25: {
                if (op instanceof Inst1.Sbbw_reg) {
                    Inst1.Sbbw_reg o = (Inst1.Sbbw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.SBBW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SbbEwGw_mem)) break;
                Inst1.SbbEwGw_mem o = (Inst1.SbbEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.SBBW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 26: 
            case 538: {
                if (op instanceof Inst1.Sbbb_reg) {
                    Inst1.Sbbb_reg o = (Inst1.Sbbb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.SBBB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SbbGbEb_mem)) break;
                Inst1.SbbGbEb_mem o = (Inst1.SbbGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.SBBB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 27: {
                if (op instanceof Inst1.Sbbw_reg) {
                    Inst1.Sbbw_reg o = (Inst1.Sbbw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.SBBW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SbbGwEw_mem)) break;
                Inst1.SbbGwEw_mem o = (Inst1.SbbGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.SBBW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 28: 
            case 540: {
                if (!(op instanceof Inst1.SbbAlIb)) break;
                Inst1.SbbAlIb o = (Inst1.SbbAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.SBBB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 29: {
                if (!(op instanceof Inst1.SbbAxIw)) break;
                Inst1.SbbAxIw o = (Inst1.SbbAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.SBBW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 30: {
                if (!(op instanceof Inst1.PushDS)) break;
                Inst1.PushDS o = (Inst1.PushDS)op;
                method.append("CPU.CPU_Push16(CPU.Segs_DSval);");
                return true;
            }
            case 31: {
                if (!(op instanceof Inst1.PopDS)) break;
                Inst1.PopDS o = (Inst1.PopDS)op;
                method.append("if (CPU.CPU_PopSegDS(false)) return RUNEXCEPTION();Core.base_ds=CPU.Segs_DSphys;Core.base_val_ds= CPU_Regs.ds;");
                return true;
            }
            case 32: 
            case 544: {
                if (op instanceof Inst1.Andb_reg) {
                    Inst1.Andb_reg o = (Inst1.Andb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ANDB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AndEbGb_mem)) break;
                Inst1.AndEbGb_mem o = (Inst1.AndEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.ANDB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 33: {
                if (op instanceof Inst1.Andw_reg) {
                    Inst1.Andw_reg o = (Inst1.Andw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ANDW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AndEwGw_mem)) break;
                Inst1.AndEwGw_mem o = (Inst1.AndEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.ANDW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 34: 
            case 546: {
                if (op instanceof Inst1.Andb_reg) {
                    Inst1.Andb_reg o = (Inst1.Andb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.ANDB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AndGbEb_mem)) break;
                Inst1.AndGbEb_mem o = (Inst1.AndGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.ANDB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 35: {
                if (op instanceof Inst1.Andw_reg) {
                    Inst1.Andw_reg o = (Inst1.Andw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.ANDW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.AndGwEw_mem)) break;
                Inst1.AndGwEw_mem o = (Inst1.AndGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.ANDW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 36: 
            case 548: {
                if (!(op instanceof Inst1.AndAlIb)) break;
                Inst1.AndAlIb o = (Inst1.AndAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.ANDB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 37: {
                if (!(op instanceof Inst1.AndAxIw)) break;
                Inst1.AndAxIw o = (Inst1.AndAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.ANDW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 38: 
            case 550: {
                if (!(op instanceof Inst1.SegES)) break;
                Inst1.SegES o = (Inst1.SegES)op;
                method.append("Core.DO_PREFIX_SEG_ES();");
                return true;
            }
            case 39: 
            case 551: {
                if (!(op instanceof Inst1.Daa)) break;
                Inst1.Daa o = (Inst1.Daa)op;
                method.append("Instructions.DAA();");
                return true;
            }
            case 40: 
            case 552: {
                if (op instanceof Inst1.Subb_reg) {
                    Inst1.Subb_reg o = (Inst1.Subb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.SUBB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SubEbGb_mem)) break;
                Inst1.SubEbGb_mem o = (Inst1.SubEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.SUBB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 41: {
                if (op instanceof Inst1.Subw_reg) {
                    Inst1.Subw_reg o = (Inst1.Subw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.SUBW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SubEwGw_mem)) break;
                Inst1.SubEwGw_mem o = (Inst1.SubEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.SUBW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 42: 
            case 554: {
                if (op instanceof Inst1.Subb_reg) {
                    Inst1.Subb_reg o = (Inst1.Subb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.SUBB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SubGbEb_mem)) break;
                Inst1.SubGbEb_mem o = (Inst1.SubGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.SUBB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 43: {
                if (op instanceof Inst1.Subw_reg) {
                    Inst1.Subw_reg o = (Inst1.Subw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.SUBW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.SubGwEw_mem)) break;
                Inst1.SubGwEw_mem o = (Inst1.SubGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.SUBW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 44: 
            case 556: {
                if (!(op instanceof Inst1.SubAlIb)) break;
                Inst1.SubAlIb o = (Inst1.SubAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.SUBB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 45: {
                if (!(op instanceof Inst1.SubAxIw)) break;
                Inst1.SubAxIw o = (Inst1.SubAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.SUBW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 46: 
            case 558: {
                if (!(op instanceof Inst1.SegCS)) break;
                Inst1.SegCS o = (Inst1.SegCS)op;
                method.append("Core.DO_PREFIX_SEG_CS();");
                return true;
            }
            case 47: 
            case 559: {
                if (!(op instanceof Inst1.Das)) break;
                Inst1.Das o = (Inst1.Das)op;
                method.append("Instructions.DAS();");
                return true;
            }
            case 48: 
            case 560: {
                if (op instanceof Inst1.Xorb_reg) {
                    Inst1.Xorb_reg o = (Inst1.Xorb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.XORB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.XorEbGb_mem)) break;
                Inst1.XorEbGb_mem o = (Inst1.XorEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.XORB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa)));");
                return true;
            }
            case 49: {
                if (op instanceof Inst1.Xorw_reg) {
                    Inst1.Xorw_reg o = (Inst1.Xorw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.XORW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.XorEwGw_mem)) break;
                Inst1.XorEwGw_mem o = (Inst1.XorEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writew(eaa, Instructions.XORW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 50: 
            case 562: {
                if (op instanceof Inst1.Xorb_reg) {
                    Inst1.Xorb_reg o = (Inst1.Xorb_reg)op;
                    method.append(Compiler.nameSet8(o.e, "Instructions.XORB(" + Compiler.nameGet8(o.g) + ", " + Compiler.nameGet8(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.XorGbEb_mem)) break;
                Inst1.XorGbEb_mem o = (Inst1.XorGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.e, "Instructions.XORB(Memory.mem_readb(eaa), " + Compiler.nameGet8(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 51: {
                if (op instanceof Inst1.Xorw_reg) {
                    Inst1.Xorw_reg o = (Inst1.Xorw_reg)op;
                    method.append(Compiler.nameSet16(o.e, "Instructions.XORW(" + Compiler.nameGet16(o.g) + ", " + Compiler.nameGet16(o.e) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.XorGwEw_mem)) break;
                Inst1.XorGwEw_mem o = (Inst1.XorGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.e, "Instructions.XORW(Memory.mem_readw(eaa), " + Compiler.nameGet16(o.e) + ")"));
                method.append(";");
                return true;
            }
            case 52: 
            case 564: {
                if (!(op instanceof Inst1.XorAlIb)) break;
                Inst1.XorAlIb o = (Inst1.XorAlIb)op;
                method.append("CPU_Regs.reg_eax.low(Instructions.XORB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low()));");
                return true;
            }
            case 53: {
                if (!(op instanceof Inst1.XorAxIw)) break;
                Inst1.XorAxIw o = (Inst1.XorAxIw)op;
                method.append("CPU_Regs.reg_eax.word(Instructions.XORW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word()));");
                return true;
            }
            case 54: 
            case 566: {
                if (!(op instanceof Inst1.SegSS)) break;
                Inst1.SegSS o = (Inst1.SegSS)op;
                method.append("Core.DO_PREFIX_SEG_SS();");
                return true;
            }
            case 55: 
            case 567: {
                if (!(op instanceof Inst1.Aaa)) break;
                Inst1.Aaa o = (Inst1.Aaa)op;
                method.append("Instructions.AAA();");
                return true;
            }
            case 56: 
            case 568: {
                if (op instanceof Inst1.Cmpb_reg) {
                    Inst1.Cmpb_reg o = (Inst1.Cmpb_reg)op;
                    method.append("Instructions.CMPB(");
                    method.append(Compiler.nameGet8(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet8(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.CmpEbGb_mem)) break;
                Inst1.CmpEbGb_mem o = (Inst1.CmpEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Instructions.CMPB(");
                method.append(Compiler.nameGet8(o.g));
                method.append(", Memory.mem_readb(eaa));");
                return true;
            }
            case 57: {
                if (op instanceof Inst1.Cmpw_reg) {
                    Inst1.Cmpw_reg o = (Inst1.Cmpw_reg)op;
                    method.append("Instructions.CMPW(");
                    method.append(Compiler.nameGet16(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet16(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.CmpEwGw_mem)) break;
                Inst1.CmpEwGw_mem o = (Inst1.CmpEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.e, method);
                method.append(";Instructions.CMPW(");
                method.append(Compiler.nameGet16(o.g));
                method.append(", Memory.mem_readw(eaa));");
                return true;
            }
            case 58: 
            case 570: {
                if (op instanceof Inst1.Cmpb_reg) {
                    Inst1.Cmpb_reg o = (Inst1.Cmpb_reg)op;
                    method.append("Instructions.CMPB(");
                    method.append(Compiler.nameGet8(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet8(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.CmpGbEb_mem)) break;
                Inst1.CmpGbEb_mem o = (Inst1.CmpGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";Instructions.CMPB(Memory.mem_readb(eaa), ");
                method.append(Compiler.nameGet8(o.e));
                method.append(");");
                return true;
            }
            case 59: {
                if (op instanceof Inst1.Cmpw_reg) {
                    Inst1.Cmpw_reg o = (Inst1.Cmpw_reg)op;
                    method.append("Instructions.CMPW(");
                    method.append(Compiler.nameGet16(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet16(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.CmpGwEw_mem)) break;
                Inst1.CmpGwEw_mem o = (Inst1.CmpGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";Instructions.CMPW(Memory.mem_readw(eaa), ");
                method.append(Compiler.nameGet16(o.e));
                method.append(");");
                return true;
            }
            case 60: 
            case 572: {
                if (!(op instanceof Inst1.CmpAlIb)) break;
                Inst1.CmpAlIb o = (Inst1.CmpAlIb)op;
                method.append("Instructions.CMPB((short)");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.low());");
                return true;
            }
            case 61: {
                if (!(op instanceof Inst1.CmpAxIw)) break;
                Inst1.CmpAxIw o = (Inst1.CmpAxIw)op;
                method.append("Instructions.CMPW(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.word());");
                return true;
            }
            case 62: 
            case 574: {
                if (!(op instanceof Inst1.SegDS)) break;
                Inst1.SegDS o = (Inst1.SegDS)op;
                method.append("Core.DO_PREFIX_SEG_DS();");
                return true;
            }
            case 63: 
            case 575: {
                if (!(op instanceof Inst1.Aas)) break;
                Inst1.Aas o = (Inst1.Aas)op;
                method.append("Instructions.AAS();");
                return true;
            }
            case 64: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 65: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 66: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 67: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 68: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 69: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 70: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 71: {
                if (!(op instanceof Inst1.Incw)) break;
                Inst1.Incw o = (Inst1.Incw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 72: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 73: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 74: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 75: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 76: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 77: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 78: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 79: {
                if (!(op instanceof Inst1.Decw)) break;
                Inst1.Decw o = (Inst1.Decw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 80: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 81: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 82: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 83: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 84: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 85: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 86: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 87: {
                if (!(op instanceof Inst1.Pushw)) break;
                Inst1.Pushw o = (Inst1.Pushw)op;
                method.append("CPU.CPU_Push16(");
                method.append(Compiler.nameGet16(o.reg));
                method.append(");");
                return true;
            }
            case 88: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 89: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 90: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 91: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 92: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 93: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 94: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 95: {
                if (!(op instanceof Inst1.Popw)) break;
                Inst1.Popw o = (Inst1.Popw)op;
                method.append(Compiler.nameSet16(o.reg, "CPU.CPU_Pop16()"));
                method.append(";");
                return true;
            }
            case 96: {
                if (!(op instanceof Inst1.Pusha)) break;
                Inst1.Pusha o = (Inst1.Pusha)op;
                method.append("int old_sp=CPU_Regs.reg_esp.word();CPU.CPU_Push16(CPU_Regs.reg_eax.word());CPU.CPU_Push16(CPU_Regs.reg_ecx.word());CPU.CPU_Push16(CPU_Regs.reg_edx.word());CPU.CPU_Push16(CPU_Regs.reg_ebx.word());CPU.CPU_Push16(old_sp);CPU.CPU_Push16(CPU_Regs.reg_ebp.word());CPU.CPU_Push16(CPU_Regs.reg_esi.word());CPU.CPU_Push16(CPU_Regs.reg_edi.word());");
                return true;
            }
            case 97: {
                if (!(op instanceof Inst1.Popa)) break;
                Inst1.Popa o = (Inst1.Popa)op;
                method.append("CPU_Regs.reg_edi.word(CPU.CPU_Pop16());CPU_Regs.reg_esi.word(CPU.CPU_Pop16());CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());CPU.CPU_Pop16();CPU_Regs.reg_ebx.word(CPU.CPU_Pop16());CPU_Regs.reg_edx.word(CPU.CPU_Pop16());CPU_Regs.reg_ecx.word(CPU.CPU_Pop16());CPU_Regs.reg_eax.word(CPU.CPU_Pop16());");
                return true;
            }
            case 98: {
                if (!(op instanceof Inst1.Bound)) break;
                Inst1.Bound o = (Inst1.Bound)op;
                method.append("short r = (short)");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";short bound_min, bound_max;int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";bound_min=(short)Memory.mem_readw(eaa); bound_max=(short)Memory.mem_readw(eaa+2);if ( (r < bound_min) || (r > bound_max) ) {return EXCEPTION(5);}");
                return true;
            }
            case 99: {
                if (op instanceof Inst1.ArplEwRw_reg) {
                    Inst1.ArplEwRw_reg o = (Inst1.ArplEwRw_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;IntRef ref = new IntRef(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");CPU.CPU_ARPL(ref,");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(");");
                    method.append(Compiler.nameSet16(o.earw, "ref.value"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.ArplEwRw_mem)) break;
                Inst1.ArplEwRw_mem o = (Inst1.ArplEwRw_mem)op;
                method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;");
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";IntRef ref = new IntRef(Memory.mem_readw(eaa));CPU.CPU_ARPL(ref,");
                method.append(Compiler.nameGet16(o.rw));
                method.append(");Memory.mem_writew(eaa,ref.value);");
                return true;
            }
            case 100: 
            case 612: {
                if (!(op instanceof Inst1.SegFS)) break;
                Inst1.SegFS o = (Inst1.SegFS)op;
                method.append("Core.DO_PREFIX_SEG_FS();");
                return true;
            }
            case 101: 
            case 613: {
                if (!(op instanceof Inst1.SegGS)) break;
                Inst1.SegGS o = (Inst1.SegGS)op;
                method.append("Core.DO_PREFIX_SEG_GS();");
                return true;
            }
            case 102: 
            case 614: {
                break;
            }
            case 103: 
            case 615: {
                break;
            }
            case 104: {
                if (!(op instanceof Inst1.Push16)) break;
                Inst1.Push16 o = (Inst1.Push16)op;
                method.append("CPU.CPU_Push16(");
                method.append(o.value);
                method.append(");");
                return true;
            }
            case 105: {
                if (op instanceof Inst1.IMULGwEwIw_reg) {
                    Inst1.IMULGwEwIw_reg o = (Inst1.IMULGwEwIw_reg)op;
                    method.append(Compiler.nameSet16(o.rw, "Instructions.DIMULW(" + Compiler.nameGet16(o.earw) + ", " + o.op3 + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.IMULGwEwIw_mem)) break;
                Inst1.IMULGwEwIw_mem o = (Inst1.IMULGwEwIw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "Instructions.DIMULW(Memory.mem_readw(eaa)," + o.op3 + ")"));
                method.append(";");
                return true;
            }
            case 106: {
                if (!(op instanceof Inst1.Push16)) break;
                Inst1.Push16 o = (Inst1.Push16)op;
                method.append("CPU.CPU_Push16(");
                method.append(o.value);
                method.append(");");
                return true;
            }
            case 107: {
                if (op instanceof Inst1.IMULGwEwIb_reg) {
                    Inst1.IMULGwEwIb_reg o = (Inst1.IMULGwEwIb_reg)op;
                    method.append(Compiler.nameSet16(o.rw, "Instructions.DIMULW(" + Compiler.nameGet16(o.earw) + ", " + o.op3 + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.IMULGwEwIb_mem)) break;
                Inst1.IMULGwEwIb_mem o = (Inst1.IMULGwEwIb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "Instructions.DIMULW(Memory.mem_readw(eaa)," + o.op3 + ")"));
                method.append(";");
                return true;
            }
            case 108: 
            case 620: {
                if (!(op instanceof Inst1.DoStringException)) break;
                Inst1.DoStringException o = (Inst1.DoStringException)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),");
                method.append(o.width);
                method.append(")) return RUNEXCEPTION();Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 109: {
                if (!(op instanceof Inst1.DoStringException)) break;
                Inst1.DoStringException o = (Inst1.DoStringException)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),");
                method.append(o.width);
                method.append(")) return RUNEXCEPTION();Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 110: 
            case 622: {
                if (!(op instanceof Inst1.DoStringException)) break;
                Inst1.DoStringException o = (Inst1.DoStringException)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),");
                method.append(o.width);
                method.append(")) return RUNEXCEPTION();Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 111: {
                if (!(op instanceof Inst1.DoStringException)) break;
                Inst1.DoStringException o = (Inst1.DoStringException)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),");
                method.append(o.width);
                method.append(")) return RUNEXCEPTION();Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 112: {
                if (!(op instanceof Inst1.JumpCond16_b_o)) break;
                Inst1.JumpCond16_b_o o = (Inst1.JumpCond16_b_o)op;
                Compiler.compile(o, "Flags.TFLG_O()", method);
                return false;
            }
            case 113: {
                if (!(op instanceof Inst1.JumpCond16_b_no)) break;
                Inst1.JumpCond16_b_no o = (Inst1.JumpCond16_b_no)op;
                Compiler.compile(o, "Flags.TFLG_NO()", method);
                return false;
            }
            case 114: {
                if (!(op instanceof Inst1.JumpCond16_b_b)) break;
                Inst1.JumpCond16_b_b o = (Inst1.JumpCond16_b_b)op;
                Compiler.compile(o, "Flags.TFLG_B()", method);
                return false;
            }
            case 115: {
                if (!(op instanceof Inst1.JumpCond16_b_nb)) break;
                Inst1.JumpCond16_b_nb o = (Inst1.JumpCond16_b_nb)op;
                Compiler.compile(o, "Flags.TFLG_NB()", method);
                return false;
            }
            case 116: {
                if (!(op instanceof Inst1.JumpCond16_b_z)) break;
                Inst1.JumpCond16_b_z o = (Inst1.JumpCond16_b_z)op;
                Compiler.compile(o, "Flags.TFLG_Z()", method);
                return false;
            }
            case 117: {
                if (!(op instanceof Inst1.JumpCond16_b_nz)) break;
                Inst1.JumpCond16_b_nz o = (Inst1.JumpCond16_b_nz)op;
                Compiler.compile(o, "Flags.TFLG_NZ()", method);
                return false;
            }
            case 118: {
                if (!(op instanceof Inst1.JumpCond16_b_be)) break;
                Inst1.JumpCond16_b_be o = (Inst1.JumpCond16_b_be)op;
                Compiler.compile(o, "Flags.TFLG_BE()", method);
                return false;
            }
            case 119: {
                if (!(op instanceof Inst1.JumpCond16_b_nbe)) break;
                Inst1.JumpCond16_b_nbe o = (Inst1.JumpCond16_b_nbe)op;
                Compiler.compile(o, "Flags.TFLG_NBE()", method);
                return false;
            }
            case 120: {
                if (!(op instanceof Inst1.JumpCond16_b_s)) break;
                Inst1.JumpCond16_b_s o = (Inst1.JumpCond16_b_s)op;
                Compiler.compile(o, "Flags.TFLG_S()", method);
                return false;
            }
            case 121: {
                if (!(op instanceof Inst1.JumpCond16_b_ns)) break;
                Inst1.JumpCond16_b_ns o = (Inst1.JumpCond16_b_ns)op;
                Compiler.compile(o, "Flags.TFLG_NS()", method);
                return false;
            }
            case 122: {
                if (!(op instanceof Inst1.JumpCond16_b_p)) break;
                Inst1.JumpCond16_b_p o = (Inst1.JumpCond16_b_p)op;
                Compiler.compile(o, "Flags.TFLG_P()", method);
                return false;
            }
            case 123: {
                if (!(op instanceof Inst1.JumpCond16_b_np)) break;
                Inst1.JumpCond16_b_np o = (Inst1.JumpCond16_b_np)op;
                Compiler.compile(o, "Flags.TFLG_NP()", method);
                return false;
            }
            case 124: {
                if (!(op instanceof Inst1.JumpCond16_b_l)) break;
                Inst1.JumpCond16_b_l o = (Inst1.JumpCond16_b_l)op;
                Compiler.compile(o, "Flags.TFLG_L()", method);
                return false;
            }
            case 125: {
                if (!(op instanceof Inst1.JumpCond16_b_nl)) break;
                Inst1.JumpCond16_b_nl o = (Inst1.JumpCond16_b_nl)op;
                Compiler.compile(o, "Flags.TFLG_NL()", method);
                return false;
            }
            case 126: {
                if (!(op instanceof Inst1.JumpCond16_b_le)) break;
                Inst1.JumpCond16_b_le o = (Inst1.JumpCond16_b_le)op;
                Compiler.compile(o, "Flags.TFLG_LE()", method);
                return false;
            }
            case 127: {
                if (!(op instanceof Inst1.JumpCond16_b_nle)) break;
                Inst1.JumpCond16_b_nle o = (Inst1.JumpCond16_b_nle)op;
                Compiler.compile(o, "Flags.TFLG_NLE()", method);
                return false;
            }
            case 128: 
            case 640: {
                if (op instanceof Inst1.GrplEbIb_reg_add) {
                    Inst1.GrplEbIb_reg_add o = (Inst1.GrplEbIb_reg_add)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.ADDB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_or) {
                    Inst1.GrplEbIb_reg_or o = (Inst1.GrplEbIb_reg_or)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.ORB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_adc) {
                    Inst1.GrplEbIb_reg_adc o = (Inst1.GrplEbIb_reg_adc)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.ADCB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_sbb) {
                    Inst1.GrplEbIb_reg_sbb o = (Inst1.GrplEbIb_reg_sbb)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.SBBB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_and) {
                    Inst1.GrplEbIb_reg_and o = (Inst1.GrplEbIb_reg_and)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.ANDB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_sub) {
                    Inst1.GrplEbIb_reg_sub o = (Inst1.GrplEbIb_reg_sub)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.SUBB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_xor) {
                    Inst1.GrplEbIb_reg_xor o = (Inst1.GrplEbIb_reg_xor)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.XORB((short)" + o.ib + "," + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_reg_cmp) {
                    Inst1.GrplEbIb_reg_cmp o = (Inst1.GrplEbIb_reg_cmp)op;
                    method.append("Instructions.CMPB((short)");
                    method.append(o.ib);
                    method.append(",");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_add) {
                    Inst1.GrplEbIb_mem_add o = (Inst1.GrplEbIb_mem_add)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.ADDB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_or) {
                    Inst1.GrplEbIb_mem_or o = (Inst1.GrplEbIb_mem_or)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.ORB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_adc) {
                    Inst1.GrplEbIb_mem_adc o = (Inst1.GrplEbIb_mem_adc)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.ADCB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_sbb) {
                    Inst1.GrplEbIb_mem_sbb o = (Inst1.GrplEbIb_mem_sbb)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.SBBB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_and) {
                    Inst1.GrplEbIb_mem_and o = (Inst1.GrplEbIb_mem_and)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.ANDB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_sub) {
                    Inst1.GrplEbIb_mem_sub o = (Inst1.GrplEbIb_mem_sub)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.SUBB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEbIb_mem_xor) {
                    Inst1.GrplEbIb_mem_xor o = (Inst1.GrplEbIb_mem_xor)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.XORB((short)");
                    method.append(o.ib);
                    method.append(",Memory.mem_readb(eaa)));");
                    return true;
                }
                if (!(op instanceof Inst1.GrplEbIb_mem_cmp)) break;
                Inst1.GrplEbIb_mem_cmp o = (Inst1.GrplEbIb_mem_cmp)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.CMPB((short)");
                method.append(o.ib);
                method.append(",Memory.mem_readb(eaa));");
                return true;
            }
            case 130: 
            case 642: {
                break;
            }
            case 129: {
                if (op instanceof Inst1.GrplEwIw_reg_add) {
                    Inst1.GrplEwIw_reg_add o = (Inst1.GrplEwIw_reg_add)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ADDW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_or) {
                    Inst1.GrplEwIw_reg_or o = (Inst1.GrplEwIw_reg_or)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ORW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_adc) {
                    Inst1.GrplEwIw_reg_adc o = (Inst1.GrplEwIw_reg_adc)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ADCW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_sbb) {
                    Inst1.GrplEwIw_reg_sbb o = (Inst1.GrplEwIw_reg_sbb)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.SBBW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_and) {
                    Inst1.GrplEwIw_reg_and o = (Inst1.GrplEwIw_reg_and)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ANDW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_sub) {
                    Inst1.GrplEwIw_reg_sub o = (Inst1.GrplEwIw_reg_sub)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.SUBW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_xor) {
                    Inst1.GrplEwIw_reg_xor o = (Inst1.GrplEwIw_reg_xor)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.XORW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_cmp) {
                    Inst1.GrplEwIw_reg_cmp o = (Inst1.GrplEwIw_reg_cmp)op;
                    method.append("Instructions.CMPW(");
                    method.append(o.ib);
                    method.append(",");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_add) {
                    Inst1.GrplEwIw_mem_add o = (Inst1.GrplEwIw_mem_add)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ADDW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_or) {
                    Inst1.GrplEwIw_mem_or o = (Inst1.GrplEwIw_mem_or)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ORW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_adc) {
                    Inst1.GrplEwIw_mem_adc o = (Inst1.GrplEwIw_mem_adc)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ADCW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_sbb) {
                    Inst1.GrplEwIw_mem_sbb o = (Inst1.GrplEwIw_mem_sbb)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.SBBW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_and) {
                    Inst1.GrplEwIw_mem_and o = (Inst1.GrplEwIw_mem_and)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ANDW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_sub) {
                    Inst1.GrplEwIw_mem_sub o = (Inst1.GrplEwIw_mem_sub)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.SUBW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_xor) {
                    Inst1.GrplEwIw_mem_xor o = (Inst1.GrplEwIw_mem_xor)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.XORW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (!(op instanceof Inst1.GrplEwIw_mem_cmp)) break;
                Inst1.GrplEwIw_mem_cmp o = (Inst1.GrplEwIw_mem_cmp)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.CMPW(");
                method.append(o.ib);
                method.append(",Memory.mem_readw(eaa));");
                return true;
            }
            case 131: {
                if (op instanceof Inst1.GrplEwIw_reg_add) {
                    Inst1.GrplEwIw_reg_add o = (Inst1.GrplEwIw_reg_add)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ADDW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_or) {
                    Inst1.GrplEwIw_reg_or o = (Inst1.GrplEwIw_reg_or)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ORW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_adc) {
                    Inst1.GrplEwIw_reg_adc o = (Inst1.GrplEwIw_reg_adc)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ADCW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_sbb) {
                    Inst1.GrplEwIw_reg_sbb o = (Inst1.GrplEwIw_reg_sbb)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.SBBW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_and) {
                    Inst1.GrplEwIw_reg_and o = (Inst1.GrplEwIw_reg_and)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.ANDW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_sub) {
                    Inst1.GrplEwIw_reg_sub o = (Inst1.GrplEwIw_reg_sub)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.SUBW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_xor) {
                    Inst1.GrplEwIw_reg_xor o = (Inst1.GrplEwIw_reg_xor)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.XORW(" + o.ib + "," + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_reg_cmp) {
                    Inst1.GrplEwIw_reg_cmp o = (Inst1.GrplEwIw_reg_cmp)op;
                    method.append("Instructions.CMPW(");
                    method.append(o.ib);
                    method.append(",");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_add) {
                    Inst1.GrplEwIw_mem_add o = (Inst1.GrplEwIw_mem_add)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ADDW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_or) {
                    Inst1.GrplEwIw_mem_or o = (Inst1.GrplEwIw_mem_or)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ORW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_adc) {
                    Inst1.GrplEwIw_mem_adc o = (Inst1.GrplEwIw_mem_adc)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ADCW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_sbb) {
                    Inst1.GrplEwIw_mem_sbb o = (Inst1.GrplEwIw_mem_sbb)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.SBBW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_and) {
                    Inst1.GrplEwIw_mem_and o = (Inst1.GrplEwIw_mem_and)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.ANDW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_sub) {
                    Inst1.GrplEwIw_mem_sub o = (Inst1.GrplEwIw_mem_sub)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.SUBW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.GrplEwIw_mem_xor) {
                    Inst1.GrplEwIw_mem_xor o = (Inst1.GrplEwIw_mem_xor)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.XORW(");
                    method.append(o.ib);
                    method.append(",Memory.mem_readw(eaa)));");
                    return true;
                }
                if (!(op instanceof Inst1.GrplEwIw_mem_cmp)) break;
                Inst1.GrplEwIw_mem_cmp o = (Inst1.GrplEwIw_mem_cmp)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.CMPW(");
                method.append(o.ib);
                method.append(",Memory.mem_readw(eaa));");
                return true;
            }
            case 132: 
            case 644: {
                if (op instanceof Inst1.TestEbGb_reg) {
                    Inst1.TestEbGb_reg o = (Inst1.TestEbGb_reg)op;
                    method.append("Instructions.TESTB(");
                    method.append(Compiler.nameGet8(o.rb));
                    method.append(",");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.TestEbGb_mem)) break;
                Inst1.TestEbGb_mem o = (Inst1.TestEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.TESTB(");
                method.append(Compiler.nameGet8(o.rb));
                method.append(",Memory.mem_readb(eaa));");
                return true;
            }
            case 133: {
                if (op instanceof Inst1.TestEwGw_reg) {
                    Inst1.TestEwGw_reg o = (Inst1.TestEwGw_reg)op;
                    method.append("Instructions.TESTW(");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(",");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.TestEwGw_mem)) break;
                Inst1.TestEwGw_mem o = (Inst1.TestEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.TESTW(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(",Memory.mem_readw(eaa));");
                return true;
            }
            case 134: 
            case 646: {
                if (op instanceof Inst1.XchgEbGb_reg) {
                    Inst1.XchgEbGb_reg o = (Inst1.XchgEbGb_reg)op;
                    method.append("short oldrmrb = ");
                    method.append(Compiler.nameGet8(o.rb));
                    method.append(";");
                    method.append(Compiler.nameSet8(o.rb, Compiler.nameGet8(o.earb)));
                    method.append(";");
                    method.append(Compiler.nameSet8(o.earb, "oldrmrb"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.XchgEbGb_mem)) break;
                Inst1.XchgEbGb_mem o = (Inst1.XchgEbGb_mem)op;
                method.append("short oldrmrb = ");
                method.append(Compiler.nameGet8(o.rb));
                method.append(";int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";short newrb = Memory.mem_readb(eaa);Memory.mem_writeb(eaa,oldrmrb);");
                method.append(Compiler.nameSet8(o.rb, "newrb"));
                method.append(";");
                return true;
            }
            case 135: {
                if (op instanceof Inst1.XchgEwGw_reg) {
                    Inst1.XchgEwGw_reg o = (Inst1.XchgEwGw_reg)op;
                    method.append("int oldrmrw = ");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(";");
                    method.append(Compiler.nameSet16(o.rw, Compiler.nameGet16(o.earw)));
                    method.append(";");
                    method.append(Compiler.nameSet16(o.earw, "oldrmrw"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.XchgEwGw_mem)) break;
                Inst1.XchgEwGw_mem o = (Inst1.XchgEwGw_mem)op;
                method.append("int oldrmrw = ");
                method.append(Compiler.nameGet16(o.rw));
                method.append(";int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int newrw = Memory.mem_readw(eaa);Memory.mem_writew(eaa,oldrmrw);");
                method.append(Compiler.nameSet16(o.rw, "newrw"));
                method.append(";");
                return true;
            }
            case 136: 
            case 648: {
                if (op instanceof Inst1.MovEbGb_reg) {
                    Inst1.MovEbGb_reg o = (Inst1.MovEbGb_reg)op;
                    method.append(Compiler.nameSet8(o.earb, Compiler.nameGet8(o.rb)));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.MovEbGb_mem_5) {
                    Inst1.MovEbGb_mem_5 o = (Inst1.MovEbGb_mem_5)op;
                    method.append("if (CPU.cpu.pmode && !CPU.cpu.code.big) {jdos.cpu.CPU.Descriptor desc=new jdos.cpu.CPU.Descriptor();CPU.cpu.gdt.GetDescriptor(CPU.seg_value(Core.base_val_ds),desc);if ((desc.Type()==CPU.DESC_CODE_R_NC_A) || (desc.Type()==CPU.DESC_CODE_R_NC_NA)) {CPU.CPU_Exception(CPU.EXCEPTION_GP,CPU.seg_value(Core.base_val_ds) & 0xfffc);return Constants.BR_Jump;}}");
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa,");
                    method.append(Compiler.nameGet8(o.rb));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.MovEbGb_mem)) break;
                Inst1.MovEbGb_mem o = (Inst1.MovEbGb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writeb(eaa,");
                method.append(Compiler.nameGet8(o.rb));
                method.append(");");
                return true;
            }
            case 137: {
                if (op instanceof Inst1.MovEwGw_reg) {
                    Inst1.MovEwGw_reg o = (Inst1.MovEwGw_reg)op;
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.rw)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.MovEwGw_mem)) break;
                Inst1.MovEwGw_mem o = (Inst1.MovEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa,");
                method.append(Compiler.nameGet16(o.rw));
                method.append(");");
                return true;
            }
            case 138: 
            case 650: {
                if (op instanceof Inst1.MovGbEb_reg) {
                    Inst1.MovGbEb_reg o = (Inst1.MovGbEb_reg)op;
                    method.append(Compiler.nameSet8(o.rb, Compiler.nameGet8(o.earb)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.MovGbEb_mem)) break;
                Inst1.MovGbEb_mem o = (Inst1.MovGbEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet8(o.rb, "Memory.mem_readb(eaa)"));
                method.append(";");
                return true;
            }
            case 139: {
                if (op instanceof Inst1.MovGwEw_reg) {
                    Inst1.MovGwEw_reg o = (Inst1.MovGwEw_reg)op;
                    method.append(Compiler.nameSet16(o.rw, Compiler.nameGet16(o.earw)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.MovGwEw_mem)) break;
                Inst1.MovGwEw_mem o = (Inst1.MovGwEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";");
                return true;
            }
            case 140: {
                if (op instanceof Inst1.MovEwEs_reg) {
                    Inst1.MovEwEs_reg o = (Inst1.MovEwEs_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.Segs_ESval"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.MovEwEs_mem) {
                    Inst1.MovEwEs_mem o = (Inst1.MovEwEs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_ESval);");
                    return true;
                }
                if (op instanceof Inst1.MovEwCs_reg) {
                    Inst1.MovEwCs_reg o = (Inst1.MovEwCs_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.Segs_CSval"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.MovEwCs_mem) {
                    Inst1.MovEwCs_mem o = (Inst1.MovEwCs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_CSval);");
                    return true;
                }
                if (op instanceof Inst1.MovEwSs_reg) {
                    Inst1.MovEwSs_reg o = (Inst1.MovEwSs_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.Segs_SSval"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.MovEwSs_mem) {
                    Inst1.MovEwSs_mem o = (Inst1.MovEwSs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_SSval);");
                    return true;
                }
                if (op instanceof Inst1.MovEwDs_reg) {
                    Inst1.MovEwDs_reg o = (Inst1.MovEwDs_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.Segs_DSval"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.MovEwDs_mem) {
                    Inst1.MovEwDs_mem o = (Inst1.MovEwDs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_DSval);");
                    return true;
                }
                if (op instanceof Inst1.MovEwFs_reg) {
                    Inst1.MovEwFs_reg o = (Inst1.MovEwFs_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.Segs_FSval"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.MovEwFs_mem) {
                    Inst1.MovEwFs_mem o = (Inst1.MovEwFs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_FSval);");
                    return true;
                }
                if (op instanceof Inst1.MovEwGs_reg) {
                    Inst1.MovEwGs_reg o = (Inst1.MovEwGs_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.Segs_GSval"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.MovEwGs_mem)) break;
                Inst1.MovEwGs_mem o = (Inst1.MovEwGs_mem)op;
                method.append("Memory.mem_writew(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", CPU.Segs_GSval);");
                return true;
            }
            case 141: {
                if (op instanceof Inst1.LeaGw_32) {
                    Inst1.LeaGw_32 o = (Inst1.LeaGw_32)op;
                    method.append("Core.base_ds=Core.base_ss=0;int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";");
                    method.append(Compiler.nameSet16(o.rw, "eaa"));
                    method.append(";Core.base_ds=CPU.Segs_DSphys;Core.base_ss=CPU.Segs_SSphys;");
                    return true;
                }
                if (!(op instanceof Inst1.LeaGw_16)) break;
                Inst1.LeaGw_16 o = (Inst1.LeaGw_16)op;
                method.append("Core.base_ds=Core.base_ss=0;int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "eaa"));
                method.append(";Core.base_ds=CPU.Segs_DSphys;Core.base_ss=CPU.Segs_SSphys;");
                return true;
            }
            case 142: 
            case 654: {
                if (op instanceof Inst1.MovEsEw_reg) {
                    Inst1.MovEsEw_reg o = (Inst1.MovEsEw_reg)op;
                    method.append("if (CPU.CPU_SetSegGeneralES(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst1.MovEsEw_mem) {
                    Inst1.MovEsEw_mem o = (Inst1.MovEsEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst1.MovSsEw_reg) {
                    Inst1.MovSsEw_reg o = (Inst1.MovSsEw_reg)op;
                    method.append("if (CPU.CPU_SetSegGeneralSS(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();Core.base_ss=CPU.Segs_SSphys;");
                    return true;
                }
                if (op instanceof Inst1.MovSsEw_mem) {
                    Inst1.MovSsEw_mem o = (Inst1.MovSsEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa))) return RUNEXCEPTION();Core.base_ss=CPU.Segs_SSphys;");
                    return true;
                }
                if (op instanceof Inst1.MovDsEw_reg) {
                    Inst1.MovDsEw_reg o = (Inst1.MovDsEw_reg)op;
                    method.append("if (CPU.CPU_SetSegGeneralDS(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();Core.base_ds=CPU.Segs_DSphys;Core.base_val_ds= CPU_Regs.ds;");
                    return true;
                }
                if (op instanceof Inst1.MovDsEw_mem) {
                    Inst1.MovDsEw_mem o = (Inst1.MovDsEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa))) return RUNEXCEPTION();Core.base_ds=CPU.Segs_DSphys;Core.base_val_ds= CPU_Regs.ds;");
                    return true;
                }
                if (op instanceof Inst1.MovFsEw_reg) {
                    Inst1.MovFsEw_reg o = (Inst1.MovFsEw_reg)op;
                    method.append("if (CPU.CPU_SetSegGeneralFS(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst1.MovFsEw_mem) {
                    Inst1.MovFsEw_mem o = (Inst1.MovFsEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst1.MovGsEw_reg) {
                    Inst1.MovGsEw_reg o = (Inst1.MovGsEw_reg)op;
                    method.append("if (CPU.CPU_SetSegGeneralGS(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();");
                    return true;
                }
                if (!(op instanceof Inst1.MovGsEw_mem)) break;
                Inst1.MovGsEw_mem o = (Inst1.MovGsEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                return true;
            }
            case 143: {
                if (op instanceof Inst1.PopEw_reg) {
                    Inst1.PopEw_reg o = (Inst1.PopEw_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.CPU_Pop16()"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.PopEw_mem)) break;
                Inst1.PopEw_mem o = (Inst1.PopEw_mem)op;
                method.append("int val = CPU.CPU_Pop16();int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa, val);");
                return true;
            }
            case 144: 
            case 656: {
                if (!(op instanceof Inst1.Noop)) break;
                Inst1.Noop o = (Inst1.Noop)op;
                return true;
            }
            case 145: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 146: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 147: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 148: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 149: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 150: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 151: {
                if (!(op instanceof Inst1.XchgAx)) break;
                Inst1.XchgAx o = (Inst1.XchgAx)op;
                method.append("int old = ");
                method.append(Compiler.nameGet16(o.reg));
                method.append(";");
                method.append(Compiler.nameSet16(o.reg, "CPU_Regs.reg_eax.word()"));
                method.append(";CPU_Regs.reg_eax.word(old);");
                return true;
            }
            case 152: {
                if (!(op instanceof Inst1.Cbw)) break;
                Inst1.Cbw o = (Inst1.Cbw)op;
                method.append("CPU_Regs.reg_eax.word((byte)CPU_Regs.reg_eax.low());");
                return true;
            }
            case 153: {
                if (!(op instanceof Inst1.Cwd)) break;
                Inst1.Cwd o = (Inst1.Cwd)op;
                method.append("if ((CPU_Regs.reg_eax.word() & 0x8000)!=0) CPU_Regs.reg_edx.word(0xffff);else CPU_Regs.reg_edx.word(0);");
                return true;
            }
            case 154: {
                if (!(op instanceof Inst1.CallAp)) break;
                Inst1.CallAp o = (Inst1.CallAp)op;
                method.append("Flags.FillFlags();CPU.CPU_CALL(false,");
                method.append(o.newcs);
                method.append(",");
                method.append(o.newip);
                method.append(", CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 155: {
                break;
            }
            case 667: {
                break;
            }
            case 156: {
                if (!(op instanceof Inst1.PushF)) break;
                Inst1.PushF o = (Inst1.PushF)op;
                method.append("if (CPU.CPU_PUSHF(false)) return RUNEXCEPTION();");
                return true;
            }
            case 157: {
                if (!(op instanceof Inst1.PopF)) break;
                Inst1.PopF o = (Inst1.PopF)op;
                method.append("if (CPU.CPU_POPF(false)) return RUNEXCEPTION();");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return DECODE_END(");
                method.append(o.eip_count);
                method.append(");}");
                method.append(" if (CPU_Regs.GETFLAG(CPU_Regs.IF)!=0 && Pic.PIC_IRQCheck!=0) return DECODE_END(");
                method.append(o.eip_count);
                method.append(");");
                return true;
            }
            case 158: 
            case 670: {
                if (!(op instanceof Inst1.Sahf)) break;
                Inst1.Sahf o = (Inst1.Sahf)op;
                method.append("Flags.SETFLAGSb(CPU_Regs.reg_eax.high());");
                return true;
            }
            case 159: 
            case 671: {
                if (!(op instanceof Inst1.Lahf)) break;
                Inst1.Lahf o = (Inst1.Lahf)op;
                method.append("Flags.FillFlags();CPU_Regs.reg_eax.high(CPU_Regs.flags & 0xff);");
                return true;
            }
            case 160: 
            case 672: {
                if (!(op instanceof Inst1.MovALOb)) break;
                Inst1.MovALOb o = (Inst1.MovALOb)op;
                method.append("CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds+");
                method.append(o.value);
                method.append("));");
                return true;
            }
            case 161: {
                if (!(op instanceof Inst1.MovAXOw)) break;
                Inst1.MovAXOw o = (Inst1.MovAXOw)op;
                method.append("CPU_Regs.reg_eax.word(Memory.mem_readw(Core.base_ds+");
                method.append(o.value);
                method.append("));");
                return true;
            }
            case 162: 
            case 674: {
                if (!(op instanceof Inst1.MovObAL)) break;
                Inst1.MovObAL o = (Inst1.MovObAL)op;
                method.append("Memory.mem_writeb(Core.base_ds+");
                method.append(o.value);
                method.append(", CPU_Regs.reg_eax.low());");
                return true;
            }
            case 163: {
                if (!(op instanceof Inst1.MovOwAX)) break;
                Inst1.MovOwAX o = (Inst1.MovOwAX)op;
                method.append("Memory.mem_writew(Core.base_ds+");
                method.append(o.value);
                method.append(", CPU_Regs.reg_eax.word());");
                return true;
            }
            case 164: 
            case 676: {
                if (op instanceof Strings.Movsb16) {
                    method.append("Strings.Movsb16.doString();");
                    return true;
                }
                if (op instanceof Strings.Movsb16r) {
                    method.append("Strings.Movsb16r.doString();");
                    return true;
                }
                if (op instanceof Strings.Movsb32) {
                    method.append("Strings.Movsb32.doString();");
                    return true;
                }
                if (!(op instanceof Strings.Movsb32r)) break;
                method.append("Strings.Movsb32r.doString();");
                return true;
            }
            case 165: {
                if (op instanceof Strings.Movsw16) {
                    method.append("Strings.Movsw16.doString();");
                    return true;
                }
                if (op instanceof Strings.Movsw16r) {
                    method.append("Strings.Movsw16r.doString();");
                    return true;
                }
                if (op instanceof Strings.Movsw32) {
                    method.append("Strings.Movsw32.doString();");
                    return true;
                }
                if (!(op instanceof Strings.Movsw32r)) break;
                method.append("Strings.Movsw32r.doString();");
                return true;
            }
            case 166: 
            case 678: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 167: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 168: 
            case 680: {
                if (!(op instanceof Inst1.TestAlIb)) break;
                Inst1.TestAlIb o = (Inst1.TestAlIb)op;
                method.append("Instructions.TESTB((short)");
                method.append(o.ib);
                method.append(",CPU_Regs.reg_eax.low());");
                return true;
            }
            case 169: {
                if (!(op instanceof Inst1.TestAxIw)) break;
                Inst1.TestAxIw o = (Inst1.TestAxIw)op;
                method.append("Instructions.TESTW(");
                method.append(o.iw);
                method.append(",CPU_Regs.reg_eax.word());");
                return true;
            }
            case 170: 
            case 682: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 171: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 172: 
            case 684: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 173: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 174: 
            case 686: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 175: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 176: 
            case 688: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 177: 
            case 689: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 178: 
            case 690: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 179: 
            case 691: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 180: 
            case 692: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 181: 
            case 693: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 182: 
            case 694: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 183: 
            case 695: {
                if (!(op instanceof Inst1.MovIb)) break;
                Inst1.MovIb o = (Inst1.MovIb)op;
                method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                method.append(";");
                return true;
            }
            case 184: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 185: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 186: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 187: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 188: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 189: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 190: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 191: {
                if (!(op instanceof Inst1.MovIw)) break;
                Inst1.MovIw o = (Inst1.MovIw)op;
                method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                method.append(";");
                return true;
            }
            case 192: 
            case 704: {
                if (op instanceof Grp2.ROLB_reg) {
                    Grp2.ROLB_reg o = (Grp2.ROLB_reg)op;
                    method.append("short e = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (Instructions.valid_ROLB(e, ");
                    method.append(o.val);
                    method.append("))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_ROLB(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RORB_reg) {
                    Grp2.RORB_reg o = (Grp2.RORB_reg)op;
                    method.append("short e = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (Instructions.valid_RORB(e, ");
                    method.append(o.val);
                    method.append("))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_RORB(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCLB_reg) {
                    Grp2.RCLB_reg o = (Grp2.RCLB_reg)op;
                    if (Instructions.valid_RCLB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_RCLB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRB_reg) {
                    Grp2.RCRB_reg o = (Grp2.RCRB_reg)op;
                    if (Instructions.valid_RCRB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_RCRB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLB_reg) {
                    Grp2.SHLB_reg o = (Grp2.SHLB_reg)op;
                    if (Instructions.valid_SHLB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_SHLB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRB_reg) {
                    Grp2.SHRB_reg o = (Grp2.SHRB_reg)op;
                    if (Instructions.valid_SHRB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_SHRB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SARB_reg) {
                    Grp2.SARB_reg o = (Grp2.SARB_reg)op;
                    if (Instructions.valid_SARB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_SARB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.ROLB_mem) {
                    Grp2.ROLB_mem o = (Grp2.ROLB_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_ROLB(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writeb(eaa, Instructions.do_ROLB(");
                    method.append(o.val);
                    method.append(", Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RORB_mem) {
                    Grp2.RORB_mem o = (Grp2.RORB_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_RORB(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writeb(eaa, Instructions.do_RORB(");
                    method.append(o.val);
                    method.append(", Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RCLB_mem) {
                    Grp2.RCLB_mem o = (Grp2.RCLB_mem)op;
                    if (Instructions.valid_RCLB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_RCLB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRB_mem) {
                    Grp2.RCRB_mem o = (Grp2.RCRB_mem)op;
                    if (Instructions.valid_RCRB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_RCRB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLB_mem) {
                    Grp2.SHLB_mem o = (Grp2.SHLB_mem)op;
                    if (Instructions.valid_SHLB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_SHLB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRB_mem) {
                    Grp2.SHRB_mem o = (Grp2.SHRB_mem)op;
                    if (Instructions.valid_SHRB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_SHRB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (!(op instanceof Grp2.SARB_mem)) break;
                Grp2.SARB_mem o = (Grp2.SARB_mem)op;
                if (Instructions.valid_SARB(o.val)) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.do_SARB(");
                    method.append(o.val);
                    method.append(", Memory.mem_readb(eaa)));");
                }
                return true;
            }
            case 193: {
                if (op instanceof Grp2.ROLW_reg) {
                    Grp2.ROLW_reg o = (Grp2.ROLW_reg)op;
                    method.append("int e = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (Instructions.valid_ROLW(e, ");
                    method.append(o.val);
                    method.append(")) ");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_ROLW(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RORW_reg) {
                    Grp2.RORW_reg o = (Grp2.RORW_reg)op;
                    method.append("int e = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (Instructions.valid_RORW(e, ");
                    method.append(o.val);
                    method.append(")) ");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_RORW(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCLW_reg) {
                    Grp2.RCLW_reg o = (Grp2.RCLW_reg)op;
                    if (Instructions.valid_RCLW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_RCLW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRW_reg) {
                    Grp2.RCRW_reg o = (Grp2.RCRW_reg)op;
                    if (Instructions.valid_RCRW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_RCRW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLW_reg) {
                    Grp2.SHLW_reg o = (Grp2.SHLW_reg)op;
                    if (Instructions.valid_SHLW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_SHLW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRW_reg) {
                    Grp2.SHRW_reg o = (Grp2.SHRW_reg)op;
                    if (Instructions.valid_SHRW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_SHRW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SARW_reg) {
                    Grp2.SARW_reg o = (Grp2.SARW_reg)op;
                    if (Instructions.valid_SARW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_SARW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.ROLW_mem) {
                    Grp2.ROLW_mem o = (Grp2.ROLW_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_ROLW(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writew(eaa, Instructions.do_ROLW(");
                    method.append(o.val);
                    method.append(", Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RORW_mem) {
                    Grp2.RORW_mem o = (Grp2.RORW_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_RORW(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writew(eaa, Instructions.do_RORW(");
                    method.append(o.val);
                    method.append(", Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RCLW_mem) {
                    Grp2.RCLW_mem o = (Grp2.RCLW_mem)op;
                    if (Instructions.valid_RCLW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_RCLW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRW_mem) {
                    Grp2.RCRW_mem o = (Grp2.RCRW_mem)op;
                    if (Instructions.valid_RCRW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_RCRW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLW_mem) {
                    Grp2.SHLW_mem o = (Grp2.SHLW_mem)op;
                    if (Instructions.valid_SHLW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_SHLW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRW_mem) {
                    Grp2.SHRW_mem o = (Grp2.SHRW_mem)op;
                    if (Instructions.valid_SHRW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_SHRW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (!(op instanceof Grp2.SARW_mem)) break;
                Grp2.SARW_mem o = (Grp2.SARW_mem)op;
                if (Instructions.valid_SARW(o.val)) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.do_SARW(");
                    method.append(o.val);
                    method.append(", Memory.mem_readw(eaa)));");
                }
                return true;
            }
            case 194: {
                if (!(op instanceof Inst1.RetnIw)) break;
                Inst1.RetnIw o = (Inst1.RetnIw)op;
                method.append("CPU_Regs.reg_eip=CPU.CPU_Pop16();CPU_Regs.reg_esp.dword+=");
                method.append(o.offset);
                method.append(";return Constants.BR_Jump;");
                return false;
            }
            case 195: {
                if (!(op instanceof Inst1.Retn)) break;
                Inst1.Retn o = (Inst1.Retn)op;
                method.append("CPU_Regs.reg_eip=CPU.CPU_Pop16();return Constants.BR_Jump;");
                return false;
            }
            case 196: {
                if (!(op instanceof Inst1.Les)) break;
                Inst1.Les o = (Inst1.Les)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa+2))) return RUNEXCEPTION();");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";");
                return true;
            }
            case 197: {
                if (!(op instanceof Inst1.Lds)) break;
                Inst1.Lds o = (Inst1.Lds)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa+2))) return RUNEXCEPTION();");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";Core.base_ds=CPU.Segs_DSphys;Core.base_val_ds= CPU_Regs.ds;");
                return true;
            }
            case 198: 
            case 710: {
                if (op instanceof Inst1.MovIb) {
                    Inst1.MovIb o = (Inst1.MovIb)op;
                    method.append(Compiler.nameSet8(o.reg, "(short)" + o.ib));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.MovIb_mem)) break;
                Inst1.MovIb_mem o = (Inst1.MovIb_mem)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", (short)");
                method.append(o.ib);
                method.append(");");
                return true;
            }
            case 199: {
                if (op instanceof Inst1.MovIw) {
                    Inst1.MovIw o = (Inst1.MovIw)op;
                    method.append(Compiler.nameSet16(o.reg, String.valueOf(o.ib)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst1.MovIw_mem)) break;
                Inst1.MovIw_mem o = (Inst1.MovIw_mem)op;
                method.append("Memory.mem_writew(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ");
                method.append(o.ib);
                method.append(");");
                return true;
            }
            case 200: {
                if (!(op instanceof Inst1.EnterIwIb)) break;
                Inst1.EnterIwIb o = (Inst1.EnterIwIb)op;
                method.append("CPU.CPU_ENTER(false,");
                method.append(o.bytes);
                method.append(",");
                method.append(o.level);
                method.append(");");
                return true;
            }
            case 201: {
                if (!(op instanceof Inst1.Leave)) break;
                Inst1.Leave o = (Inst1.Leave)op;
                method.append("CPU_Regs.reg_esp.dword&=CPU.cpu.stack.notmask;CPU_Regs.reg_esp.dword|=(CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask);CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());");
                return true;
            }
            case 202: {
                if (!(op instanceof Inst1.RetfIw)) break;
                Inst1.RetfIw o = (Inst1.RetfIw)op;
                method.append("Flags.FillFlags();CPU.CPU_RET(false,");
                method.append(o.words);
                method.append(",CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");return Constants.BR_Jump;");
                return false;
            }
            case 203: {
                if (!(op instanceof Inst1.Retf)) break;
                Inst1.Retf o = (Inst1.Retf)op;
                method.append("Flags.FillFlags();CPU.CPU_RET(false,0,CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");return Constants.BR_Jump;");
                return false;
            }
            case 204: 
            case 716: {
                if (!(op instanceof Inst1.Int3)) break;
                Inst1.Int3 o = (Inst1.Int3)op;
                method.append("CPU.CPU_SW_Interrupt_NoIOPLCheck(3,CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("CPU.cpu.trap_skip=true;");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 205: 
            case 717: {
                if (!(op instanceof Inst1.IntIb)) break;
                Inst1.IntIb o = (Inst1.IntIb)op;
                method.append("CPU.CPU_SW_Interrupt(");
                method.append(o.num);
                method.append(", CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("CPU.cpu.trap_skip=true;");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 206: 
            case 718: {
                if (!(op instanceof Inst1.Int0)) break;
                Inst1.Int0 o = (Inst1.Int0)op;
                method.append("if (Flags.get_OF()) {CPU.CPU_SW_Interrupt(4,CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("CPU.cpu.trap_skip=true;");
                method.append("return Constants.BR_Jump;}");
                return true;
            }
            case 207: {
                if (!(op instanceof Inst1.IRet)) break;
                Inst1.IRet o = (Inst1.IRet)op;
                method.append("CPU.CPU_IRET(false, CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.IF)!=0 && Pic.PIC_IRQCheck!=0) return CB_NONE();");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 208: 
            case 720: {
                if (op instanceof Grp2.ROLB_reg) {
                    Grp2.ROLB_reg o = (Grp2.ROLB_reg)op;
                    method.append("short e = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (Instructions.valid_ROLB(e, ");
                    method.append(o.val);
                    method.append("))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_ROLB(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RORB_reg) {
                    Grp2.RORB_reg o = (Grp2.RORB_reg)op;
                    method.append("short e = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (Instructions.valid_RORB(e, ");
                    method.append(o.val);
                    method.append("))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_RORB(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCLB_reg) {
                    Grp2.RCLB_reg o = (Grp2.RCLB_reg)op;
                    if (Instructions.valid_RCLB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_RCLB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRB_reg) {
                    Grp2.RCRB_reg o = (Grp2.RCRB_reg)op;
                    if (Instructions.valid_RCRB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_RCRB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLB_reg) {
                    Grp2.SHLB_reg o = (Grp2.SHLB_reg)op;
                    if (Instructions.valid_SHLB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_SHLB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRB_reg) {
                    Grp2.SHRB_reg o = (Grp2.SHRB_reg)op;
                    if (Instructions.valid_SHRB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_SHRB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SARB_reg) {
                    Grp2.SARB_reg o = (Grp2.SARB_reg)op;
                    if (Instructions.valid_SARB(o.val)) {
                        method.append(Compiler.nameSet8(o.earb, "Instructions.do_SARB(" + o.val + ", " + Compiler.nameGet8(o.earb) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.ROLB_mem) {
                    Grp2.ROLB_mem o = (Grp2.ROLB_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_ROLB(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writeb(eaa, Instructions.do_ROLB(");
                    method.append(o.val);
                    method.append(", Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RORB_mem) {
                    Grp2.RORB_mem o = (Grp2.RORB_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_RORB(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writeb(eaa, Instructions.do_RORB(");
                    method.append(o.val);
                    method.append(", Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RCLB_mem) {
                    Grp2.RCLB_mem o = (Grp2.RCLB_mem)op;
                    if (Instructions.valid_RCLB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_RCLB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRB_mem) {
                    Grp2.RCRB_mem o = (Grp2.RCRB_mem)op;
                    if (Instructions.valid_RCRB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_RCRB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLB_mem) {
                    Grp2.SHLB_mem o = (Grp2.SHLB_mem)op;
                    if (Instructions.valid_SHLB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_SHLB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRB_mem) {
                    Grp2.SHRB_mem o = (Grp2.SHRB_mem)op;
                    if (Instructions.valid_SHRB(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writeb(eaa, Instructions.do_SHRB(");
                        method.append(o.val);
                        method.append(", Memory.mem_readb(eaa)));");
                    }
                    return true;
                }
                if (!(op instanceof Grp2.SARB_mem)) break;
                Grp2.SARB_mem o = (Grp2.SARB_mem)op;
                if (Instructions.valid_SARB(o.val)) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.do_SARB(");
                    method.append(o.val);
                    method.append(", Memory.mem_readb(eaa)));");
                }
                return true;
            }
            case 209: {
                if (op instanceof Grp2.ROLW_reg) {
                    Grp2.ROLW_reg o = (Grp2.ROLW_reg)op;
                    method.append("int e = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (Instructions.valid_ROLW(e, ");
                    method.append(o.val);
                    method.append(")) ");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_ROLW(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RORW_reg) {
                    Grp2.RORW_reg o = (Grp2.RORW_reg)op;
                    method.append("int e = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (Instructions.valid_RORW(e, ");
                    method.append(o.val);
                    method.append(")) ");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_RORW(" + o.val + ", e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCLW_reg) {
                    Grp2.RCLW_reg o = (Grp2.RCLW_reg)op;
                    if (Instructions.valid_RCLW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_RCLW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRW_reg) {
                    Grp2.RCRW_reg o = (Grp2.RCRW_reg)op;
                    if (Instructions.valid_RCRW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_RCRW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLW_reg) {
                    Grp2.SHLW_reg o = (Grp2.SHLW_reg)op;
                    if (Instructions.valid_SHLW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_SHLW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRW_reg) {
                    Grp2.SHRW_reg o = (Grp2.SHRW_reg)op;
                    if (Instructions.valid_SHRW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_SHRW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.SARW_reg) {
                    Grp2.SARW_reg o = (Grp2.SARW_reg)op;
                    if (Instructions.valid_SARW(o.val)) {
                        method.append(Compiler.nameSet16(o.earw, "Instructions.do_SARW(" + o.val + ", " + Compiler.nameGet16(o.earw) + ")"));
                        method.append(";");
                    }
                    return true;
                }
                if (op instanceof Grp2.ROLW_mem) {
                    Grp2.ROLW_mem o = (Grp2.ROLW_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_ROLW(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writew(eaa, Instructions.do_ROLW(");
                    method.append(o.val);
                    method.append(", Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RORW_mem) {
                    Grp2.RORW_mem o = (Grp2.RORW_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (Instructions.valid_RORW(eaa, ");
                    method.append(o.val);
                    method.append(")) Memory.mem_writew(eaa, Instructions.do_RORW(");
                    method.append(o.val);
                    method.append(", Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RCLW_mem) {
                    Grp2.RCLW_mem o = (Grp2.RCLW_mem)op;
                    if (Instructions.valid_RCLW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_RCLW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRW_mem) {
                    Grp2.RCRW_mem o = (Grp2.RCRW_mem)op;
                    if (Instructions.valid_RCRW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_RCRW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLW_mem) {
                    Grp2.SHLW_mem o = (Grp2.SHLW_mem)op;
                    if (Instructions.valid_SHLW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_SHLW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRW_mem) {
                    Grp2.SHRW_mem o = (Grp2.SHRW_mem)op;
                    if (Instructions.valid_SHRW(o.val)) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writew(eaa, Instructions.do_SHRW(");
                        method.append(o.val);
                        method.append(", Memory.mem_readw(eaa)));");
                    }
                    return true;
                }
                if (!(op instanceof Grp2.SARW_mem)) break;
                Grp2.SARW_mem o = (Grp2.SARW_mem)op;
                if (Instructions.valid_SARW(o.val)) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.do_SARW(");
                    method.append(o.val);
                    method.append(", Memory.mem_readw(eaa)));");
                }
                return true;
            }
            case 210: 
            case 722: {
                if (op instanceof Grp2.ROLB_reg_cl) {
                    Grp2.ROLB_reg_cl o = (Grp2.ROLB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; short e = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (Instructions.valid_ROLB(e, val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_ROLB(val, e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RORB_reg_cl) {
                    Grp2.RORB_reg_cl o = (Grp2.RORB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; short e = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (Instructions.valid_RORB(e, val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_RORB(val, e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCLB_reg_cl) {
                    Grp2.RCLB_reg_cl o = (Grp2.RCLB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RCLB (val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_RCLB(val, " + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCRB_reg_cl) {
                    Grp2.RCRB_reg_cl o = (Grp2.RCRB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RCRB (val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_RCRB(val, " + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.SHLB_reg_cl) {
                    Grp2.SHLB_reg_cl o = (Grp2.SHLB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SHLB (val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_SHLB(val, " + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.SHRB_reg_cl) {
                    Grp2.SHRB_reg_cl o = (Grp2.SHRB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SHRB (val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_SHRB(val, " + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.SARB_reg_cl) {
                    Grp2.SARB_reg_cl o = (Grp2.SARB_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SARB (val))");
                    method.append(Compiler.nameSet8(o.earb, "Instructions.do_SARB(val, " + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.ROLB_mem_cl) {
                    Grp2.ROLB_mem_cl o = (Grp2.ROLB_mem_cl)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_ROLB(eaa, val)) Memory.mem_writeb(eaa, Instructions.do_ROLB(val, Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RORB_mem_cl) {
                    Grp2.RORB_mem_cl o = (Grp2.RORB_mem_cl)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RORB(eaa, val)) Memory.mem_writeb(eaa, Instructions.do_RORB(val, Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RCLB_mem_cl) {
                    Grp2.RCLB_mem_cl o = (Grp2.RCLB_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; if (Instructions.valid_RCLB (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.do_RCLB(val, Memory.mem_readb(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.RCRB_mem_cl) {
                    Grp2.RCRB_mem_cl o = (Grp2.RCRB_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; if (Instructions.valid_RCRB (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.do_RCRB(val, Memory.mem_readb(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.SHLB_mem_cl) {
                    Grp2.SHLB_mem_cl o = (Grp2.SHLB_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; if (Instructions.valid_SHLB (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.do_SHLB(val, Memory.mem_readb(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.SHRB_mem_cl) {
                    Grp2.SHRB_mem_cl o = (Grp2.SHRB_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; if (Instructions.valid_SHRB (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.do_SHRB(val, Memory.mem_readb(eaa)));}");
                    return true;
                }
                if (!(op instanceof Grp2.SARB_mem_cl)) break;
                Grp2.SARB_mem_cl o = (Grp2.SARB_mem_cl)op;
                method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f; if (Instructions.valid_SARB (val)) {int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writeb(eaa, Instructions.do_SARB(val, Memory.mem_readb(eaa)));}");
                return true;
            }
            case 211: {
                if (op instanceof Grp2.ROLW_reg_cl) {
                    Grp2.ROLW_reg_cl o = (Grp2.ROLW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;int e = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (Instructions.valid_ROLW(e, val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_ROLW(val, e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RORW_reg_cl) {
                    Grp2.RORW_reg_cl o = (Grp2.RORW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;int e = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (Instructions.valid_RORW(e, val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_RORW(val, e)"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCLW_reg_cl) {
                    Grp2.RCLW_reg_cl o = (Grp2.RCLW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RCLW (val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_RCLW(val, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.RCRW_reg_cl) {
                    Grp2.RCRW_reg_cl o = (Grp2.RCRW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RCRW (val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_RCRW(val, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.SHLW_reg_cl) {
                    Grp2.SHLW_reg_cl o = (Grp2.SHLW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SHLW (val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_SHLW(val, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.SHRW_reg_cl) {
                    Grp2.SHRW_reg_cl o = (Grp2.SHRW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SHRW (val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_SHRW(val, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.SARW_reg_cl) {
                    Grp2.SARW_reg_cl o = (Grp2.SARW_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SARW (val))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_SARW(val, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp2.ROLW_mem_cl) {
                    Grp2.ROLW_mem_cl o = (Grp2.ROLW_mem_cl)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_ROLW(eaa, val)) Memory.mem_writew(eaa, Instructions.do_ROLW(val, Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RORW_mem_cl) {
                    Grp2.RORW_mem_cl o = (Grp2.RORW_mem_cl)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RORW(eaa, val)) Memory.mem_writew(eaa, Instructions.do_RORW(val, Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp2.RCLW_mem_cl) {
                    Grp2.RCLW_mem_cl o = (Grp2.RCLW_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RCLW (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.do_RCLW(val, Memory.mem_readw(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.RCRW_mem_cl) {
                    Grp2.RCRW_mem_cl o = (Grp2.RCRW_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_RCRW (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.do_RCRW(val, Memory.mem_readw(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.SHLW_mem_cl) {
                    Grp2.SHLW_mem_cl o = (Grp2.SHLW_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SHLW (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.do_SHLW(val, Memory.mem_readw(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.SHRW_mem_cl) {
                    Grp2.SHRW_mem_cl o = (Grp2.SHRW_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SHRW (val)) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.do_SHRW(val, Memory.mem_readw(eaa)));}");
                    return true;
                }
                if (!(op instanceof Grp2.SARW_mem_cl)) break;
                Grp2.SARW_mem_cl o = (Grp2.SARW_mem_cl)op;
                method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (Instructions.valid_SARW (val)) {int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa, Instructions.do_SARW(val, Memory.mem_readw(eaa)));}");
                return true;
            }
            case 212: 
            case 724: {
                if (!(op instanceof Inst1.AamIb)) break;
                Inst1.AamIb o = (Inst1.AamIb)op;
                if (o.ib != 0) break;
                method.append("return EXCEPTION(0);");
                return false;
            }
            case 213: 
            case 725: {
                if (!(op instanceof Inst1.AadIb)) break;
                Inst1.AadIb o = (Inst1.AadIb)op;
                method.append("Instructions.AAD(");
                method.append(o.ib);
                method.append(");");
                return true;
            }
            case 214: 
            case 726: {
                if (!(op instanceof Inst1.Salc)) break;
                Inst1.Salc o = (Inst1.Salc)op;
                method.append("CPU_Regs.reg_eax.low(Flags.get_CF() ? 0xFF : 0);");
                return true;
            }
            case 215: 
            case 727: {
                if (op instanceof Inst1.Xlat32) {
                    Inst1.Xlat32 o = (Inst1.Xlat32)op;
                    method.append("CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds+CPU_Regs.reg_ebx.dword+CPU_Regs.reg_eax.low()));");
                    return true;
                }
                if (!(op instanceof Inst1.Xlat16)) break;
                Inst1.Xlat16 o = (Inst1.Xlat16)op;
                method.append("CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds+((CPU_Regs.reg_ebx.word()+CPU_Regs.reg_eax.low()) & 0xFFFF)));");
                return true;
            }
            case 216: 
            case 728: {
                if (op instanceof Inst1.FPU0_normal) {
                    Inst1.FPU0_normal o = (Inst1.FPU0_normal)op;
                    method.append("FPU.FPU_ESC0_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU0_ea)) break;
                Inst1.FPU0_ea o = (Inst1.FPU0_ea)op;
                method.append("FPU.FPU_ESC0_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 217: 
            case 729: {
                if (op instanceof Inst1.FPU1_normal) {
                    Inst1.FPU1_normal o = (Inst1.FPU1_normal)op;
                    method.append("FPU.FPU_ESC1_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU1_ea)) break;
                Inst1.FPU1_ea o = (Inst1.FPU1_ea)op;
                method.append("FPU.FPU_ESC1_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 218: 
            case 730: {
                if (op instanceof Inst1.FPU2_normal) {
                    Inst1.FPU2_normal o = (Inst1.FPU2_normal)op;
                    method.append("FPU.FPU_ESC2_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU2_ea)) break;
                Inst1.FPU2_ea o = (Inst1.FPU2_ea)op;
                method.append("FPU.FPU_ESC2_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 219: 
            case 731: {
                if (op instanceof Inst1.FPU3_normal) {
                    Inst1.FPU3_normal o = (Inst1.FPU3_normal)op;
                    method.append("FPU.FPU_ESC3_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU3_ea)) break;
                Inst1.FPU3_ea o = (Inst1.FPU3_ea)op;
                method.append("FPU.FPU_ESC3_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 220: 
            case 732: {
                if (op instanceof Inst1.FPU4_normal) {
                    Inst1.FPU4_normal o = (Inst1.FPU4_normal)op;
                    method.append("FPU.FPU_ESC4_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU4_ea)) break;
                Inst1.FPU4_ea o = (Inst1.FPU4_ea)op;
                method.append("FPU.FPU_ESC4_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 221: 
            case 733: {
                if (op instanceof Inst1.FPU5_normal) {
                    Inst1.FPU5_normal o = (Inst1.FPU5_normal)op;
                    method.append("FPU.FPU_ESC5_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU5_ea)) break;
                Inst1.FPU5_ea o = (Inst1.FPU5_ea)op;
                method.append("FPU.FPU_ESC5_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 222: 
            case 734: {
                if (op instanceof Inst1.FPU6_normal) {
                    Inst1.FPU6_normal o = (Inst1.FPU6_normal)op;
                    method.append("FPU.FPU_ESC6_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU6_ea)) break;
                Inst1.FPU6_ea o = (Inst1.FPU6_ea)op;
                method.append("FPU.FPU_ESC6_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 223: 
            case 735: {
                if (op instanceof Inst1.FPU7_normal) {
                    Inst1.FPU7_normal o = (Inst1.FPU7_normal)op;
                    method.append("FPU.FPU_ESC7_Normal(");
                    method.append(o.rm);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.FPU7_ea)) break;
                Inst1.FPU7_ea o = (Inst1.FPU7_ea)op;
                method.append("FPU.FPU_ESC7_EA(");
                method.append(o.rm);
                method.append(",");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 224: {
                if (op instanceof Inst1.Loopnz32) {
                    Inst1.Loopnz32 o = (Inst1.Loopnz32)op;
                    method.append("CPU_Regs.reg_ecx.dword--;");
                    Compiler.compile(o, "CPU_Regs.reg_ecx.dword!=0 && !Flags.get_ZF()", method);
                    return false;
                }
                if (!(op instanceof Inst1.Loopnz16)) break;
                Inst1.Loopnz16 o = (Inst1.Loopnz16)op;
                method.append("CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word()-1);");
                Compiler.compile(o, "CPU_Regs.reg_ecx.word()!=0 && !Flags.get_ZF()", method);
                return false;
            }
            case 225: {
                if (op instanceof Inst1.Loopz32) {
                    Inst1.Loopz32 o = (Inst1.Loopz32)op;
                    method.append("CPU_Regs.reg_ecx.dword--;");
                    Compiler.compile(o, "CPU_Regs.reg_ecx.dword!=0 && Flags.get_ZF()", method);
                    return false;
                }
                if (!(op instanceof Inst1.Loopz16)) break;
                Inst1.Loopz16 o = (Inst1.Loopz16)op;
                method.append("CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word()-1);");
                Compiler.compile(o, "CPU_Regs.reg_ecx.word()!=0 && Flags.get_ZF()", method);
                return false;
            }
            case 226: {
                if (op instanceof Inst1.Loop32) {
                    Inst1.Loop32 o = (Inst1.Loop32)op;
                    method.append("CPU_Regs.reg_ecx.dword--;");
                    Compiler.compile(o, "CPU_Regs.reg_ecx.dword!=0", method);
                    return false;
                }
                if (!(op instanceof Inst1.Loop16)) break;
                Inst1.Loop16 o = (Inst1.Loop16)op;
                method.append("CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word()-1);");
                Compiler.compile(o, "CPU_Regs.reg_ecx.word()!=0", method);
                return false;
            }
            case 227: {
                if (!(op instanceof Inst1.Jcxz)) break;
                Inst1.Jcxz o = (Inst1.Jcxz)op;
                Compiler.compile(o, "(CPU_Regs.reg_ecx.dword & " + o.mask + ")==0", method);
                return false;
            }
            case 228: 
            case 740: {
                if (!(op instanceof Inst1.InAlIb)) break;
                Inst1.InAlIb o = (Inst1.InAlIb)op;
                method.append("if (CPU.CPU_IO_Exception(");
                method.append(o.port);
                method.append(",1)) return RUNEXCEPTION();CPU_Regs.reg_eax.low(IO.IO_ReadB(");
                method.append(o.port);
                method.append("));");
                return true;
            }
            case 229: {
                if (!(op instanceof Inst1.InAxIb)) break;
                Inst1.InAxIb o = (Inst1.InAxIb)op;
                method.append("if (CPU.CPU_IO_Exception(");
                method.append(o.port);
                method.append(",2)) return RUNEXCEPTION();CPU_Regs.reg_eax.word(IO.IO_ReadW(");
                method.append(o.port);
                method.append("));");
                return true;
            }
            case 230: 
            case 742: {
                if (!(op instanceof Inst1.OutAlIb)) break;
                Inst1.OutAlIb o = (Inst1.OutAlIb)op;
                method.append("if (CPU.CPU_IO_Exception(");
                method.append(o.port);
                method.append(",1)) return RUNEXCEPTION();IO.IO_WriteB(");
                method.append(o.port);
                method.append(",CPU_Regs.reg_eax.low());");
                return true;
            }
            case 231: {
                if (!(op instanceof Inst1.OutAxIb)) break;
                Inst1.OutAxIb o = (Inst1.OutAxIb)op;
                method.append("if (CPU.CPU_IO_Exception(");
                method.append(o.port);
                method.append(",2)) return RUNEXCEPTION();IO.IO_WriteW(");
                method.append(o.port);
                method.append(",CPU_Regs.reg_eax.word());");
                return true;
            }
            case 232: {
                if (!(op instanceof Inst1.CallJw)) break;
                Inst1.CallJw o = (Inst1.CallJw)op;
                method.append("CPU.CPU_Push16(CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");CPU_Regs.reg_ip(CPU_Regs.reg_eip+");
                method.append(o.eip_count + o.addip);
                method.append(");return Constants.BR_Link1;");
                return false;
            }
            case 233: {
                if (!(op instanceof Inst1.JmpJw)) break;
                Inst1.JmpJw o = (Inst1.JmpJw)op;
                method.append("CPU_Regs.reg_ip(CPU_Regs.reg_eip+");
                method.append(o.eip_count + o.addip);
                method.append(");return Constants.BR_Link1;");
                return false;
            }
            case 234: {
                if (!(op instanceof Inst1.JmpAp)) break;
                Inst1.JmpAp o = (Inst1.JmpAp)op;
                method.append("Flags.FillFlags();CPU.CPU_JMP(false,");
                method.append(o.newcs);
                method.append(",");
                method.append(o.newip);
                method.append(", CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 235: {
                if (!(op instanceof Inst1.JmpJb)) break;
                Inst1.JmpJb o = (Inst1.JmpJb)op;
                method.append("CPU_Regs.reg_ip(CPU_Regs.reg_eip+");
                method.append(o.eip_count + o.addip);
                method.append(");return Constants.BR_Link1;");
                return false;
            }
            case 236: 
            case 748: {
                if (!(op instanceof Inst1.InAlDx)) break;
                Inst1.InAlDx o = (Inst1.InAlDx)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),1)) return RUNEXCEPTION();CPU_Regs.reg_eax.low(IO.IO_ReadB(CPU_Regs.reg_edx.word()));");
                return true;
            }
            case 237: {
                if (!(op instanceof Inst1.InAxDx)) break;
                Inst1.InAxDx o = (Inst1.InAxDx)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),2)) return RUNEXCEPTION();CPU_Regs.reg_eax.word(IO.IO_ReadW(CPU_Regs.reg_edx.word()));");
                return true;
            }
            case 238: 
            case 750: {
                if (!(op instanceof Inst1.OutAlDx)) break;
                Inst1.OutAlDx o = (Inst1.OutAlDx)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),1)) return RUNEXCEPTION();IO.IO_WriteB(CPU_Regs.reg_edx.word(),CPU_Regs.reg_eax.low());");
                return true;
            }
            case 239: {
                if (!(op instanceof Inst1.OutAxDx)) break;
                Inst1.OutAxDx o = (Inst1.OutAxDx)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),2)) return RUNEXCEPTION();IO.IO_WriteW(CPU_Regs.reg_edx.word(),CPU_Regs.reg_eax.word());");
                return true;
            }
            case 240: 
            case 752: {
                if (!(op instanceof Inst1.Lock)) break;
                Inst1.Lock o = (Inst1.Lock)op;
                return true;
            }
            case 241: 
            case 753: {
                if (!(op instanceof Inst1.Icebp)) break;
                Inst1.Icebp o = (Inst1.Icebp)op;
                method.append("CPU.CPU_SW_Interrupt_NoIOPLCheck(1,CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("CPU.cpu.trap_skip=true;");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 242: 
            case 754: {
                break;
            }
            case 243: 
            case 755: {
                break;
            }
            case 244: 
            case 756: {
                if (!(op instanceof Inst1.Hlt)) break;
                Inst1.Hlt o = (Inst1.Hlt)op;
                method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);Flags.FillFlags();CPU.CPU_HLT(CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");return CB_NONE();");
                return false;
            }
            case 245: 
            case 757: {
                if (!(op instanceof Inst1.Cmc)) break;
                Inst1.Cmc o = (Inst1.Cmc)op;
                method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(CPU_Regs.flags & CPU_Regs.CF)==0);");
                return true;
            }
            case 246: 
            case 758: {
                if (op instanceof Grp3.Testb_reg) {
                    Grp3.Testb_reg o = (Grp3.Testb_reg)op;
                    method.append("Instructions.TESTB((short)");
                    method.append(o.val);
                    method.append(",");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.Testb_mem) {
                    Grp3.Testb_mem o = (Grp3.Testb_mem)op;
                    method.append("Instructions.TESTB((short)");
                    method.append(o.val);
                    method.append(",Memory.mem_readb(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("));");
                    return true;
                }
                if (op instanceof Grp3.NotEb_reg) {
                    Grp3.NotEb_reg o = (Grp3.NotEb_reg)op;
                    method.append(Compiler.nameSet8(o.earb, "(byte)~" + Compiler.nameGet8(o.earb)));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp3.NotEb_mem) {
                    Grp3.NotEb_mem o = (Grp3.NotEb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa,~Memory.mem_readb(eaa));");
                    return true;
                }
                if (op instanceof Grp3.NegEb_reg) {
                    Grp3.NegEb_reg o = (Grp3.NegEb_reg)op;
                    method.append(Compiler.nameSet8(o.earb, "Instructions.Negb(" + Compiler.nameGet8(o.earb) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp3.NegEb_mem) {
                    Grp3.NegEb_mem o = (Grp3.NegEb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.Negb(Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Grp3.MulAlEb_reg) {
                    Grp3.MulAlEb_reg o = (Grp3.MulAlEb_reg)op;
                    method.append("Instructions.MULB(");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.MulAlEb_mem) {
                    Grp3.MulAlEb_mem o = (Grp3.MulAlEb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Instructions.MULB(Memory.mem_readb(eaa));");
                    return true;
                }
                if (op instanceof Grp3.IMulAlEb_reg) {
                    Grp3.IMulAlEb_reg o = (Grp3.IMulAlEb_reg)op;
                    method.append("Instructions.IMULB(");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.IMulAlEb_mem) {
                    Grp3.IMulAlEb_mem o = (Grp3.IMulAlEb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Instructions.IMULB(Memory.mem_readb(eaa));");
                    return true;
                }
                if (op instanceof Grp3.DivAlEb_reg) {
                    Grp3.DivAlEb_reg o = (Grp3.DivAlEb_reg)op;
                    method.append("int val = ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (val==0)\t{return EXCEPTION(0);} int quo=CPU_Regs.reg_eax.word() / val; int rem=(CPU_Regs.reg_eax.word() % val); int quo8=(quo&0xff); if (quo>0xff) {return EXCEPTION(0);}CPU_Regs.reg_eax.high(rem);CPU_Regs.reg_eax.low(quo8);");
                    return true;
                }
                if (op instanceof Grp3.DivAlEb_mem) {
                    Grp3.DivAlEb_mem o = (Grp3.DivAlEb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = Memory.mem_readb(eaa);");
                    method.append("if (val==0)\t{return EXCEPTION(0);} int quo=CPU_Regs.reg_eax.word() / val; int rem=(CPU_Regs.reg_eax.word() % val); int quo8=(quo&0xff); if (quo>0xff) {return EXCEPTION(0);}CPU_Regs.reg_eax.high(rem);CPU_Regs.reg_eax.low(quo8);");
                    return true;
                }
                if (op instanceof Grp3.IDivAlEb_reg) {
                    Grp3.IDivAlEb_reg o = (Grp3.IDivAlEb_reg)op;
                    method.append("int val = (byte)");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";if (val==0)\t{return EXCEPTION(0);} int quo=CPU_Regs.reg_eax.word() / val; int rem=(CPU_Regs.reg_eax.word() % val); int quo8=(quo&0xff); if (quo>0xff) {return EXCEPTION(0);}CPU_Regs.reg_eax.high(rem);CPU_Regs.reg_eax.low(quo8);");
                    return true;
                }
                if (!(op instanceof Grp3.IDivAlEb_mem)) break;
                Grp3.IDivAlEb_mem o = (Grp3.IDivAlEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int val = (byte)Memory.mem_readb(eaa);");
                method.append("if (val==0)\t{return EXCEPTION(0);} int quo=CPU_Regs.reg_eax.word() / val; int rem=(CPU_Regs.reg_eax.word() % val); int quo8=(quo&0xff); if (quo>0xff) {return EXCEPTION(0);}CPU_Regs.reg_eax.high(rem);CPU_Regs.reg_eax.low(quo8);");
                return true;
            }
            case 247: {
                if (op instanceof Grp3.Testw_reg) {
                    Grp3.Testw_reg o = (Grp3.Testw_reg)op;
                    method.append("Instructions.TESTW(");
                    method.append(o.val);
                    method.append(",");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.Testw_mem) {
                    Grp3.Testw_mem o = (Grp3.Testw_mem)op;
                    method.append("Instructions.TESTW(");
                    method.append(o.val);
                    method.append(",Memory.mem_readw(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("));");
                    return true;
                }
                if (op instanceof Grp3.NotEw_reg) {
                    Grp3.NotEw_reg o = (Grp3.NotEw_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "~" + Compiler.nameGet16(o.earw)));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp3.NotEw_mem) {
                    Grp3.NotEw_mem o = (Grp3.NotEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa,~Memory.mem_readw(eaa));");
                    return true;
                }
                if (op instanceof Grp3.NegEw_reg) {
                    Grp3.NegEw_reg o = (Grp3.NegEw_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.Negw(" + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp3.NegEw_mem) {
                    Grp3.NegEw_mem o = (Grp3.NegEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.Negw(Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Grp3.MulAxEw_reg) {
                    Grp3.MulAxEw_reg o = (Grp3.MulAxEw_reg)op;
                    method.append("Instructions.MULW(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.MulAxEw_mem) {
                    Grp3.MulAxEw_mem o = (Grp3.MulAxEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Instructions.MULW(Memory.mem_readw(eaa));");
                    return true;
                }
                if (op instanceof Grp3.IMulAxEw_reg) {
                    Grp3.IMulAxEw_reg o = (Grp3.IMulAxEw_reg)op;
                    method.append("Instructions.IMULW(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.IMulAxEw_mem) {
                    Grp3.IMulAxEw_mem o = (Grp3.IMulAxEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Instructions.IMULW(Memory.mem_readw(eaa));");
                    return true;
                }
                if (op instanceof Grp3.DivAxEw_reg) {
                    Grp3.DivAxEw_reg o = (Grp3.DivAxEw_reg)op;
                    method.append("int val = ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (val==0)\t{return EXCEPTION(0);}long num=((long)CPU_Regs.reg_edx.word()<<16)|CPU_Regs.reg_eax.word();long quo=num/val;int rem=(int)((num % val));int quo16=(int)(quo&0xffff);if (quo!=quo16) {return EXCEPTION(0);}CPU_Regs.reg_edx.word(rem);CPU_Regs.reg_eax.word(quo16);");
                    return true;
                }
                if (op instanceof Grp3.DivAxEw_mem) {
                    Grp3.DivAxEw_mem o = (Grp3.DivAxEw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = Memory.mem_readw(eaa);");
                    method.append("if (val==0)\t{return EXCEPTION(0);}long num=((long)CPU_Regs.reg_edx.word()<<16)|CPU_Regs.reg_eax.word();long quo=num/val;int rem=(int)((num % val));int quo16=(int)(quo&0xffff);if (quo!=quo16) {return EXCEPTION(0);}CPU_Regs.reg_edx.word(rem);CPU_Regs.reg_eax.word(quo16);");
                    return true;
                }
                if (op instanceof Grp3.IDivAxEw_reg) {
                    Grp3.IDivAxEw_reg o = (Grp3.IDivAxEw_reg)op;
                    method.append("int val = (short)");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (val==0)\t{return EXCEPTION(0);}int num=(CPU_Regs.reg_edx.word()<<16)|CPU_Regs.reg_eax.word();int quo=num/val;short rem=(short)((num % val));short quo16=(short)quo;if (quo!=(int)quo16) {return EXCEPTION(0);}CPU_Regs.reg_edx.word(rem);CPU_Regs.reg_eax.word(quo16);");
                    return true;
                }
                if (!(op instanceof Grp3.IDivAxEw_mem)) break;
                Grp3.IDivAxEw_mem o = (Grp3.IDivAxEw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int val = (short)Memory.mem_readw(eaa);");
                method.append("if (val==0)\t{return EXCEPTION(0);}int num=(CPU_Regs.reg_edx.word()<<16)|CPU_Regs.reg_eax.word();int quo=num/val;short rem=(short)((num % val));short quo16=(short)quo;if (quo!=(int)quo16) {return EXCEPTION(0);}CPU_Regs.reg_edx.word(rem);CPU_Regs.reg_eax.word(quo16);");
                return true;
            }
            case 248: 
            case 760: {
                if (!(op instanceof Inst1.Clc)) break;
                Inst1.Clc o = (Inst1.Clc)op;
                method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,false);");
                return true;
            }
            case 249: 
            case 761: {
                if (!(op instanceof Inst1.Stc)) break;
                Inst1.Stc o = (Inst1.Stc)op;
                method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,true);");
                return true;
            }
            case 250: 
            case 762: {
                if (!(op instanceof Inst1.Cli)) break;
                Inst1.Cli o = (Inst1.Cli)op;
                method.append("if (CPU.CPU_CLI()) return RUNEXCEPTION();");
                return true;
            }
            case 251: 
            case 763: {
                if (!(op instanceof Inst1.Sti)) break;
                Inst1.Sti o = (Inst1.Sti)op;
                method.append("if (CPU.CPU_STI()) return RUNEXCEPTION();");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.IF)!=0 && Pic.PIC_IRQCheck!=0) return DECODE_END(");
                method.append(o.eip_count);
                method.append(");");
                return true;
            }
            case 252: 
            case 764: {
                if (!(op instanceof Inst1.Cld)) break;
                Inst1.Cld o = (Inst1.Cld)op;
                method.append("CPU_Regs.SETFLAGBIT(CPU_Regs.DF,false);CPU.cpu.direction=1;");
                return true;
            }
            case 253: 
            case 765: {
                if (!(op instanceof Inst1.Std)) break;
                Inst1.Std o = (Inst1.Std)op;
                method.append("CPU_Regs.SETFLAGBIT(CPU_Regs.DF,true);CPU.cpu.direction=-1;");
                return true;
            }
            case 254: 
            case 766: {
                if (op instanceof Inst1.Incb_reg) {
                    Inst1.Incb_reg o = (Inst1.Incb_reg)op;
                    method.append(Compiler.nameSet8(o.reg, "Instructions.INCB(" + Compiler.nameGet8(o.reg) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.Incb_mem) {
                    Inst1.Incb_mem o = (Inst1.Incb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.INCB(Memory.mem_readb(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.Decb_reg) {
                    Inst1.Decb_reg o = (Inst1.Decb_reg)op;
                    method.append(Compiler.nameSet8(o.reg, "Instructions.DECB(" + Compiler.nameGet8(o.reg) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.Decb_mem) {
                    Inst1.Decb_mem o = (Inst1.Decb_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writeb(eaa, Instructions.DECB(Memory.mem_readb(eaa)));");
                    return true;
                }
                if (!(op instanceof Inst1.Callback)) break;
                Inst1.Callback o = (Inst1.Callback)op;
                method.append("CPU_Regs.reg_eip+=");
                method.append(o.eip_count);
                method.append(";Data.callback = ");
                method.append(o.val);
                method.append(";return Constants.BR_CallBack;");
                return false;
            }
            case 255: {
                if (op instanceof Inst1.Incw_reg) {
                    Inst1.Incw_reg o = (Inst1.Incw_reg)op;
                    method.append(Compiler.nameSet16(o.reg, "Instructions.INCW(" + Compiler.nameGet16(o.reg) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.Incw_mem) {
                    Inst1.Incw_mem o = (Inst1.Incw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.INCW(Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.Decw_reg) {
                    Inst1.Decw_reg o = (Inst1.Decw_reg)op;
                    method.append(Compiler.nameSet16(o.reg, "Instructions.DECW(" + Compiler.nameGet16(o.reg) + ")"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst1.Decw_mem) {
                    Inst1.Decw_mem o = (Inst1.Decw_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, Instructions.DECW(Memory.mem_readw(eaa)));");
                    return true;
                }
                if (op instanceof Inst1.CallEv_reg) {
                    Inst1.CallEv_reg o = (Inst1.CallEv_reg)op;
                    method.append("int old = CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(";CPU.CPU_Push16(old & 0xFFFF);");
                    method.append("CPU_Regs.reg_eip=");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst1.CallEv_mem) {
                    Inst1.CallEv_mem o = (Inst1.CallEv_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old = CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(";int eip = Memory.mem_readw(eaa);CPU.CPU_Push16(old & 0xFFFF);CPU_Regs.reg_eip = eip;return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst1.CallEp) {
                    Inst1.CallEp o = (Inst1.CallEp)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int newip=Memory.mem_readw(eaa);int newcs=Memory.mem_readw(eaa+2);Flags.FillFlags();CPU.CPU_CALL(false,newcs,newip,(CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(") & 0xFFFF);");
                    method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                    method.append("return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst1.JmpEv_reg) {
                    Inst1.JmpEv_reg o = (Inst1.JmpEv_reg)op;
                    method.append("CPU_Regs.reg_eip=");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst1.JmpEv_mem) {
                    Inst1.JmpEv_mem o = (Inst1.JmpEv_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";CPU_Regs.reg_eip=Memory.mem_readw(eaa);return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst1.JmpEp) {
                    Inst1.JmpEp o = (Inst1.JmpEp)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int newip=Memory.mem_readw(eaa);int newcs=Memory.mem_readw(eaa+2);Flags.FillFlags();CPU.CPU_JMP(false,newcs,newip,(CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(") & 0xFFFF);");
                    method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                    method.append("return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst1.PushEv_reg) {
                    Inst1.PushEv_reg o = (Inst1.PushEv_reg)op;
                    method.append("CPU.CPU_Push16(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst1.PushEv_mem)) break;
                Inst1.PushEv_mem o = (Inst1.PushEv_mem)op;
                method.append("CPU.CPU_Push16(Memory.mem_readw(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append("));");
                return true;
            }
            case 256: {
                if (op instanceof Inst2.Sldt_reg) {
                    Inst2.Sldt_reg o = (Inst2.Sldt_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;");
                    method.append(Compiler.nameSet16(o.earw, "CPU.CPU_SLDT()"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst2.Sldt_mem) {
                    Inst2.Sldt_mem o = (Inst2.Sldt_mem)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, CPU.CPU_SLDT());");
                    return true;
                }
                if (op instanceof Inst2.Str_reg) {
                    Inst2.Str_reg o = (Inst2.Str_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;");
                    method.append(Compiler.nameSet16(o.earw, "CPU.CPU_STR()"));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst2.Str_mem) {
                    Inst2.Str_mem o = (Inst2.Str_mem)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa, CPU.CPU_STR());");
                    return true;
                }
                if (op instanceof Inst2.Lldt_reg) {
                    Inst2.Lldt_reg o = (Inst2.Lldt_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;if (CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);if (CPU.CPU_LLDT(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst2.Lldt_mem) {
                    Inst2.Lldt_mem o = (Inst2.Lldt_mem)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;if (CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_LLDT(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst2.Ltr_reg) {
                    Inst2.Ltr_reg o = (Inst2.Ltr_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;if (CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);if (CPU.CPU_LTR(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(")) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst2.Ltr_mem) {
                    Inst2.Ltr_mem o = (Inst2.Ltr_mem)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;if (CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_LTR(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst2.Verr_reg) {
                    Inst2.Verr_reg o = (Inst2.Verr_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;CPU.CPU_VERR(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst2.Verr_mem) {
                    Inst2.Verr_mem o = (Inst2.Verr_mem)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";CPU.CPU_VERR(Memory.mem_readw(eaa));");
                    return true;
                }
                if (op instanceof Inst2.Verw_reg) {
                    Inst2.Verw_reg o = (Inst2.Verw_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;CPU.CPU_VERW(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst2.Verw_mem)) break;
                Inst2.Verw_mem o = (Inst2.Verw_mem)op;
                method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";CPU.CPU_VERW(Memory.mem_readw(eaa));");
                return true;
            }
            case 257: {
                if (op instanceof Inst2.Sgdt_mem) {
                    Inst2.Sgdt_mem o = (Inst2.Sgdt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa,CPU.CPU_SGDT_limit());Memory.mem_writed(eaa+2,CPU.CPU_SGDT_base());");
                    return true;
                }
                if (op instanceof Inst2.Sidt_mem) {
                    Inst2.Sidt_mem o = (Inst2.Sidt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa,CPU.CPU_SIDT_limit());Memory.mem_writed(eaa+2,CPU.CPU_SIDT_base());");
                    return true;
                }
                if (op instanceof Inst2.Lgdt_mem) {
                    Inst2.Lgdt_mem o = (Inst2.Lgdt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);CPU.CPU_LGDT(Memory.mem_readw(eaa),Memory.mem_readd(eaa + 2) & 0xFFFFFF);");
                    return true;
                }
                if (op instanceof Inst2.Lidt_mem) {
                    Inst2.Lidt_mem o = (Inst2.Lidt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);CPU.CPU_LIDT(Memory.mem_readw(eaa),Memory.mem_readd(eaa + 2) & 0xFFFFFF);");
                    return true;
                }
                if (op instanceof Inst2.Smsw_mem) {
                    Inst2.Smsw_mem o = (Inst2.Smsw_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writew(eaa,CPU.CPU_SMSW());");
                    return true;
                }
                if (op instanceof Inst2.Lmsw_mem) {
                    Inst2.Lmsw_mem o = (Inst2.Lmsw_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_LMSW(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst2.Invlpg) {
                    Inst2.Invlpg o = (Inst2.Invlpg)op;
                    method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);Paging.PAGING_ClearTLB();");
                    return true;
                }
                if (op instanceof Inst2.Lgdt_reg) {
                    Inst2.Lgdt_reg o = (Inst2.Lgdt_reg)op;
                    method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);return Constants.BR_Illegal;");
                    return false;
                }
                if (op instanceof Inst2.Lidt_reg) {
                    Inst2.Lidt_reg o = (Inst2.Lidt_reg)op;
                    method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);return Constants.BR_Illegal;");
                    return false;
                }
                if (op instanceof Inst2.Smsw_reg) {
                    Inst2.Smsw_reg o = (Inst2.Smsw_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "CPU.CPU_SMSW()"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.Lmsw_reg)) break;
                Inst2.Lmsw_reg o = (Inst2.Lmsw_reg)op;
                method.append("if (CPU.CPU_LMSW(");
                method.append(Compiler.nameGet16(o.earw));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 258: {
                if (op instanceof Inst2.LarGwEw_reg) {
                    Inst2.LarGwEw_reg o = (Inst2.LarGwEw_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;IntRef value=new IntRef(");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(");CPU.CPU_LAR(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(",value);");
                    method.append(Compiler.nameSet16(o.rw, "value.value"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.LarGwEw_mem)) break;
                Inst2.LarGwEw_mem o = (Inst2.LarGwEw_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;IntRef value=new IntRef(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(");CPU.CPU_LAR(Memory.mem_readw(eaa),value);");
                method.append(Compiler.nameSet16(o.rw, "value.value"));
                method.append(";");
                return true;
            }
            case 259: {
                if (op instanceof Inst2.LslGwEw_reg) {
                    Inst2.LslGwEw_reg o = (Inst2.LslGwEw_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;IntRef value=new IntRef(");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(");CPU.CPU_LSL(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(",value);");
                    method.append(Compiler.nameSet16(o.rw, "value.value"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.LslGwEw_mem)) break;
                Inst2.LslGwEw_mem o = (Inst2.LslGwEw_mem)op;
                method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";IntRef value = new IntRef(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(");CPU.CPU_LSL(Memory.mem_readw(eaa),value);");
                method.append(Compiler.nameSet16(o.rw, "value.value"));
                method.append(";");
                return true;
            }
            case 262: 
            case 774: {
                if (!(op instanceof Inst2.Clts)) break;
                Inst2.Clts o = (Inst2.Clts)op;
                method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);CPU.cpu.cr0=CPU.cpu.cr0 & (~(int)CPU.CR0_TASKSWITCH);");
                return true;
            }
            case 264: 
            case 776: {
                if (!(op instanceof Inst2.Invd)) break;
                Inst2.Invd o = (Inst2.Invd)op;
                method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);");
                return true;
            }
            case 265: 
            case 777: {
                break;
            }
            case 288: 
            case 800: {
                if (!(op instanceof Inst2.MovRdCr)) break;
                Inst2.MovRdCr o = (Inst2.MovRdCr)op;
                method.append("if (CPU.CPU_READ_CRX(");
                method.append(o.which);
                method.append(",");
                method.append(Compiler.nameRef(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 289: 
            case 801: {
                if (!(op instanceof Inst2.MovRdDr)) break;
                Inst2.MovRdDr o = (Inst2.MovRdDr)op;
                method.append("if (CPU.CPU_READ_DRX(");
                method.append(o.which);
                method.append(",");
                method.append(Compiler.nameRef(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 290: 
            case 802: {
                if (!(op instanceof Inst2.MovCrRd)) break;
                Inst2.MovCrRd o = (Inst2.MovCrRd)op;
                method.append("if (CPU.CPU_WRITE_CRX(");
                method.append(o.which);
                method.append(",");
                method.append(Compiler.nameGet32(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 291: 
            case 803: {
                if (!(op instanceof Inst2.MovDrRd)) break;
                Inst2.MovDrRd o = (Inst2.MovDrRd)op;
                method.append("if (CPU.CPU_WRITE_DRX(");
                method.append(o.which);
                method.append(",");
                method.append(Compiler.nameGet32(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 292: 
            case 804: {
                if (!(op instanceof Inst2.MovRdTr)) break;
                Inst2.MovRdTr o = (Inst2.MovRdTr)op;
                method.append("if (CPU.CPU_READ_TRX(");
                method.append(o.which);
                method.append(",");
                method.append(Compiler.nameRef(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 294: 
            case 806: {
                if (!(op instanceof Inst2.MovTrRd)) break;
                Inst2.MovTrRd o = (Inst2.MovTrRd)op;
                method.append("if (CPU.CPU_WRITE_TRX(");
                method.append(o.which);
                method.append(",");
                method.append(Compiler.nameGet32(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 305: 
            case 817: {
                if (!(op instanceof Inst2.Rdtsc)) break;
                Inst2.Rdtsc o = (Inst2.Rdtsc)op;
                method.append("if (CPU.CPU_ArchitectureType<CPU.CPU_ARCHTYPE_PENTIUM) return Constants.BR_Illegal;long tsc=(long)(Pic.PIC_FullIndex()*(double)CPU.CPU_CycleMax);CPU_Regs.reg_edx.dword=(int)(tsc>>>32);CPU_Regs.reg_eax.dword=(int)tsc;");
                return true;
            }
            case 384: {
                if (!(op instanceof Inst2.JumpCond16_w_o)) break;
                Inst2.JumpCond16_w_o o = (Inst2.JumpCond16_w_o)op;
                Compiler.compile(o, "Flags.TFLG_O()", method);
                return false;
            }
            case 385: {
                if (!(op instanceof Inst2.JumpCond16_w_no)) break;
                Inst2.JumpCond16_w_no o = (Inst2.JumpCond16_w_no)op;
                Compiler.compile(o, "Flags.TFLG_NO()", method);
                return false;
            }
            case 386: {
                if (!(op instanceof Inst2.JumpCond16_w_b)) break;
                Inst2.JumpCond16_w_b o = (Inst2.JumpCond16_w_b)op;
                Compiler.compile(o, "Flags.TFLG_B()", method);
                return false;
            }
            case 387: {
                if (!(op instanceof Inst2.JumpCond16_w_nb)) break;
                Inst2.JumpCond16_w_nb o = (Inst2.JumpCond16_w_nb)op;
                Compiler.compile(o, "Flags.TFLG_NB()", method);
                return false;
            }
            case 388: {
                if (!(op instanceof Inst2.JumpCond16_w_z)) break;
                Inst2.JumpCond16_w_z o = (Inst2.JumpCond16_w_z)op;
                Compiler.compile(o, "Flags.TFLG_Z()", method);
                return false;
            }
            case 389: {
                if (!(op instanceof Inst2.JumpCond16_w_nz)) break;
                Inst2.JumpCond16_w_nz o = (Inst2.JumpCond16_w_nz)op;
                Compiler.compile(o, "Flags.TFLG_NZ()", method);
                return false;
            }
            case 390: {
                if (!(op instanceof Inst2.JumpCond16_w_be)) break;
                Inst2.JumpCond16_w_be o = (Inst2.JumpCond16_w_be)op;
                Compiler.compile(o, "Flags.TFLG_BE()", method);
                return false;
            }
            case 391: {
                if (!(op instanceof Inst2.JumpCond16_w_nbe)) break;
                Inst2.JumpCond16_w_nbe o = (Inst2.JumpCond16_w_nbe)op;
                Compiler.compile(o, "Flags.TFLG_NBE()", method);
                return false;
            }
            case 392: {
                if (!(op instanceof Inst2.JumpCond16_w_s)) break;
                Inst2.JumpCond16_w_s o = (Inst2.JumpCond16_w_s)op;
                Compiler.compile(o, "Flags.TFLG_S()", method);
                return false;
            }
            case 393: {
                if (!(op instanceof Inst2.JumpCond16_w_ns)) break;
                Inst2.JumpCond16_w_ns o = (Inst2.JumpCond16_w_ns)op;
                Compiler.compile(o, "Flags.TFLG_NS()", method);
                return false;
            }
            case 394: {
                if (!(op instanceof Inst2.JumpCond16_w_p)) break;
                Inst2.JumpCond16_w_p o = (Inst2.JumpCond16_w_p)op;
                Compiler.compile(o, "Flags.TFLG_P()", method);
                return false;
            }
            case 395: {
                if (!(op instanceof Inst2.JumpCond16_w_np)) break;
                Inst2.JumpCond16_w_np o = (Inst2.JumpCond16_w_np)op;
                Compiler.compile(o, "Flags.TFLG_NP()", method);
                return false;
            }
            case 396: {
                if (!(op instanceof Inst2.JumpCond16_w_l)) break;
                Inst2.JumpCond16_w_l o = (Inst2.JumpCond16_w_l)op;
                Compiler.compile(o, "Flags.TFLG_L()", method);
                return false;
            }
            case 397: {
                if (!(op instanceof Inst2.JumpCond16_w_nl)) break;
                Inst2.JumpCond16_w_nl o = (Inst2.JumpCond16_w_nl)op;
                Compiler.compile(o, "Flags.TFLG_NL()", method);
                return false;
            }
            case 398: {
                if (!(op instanceof Inst2.JumpCond16_w_le)) break;
                Inst2.JumpCond16_w_le o = (Inst2.JumpCond16_w_le)op;
                Compiler.compile(o, "Flags.TFLG_LE()", method);
                return false;
            }
            case 399: {
                if (!(op instanceof Inst2.JumpCond16_w_nle)) break;
                Inst2.JumpCond16_w_nle o = (Inst2.JumpCond16_w_nle)op;
                Compiler.compile(o, "Flags.TFLG_NLE()", method);
                return false;
            }
            case 400: 
            case 912: {
                if (op instanceof Inst2.SETcc_reg_o) {
                    Inst2.SETcc_reg_o o = (Inst2.SETcc_reg_o)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_O()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_o)) break;
                Inst2.SETcc_mem_o o = (Inst2.SETcc_mem_o)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_O()) ? 1 : 0)));");
                return true;
            }
            case 401: 
            case 913: {
                if (op instanceof Inst2.SETcc_reg_no) {
                    Inst2.SETcc_reg_no o = (Inst2.SETcc_reg_no)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NO()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_no)) break;
                Inst2.SETcc_mem_no o = (Inst2.SETcc_mem_no)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NO()) ? 1 : 0)));");
                return true;
            }
            case 402: 
            case 914: {
                if (op instanceof Inst2.SETcc_reg_b) {
                    Inst2.SETcc_reg_b o = (Inst2.SETcc_reg_b)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_B()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_b)) break;
                Inst2.SETcc_mem_b o = (Inst2.SETcc_mem_b)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_B()) ? 1 : 0)));");
                return true;
            }
            case 403: 
            case 915: {
                if (op instanceof Inst2.SETcc_reg_nb) {
                    Inst2.SETcc_reg_nb o = (Inst2.SETcc_reg_nb)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NB()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_nb)) break;
                Inst2.SETcc_mem_nb o = (Inst2.SETcc_mem_nb)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NB()) ? 1 : 0)));");
                return true;
            }
            case 404: 
            case 916: {
                if (op instanceof Inst2.SETcc_reg_z) {
                    Inst2.SETcc_reg_z o = (Inst2.SETcc_reg_z)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_Z()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_z)) break;
                Inst2.SETcc_mem_z o = (Inst2.SETcc_mem_z)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_Z()) ? 1 : 0)));");
                return true;
            }
            case 405: 
            case 917: {
                if (op instanceof Inst2.SETcc_reg_nz) {
                    Inst2.SETcc_reg_nz o = (Inst2.SETcc_reg_nz)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NZ()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_nz)) break;
                Inst2.SETcc_mem_nz o = (Inst2.SETcc_mem_nz)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NZ()) ? 1 : 0)));");
                return true;
            }
            case 406: 
            case 918: {
                if (op instanceof Inst2.SETcc_reg_be) {
                    Inst2.SETcc_reg_be o = (Inst2.SETcc_reg_be)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_BE()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_be)) break;
                Inst2.SETcc_mem_be o = (Inst2.SETcc_mem_be)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_BE()) ? 1 : 0)));");
                return true;
            }
            case 407: 
            case 919: {
                if (op instanceof Inst2.SETcc_reg_nbe) {
                    Inst2.SETcc_reg_nbe o = (Inst2.SETcc_reg_nbe)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NBE()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_nbe)) break;
                Inst2.SETcc_mem_nbe o = (Inst2.SETcc_mem_nbe)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NBE()) ? 1 : 0)));");
                return true;
            }
            case 408: 
            case 920: {
                if (op instanceof Inst2.SETcc_reg_s) {
                    Inst2.SETcc_reg_s o = (Inst2.SETcc_reg_s)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_S()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_s)) break;
                Inst2.SETcc_mem_s o = (Inst2.SETcc_mem_s)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_S()) ? 1 : 0)));");
                return true;
            }
            case 409: 
            case 921: {
                if (op instanceof Inst2.SETcc_reg_ns) {
                    Inst2.SETcc_reg_ns o = (Inst2.SETcc_reg_ns)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NS()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_ns)) break;
                Inst2.SETcc_mem_ns o = (Inst2.SETcc_mem_ns)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NS()) ? 1 : 0)));");
                return true;
            }
            case 410: 
            case 922: {
                if (op instanceof Inst2.SETcc_reg_p) {
                    Inst2.SETcc_reg_p o = (Inst2.SETcc_reg_p)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_P()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_p)) break;
                Inst2.SETcc_mem_p o = (Inst2.SETcc_mem_p)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_P()) ? 1 : 0)));");
                return true;
            }
            case 411: 
            case 923: {
                if (op instanceof Inst2.SETcc_reg_np) {
                    Inst2.SETcc_reg_np o = (Inst2.SETcc_reg_np)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NP()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_np)) break;
                Inst2.SETcc_mem_np o = (Inst2.SETcc_mem_np)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NP()) ? 1 : 0)));");
                return true;
            }
            case 412: 
            case 924: {
                if (op instanceof Inst2.SETcc_reg_l) {
                    Inst2.SETcc_reg_l o = (Inst2.SETcc_reg_l)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_L()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_l)) break;
                Inst2.SETcc_mem_l o = (Inst2.SETcc_mem_l)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_L()) ? 1 : 0)));");
                return true;
            }
            case 413: 
            case 925: {
                if (op instanceof Inst2.SETcc_reg_nl) {
                    Inst2.SETcc_reg_nl o = (Inst2.SETcc_reg_nl)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NL()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_nl)) break;
                Inst2.SETcc_mem_nl o = (Inst2.SETcc_mem_nl)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NL()) ? 1 : 0)));");
                return true;
            }
            case 414: 
            case 926: {
                if (op instanceof Inst2.SETcc_reg_le) {
                    Inst2.SETcc_reg_le o = (Inst2.SETcc_reg_le)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_LE()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_le)) break;
                Inst2.SETcc_mem_le o = (Inst2.SETcc_mem_le)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_LE()) ? 1 : 0)));");
                return true;
            }
            case 415: 
            case 927: {
                if (op instanceof Inst2.SETcc_reg_nle) {
                    Inst2.SETcc_reg_nle o = (Inst2.SETcc_reg_nle)op;
                    method.append(Compiler.nameSet8(o.earb, "(short)((Flags.TFLG_NLE()) ? 1 : 0)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.SETcc_mem_nle)) break;
                Inst2.SETcc_mem_nle o = (Inst2.SETcc_mem_nle)op;
                method.append("Memory.mem_writeb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ((short)((Flags.TFLG_NLE()) ? 1 : 0)));");
                return true;
            }
            case 416: {
                if (!(op instanceof Inst2.PushFS)) break;
                Inst2.PushFS o = (Inst2.PushFS)op;
                method.append("CPU.CPU_Push16(CPU.Segs_FSval);");
                return true;
            }
            case 417: {
                if (!(op instanceof Inst2.PopFS)) break;
                Inst2.PopFS o = (Inst2.PopFS)op;
                method.append("if (CPU.CPU_PopSegFS(false)) return RUNEXCEPTION();");
                return true;
            }
            case 418: 
            case 930: {
                if (!(op instanceof Inst2.CPUID)) break;
                Inst2.CPUID o = (Inst2.CPUID)op;
                method.append("if (!CPU.CPU_CPUID()) return Constants.BR_Illegal;");
                return true;
            }
            case 419: {
                if (op instanceof Inst2.BtEwGw_reg) {
                    Inst2.BtEwGw_reg o = (Inst2.BtEwGw_reg)op;
                    method.append("Flags.FillFlags();");
                    method.append("CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & (1 << (");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(" & 15)))!=0);");
                    return true;
                }
                if (!(op instanceof Inst2.BtEwGw_mem)) break;
                Inst2.BtEwGw_mem o = (Inst2.BtEwGw_mem)op;
                method.append("Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet16(o.rw));
                method.append(" & 15);int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";eaa+=(((short)");
                method.append(Compiler.nameGet16(o.rw));
                method.append(")>>4)*2;int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);");
                return true;
            }
            case 420: {
                if (op instanceof Inst2.ShldEwGwIb_reg) {
                    Inst2.ShldEwGwIb_reg o = (Inst2.ShldEwGwIb_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_DSHLW(" + Compiler.nameGet16(o.rw) + ", " + o.op3 + ", " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.ShldEwGwIb_mem)) break;
                Inst2.ShldEwGwIb_mem o = (Inst2.ShldEwGwIb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa, Instructions.do_DSHLW(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(", ");
                method.append(o.op3);
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 421: {
                if (op instanceof Inst2.ShldEwGwCl_reg) {
                    Inst2.ShldEwGwCl_reg o = (Inst2.ShldEwGwCl_reg)op;
                    method.append("short s = CPU_Regs.reg_ecx.low();if (Instructions.valid_DSHLW(s))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_DSHLW(" + Compiler.nameGet16(o.rw) + ", s, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.ShldEwGwCl_mem)) break;
                Inst2.ShldEwGwCl_mem o = (Inst2.ShldEwGwCl_mem)op;
                method.append("short s = CPU_Regs.reg_ecx.low();if (Instructions.valid_DSHLW(s)) {int eaa =");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa, Instructions.do_DSHLW(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(", s, Memory.mem_readw(eaa)));");
                return true;
            }
            case 424: {
                if (!(op instanceof Inst2.PushGS)) break;
                Inst2.PushGS o = (Inst2.PushGS)op;
                method.append("CPU.CPU_Push16(CPU.Segs_GSval);");
                return true;
            }
            case 425: {
                if (!(op instanceof Inst2.PopGS)) break;
                Inst2.PopGS o = (Inst2.PopGS)op;
                method.append("if (CPU.CPU_PopSegGS(false)) return RUNEXCEPTION();");
                return true;
            }
            case 427: {
                if (op instanceof Inst2.BtsEwGw_reg) {
                    Inst2.BtsEwGw_reg o = (Inst2.BtsEwGw_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(" & 15);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & mask)!=0);");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + " | mask"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.BtsEwGw_mem)) break;
                Inst2.BtsEwGw_mem o = (Inst2.BtsEwGw_mem)op;
                method.append("Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet16(o.rw));
                method.append(" & 15);int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";eaa+=(((short)");
                method.append(Compiler.nameGet16(o.rw));
                method.append(")>>4)*2;int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);Memory.mem_writew(eaa,old | mask);");
                return true;
            }
            case 428: {
                if (op instanceof Inst2.ShrdEwGwIb_reg) {
                    Inst2.ShrdEwGwIb_reg o = (Inst2.ShrdEwGwIb_reg)op;
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_DSHRW(" + Compiler.nameGet16(o.rw) + ", " + o.op3 + ", " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.ShrdEwGwIb_mem)) break;
                Inst2.ShrdEwGwIb_mem o = (Inst2.ShrdEwGwIb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa, Instructions.do_DSHRW(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(", ");
                method.append(o.op3);
                method.append(", Memory.mem_readw(eaa)));");
                return true;
            }
            case 429: {
                if (op instanceof Inst2.ShrdEwGwCl_reg) {
                    Inst2.ShrdEwGwCl_reg o = (Inst2.ShrdEwGwCl_reg)op;
                    method.append("int s = CPU_Regs.reg_ecx.low();if (Instructions.valid_DSHRW(s))");
                    method.append(Compiler.nameSet16(o.earw, "Instructions.do_DSHRW(" + Compiler.nameGet16(o.rw) + ", s, " + Compiler.nameGet16(o.earw) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.ShrdEwGwCl_mem)) break;
                Inst2.ShrdEwGwCl_mem o = (Inst2.ShrdEwGwCl_mem)op;
                method.append("int s = CPU_Regs.reg_ecx.low();if (Instructions.valid_DSHRW(s)) {int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writew(eaa, Instructions.do_DSHRW(");
                method.append(Compiler.nameGet16(o.rw));
                method.append(", s, Memory.mem_readw(eaa)));}");
                return true;
            }
            case 431: {
                if (op instanceof Inst2.ImulGwEw_reg) {
                    Inst2.ImulGwEw_reg o = (Inst2.ImulGwEw_reg)op;
                    method.append(Compiler.nameSet16(o.rw, "Instructions.DIMULW(" + Compiler.nameGet16(o.earw) + "," + Compiler.nameGet16(o.rw) + ")"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.ImulGwEw_mem)) break;
                Inst2.ImulGwEw_mem o = (Inst2.ImulGwEw_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "Instructions.DIMULW(Memory.mem_readw(eaa)," + Compiler.nameGet16(o.rw) + ")"));
                method.append(";");
                return true;
            }
            case 432: 
            case 944: {
                if (op instanceof Inst2.CmpxchgEbGb_reg) {
                    Inst2.CmpxchgEbGb_reg o = (Inst2.CmpxchgEbGb_reg)op;
                    method.append("Flags.FillFlags();if (CPU_Regs.reg_eax.low() == ");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(") {");
                    method.append(Compiler.nameSet8(o.earb, Compiler.nameGet8(o.rb)));
                    method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {CPU_Regs.reg_eax.low(");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);}");
                    return true;
                }
                if (!(op instanceof Inst2.CmpxchgEbGb_mem)) break;
                Inst2.CmpxchgEbGb_mem o = (Inst2.CmpxchgEbGb_mem)op;
                method.append("Flags.FillFlags();int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";short val = Memory.mem_readb(eaa);if (CPU_Regs.reg_eax.low() == val) {Memory.mem_writeb(eaa,");
                method.append(Compiler.nameGet8(o.rb));
                method.append(");CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {Memory.mem_writeb(eaa,val);CPU_Regs.reg_eax.low(val);CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);}");
                return true;
            }
            case 433: {
                if (op instanceof Inst2.CmpxchgEwGw_reg) {
                    Inst2.CmpxchgEwGw_reg o = (Inst2.CmpxchgEwGw_reg)op;
                    method.append("Flags.FillFlags();if (CPU_Regs.reg_eax.word() == ");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(") {");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.rw)));
                    method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {CPU_Regs.reg_eax.word(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);}");
                    return true;
                }
                if (!(op instanceof Inst2.CmpxchgEwGw_mem)) break;
                Inst2.CmpxchgEwGw_mem o = (Inst2.CmpxchgEwGw_mem)op;
                method.append("Flags.FillFlags();int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int val = Memory.mem_readw(eaa);if (CPU_Regs.reg_eax.word() == val) {Memory.mem_writew(eaa,");
                method.append(Compiler.nameGet16(o.rw));
                method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {Memory.mem_writew(eaa,val);CPU_Regs.reg_eax.word(val);CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);}");
                return true;
            }
            case 434: {
                if (!(op instanceof Inst2.LssEw)) break;
                Inst2.LssEw o = (Inst2.LssEw)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa+2))) return RUNEXCEPTION();");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";Core.base_ss=CPU.Segs_SSphys;");
                return true;
            }
            case 435: {
                if (op instanceof Inst2.BtrEwGw_reg) {
                    Inst2.BtrEwGw_reg o = (Inst2.BtrEwGw_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(" & 15);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & mask)!=0);");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + " & ~mask"));
                    method.append(";");
                    return false;
                }
                if (!(op instanceof Inst2.BtrEwGw_mem)) break;
                Inst2.BtrEwGw_mem o = (Inst2.BtrEwGw_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet16(o.rw));
                method.append(" & 15);eaa+=(((short)");
                method.append(Compiler.nameGet16(o.rw));
                method.append(")>>4)*2;int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);Memory.mem_writew(eaa,old & ~mask);");
                return true;
            }
            case 436: {
                if (!(op instanceof Inst2.LfsEw)) break;
                Inst2.LfsEw o = (Inst2.LfsEw)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa+2))) return RUNEXCEPTION();");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";");
                return true;
            }
            case 437: {
                if (!(op instanceof Inst2.LgsEw)) break;
                Inst2.LgsEw o = (Inst2.LgsEw)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa+2))) return RUNEXCEPTION();");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";");
                return true;
            }
            case 438: {
                if (op instanceof Inst2.MovzxGwEb_reg) {
                    Inst2.MovzxGwEb_reg o = (Inst2.MovzxGwEb_reg)op;
                    method.append(Compiler.nameSet16(o.rw, Compiler.nameGet8(o.earb)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.MovzxGwEb_mem)) break;
                Inst2.MovzxGwEb_mem o = (Inst2.MovzxGwEb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readb(eaa)"));
                method.append(";");
                return true;
            }
            case 439: {
                if (op instanceof Inst2.MovzxGwEw_reg) {
                    Inst2.MovzxGwEw_reg o = (Inst2.MovzxGwEw_reg)op;
                    method.append(Compiler.nameSet16(o.rw, Compiler.nameGet16(o.earw)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.MovzxGwEw_mem)) break;
                Inst2.MovzxGwEw_mem o = (Inst2.MovzxGwEw_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "Memory.mem_readw(eaa)"));
                method.append(";");
                return true;
            }
            case 447: {
                break;
            }
            case 442: {
                if (op instanceof Inst2.BtEwIb_reg) {
                    Inst2.BtEwIb_reg o = (Inst2.BtEwIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & mask)!=0);");
                    return true;
                }
                if (op instanceof Inst2.BtsEwIb_reg) {
                    Inst2.BtsEwIb_reg o = (Inst2.BtsEwIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + " | " + o.mask));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst2.BtrEwIb_reg) {
                    Inst2.BtrEwIb_reg o = (Inst2.BtrEwIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + " & ~" + o.mask));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst2.BtcEwIb_reg) {
                    Inst2.BtcEwIb_reg o = (Inst2.BtcEwIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + " ^ " + o.mask));
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst2.BtEwIb_mem) {
                    Inst2.BtEwIb_mem o = (Inst2.BtEwIb_mem)op;
                    method.append("Flags.FillFlags();");
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    return true;
                }
                if (op instanceof Inst2.BtsEwIb_mem) {
                    Inst2.BtsEwIb_mem o = (Inst2.BtsEwIb_mem)op;
                    method.append("Flags.FillFlags();");
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                    method.append(o.mask);
                    method.append(")!=0);Memory.mem_writew(eaa,old|");
                    method.append(o.mask);
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst2.BtrEwIb_mem) {
                    Inst2.BtrEwIb_mem o = (Inst2.BtrEwIb_mem)op;
                    method.append("Flags.FillFlags();");
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                    method.append(o.mask);
                    method.append(")!=0);Memory.mem_writew(eaa,old & ~");
                    method.append(o.mask);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst2.BtcEwIb_mem)) break;
                Inst2.BtcEwIb_mem o = (Inst2.BtcEwIb_mem)op;
                method.append("Flags.FillFlags();");
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                method.append(o.mask);
                method.append(")!=0);Memory.mem_writew(eaa,old ^ ");
                method.append(o.mask);
                method.append(");");
                return true;
            }
            case 443: {
                if (op instanceof Inst2.BtcEwGw_reg) {
                    Inst2.BtcEwGw_reg o = (Inst2.BtcEwGw_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(" & 15);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(" & mask)!=0);");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + " ^ mask"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.BtcEwGw_mem)) break;
                Inst2.BtcEwGw_mem o = (Inst2.BtcEwGw_mem)op;
                method.append("Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet16(o.rw));
                method.append(" & 15);int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";eaa+=(((short)");
                method.append(Compiler.nameGet16(o.rw));
                method.append(")>>4)*2;int old=Memory.mem_readw(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);Memory.mem_writew(eaa,old ^ mask);");
                return true;
            }
            case 444: {
                if (op instanceof Inst2.BsfGwEw_reg) {
                    Inst2.BsfGwEw_reg o = (Inst2.BsfGwEw_reg)op;
                    method.append("int value=");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 0; while ((value & 0x01)==0) { result++; value>>=1; }CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                    method.append(Compiler.nameSet16(o.rw, "result"));
                    method.append(";}Flags.lflags.type=Flags.t_UNKNOWN;");
                    return true;
                }
                if (!(op instanceof Inst2.BsfGwEw_mem)) break;
                Inst2.BsfGwEw_mem o = (Inst2.BsfGwEw_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int value=Memory.mem_readw(eaa);if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 0;while ((value & 0x01)==0) { result++; value>>=1; }CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                method.append(Compiler.nameSet16(o.rw, "result"));
                method.append(";}Flags.lflags.type=Flags.t_UNKNOWN;");
                return true;
            }
            case 445: {
                if (op instanceof Inst2.BsrGwEw_reg) {
                    Inst2.BsrGwEw_reg o = (Inst2.BsrGwEw_reg)op;
                    method.append("int value=");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 15;while ((value & 0x8000)==0) { result--; value<<=1; }CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                    method.append(Compiler.nameSet16(o.rw, "result"));
                    method.append(";}Flags.lflags.type=Flags.t_UNKNOWN;");
                    return true;
                }
                if (!(op instanceof Inst2.BsrGwEw_mem)) break;
                Inst2.BsrGwEw_mem o = (Inst2.BsrGwEw_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int value=Memory.mem_readw(eaa);if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 15;while ((value & 0x8000)==0) { result--; value<<=1; }CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                method.append(Compiler.nameSet16(o.rw, "result"));
                method.append(";}Flags.lflags.type=Flags.t_UNKNOWN;");
                return true;
            }
            case 446: {
                if (op instanceof Inst2.MovsxGwEb_reg) {
                    Inst2.MovsxGwEb_reg o = (Inst2.MovsxGwEb_reg)op;
                    method.append(Compiler.nameSet16(o.rw, "(byte)" + Compiler.nameGet8(o.earb)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.MovsxGwEb_mem)) break;
                Inst2.MovsxGwEb_mem o = (Inst2.MovsxGwEb_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameSet16(o.rw, "(byte)Memory.mem_readb(eaa)"));
                method.append(";");
                return true;
            }
            case 448: 
            case 960: {
                if (op instanceof Inst2.XaddGbEb_reg) {
                    Inst2.XaddGbEb_reg o = (Inst2.XaddGbEb_reg)op;
                    method.append("short oldrmrb=");
                    method.append(Compiler.nameGet8(o.rb));
                    method.append(Compiler.nameSet8(o.rb, Compiler.nameGet8(o.earb)));
                    method.append(";");
                    method.append(Compiler.nameSet8(o.earb, "(short)(" + Compiler.nameGet8(o.earb) + "+oldrmrb)"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.XaddGbEb_mem)) break;
                Inst2.XaddGbEb_mem o = (Inst2.XaddGbEb_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";short oldrmrb=");
                method.append(Compiler.nameGet8(o.rb));
                method.append(";short val = Memory.mem_readb(eaa);Memory.mem_writeb(eaa,val+oldrmrb);");
                method.append(Compiler.nameSet8(o.rb, "val"));
                method.append(";");
                return true;
            }
            case 449: {
                if (op instanceof Inst2.XaddGwEw_reg) {
                    Inst2.XaddGwEw_reg o = (Inst2.XaddGwEw_reg)op;
                    method.append("int oldrmrw=");
                    method.append(Compiler.nameGet16(o.rw));
                    method.append(";");
                    method.append(Compiler.nameSet16(o.rw, Compiler.nameGet16(o.earw)));
                    method.append(";");
                    method.append(Compiler.nameSet16(o.earw, Compiler.nameGet16(o.earw) + "+oldrmrw"));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst2.XaddGwEw_mem)) break;
                Inst2.XaddGwEw_mem o = (Inst2.XaddGwEw_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int oldrmrb=");
                method.append(Compiler.nameGet16(o.rw));
                method.append(";int val = Memory.mem_readw(eaa);Memory.mem_writew(eaa,val+oldrmrb);");
                method.append(Compiler.nameSet16(o.rw, "val"));
                method.append(";");
                return true;
            }
            case 456: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 457: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 458: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 459: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 460: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 461: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 462: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 463: {
                if (!(op instanceof Inst2.Bswapw)) break;
                Inst2.Bswapw o = (Inst2.Bswapw)op;
                method.append(Compiler.nameSet16(o.reg, "Instructions.BSWAPW(" + Compiler.nameGet16(o.reg) + ")"));
                method.append(";");
                return true;
            }
            case 513: {
                if (op instanceof Inst3.Addd_reg) {
                    Inst3.Addd_reg o = (Inst3.Addd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ADDD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.AddEdGd_mem)) break;
                Inst3.AddEdGd_mem o = (Inst3.AddEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.ADDD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 515: {
                if (op instanceof Inst3.Addd_reg) {
                    Inst3.Addd_reg o = (Inst3.Addd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ADDD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.AddGdEd_mem)) break;
                Inst3.AddGdEd_mem o = (Inst3.AddGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.ADDD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 517: {
                if (!(op instanceof Inst3.AddEaxId)) break;
                Inst3.AddEaxId o = (Inst3.AddEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.ADDD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 518: {
                if (!(op instanceof Inst3.Push32ES)) break;
                Inst3.Push32ES o = (Inst3.Push32ES)op;
                method.append("CPU.CPU_Push32(CPU.Segs_ESval);");
                return true;
            }
            case 519: {
                if (!(op instanceof Inst3.Pop32ES)) break;
                Inst3.Pop32ES o = (Inst3.Pop32ES)op;
                method.append("if (CPU.CPU_PopSegES(true)) return RUNEXCEPTION();");
                return true;
            }
            case 521: {
                if (op instanceof Inst3.Ord_reg) {
                    Inst3.Ord_reg o = (Inst3.Ord_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ORD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.OrEdGd_mem)) break;
                Inst3.OrEdGd_mem o = (Inst3.OrEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.ORD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 523: {
                if (op instanceof Inst3.Ord_reg) {
                    Inst3.Ord_reg o = (Inst3.Ord_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ORD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.OrGdEd_mem)) break;
                Inst3.OrGdEd_mem o = (Inst3.OrGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.ORD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 525: {
                if (!(op instanceof Inst3.OrEaxId)) break;
                Inst3.OrEaxId o = (Inst3.OrEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.ORD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 526: {
                if (!(op instanceof Inst3.Push32CS)) break;
                Inst3.Push32CS o = (Inst3.Push32CS)op;
                method.append("CPU.CPU_Push32(CPU.Segs_CSval);");
                return true;
            }
            case 529: {
                if (op instanceof Inst3.Adcd_reg) {
                    Inst3.Adcd_reg o = (Inst3.Adcd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ADCD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.AdcEdGd_mem)) break;
                Inst3.AdcEdGd_mem o = (Inst3.AdcEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.ADCD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 531: {
                if (op instanceof Inst3.Adcd_reg) {
                    Inst3.Adcd_reg o = (Inst3.Adcd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ADCD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.AdcGdEd_mem)) break;
                Inst3.AdcGdEd_mem o = (Inst3.AdcGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.ADCD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 533: {
                if (!(op instanceof Inst3.AdcEaxId)) break;
                Inst3.AdcEaxId o = (Inst3.AdcEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.ADCD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 534: {
                if (!(op instanceof Inst3.Push32SS)) break;
                Inst3.Push32SS o = (Inst3.Push32SS)op;
                method.append("CPU.CPU_Push32(CPU.Segs_SSval);");
                return true;
            }
            case 535: {
                if (!(op instanceof Inst3.Pop32SS)) break;
                Inst3.Pop32SS o = (Inst3.Pop32SS)op;
                method.append("if (CPU.CPU_PopSegSS(true)) return RUNEXCEPTION();Core.base_ss=CPU.Segs_SSphys;");
                return true;
            }
            case 537: {
                if (op instanceof Inst3.Sbbd_reg) {
                    Inst3.Sbbd_reg o = (Inst3.Sbbd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.SBBD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.SbbEdGd_mem)) break;
                Inst3.SbbEdGd_mem o = (Inst3.SbbEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.SBBD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 539: {
                if (op instanceof Inst3.Sbbd_reg) {
                    Inst3.Sbbd_reg o = (Inst3.Sbbd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.SBBD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.SbbGdEd_mem)) break;
                Inst3.SbbGdEd_mem o = (Inst3.SbbGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.SBBD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 541: {
                if (!(op instanceof Inst3.SbbEaxId)) break;
                Inst3.SbbEaxId o = (Inst3.SbbEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.SBBD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 542: {
                if (!(op instanceof Inst3.Push32DS)) break;
                Inst3.Push32DS o = (Inst3.Push32DS)op;
                method.append("CPU.CPU_Push32(CPU.Segs_DSval);");
                return true;
            }
            case 543: {
                if (!(op instanceof Inst3.Pop32DS)) break;
                Inst3.Pop32DS o = (Inst3.Pop32DS)op;
                method.append("if (CPU.CPU_PopSegDS(true)) return RUNEXCEPTION();Core.base_ds=CPU.Segs_DSphys;Core.base_val_ds= CPU_Regs.ds;");
                return true;
            }
            case 545: {
                if (op instanceof Inst3.Andd_reg) {
                    Inst3.Andd_reg o = (Inst3.Andd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ANDD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.AndEdGd_mem)) break;
                Inst3.AndEdGd_mem o = (Inst3.AndEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.ANDD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 547: {
                if (op instanceof Inst3.Andd_reg) {
                    Inst3.Andd_reg o = (Inst3.Andd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.ANDD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.AndGdEd_mem)) break;
                Inst3.AndGdEd_mem o = (Inst3.AndGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.ANDD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 549: {
                if (!(op instanceof Inst3.AndEaxId)) break;
                Inst3.AndEaxId o = (Inst3.AndEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.ANDD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 553: {
                if (op instanceof Inst3.Subd_reg) {
                    Inst3.Subd_reg o = (Inst3.Subd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.SUBD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.SubEdGd_mem)) break;
                Inst3.SubEdGd_mem o = (Inst3.SubEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.SUBD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 555: {
                if (op instanceof Inst3.Subd_reg) {
                    Inst3.Subd_reg o = (Inst3.Subd_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.SUBD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.SubGdEd_mem)) break;
                Inst3.SubGdEd_mem o = (Inst3.SubGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.SUBD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 557: {
                if (!(op instanceof Inst3.SubEaxId)) break;
                Inst3.SubEaxId o = (Inst3.SubEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.SUBD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 561: {
                if (op instanceof Inst3.Xord_reg) {
                    Inst3.Xord_reg o = (Inst3.Xord_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.XORD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.XorEdGd_mem)) break;
                Inst3.XorEdGd_mem o = (Inst3.XorEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Memory.mem_writed(eaa, Instructions.XORD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", ");
                method.append("Memory.mem_readd(eaa)));");
                return true;
            }
            case 563: {
                if (op instanceof Inst3.Xord_reg) {
                    Inst3.Xord_reg o = (Inst3.Xord_reg)op;
                    method.append(Compiler.nameGet32(o.e));
                    method.append("=Instructions.XORD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.XorGdEd_mem)) break;
                Inst3.XorGdEd_mem o = (Inst3.XorGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.g, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.e));
                method.append("=Instructions.XORD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 565: {
                if (!(op instanceof Inst3.XorEaxId)) break;
                Inst3.XorEaxId o = (Inst3.XorEaxId)op;
                method.append("CPU_Regs.reg_eax.dword=Instructions.XORD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 569: {
                if (op instanceof Inst3.Cmpd_reg) {
                    Inst3.Cmpd_reg o = (Inst3.Cmpd_reg)op;
                    method.append("Instructions.CMPD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.CmpEdGd_mem)) break;
                Inst3.CmpEdGd_mem o = (Inst3.CmpEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.e, method);
                method.append(";Instructions.CMPD(");
                method.append(Compiler.nameGet32(o.g));
                method.append(", Memory.mem_readd(eaa));");
                return true;
            }
            case 571: {
                if (op instanceof Inst3.Cmpd_reg) {
                    Inst3.Cmpd_reg o = (Inst3.Cmpd_reg)op;
                    method.append("Instructions.CMPD(");
                    method.append(Compiler.nameGet32(o.g));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.e));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.CmpGdEd_mem)) break;
                Inst3.CmpGdEd_mem o = (Inst3.CmpGdEd_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.g, method);
                method.append(";Instructions.CMPD(Memory.mem_readd(eaa), ");
                method.append(Compiler.nameGet32(o.e));
                method.append(");");
                return true;
            }
            case 573: {
                if (!(op instanceof Inst3.CmpEaxId)) break;
                Inst3.CmpEaxId o = (Inst3.CmpEaxId)op;
                method.append("Instructions.CMPD(");
                method.append(o.i);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 576: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 577: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 578: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 579: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 580: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 581: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 582: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 583: {
                if (!(op instanceof Inst3.Incd_reg)) break;
                Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.INCD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 584: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 585: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 586: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 587: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 588: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 589: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 590: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 591: {
                if (!(op instanceof Inst3.Decd_reg)) break;
                Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append(" = Instructions.DECD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 592: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 593: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 594: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 595: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 596: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 597: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 598: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 599: {
                if (!(op instanceof Inst3.Push32_reg)) break;
                Inst3.Push32_reg o = (Inst3.Push32_reg)op;
                method.append("CPU.CPU_Push32(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 600: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 601: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 602: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 603: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 604: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 605: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 606: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 607: {
                if (!(op instanceof Inst3.Pop32_reg)) break;
                Inst3.Pop32_reg o = (Inst3.Pop32_reg)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU.CPU_Pop32();");
                return true;
            }
            case 608: {
                if (!(op instanceof Inst3.Pushad)) break;
                Inst3.Pushad o = (Inst3.Pushad)op;
                method.append("int tmpesp = CPU_Regs.reg_esp.dword;CPU.CPU_Push32(CPU_Regs.reg_eax.dword);CPU.CPU_Push32(CPU_Regs.reg_ecx.dword);CPU.CPU_Push32(CPU_Regs.reg_edx.dword);CPU.CPU_Push32(CPU_Regs.reg_ebx.dword);CPU.CPU_Push32(tmpesp);CPU.CPU_Push32(CPU_Regs.reg_ebp.dword);CPU.CPU_Push32(CPU_Regs.reg_esi.dword);CPU.CPU_Push32(CPU_Regs.reg_edi.dword);");
                return true;
            }
            case 609: {
                if (!(op instanceof Inst3.Popad)) break;
                Inst3.Popad o = (Inst3.Popad)op;
                method.append("CPU_Regs.reg_edi.dword=CPU.CPU_Pop32();CPU_Regs.reg_esi.dword=CPU.CPU_Pop32();CPU_Regs.reg_ebp.dword=CPU.CPU_Pop32();CPU.CPU_Pop32();CPU_Regs.reg_ebx.dword=CPU.CPU_Pop32();CPU_Regs.reg_edx.dword=CPU.CPU_Pop32();CPU_Regs.reg_ecx.dword=CPU.CPU_Pop32();CPU_Regs.reg_eax.dword=CPU.CPU_Pop32();");
                return true;
            }
            case 610: {
                if (!(op instanceof Inst3.BoundEd)) break;
                Inst3.BoundEd o = (Inst3.BoundEd)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int bound_min=Memory.mem_readd(eaa);int bound_max=Memory.mem_readd(eaa + 4);int rmrd = rd.dword;if (rmrd < bound_min || rmrd > bound_max) {return EXCEPTION(5);}");
                return true;
            }
            case 611: {
                if (op instanceof Inst3.ArplEdRd_reg) {
                    Inst3.ArplEdRd_reg o = (Inst3.ArplEdRd_reg)op;
                    method.append("if (((CPU.cpu.pmode) && (CPU_Regs.flags & CPU_Regs.VM)!=0) || (!CPU.cpu.pmode)) return Constants.BR_Illegal;");
                    method.append("IntRef ref = new IntRef(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    method.append("CPU.CPU_ARPL(ref, ");
                    method.append(Compiler.nameGet16(o.rd));
                    method.append(");");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=ref.value;");
                    return true;
                }
                if (!(op instanceof Inst3.ArplEdRd_mem)) break;
                Inst3.ArplEdRd_mem o = (Inst3.ArplEdRd_mem)op;
                method.append("if (((CPU.cpu.pmode) && (CPU_Regs.flags & CPU_Regs.VM)!=0) || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";IntRef ref = new IntRef(Memory.mem_readw(eaa));");
                method.append("CPU.CPU_ARPL(ref, ");
                method.append(Compiler.nameGet16(o.rd));
                method.append(");Memory.mem_writed(eaa,ref.value);");
                return true;
            }
            case 616: {
                if (!(op instanceof Inst3.PushId)) break;
                Inst3.PushId o = (Inst3.PushId)op;
                method.append("CPU.CPU_Push32(");
                method.append(o.id);
                method.append(");");
                return true;
            }
            case 617: {
                if (op instanceof Inst3.ImulGdEdId_reg) {
                    Inst3.ImulGdEdId_reg o = (Inst3.ImulGdEdId_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=Instructions.DIMULD(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(", ");
                    method.append(o.op3);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.ImulGdEdId_mem)) break;
                Inst3.ImulGdEdId_mem o = (Inst3.ImulGdEdId_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Instructions.DIMULD(Memory.mem_readd(eaa),");
                method.append(o.op3);
                method.append(");");
                return true;
            }
            case 618: {
                if (!(op instanceof Inst3.PushIb)) break;
                Inst3.PushIb o = (Inst3.PushIb)op;
                method.append("CPU.CPU_Push32(");
                method.append(o.id);
                method.append(");");
                return true;
            }
            case 619: {
                if (op instanceof Inst3.ImulGdEdIb_reg) {
                    Inst3.ImulGdEdIb_reg o = (Inst3.ImulGdEdIb_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=Instructions.DIMULD(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(", ");
                    method.append(o.op3);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.ImulGdEdIb_mem)) break;
                Inst3.ImulGdEdIb_mem o = (Inst3.ImulGdEdIb_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Instructions.DIMULD(Memory.mem_readd(eaa),");
                method.append(o.op3);
                method.append(");");
                return true;
            }
            case 621: {
                if (!(op instanceof Inst1.DoStringException)) break;
                Inst1.DoStringException o = (Inst1.DoStringException)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),");
                method.append(o.width);
                method.append(")) return RUNEXCEPTION();Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 623: {
                if (!(op instanceof Inst1.DoStringException)) break;
                Inst1.DoStringException o = (Inst1.DoStringException)op;
                method.append("if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(),");
                method.append(o.width);
                method.append(")) return RUNEXCEPTION();Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 624: {
                if (!(op instanceof Inst3.JumpCond32_b_o)) break;
                Inst3.JumpCond32_b_o o = (Inst3.JumpCond32_b_o)op;
                Compiler.compile(o, "Flags.TFLG_O()", method);
                return false;
            }
            case 625: {
                if (!(op instanceof Inst3.JumpCond32_b_no)) break;
                Inst3.JumpCond32_b_no o = (Inst3.JumpCond32_b_no)op;
                Compiler.compile(o, "Flags.TFLG_NO()", method);
                return false;
            }
            case 626: {
                if (!(op instanceof Inst3.JumpCond32_b_b)) break;
                Inst3.JumpCond32_b_b o = (Inst3.JumpCond32_b_b)op;
                Compiler.compile(o, "Flags.TFLG_B()", method);
                return false;
            }
            case 627: {
                if (!(op instanceof Inst3.JumpCond32_b_nb)) break;
                Inst3.JumpCond32_b_nb o = (Inst3.JumpCond32_b_nb)op;
                Compiler.compile(o, "Flags.TFLG_NB()", method);
                return false;
            }
            case 628: {
                if (!(op instanceof Inst3.JumpCond32_b_z)) break;
                Inst3.JumpCond32_b_z o = (Inst3.JumpCond32_b_z)op;
                Compiler.compile(o, "Flags.TFLG_Z()", method);
                return false;
            }
            case 629: {
                if (!(op instanceof Inst3.JumpCond32_b_nz)) break;
                Inst3.JumpCond32_b_nz o = (Inst3.JumpCond32_b_nz)op;
                Compiler.compile(o, "Flags.TFLG_NZ()", method);
                return false;
            }
            case 630: {
                if (!(op instanceof Inst3.JumpCond32_b_be)) break;
                Inst3.JumpCond32_b_be o = (Inst3.JumpCond32_b_be)op;
                Compiler.compile(o, "Flags.TFLG_BE()", method);
                return false;
            }
            case 631: {
                if (!(op instanceof Inst3.JumpCond32_b_nbe)) break;
                Inst3.JumpCond32_b_nbe o = (Inst3.JumpCond32_b_nbe)op;
                Compiler.compile(o, "Flags.TFLG_NBE()", method);
                return false;
            }
            case 632: {
                if (!(op instanceof Inst3.JumpCond32_b_s)) break;
                Inst3.JumpCond32_b_s o = (Inst3.JumpCond32_b_s)op;
                Compiler.compile(o, "Flags.TFLG_S()", method);
                return false;
            }
            case 633: {
                if (!(op instanceof Inst3.JumpCond32_b_ns)) break;
                Inst3.JumpCond32_b_ns o = (Inst3.JumpCond32_b_ns)op;
                Compiler.compile(o, "Flags.TFLG_NS()", method);
                return false;
            }
            case 634: {
                if (!(op instanceof Inst3.JumpCond32_b_p)) break;
                Inst3.JumpCond32_b_p o = (Inst3.JumpCond32_b_p)op;
                Compiler.compile(o, "Flags.TFLG_P()", method);
                return false;
            }
            case 635: {
                if (!(op instanceof Inst3.JumpCond32_b_np)) break;
                Inst3.JumpCond32_b_np o = (Inst3.JumpCond32_b_np)op;
                Compiler.compile(o, "Flags.TFLG_NP()", method);
                return false;
            }
            case 636: {
                if (!(op instanceof Inst3.JumpCond32_b_l)) break;
                Inst3.JumpCond32_b_l o = (Inst3.JumpCond32_b_l)op;
                Compiler.compile(o, "Flags.TFLG_L()", method);
                return false;
            }
            case 637: {
                if (!(op instanceof Inst3.JumpCond32_b_nl)) break;
                Inst3.JumpCond32_b_nl o = (Inst3.JumpCond32_b_nl)op;
                Compiler.compile(o, "Flags.TFLG_NL()", method);
                return false;
            }
            case 638: {
                if (!(op instanceof Inst3.JumpCond32_b_le)) break;
                Inst3.JumpCond32_b_le o = (Inst3.JumpCond32_b_le)op;
                Compiler.compile(o, "Flags.TFLG_LE()", method);
                return false;
            }
            case 639: {
                if (!(op instanceof Inst3.JumpCond32_b_nle)) break;
                Inst3.JumpCond32_b_nle o = (Inst3.JumpCond32_b_nle)op;
                Compiler.compile(o, "Flags.TFLG_NLE()", method);
                return false;
            }
            case 641: {
                if (op instanceof Inst3.GrplEdId_reg_add) {
                    Inst3.GrplEdId_reg_add o = (Inst3.GrplEdId_reg_add)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ADDD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_or) {
                    Inst3.GrplEdId_reg_or o = (Inst3.GrplEdId_reg_or)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ORD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_adc) {
                    Inst3.GrplEdId_reg_adc o = (Inst3.GrplEdId_reg_adc)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ADCD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_sbb) {
                    Inst3.GrplEdId_reg_sbb o = (Inst3.GrplEdId_reg_sbb)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SBBD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_and) {
                    Inst3.GrplEdId_reg_and o = (Inst3.GrplEdId_reg_and)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ANDD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_sub) {
                    Inst3.GrplEdId_reg_sub o = (Inst3.GrplEdId_reg_sub)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SUBD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_xor) {
                    Inst3.GrplEdId_reg_xor o = (Inst3.GrplEdId_reg_xor)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.XORD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_cmp) {
                    Inst3.GrplEdId_reg_cmp o = (Inst3.GrplEdId_reg_cmp)op;
                    method.append("Instructions.CMPD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_add) {
                    Inst3.GrplEdId_mem_add o = (Inst3.GrplEdId_mem_add)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ADDD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_or) {
                    Inst3.GrplEdId_mem_or o = (Inst3.GrplEdId_mem_or)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ORD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_adc) {
                    Inst3.GrplEdId_mem_adc o = (Inst3.GrplEdId_mem_adc)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ADCD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_sbb) {
                    Inst3.GrplEdId_mem_sbb o = (Inst3.GrplEdId_mem_sbb)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.SBBD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_and) {
                    Inst3.GrplEdId_mem_and o = (Inst3.GrplEdId_mem_and)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ANDD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_sub) {
                    Inst3.GrplEdId_mem_sub o = (Inst3.GrplEdId_mem_sub)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.SUBD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_xor) {
                    Inst3.GrplEdId_mem_xor o = (Inst3.GrplEdId_mem_xor)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.XORD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (!(op instanceof Inst3.GrplEdId_mem_cmp)) break;
                Inst3.GrplEdId_mem_cmp o = (Inst3.GrplEdId_mem_cmp)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.CMPD(");
                method.append(o.ib);
                method.append(" ,Memory.mem_readd(eaa));");
                return true;
            }
            case 643: {
                if (op instanceof Inst3.GrplEdId_reg_add) {
                    Inst3.GrplEdId_reg_add o = (Inst3.GrplEdId_reg_add)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ADDD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_or) {
                    Inst3.GrplEdId_reg_or o = (Inst3.GrplEdId_reg_or)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ORD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_adc) {
                    Inst3.GrplEdId_reg_adc o = (Inst3.GrplEdId_reg_adc)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ADCD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_sbb) {
                    Inst3.GrplEdId_reg_sbb o = (Inst3.GrplEdId_reg_sbb)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SBBD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_and) {
                    Inst3.GrplEdId_reg_and o = (Inst3.GrplEdId_reg_and)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ANDD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_sub) {
                    Inst3.GrplEdId_reg_sub o = (Inst3.GrplEdId_reg_sub)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SUBD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_xor) {
                    Inst3.GrplEdId_reg_xor o = (Inst3.GrplEdId_reg_xor)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.XORD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_reg_cmp) {
                    Inst3.GrplEdId_reg_cmp o = (Inst3.GrplEdId_reg_cmp)op;
                    method.append("Instructions.CMPD(");
                    method.append(o.ib);
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_add) {
                    Inst3.GrplEdId_mem_add o = (Inst3.GrplEdId_mem_add)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ADDD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_or) {
                    Inst3.GrplEdId_mem_or o = (Inst3.GrplEdId_mem_or)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ORD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_adc) {
                    Inst3.GrplEdId_mem_adc o = (Inst3.GrplEdId_mem_adc)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ADCD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_sbb) {
                    Inst3.GrplEdId_mem_sbb o = (Inst3.GrplEdId_mem_sbb)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.SBBD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_and) {
                    Inst3.GrplEdId_mem_and o = (Inst3.GrplEdId_mem_and)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.ANDD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_sub) {
                    Inst3.GrplEdId_mem_sub o = (Inst3.GrplEdId_mem_sub)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.SUBD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.GrplEdId_mem_xor) {
                    Inst3.GrplEdId_mem_xor o = (Inst3.GrplEdId_mem_xor)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writed(eaa, Instructions.XORD(");
                    method.append(o.ib);
                    method.append(" ,Memory.mem_readd(eaa)));");
                    return true;
                }
                if (!(op instanceof Inst3.GrplEdId_mem_cmp)) break;
                Inst3.GrplEdId_mem_cmp o = (Inst3.GrplEdId_mem_cmp)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.CMPD(");
                method.append(o.ib);
                method.append(" ,Memory.mem_readd(eaa));");
                return true;
            }
            case 645: {
                if (op instanceof Inst3.TestEdGd_reg) {
                    Inst3.TestEdGd_reg o = (Inst3.TestEdGd_reg)op;
                    method.append("Instructions.TESTD(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(", ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.TestEdGd_mem)) break;
                Inst3.TestEdGd_mem o = (Inst3.TestEdGd_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Instructions.TESTD(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(" ,Memory.mem_readd(eaa));");
                return true;
            }
            case 647: {
                if (op instanceof Inst3.XchgEdGd_reg) {
                    Inst3.XchgEdGd_reg o = (Inst3.XchgEdGd_reg)op;
                    method.append("int oldrmrd = ");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(";");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=oldrmrd;");
                    return true;
                }
                if (!(op instanceof Inst3.XchgEdGd_mem)) break;
                Inst3.XchgEdGd_mem o = (Inst3.XchgEdGd_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int oldrmrd = ");
                method.append(Compiler.nameGet32(o.rd));
                method.append("; int tmp = Memory.mem_readd(eaa);Memory.mem_writed(eaa, oldrmrd);");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=tmp;");
                return true;
            }
            case 649: {
                if (op instanceof Inst3.MovEdGd_reg) {
                    Inst3.MovEdGd_reg o = (Inst3.MovEdGd_reg)op;
                    method.append(Compiler.nameSet32(o.eard, Compiler.nameGet32(o.rd)));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst3.MovEdGd_mem)) break;
                Inst3.MovEdGd_mem o = (Inst3.MovEdGd_mem)op;
                method.append("Memory.mem_writed(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ");
                method.append(Compiler.nameGet32(o.rd));
                method.append(");");
                return true;
            }
            case 651: {
                if (op instanceof Inst3.MovGdEd_reg) {
                    Inst3.MovGdEd_reg o = (Inst3.MovGdEd_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst3.MovGdEd_mem)) break;
                Inst3.MovGdEd_mem o = (Inst3.MovGdEd_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readd(eaa);");
                return true;
            }
            case 652: {
                if (op instanceof Inst3.MovEdEs_reg) {
                    Inst3.MovEdEs_reg o = (Inst3.MovEdEs_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.Segs_ESval & 0xFFFF;");
                    return true;
                }
                if (op instanceof Inst1.MovEwEs_mem) {
                    Inst1.MovEwEs_mem o = (Inst1.MovEwEs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_ESval);");
                    return true;
                }
                if (op instanceof Inst3.MovEdCs_reg) {
                    Inst3.MovEdCs_reg o = (Inst3.MovEdCs_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.Segs_CSval & 0xFFFF;");
                    return true;
                }
                if (op instanceof Inst1.MovEwCs_mem) {
                    Inst1.MovEwCs_mem o = (Inst1.MovEwCs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_CSval);");
                    return true;
                }
                if (op instanceof Inst3.MovEdSs_reg) {
                    Inst3.MovEdSs_reg o = (Inst3.MovEdSs_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.Segs_SSval & 0xFFFF;");
                    return true;
                }
                if (op instanceof Inst1.MovEwSs_mem) {
                    Inst1.MovEwSs_mem o = (Inst1.MovEwSs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_SSval);");
                    return true;
                }
                if (op instanceof Inst3.MovEdDs_reg) {
                    Inst3.MovEdDs_reg o = (Inst3.MovEdDs_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.Segs_DSval & 0xFFFF;");
                    return true;
                }
                if (op instanceof Inst1.MovEwDs_mem) {
                    Inst1.MovEwDs_mem o = (Inst1.MovEwDs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_DSval);");
                    return true;
                }
                if (op instanceof Inst3.MovEdFs_reg) {
                    Inst3.MovEdFs_reg o = (Inst3.MovEdFs_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.Segs_FSval & 0xFFFF;");
                    return true;
                }
                if (op instanceof Inst1.MovEwFs_mem) {
                    Inst1.MovEwFs_mem o = (Inst1.MovEwFs_mem)op;
                    method.append("Memory.mem_writew(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(", CPU.Segs_FSval);");
                    return true;
                }
                if (op instanceof Inst3.MovEdGs_reg) {
                    Inst3.MovEdGs_reg o = (Inst3.MovEdGs_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.Segs_GSval & 0xFFFF;");
                    return true;
                }
                if (!(op instanceof Inst1.MovEwGs_mem)) break;
                Inst1.MovEwGs_mem o = (Inst1.MovEwGs_mem)op;
                method.append("Memory.mem_writew(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", CPU.Segs_GSval);");
                return true;
            }
            case 653: {
                if (op instanceof Inst3.LeaGd_32) {
                    Inst3.LeaGd_32 o = (Inst3.LeaGd_32)op;
                    method.append("Core.base_ds=Core.base_ss=0;");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Core.base_ds=CPU.Segs_DSphys;Core.base_ss=CPU.Segs_SSphys;");
                    return true;
                }
                if (!(op instanceof Inst3.LeaGd_16)) break;
                Inst3.LeaGd_16 o = (Inst3.LeaGd_16)op;
                method.append("Core.base_ds=Core.base_ss=0;");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Core.base_ds=CPU.Segs_DSphys;Core.base_ss=CPU.Segs_SSphys;");
                return true;
            }
            case 655: {
                if (op instanceof Inst3.PopEd_reg) {
                    Inst3.PopEd_reg o = (Inst3.PopEd_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.CPU_Pop32();");
                    return true;
                }
                if (!(op instanceof Inst3.PopEd_mem)) break;
                Inst3.PopEd_mem o = (Inst3.PopEd_mem)op;
                method.append("int val = CPU.CPU_Pop32();int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writed(eaa, val);");
                return true;
            }
            case 657: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 658: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 659: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 660: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 661: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 662: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 663: {
                if (!(op instanceof Inst3.XchgEax)) break;
                Inst3.XchgEax o = (Inst3.XchgEax)op;
                method.append("int old = ");
                method.append(Compiler.nameGet32(o.reg));
                method.append(";");
                method.append(Compiler.nameGet32(o.reg));
                method.append("=CPU_Regs.reg_eax.dword;CPU_Regs.reg_eax.dword=old;");
                return true;
            }
            case 664: {
                if (!(op instanceof Inst3.Cwde)) break;
                Inst3.Cwde o = (Inst3.Cwde)op;
                method.append("CPU_Regs.reg_eax.dword=(short)CPU_Regs.reg_eax.word();");
                return true;
            }
            case 665: {
                if (!(op instanceof Inst3.Cdq)) break;
                Inst3.Cdq o = (Inst3.Cdq)op;
                method.append("if ((CPU_Regs.reg_eax.dword & 0x80000000)!=0) CPU_Regs.reg_edx.dword=0xffffffff;else CPU_Regs.reg_edx.dword=0;");
                return true;
            }
            case 666: {
                if (!(op instanceof Inst3.CallFarAp)) break;
                Inst3.CallFarAp o = (Inst3.CallFarAp)op;
                method.append("Flags.FillFlags();CPU.CPU_CALL(true,");
                method.append(o.newcs);
                method.append(",");
                method.append(o.newip);
                method.append(", CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 668: {
                if (!(op instanceof Inst3.Pushfd)) break;
                Inst3.Pushfd o = (Inst3.Pushfd)op;
                method.append("if (CPU.CPU_PUSHF(true)) return RUNEXCEPTION();");
                return true;
            }
            case 669: {
                if (!(op instanceof Inst3.Popfd)) break;
                Inst3.Popfd o = (Inst3.Popfd)op;
                method.append("if (CPU.CPU_POPF(true)) return RUNEXCEPTION();");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return DECODE_END(");
                method.append(o.eip_count);
                method.append(");}");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.IF)!=0 && Pic.PIC_IRQCheck!=0) return DECODE_END(");
                method.append(o.eip_count);
                method.append(");");
                return true;
            }
            case 673: {
                if (!(op instanceof Inst3.MovEaxOd)) break;
                Inst3.MovEaxOd o = (Inst3.MovEaxOd)op;
                method.append("CPU_Regs.reg_eax.dword=Memory.mem_readd(Core.base_ds+");
                method.append(o.value);
                method.append(");");
                return true;
            }
            case 675: {
                if (!(op instanceof Inst3.MovOdEax)) break;
                Inst3.MovOdEax o = (Inst3.MovOdEax)op;
                method.append(" Memory.mem_writed(Core.base_ds+");
                method.append(o.value);
                method.append(", CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 677: {
                if (op instanceof Strings.Movsd16) {
                    method.append("Strings.Movsd16.doString();");
                    return true;
                }
                if (op instanceof Strings.Movsd16r) {
                    method.append("Strings.Movsd16r.doString();");
                    return true;
                }
                if (op instanceof Strings.Movsd32) {
                    method.append("Strings.Movsd32.doString();");
                    return true;
                }
                if (!(op instanceof Strings.Movsd32r)) break;
                method.append("Strings.Movsd32r.doString();");
                return true;
            }
            case 679: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 681: {
                if (!(op instanceof Inst3.TestEaxId)) break;
                Inst3.TestEaxId o = (Inst3.TestEaxId)op;
                method.append("Instructions.TESTD(");
                method.append(o.id);
                method.append(",CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 683: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 685: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 687: {
                if (!(op instanceof Inst1.DoString)) break;
                Inst1.DoString o = (Inst1.DoString)op;
                method.append("Core.rep_zero = ");
                method.append(o.rep_zero);
                method.append(";StringOp.DoString(");
                method.append(o.prefixes);
                method.append(", ");
                method.append(o.type);
                method.append(");");
                return true;
            }
            case 696: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 697: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 698: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 699: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 700: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 701: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 702: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 703: {
                if (!(op instanceof Inst3.MovId)) break;
                Inst3.MovId o = (Inst3.MovId)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=");
                method.append(o.id);
                method.append(";");
                return true;
            }
            case 705: {
                if (op instanceof Grp2.ROLD_reg) {
                    Grp2.ROLD_reg o = (Grp2.ROLD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.ROLD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.RORD_reg) {
                    Grp2.RORD_reg o = (Grp2.RORD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.RORD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCLD_reg) {
                    Grp2.RCLD_reg o = (Grp2.RCLD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.RCLD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRD_reg) {
                    Grp2.RCRD_reg o = (Grp2.RCRD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.RCRD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLD_reg) {
                    Grp2.SHLD_reg o = (Grp2.SHLD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.SHLD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRD_reg) {
                    Grp2.SHRD_reg o = (Grp2.SHRD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.SHRD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.SARD_reg) {
                    Grp2.SARD_reg o = (Grp2.SARD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.SARD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.ROLD_mem) {
                    Grp2.ROLD_mem o = (Grp2.ROLD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.ROLD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RORD_mem) {
                    Grp2.RORD_mem o = (Grp2.RORD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.RORD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCLD_mem) {
                    Grp2.RCLD_mem o = (Grp2.RCLD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.RCLD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRD_mem) {
                    Grp2.RCRD_mem o = (Grp2.RCRD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.RCRD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLD_mem) {
                    Grp2.SHLD_mem o = (Grp2.SHLD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.SHLD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRD_mem) {
                    Grp2.SHRD_mem o = (Grp2.SHRD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.SHRD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (!(op instanceof Grp2.SARD_mem)) break;
                Grp2.SARD_mem o = (Grp2.SARD_mem)op;
                if (o.val != 0) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.SARD(");
                    method.append(o.val);
                    method.append(", Memory.mem_readd(eaa)));");
                }
                return true;
            }
            case 706: {
                if (!(op instanceof Inst3.Retn32Iw)) break;
                Inst3.Retn32Iw o = (Inst3.Retn32Iw)op;
                method.append("CPU_Regs.reg_eip=CPU.CPU_Pop32();CPU_Regs.reg_esp.dword=CPU_Regs.reg_esp.dword+");
                method.append(o.offset);
                method.append(";return Constants.BR_Jump;");
                return false;
            }
            case 707: {
                if (!(op instanceof Inst3.Retn32)) break;
                Inst3.Retn32 o = (Inst3.Retn32)op;
                method.append("CPU_Regs.reg_eip=CPU.CPU_Pop32();return Constants.BR_Jump;");
                return false;
            }
            case 708: {
                if (!(op instanceof Inst3.Les32)) break;
                Inst3.Les32 o = (Inst3.Les32)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa+4))) return RUNEXCEPTION();");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readd(eaa);");
                return true;
            }
            case 709: {
                if (!(op instanceof Inst3.Lds32)) break;
                Inst3.Lds32 o = (Inst3.Lds32)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append("; if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa+4))) return RUNEXCEPTION();");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readd(eaa);Core.base_ds=CPU.Segs_DSphys;Core.base_val_ds= CPU_Regs.ds;");
                return true;
            }
            case 711: {
                if (op instanceof Inst3.MovId) {
                    Inst3.MovId o = (Inst3.MovId)op;
                    method.append(Compiler.nameGet32(o.reg));
                    method.append("=");
                    method.append(o.id);
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst3.MovId_mem)) break;
                Inst3.MovId_mem o = (Inst3.MovId_mem)op;
                method.append("Memory.mem_writed(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(", ");
                method.append(o.id);
                method.append(");");
                return true;
            }
            case 712: {
                if (!(op instanceof Inst3.Enter32IwIb)) break;
                Inst3.Enter32IwIb o = (Inst3.Enter32IwIb)op;
                method.append("CPU.CPU_ENTER(true,");
                method.append(o.bytes);
                method.append(", ");
                method.append(o.level);
                method.append(");");
                return true;
            }
            case 713: {
                if (!(op instanceof Inst3.Leave32)) break;
                Inst3.Leave32 o = (Inst3.Leave32)op;
                method.append("CPU_Regs.reg_esp.dword&=CPU.cpu.stack.notmask;CPU_Regs.reg_esp.dword|=(CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask);CPU_Regs.reg_ebp.dword=CPU.CPU_Pop32();");
                return true;
            }
            case 714: {
                if (!(op instanceof Inst3.Retf32Iw)) break;
                Inst3.Retf32Iw o = (Inst3.Retf32Iw)op;
                method.append("Flags.FillFlags();CPU.CPU_RET(true,");
                method.append(o.words);
                method.append(", CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");return Constants.BR_Jump;");
                return false;
            }
            case 715: {
                if (!(op instanceof Inst3.Retf32)) break;
                Inst3.Retf32 o = (Inst3.Retf32)op;
                method.append("Flags.FillFlags();CPU.CPU_RET(true,0,CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");return Constants.BR_Jump;");
                return false;
            }
            case 719: {
                if (!(op instanceof Inst3.IRet32)) break;
                Inst3.IRet32 o = (Inst3.IRet32)op;
                method.append("CPU.CPU_IRET(true, CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.IF)!=0 && Pic.PIC_IRQCheck!=0) return CB_NONE();");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 721: {
                if (op instanceof Grp2.ROLD_reg) {
                    Grp2.ROLD_reg o = (Grp2.ROLD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.ROLD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.RORD_reg) {
                    Grp2.RORD_reg o = (Grp2.RORD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.RORD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCLD_reg) {
                    Grp2.RCLD_reg o = (Grp2.RCLD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.RCLD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRD_reg) {
                    Grp2.RCRD_reg o = (Grp2.RCRD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.RCRD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLD_reg) {
                    Grp2.SHLD_reg o = (Grp2.SHLD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.SHLD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRD_reg) {
                    Grp2.SHRD_reg o = (Grp2.SHRD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.SHRD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.SARD_reg) {
                    Grp2.SARD_reg o = (Grp2.SARD_reg)op;
                    if (o.val != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.SARD(");
                        method.append(o.val);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (op instanceof Grp2.ROLD_mem) {
                    Grp2.ROLD_mem o = (Grp2.ROLD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.ROLD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RORD_mem) {
                    Grp2.RORD_mem o = (Grp2.RORD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.RORD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCLD_mem) {
                    Grp2.RCLD_mem o = (Grp2.RCLD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.RCLD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.RCRD_mem) {
                    Grp2.RCRD_mem o = (Grp2.RCRD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.RCRD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHLD_mem) {
                    Grp2.SHLD_mem o = (Grp2.SHLD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.SHLD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (op instanceof Grp2.SHRD_mem) {
                    Grp2.SHRD_mem o = (Grp2.SHRD_mem)op;
                    if (o.val != 0) {
                        method.append("int eaa = ");
                        Compiler.toStringValue(o.get_eaa, method);
                        method.append(";Memory.mem_writed(eaa, Instructions.SHRD(");
                        method.append(o.val);
                        method.append(", Memory.mem_readd(eaa)));");
                    }
                    return true;
                }
                if (!(op instanceof Grp2.SARD_mem)) break;
                Grp2.SARD_mem o = (Grp2.SARD_mem)op;
                if (o.val != 0) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.SARD(");
                    method.append(o.val);
                    method.append(", Memory.mem_readd(eaa)));");
                }
                return true;
            }
            case 723: {
                if (op instanceof Grp2.ROLD_reg_cl) {
                    Grp2.ROLD_reg_cl o = (Grp2.ROLD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.ROLD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.RORD_reg_cl) {
                    Grp2.RORD_reg_cl o = (Grp2.RORD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.RORD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.RCLD_reg_cl) {
                    Grp2.RCLD_reg_cl o = (Grp2.RCLD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.RCLD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.RCRD_reg_cl) {
                    Grp2.RCRD_reg_cl o = (Grp2.RCRD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.RCRD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.SHLD_reg_cl) {
                    Grp2.SHLD_reg_cl o = (Grp2.SHLD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SHLD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.SHRD_reg_cl) {
                    Grp2.SHRD_reg_cl o = (Grp2.SHRD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SHRD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.SARD_reg_cl) {
                    Grp2.SARD_reg_cl o = (Grp2.SARD_reg_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.SARD(val, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp2.ROLD_mem_cl) {
                    Grp2.ROLD_mem_cl o = (Grp2.ROLD_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.ROLD(val, Memory.mem_readd(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.RORD_mem_cl) {
                    Grp2.RORD_mem_cl o = (Grp2.RORD_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.RORD(val, Memory.mem_readd(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.RCLD_mem_cl) {
                    Grp2.RCLD_mem_cl o = (Grp2.RCLD_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.RCLD(val, Memory.mem_readd(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.RCRD_mem_cl) {
                    Grp2.RCRD_mem_cl o = (Grp2.RCRD_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.RCRD(val, Memory.mem_readd(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.SHLD_mem_cl) {
                    Grp2.SHLD_mem_cl o = (Grp2.SHLD_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.SHLD(val, Memory.mem_readd(eaa)));}");
                    return true;
                }
                if (op instanceof Grp2.SHRD_mem_cl) {
                    Grp2.SHRD_mem_cl o = (Grp2.SHRD_mem_cl)op;
                    method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.SHRD(val, Memory.mem_readd(eaa)));}");
                    return true;
                }
                if (!(op instanceof Grp2.SARD_mem_cl)) break;
                Grp2.SARD_mem_cl o = (Grp2.SARD_mem_cl)op;
                method.append("int val = CPU_Regs.reg_ecx.low() & 0x1f;if (val != 0) {int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writed(eaa, Instructions.SARD(val, Memory.mem_readd(eaa)));}");
                return true;
            }
            case 736: {
                if (op instanceof Inst3.Loopnz32) {
                    Inst3.Loopnz32 o = (Inst3.Loopnz32)op;
                    method.append("CPU_Regs.reg_ecx.dword--;");
                    Compiler.compile(o, "CPU_Regs.reg_ecx.dword!=0 && !Flags.get_ZF()", method);
                    return false;
                }
                if (!(op instanceof Inst3.Loopnz16)) break;
                Inst3.Loopnz16 o = (Inst3.Loopnz16)op;
                method.append("CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word()-1);");
                Compiler.compile(o, "CPU_Regs.reg_ecx.word()!=0 && !Flags.get_ZF()", method);
                return false;
            }
            case 737: {
                if (op instanceof Inst3.Loopz32) {
                    Inst3.Loopz32 o = (Inst3.Loopz32)op;
                    method.append("CPU_Regs.reg_ecx.dword--;");
                    Compiler.compile(o, "CPU_Regs.reg_ecx.dword!=0 && Flags.get_ZF()", method);
                    return false;
                }
                if (!(op instanceof Inst3.Loopz16)) break;
                Inst3.Loopz16 o = (Inst3.Loopz16)op;
                method.append("CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word()-1);");
                Compiler.compile(o, "CPU_Regs.reg_ecx.word()!=0 && Flags.get_ZF()", method);
                return false;
            }
            case 738: {
                if (op instanceof Inst3.Loop32) {
                    Inst3.Loop32 o = (Inst3.Loop32)op;
                    method.append("CPU_Regs.reg_ecx.dword--;");
                    Compiler.compile(o, "CPU_Regs.reg_ecx.dword!=0", method);
                    return false;
                }
                if (!(op instanceof Inst3.Loop16)) break;
                Inst3.Loop16 o = (Inst3.Loop16)op;
                method.append("CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word()-1);");
                Compiler.compile(o, "CPU_Regs.reg_ecx.word()!=0", method);
                return false;
            }
            case 739: {
                if (!(op instanceof Inst3.Jcxz)) break;
                Inst3.Jcxz o = (Inst3.Jcxz)op;
                Compiler.compile(o, "(CPU_Regs.reg_ecx.dword & " + o.mask + ")==0", method);
                return false;
            }
            case 741: {
                if (!(op instanceof Inst3.InEaxIb)) break;
                Inst3.InEaxIb o = (Inst3.InEaxIb)op;
                method.append("if (CPU.CPU_IO_Exception(");
                method.append(o.port);
                method.append(",4)) return RUNEXCEPTION();CPU_Regs.reg_eax.dword=IO.IO_ReadD(");
                method.append(o.port);
                method.append(");");
                return true;
            }
            case 743: {
                if (!(op instanceof Inst3.OutEaxIb)) break;
                Inst3.OutEaxIb o = (Inst3.OutEaxIb)op;
                method.append("if (CPU.CPU_IO_Exception(");
                method.append(o.port);
                method.append(",4)) return RUNEXCEPTION();IO.IO_WriteD(");
                method.append(o.port);
                method.append(",CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 744: {
                if (!(op instanceof Inst3.CallJd)) break;
                Inst3.CallJd o = (Inst3.CallJd)op;
                method.append("CPU.CPU_Push32(CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");CPU_Regs.reg_eip+=");
                method.append(o.addip + (long)o.eip_count);
                method.append(";return Constants.BR_Link1;");
                return false;
            }
            case 745: {
                if (!(op instanceof Inst3.JmpJd)) break;
                Inst3.JmpJd o = (Inst3.JmpJd)op;
                method.append("CPU_Regs.reg_eip+=");
                method.append((long)o.eip_count + o.addip);
                method.append(";return Constants.BR_Link1;");
                return false;
            }
            case 746: {
                if (!(op instanceof Inst3.JmpAd)) break;
                Inst3.JmpAd o = (Inst3.JmpAd)op;
                method.append("Flags.FillFlags();CPU.CPU_JMP(true,");
                method.append(o.newcs);
                method.append(", ");
                method.append(o.newip);
                method.append(", CPU_Regs.reg_eip+");
                method.append(o.eip_count);
                method.append(");");
                method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                method.append("return Constants.BR_Jump;");
                return false;
            }
            case 747: {
                if (!(op instanceof Inst3.JmpJb)) break;
                Inst3.JmpJb o = (Inst3.JmpJb)op;
                method.append("CPU_Regs.reg_eip+=");
                method.append(o.eip_count + o.addip);
                method.append(";return Constants.BR_Link1;");
                return false;
            }
            case 749: {
                if (!(op instanceof Inst3.InEaxDx)) break;
                Inst3.InEaxDx o = (Inst3.InEaxDx)op;
                method.append("CPU_Regs.reg_eax.dword=IO.IO_ReadD(CPU_Regs.reg_edx.word());");
                return true;
            }
            case 751: {
                if (!(op instanceof Inst3.OutEaxDx)) break;
                Inst3.OutEaxDx o = (Inst3.OutEaxDx)op;
                method.append("IO.IO_WriteD(CPU_Regs.reg_edx.word(),CPU_Regs.reg_eax.dword);");
                return true;
            }
            case 759: {
                if (op instanceof Grp3.Testd_reg) {
                    Grp3.Testd_reg o = (Grp3.Testd_reg)op;
                    method.append("Instructions.TESTD(");
                    method.append(o.val);
                    method.append(",");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.Testd_mem) {
                    Grp3.Testd_mem o = (Grp3.Testd_mem)op;
                    method.append("Instructions.TESTD(");
                    method.append(o.val);
                    method.append(",Memory.mem_readd(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("));");
                    return true;
                }
                if (op instanceof Grp3.NotEd_reg) {
                    Grp3.NotEd_reg o = (Grp3.NotEd_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=~");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";");
                    return true;
                }
                if (op instanceof Grp3.NotEd_mem) {
                    Grp3.NotEd_mem o = (Grp3.NotEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa,~Memory.mem_readd(eaa));");
                    return true;
                }
                if (op instanceof Grp3.NegEd_reg) {
                    Grp3.NegEd_reg o = (Grp3.NegEd_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.Negd(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.NegEd_mem) {
                    Grp3.NegEd_mem o = (Grp3.NegEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.Negd(Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Grp3.MulAxEd_reg) {
                    Grp3.MulAxEd_reg o = (Grp3.MulAxEd_reg)op;
                    method.append("Instructions.MULD(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.MulAxEd_mem) {
                    Grp3.MulAxEd_mem o = (Grp3.MulAxEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Instructions.MULD(Memory.mem_readd(eaa));");
                    return true;
                }
                if (op instanceof Grp3.IMulAxEd_reg) {
                    Grp3.IMulAxEd_reg o = (Grp3.IMulAxEd_reg)op;
                    method.append("Instructions.IMULD(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (op instanceof Grp3.IMulAxEd_mem) {
                    Grp3.IMulAxEd_mem o = (Grp3.IMulAxEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Instructions.IMULD(Memory.mem_readd(eaa));");
                    return true;
                }
                if (op instanceof Grp3.DivAxEd_reg) {
                    Grp3.DivAxEd_reg o = (Grp3.DivAxEd_reg)op;
                    method.append("int val = ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";if (Instructions.DIVDr(this, val)==Constants.BR_Jump) return Constants.BR_Jump;");
                    return true;
                }
                if (op instanceof Grp3.DivAxEd_mem) {
                    Grp3.DivAxEd_mem o = (Grp3.DivAxEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int val = Memory.mem_readd(eaa);");
                    method.append("if (Instructions.DIVDr(this, val)==Constants.BR_Jump) return Constants.BR_Jump;");
                    return true;
                }
                if (op instanceof Grp3.IDivAxEd_reg) {
                    Grp3.IDivAxEd_reg o = (Grp3.IDivAxEd_reg)op;
                    method.append("int val = ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";if (Instructions.IDIVDr(this, val)==Constants.BR_Jump) return Constants.BR_Jump;");
                    return true;
                }
                if (!(op instanceof Grp3.IDivAxEd_mem)) break;
                Grp3.IDivAxEd_mem o = (Grp3.IDivAxEd_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int val = Memory.mem_readd(eaa);");
                method.append("if (Instructions.IDIVDr(this, val)==Constants.BR_Jump) return Constants.BR_Jump;");
                return true;
            }
            case 767: {
                if (op instanceof Inst3.Incd_reg) {
                    Inst3.Incd_reg o = (Inst3.Incd_reg)op;
                    method.append(Compiler.nameGet32(o.reg));
                    method.append(" = Instructions.INCD(");
                    method.append(Compiler.nameGet32(o.reg));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.Incd_mem) {
                    Inst3.Incd_mem o = (Inst3.Incd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.INCD(Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.Decd_reg) {
                    Inst3.Decd_reg o = (Inst3.Decd_reg)op;
                    method.append(Compiler.nameGet32(o.reg));
                    method.append(" = Instructions.DECD(");
                    method.append(Compiler.nameGet32(o.reg));
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst3.Decd_mem) {
                    Inst3.Decd_mem o = (Inst3.Decd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.DECD(Memory.mem_readd(eaa)));");
                    return true;
                }
                if (op instanceof Inst3.CallNearEd_reg) {
                    Inst3.CallNearEd_reg o = (Inst3.CallNearEd_reg)op;
                    method.append("int old = CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(";CPU.CPU_Push32(old);CPU_Regs.reg_eip=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst3.CallNearEd_mem) {
                    Inst3.CallNearEd_mem o = (Inst3.CallNearEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old = CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(";int eip = Memory.mem_readd(eaa); CPU.CPU_Push32(old);CPU_Regs.reg_eip = eip;return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst3.CallFarEd_mem) {
                    Inst3.CallFarEd_mem o = (Inst3.CallFarEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int newip=Memory.mem_readd(eaa);int newcs=Memory.mem_readw(eaa+4);Flags.FillFlags();CPU.CPU_CALL(true,newcs,newip,CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(");");
                    method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                    method.append("return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst3.JmpNearEd_reg) {
                    Inst3.JmpNearEd_reg o = (Inst3.JmpNearEd_reg)op;
                    method.append("CPU_Regs.reg_eip = ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst3.JmpNearEd_mem) {
                    Inst3.JmpNearEd_mem o = (Inst3.JmpNearEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";CPU_Regs.reg_eip=Memory.mem_readd(eaa);return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst3.JmpFarEd_mem) {
                    Inst3.JmpFarEd_mem o = (Inst3.JmpFarEd_mem)op;
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int newip=Memory.mem_readd(eaa);int newcs=Memory.mem_readw(eaa+4);Flags.FillFlags();CPU.CPU_JMP(true,newcs,newip,CPU_Regs.reg_eip+");
                    method.append(o.eip_count);
                    method.append(");");
                    method.append("if (CPU_Regs.GETFLAG(CPU_Regs.TF)!=0) {CPU.cpudecoder= Core_dynamic.CPU_Core_Dynrec_Trap_Run;return CB_NONE();}");
                    method.append("return Constants.BR_Jump;");
                    return false;
                }
                if (op instanceof Inst3.PushEd_reg) {
                    Inst3.PushEd_reg o = (Inst3.PushEd_reg)op;
                    method.append("CPU.CPU_Push32(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst3.PushEd_mem)) break;
                Inst3.PushEd_mem o = (Inst3.PushEd_mem)op;
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";CPU.CPU_Push32(Memory.mem_readd(eaa));");
                return true;
            }
            case 769: {
                if (op instanceof Inst2.Sgdt_mem) {
                    Inst2.Sgdt_mem o = (Inst2.Sgdt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa,CPU.CPU_SGDT_limit());Memory.mem_writed(eaa+2,CPU.CPU_SGDT_base());");
                    return true;
                }
                if (op instanceof Inst2.Sidt_mem) {
                    Inst2.Sidt_mem o = (Inst2.Sidt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writew(eaa,CPU.CPU_SIDT_limit());Memory.mem_writed(eaa+2,CPU.CPU_SIDT_base());");
                    return true;
                }
                if (op instanceof Inst4.Lgdt_mem) {
                    Inst4.Lgdt_mem o = (Inst4.Lgdt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);CPU.CPU_LGDT(Memory.mem_readw(eaa),Memory.mem_readd(eaa + 2));");
                    return true;
                }
                if (op instanceof Inst4.Lidt_mem) {
                    Inst4.Lidt_mem o = (Inst4.Lidt_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);CPU.CPU_LIDT(Memory.mem_readw(eaa),Memory.mem_readd(eaa + 2));");
                    return true;
                }
                if (op instanceof Inst2.Smsw_mem) {
                    Inst2.Smsw_mem o = (Inst2.Smsw_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append("; Memory.mem_writew(eaa,CPU.CPU_SMSW());");
                    return true;
                }
                if (op instanceof Inst2.Lmsw_mem) {
                    Inst2.Lmsw_mem o = (Inst2.Lmsw_mem)op;
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";if (CPU.CPU_LMSW(Memory.mem_readw(eaa))) return RUNEXCEPTION();");
                    return true;
                }
                if (op instanceof Inst2.Invlpg) {
                    Inst2.Invlpg o = (Inst2.Invlpg)op;
                    method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);Paging.PAGING_ClearTLB();");
                    return true;
                }
                if (op instanceof Inst2.Lgdt_reg) {
                    Inst2.Lgdt_reg o = (Inst2.Lgdt_reg)op;
                    method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);return Constants.BR_Illegal;");
                    return false;
                }
                if (op instanceof Inst2.Lidt_reg) {
                    Inst2.Lidt_reg o = (Inst2.Lidt_reg)op;
                    method.append("if (CPU.cpu.pmode && CPU.cpu.cpl!=0) return EXCEPTION(CPU.EXCEPTION_GP);return Constants.BR_Illegal;");
                    return false;
                }
                if (op instanceof Inst4.Smsw_reg) {
                    Inst4.Smsw_reg o = (Inst4.Smsw_reg)op;
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=CPU.CPU_SMSW();");
                    return true;
                }
                if (!(op instanceof Inst4.Lmsw_reg)) break;
                Inst4.Lmsw_reg o = (Inst4.Lmsw_reg)op;
                method.append("if (CPU.CPU_LMSW(");
                method.append(Compiler.nameGet32(o.eard));
                method.append(")) return RUNEXCEPTION();");
                return true;
            }
            case 770: {
                if (op instanceof Inst4.LarGdEd_reg) {
                    Inst4.LarGdEd_reg o = (Inst4.LarGdEd_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;IntRef value=new IntRef(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(");CPU.CPU_LAR(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(",value);");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=value.value;");
                    return true;
                }
                if (!(op instanceof Inst4.LarGdEd_mem)) break;
                Inst4.LarGdEd_mem o = (Inst4.LarGdEd_mem)op;
                method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";IntRef value=new IntRef(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(");CPU.CPU_LAR(Memory.mem_readw(eaa),value);");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=value.value;");
                return true;
            }
            case 771: {
                if (op instanceof Inst4.LslGdEd_reg) {
                    Inst4.LslGdEd_reg o = (Inst4.LslGdEd_reg)op;
                    method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;IntRef value=new IntRef(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(");CPU.CPU_LSL(");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(",value);");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=value.value;");
                    return true;
                }
                if (!(op instanceof Inst4.LslGdEd_mem)) break;
                Inst4.LslGdEd_mem o = (Inst4.LslGdEd_mem)op;
                method.append("if ((CPU_Regs.flags & CPU_Regs.VM)!=0 || (!CPU.cpu.pmode)) return Constants.BR_Illegal;int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";IntRef value=new IntRef(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(");CPU.CPU_LSL(Memory.mem_readw(eaa),value);");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=value.value;");
                return true;
            }
            case 896: {
                if (!(op instanceof Inst4.JumpCond32_d_o)) break;
                Inst4.JumpCond32_d_o o = (Inst4.JumpCond32_d_o)op;
                Compiler.compile(o, "Flags.TFLG_O()", method);
                return false;
            }
            case 897: {
                if (!(op instanceof Inst4.JumpCond32_d_no)) break;
                Inst4.JumpCond32_d_no o = (Inst4.JumpCond32_d_no)op;
                Compiler.compile(o, "Flags.TFLG_NO()", method);
                return false;
            }
            case 898: {
                if (!(op instanceof Inst4.JumpCond32_d_b)) break;
                Inst4.JumpCond32_d_b o = (Inst4.JumpCond32_d_b)op;
                Compiler.compile(o, "Flags.TFLG_B()", method);
                return false;
            }
            case 899: {
                if (!(op instanceof Inst4.JumpCond32_d_nb)) break;
                Inst4.JumpCond32_d_nb o = (Inst4.JumpCond32_d_nb)op;
                Compiler.compile(o, "Flags.TFLG_NB()", method);
                return false;
            }
            case 900: {
                if (!(op instanceof Inst4.JumpCond32_d_z)) break;
                Inst4.JumpCond32_d_z o = (Inst4.JumpCond32_d_z)op;
                Compiler.compile(o, "Flags.TFLG_Z()", method);
                return false;
            }
            case 901: {
                if (!(op instanceof Inst4.JumpCond32_d_nz)) break;
                Inst4.JumpCond32_d_nz o = (Inst4.JumpCond32_d_nz)op;
                Compiler.compile(o, "Flags.TFLG_NZ()", method);
                return false;
            }
            case 902: {
                if (!(op instanceof Inst4.JumpCond32_d_be)) break;
                Inst4.JumpCond32_d_be o = (Inst4.JumpCond32_d_be)op;
                Compiler.compile(o, "Flags.TFLG_BE()", method);
                return false;
            }
            case 903: {
                if (!(op instanceof Inst4.JumpCond32_d_nbe)) break;
                Inst4.JumpCond32_d_nbe o = (Inst4.JumpCond32_d_nbe)op;
                Compiler.compile(o, "Flags.TFLG_NBE()", method);
                return false;
            }
            case 904: {
                if (!(op instanceof Inst4.JumpCond32_d_s)) break;
                Inst4.JumpCond32_d_s o = (Inst4.JumpCond32_d_s)op;
                Compiler.compile(o, "Flags.TFLG_S()", method);
                return false;
            }
            case 905: {
                if (!(op instanceof Inst4.JumpCond32_d_ns)) break;
                Inst4.JumpCond32_d_ns o = (Inst4.JumpCond32_d_ns)op;
                Compiler.compile(o, "Flags.TFLG_NS()", method);
                return false;
            }
            case 906: {
                if (!(op instanceof Inst4.JumpCond32_d_p)) break;
                Inst4.JumpCond32_d_p o = (Inst4.JumpCond32_d_p)op;
                Compiler.compile(o, "Flags.TFLG_P()", method);
                return false;
            }
            case 907: {
                if (!(op instanceof Inst4.JumpCond32_d_np)) break;
                Inst4.JumpCond32_d_np o = (Inst4.JumpCond32_d_np)op;
                Compiler.compile(o, "Flags.TFLG_NP()", method);
                return false;
            }
            case 908: {
                if (!(op instanceof Inst4.JumpCond32_d_l)) break;
                Inst4.JumpCond32_d_l o = (Inst4.JumpCond32_d_l)op;
                Compiler.compile(o, "Flags.TFLG_L()", method);
                return false;
            }
            case 909: {
                if (!(op instanceof Inst4.JumpCond32_d_nl)) break;
                Inst4.JumpCond32_d_nl o = (Inst4.JumpCond32_d_nl)op;
                Compiler.compile(o, "Flags.TFLG_NL()", method);
                return false;
            }
            case 910: {
                if (!(op instanceof Inst4.JumpCond32_d_le)) break;
                Inst4.JumpCond32_d_le o = (Inst4.JumpCond32_d_le)op;
                Compiler.compile(o, "Flags.TFLG_LE()", method);
                return false;
            }
            case 911: {
                if (!(op instanceof Inst4.JumpCond32_d_nle)) break;
                Inst4.JumpCond32_d_nle o = (Inst4.JumpCond32_d_nle)op;
                Compiler.compile(o, "Flags.TFLG_NLE()", method);
                return false;
            }
            case 928: {
                if (!(op instanceof Inst4.PushFS)) break;
                Inst4.PushFS o = (Inst4.PushFS)op;
                method.append("CPU.CPU_Push32(CPU.Segs_FSval);");
                return true;
            }
            case 929: {
                if (!(op instanceof Inst4.PopFS)) break;
                Inst4.PopFS o = (Inst4.PopFS)op;
                method.append("if (CPU.CPU_PopSegFS(true)) return RUNEXCEPTION();");
                return true;
            }
            case 931: {
                if (op instanceof Inst4.BtEdGd_reg) {
                    Inst4.BtEdGd_reg o = (Inst4.BtEdGd_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(" & 31);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & mask)!=0);");
                    return true;
                }
                if (!(op instanceof Inst4.BtEdGd_mem)) break;
                Inst4.BtEdGd_mem o = (Inst4.BtEdGd_mem)op;
                method.append("Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet32(o.rd));
                method.append(" & 31);int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";eaa+=(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(">>5)*4;int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);");
                return true;
            }
            case 932: {
                if (op instanceof Inst4.ShldEdGdIb_reg) {
                    Inst4.ShldEdGdIb_reg o = (Inst4.ShldEdGdIb_reg)op;
                    if (o.op3 != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.DSHLD(");
                        method.append(Compiler.nameGet32(o.rd));
                        method.append(", ");
                        method.append(o.op3);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (!(op instanceof Inst4.ShldEdGdIb_mem)) break;
                Inst4.ShldEdGdIb_mem o = (Inst4.ShldEdGdIb_mem)op;
                if (o.op3 != 0) {
                    method.append("int eaa = ");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.DSHLD(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(", ");
                    method.append(o.op3);
                    method.append(", Memory.mem_readd(eaa)));");
                }
                return true;
            }
            case 933: {
                if (op instanceof Inst4.ShldEdGdCl_reg) {
                    Inst4.ShldEdGdCl_reg o = (Inst4.ShldEdGdCl_reg)op;
                    method.append("int op3=CPU_Regs.reg_ecx.low() & 0x1F;if (op3!=0)");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.DSHLD(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(", op3, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst4.ShldEdGdCl_mem)) break;
                Inst4.ShldEdGdCl_mem o = (Inst4.ShldEdGdCl_mem)op;
                method.append("int op3=CPU_Regs.reg_ecx.low() & 0x1F;if (op3!=0) {");
                method.append("int eaa = ");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writed(eaa, Instructions.DSHLD(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(", op3, Memory.mem_readd(eaa)));}");
                return true;
            }
            case 936: {
                if (!(op instanceof Inst4.PushGS)) break;
                Inst4.PushGS o = (Inst4.PushGS)op;
                method.append("CPU.CPU_Push32(CPU.Segs_GSval);");
                return true;
            }
            case 937: {
                if (!(op instanceof Inst4.PopGS)) break;
                Inst4.PopGS o = (Inst4.PopGS)op;
                method.append("if (CPU.CPU_PopSegGS(true)) return RUNEXCEPTION();");
                return true;
            }
            case 939: {
                if (op instanceof Inst4.BtsEdGd_reg) {
                    Inst4.BtsEdGd_reg o = (Inst4.BtsEdGd_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(" & 31);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & mask)!=0);");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("|=mask;");
                    return true;
                }
                if (!(op instanceof Inst4.BtsEdGd_mem)) break;
                Inst4.BtsEdGd_mem o = (Inst4.BtsEdGd_mem)op;
                method.append("Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet32(o.rd));
                method.append(" & 31);int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";eaa+=(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(">>5)*4;int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);Memory.mem_writed(eaa,old | mask);");
                return true;
            }
            case 940: {
                if (op instanceof Inst4.ShrdEdGdIb_reg) {
                    Inst4.ShrdEdGdIb_reg o = (Inst4.ShrdEdGdIb_reg)op;
                    if (o.op3 != 0) {
                        method.append(Compiler.nameGet32(o.eard));
                        method.append("=Instructions.DSHRD(");
                        method.append(Compiler.nameGet32(o.rd));
                        method.append(", ");
                        method.append(o.op3);
                        method.append(", ");
                        method.append(Compiler.nameGet32(o.eard));
                        method.append(");");
                    }
                    return true;
                }
                if (!(op instanceof Inst4.ShrdEdGdIb_mem)) break;
                Inst4.ShrdEdGdIb_mem o = (Inst4.ShrdEdGdIb_mem)op;
                if (o.op3 != 0) {
                    method.append("int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";Memory.mem_writed(eaa, Instructions.DSHRD(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(", ");
                    method.append(o.op3);
                    method.append(", Memory.mem_readd(eaa)));");
                }
                return true;
            }
            case 941: {
                if (op instanceof Inst4.ShrdEdGdCl_reg) {
                    Inst4.ShrdEdGdCl_reg o = (Inst4.ShrdEdGdCl_reg)op;
                    method.append("int op3 = CPU_Regs.reg_ecx.low() & 0x1F;if (op3!=0)");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=Instructions.DSHRD(");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(", op3, ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst4.ShrdEdGdCl_mem)) break;
                Inst4.ShrdEdGdCl_mem o = (Inst4.ShrdEdGdCl_mem)op;
                method.append("int op3=CPU_Regs.reg_ecx.low() & 0x1F;if (op3!=0) {int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Memory.mem_writed(eaa, Instructions.DSHRD(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(", op3, Memory.mem_readd(eaa)));}");
                return true;
            }
            case 943: {
                if (op instanceof Inst4.ImulGdEd_reg) {
                    Inst4.ImulGdEd_reg o = (Inst4.ImulGdEd_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=Instructions.DIMULD(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(",");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst4.ImulGdEd_mem)) break;
                Inst4.ImulGdEd_mem o = (Inst4.ImulGdEd_mem)op;
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Instructions.DIMULD(Memory.mem_readd(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append("),");
                method.append(Compiler.nameGet32(o.rd));
                method.append(");");
                return true;
            }
            case 945: {
                if (op instanceof Inst4.CmpxchgEdGd_reg) {
                    Inst4.CmpxchgEdGd_reg o = (Inst4.CmpxchgEdGd_reg)op;
                    method.append("Flags.FillFlags();if (CPU_Regs.reg_eax.dword == ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(") {");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("=");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {CPU_Regs.reg_eax.dword=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);}");
                    return true;
                }
                if (!(op instanceof Inst4.CmpxchgEdGd_mem)) break;
                Inst4.CmpxchgEdGd_mem o = (Inst4.CmpxchgEdGd_mem)op;
                method.append("Flags.FillFlags();int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int val = Memory.mem_readd(eaa);if (CPU_Regs.reg_eax.dword == val) {Memory.mem_writed(eaa,");
                method.append(Compiler.nameGet32(o.rd));
                method.append(");CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {Memory.mem_writed(eaa,val);CPU_Regs.reg_eax.dword=val;CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);}");
                return true;
            }
            case 946: {
                if (!(op instanceof Inst4.LssEd)) break;
                Inst4.LssEd o = (Inst4.LssEd)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa+4))) return RUNEXCEPTION();");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readd(eaa);Core.base_ss=CPU.Segs_SSphys;");
                return true;
            }
            case 947: {
                if (op instanceof Inst4.BtrEdGd_reg) {
                    Inst4.BtrEdGd_reg o = (Inst4.BtrEdGd_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(" & 31);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & mask)!=0);");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("&=~mask;");
                    return true;
                }
                if (!(op instanceof Inst4.BtrEdGd_mem)) break;
                Inst4.BtrEdGd_mem o = (Inst4.BtrEdGd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";Flags.FillFlags();int mask=1 << (");
                method.append(Compiler.nameGet32(o.rd));
                method.append(" & 31);eaa+=(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(">>5)*4;int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);Memory.mem_writed(eaa,old & ~mask);");
                return true;
            }
            case 948: {
                if (!(op instanceof Inst4.LfsEd)) break;
                Inst4.LfsEd o = (Inst4.LfsEd)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa+4))) return RUNEXCEPTION();");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readd(eaa);");
                return true;
            }
            case 949: {
                if (!(op instanceof Inst4.LgsEd)) break;
                Inst4.LgsEd o = (Inst4.LgsEd)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa+4))) return RUNEXCEPTION();");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readd(eaa);");
                return true;
            }
            case 950: {
                if (op instanceof Inst4.MovzxGdEb_reg) {
                    Inst4.MovzxGdEb_reg o = (Inst4.MovzxGdEb_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst4.MovzxGdEb_mem)) break;
                Inst4.MovzxGdEb_mem o = (Inst4.MovzxGdEb_mem)op;
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 951: {
                if (op instanceof Inst4.MovzxGdEw_reg) {
                    Inst4.MovzxGdEw_reg o = (Inst4.MovzxGdEw_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst4.MovzxGdEw_mem)) break;
                Inst4.MovzxGdEw_mem o = (Inst4.MovzxGdEw_mem)op;
                method.append(Compiler.nameGet32(o.rd));
                method.append("=Memory.mem_readw(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 954: {
                if (op instanceof Inst4.BtEdIb_reg) {
                    Inst4.BtEdIb_reg o = (Inst4.BtEdIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    return true;
                }
                if (op instanceof Inst4.BtsEdIb_reg) {
                    Inst4.BtsEdIb_reg o = (Inst4.BtsEdIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("|=");
                    method.append(o.mask);
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst4.BtrEdIb_reg) {
                    Inst4.BtrEdIb_reg o = (Inst4.BtrEdIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("&=~");
                    method.append(o.mask);
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst4.BtcEdIb_reg) {
                    Inst4.BtcEdIb_reg o = (Inst4.BtcEdIb_reg)op;
                    method.append("Flags.FillFlags();CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    method.append("if (CPU_Regs.GETFLAG(CPU_Regs.CF)!=0) ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("&=~");
                    method.append(o.mask);
                    method.append(";else ");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("|=");
                    method.append(o.mask);
                    method.append(";");
                    return true;
                }
                if (op instanceof Inst4.BtEdIb_mem) {
                    Inst4.BtEdIb_mem o = (Inst4.BtEdIb_mem)op;
                    method.append("Flags.FillFlags();int old=Memory.mem_readd(");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(");CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                    method.append(o.mask);
                    method.append(")!=0);");
                    return true;
                }
                if (op instanceof Inst4.BtsEdIb_mem) {
                    Inst4.BtsEdIb_mem o = (Inst4.BtsEdIb_mem)op;
                    method.append("Flags.FillFlags();int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                    method.append(o.mask);
                    method.append(")!=0);Memory.mem_writed(eaa,old|");
                    method.append(o.mask);
                    method.append(");");
                    return true;
                }
                if (op instanceof Inst4.BtrEdIb_mem) {
                    Inst4.BtrEdIb_mem o = (Inst4.BtrEdIb_mem)op;
                    method.append("Flags.FillFlags();int eaa=");
                    Compiler.toStringValue(o.get_eaa, method);
                    method.append(";int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                    method.append(o.mask);
                    method.append(")!=0);Memory.mem_writed(eaa,old & ~");
                    method.append(o.mask);
                    method.append(");");
                    return true;
                }
                if (!(op instanceof Inst4.BtcEdIb_mem)) break;
                Inst4.BtcEdIb_mem o = (Inst4.BtcEdIb_mem)op;
                method.append("Flags.FillFlags();int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & ");
                method.append(o.mask);
                method.append(")!=0);if (CPU_Regs.GETFLAG(CPU_Regs.CF)!=0) old&=~");
                method.append(o.mask);
                method.append(";else old|=");
                method.append(o.mask);
                method.append(";Memory.mem_writed(eaa,old);");
                return true;
            }
            case 955: {
                if (op instanceof Inst4.BtcEdGd_reg) {
                    Inst4.BtcEdGd_reg o = (Inst4.BtcEdGd_reg)op;
                    method.append("Flags.FillFlags();int mask=1 << (");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(" & 31);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(" & mask)!=0);");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("^=mask;");
                    return true;
                }
                if (!(op instanceof Inst4.BtcEdGd_mem)) break;
                Inst4.BtcEdGd_mem o = (Inst4.BtcEdGd_mem)op;
                method.append("Flags.FillFlags();");
                method.append("int mask=1 << (");
                method.append(Compiler.nameGet32(o.rd));
                method.append(" & 31);int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";eaa+=(");
                method.append(Compiler.nameGet32(o.rd));
                method.append(">>5)*4;int old=Memory.mem_readd(eaa);CPU_Regs.SETFLAGBIT(CPU_Regs.CF,(old & mask)!=0);Memory.mem_writed(eaa,old ^ mask);");
                return true;
            }
            case 956: {
                if (op instanceof Inst4.BsfGdEd_reg) {
                    Inst4.BsfGdEd_reg o = (Inst4.BsfGdEd_reg)op;
                    method.append("int value=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 0;while ((value & 0x01)==0) { result++; value>>>=1; } CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=result;}Flags.lflags.type=Flags.t_UNKNOWN;");
                    return true;
                }
                if (!(op instanceof Inst4.BsfGdEd_mem)) break;
                Inst4.BsfGdEd_mem o = (Inst4.BsfGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int value=Memory.mem_readd(eaa);");
                method.append("if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 0;while ((value & 0x01)==0) { result++; value>>>=1; } CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=result;}Flags.lflags.type=Flags.t_UNKNOWN;");
                return true;
            }
            case 957: {
                if (op instanceof Inst4.BsrGdEd_reg) {
                    Inst4.BsrGdEd_reg o = (Inst4.BsrGdEd_reg)op;
                    method.append("int value=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 31;while ((value & 0x80000000)==0) { result--; value<<=1; } CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=result;} Flags.lflags.type=Flags.t_UNKNOWN;");
                    return true;
                }
                if (!(op instanceof Inst4.BsrGdEd_mem)) break;
                Inst4.BsrGdEd_mem o = (Inst4.BsrGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int value=Memory.mem_readd(eaa);if (value==0) {CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,true);} else {int result = 31;while ((value & 0x80000000)==0) { result--; value<<=1; }CPU_Regs.SETFLAGBIT(CPU_Regs.ZF,false);");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=result;}Flags.lflags.type=Flags.t_UNKNOWN;");
                return true;
            }
            case 958: {
                if (op instanceof Inst4.MovsxGdEb_reg) {
                    Inst4.MovsxGdEb_reg o = (Inst4.MovsxGdEb_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=(byte)");
                    method.append(Compiler.nameGet8(o.earb));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst4.MovsxGdEb_mem)) break;
                Inst4.MovsxGdEb_mem o = (Inst4.MovsxGdEb_mem)op;
                method.append(Compiler.nameGet32(o.rd));
                method.append("=(byte)Memory.mem_readb(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 959: {
                if (op instanceof Inst4.MovsxGdEw_reg) {
                    Inst4.MovsxGdEw_reg o = (Inst4.MovsxGdEw_reg)op;
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=(short)");
                    method.append(Compiler.nameGet16(o.earw));
                    method.append(";");
                    return true;
                }
                if (!(op instanceof Inst4.MovsxGdEw_mem)) break;
                Inst4.MovsxGdEw_mem o = (Inst4.MovsxGdEw_mem)op;
                method.append(Compiler.nameGet32(o.rd));
                method.append("=(short)Memory.mem_readw(");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(");");
                return true;
            }
            case 961: {
                if (op instanceof Inst4.XaddGdEd_reg) {
                    Inst4.XaddGdEd_reg o = (Inst4.XaddGdEd_reg)op;
                    method.append("int oldrmrd=");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append(";");
                    method.append(Compiler.nameGet32(o.rd));
                    method.append("=");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append(";");
                    method.append(Compiler.nameGet32(o.eard));
                    method.append("+=oldrmrd;");
                    return true;
                }
                if (!(op instanceof Inst4.XaddGdEd_mem)) break;
                Inst4.XaddGdEd_mem o = (Inst4.XaddGdEd_mem)op;
                method.append("int eaa=");
                Compiler.toStringValue(o.get_eaa, method);
                method.append(";int oldrmrd=");
                method.append(Compiler.nameGet32(o.rd));
                method.append(";int val = Memory.mem_readd(eaa);Memory.mem_writed(eaa,val+oldrmrd);");
                method.append(Compiler.nameGet32(o.rd));
                method.append("=val;");
                return true;
            }
            case 968: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 969: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 970: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 971: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 972: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 973: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 974: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            case 975: {
                if (!(op instanceof Inst4.Bswapd)) break;
                Inst4.Bswapd o = (Inst4.Bswapd)op;
                method.append(Compiler.nameGet32(o.reg));
                method.append("=Instructions.BSWAPD(");
                method.append(Compiler.nameGet32(o.reg));
                method.append(");");
                return true;
            }
            default: {
                if (op instanceof Inst1.Illegal) {
                    Inst1.Illegal o = (Inst1.Illegal)op;
                    method.append("Log.log(LogTypes.LOG_CPU, LogSeverities.LOG_ERROR,");
                    method.append(o.msg);
                    method.append(");return Constants.BR_Illegal;");
                    return false;
                }
                if (op instanceof Decoder.HandledSegChange) {
                    method.append("Core.base_ds= CPU.Segs_DSphys;Core.base_ss=CPU.Segs_SSphys;Core.base_val_ds=CPU_Regs.ds;");
                    return true;
                }
                if (op instanceof Decoder.HandledDecode) {
                    return true;
                }
                if (op instanceof Decoder.ModifiedDecodeOp) {
                    method.append("return ModifiedDecode.call();");
                    return false;
                }
                Log.exit("[Compiler] Unhandled op: " + op);
            }
        }
        return true;
    }

    private static Op compileMethod(Op op, StringBuffer method, boolean jump) {
        try {
            String className = "CacheBlock" + count++;
            CtClass codeBlock = pool.makeClass(className);
            codeBlock.setSuperclass(pool.getCtClass("jdos.cpu.core_dynamic.Op"));
            if (!jump) {
                method.append("return Constants.BR_Normal;");
            }
            method.append("}");
            CtMethod m = CtNewMethod.make("public int call() {" + method.toString(), codeBlock);
            codeBlock.addMethod(m);
            Op o = op;
            int cycle = 0;
            while (o != null) {
                cycle = o.cycle;
                o = o.next;
            }
            if (cycle < 1) {
                cycle = 1;
            }
            CtConstructor c = CtNewConstructor.make("public " + className + "(){this.cycle=" + cycle + ";}", codeBlock);
            codeBlock.addConstructor(c);
            URLClassLoader cl = (URLClassLoader)codeBlock.getClass().getClassLoader();
            cl = URLClassLoader.newInstance(cl.getURLs(), cl);
            Class clazz = codeBlock.toClass(cl, null);
            Op compiledCode = (Op)clazz.newInstance();
            codeBlock.detach();
            if (saveClasses) {
                if (op instanceof DecodeBlock) {
                    DecodeBlock block = (DecodeBlock)op;
                    String header = "package jdos.cpu.core_dynamic;\n\nimport jdos.cpu.core_dynamic.*;\nimport jdos.cpu.*;\nimport jdos.fpu.*;\nimport jdos.hardware.*;\nimport jdos.util.*;\nimport jdos.cpu.core_normal.*;\nimport jdos.cpu.core_share.*;\n\npublic final class " + className + " extends Op {\npublic int call() {";
                    Loader.add(codeBlock.getName(), codeBlock.toBytecode(), block.codeStart, Compiler.getOpCode(block.codeStart, block.codeLen), header + method.toString() + "\n}");
                } else {
                    Log.exit("Tried to save an incomplete code block");
                }
            }
            return compiledCode;
        }
        catch (Exception e) {
            System.out.println(method.toString());
            e.printStackTrace();
            return null;
        }
    }

    static {
        compilerThread = new Thread[1];
        for (int i = 0; i < compilerThread.length; ++i) {
            Compiler.compilerThread[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        while (true) {
                            DecodeBlock nextBlock = null;
                            LinkedList linkedList = compilerQueue;
                            synchronized (linkedList) {
                                if (compilerQueue.isEmpty()) {
                                    compilerQueue.wait();
                                }
                                if (!compilerQueue.isEmpty()) {
                                    nextBlock = (DecodeBlock)compilerQueue.pop();
                                }
                            }
                            if (nextBlock != null) {
                                if (!nextBlock.active) continue;
                                Compiler.do_compile(nextBlock);
                                nextBlock.op = nextBlock.next;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            compilerThread[i].start();
        }
        cacheCount = 0;
        pool = ClassPool.getDefault();
        pool.importPackage("jdos.cpu.core_dynamic");
        pool.importPackage("jdos.cpu");
        pool.importPackage("jdos.fpu");
        pool.importPackage("jdos.hardware");
        pool.importPackage("jdos.util");
        pool.importPackage("jdos.cpu.core_normal");
        pool.importPackage("jdos.cpu.core_share");
        pool.insertClassPath(new ClassPath(){

            public InputStream openClassfile(String s) throws NotFoundException {
                if (s.startsWith("jdos.")) {
                    s = "/" + s.replace('.', '/') + ".class";
                    return (class$jdos$Dosbox == null ? (class$jdos$Dosbox = Compiler.class$("jdos.Dosbox")) : class$jdos$Dosbox).getResourceAsStream(s.substring(6));
                }
                return null;
            }

            public URL find(String s) {
                if (s.startsWith("jdos.")) {
                    s = "/" + s.replace('.', '/') + ".class";
                    return (class$jdos$Dosbox == null ? (class$jdos$Dosbox = Compiler.class$("jdos.Dosbox")) : class$jdos$Dosbox).getResource(s.substring(6));
                }
                return null;
            }

            public void close() {
            }
        });
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
        count = 0;
        Compiler_Init = new Section.SectionFunction(){

            public void call(Section newconfig) {
                Section_prop section = (Section_prop)newconfig;
                DecodeBlock.compileThreshold = section.Get_int("threshold");
                min_block_size = section.Get_int("min_block_size");
            }
        };
    }
}

