/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU_Regs;
import jdos.cpu.Instructions;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Mod;
import jdos.cpu.core_dynamic.Op;
import jdos.hardware.Memory;

public class Grp2
extends Helper {

    public static class SARD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SARD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.SARD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class SHRD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SHRD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.SHRD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class SHLD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SHLD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.SHLD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class RCRD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RCRD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.RCRD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class RCLD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RCLD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.RCLD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class RORD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RORD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.RORD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class ROLD_mem_cl
    extends Op {
        EaaBase get_eaa;

        public ROLD_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.ROLD(val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class SARD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public SARD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.SARD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class SHRD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public SHRD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.SHRD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class SHLD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public SHLD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.SHLD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class RCRD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public RCRD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.RCRD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class RCLD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public RCLD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.RCLD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class RORD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public RORD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.RORD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class ROLD_reg_cl
    extends Op {
        CPU_Regs.Reg eard;

        public ROLD_reg_cl(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (val != 0) {
                this.eard.dword = Instructions.ROLD(val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class SARD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public SARD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.SARD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class SHRD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public SHRD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.SHRD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class SHLD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public SHLD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.SHLD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class RCRD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public RCRD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.RCRD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class RCLD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public RCLD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.RCLD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class RORD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public RORD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.RORD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class ROLD_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public ROLD_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (this.val != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.ROLD(this.val, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static class SARD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public SARD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.SARD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class SHRD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public SHRD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.SHRD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class SHLD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public SHLD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.SHLD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class RCRD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public RCRD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.RCRD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class RCLD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public RCLD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.RCLD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class RORD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public RORD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.RORD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class ROLD_reg
    extends Op {
        int val;
        CPU_Regs.Reg eard;

        public ROLD_reg(int rm, int val) {
            this.val = val;
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (this.val != 0) {
                this.eard.dword = Instructions.ROLD(this.val, this.eard.dword);
            }
            return 4;
        }
    }

    public static class SARW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SARW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SARW(val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_SARW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class SHRW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SHRW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHRW(val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_SHRW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class SHLW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SHLW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHLW(val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_SHLW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class RCRW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RCRW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCRW(val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_RCRW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class RCLW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RCLW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCLW(val)) {
                Memory.mem_writew(eaa, Instructions.do_RCLW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class RORW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RORW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val;
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RORW(eaa, val = CPU_Regs.reg_ecx.low() & 0x1F)) {
                Memory.mem_writew(eaa, Instructions.do_RORW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class ROLW_mem_cl
    extends Op {
        EaaBase get_eaa;

        public ROLW_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val;
            int eaa = this.get_eaa.call();
            if (Instructions.valid_ROLW(eaa, val = CPU_Regs.reg_ecx.low() & 0x1F)) {
                Memory.mem_writew(eaa, Instructions.do_ROLW(val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class SARW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public SARW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SARW(val)) {
                this.earw.word(Instructions.do_SARW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class SHRW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public SHRW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHRW(val)) {
                this.earw.word(Instructions.do_SHRW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class SHLW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public SHLW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHLW(val)) {
                this.earw.word(Instructions.do_SHLW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class RCRW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public RCRW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCRW(val)) {
                this.earw.word(Instructions.do_RCRW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class RCLW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public RCLW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCLW(val)) {
                this.earw.word(Instructions.do_RCLW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class RORW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public RORW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RORW(this.earw.word(), val)) {
                this.earw.word(Instructions.do_RORW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class ROLW_reg_cl
    extends Op {
        CPU_Regs.Reg earw;

        public ROLW_reg_cl(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_ROLW(this.earw.word(), val)) {
                this.earw.word(Instructions.do_ROLW(val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class SARB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SARB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SARB(val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writeb(eaa, Instructions.do_SARB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class SHRB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SHRB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHRB(CPU_Regs.reg_ecx.low())) {
                int eaa = this.get_eaa.call();
                Memory.mem_writeb(eaa, Instructions.do_SHRB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class SHLB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public SHLB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHLB(val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writeb(eaa, Instructions.do_SHLB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class RCRB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RCRB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCRB(val)) {
                Memory.mem_writeb(eaa, Instructions.do_RCRB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class RCLB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RCLB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCLB(val)) {
                Memory.mem_writeb(eaa, Instructions.do_RCLB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class RORB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public RORB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val;
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RORB(eaa, val = CPU_Regs.reg_ecx.low() & 0x1F)) {
                Memory.mem_writeb(eaa, Instructions.do_RORB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class ROLB_mem_cl
    extends Op {
        EaaBase get_eaa;

        public ROLB_mem_cl(EaaBase get_eaa) {
            this.get_eaa = get_eaa;
        }

        public int call() {
            int val;
            int eaa = this.get_eaa.call();
            if (Instructions.valid_ROLB(eaa, val = CPU_Regs.reg_ecx.low() & 0x1F)) {
                Memory.mem_writeb(eaa, Instructions.do_ROLB(val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class SARB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public SARB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SARB(val)) {
                this.earb.set8(Instructions.do_SARB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class SHRB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public SHRB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHRB(val)) {
                this.earb.set8(Instructions.do_SHRB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class SHLB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public SHLB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_SHLB(val)) {
                this.earb.set8(Instructions.do_SHLB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class RCRB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public RCRB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCRB(val)) {
                this.earb.set8(Instructions.do_RCRB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class RCLB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public RCLB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RCLB(val)) {
                this.earb.set8(Instructions.do_RCLB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class RORB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public RORB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_RORB(this.earb.get8(), val)) {
                this.earb.set8(Instructions.do_RORB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class ROLB_reg_cl
    extends Op {
        CPU_Regs.Reg earb;

        public ROLB_reg_cl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            int val = CPU_Regs.reg_ecx.low() & 0x1F;
            if (Instructions.valid_ROLB(this.earb.get8(), val)) {
                this.earb.set8(Instructions.do_ROLB(val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class SARW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public SARW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_SARW(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_SARW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class SHRW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public SHRW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_SHRW(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_SHRW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class SHLW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public SHLW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_SHLW(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_SHLW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class RCRW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public RCRW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_RCRW(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_RCRW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class RCLW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public RCLW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RCLW(this.val)) {
                Memory.mem_writew(eaa, Instructions.do_RCLW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class RORW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public RORW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RORW(eaa, this.val)) {
                Memory.mem_writew(eaa, Instructions.do_RORW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class ROLW_mem
    extends Op {
        int val;
        EaaBase get_eaa;

        public ROLW_mem(EaaBase get_eaa, int val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_ROLW(eaa, this.val)) {
                Memory.mem_writew(eaa, Instructions.do_ROLW(this.val, Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static class SARW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public SARW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_SARW(this.val)) {
                this.earw.word(Instructions.do_SARW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class SHRW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public SHRW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_SHRW(this.val)) {
                this.earw.word(Instructions.do_SHRW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class SHLW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public SHLW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_SHLW(this.val)) {
                this.earw.word(Instructions.do_SHLW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class RCRW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public RCRW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_RCRW(this.val)) {
                this.earw.word(Instructions.do_RCRW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class RCLW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public RCLW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_RCLW(this.val)) {
                this.earw.word(Instructions.do_RCLW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class RORW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public RORW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_RORW(this.earw.word(), this.val)) {
                this.earw.word(Instructions.do_RORW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class ROLW_reg
    extends Op {
        int val;
        CPU_Regs.Reg earw;

        public ROLW_reg(int rm, int val) {
            this.val = val;
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_ROLW(this.earw.word(), this.val)) {
                this.earw.word(Instructions.do_ROLW(this.val, this.earw.word()));
            }
            return 4;
        }
    }

    public static class SARB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public SARB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_SARB(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writeb(eaa, Instructions.do_SARB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class SHRB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public SHRB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_SHRB(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writeb(eaa, Instructions.do_SHRB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class SHLB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public SHLB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            if (Instructions.valid_SHLB(this.val)) {
                int eaa = this.get_eaa.call();
                Memory.mem_writeb(eaa, Instructions.do_SHLB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class RCRB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public RCRB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RCRB(this.val)) {
                Memory.mem_writeb(eaa, Instructions.do_RCRB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class RCLB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public RCLB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RCLB(this.val)) {
                Memory.mem_writeb(eaa, Instructions.do_RCLB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class RORB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public RORB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_RORB(eaa, this.val)) {
                Memory.mem_writeb(eaa, Instructions.do_RORB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class ROLB_mem
    extends Op {
        short val;
        EaaBase get_eaa;

        public ROLB_mem(EaaBase get_eaa, short val) {
            this.get_eaa = get_eaa;
            this.val = val;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (Instructions.valid_ROLB(eaa, this.val)) {
                Memory.mem_writeb(eaa, Instructions.do_ROLB(this.val, Memory.mem_readb(eaa)));
            }
            return 4;
        }
    }

    public static class SARB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public SARB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_SARB(this.val)) {
                this.earb.set8(Instructions.do_SARB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class SHRB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public SHRB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_SHRB(this.val)) {
                this.earb.set8(Instructions.do_SHRB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class SHLB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public SHLB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_SHLB(this.val)) {
                this.earb.set8(Instructions.do_SHLB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class RCRB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public RCRB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_RCRB(this.val)) {
                this.earb.set8(Instructions.do_RCRB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class RCLB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public RCLB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_RCLB(this.val)) {
                this.earb.set8(Instructions.do_RCLB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class RORB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public RORB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_RORB(this.earb.get8(), this.val)) {
                this.earb.set8(Instructions.do_RORB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }

    public static class ROLB_reg
    extends Op {
        short val;
        CPU_Regs.Reg earb;

        public ROLB_reg(int rm, short val) {
            this.val = val;
            this.earb = Mod.eb(rm);
        }

        public int call() {
            if (Instructions.valid_ROLB(this.earb.get8(), this.val)) {
                this.earb.set8(Instructions.do_ROLB(this.val, this.earb.get8()));
            }
            return 4;
        }
    }
}

