/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Mod;
import jdos.cpu.core_dynamic.Op;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.util.IntRef;

public class Inst2
extends Helper {

    public static final class Bswapw
    extends Op {
        CPU_Regs.Reg reg;

        public Bswapw(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.word(Instructions.BSWAPW(this.reg.word()));
            return 4;
        }
    }

    public static final class XaddGwEw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public XaddGwEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int oldrmrb = this.rw.word();
            int val = Memory.mem_readw(eaa);
            Memory.mem_writew(eaa, val + oldrmrb);
            this.rw.word(val);
            return 4;
        }
    }

    public static final class XaddGwEw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;

        public XaddGwEw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int oldrmrw = this.rw.word();
            this.rw.word(this.earw.word());
            this.earw.word(this.earw.word() + oldrmrw);
            return 4;
        }
    }

    public static final class XaddGbEb_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rb;

        public XaddGbEb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rb = Mod.gb(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            short oldrmrb = this.rb.get8();
            short val = Memory.mem_readb(eaa);
            Memory.mem_writeb(eaa, val + oldrmrb);
            this.rb.set8(val);
            return 4;
        }
    }

    public static final class XaddGbEb_reg
    extends Op {
        CPU_Regs.Reg earb;
        CPU_Regs.Reg rb;

        public XaddGbEb_reg(int rm) {
            this.earb = Mod.eb(rm);
            this.rb = Mod.gb(rm);
        }

        public int call() {
            short oldrmrb = this.rb.get8();
            this.rb.set8(this.earb.get8());
            this.earb.set8((short)(this.earb.get8() + oldrmrb));
            return 4;
        }
    }

    public static final class MovsxGwEb_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public MovsxGwEb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word((byte)Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static final class MovsxGwEb_reg
    extends Op {
        CPU_Regs.Reg earb;
        CPU_Regs.Reg rw;

        public MovsxGwEb_reg(int rm) {
            this.earb = Mod.eb(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            this.rw.word((byte)this.earb.get8());
            return 4;
        }
    }

    public static final class BsrGwEw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public BsrGwEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int value = Memory.mem_readw(eaa);
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 15;
                while ((value & 0x8000) == 0) {
                    --result;
                    value <<= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rw.word(result);
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BsrGwEw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;

        public BsrGwEw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int value = this.earw.word();
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 15;
                while ((value & 0x8000) == 0) {
                    --result;
                    value <<= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rw.word(result);
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BsfGwEw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public BsfGwEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int value = Memory.mem_readw(eaa);
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 0;
                while ((value & 1) == 0) {
                    ++result;
                    value >>= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rw.word(result);
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BsfGwEw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;

        public BsfGwEw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int value = this.earw.word();
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 0;
                while ((value & 1) == 0) {
                    ++result;
                    value >>= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rw.word(result);
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BtcEwGw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public BtcEwGw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rw.word() & 0xF);
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa += ((short)this.rw.word() >> 4) * 2);
            CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
            Memory.mem_writew(eaa, old ^ mask);
            return 4;
        }
    }

    public static final class BtcEwGw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;

        public BtcEwGw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rw.word() & 0xF);
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & mask) != 0);
            this.earw.word(this.earw.word() ^ mask);
            return 4;
        }
    }

    public static final class BtcEwIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtcEwIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            Memory.mem_writew(eaa, old ^ this.mask);
            return 4;
        }
    }

    public static final class BtrEwIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtrEwIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            Memory.mem_writew(eaa, old & ~this.mask);
            return 4;
        }
    }

    public static final class BtsEwIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtsEwIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            Memory.mem_writew(eaa, old | this.mask);
            return 4;
        }
    }

    public static final class BtEwIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtEwIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            return 4;
        }
    }

    public static final class BtcEwIb_reg
    extends Op {
        CPU_Regs.Reg earw;
        int mask;

        public BtcEwIb_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & this.mask) != 0);
            this.earw.word(this.earw.word() ^ this.mask);
            return 4;
        }
    }

    public static final class BtrEwIb_reg
    extends Op {
        CPU_Regs.Reg earw;
        int mask;

        public BtrEwIb_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & this.mask) != 0);
            this.earw.word(this.earw.word() & ~this.mask);
            return 4;
        }
    }

    public static final class BtsEwIb_reg
    extends Op {
        CPU_Regs.Reg earw;
        int mask;

        public BtsEwIb_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & this.mask) != 0);
            this.earw.word(this.earw.word() | this.mask);
            return 4;
        }
    }

    public static final class BtEwIb_reg
    extends Op {
        CPU_Regs.Reg earw;
        int mask;

        public BtEwIb_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0xF);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & this.mask) != 0);
            return 4;
        }
    }

    public static final class MovzxGwEw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public MovzxGwEw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class MovzxGwEw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public MovzxGwEw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.rw.word(this.earw.word());
            return 4;
        }
    }

    public static final class MovzxGwEb_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public MovzxGwEb_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word(Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static final class MovzxGwEb_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earb;

        public MovzxGwEb_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.rw.word(this.earb.get8());
            return 4;
        }
    }

    public static final class LgsEw
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public LgsEw(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa + 2))) {
                return this.RUNEXCEPTION();
            }
            this.rw.word(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class LfsEw
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public LfsEw(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa + 2))) {
                return this.RUNEXCEPTION();
            }
            this.rw.word(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class BtrEwGw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public BtrEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Flags.FillFlags();
            int mask = 1 << (this.rw.word() & 0xF);
            int old = Memory.mem_readw(eaa += ((short)this.rw.word() >> 4) * 2);
            CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
            Memory.mem_writew(eaa, old & ~mask);
            return 4;
        }
    }

    public static final class BtrEwGw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public BtrEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rw.word() & 0xF);
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & mask) != 0);
            this.earw.word(this.earw.word() & ~mask);
            return 4;
        }
    }

    public static final class LssEw
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public LssEw(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa + 2))) {
                return this.RUNEXCEPTION();
            }
            this.rw.word(Memory.mem_readw(eaa));
            Core.base_ss = CPU.Segs_SSphys;
            return 4;
        }
    }

    public static final class CmpxchgEwGw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public CmpxchgEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int val = Memory.mem_readw(eaa);
            if (CPU_Regs.reg_eax.word() == val) {
                Memory.mem_writew(eaa, this.rw.word());
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                Memory.mem_writew(eaa, val);
                CPU_Regs.reg_eax.word(val);
                CPU_Regs.SETFLAGBIT(64, false);
            }
            return 4;
        }
    }

    public static final class CmpxchgEwGw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public CmpxchgEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            Flags.FillFlags();
            if (CPU_Regs.reg_eax.word() == this.earw.word()) {
                this.earw.word(this.rw.word());
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                CPU_Regs.reg_eax.word(this.earw.word());
                CPU_Regs.SETFLAGBIT(64, false);
            }
            return 4;
        }
    }

    public static final class CmpxchgEbGb_mem
    extends Op {
        CPU_Regs.Reg rb;
        EaaBase get_eaa;

        public CmpxchgEbGb_mem(int rm) {
            this.rb = Mod.gb(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            short val = Memory.mem_readb(eaa);
            if (CPU_Regs.reg_eax.low() == val) {
                Memory.mem_writeb(eaa, this.rb.get8());
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                Memory.mem_writeb(eaa, val);
                CPU_Regs.reg_eax.low(val);
                CPU_Regs.SETFLAGBIT(64, false);
            }
            return 4;
        }
    }

    public static final class CmpxchgEbGb_reg
    extends Op {
        CPU_Regs.Reg rb;
        CPU_Regs.Reg earb;

        public CmpxchgEbGb_reg(int rm) {
            this.rb = Mod.gb(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            Flags.FillFlags();
            if (CPU_Regs.reg_eax.low() == this.earb.get8()) {
                this.earb.set8(this.rb.get8());
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                CPU_Regs.reg_eax.low(this.earb.get8());
                CPU_Regs.SETFLAGBIT(64, false);
            }
            return 4;
        }
    }

    public static final class ImulGwEw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public ImulGwEw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word(Instructions.DIMULW(Memory.mem_readw(eaa), this.rw.word()));
            return 4;
        }
    }

    public static final class ImulGwEw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public ImulGwEw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.rw.word(Instructions.DIMULW(this.earw.word(), this.rw.word()));
            return 4;
        }
    }

    public static final class ShrdEwGwCl_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public ShrdEwGwCl_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if (Instructions.valid_DSHRW(CPU_Regs.reg_ecx.low())) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_DSHRW(this.rw.word(), CPU_Regs.reg_ecx.low(), Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static final class ShrdEwGwCl_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public ShrdEwGwCl_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_DSHRW(CPU_Regs.reg_ecx.low())) {
                this.earw.word(Instructions.do_DSHRW(this.rw.word(), CPU_Regs.reg_ecx.low(), this.earw.word()));
            }
            return 4;
        }
    }

    public static final class ShrdEwGwIb_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;
        int op3;

        public ShrdEwGwIb_mem(int rm, EaaBase get_eaa, int op3) {
            this.rw = Mod.gw(rm);
            this.get_eaa = get_eaa;
            this.op3 = op3;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.do_DSHRW(this.rw.word(), this.op3, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class ShrdEwGwIb_reg
    extends Op {
        int op3;
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public ShrdEwGwIb_reg(int rm, CPU_Regs.Reg earw, int op3) {
            this.rw = Mod.gw(rm);
            this.earw = earw;
            this.op3 = op3;
        }

        public int call() {
            this.earw.word(Instructions.do_DSHRW(this.rw.word(), this.op3, this.earw.word()));
            return 4;
        }
    }

    public static final class BtsEwGw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public BtsEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rw.word() & 0xF);
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa += ((short)this.rw.word() >> 4) * 2);
            CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
            Memory.mem_writew(eaa, old | mask);
            return 4;
        }
    }

    public static final class BtsEwGw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public BtsEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rw.word() & 0xF);
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & mask) != 0);
            this.earw.word(this.earw.word() | mask);
            return 4;
        }
    }

    public static final class PopGS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegGS(false)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class PushGS
    extends Op {
        public int call() {
            CPU.CPU_Push16(CPU.Segs_GSval);
            return 4;
        }
    }

    public static final class ShldEwGwCl_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public ShldEwGwCl_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if (Instructions.valid_DSHLW(CPU_Regs.reg_ecx.low())) {
                int eaa = this.get_eaa.call();
                Memory.mem_writew(eaa, Instructions.do_DSHLW(this.rw.word(), CPU_Regs.reg_ecx.low(), Memory.mem_readw(eaa)));
            }
            return 4;
        }
    }

    public static final class ShldEwGwCl_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public ShldEwGwCl_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (Instructions.valid_DSHLW(CPU_Regs.reg_ecx.low())) {
                this.earw.word(Instructions.do_DSHLW(this.rw.word(), CPU_Regs.reg_ecx.low(), this.earw.word()));
            }
            return 4;
        }
    }

    public static final class ShldEwGwIb_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;
        int op3;

        public ShldEwGwIb_mem(int rm, EaaBase get_eaa, int op3) {
            this.rw = Mod.gw(rm);
            this.get_eaa = get_eaa;
            this.op3 = op3;
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.do_DSHLW(this.rw.word(), this.op3, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class ShldEwGwIb_reg
    extends Op {
        int op3;
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public ShldEwGwIb_reg(int rm, CPU_Regs.Reg earw, int op3) {
            this.rw = Mod.gw(rm);
            this.earw = earw;
            this.op3 = op3;
        }

        public int call() {
            this.earw.word(Instructions.do_DSHLW(this.rw.word(), this.op3, this.earw.word()));
            return 4;
        }
    }

    public static final class BtEwGw_mem
    extends Op {
        int mask;
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public BtEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            this.mask = 1 << (this.rw.word() & 0xF);
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readw(eaa += ((short)this.rw.word() >> 4) * 2);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            return 4;
        }
    }

    public static final class BtEwGw_reg
    extends Op {
        int mask;
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public BtEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            Flags.FillFlags();
            this.mask = 1 << (this.rw.word() & 0xF);
            CPU_Regs.SETFLAGBIT(1, (this.earw.word() & this.mask) != 0);
            return 4;
        }
    }

    public static final class CPUID
    extends Op {
        public int call() {
            if (!CPU.CPU_CPUID()) {
                return 6;
            }
            return 4;
        }
    }

    public static final class PopFS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegFS(false)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class PushFS
    extends Op {
        public int call() {
            CPU.CPU_Push16(CPU.Segs_FSval);
            return 4;
        }
    }

    public static final class SETcc_mem_nle
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_nle(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NLE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_nle
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_nle(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NLE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_le
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_le(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_LE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_le
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_le(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_LE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_nl
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_nl(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NL() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_nl
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_nl(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NL() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_l
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_l(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_L() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_l
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_l(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_L() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_np
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_np(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NP() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_np
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_np(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NP() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_p
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_p(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_P() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_p
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_p(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_P() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_ns
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_ns(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NS() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_ns
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_ns(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NS() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_s
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_s(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_S() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_s
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_s(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_S() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_nbe
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_nbe(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NBE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_nbe
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_nbe(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NBE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_be
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_be(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_BE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_be
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_be(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_BE() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_nz
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_nz(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NZ() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_nz
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_nz(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NZ() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_z
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_z(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_Z() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_z
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_z(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_Z() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_nb
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_nb(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NB() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_nb
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_nb(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NB() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_b
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_b(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_B() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_b
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_b(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_B() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_no
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_no(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_NO() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_no
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_no(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_NO() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_mem_o
    extends Op {
        EaaBase get_eaa;

        public SETcc_mem_o(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, (short)(Flags.TFLG_O() ? 1 : 0));
            return 4;
        }
    }

    public static final class SETcc_reg_o
    extends Op {
        CPU_Regs.Reg earb;

        public SETcc_reg_o(int rm) {
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8((short)(Flags.TFLG_O() ? 1 : 0));
            return 4;
        }
    }

    public static final class JumpCond16_w_nle
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NLE(), this.offset);
        }
    }

    public static final class JumpCond16_w_le
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_LE(), this.offset);
        }
    }

    public static final class JumpCond16_w_nl
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NL(), this.offset);
        }
    }

    public static final class JumpCond16_w_l
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_L(), this.offset);
        }
    }

    public static final class JumpCond16_w_np
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NP(), this.offset);
        }
    }

    public static final class JumpCond16_w_p
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_P(), this.offset);
        }
    }

    public static final class JumpCond16_w_ns
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NS(), this.offset);
        }
    }

    public static final class JumpCond16_w_s
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_S(), this.offset);
        }
    }

    public static final class JumpCond16_w_nbe
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NBE(), this.offset);
        }
    }

    public static final class JumpCond16_w_be
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_BE(), this.offset);
        }
    }

    public static final class JumpCond16_w_nz
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NZ(), this.offset);
        }
    }

    public static final class JumpCond16_w_z
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_Z(), this.offset);
        }
    }

    public static final class JumpCond16_w_nb
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NB(), this.offset);
        }
    }

    public static final class JumpCond16_w_b
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_B(), this.offset);
        }
    }

    public static final class JumpCond16_w_no
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_NO(), this.offset);
        }
    }

    public static final class JumpCond16_w_o
    extends JumpCond16_w {
        public int call() {
            return this.jump(Flags.TFLG_O(), this.offset);
        }
    }

    public static abstract class JumpCond16_w
    extends Op {
        int offset = Helper.decode_fetchws();

        protected final int jump(boolean COND, int off) {
            if (COND) {
                CPU_Regs.reg_ip(CPU_Regs.reg_ip() + off + this.eip_count);
                return 1;
            }
            CPU_Regs.reg_ip(CPU_Regs.reg_ip() + this.eip_count);
            return 2;
        }
    }

    public static final class Rdtsc
    extends Op {
        public int call() {
            if (CPU.CPU_ArchitectureType < 80) {
                return 6;
            }
            long tsc = (long)(Pic.PIC_FullIndex() * (double)CPU.CPU_CycleMax);
            CPU_Regs.reg_edx.dword = (int)(tsc >>> 32);
            CPU_Regs.reg_eax.dword = (int)(tsc & 0xFFFFFFFFL);
            return 4;
        }
    }

    public static final class MovTrRd
    extends Op {
        CPU_Regs.Reg eard;
        int which;

        public MovTrRd(int rm) {
            this.eard = Mod.ed(rm);
            this.which = rm >> 3 & 7;
        }

        public int call() {
            if (CPU.CPU_WRITE_TRX(this.which, this.eard.dword)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovRdTr
    extends Op {
        CPU_Regs.Reg eard;
        int which;

        public MovRdTr(int rm) {
            this.eard = Mod.ed(rm);
            this.which = rm >> 3 & 7;
        }

        public int call() {
            if (CPU.CPU_READ_TRX(this.which, this.eard)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovDrRd
    extends Op {
        CPU_Regs.Reg eard;
        int which;

        public MovDrRd(int rm) {
            this.eard = Mod.ed(rm);
            this.which = rm >> 3 & 7;
        }

        public int call() {
            if (CPU.CPU_WRITE_DRX(this.which, this.eard.dword)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovCrRd
    extends Op {
        CPU_Regs.Reg eard;
        int which;

        public MovCrRd(int rm) {
            this.eard = Mod.ed(rm);
            this.which = rm >> 3 & 7;
        }

        public int call() {
            if (CPU.CPU_WRITE_CRX(this.which, this.eard.dword)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovRdDr
    extends Op {
        CPU_Regs.Reg eard;
        int which;

        public MovRdDr(int rm) {
            this.eard = Mod.ed(rm);
            this.which = rm >> 3 & 7;
        }

        public int call() {
            if (CPU.CPU_READ_DRX(this.which, this.eard)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovRdCr
    extends Op {
        CPU_Regs.Reg eard;
        int which;

        public MovRdCr(int rm) {
            this.eard = Mod.ed(rm);
            this.which = rm >> 3 & 7;
        }

        public int call() {
            if (CPU.CPU_READ_CRX(this.which, this.eard)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Invd
    extends Op {
        public int call() {
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            return 4;
        }
    }

    public static final class Clts
    extends Op {
        public int call() {
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            CPU.cpu.cr0 &= 0xFFFFFFF7;
            return 4;
        }
    }

    public static final class LslGwEw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;
        IntRef value = new IntRef(0);

        public LslGwEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.value.value = this.rw.word();
            CPU.CPU_LSL(Memory.mem_readw(eaa), this.value);
            this.rw.word(this.value.value);
            return 4;
        }
    }

    public static final class LslGwEw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;
        IntRef value = new IntRef(0);

        public LslGwEw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.value.value = this.rw.word();
            CPU.CPU_LSL(this.earw.word(), this.value);
            this.rw.word(this.value.value);
            return 4;
        }
    }

    public static final class LarGwEw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public LarGwEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            IntRef value = new IntRef(this.rw.word());
            CPU.CPU_LAR(Memory.mem_readw(eaa), value);
            this.rw.word(value.value);
            return 4;
        }
    }

    public static final class LarGwEw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;

        public LarGwEw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            IntRef value = new IntRef(this.rw.word());
            CPU.CPU_LAR(this.earw.word(), value);
            this.rw.word(value.value);
            return 4;
        }
    }

    public static final class Lmsw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Lmsw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (CPU.CPU_LMSW(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Smsw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Smsw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.CPU_SMSW() & 0xFFFF);
            return 4;
        }
    }

    public static final class Lidt_reg
    extends Op {
        public int call() {
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            return 6;
        }
    }

    public static final class Lgdt_reg
    extends Op {
        public int call() {
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            return 6;
        }
    }

    public static final class Invlpg
    extends Op {
        public int call() {
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            Paging.PAGING_ClearTLB();
            return 4;
        }
    }

    public static final class Lmsw_mem
    extends Op {
        EaaBase get_eaa;

        public Lmsw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int limit = Memory.mem_readw(eaa);
            if (CPU.CPU_LMSW(limit)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Smsw_mem
    extends Op {
        EaaBase get_eaa;

        public Smsw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.CPU_SMSW() & 0xFFFF);
            return 4;
        }
    }

    public static final class Lidt_mem
    extends Op {
        EaaBase get_eaa;

        public Lidt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            int v1 = Memory.mem_readd(eaa + 2) & 0xFFFFFF;
            int v0 = Memory.mem_readw(eaa);
            CPU.CPU_LIDT(v0, v1);
            return 4;
        }
    }

    public static final class Lgdt_mem
    extends Op {
        EaaBase get_eaa;

        public Lgdt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            int v1 = Memory.mem_readd(eaa + 2) & 0xFFFFFF;
            int v0 = Memory.mem_readw(eaa);
            CPU.CPU_LGDT(v0, v1);
            return 4;
        }
    }

    public static final class Sidt_mem
    extends Op {
        EaaBase get_eaa;

        public Sidt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.CPU_SIDT_limit());
            Memory.mem_writed(eaa + 2, CPU.CPU_SIDT_base());
            return 4;
        }
    }

    public static final class Sgdt_mem
    extends Op {
        EaaBase get_eaa;

        public Sgdt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.CPU_SGDT_limit());
            Memory.mem_writed(eaa + 2, CPU.CPU_SGDT_base());
            return 4;
        }
    }

    public static final class Verw_mem
    extends Op {
        EaaBase get_eaa;

        public Verw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            int eaa = this.get_eaa.call();
            CPU.CPU_VERW(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class Verw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Verw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            CPU.CPU_VERW(this.earw.word());
            return 4;
        }
    }

    public static final class Verr_mem
    extends Op {
        EaaBase get_eaa;

        public Verr_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            int eaa = this.get_eaa.call();
            CPU.CPU_VERR(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class Verr_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Verr_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            CPU.CPU_VERR(this.earw.word());
            return 4;
        }
    }

    public static final class Ltr_mem
    extends Op {
        EaaBase get_eaa;

        public Ltr_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            if (CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            int eaa = this.get_eaa.call();
            if (CPU.CPU_LTR(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Ltr_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Ltr_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            if (CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            if (CPU.CPU_LTR(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Lldt_mem
    extends Op {
        EaaBase get_eaa;

        public Lldt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            if (CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            int eaa = this.get_eaa.call();
            if (CPU.CPU_LLDT(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Lldt_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Lldt_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            if (CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            if (CPU.CPU_LLDT(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Str_mem
    extends Op {
        EaaBase get_eaa;

        public Str_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.CPU_STR());
            return 4;
        }
    }

    public static final class Str_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Str_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.earw.word(CPU.CPU_STR());
            return 4;
        }
    }

    public static final class Sldt_mem
    extends Op {
        EaaBase get_eaa;

        public Sldt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.CPU_SLDT());
            return 4;
        }
    }

    public static final class Sldt_reg
    extends Op {
        CPU_Regs.Reg earw;

        public Sldt_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.earw.word(CPU.CPU_SLDT());
            return 4;
        }
    }
}

