/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Core_dynamic;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Inst1;
import jdos.cpu.core_dynamic.Mod;
import jdos.cpu.core_dynamic.Op;
import jdos.hardware.IO;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.util.IntRef;

public class Inst3
extends Helper {

    public static final class PushEd_mem
    extends Op {
        EaaBase get_eaa;

        public PushEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            CPU.CPU_Push32(Memory.mem_readd(eaa));
            return 4;
        }
    }

    public static final class PushEd_reg
    extends Op {
        CPU_Regs.Reg eard;

        public PushEd_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            CPU.CPU_Push32(this.eard.dword);
            return 4;
        }
    }

    public static final class JmpFarEd_mem
    extends Op {
        EaaBase get_eaa;

        public JmpFarEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int newip = Memory.mem_readd(eaa);
            int newcs = Memory.mem_readw(eaa + 4);
            Flags.FillFlags();
            CPU.CPU_JMP(true, newcs, newip, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class JmpNearEd_mem
    extends Op {
        EaaBase get_eaa;

        public JmpNearEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            CPU_Regs.reg_eip = Memory.mem_readd(eaa);
            return 3;
        }
    }

    public static final class JmpNearEd_reg
    extends Op {
        CPU_Regs.Reg eard;

        public JmpNearEd_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            CPU_Regs.reg_eip = this.eard.dword;
            return 3;
        }
    }

    public static final class CallFarEd_mem
    extends Op {
        EaaBase get_eaa;

        public CallFarEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int newip = Memory.mem_readd(eaa);
            int newcs = Memory.mem_readw(eaa + 4);
            Flags.FillFlags();
            CPU.CPU_CALL(true, newcs, newip, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class CallNearEd_mem
    extends Op {
        EaaBase get_eaa;

        public CallNearEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int old = CPU_Regs.reg_eip + this.eip_count;
            int eip = Memory.mem_readd(eaa);
            CPU.CPU_Push32(old);
            CPU_Regs.reg_eip = eip;
            return 3;
        }
    }

    public static final class CallNearEd_reg
    extends Op {
        CPU_Regs.Reg eard;

        public CallNearEd_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int old = CPU_Regs.reg_eip + this.eip_count;
            CPU.CPU_Push32(old);
            CPU_Regs.reg_eip = this.eard.dword;
            return 3;
        }
    }

    public static final class OutEaxDx
    extends Op {
        public int call() {
            IO.IO_WriteD(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class InEaxDx
    extends Op {
        public int call() {
            CPU_Regs.reg_eax.dword = IO.IO_ReadD(CPU_Regs.reg_edx.word());
            return 4;
        }
    }

    public static final class JmpJb
    extends Op {
        int addip = Helper.decode_fetchbs();

        public int call() {
            CPU_Regs.reg_eip += this.eip_count + this.addip;
            return 1;
        }
    }

    public static final class JmpAd
    extends Op {
        int newip = Helper.decode_fetchd();
        int newcs = Helper.decode_fetchw();

        public int call() {
            Flags.FillFlags();
            CPU.CPU_JMP(true, this.newcs, this.newip, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class JmpJd
    extends Op {
        long addip = Helper.decode_fetchds();

        public int call() {
            CPU_Regs.reg_eip = (int)((long)CPU_Regs.reg_eip + ((long)this.eip_count + this.addip));
            return 1;
        }
    }

    public static final class CallJd
    extends Op {
        long addip = Helper.decode_fetchds();

        public int call() {
            CPU.CPU_Push32(CPU_Regs.reg_eip + this.eip_count);
            CPU_Regs.reg_eip = (int)((long)CPU_Regs.reg_eip + (this.addip + (long)this.eip_count));
            return 1;
        }
    }

    public static final class OutEaxIb
    extends Op {
        int port = Helper.decode_fetchb();

        public int call() {
            if (CPU.CPU_IO_Exception(this.port, 4)) {
                return this.RUNEXCEPTION();
            }
            IO.IO_WriteD(this.port, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class InEaxIb
    extends Op {
        int port = Helper.decode_fetchb();

        public int call() {
            if (CPU.CPU_IO_Exception(this.port, 4)) {
                return this.RUNEXCEPTION();
            }
            CPU_Regs.reg_eax.dword = IO.IO_ReadD(this.port);
            return 4;
        }
    }

    public static final class Jcxz
    extends JumpCond32_b {
        int mask;

        public Jcxz(int mask) {
            this.mask = mask;
        }

        public int call() {
            return this.jump((CPU_Regs.reg_ecx.dword & this.mask) == 0, this.offset);
        }
    }

    public static final class Loop16
    extends JumpCond32_b {
        public int call() {
            CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
            return this.jump(CPU_Regs.reg_ecx.word() != 0, this.offset);
        }
    }

    public static final class Loop32
    extends JumpCond32_b {
        public int call() {
            --CPU_Regs.reg_ecx.dword;
            return this.jump(CPU_Regs.reg_ecx.dword != 0, this.offset);
        }
    }

    public static final class Loopz16
    extends JumpCond32_b {
        public int call() {
            CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
            return this.jump(CPU_Regs.reg_ecx.word() != 0 && Flags.get_ZF(), this.offset);
        }
    }

    public static final class Loopz32
    extends JumpCond32_b {
        public int call() {
            --CPU_Regs.reg_ecx.dword;
            return this.jump(CPU_Regs.reg_ecx.dword != 0 && Flags.get_ZF(), this.offset);
        }
    }

    public static final class Loopnz16
    extends JumpCond32_b {
        public int call() {
            CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
            return this.jump(CPU_Regs.reg_ecx.word() != 0 && !Flags.get_ZF(), this.offset);
        }
    }

    public static final class Loopnz32
    extends JumpCond32_b {
        public int call() {
            --CPU_Regs.reg_ecx.dword;
            return this.jump(CPU_Regs.reg_ecx.dword != 0 && !Flags.get_ZF(), this.offset);
        }
    }

    public static final class IRet32
    extends Op {
        public int call() {
            CPU.CPU_IRET(true, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class Retf32
    extends Op {
        public int call() {
            Flags.FillFlags();
            CPU.CPU_RET(true, 0, CPU_Regs.reg_eip + this.eip_count);
            return 3;
        }
    }

    public static final class Retf32Iw
    extends Op {
        int words = Helper.decode_fetchw();

        public int call() {
            Flags.FillFlags();
            CPU.CPU_RET(true, this.words, CPU_Regs.reg_eip + this.eip_count);
            return 3;
        }
    }

    public static final class Leave32
    extends Op {
        public int call() {
            CPU_Regs.reg_esp.dword &= CPU.cpu.stack.notmask;
            CPU_Regs.reg_esp.dword |= CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask;
            CPU_Regs.reg_ebp.dword = CPU.CPU_Pop32();
            return 4;
        }
    }

    public static final class Enter32IwIb
    extends Op {
        int bytes = Helper.decode_fetchw();
        int level = Helper.decode_fetchb();

        public int call() {
            CPU.CPU_ENTER(true, this.bytes, this.level);
            return 4;
        }
    }

    public static final class Lds32
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public Lds32(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa + 4))) {
                return this.RUNEXCEPTION();
            }
            this.rd.dword = Memory.mem_readd(eaa);
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class Les32
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public Les32(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa + 4))) {
                return this.RUNEXCEPTION();
            }
            this.rd.dword = Memory.mem_readd(eaa);
            return 4;
        }
    }

    public static final class Retn32
    extends Op {
        public int call() {
            CPU_Regs.reg_eip = CPU.CPU_Pop32();
            return 3;
        }
    }

    public static final class Retn32Iw
    extends Op {
        int offset = Helper.decode_fetchw();

        public int call() {
            CPU_Regs.reg_eip = CPU.CPU_Pop32();
            CPU_Regs.reg_esp.dword += this.offset;
            return 3;
        }
    }

    public static final class MovId_mem
    extends Op {
        int id;
        EaaBase get_eaa;

        public MovId_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.id = Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, this.id);
            return 4;
        }
    }

    public static final class MovId
    extends Op {
        int id = Helper.decode_fetchd();
        CPU_Regs.Reg reg;

        public MovId(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.dword = this.id;
            return 4;
        }
    }

    public static final class TestEaxId
    extends Op {
        int id = Helper.decode_fetchd();

        public int call() {
            Instructions.TESTD(this.id, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class MovOdEax
    extends Inst1.GetEADirect {
        public int call() {
            int eaa = Core.base_ds + this.value;
            Memory.mem_writed(eaa, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class MovEaxOd
    extends Inst1.GetEADirect {
        public int call() {
            int eaa = Core.base_ds + this.value;
            CPU_Regs.reg_eax.dword = Memory.mem_readd(eaa);
            return 4;
        }
    }

    public static final class Popfd
    extends Op {
        public int call() {
            if (CPU.CPU_POPF(true)) {
                return this.RUNEXCEPTION();
            }
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.DECODE_END(this.eip_count);
            }
            if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                return this.DECODE_END(this.eip_count);
            }
            return 4;
        }
    }

    public static final class Pushfd
    extends Op {
        public int call() {
            if (CPU.CPU_PUSHF(true)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class CallFarAp
    extends Op {
        int newcs;
        int newip;

        public CallFarAp(int newcs, int newip) {
            this.newcs = newcs;
            this.newip = newip;
        }

        public int call() {
            Flags.FillFlags();
            CPU.CPU_CALL(true, this.newcs, this.newip, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class Cdq
    extends Op {
        public int call() {
            CPU_Regs.reg_edx.dword = (CPU_Regs.reg_eax.dword & Integer.MIN_VALUE) != 0 ? -1 : 0;
            return 4;
        }
    }

    public static final class Cwde
    extends Op {
        public int call() {
            CPU_Regs.reg_eax.dword = (short)CPU_Regs.reg_eax.word();
            return 4;
        }
    }

    public static final class XchgEax
    extends Op {
        CPU_Regs.Reg reg;

        public XchgEax(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            int old = this.reg.dword;
            this.reg.dword = CPU_Regs.reg_eax.dword;
            CPU_Regs.reg_eax.dword = old;
            return 4;
        }
    }

    public static final class PopEd_mem
    extends Op {
        EaaBase get_eaa;

        public PopEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int val = CPU.CPU_Pop32();
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, val);
            return 4;
        }
    }

    public static final class PopEd_reg
    extends Op {
        CPU_Regs.Reg eard;

        public PopEd_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.CPU_Pop32();
            return 4;
        }
    }

    public static final class LeaGd_32
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public LeaGd_32(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa32(rm);
        }

        public int call() {
            Core.base_ss = 0;
            Core.base_ds = 0;
            this.rd.dword = this.get_eaa.call();
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class LeaGd_16
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public LeaGd_16(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa16(rm);
        }

        public int call() {
            Core.base_ss = 0;
            Core.base_ds = 0;
            this.rd.dword = this.get_eaa.call();
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class MovEdGs_reg
    extends Op {
        CPU_Regs.Reg eard;

        public MovEdGs_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.Segs_GSval & 0xFFFF;
            return 4;
        }
    }

    public static final class MovEdFs_reg
    extends Op {
        CPU_Regs.Reg eard;

        public MovEdFs_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.Segs_FSval & 0xFFFF;
            return 4;
        }
    }

    public static final class MovEdDs_reg
    extends Op {
        CPU_Regs.Reg eard;

        public MovEdDs_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.Segs_DSval & 0xFFFF;
            return 4;
        }
    }

    public static final class MovEdSs_reg
    extends Op {
        CPU_Regs.Reg eard;

        public MovEdSs_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.Segs_SSval & 0xFFFF;
            return 4;
        }
    }

    public static final class MovEdCs_reg
    extends Op {
        CPU_Regs.Reg eard;

        public MovEdCs_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.Segs_CSval & 0xFFFF;
            return 4;
        }
    }

    public static final class MovEdEs_reg
    extends Op {
        CPU_Regs.Reg eard;

        public MovEdEs_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.Segs_ESval & 0xFFFF;
            return 4;
        }
    }

    public static final class MovGdEd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public MovGdEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = Memory.mem_readd(eaa);
            return 4;
        }
    }

    public static final class MovGdEd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public MovGdEd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            this.rd.dword = this.eard.dword;
            return 4;
        }
    }

    public static final class MovEdGd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public MovEdGd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, this.rd.dword);
            return 4;
        }
    }

    public static final class MovEdGd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public MovEdGd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            this.eard.dword = this.rd.dword;
            return 4;
        }
    }

    public static final class XchgEdGd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public XchgEdGd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int oldrmrd = this.rd.dword;
            int tmp = Memory.mem_readd(eaa);
            Memory.mem_writed(eaa, oldrmrd);
            this.rd.dword = tmp;
            return 4;
        }
    }

    public static final class XchgEdGd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public XchgEdGd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int oldrmrd = this.rd.dword;
            this.rd.dword = this.eard.dword;
            this.eard.dword = oldrmrd;
            return 4;
        }
    }

    public static final class TestEdGd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public TestEdGd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Instructions.TESTD(this.rd.dword, Memory.mem_readd(eaa));
            return 4;
        }
    }

    public static final class TestEdGd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public TestEdGd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            Instructions.TESTD(this.rd.dword, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_mem_cmp
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_cmp(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Instructions.CMPD(this.ib, Memory.mem_readd(eaa));
            return 4;
        }
    }

    public static final class GrplEdId_mem_xor
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_xor(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.XORD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_mem_sub
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_sub(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.SUBD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_mem_and
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_and(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.ANDD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_mem_sbb
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_sbb(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.SBBD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_mem_adc
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_adc(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.ADCD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_mem_or
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_or(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.ORD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_mem_add
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEdId_mem_add(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.ADDD(this.ib, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class GrplEdId_reg_cmp
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_cmp(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            Instructions.CMPD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_xor
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_xor(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.XORD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_sub
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_sub(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.SUBD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_and
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_and(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.ANDD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_sbb
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_sbb(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.SBBD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_adc
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_adc(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.ADCD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_or
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_or(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.ORD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class GrplEdId_reg_add
    extends Op {
        CPU_Regs.Reg eard;
        int ib;

        public GrplEdId_reg_add(int rm, boolean signed) {
            this.eard = Mod.ed(rm);
            this.ib = signed ? (int)Helper.decode_fetchbs() : Helper.decode_fetchd();
        }

        public int call() {
            this.eard.dword = Instructions.ADDD(this.ib, this.eard.dword);
            return 4;
        }
    }

    public static final class JumpCond32_b_nle
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NLE(), this.offset);
        }
    }

    public static final class JumpCond32_b_le
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_LE(), this.offset);
        }
    }

    public static final class JumpCond32_b_nl
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NL(), this.offset);
        }
    }

    public static final class JumpCond32_b_l
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_L(), this.offset);
        }
    }

    public static final class JumpCond32_b_np
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NP(), this.offset);
        }
    }

    public static final class JumpCond32_b_p
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_P(), this.offset);
        }
    }

    public static final class JumpCond32_b_ns
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NS(), this.offset);
        }
    }

    public static final class JumpCond32_b_s
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_S(), this.offset);
        }
    }

    public static final class JumpCond32_b_nbe
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NBE(), this.offset);
        }
    }

    public static final class JumpCond32_b_be
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_BE(), this.offset);
        }
    }

    public static final class JumpCond32_b_nz
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NZ(), this.offset);
        }
    }

    public static final class JumpCond32_b_z
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_Z(), this.offset);
        }
    }

    public static final class JumpCond32_b_nb
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NB(), this.offset);
        }
    }

    public static final class JumpCond32_b_b
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_B(), this.offset);
        }
    }

    public static final class JumpCond32_b_no
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_NO(), this.offset);
        }
    }

    public static final class JumpCond32_b_o
    extends JumpCond32_b {
        public int call() {
            return this.jump(Flags.TFLG_O(), this.offset);
        }
    }

    public static abstract class JumpCond32_b
    extends Op {
        int offset = Helper.decode_fetchbs();

        protected final int jump(boolean COND, int off) {
            if (COND) {
                CPU_Regs.reg_eip += off + this.eip_count;
                return 1;
            }
            CPU_Regs.reg_eip += this.eip_count;
            return 2;
        }
    }

    public static final class ImulGdEdIb_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;
        int op3;

        public ImulGdEdIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
            this.op3 = Helper.decode_fetchbs();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = Instructions.DIMULD(Memory.mem_readd(eaa), this.op3);
            return 4;
        }
    }

    public static final class ImulGdEdIb_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;
        int op3;

        public ImulGdEdIb_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
            this.op3 = Helper.decode_fetchbs();
        }

        public int call() {
            this.rd.dword = Instructions.DIMULD(this.eard.dword, this.op3);
            return 4;
        }
    }

    public static final class PushIb
    extends Op {
        int id = Helper.decode_fetchbs();

        public int call() {
            CPU.CPU_Push32(this.id);
            return 4;
        }
    }

    public static final class ImulGdEdId_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;
        int op3;

        public ImulGdEdId_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
            this.op3 = Helper.decode_fetchds();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = Instructions.DIMULD(Memory.mem_readd(eaa), this.op3);
            return 4;
        }
    }

    public static final class ImulGdEdId_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;
        int op3;

        public ImulGdEdId_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
            this.op3 = Helper.decode_fetchds();
        }

        public int call() {
            this.rd.dword = Instructions.DIMULD(this.eard.dword, this.op3);
            return 4;
        }
    }

    public static final class PushId
    extends Op {
        int id = Helper.decode_fetchd();

        public int call() {
            CPU.CPU_Push32(this.id);
            return 4;
        }
    }

    public static final class ArplEdRd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;
        IntRef ref = new IntRef(0);

        public ArplEdRd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            if (CPU.cpu.pmode && (CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            int eaa = this.get_eaa.call();
            this.ref.value = Memory.mem_readw(eaa);
            CPU.CPU_ARPL(this.ref, this.rd.word());
            Memory.mem_writed(eaa, this.ref.value);
            return 4;
        }
    }

    public static final class ArplEdRd_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;
        IntRef ref = new IntRef(0);

        public ArplEdRd_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (CPU.cpu.pmode && (CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.ref.value = this.eard.dword;
            CPU.CPU_ARPL(this.ref, this.rd.word());
            this.eard.dword = this.ref.value;
            return 4;
        }
    }

    public static final class BoundEd
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public BoundEd() {
            short rm = Helper.decode_fetchb();
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int bound_min = Memory.mem_readd(eaa);
            int bound_max = Memory.mem_readd(eaa + 4);
            int rmrd = this.rd.dword;
            if (rmrd < bound_min || rmrd > bound_max) {
                return this.EXCEPTION(5);
            }
            return 4;
        }
    }

    public static final class Popad
    extends Op {
        public int call() {
            CPU_Regs.reg_edi.dword = CPU.CPU_Pop32();
            CPU_Regs.reg_esi.dword = CPU.CPU_Pop32();
            CPU_Regs.reg_ebp.dword = CPU.CPU_Pop32();
            CPU.CPU_Pop32();
            CPU_Regs.reg_ebx.dword = CPU.CPU_Pop32();
            CPU_Regs.reg_edx.dword = CPU.CPU_Pop32();
            CPU_Regs.reg_ecx.dword = CPU.CPU_Pop32();
            CPU_Regs.reg_eax.dword = CPU.CPU_Pop32();
            return 4;
        }
    }

    public static final class Pushad
    extends Op {
        public int call() {
            int tmpesp = CPU_Regs.reg_esp.dword;
            CPU.CPU_Push32(CPU_Regs.reg_eax.dword);
            CPU.CPU_Push32(CPU_Regs.reg_ecx.dword);
            CPU.CPU_Push32(CPU_Regs.reg_edx.dword);
            CPU.CPU_Push32(CPU_Regs.reg_ebx.dword);
            CPU.CPU_Push32(tmpesp);
            CPU.CPU_Push32(CPU_Regs.reg_ebp.dword);
            CPU.CPU_Push32(CPU_Regs.reg_esi.dword);
            CPU.CPU_Push32(CPU_Regs.reg_edi.dword);
            return 4;
        }
    }

    public static final class Pop32_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Pop32_reg(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.dword = CPU.CPU_Pop32();
            return 4;
        }
    }

    public static final class Push32_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Push32_reg(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            CPU.CPU_Push32(this.reg.dword);
            return 4;
        }
    }

    public static final class Decd_mem
    extends Op {
        EaaBase get_eaa;

        public Decd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.DECD(Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Decd_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Decd_reg(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.dword = Instructions.DECD(this.reg.dword);
            return 4;
        }
    }

    public static final class Incd_mem
    extends Op {
        EaaBase get_eaa;

        public Incd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writed(eaa, Instructions.INCD(Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Incd_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Incd_reg(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.dword = Instructions.INCD(this.reg.dword);
            return 4;
        }
    }

    public static final class CmpEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            Instructions.CMPD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class CmpGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public CmpGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            Instructions.CMPD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class CmpEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public CmpEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Instructions.CMPD(this.g.dword, Memory.mem_readd(eaa));
            return 4;
        }
    }

    public static final class Cmpd_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Cmpd_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            Instructions.CMPD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class XorEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.XORD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class XorGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public XorGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.XORD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class XorEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public XorEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.XORD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Xord_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Xord_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.XORD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class SubEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.SUBD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class SubGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public SubGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.SUBD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class SubEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public SubEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.SUBD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Subd_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Subd_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.SUBD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class AndEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.ANDD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class AndGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AndGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.ANDD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class AndEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AndEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.ANDD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Andd_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Andd_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.ANDD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class Pop32DS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegDS(true)) {
                return this.RUNEXCEPTION();
            }
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class Push32DS
    extends Op {
        public int call() {
            CPU.CPU_Push32(CPU.Segs_DSval);
            return 4;
        }
    }

    public static final class SbbEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.SBBD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class SbbGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public SbbGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.SBBD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class SbbEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public SbbEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.SBBD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Sbbd_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Sbbd_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.SBBD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class Pop32SS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegSS(true)) {
                return this.RUNEXCEPTION();
            }
            Core.base_ss = CPU.Segs_SSphys;
            return 4;
        }
    }

    public static final class Push32SS
    extends Op {
        public int call() {
            CPU.CPU_Push32(CPU.Segs_SSval);
            return 4;
        }
    }

    public static final class AdcEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.ADCD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class AdcGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AdcGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.ADCD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class AdcEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AdcEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.ADCD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Adcd_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Adcd_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.ADCD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class Push32CS
    extends Op {
        public int call() {
            CPU.CPU_Push32(CPU.Segs_CSval);
            return 4;
        }
    }

    public static final class OrEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.ORD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class OrGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public OrGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.ORD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class OrEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public OrEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.ORD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Ord_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Ord_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.ORD(this.g.dword, this.e.dword);
            return 4;
        }
    }

    public static final class Pop32ES
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegES(true)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Push32ES
    extends Op {
        public int call() {
            CPU.CPU_Push32(CPU.Segs_ESval);
            return 4;
        }
    }

    public static final class AddEaxId
    extends Op {
        int i = Helper.decode_fetchd();

        public int call() {
            CPU_Regs.reg_eax.dword = Instructions.ADDD(this.i, CPU_Regs.reg_eax.dword);
            return 4;
        }
    }

    public static final class AddGdEd_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AddGdEd_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.dword = Instructions.ADDD(Memory.mem_readd(eaa), this.e.dword);
            return 4;
        }
    }

    public static final class AddEdGd_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AddEdGd_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writed(eaa, Instructions.ADDD(this.g.dword, Memory.mem_readd(eaa)));
            return 4;
        }
    }

    public static final class Addd_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Addd_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.dword = Instructions.ADDD(this.g.dword, this.e.dword);
            return 4;
        }
    }
}

