/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.core_dynamic.Decode;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Inst1;
import jdos.cpu.core_dynamic.Inst2;
import jdos.cpu.core_dynamic.Inst4;
import jdos.cpu.core_dynamic.Op;
import jdos.misc.Log;

public class Prefix_66_0f
extends Helper {
    public static void init(Decode[] ops) {
        ops[768] = ops[256];
        ops[769] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    switch (which) {
                        case 0: {
                            prev.next = new Inst2.Sgdt_mem(rm);
                            break;
                        }
                        case 1: {
                            prev.next = new Inst2.Sidt_mem(rm);
                            break;
                        }
                        case 2: {
                            prev.next = new Inst4.Lgdt_mem(rm);
                            break;
                        }
                        case 3: {
                            prev.next = new Inst4.Lidt_mem(rm);
                            break;
                        }
                        case 4: {
                            prev.next = new Inst2.Smsw_mem(rm);
                            break;
                        }
                        case 6: {
                            prev.next = new Inst2.Lmsw_mem(rm);
                            break;
                        }
                        case 7: {
                            prev.next = new Inst2.Invlpg();
                        }
                    }
                } else {
                    switch (which) {
                        case 2: {
                            prev.next = new Inst2.Lgdt_reg();
                            break;
                        }
                        case 3: {
                            prev.next = new Inst2.Lidt_reg();
                            break;
                        }
                        case 4: {
                            prev.next = new Inst4.Smsw_reg(rm);
                            break;
                        }
                        case 6: {
                            prev.next = new Inst4.Lmsw_reg(rm);
                            break;
                        }
                        default: {
                            prev.next = new Inst1.Illegal("");
                        }
                    }
                }
                return 0;
            }
        };
        ops[770] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.LarGdEd_reg(rm) : new Inst4.LarGdEd_mem(rm);
                return 0;
            }
        };
        ops[771] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.LslGdEd_reg(rm) : new Inst4.LslGdEd_mem(rm);
                return 0;
            }
        };
        ops[896] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_o();
                return 6;
            }
        };
        ops[897] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_no();
                return 6;
            }
        };
        ops[898] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_b();
                return 6;
            }
        };
        ops[899] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_nb();
                return 6;
            }
        };
        ops[900] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_z();
                return 6;
            }
        };
        ops[901] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_nz();
                return 6;
            }
        };
        ops[902] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_be();
                return 6;
            }
        };
        ops[903] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_nbe();
                return 6;
            }
        };
        ops[904] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_s();
                return 6;
            }
        };
        ops[905] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_ns();
                return 6;
            }
        };
        ops[906] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_p();
                return 6;
            }
        };
        ops[907] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_np();
                return 6;
            }
        };
        ops[908] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_l();
                return 6;
            }
        };
        ops[909] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_nl();
                return 6;
            }
        };
        ops[910] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_le();
                return 6;
            }
        };
        ops[911] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.JumpCond32_d_nle();
                return 6;
            }
        };
        ops[928] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.PushFS();
                return 0;
            }
        };
        ops[929] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.PopFS();
                return 0;
            }
        };
        ops[931] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.BtEdGd_reg(rm) : new Inst4.BtEdGd_mem(rm);
                return 0;
            }
        };
        ops[932] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.ShldEdGdIb_reg(rm) : new Inst4.ShldEdGdIb_mem(rm);
                return 0;
            }
        };
        ops[933] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.ShldEdGdCl_reg(rm) : new Inst4.ShldEdGdCl_mem(rm);
                return 0;
            }
        };
        ops[936] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.PushGS();
                return 0;
            }
        };
        ops[937] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst4.PopGS();
                return 0;
            }
        };
        ops[939] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.BtsEdGd_reg(rm) : new Inst4.BtsEdGd_mem(rm);
                return 0;
            }
        };
        ops[940] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.ShrdEdGdIb_reg(rm) : new Inst4.ShrdEdGdIb_mem(rm);
                return 0;
            }
        };
        ops[941] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.ShrdEdGdCl_reg(rm) : new Inst4.ShrdEdGdCl_mem(rm);
                return 0;
            }
        };
        ops[943] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.ImulGdEd_reg(rm) : new Inst4.ImulGdEd_mem(rm);
                return 0;
            }
        };
        ops[945] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.CmpxchgEdGd_reg(rm) : new Inst4.CmpxchgEdGd_mem(rm);
                return 0;
            }
        };
        ops[946] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst1.Illegal("") : new Inst4.LssEd(rm);
                return 0;
            }
        };
        ops[947] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.BtrEdGd_reg(rm) : new Inst4.BtrEdGd_mem(rm);
                return 0;
            }
        };
        ops[948] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst1.Illegal("") : new Inst4.LfsEd(rm);
                return 0;
            }
        };
        ops[949] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst1.Illegal("") : new Inst4.LgsEd(rm);
                return 0;
            }
        };
        ops[950] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.MovzxGdEb_reg(rm) : new Inst4.MovzxGdEb_mem(rm);
                return 0;
            }
        };
        ops[951] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.MovzxGdEw_reg(rm) : new Inst4.MovzxGdEw_mem(rm);
                return 0;
            }
        };
        ops[954] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                if (rm >= 192) {
                    switch (rm & 0x38) {
                        case 32: {
                            prev.next = new Inst4.BtEdIb_reg(rm);
                            break;
                        }
                        case 40: {
                            prev.next = new Inst4.BtsEdIb_reg(rm);
                            break;
                        }
                        case 48: {
                            prev.next = new Inst4.BtrEdIb_reg(rm);
                            break;
                        }
                        case 56: {
                            prev.next = new Inst4.BtcEdIb_reg(rm);
                            break;
                        }
                        default: {
                            Log.exit("CPU:66:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                            break;
                        }
                    }
                } else {
                    switch (rm & 0x38) {
                        case 32: {
                            prev.next = new Inst4.BtEdIb_mem(rm);
                            break;
                        }
                        case 40: {
                            prev.next = new Inst4.BtsEdIb_mem(rm);
                            break;
                        }
                        case 48: {
                            prev.next = new Inst4.BtrEdIb_mem(rm);
                            break;
                        }
                        case 56: {
                            prev.next = new Inst4.BtcEdIb_mem(rm);
                            break;
                        }
                        default: {
                            Log.exit("CPU:66:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                        }
                    }
                }
                return 0;
            }
        };
        ops[955] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.BtcEdGd_reg(rm) : new Inst4.BtcEdGd_mem(rm);
                return 0;
            }
        };
        ops[956] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.BsfGdEd_reg(rm) : new Inst4.BsfGdEd_mem(rm);
                return 0;
            }
        };
        ops[957] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.BsrGdEd_reg(rm) : new Inst4.BsrGdEd_mem(rm);
                return 0;
            }
        };
        ops[958] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.MovsxGdEb_reg(rm) : new Inst4.MovsxGdEb_mem(rm);
                return 0;
            }
        };
        ops[959] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.MovsxGdEw_reg(rm) : new Inst4.MovsxGdEw_mem(rm);
                return 0;
            }
        };
        ops[961] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst4.XaddGdEd_reg(rm) : new Inst4.XaddGdEd_mem(rm);
                return 0;
            }
        };
        ops[968] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_eax);
                return 0;
            }
        };
        ops[969] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_ecx);
                return 0;
            }
        };
        ops[970] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_edx);
                return 0;
            }
        };
        ops[971] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_ebx);
                return 0;
            }
        };
        ops[972] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_esp);
                return 0;
            }
        };
        ops[973] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_ebp);
                return 0;
            }
        };
        ops[974] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_esi);
                return 0;
            }
        };
        ops[975] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst4.Bswapd(CPU_Regs.reg_edi);
                return 0;
            }
        };
    }
}

