/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.Op;
import jdos.hardware.Memory;

public class Strings
extends Core {

    public static final class Movsb16
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            Memory.mem_writeb(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readb(si_base + CPU_Regs.reg_esi.word()));
            CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
            CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
        }

        public int call() {
            Movsb16.doString();
            return 4;
        }
    }

    public static final class Movsb16r
    extends Op {
        public static void doString() {
            int count;
            int len;
            int add_index = CPU.cpu.direction;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            for (count = CPU_Regs.reg_ecx.word(); count > 1; count -= len) {
                int esiCount;
                int ediCount;
                int dst_len;
                int src_len;
                int dst = di_base + CPU_Regs.reg_edi.word();
                int src = si_base + CPU_Regs.reg_esi.word();
                int dst_index = Paging.getDirectIndex(dst);
                int src_index = Paging.getDirectIndexRO(src);
                if (dst_index < 0 || src_index < 0) break;
                len = count;
                if (add_index < 0) {
                    src_len = (src & 0xFFF) + 1;
                    dst_len = (dst & 0xFFF) + 1;
                } else {
                    src_len = 4096 - (src & 0xFFF);
                    dst_len = 4096 - (dst & 0xFFF);
                }
                if (len > src_len) {
                    len = src_len;
                }
                if (len > dst_len) {
                    len = dst_len;
                }
                if (add_index < 0) {
                    ediCount = CPU_Regs.reg_edi.word() + 1;
                    esiCount = CPU_Regs.reg_esi.word() + 1;
                    if (len > ediCount) {
                        len = ediCount;
                    }
                    if (len > esiCount) {
                        len = esiCount;
                    }
                } else {
                    ediCount = 65536 - CPU_Regs.reg_edi.word();
                    esiCount = 65536 - CPU_Regs.reg_esi.word();
                    if (len > ediCount) {
                        len = ediCount;
                    }
                    if (len > esiCount) {
                        len = esiCount;
                    }
                }
                if (Math.abs(src_index - dst_index) < len) {
                    for (int i = 0; i < len; ++i) {
                        Memory.host_writeb(dst_index, Memory.host_readb(src_index));
                        dst_index += add_index;
                        src_index += add_index;
                    }
                } else {
                    if (add_index < 0) {
                        src_index -= len - 1;
                        dst_index -= len - 1;
                    }
                    Memory.host_memcpy(dst_index, src_index, len);
                }
                if (add_index < 0) {
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() - len);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() - len);
                } else {
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + len);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + len);
                }
                CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - len);
            }
            while (count > 0) {
                Memory.mem_writeb(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readb(si_base + CPU_Regs.reg_esi.word()));
                CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
                CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
                CPU_Regs.reg_ecx.word_dec();
                --count;
            }
        }

        public int call() {
            Movsb16r.doString();
            return 4;
        }
    }

    public static final class Movsb32
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            Memory.mem_writeb(di_base + CPU_Regs.reg_edi.dword, Memory.mem_readb(si_base + CPU_Regs.reg_esi.dword));
            CPU_Regs.reg_edi.dword += add_index;
            CPU_Regs.reg_esi.dword += add_index;
        }

        public int call() {
            Movsb32.doString();
            return 4;
        }
    }

    public static final class Movsb32r
    extends Op {
        public static void doString() {
            int count;
            int len;
            int add_index = CPU.cpu.direction;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            for (count = CPU_Regs.reg_ecx.dword; count > 1; count -= len) {
                int dst_len;
                int src_len;
                int dst = di_base + CPU_Regs.reg_edi.dword;
                int src = si_base + CPU_Regs.reg_esi.dword;
                int dst_index = Paging.getDirectIndex(dst);
                int src_index = Paging.getDirectIndexRO(src);
                if (dst_index < 0 || src_index < 0) break;
                len = count;
                if (add_index < 0) {
                    src_len = (src & 0xFFF) + 1;
                    dst_len = (dst & 0xFFF) + 1;
                } else {
                    src_len = 4096 - (src & 0xFFF);
                    dst_len = 4096 - (dst & 0xFFF);
                }
                if (len > src_len) {
                    len = src_len;
                }
                if (len > dst_len) {
                    len = dst_len;
                }
                if (Math.abs(src_index - dst_index) < len) {
                    for (int i = 0; i < len; ++i) {
                        Memory.host_writeb(dst_index, Memory.host_readb(src_index));
                        dst_index += add_index;
                        src_index += add_index;
                    }
                } else {
                    if (add_index < 0) {
                        src_index -= len - 1;
                        dst_index -= len - 1;
                    }
                    Memory.host_memcpy(dst_index, src_index, len);
                }
                if (add_index < 0) {
                    CPU_Regs.reg_edi.dword -= len;
                    CPU_Regs.reg_esi.dword -= len;
                } else {
                    CPU_Regs.reg_edi.dword += len;
                    CPU_Regs.reg_esi.dword += len;
                }
                CPU_Regs.reg_ecx.dword -= len;
            }
            while (count > 0) {
                Memory.mem_writeb(di_base + CPU_Regs.reg_edi.dword, Memory.mem_readb(si_base + CPU_Regs.reg_esi.dword));
                CPU_Regs.reg_edi.dword += add_index;
                CPU_Regs.reg_esi.dword += add_index;
                --CPU_Regs.reg_ecx.dword;
                --count;
            }
        }

        public int call() {
            Movsb32r.doString();
            return 4;
        }
    }

    public static final class Movsd16
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction << 2;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            Memory.mem_writed(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readd(si_base + CPU_Regs.reg_esi.word()));
            CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
            CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
        }

        public int call() {
            Movsd16.doString();
            return 4;
        }
    }

    public static final class Movsd16r
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction * 4;
            int count = CPU_Regs.reg_ecx.word();
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            while (count > 1) {
                int esiCount;
                int ediCount;
                int dst_len;
                int src_len;
                int dst = di_base + CPU_Regs.reg_edi.word();
                int src = si_base + CPU_Regs.reg_esi.word();
                int dst_index = Paging.getDirectIndex(dst);
                int src_index = Paging.getDirectIndexRO(src);
                if (dst_index < 0 || src_index < 0) break;
                int len = count << 2;
                if (add_index < 0) {
                    src_len = (src & 0xFFF) + 1;
                    dst_len = (dst & 0xFFF) + 1;
                } else {
                    src_len = 4096 - (src & 0xFFF);
                    dst_len = 4096 - (dst & 0xFFF);
                }
                if (len > src_len) {
                    len = src_len;
                }
                if (len > dst_len) {
                    len = dst_len;
                }
                if (add_index < 0) {
                    ediCount = CPU_Regs.reg_edi.word() + 1;
                    esiCount = CPU_Regs.reg_esi.word() + 1;
                    if (len > ediCount) {
                        len = ediCount;
                    }
                    if (len > esiCount) {
                        len = esiCount;
                    }
                    len &= 0xFFFFFFFC;
                } else {
                    ediCount = 65536 - CPU_Regs.reg_edi.word();
                    esiCount = 65536 - CPU_Regs.reg_esi.word();
                    if (len > ediCount) {
                        len = ediCount;
                    }
                    if (len > esiCount) {
                        len = esiCount;
                    }
                    len &= 0xFFFFFFFC;
                }
                if (len <= 0) {
                    Memory.mem_writed(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readd(si_base + CPU_Regs.reg_esi.word()));
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
                    CPU_Regs.reg_ecx.word_dec();
                    --count;
                    continue;
                }
                int thisCount = len >> 2;
                if (Math.abs(src_index - dst_index) < len) {
                    for (int i = 0; i < thisCount; ++i) {
                        Memory.host_writed(dst_index, Memory.host_readd(src_index));
                        dst_index += add_index;
                        src_index += add_index;
                    }
                } else {
                    if (add_index < 0) {
                        src_index -= len - 4;
                        dst_index -= len - 4;
                    }
                    Memory.host_memcpy(dst_index, src_index, len);
                }
                if (add_index < 0) {
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() - len);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() - len);
                } else {
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + len);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + len);
                }
                CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - thisCount);
                count -= thisCount;
            }
            while (count > 0) {
                Memory.mem_writed(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readd(si_base + CPU_Regs.reg_esi.word()));
                CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
                CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
                CPU_Regs.reg_ecx.word_dec();
                --count;
            }
        }

        public int call() {
            Movsd16r.doString();
            return 4;
        }
    }

    public static final class Movsd32
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction << 2;
            Memory.mem_writed(CPU.Segs_ESphys + CPU_Regs.reg_edi.dword, Memory.mem_readd(Core.base_ds + CPU_Regs.reg_esi.dword));
            CPU_Regs.reg_edi.dword += add_index;
            CPU_Regs.reg_esi.dword += add_index;
        }

        public int call() {
            Movsd32.doString();
            return 4;
        }
    }

    public static final class Movsd32r
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction << 2;
            int count = CPU_Regs.reg_ecx.dword;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            while (count > 1) {
                int dst_len;
                int src_len;
                int dst = di_base + CPU_Regs.reg_edi.dword;
                int src = si_base + CPU_Regs.reg_esi.dword;
                int dst_index = Paging.getDirectIndex(dst);
                int src_index = Paging.getDirectIndexRO(src);
                if (dst_index < 0 || src_index < 0) break;
                int len = count << 2;
                if (add_index < 0) {
                    src_len = (src & 0xFFF) + 1;
                    dst_len = (dst & 0xFFF) + 1;
                } else {
                    src_len = 4096 - (src & 0xFFF);
                    dst_len = 4096 - (dst & 0xFFF);
                }
                if (len > src_len) {
                    len = src_len;
                }
                if (len > dst_len) {
                    len = dst_len;
                }
                if ((len &= 0xFFFFFFFC) <= 0) {
                    Memory.mem_writed(di_base + CPU_Regs.reg_edi.dword, Memory.mem_readd(si_base + CPU_Regs.reg_esi.dword));
                    CPU_Regs.reg_edi.dword += add_index;
                    CPU_Regs.reg_esi.dword += add_index;
                    --CPU_Regs.reg_ecx.dword;
                    --count;
                    continue;
                }
                int thisCount = len >> 2;
                if (Math.abs(src_index - dst_index) < len) {
                    for (int i = 0; i < thisCount; ++i) {
                        Memory.host_writed(dst_index, Memory.host_readd(src_index));
                        dst_index += add_index;
                        src_index += add_index;
                    }
                } else {
                    if (add_index < 0) {
                        src_index -= len - 4;
                        dst_index -= len - 4;
                    }
                    Memory.host_memcpy(dst_index, src_index, len);
                }
                if (add_index < 0) {
                    CPU_Regs.reg_edi.dword -= len;
                    CPU_Regs.reg_esi.dword -= len;
                } else {
                    CPU_Regs.reg_edi.dword += len;
                    CPU_Regs.reg_esi.dword += len;
                }
                CPU_Regs.reg_ecx.dword -= thisCount;
                count -= thisCount;
            }
            while (count > 0) {
                Memory.mem_writed(di_base + CPU_Regs.reg_edi.dword, Memory.mem_readd(si_base + CPU_Regs.reg_esi.dword));
                CPU_Regs.reg_edi.dword += add_index;
                CPU_Regs.reg_esi.dword += add_index;
                --CPU_Regs.reg_ecx.dword;
                --count;
            }
        }

        public int call() {
            Movsd32r.doString();
            return 4;
        }
    }

    public static final class Movsw16
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction * 2;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            Memory.mem_writew(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readw(si_base + CPU_Regs.reg_esi.word()));
            CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
            CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
        }

        public int call() {
            Movsw16.doString();
            return 4;
        }
    }

    public static final class Movsw16r
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction << 1;
            int count = CPU_Regs.reg_ecx.word();
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            while (count > 1) {
                int esiCount;
                int ediCount;
                int dst_len;
                int src_len;
                int dst = di_base + CPU_Regs.reg_edi.word();
                int src = si_base + CPU_Regs.reg_esi.word();
                int dst_index = Paging.getDirectIndex(dst);
                int src_index = Paging.getDirectIndexRO(src);
                if (dst_index < 0 || src_index < 0) break;
                int len = count << 1;
                if (add_index < 0) {
                    src_len = (src & 0xFFF) + 1;
                    dst_len = (dst & 0xFFF) + 1;
                } else {
                    src_len = 4096 - (src & 0xFFF);
                    dst_len = 4096 - (dst & 0xFFF);
                }
                if (len > src_len) {
                    len = src_len;
                }
                if (len > dst_len) {
                    len = dst_len;
                }
                if (add_index < 0) {
                    ediCount = CPU_Regs.reg_edi.word() + 1;
                    esiCount = CPU_Regs.reg_esi.word() + 1;
                    if (len > ediCount) {
                        len = ediCount;
                    }
                    if (len > esiCount) {
                        len = esiCount;
                    }
                    len &= 0xFFFFFFFE;
                } else {
                    ediCount = 65536 - CPU_Regs.reg_edi.word();
                    esiCount = 65536 - CPU_Regs.reg_esi.word();
                    if (len > ediCount) {
                        len = ediCount;
                    }
                    if (len > esiCount) {
                        len = esiCount;
                    }
                    len &= 0xFFFFFFFE;
                }
                if (len <= 0) {
                    Memory.mem_writew(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readw(si_base + CPU_Regs.reg_esi.word()));
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
                    CPU_Regs.reg_ecx.word_dec();
                    --count;
                    continue;
                }
                int thisCount = len >> 1;
                if (Math.abs(src_index - dst_index) < len) {
                    for (int i = 0; i < thisCount; ++i) {
                        Memory.host_writew(dst_index, Memory.host_readw(src_index));
                        dst_index += add_index;
                        src_index += add_index;
                    }
                } else {
                    if (add_index < 0) {
                        src_index -= len - 2;
                        dst_index -= len - 2;
                    }
                    Memory.host_memcpy(dst_index, src_index, len);
                }
                if (add_index < 0) {
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() - len);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() - len);
                } else {
                    CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + len);
                    CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + len);
                }
                CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - thisCount);
                count -= thisCount;
            }
            while (count > 0) {
                Memory.mem_writew(di_base + CPU_Regs.reg_edi.word(), Memory.mem_readw(si_base + CPU_Regs.reg_esi.word()));
                CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + add_index);
                CPU_Regs.reg_esi.word(CPU_Regs.reg_esi.word() + add_index);
                CPU_Regs.reg_ecx.word_dec();
                --count;
            }
        }

        public int call() {
            Movsw16r.doString();
            return 4;
        }
    }

    public static final class Movsw32
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction << 1;
            Memory.mem_writew(CPU.Segs_ESphys + CPU_Regs.reg_edi.dword, Memory.mem_readw(Core.base_ds + CPU_Regs.reg_esi.dword));
            CPU_Regs.reg_edi.dword += add_index;
            CPU_Regs.reg_esi.dword += add_index;
        }

        public int call() {
            Movsw32.doString();
            return 4;
        }
    }

    public static final class Movsw32r
    extends Op {
        public static void doString() {
            int add_index = CPU.cpu.direction << 1;
            int count = CPU_Regs.reg_ecx.dword;
            int si_base = Core.base_ds;
            int di_base = CPU.Segs_ESphys;
            while (count > 1) {
                int dst_len;
                int src_len;
                int dst = di_base + CPU_Regs.reg_edi.dword;
                int src = si_base + CPU_Regs.reg_esi.dword;
                int dst_index = Paging.getDirectIndex(dst);
                int src_index = Paging.getDirectIndexRO(src);
                if (dst_index < 0 || src_index < 0 || Math.abs(src_index - dst_index) < 2) break;
                int len = count << 1;
                if (add_index < 0) {
                    if (Math.abs(src_index - dst_index) < len) break;
                    src_len = (src & 0xFFF) + 1;
                    dst_len = (dst & 0xFFF) + 1;
                } else {
                    src_len = 4096 - (src & 0xFFF);
                    dst_len = 4096 - (dst & 0xFFF);
                }
                if (len > src_len) {
                    len = src_len;
                }
                if (len > dst_len) {
                    len = dst_len;
                }
                if ((len &= 0xFFFFFFFE) <= 0) {
                    Memory.mem_writew(di_base + CPU_Regs.reg_edi.dword, Memory.mem_readw(si_base + CPU_Regs.reg_esi.dword));
                    CPU_Regs.reg_edi.dword += add_index;
                    CPU_Regs.reg_esi.dword += add_index;
                    --CPU_Regs.reg_ecx.dword;
                    --count;
                    continue;
                }
                int thisCount = len >> 1;
                if (Math.abs(src_index - dst_index) < len) {
                    for (int i = 0; i < thisCount; ++i) {
                        Memory.host_writew(dst_index, Memory.host_readw(src_index));
                        dst_index += add_index;
                        src_index += add_index;
                    }
                } else {
                    if (add_index < 0) {
                        src_index -= len - 2;
                        dst_index -= len - 2;
                    }
                    Memory.host_memcpy(dst_index, src_index, len);
                }
                if (add_index < 0) {
                    CPU_Regs.reg_edi.dword -= len;
                    CPU_Regs.reg_esi.dword -= len;
                } else {
                    CPU_Regs.reg_edi.dword += len;
                    CPU_Regs.reg_esi.dword += len;
                }
                CPU_Regs.reg_ecx.dword -= thisCount;
                count -= thisCount;
            }
            while (count > 0) {
                Memory.mem_writew(di_base + CPU_Regs.reg_edi.dword, Memory.mem_readw(si_base + CPU_Regs.reg_esi.dword));
                CPU_Regs.reg_edi.dword += add_index;
                CPU_Regs.reg_esi.dword += add_index;
                --CPU_Regs.reg_ecx.dword;
                --count;
            }
        }

        public int call() {
            Movsw32r.doString();
            return 4;
        }
    }
}

