/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_normal;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Core_normal;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.Modrm;
import jdos.cpu.Table_ea;
import jdos.cpu.core_normal.Prefix_0f;
import jdos.cpu.core_normal.Prefix_helpers;
import jdos.hardware.IO;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.util.IntRef;

public class Prefix_66
extends Prefix_0f {
    private static final IntRef int_ref_1 = new IntRef(0);

    static {
        Prefix_66.ops[513] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.ADDD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.ADDD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[515] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.ADDD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.ADDD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[517] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.ADDD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[518] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU.Segs_ESval);
                return 3;
            }
        };
        Prefix_66.ops[519] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegES(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_66.ops[521] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.ORD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.ORD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[523] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.ORD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.ORD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[525] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.ORD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[526] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU.Segs_CSval);
                return 3;
            }
        };
        Prefix_66.ops[529] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.ADCD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.ADCD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[531] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.ADCD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.ADCD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[533] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.ADCD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[534] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU.Segs_SSval);
                return 3;
            }
        };
        Prefix_66.ops[535] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegSS(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                ++CPU.CPU_Cycles;
                return 3;
            }
        };
        Prefix_66.ops[537] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.SBBD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.SBBD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[539] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.SBBD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.SBBD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[541] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.SBBD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[542] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU.Segs_DSval);
                return 3;
            }
        };
        Prefix_66.ops[543] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegDS(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_66.ops[545] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.ANDD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.ANDD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[547] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.ANDD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.ANDD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[549] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.ANDD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[553] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.SUBD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.SUBD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[555] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.SUBD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.SUBD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[557] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.SUBD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[561] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    r.dword = Instructions.XORD(Modrm.Getrd[rm].dword, r.dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Instructions.XORD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa)));
                }
                return 3;
            }
        };
        Prefix_66.ops[563] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.XORD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.XORD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66.ops[565] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.XORD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[569] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.CMPD(Modrm.Getrd[rm].dword, Modrm.GetEArd[rm].dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Instructions.CMPD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa));
                }
                return 3;
            }
        };
        Prefix_66.ops[571] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.CMPD(Modrm.GetEArd[rm].dword, Modrm.Getrd[rm].dword);
                } else {
                    Instructions.CMPD(Memory.mem_readd(Table_ea.getEaa(rm)), Modrm.Getrd[rm].dword);
                }
                return 3;
            }
        };
        Prefix_66.ops[573] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.CMPD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[576] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.INCD(CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[577] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.dword = Instructions.INCD(CPU_Regs.reg_ecx.dword);
                return 3;
            }
        };
        Prefix_66.ops[578] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.dword = Instructions.INCD(CPU_Regs.reg_edx.dword);
                return 3;
            }
        };
        Prefix_66.ops[579] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.dword = Instructions.INCD(CPU_Regs.reg_ebx.dword);
                return 3;
            }
        };
        Prefix_66.ops[580] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.dword = Instructions.INCD(CPU_Regs.reg_esp.dword);
                return 3;
            }
        };
        Prefix_66.ops[581] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebp.dword = Instructions.INCD(CPU_Regs.reg_ebp.dword);
                return 3;
            }
        };
        Prefix_66.ops[582] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esi.dword = Instructions.INCD(CPU_Regs.reg_esi.dword);
                return 3;
            }
        };
        Prefix_66.ops[583] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.dword = Instructions.INCD(CPU_Regs.reg_edi.dword);
                return 3;
            }
        };
        Prefix_66.ops[584] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Instructions.DECD(CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[585] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.dword = Instructions.DECD(CPU_Regs.reg_ecx.dword);
                return 3;
            }
        };
        Prefix_66.ops[586] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.dword = Instructions.DECD(CPU_Regs.reg_edx.dword);
                return 3;
            }
        };
        Prefix_66.ops[587] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.dword = Instructions.DECD(CPU_Regs.reg_ebx.dword);
                return 3;
            }
        };
        Prefix_66.ops[588] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.dword = Instructions.DECD(CPU_Regs.reg_esp.dword);
                return 3;
            }
        };
        Prefix_66.ops[589] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebp.dword = Instructions.DECD(CPU_Regs.reg_ebp.dword);
                return 3;
            }
        };
        Prefix_66.ops[590] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esi.dword = Instructions.DECD(CPU_Regs.reg_esi.dword);
                return 3;
            }
        };
        Prefix_66.ops[591] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.dword = Instructions.DECD(CPU_Regs.reg_edi.dword);
                return 3;
            }
        };
        Prefix_66.ops[592] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[593] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_ecx.dword);
                return 3;
            }
        };
        Prefix_66.ops[594] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_edx.dword);
                return 3;
            }
        };
        Prefix_66.ops[595] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_ebx.dword);
                return 3;
            }
        };
        Prefix_66.ops[596] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_esp.dword);
                return 3;
            }
        };
        Prefix_66.ops[597] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_ebp.dword);
                return 3;
            }
        };
        Prefix_66.ops[598] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_esi.dword);
                return 3;
            }
        };
        Prefix_66.ops[599] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU_Regs.reg_edi.dword);
                return 3;
            }
        };
        Prefix_66.ops[600] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[601] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[602] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[603] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[604] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[605] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebp.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[606] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esi.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[607] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[608] = new Prefix_helpers.OP(){

            public final int call() {
                int tmpesp = CPU_Regs.reg_esp.dword;
                CPU.CPU_Push32(CPU_Regs.reg_eax.dword);
                CPU.CPU_Push32(CPU_Regs.reg_ecx.dword);
                CPU.CPU_Push32(CPU_Regs.reg_edx.dword);
                CPU.CPU_Push32(CPU_Regs.reg_ebx.dword);
                CPU.CPU_Push32(tmpesp);
                CPU.CPU_Push32(CPU_Regs.reg_ebp.dword);
                CPU.CPU_Push32(CPU_Regs.reg_esi.dword);
                CPU.CPU_Push32(CPU_Regs.reg_edi.dword);
                return 3;
            }
        };
        Prefix_66.ops[609] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.dword = CPU.CPU_Pop32();
                CPU_Regs.reg_esi.dword = CPU.CPU_Pop32();
                CPU_Regs.reg_ebp.dword = CPU.CPU_Pop32();
                CPU.CPU_Pop32();
                CPU_Regs.reg_ebx.dword = CPU.CPU_Pop32();
                CPU_Regs.reg_edx.dword = CPU.CPU_Pop32();
                CPU_Regs.reg_ecx.dword = CPU.CPU_Pop32();
                CPU_Regs.reg_eax.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[610] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int eaa = Table_ea.getEaa(rm);
                int bound_min = Memory.mem_readd(eaa);
                int bound_max = Memory.mem_readd(eaa + 4);
                int rmrd = Modrm.Getrd[rm].dword;
                if (rmrd < bound_min || rmrd > bound_max) {
                    return Prefix_helpers.EXCEPTION(5);
                }
                return 3;
            }
        };
        Prefix_66.ops[611] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.cpu.pmode && (CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int_ref_1.value = Modrm.GetEArd[rm].dword;
                    CPU.CPU_ARPL(int_ref_1, Modrm.Getrw[rm].word());
                    Modrm.GetEArd[rm].dword = int_ref_1.value;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int_ref_1.value = Memory.mem_readw(eaa);
                    CPU.CPU_ARPL(int_ref_1, Modrm.Getrw[rm].word());
                    Memory.mem_writed(eaa, int_ref_1.value);
                }
                return 3;
            }
        };
        Prefix_66.ops[616] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(Core.Fetchd());
                return 3;
            }
        };
        Prefix_66.ops[617] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int op3 = Core.Fetchds();
                    Modrm.Getrd[rm].dword = Instructions.DIMULD(Modrm.GetEArd[rm].dword, op3);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int op3 = Core.Fetchds();
                    Modrm.Getrd[rm].dword = Instructions.DIMULD(Memory.mem_readd(eaa), op3);
                }
                return 3;
            }
        };
        Prefix_66.ops[618] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(Core.Fetchbs());
                return 3;
            }
        };
        Prefix_66.ops[619] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    byte op3 = Core.Fetchbs();
                    Modrm.Getrd[rm].dword = Instructions.DIMULD(Modrm.GetEArd[rm].dword, op3);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    byte op3 = Core.Fetchbs();
                    Modrm.Getrd[rm].dword = Instructions.DIMULD(Memory.mem_readd(eaa), op3);
                }
                return 3;
            }
        };
        Prefix_66.ops[621] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 4)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Prefix_66.DoString(6);
                return 3;
            }
        };
        Prefix_66.ops[623] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 4)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Prefix_66.DoString(3);
                return 3;
            }
        };
        Prefix_66.ops[624] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_O());
                return 6;
            }
        };
        Prefix_66.ops[625] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NO());
                return 6;
            }
        };
        Prefix_66.ops[626] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_B());
                return 6;
            }
        };
        Prefix_66.ops[627] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NB());
                return 6;
            }
        };
        Prefix_66.ops[628] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_Z());
                return 6;
            }
        };
        Prefix_66.ops[629] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NZ());
                return 6;
            }
        };
        Prefix_66.ops[630] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_BE());
                return 6;
            }
        };
        Prefix_66.ops[631] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NBE());
                return 6;
            }
        };
        Prefix_66.ops[632] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_S());
                return 6;
            }
        };
        Prefix_66.ops[633] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NS());
                return 6;
            }
        };
        Prefix_66.ops[634] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_P());
                return 6;
            }
        };
        Prefix_66.ops[635] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NP());
                return 6;
            }
        };
        Prefix_66.ops[636] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_L());
                return 6;
            }
        };
        Prefix_66.ops[637] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NL());
                return 6;
            }
        };
        Prefix_66.ops[638] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_LE());
                return 6;
            }
        };
        Prefix_66.ops[639] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(Flags.TFLG_NLE());
                return 6;
            }
        };
        Prefix_66.ops[641] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    int id = Core.Fetchd();
                    switch (which) {
                        case 0: {
                            r.dword = Instructions.ADDD(id, r.dword);
                            break;
                        }
                        case 1: {
                            r.dword = Instructions.ORD(id, r.dword);
                            break;
                        }
                        case 2: {
                            r.dword = Instructions.ADCD(id, r.dword);
                            break;
                        }
                        case 3: {
                            r.dword = Instructions.SBBD(id, r.dword);
                            break;
                        }
                        case 4: {
                            r.dword = Instructions.ANDD(id, r.dword);
                            break;
                        }
                        case 5: {
                            r.dword = Instructions.SUBD(id, r.dword);
                            break;
                        }
                        case 6: {
                            r.dword = Instructions.XORD(id, r.dword);
                            break;
                        }
                        case 7: {
                            Instructions.CMPD(id, r.dword);
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int id = Core.Fetchd();
                    switch (which) {
                        case 0: {
                            Memory.mem_writed(eaa, Instructions.ADDD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 1: {
                            Memory.mem_writed(eaa, Instructions.ORD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 2: {
                            Memory.mem_writed(eaa, Instructions.ADCD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 3: {
                            Memory.mem_writed(eaa, Instructions.SBBD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 4: {
                            Memory.mem_writed(eaa, Instructions.ANDD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 5: {
                            Memory.mem_writed(eaa, Instructions.SUBD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 6: {
                            Memory.mem_writed(eaa, Instructions.XORD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 7: {
                            Instructions.CMPD(id, Memory.mem_readd(eaa));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_66.ops[643] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    byte id = Core.Fetchbs();
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    switch (which) {
                        case 0: {
                            r.dword = Instructions.ADDD(id, r.dword);
                            break;
                        }
                        case 1: {
                            r.dword = Instructions.ORD(id, r.dword);
                            break;
                        }
                        case 2: {
                            r.dword = Instructions.ADCD(id, r.dword);
                            break;
                        }
                        case 3: {
                            r.dword = Instructions.SBBD(id, r.dword);
                            break;
                        }
                        case 4: {
                            r.dword = Instructions.ANDD(id, r.dword);
                            break;
                        }
                        case 5: {
                            r.dword = Instructions.SUBD(id, r.dword);
                            break;
                        }
                        case 6: {
                            r.dword = Instructions.XORD(id, r.dword);
                            break;
                        }
                        case 7: {
                            Instructions.CMPD(id, r.dword);
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    byte id = Core.Fetchbs();
                    switch (which) {
                        case 0: {
                            Memory.mem_writed(eaa, Instructions.ADDD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 1: {
                            Memory.mem_writed(eaa, Instructions.ORD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 2: {
                            Memory.mem_writed(eaa, Instructions.ADCD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 3: {
                            Memory.mem_writed(eaa, Instructions.SBBD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 4: {
                            Memory.mem_writed(eaa, Instructions.ANDD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 5: {
                            Memory.mem_writed(eaa, Instructions.SUBD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 6: {
                            Memory.mem_writed(eaa, Instructions.XORD(id, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 7: {
                            Instructions.CMPD(id, Memory.mem_readd(eaa));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_66.ops[645] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.TESTD(Modrm.Getrd[rm].dword, Modrm.GetEArd[rm].dword);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Instructions.TESTD(Modrm.Getrd[rm].dword, Memory.mem_readd(eaa));
                }
                return 3;
            }
        };
        Prefix_66.ops[647] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg rd = Modrm.Getrd[rm];
                int oldrmrd = rd.dword;
                if (rm >= 192) {
                    CPU_Regs.Reg eard = Modrm.GetEArd[rm];
                    rd.dword = eard.dword;
                    eard.dword = oldrmrd;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int val = Memory.mem_readd(eaa);
                    Memory.mem_writed(eaa, oldrmrd);
                    rd.dword = val;
                }
                return 3;
            }
        };
        Prefix_66.ops[649] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArd[rm].dword = Modrm.Getrd[rm].dword;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Modrm.Getrd[rm].dword);
                }
                return 3;
            }
        };
        Prefix_66.ops[651] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrd[rm].dword = Modrm.GetEArd[rm].dword;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrd[rm].dword = Memory.mem_readd(eaa);
                }
                return 3;
            }
        };
        Prefix_66.ops[652] = new Prefix_helpers.OP(){

            public final int call() {
                int val;
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: {
                        val = CPU.Segs_ESval;
                        break;
                    }
                    case 1: {
                        val = CPU.Segs_CSval;
                        break;
                    }
                    case 2: {
                        val = CPU.Segs_SSval;
                        break;
                    }
                    case 3: {
                        val = CPU.Segs_DSval;
                        break;
                    }
                    case 4: {
                        val = CPU.Segs_FSval;
                        break;
                    }
                    case 5: {
                        val = CPU.Segs_GSval;
                        break;
                    }
                    default: {
                        Log.log(8, 2, "CPU:8c:Illegal RM Byte");
                        return 1;
                    }
                }
                if (rm >= 192) {
                    Modrm.GetEArd[rm].dword = val;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, val);
                }
                return 3;
            }
        };
        Prefix_66.ops[653] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Core.base_ss = 0;
                Core.base_ds = 0;
                Modrm.Getrd[rm].dword = Prefix_helpers.TEST_PREFIX_ADDR() != 0 ? Table_ea.getEaa32(rm) : Table_ea.getEaa16(rm);
                return 3;
            }
        };
        Prefix_66.ops[655] = new Prefix_helpers.OP(){

            public final int call() {
                int val = CPU.CPU_Pop32();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArd[rm].dword = val;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, val);
                }
                return 3;
            }
        };
        Prefix_66.ops[657] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_ecx.dword;
                CPU_Regs.reg_ecx.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[658] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_edx.dword;
                CPU_Regs.reg_edx.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[659] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_ebx.dword;
                CPU_Regs.reg_ebx.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[660] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_esp.dword;
                CPU_Regs.reg_esp.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[661] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_ebp.dword;
                CPU_Regs.reg_ebp.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[662] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_esi.dword;
                CPU_Regs.reg_esi.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[663] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.dword;
                CPU_Regs.reg_eax.dword = CPU_Regs.reg_edi.dword;
                CPU_Regs.reg_edi.dword = temp;
                return 3;
            }
        };
        Prefix_66.ops[664] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = (short)CPU_Regs.reg_eax.word();
                return 3;
            }
        };
        Prefix_66.ops[665] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.dword = (CPU_Regs.reg_eax.dword & Integer.MIN_VALUE) != 0 ? -1 : 0;
                return 3;
            }
        };
        Prefix_66.ops[666] = new Prefix_helpers.OP(){

            public final int call() {
                int newip = Core.Fetchd();
                int newcs = Core.Fetchw();
                Flags.FillFlags();
                CPU.CPU_CALL(true, newcs, newip, Prefix_helpers.GETIP());
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 5;
                }
                return 6;
            }
        };
        Prefix_66.ops[668] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PUSHF(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_66.ops[669] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_POPF(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 8;
                }
                if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                    return 8;
                }
                return 3;
            }
        };
        Prefix_66.ops[673] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Memory.mem_readd(Prefix_66.GetEADirect());
                return 3;
            }
        };
        Prefix_66.ops[675] = new Prefix_helpers.OP(){

            public final int call() {
                Memory.mem_writed(Prefix_66.GetEADirect(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[677] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_66.DoString(9);
                return 3;
            }
        };
        Prefix_66.ops[679] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_66.DoString(21);
                return 3;
            }
        };
        Prefix_66.ops[681] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.TESTD(Core.Fetchd(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[683] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_66.DoString(15);
                return 3;
            }
        };
        Prefix_66.ops[685] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_66.DoString(12);
                return 3;
            }
        };
        Prefix_66.ops[687] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_66.DoString(18);
                return 3;
            }
        };
        Prefix_66.ops[696] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[697] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[698] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[699] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[700] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[701] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebp.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[702] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esi.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[703] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.dword = Core.Fetchd();
                return 3;
            }
        };
        Prefix_66.ops[705] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    short blah = Core.Fetchb();
                    int val = blah & 0x1F;
                    if (val == 0) {
                        return 3;
                    }
                    CPU_Regs.Reg r = Modrm.GetEArd[rm];
                    switch (which) {
                        case 0: {
                            r.dword = Instructions.ROLD(val, r.dword);
                            break;
                        }
                        case 1: {
                            r.dword = Instructions.RORD(val, r.dword);
                            break;
                        }
                        case 2: {
                            r.dword = Instructions.RCLD(val, r.dword);
                            break;
                        }
                        case 3: {
                            r.dword = Instructions.RCRD(val, r.dword);
                            break;
                        }
                        case 4: 
                        case 6: {
                            r.dword = Instructions.SHLD(val, r.dword);
                            break;
                        }
                        case 5: {
                            r.dword = Instructions.SHRD(val, r.dword);
                            break;
                        }
                        case 7: {
                            r.dword = Instructions.SARD(val, r.dword);
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    short blah = Core.Fetchb();
                    int val = blah & 0x1F;
                    if (val == 0) {
                        return 3;
                    }
                    switch (which) {
                        case 0: {
                            Memory.mem_writed(eaa, Instructions.ROLD(val, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 1: {
                            Memory.mem_writed(eaa, Instructions.RORD(val, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 2: {
                            Memory.mem_writed(eaa, Instructions.RCLD(val, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 3: {
                            Memory.mem_writed(eaa, Instructions.RCRD(val, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 4: 
                        case 6: {
                            Memory.mem_writed(eaa, Instructions.SHLD(val, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 5: {
                            Memory.mem_writed(eaa, Instructions.SHRD(val, Memory.mem_readd(eaa)));
                            break;
                        }
                        case 7: {
                            Memory.mem_writed(eaa, Instructions.SARD(val, Memory.mem_readd(eaa)));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_66.ops[706] = new Prefix_helpers.OP(){

            public final int call() {
                int offset = Core.Fetchw();
                CPU_Regs.reg_eip = CPU.CPU_Pop32();
                CPU_Regs.reg_esp.dword += offset;
                return 6;
            }
        };
        Prefix_66.ops[707] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eip = CPU.CPU_Pop32();
                return 6;
            }
        };
        Prefix_66.ops[708] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa + 4))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrd[rm].dword = Memory.mem_readd(eaa);
                return 3;
            }
        };
        Prefix_66.ops[709] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa + 4))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrd[rm].dword = Memory.mem_readd(eaa);
                return 3;
            }
        };
        Prefix_66.ops[711] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArd[rm].dword = Core.Fetchd();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writed(eaa, Core.Fetchd());
                }
                return 3;
            }
        };
        Prefix_66.ops[712] = new Prefix_helpers.OP(){

            public final int call() {
                int bytes = Core.Fetchw();
                short level = Core.Fetchb();
                CPU.CPU_ENTER(true, bytes, level);
                return 3;
            }
        };
        Prefix_66.ops[713] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.dword &= CPU.cpu.stack.notmask;
                CPU_Regs.reg_esp.dword |= CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask;
                CPU_Regs.reg_ebp.dword = CPU.CPU_Pop32();
                return 3;
            }
        };
        Prefix_66.ops[714] = new Prefix_helpers.OP(){

            public final int call() {
                int words = Core.Fetchw();
                Flags.FillFlags();
                CPU.CPU_RET(true, words, Prefix_helpers.GETIP());
                return 6;
            }
        };
        Prefix_66.ops[715] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                CPU.CPU_RET(true, 0, Prefix_helpers.GETIP());
                return 6;
            }
        };
        Prefix_66.ops[719] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_IRET(true, Prefix_helpers.GETIP());
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 5;
                }
                if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                    return 5;
                }
                return 6;
            }
        };
        Prefix_66.ops[721] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2D(rm, 1);
                return 3;
            }
        };
        Prefix_66.ops[723] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2D(rm, CPU_Regs.reg_ecx.low());
                return 3;
            }
        };
        Prefix_66.ops[736] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Prefix_helpers.JumpCond32_b(CPU_Regs.reg_ecx.dword - 1 != 0 && !Flags.get_ZF());
                    --CPU_Regs.reg_ecx.dword;
                } else {
                    Prefix_helpers.JumpCond32_b(CPU_Regs.reg_ecx.word() - 1 != 0 && !Flags.get_ZF());
                    CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
                }
                return 6;
            }
        };
        Prefix_66.ops[737] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Prefix_helpers.JumpCond32_b(CPU_Regs.reg_ecx.dword - 1 != 0 && Flags.get_ZF());
                    --CPU_Regs.reg_ecx.dword;
                } else {
                    Prefix_helpers.JumpCond32_b(CPU_Regs.reg_ecx.word() - 1 != 0 && Flags.get_ZF());
                    CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
                }
                return 6;
            }
        };
        Prefix_66.ops[738] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Prefix_helpers.JumpCond32_b(CPU_Regs.reg_ecx.dword - 1 != 0);
                    --CPU_Regs.reg_ecx.dword;
                } else {
                    Prefix_helpers.JumpCond32_b(CPU_Regs.reg_ecx.word() - 1 != 0);
                    CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
                }
                return 6;
            }
        };
        Prefix_66.ops[739] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_b(((long)CPU_Regs.reg_ecx.dword & Prefix_helpers.AddrMaskTable1[Core.prefixes & 1]) == 0L);
                return 6;
            }
        };
        Prefix_66.ops[741] = new Prefix_helpers.OP(){

            public final int call() {
                short port = Core.Fetchb();
                if (CPU.CPU_IO_Exception(port, 4)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                CPU_Regs.reg_eax.dword = IO.IO_ReadD(port);
                return 3;
            }
        };
        Prefix_66.ops[743] = new Prefix_helpers.OP(){

            public final int call() {
                short port = Core.Fetchb();
                if (CPU.CPU_IO_Exception(port, 4)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                IO.IO_WriteD(port, CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[744] = new Prefix_helpers.OP(){

            public final int call() {
                int addip = Core.Fetchds();
                CPU.CPU_Push32(Prefix_helpers.GETIP());
                Prefix_helpers.SAVEIP();
                CPU_Regs.reg_eip += addip;
                return 6;
            }
        };
        Prefix_66.ops[745] = new Prefix_helpers.OP(){

            public final int call() {
                int addip = Core.Fetchds();
                Prefix_helpers.SAVEIP();
                CPU_Regs.reg_eip += addip;
                return 6;
            }
        };
        Prefix_66.ops[746] = new Prefix_helpers.OP(){

            public final int call() {
                int newip = Core.Fetchd();
                int newcs = Core.Fetchw();
                Flags.FillFlags();
                CPU.CPU_JMP(true, newcs, newip, Prefix_helpers.GETIP());
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 5;
                }
                return 6;
            }
        };
        Prefix_66.ops[747] = new Prefix_helpers.OP(){

            public final int call() {
                byte addip = Core.Fetchbs();
                Prefix_helpers.SAVEIP();
                CPU_Regs.reg_eip += addip;
                return 6;
            }
        };
        Prefix_66.ops[749] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.dword = IO.IO_ReadD(CPU_Regs.reg_edx.word());
                return 3;
            }
        };
        Prefix_66.ops[751] = new Prefix_helpers.OP(){

            public final int call() {
                IO.IO_WriteD(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66.ops[759] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: 
                    case 1: {
                        if (rm >= 192) {
                            Instructions.TESTD(Core.Fetchd(), Modrm.GetEArd[rm].dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.TESTD(Core.Fetchd(), Memory.mem_readd(eaa));
                        break;
                    }
                    case 2: {
                        if (rm >= 192) {
                            CPU_Regs.Reg r = Modrm.GetEArd[rm];
                            r.dword ^= 0xFFFFFFFF;
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writed(eaa, ~Memory.mem_readd(eaa));
                        break;
                    }
                    case 3: {
                        if (rm >= 192) {
                            CPU_Regs.Reg r = Modrm.GetEArd[rm];
                            r.dword = Instructions.Negd(r.dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writed(eaa, Instructions.Negd(Memory.mem_readd(eaa)));
                        break;
                    }
                    case 4: {
                        if (rm >= 192) {
                            Instructions.MULD(Modrm.GetEArd[rm].dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.MULD(Memory.mem_readd(eaa));
                        break;
                    }
                    case 5: {
                        if (rm >= 192) {
                            Instructions.IMULD(Modrm.GetEArd[rm].dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.IMULD(Memory.mem_readd(eaa));
                        break;
                    }
                    case 6: {
                        if (rm >= 192) {
                            Instructions.DIVD(Modrm.GetEArd[rm].dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.DIVD(Memory.mem_readd(eaa));
                        break;
                    }
                    case 7: {
                        if (rm >= 192) {
                            Instructions.IDIVD(Modrm.GetEArd[rm].dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.IDIVD(Memory.mem_readd(eaa));
                    }
                }
                return 3;
            }
        };
        Prefix_66.ops[767] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: {
                        if (rm >= 192) {
                            CPU_Regs.Reg r = Modrm.GetEArd[rm];
                            r.dword = Instructions.INCD(r.dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writed(eaa, Instructions.INCD(Memory.mem_readd(eaa)));
                        break;
                    }
                    case 1: {
                        if (rm >= 192) {
                            CPU_Regs.Reg r = Modrm.GetEArd[rm];
                            r.dword = Instructions.DECD(r.dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writed(eaa, Instructions.DECD(Memory.mem_readd(eaa)));
                        break;
                    }
                    case 2: {
                        int eip;
                        if (rm >= 192) {
                            eip = Modrm.GetEArd[rm].dword;
                        } else {
                            int eaa = Table_ea.getEaa(rm);
                            eip = Memory.mem_readd(eaa);
                        }
                        CPU.CPU_Push32(Prefix_helpers.GETIP());
                        CPU_Regs.reg_eip = eip;
                        return 6;
                    }
                    case 3: {
                        if (rm >= 192) {
                            return 1;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        int newip = Memory.mem_readd(eaa);
                        int newcs = Memory.mem_readw(eaa + 4);
                        Flags.FillFlags();
                        CPU.CPU_CALL(true, newcs, newip, Prefix_helpers.GETIP());
                        if (CPU_Regs.GETFLAG(256) != 0) {
                            CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                            return 5;
                        }
                        return 6;
                    }
                    case 4: {
                        if (rm >= 192) {
                            CPU_Regs.reg_eip = Modrm.GetEArd[rm].dword;
                        } else {
                            int eaa = Table_ea.getEaa(rm);
                            CPU_Regs.reg_eip = Memory.mem_readd(eaa);
                        }
                        return 6;
                    }
                    case 5: {
                        if (rm >= 192) {
                            return 1;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        int newip = Memory.mem_readd(eaa);
                        int newcs = Memory.mem_readw(eaa + 4);
                        Flags.FillFlags();
                        CPU.CPU_JMP(true, newcs, newip, Prefix_helpers.GETIP());
                        if (CPU_Regs.GETFLAG(256) != 0) {
                            CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                            return 5;
                        }
                        return 6;
                    }
                    case 6: {
                        if (rm >= 192) {
                            CPU.CPU_Push32(Modrm.GetEArd[rm].dword);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        CPU.CPU_Push32(Memory.mem_readd(eaa));
                        break;
                    }
                    default: {
                        Log.log(8, 2, "CPU:66:GRP5:Illegal call " + Integer.toString(which, 16));
                        return 1;
                    }
                }
                return 3;
            }
        };
    }
}

