/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_normal;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Instructions;
import jdos.cpu.Modrm;
import jdos.hardware.Memory;

public class Prefix_helpers
extends Instructions {
    protected static final long[] AddrMaskTable = new long[]{65535L, 0xFFFFFFFFL};
    protected static final long[] AddrMaskTable1 = new long[]{65535L, -1L};
    protected static final int OPCODE_NONE = 0;
    protected static final int OPCODE_0F = 256;
    protected static final int OPCODE_SIZE = 512;
    public static final int ILLEGAL_OPCODE = 1;
    public static final int NOT_HANDLED = 2;
    public static final int HANDLED = 3;
    public static final int RESTART = 4;
    public static final int CBRET_NONE = 5;
    public static final int CONTINUE = 6;
    public static final int RETURN = 7;
    public static final int DECODE_END = 8;
    protected static short r;
    protected static int m;
    protected static final Instructions.loadw rw_l;
    protected static final Instructions.savew rw_s;
    protected static final Instructions.loadb earb_l;
    protected static final Instructions.saveb earb_s;
    protected static final Instructions.loadw earw_l;
    protected static final Instructions.savew earw_s;
    protected static final Instructions.loadb b_l;
    protected static final Instructions.saveb b_s;
    protected static final Instructions.loadw w_l;
    protected static final Instructions.savew w_s;

    protected static int TEST_PREFIX_ADDR() {
        return prefixes & 1;
    }

    public static int RUNEXCEPTION() {
        CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
        return 6;
    }

    public static int EXCEPTION(int blah) {
        CPU.CPU_Exception(blah);
        return 6;
    }

    protected static int GETIP() {
        return cseip - CPU.Segs_CSphys;
    }

    public static void SAVEIP() {
        CPU_Regs.reg_eip = Prefix_helpers.GETIP();
    }

    protected static void LOADIP() {
        cseip = CPU.Segs_CSphys + CPU_Regs.reg_eip;
    }

    protected static void JumpCond16_b(boolean COND) {
        if (COND) {
            byte offset = Prefix_helpers.Fetchbs();
            Prefix_helpers.SAVEIP();
            Prefix_helpers.reg_ip(Prefix_helpers.reg_ip() + offset);
        } else {
            Prefix_helpers.SAVEIP();
            Prefix_helpers.reg_ip(Prefix_helpers.reg_ip() + 1);
        }
    }

    protected static void JumpCond16_w(boolean COND) {
        if (COND) {
            short offset = Prefix_helpers.Fetchws();
            Prefix_helpers.SAVEIP();
            Prefix_helpers.reg_ip(Prefix_helpers.reg_ip() + offset);
        } else {
            Prefix_helpers.SAVEIP();
            Prefix_helpers.reg_ip(Prefix_helpers.reg_ip() + 2);
        }
    }

    protected static void JumpCond32_b(boolean COND) {
        if (COND) {
            byte offset = Prefix_helpers.Fetchbs();
            Prefix_helpers.SAVEIP();
            reg_eip += offset;
        } else {
            Prefix_helpers.SAVEIP();
            ++reg_eip;
        }
    }

    protected static void JumpCond32_d(boolean COND) {
        if (COND) {
            int offset = Prefix_helpers.Fetchds();
            Prefix_helpers.SAVEIP();
            reg_eip += offset;
        } else {
            Prefix_helpers.SAVEIP();
            reg_eip += 4;
        }
    }

    protected static void SETcc(boolean cc) {
        short rm = Prefix_helpers.Fetchb();
        if (rm >= 192) {
            Modrm.GetEArb[rm].set((short)(cc ? 1 : 0));
        } else {
            Memory.mem_writeb(Prefix_helpers.getEaa(rm), cc ? 1 : 0);
        }
    }

    protected static void GRP2B(short rm, int blah) {
        int which = rm >> 3 & 7;
        if (rm >= 192) {
            short val = (short)(blah & 0x1F);
            r = rm;
            short earb = Modrm.GetEArb[rm].get();
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLB(earb, val, earb_l, earb_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORB(earb, val, earb_l, earb_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLB(val, earb_l, earb_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRB(val, earb_l, earb_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLB(val, earb_l, earb_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRB(val, earb_l, earb_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARB(val, earb_l, earb_s);
                }
            }
        } else {
            m = Prefix_helpers.getEaa(rm);
            short val = (short)(blah & 0x1F);
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLB(m, val, b_l, b_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORB(m, val, b_l, b_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLB(val, b_l, b_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRB(val, b_l, b_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLB(val, b_l, b_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRB(val, b_l, b_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARB(val, b_l, b_s);
                }
            }
        }
    }

    protected static void GRP2B_fetchb(short rm) {
        int which = rm >> 3 & 7;
        if (rm >= 192) {
            short blah = Prefix_helpers.Fetchb();
            short val = (short)(blah & 0x1F);
            r = rm;
            short earb = Modrm.GetEArb[rm].get();
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLB(earb, val, earb_l, earb_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORB(earb, val, earb_l, earb_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLB(val, earb_l, earb_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRB(val, earb_l, earb_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLB(val, earb_l, earb_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRB(val, earb_l, earb_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARB(val, earb_l, earb_s);
                }
            }
        } else {
            m = Prefix_helpers.getEaa(rm);
            short blah = Prefix_helpers.Fetchb();
            short val = (short)(blah & 0x1F);
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLB(m, val, b_l, b_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORB(m, val, b_l, b_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLB(val, b_l, b_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRB(val, b_l, b_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLB(val, b_l, b_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRB(val, b_l, b_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARB(val, b_l, b_s);
                }
            }
        }
    }

    protected static void GRP2W(short rm, int blah) {
        int which = rm >> 3 & 7;
        if (rm >= 192) {
            int val = blah & 0x1F;
            r = rm;
            int earw = Modrm.GetEArw[rm].word();
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLW(earw, val, earw_l, earw_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORW(earw, val, earw_l, earw_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLW(val, earw_l, earw_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRW(val, earw_l, earw_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLW(val, earw_l, earw_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRW(val, earw_l, earw_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARW(val, earw_l, earw_s);
                }
            }
        } else {
            m = Prefix_helpers.getEaa(rm);
            int val = blah & 0x1F;
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLW(m, val, w_l, w_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORW(m, val, w_l, w_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLW(val, w_l, w_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRW(val, w_l, w_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLW(val, w_l, w_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRW(val, w_l, w_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARW(val, w_l, w_s);
                }
            }
        }
    }

    protected static void GRP2W_fetchb(short rm) {
        int which = rm >> 3 & 7;
        if (rm >= 192) {
            short blah = Prefix_helpers.Fetchb();
            int val = blah & 0x1F;
            r = rm;
            int earw = Modrm.GetEArw[rm].word();
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLW(earw, val, earw_l, earw_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORW(earw, val, earw_l, earw_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLW(val, earw_l, earw_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRW(val, earw_l, earw_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLW(val, earw_l, earw_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRW(val, earw_l, earw_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARW(val, earw_l, earw_s);
                }
            }
        } else {
            m = Prefix_helpers.getEaa(rm);
            short blah = Prefix_helpers.Fetchb();
            int val = blah & 0x1F;
            switch (which) {
                case 0: {
                    Prefix_helpers.ROLW(m, val, w_l, w_s);
                    break;
                }
                case 1: {
                    Prefix_helpers.RORW(m, val, w_l, w_s);
                    break;
                }
                case 2: {
                    Prefix_helpers.RCLW(val, w_l, w_s);
                    break;
                }
                case 3: {
                    Prefix_helpers.RCRW(val, w_l, w_s);
                    break;
                }
                case 4: 
                case 6: {
                    Prefix_helpers.SHLW(val, w_l, w_s);
                    break;
                }
                case 5: {
                    Prefix_helpers.SHRW(val, w_l, w_s);
                    break;
                }
                case 7: {
                    Prefix_helpers.SARW(val, w_l, w_s);
                }
            }
        }
    }

    protected static void GRP2D(short rm, int blah) {
        int which = rm >> 3 & 7;
        if (rm >= 192) {
            int val = blah & 0x1F;
            if (val == 0) {
                return;
            }
            CPU_Regs.Reg r = Modrm.GetEArd[rm];
            switch (which) {
                case 0: {
                    r.dword = Prefix_helpers.ROLD(val, r.dword);
                    break;
                }
                case 1: {
                    r.dword = Prefix_helpers.RORD(val, r.dword);
                    break;
                }
                case 2: {
                    r.dword = Prefix_helpers.RCLD(val, r.dword);
                    break;
                }
                case 3: {
                    r.dword = Prefix_helpers.RCRD(val, r.dword);
                    break;
                }
                case 4: 
                case 6: {
                    r.dword = Prefix_helpers.SHLD(val, r.dword);
                    break;
                }
                case 5: {
                    r.dword = Prefix_helpers.SHRD(val, r.dword);
                    break;
                }
                case 7: {
                    r.dword = Prefix_helpers.SARD(val, r.dword);
                }
            }
        } else {
            int eaa = Prefix_helpers.getEaa(rm);
            int val = blah & 0x1F;
            if (val == 0) {
                return;
            }
            switch (which) {
                case 0: {
                    Memory.mem_writed(eaa, Prefix_helpers.ROLD(val, Memory.mem_readd(eaa)));
                    break;
                }
                case 1: {
                    Memory.mem_writed(eaa, Prefix_helpers.RORD(val, Memory.mem_readd(eaa)));
                    break;
                }
                case 2: {
                    Memory.mem_writed(eaa, Prefix_helpers.RCLD(val, Memory.mem_readd(eaa)));
                    break;
                }
                case 3: {
                    Memory.mem_writed(eaa, Prefix_helpers.RCRD(val, Memory.mem_readd(eaa)));
                    break;
                }
                case 4: 
                case 6: {
                    Memory.mem_writed(eaa, Prefix_helpers.SHLD(val, Memory.mem_readd(eaa)));
                    break;
                }
                case 5: {
                    Memory.mem_writed(eaa, Prefix_helpers.SHRD(val, Memory.mem_readd(eaa)));
                    break;
                }
                case 7: {
                    Memory.mem_writed(eaa, Prefix_helpers.SARD(val, Memory.mem_readd(eaa)));
                }
            }
        }
    }

    static {
        rw_l = new Instructions.loadw(){

            public final int call() {
                return Modrm.Getrw[r].word();
            }
        };
        rw_s = new Instructions.savew(){

            public final void call(int value) {
                Modrm.Getrw[r].word(value);
            }
        };
        earb_l = new Instructions.loadb(){

            public final short call() {
                return Modrm.GetEArb[r].get();
            }
        };
        earb_s = new Instructions.saveb(){

            public final void call(short value) {
                Modrm.GetEArb[r].set(value);
            }
        };
        earw_l = new Instructions.loadw(){

            public final int call() {
                return Modrm.GetEArw[r].word();
            }
        };
        earw_s = new Instructions.savew(){

            public final void call(int value) {
                Modrm.GetEArw[r].word(value);
            }
        };
        b_l = new Instructions.loadb(){

            public final short call() {
                return Memory.mem_readb(m);
            }
        };
        b_s = new Instructions.saveb(){

            public final void call(short value) {
                Memory.mem_writeb(m, value);
            }
        };
        w_l = new Instructions.loadw(){

            public final int call() {
                return Memory.mem_readw(m);
            }
        };
        w_s = new Instructions.savew(){

            public final void call(int value) {
                Memory.mem_writew(m, value);
            }
        };
    }

    public static class ContinueException
    extends RuntimeException {
    }

    public static interface OP {
        public int call();
    }
}

