/*
 * Decompiled with CFR 0.152.
 */
package jdos.debug;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.fpu.FPU;
import jdos.misc.setup.Section;

public class Debug {
    public static final int INSTRUCTION = 1;
    public static final int FETCHB = 2;
    public static final int FETCHW = 3;
    public static final int FETCHD = 4;
    public static final int EAX = 5;
    public static final int EBX = 6;
    public static final int ECX = 7;
    public static final int EDX = 8;
    public static final int EDI = 9;
    public static final int EIP = 10;
    public static final int ESP = 11;
    public static final int EBP = 12;
    public static final int ESI = 13;
    public static final int FLAGS = 14;
    public static final int FPU_REG0 = 15;
    public static final int FPU_REG1 = 16;
    public static final int FPU_REG2 = 17;
    public static final int FPU_REG3 = 18;
    public static final int FPU_REG4 = 19;
    public static final int FPU_REG5 = 20;
    public static final int FPU_REG6 = 21;
    public static final int FPU_REG7 = 22;
    public static final int FPU_REG8 = 23;
    public static final int FPU_CW = 24;
    public static final int FPU_CW_MASK = 25;
    public static final int FPU_SW = 26;
    public static final int FPU_TOP = 27;
    public static final int FPU_ROUND = 28;
    public static final int ES = 29;
    public static final int CS = 30;
    public static final int SS = 31;
    public static final int DS = 32;
    public static final int FS = 33;
    public static final int GS = 34;
    public static final int READB = 35;
    public static final int READW = 36;
    public static final int READD = 37;
    public static final int WRITEB = 38;
    public static final int WRITEW = 39;
    public static final int WRITED = 40;
    public static final int PROG = 41;
    public static final int CALLBACK = 42;
    public static final int CSEIP1 = 43;
    public static final int CSEIP2 = 44;
    public static final int CSEIP3 = 45;
    public static final int CSEIP4 = 46;
    public static final int DONE = 47;
    public static final int INSTRUCTION_DONE = 48;
    static long[] last = new long[50];
    static DataOutputStream log = null;
    public static boolean logging = true;
    public static final int TYPE_CPU = 1;
    public static final int TYPE_INT10 = 2;
    private static int lastType;
    public static final int MASK = 1;
    public static int cycle_count;
    public static int debugCallback;
    public static Section.SectionFunction DEBUG_Init;

    public static void start(int type, int c) {
        lastType = type;
        if ((type & 1) != 0) {
            Debug.log(1, c);
            Debug.log(5, CPU_Regs.reg_eax.dword);
            Debug.log(6, CPU_Regs.reg_ebx.dword);
            Debug.log(7, CPU_Regs.reg_ecx.dword);
            Debug.log(8, CPU_Regs.reg_edx.dword);
            Debug.log(9, CPU_Regs.reg_edi.dword);
            Debug.log(10, CPU_Regs.reg_eip);
            Debug.log(11, CPU_Regs.reg_esp.dword);
            Debug.log(12, CPU_Regs.reg_ebp.dword);
            Debug.log(13, CPU_Regs.reg_esi.dword);
            Debug.log(14, CPU_Regs.flags);
            Debug.log(29, CPU.Segs_ESphys);
            Debug.log(30, CPU.Segs_CSphys);
            Debug.log(31, CPU.Segs_SSphys);
            Debug.log(32, CPU.Segs_DSphys);
            Debug.log(33, CPU.Segs_FSphys);
            Debug.log(34, CPU.Segs_GSphys);
            FPU.log();
        }
    }

    public static void stop(int type, int c) {
        lastType = type;
        if ((type & 1) != 0) {
            Debug.log(48, c);
            Debug.log(5, CPU_Regs.reg_eax.dword);
            Debug.log(6, CPU_Regs.reg_ebx.dword);
            Debug.log(7, CPU_Regs.reg_ecx.dword);
            Debug.log(8, CPU_Regs.reg_edx.dword);
            Debug.log(9, CPU_Regs.reg_edi.dword);
            Debug.log(10, CPU_Regs.reg_eip);
            Debug.log(11, CPU_Regs.reg_esp.dword);
            Debug.log(12, CPU_Regs.reg_ebp.dword);
            Debug.log(13, CPU_Regs.reg_esi.dword);
            Debug.log(14, CPU_Regs.flags);
            Debug.log(29, CPU.Segs_ESphys);
            Debug.log(30, CPU.Segs_CSphys);
            Debug.log(31, CPU.Segs_SSphys);
            Debug.log(32, CPU.Segs_DSphys);
            Debug.log(33, CPU.Segs_FSphys);
            Debug.log(34, CPU.Segs_GSphys);
            FPU.log();
            Debug.log(47, c);
        }
    }

    public static void close() {
        if (log != null) {
            try {
                log.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log(int type, String value) {
        if (logging) {
            try {
                byte[] b = value.getBytes();
                log.writeByte(type);
                log.writeInt(b.length);
                log.write(b);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log(int type, long value) {
        if (logging && (lastType & 1) != 0) {
            try {
                if (type > 34 || last[type] != value) {
                    log.writeByte(type);
                    log.writeInt((int)value);
                    Debug.last[type] = value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log_long(int type, long value) {
        if (logging && (lastType & 1) != 0) {
            try {
                if (type > 34 || last[type] != value) {
                    log.writeByte(type);
                    log.writeLong(value);
                    Debug.last[type] = value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log(int type, long value, long value1) {
        if (logging && (lastType & 1) != 0) {
            try {
                log.writeByte(type);
                log.writeInt((int)value);
                log.writeInt((int)value1);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void DEBUG_HeavyWriteLogInstruction() {
    }

    public static boolean DEBUG_IntBreakpoint(short intNum) {
        return false;
    }

    public static boolean DEBUG_HeavyIsBreakpoint() {
        return false;
    }

    public static boolean DEBUG_Breakpoint() {
        return false;
    }

    public static boolean DEBUG_ExitLoop() {
        return false;
    }

    static {
        try {
            log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("debug.log")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEBUG_Init = new Section.SectionFunction(){

            public void call(Section section) {
            }
        };
    }
}

