/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.CDROM_Interface_Fake;
import jdos.dos.CDROM_Interface_Image;
import jdos.dos.DOS_Device;
import jdos.dos.Dos;
import jdos.dos.Dos_cdrom;
import jdos.dos.Dos_devices;
import jdos.dos.Dos_misc;
import jdos.dos.Dos_system;
import jdos.dos.Dos_tables;
import jdos.dos.MemStruct;
import jdos.hardware.Memory;
import jdos.ints.Bios_disk;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.util.BooleanRef;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringRef;

public class DosMSCDEX {
    private static final int MSCDEX_VERSION_HIGH = 2;
    private static final int MSCDEX_VERSION_LOW = 23;
    private static final int MSCDEX_MAX_DRIVES = 8;
    private static final int MSCDEX_ERROR_INVALID_FUNCTION = 1;
    private static final int MSCDEX_ERROR_BAD_FORMAT = 11;
    private static final int MSCDEX_ERROR_UNKNOWN_DRIVE = 15;
    private static final int MSCDEX_ERROR_DRIVE_NOT_READY = 21;
    private static final int REQUEST_STATUS_DONE = 256;
    private static final int REQUEST_STATUS_ERROR = 32768;
    private static int forceCD = -1;
    private static CMscdex mscdex = null;
    private static int curReqheaderPtr = 0;
    private static Callback.Handler MSCDEX_Strategy_Handler = new Callback.Handler(){

        public String getName() {
            return "MSCDEX_Strategy_Handler";
        }

        public int call() {
            curReqheaderPtr = Memory.PhysMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word());
            return 0;
        }
    };
    private static Callback.Handler MSCDEX_Interrupt_Handler = new Callback.Handler(){

        public String getName() {
            return "MSCDEX_Interrupt_Handler";
        }

        public int call() {
            if (curReqheaderPtr == 0) {
                Log.log(21, 2, "MSCDEX: invalid call to interrupt handler");
                return 0;
            }
            short subUnit = Memory.mem_readb(curReqheaderPtr + 1);
            short funcNr = Memory.mem_readb(curReqheaderPtr + 2);
            int errcode = 0;
            int buffer = 0;
            Log.log(21, 2, "MSCDEX: Driver Function " + Integer.toString(funcNr, 16));
            if (funcNr == 3 || funcNr == 12 || funcNr == 128 || funcNr == 130) {
                buffer = Memory.PhysMake(Memory.mem_readw(curReqheaderPtr + 16), Memory.mem_readw(curReqheaderPtr + 14));
            }
            switch (funcNr) {
                case 3: {
                    int error = DosMSCDEX.MSCDEX_IOCTL_Input(buffer, subUnit);
                    if (error == 0) break;
                    errcode = error;
                    break;
                }
                case 12: {
                    int error = DosMSCDEX.MSCDEX_IOCTL_Optput(buffer, subUnit);
                    if (error == 0) break;
                    errcode = error;
                    break;
                }
                case 13: 
                case 14: {
                    break;
                }
                case 128: 
                case 130: {
                    boolean raw;
                    long start = (long)Memory.mem_readd(curReqheaderPtr + 20) & 0xFFFFFFFFL;
                    int len = Memory.mem_readw(curReqheaderPtr + 18);
                    boolean bl = raw = Memory.mem_readb(curReqheaderPtr + 24) == 1;
                    if (Memory.mem_readb(curReqheaderPtr + 13) == 0) {
                        mscdex.ReadSectors(subUnit, raw, start, len, buffer);
                        break;
                    }
                    mscdex.ReadSectorsMSF(subUnit, raw, start, len, buffer);
                    break;
                }
                case 131: {
                    break;
                }
                case 132: {
                    long start = (long)Memory.mem_readd(curReqheaderPtr + 14) & 0xFFFFFFFFL;
                    long len = (long)Memory.mem_readd(curReqheaderPtr + 18) & 0xFFFFFFFFL;
                    if (Memory.mem_readb(curReqheaderPtr + 13) == 0) {
                        mscdex.PlayAudioSector(subUnit, start, len);
                        break;
                    }
                    mscdex.PlayAudioMSF(subUnit, start, len);
                    break;
                }
                case 133: {
                    mscdex.StopAudio(subUnit);
                    break;
                }
                case 136: {
                    mscdex.ResumeAudio(subUnit);
                    break;
                }
                default: {
                    Log.log(21, 2, "MSCDEX: Unsupported Driver Request " + Integer.toString(funcNr, 16));
                }
            }
            Memory.mem_writew(curReqheaderPtr + 3, mscdex.GetStatusWord(subUnit, errcode));
            Log.log(21, 2, "MSCDEX: Status : " + Integer.toString(Memory.mem_readw(curReqheaderPtr + 3), 16));
            return 0;
        }
    };
    private static Dos_system.MultiplexHandler MSCDEX_Handler = new Dos_system.MultiplexHandler(){

        public boolean call() {
            if (CPU_Regs.reg_eax.high() == 17) {
                if (CPU_Regs.reg_eax.low() == 0) {
                    int check = Memory.PhysMake(CPU.Segs_SSval, CPU_Regs.reg_esp.word());
                    if (Memory.mem_readw(check + 6) == 56026) {
                        Memory.mem_writew(check + 6, 44461);
                    }
                    CPU_Regs.reg_eax.low(255);
                    return true;
                }
                Log.log(21, 2, "NETWORK REDIRECTOR USED!!!");
                CPU_Regs.reg_eax.word(73);
                Callback.CALLBACK_SCF(true);
                return true;
            }
            if (CPU_Regs.reg_eax.high() != 21) {
                return false;
            }
            int data = Memory.PhysMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word());
            Log.log(21, 2, "MSCDEX: INT 2F " + Integer.toString(CPU_Regs.reg_eax.word(), 16) + " BX= " + Integer.toString(CPU_Regs.reg_ebx.word(), 16) + " CX=" + Integer.toString(CPU_Regs.reg_ecx.word(), 16));
            switch (CPU_Regs.reg_eax.word()) {
                case 5376: {
                    CPU_Regs.reg_ebx.word(mscdex.GetNumDrives());
                    if (CPU_Regs.reg_ebx.word() > 0) {
                        CPU_Regs.reg_ecx.word(mscdex.GetFirstDrive());
                    }
                    CPU_Regs.reg_eax.low(255);
                    return true;
                }
                case 5377: {
                    mscdex.GetDriverInfo(data);
                    return true;
                }
                case 5378: {
                    if (mscdex.GetCopyrightName(CPU_Regs.reg_ecx.word(), data)) {
                        Callback.CALLBACK_SCF(false);
                    } else {
                        CPU_Regs.reg_eax.word(15);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
                case 5379: {
                    if (mscdex.GetAbstractName(CPU_Regs.reg_ecx.word(), data)) {
                        Callback.CALLBACK_SCF(false);
                    } else {
                        CPU_Regs.reg_eax.word(15);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
                case 5380: {
                    if (mscdex.GetDocumentationName(CPU_Regs.reg_ecx.word(), data)) {
                        Callback.CALLBACK_SCF(false);
                    } else {
                        CPU_Regs.reg_eax.word(15);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
                case 5381: {
                    IntRef error = new IntRef(0);
                    if (mscdex.ReadVTOC(CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word(), data, error)) {
                        Callback.CALLBACK_SCF(false);
                    } else {
                        CPU_Regs.reg_eax.word(error.value);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
                case 5384: {
                    long sector = (CPU_Regs.reg_esi.word() << 16) + CPU_Regs.reg_edi.word();
                    if (mscdex.ReadSectors(CPU_Regs.reg_ecx.word(), sector, CPU_Regs.reg_edx.word(), data)) {
                        CPU_Regs.reg_eax.word(0);
                        Callback.CALLBACK_SCF(false);
                    } else {
                        CPU_Regs.reg_eax.word(15);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
                case 5385: {
                    CPU_Regs.reg_eax.word(1);
                    Callback.CALLBACK_SCF(true);
                    return true;
                }
                case 5387: {
                    CPU_Regs.reg_eax.word(mscdex.IsValidDrive(CPU_Regs.reg_ecx.word()) ? 23256 : 0);
                    CPU_Regs.reg_ebx.word(44461);
                    return true;
                }
                case 5388: {
                    CPU_Regs.reg_ebx.word(mscdex.GetVersion());
                    return true;
                }
                case 5389: {
                    mscdex.GetDrives(data);
                    return true;
                }
                case 5390: {
                    if (mscdex.IsValidDrive(CPU_Regs.reg_ecx.word())) {
                        if (CPU_Regs.reg_ebx.word() == 0) {
                            CPU_Regs.reg_edx.word(256);
                            Callback.CALLBACK_SCF(false);
                        } else if (CPU_Regs.reg_ebx.word() == 1) {
                            if (CPU_Regs.reg_edx.high() == 1) {
                                Callback.CALLBACK_SCF(false);
                            } else {
                                CPU_Regs.reg_eax.word(1);
                                Callback.CALLBACK_SCF(true);
                            }
                        } else {
                            CPU_Regs.reg_eax.word(1);
                            Callback.CALLBACK_SCF(true);
                        }
                    } else {
                        CPU_Regs.reg_eax.word(15);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
                case 5391: {
                    IntRef error = new IntRef(0);
                    boolean success = mscdex.GetDirectoryEntry(CPU_Regs.reg_ecx.low(), (CPU_Regs.reg_ecx.high() & 1) != 0, data, Memory.PhysMake(CPU_Regs.reg_esi.word(), CPU_Regs.reg_edi.word()), error);
                    CPU_Regs.reg_eax.word(error.value);
                    Callback.CALLBACK_SCF(!success);
                    return true;
                }
                case 5392: {
                    if (mscdex.SendDriverRequest(CPU_Regs.reg_ecx.word(), data)) {
                        Callback.CALLBACK_SCF(false);
                    } else {
                        CPU_Regs.reg_eax.word(15);
                        Callback.CALLBACK_SCF(true);
                    }
                    return true;
                }
            }
            Log.log(21, 2, "MSCDEX: Unknwon call : " + Integer.toString(CPU_Regs.reg_eax.word(), 16));
            return true;
        }
    };
    private static Dos_cdrom.TMSF[] leadOut = new Dos_cdrom.TMSF[8];
    public static Section.SectionFunction MSCDEX_ShutDown;
    public static Section.SectionFunction MSCDEX_Init;

    private static int MSCDEX_IOCTL_Input(int buffer, short drive_unit) {
        short ioctl_fct = Memory.mem_readb(buffer);
        Log.log(21, 2, "MSCDEX: IOCTL INPUT Subfunction " + Integer.toString(ioctl_fct, 16));
        switch (ioctl_fct) {
            case 0: {
                Memory.mem_writed(buffer + 1, Memory.RealMake(DosMSCDEX.mscdex.rootDriverHeaderSeg, 0));
                break;
            }
            case 1: {
                Dos_cdrom.TMSF pos = new Dos_cdrom.TMSF();
                mscdex.GetCurrentPos(drive_unit, pos);
                short addr_mode = Memory.mem_readb(buffer + 1);
                if (addr_mode == 0) {
                    long frames = pos.min * 60 * 75 + pos.sec * 75 + pos.fr;
                    if (frames < 150L) {
                        Log.log(21, 2, "MSCDEX: Get position: invalid position " + pos.min + ":" + pos.sec + ":" + pos.fr);
                    }
                    Memory.mem_writed(buffer + 2, (int)frames);
                    break;
                }
                if (addr_mode == 1) {
                    Memory.mem_writeb(buffer + 2, pos.fr);
                    Memory.mem_writeb(buffer + 3, pos.sec);
                    Memory.mem_writeb(buffer + 4, pos.min);
                    Memory.mem_writeb(buffer + 5, 0);
                    break;
                }
                Log.log(21, 2, "MSCDEX: Get position: invalid address mode " + Integer.toString(addr_mode, 16));
                return 3;
            }
            case 4: {
                Dos_cdrom.TCtrl ctrl = new Dos_cdrom.TCtrl();
                if (!mscdex.GetChannelControl(drive_unit, ctrl)) {
                    return 1;
                }
                for (int chan = 0; chan < 4; ++chan) {
                    Memory.mem_writeb(buffer + chan * 2 + 1, ctrl.out[chan]);
                    Memory.mem_writeb(buffer + chan * 2 + 2, ctrl.vol[chan]);
                }
                break;
            }
            case 6: {
                Memory.mem_writed(buffer + 1, (int)mscdex.GetDeviceStatus(drive_unit));
                break;
            }
            case 7: {
                if (Memory.mem_readb(buffer + 1) == 0) {
                    Memory.mem_writed(buffer + 2, 2048);
                    break;
                }
                if (Memory.mem_readb(buffer + 1) == 1) {
                    Memory.mem_writed(buffer + 2, 2352);
                    break;
                }
                return 3;
            }
            case 8: {
                Memory.mem_writed(buffer + 1, (int)mscdex.GetVolumeSize(drive_unit));
                break;
            }
            case 9: {
                ShortRef status = new ShortRef();
                if (!mscdex.GetMediaStatus(drive_unit, status)) {
                    status.value = 0;
                }
                Memory.mem_writeb(buffer + 1, status.value);
                break;
            }
            case 10: {
                ShortRef tr1 = new ShortRef();
                ShortRef tr2 = new ShortRef();
                Dos_cdrom.TMSF leadOut = new Dos_cdrom.TMSF();
                if (!mscdex.GetCDInfo(drive_unit, tr1, tr2, leadOut)) {
                    return 5;
                }
                Memory.mem_writeb(buffer + 1, tr1.value);
                Memory.mem_writeb(buffer + 2, tr2.value);
                Memory.mem_writeb(buffer + 3, leadOut.fr);
                Memory.mem_writeb(buffer + 4, leadOut.sec);
                Memory.mem_writeb(buffer + 5, leadOut.min);
                Memory.mem_writeb(buffer + 6, 0);
                break;
            }
            case 11: {
                ShortRef attr = new ShortRef();
                Dos_cdrom.TMSF start = new Dos_cdrom.TMSF();
                short track2 = Memory.mem_readb(buffer + 1);
                mscdex.GetTrackInfo(drive_unit, track2, attr, start);
                Memory.mem_writeb(buffer + 2, start.fr);
                Memory.mem_writeb(buffer + 3, start.sec);
                Memory.mem_writeb(buffer + 4, start.min);
                Memory.mem_writeb(buffer + 5, 0);
                Memory.mem_writeb(buffer + 6, attr.value);
                break;
            }
            case 12: {
                ShortRef attr = new ShortRef();
                ShortRef track3 = new ShortRef();
                ShortRef index = new ShortRef();
                Dos_cdrom.TMSF abs = new Dos_cdrom.TMSF();
                Dos_cdrom.TMSF rel = new Dos_cdrom.TMSF();
                mscdex.GetSubChannelData(drive_unit, attr, track3, index, rel, abs);
                Memory.mem_writeb(buffer + 1, attr.value);
                Memory.mem_writeb(buffer + 2, track3.value);
                Memory.mem_writeb(buffer + 3, index.value);
                Memory.mem_writeb(buffer + 4, rel.min);
                Memory.mem_writeb(buffer + 5, rel.sec);
                Memory.mem_writeb(buffer + 6, rel.fr);
                Memory.mem_writeb(buffer + 7, 0);
                Memory.mem_writeb(buffer + 8, abs.min);
                Memory.mem_writeb(buffer + 9, abs.sec);
                Memory.mem_writeb(buffer + 10, abs.fr);
                break;
            }
            case 14: {
                ShortRef attr = new ShortRef();
                StringRef upc = new StringRef();
                mscdex.GetUPC(drive_unit, attr, upc);
                Memory.mem_writeb(buffer + 1, attr.value);
                for (int i = 0; i < 7; ++i) {
                    Memory.mem_writeb(buffer + 2 + i, upc.value.charAt(i));
                }
                Memory.mem_writeb(buffer + 9, 0);
                break;
            }
            case 15: {
                BooleanRef playing = new BooleanRef();
                BooleanRef pause = new BooleanRef();
                Dos_cdrom.TMSF resStart = new Dos_cdrom.TMSF();
                Dos_cdrom.TMSF resEnd = new Dos_cdrom.TMSF();
                mscdex.GetAudioStatus(drive_unit, playing, pause, resStart, resEnd);
                Memory.mem_writeb(buffer + 1, pause.value ? 1 : 0);
                Memory.mem_writeb(buffer + 3, resStart.min);
                Memory.mem_writeb(buffer + 4, resStart.sec);
                Memory.mem_writeb(buffer + 5, resStart.fr);
                Memory.mem_writeb(buffer + 6, 0);
                Memory.mem_writeb(buffer + 7, resEnd.min);
                Memory.mem_writeb(buffer + 8, resEnd.sec);
                Memory.mem_writeb(buffer + 9, resEnd.fr);
                Memory.mem_writeb(buffer + 10, 0);
                break;
            }
            default: {
                Log.log(21, 2, "MSCDEX: Unsupported IOCTL INPUT Subfunction " + Integer.toString(ioctl_fct, 16));
                return 3;
            }
        }
        return 0;
    }

    private static int MSCDEX_IOCTL_Optput(int buffer, short drive_unit) {
        short ioctl_fct = Memory.mem_readb(buffer);
        switch (ioctl_fct) {
            case 0: {
                if (mscdex.LoadUnloadMedia(drive_unit, true)) break;
                return 2;
            }
            case 3: {
                Dos_cdrom.TCtrl ctrl = new Dos_cdrom.TCtrl();
                for (int chan = 0; chan < 4; ++chan) {
                    ctrl.out[chan] = Memory.mem_readb(buffer + chan * 2 + 1);
                    ctrl.vol[chan] = Memory.mem_readb(buffer + chan * 2 + 2);
                }
                if (mscdex.ChannelControl(drive_unit, ctrl)) break;
                return 1;
            }
            case 1: {
                break;
            }
            case 2: {
                Log.log(21, 1, "cdromDrive reset");
                if (mscdex.StopAudio(drive_unit)) break;
                return 2;
            }
            case 5: {
                if (!mscdex.LoadUnloadMedia(drive_unit, false)) {
                    return 2;
                }
            }
            default: {
                Log.log(21, 2, "MSCDEX: Unsupported IOCTL OUTPUT Subfunction " + Integer.toString(ioctl_fct, 16));
                return 3;
            }
        }
        return 0;
    }

    public static int MSCDEX_AddDrive(char driveLetter, String physicalPath, ShortRef subUnit) {
        return mscdex.AddDrive(driveLetter - 65, physicalPath, subUnit);
    }

    public static int MSCDEX_RemoveDrive(char driveLetter) {
        if (mscdex == null) {
            return 0;
        }
        return mscdex.RemoveDrive(driveLetter - 65);
    }

    public static boolean MSCDEX_HasDrive(char driveLetter) {
        return mscdex.HasDrive(driveLetter - 65);
    }

    public static void MSCDEX_ReplaceDrive(Dos_cdrom.CDROM_Interface cdrom, short subUnit) {
        mscdex.ReplaceDrive(cdrom, subUnit);
    }

    public static boolean MSCDEX_GetVolumeName(short subUnit, StringRef name) {
        return mscdex.GetVolumeName(subUnit, name);
    }

    public static boolean MSCDEX_HasMediaChanged(short subUnit) {
        ShortRef tr1 = new ShortRef();
        ShortRef tr2 = new ShortRef();
        Dos_cdrom.TMSF leadnew = new Dos_cdrom.TMSF();
        if (mscdex.GetCDInfo(subUnit, tr1, tr2, leadnew)) {
            boolean changed;
            boolean bl = changed = DosMSCDEX.leadOut[subUnit].min != leadnew.min || DosMSCDEX.leadOut[subUnit].sec != leadnew.sec || DosMSCDEX.leadOut[subUnit].fr != leadnew.fr;
            if (changed) {
                DosMSCDEX.leadOut[subUnit].min = leadnew.min;
                DosMSCDEX.leadOut[subUnit].sec = leadnew.sec;
                DosMSCDEX.leadOut[subUnit].fr = leadnew.fr;
                mscdex.InitNewMedia(subUnit);
            }
            return changed;
        }
        if (subUnit < 8) {
            DosMSCDEX.leadOut[subUnit].min = 0;
            DosMSCDEX.leadOut[subUnit].sec = 0;
            DosMSCDEX.leadOut[subUnit].fr = 0;
        }
        return true;
    }

    public static void MSCDEX_SetCDInterface(int intNr, int numCD) {
        forceCD = numCD;
    }

    static {
        for (int i = 0; i < leadOut.length; ++i) {
            DosMSCDEX.leadOut[i] = new Dos_cdrom.TMSF();
        }
        MSCDEX_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                mscdex = null;
                curReqheaderPtr = 0;
            }
        };
        MSCDEX_Init = new Section.SectionFunction(){

            public void call(Section section) {
                section.AddDestroyFunction(MSCDEX_ShutDown);
                device_MSCDEX newdev = new device_MSCDEX();
                Dos_devices.DOS_AddDevice(newdev);
                curReqheaderPtr = 0;
                Dos_misc.DOS_AddMultiplexHandler(MSCDEX_Handler);
                mscdex = new CMscdex();
            }
        };
    }

    private static class device_MSCDEX
    extends DOS_Device {
        device_MSCDEX() {
            this.SetName("MSCD001");
        }

        public boolean Read(byte[] data, IntRef size) {
            return false;
        }

        public boolean Write(byte[] data, IntRef size) {
            Log.log(0, 0, "Write to mscdex device");
            return false;
        }

        public boolean Seek(LongRef pos, int type) {
            return false;
        }

        public boolean Close() {
            return false;
        }

        public int GetInformation() {
            return 51328;
        }

        public boolean ReadFromControlChannel(int bufptr, int size, IntRef retcode) {
            if (DosMSCDEX.MSCDEX_IOCTL_Input(bufptr, (short)0) == 0) {
                retcode.value = size;
                return true;
            }
            return false;
        }

        public boolean WriteToControlChannel(int bufptr, int size, IntRef retcode) {
            if (DosMSCDEX.MSCDEX_IOCTL_Optput(bufptr, (short)0) == 0) {
                retcode.value = size;
                return true;
            }
            return false;
        }
    }

    private static class CMscdex {
        int numDrives = 0;
        int defaultBufSeg = 0;
        TDriveInfo[] dinfo = new TDriveInfo[8];
        Dos_cdrom.CDROM_Interface[] cdrom = new Dos_cdrom.CDROM_Interface[8];
        int rootDriverHeaderSeg = 0;

        int GetVersion() {
            return 535;
        }

        int GetNumDrives() {
            return this.numDrives;
        }

        int GetFirstDrive() {
            return this.dinfo[0].drive;
        }

        CMscdex() {
            for (int i = 0; i < 8; ++i) {
                this.dinfo[i] = new TDriveInfo();
            }
        }

        void GetDrives(int data) {
            for (int i = 0; i < this.GetNumDrives(); ++i) {
                Memory.mem_writeb(data + i, this.dinfo[i].drive);
            }
        }

        boolean IsValidDrive(int _drive) {
            _drive &= 0xFF;
            for (int i = 0; i < this.GetNumDrives(); ++i) {
                if (this.dinfo[i].drive != _drive) continue;
                return true;
            }
            return false;
        }

        short GetSubUnit(int _drive) {
            _drive &= 0xFF;
            for (int i = 0; i < this.GetNumDrives(); ++i) {
                if (this.dinfo[i].drive != _drive) continue;
                return (short)i;
            }
            return 255;
        }

        int RemoveDrive(int _drive) {
            int i;
            int idx = 8;
            for (i = 0; i < this.GetNumDrives(); ++i) {
                if (this.dinfo[i].drive != _drive) continue;
                idx = i;
                break;
            }
            if (idx == 8 || idx != 0 && idx != this.GetNumDrives() - 1) {
                return 0;
            }
            this.cdrom[idx].close();
            if (idx == 0) {
                for (i = 0; i < this.GetNumDrives(); ++i) {
                    if (i == 7) {
                        this.cdrom[i] = null;
                        this.dinfo[i] = new TDriveInfo();
                        continue;
                    }
                    this.dinfo[i] = this.dinfo[i + 1];
                    this.cdrom[i] = this.cdrom[i + 1];
                }
            } else {
                this.cdrom[idx] = null;
                this.dinfo[idx] = new TDriveInfo();
            }
            --this.numDrives;
            if (this.GetNumDrives() == 0) {
                DOS_DeviceHeader devHeader = new DOS_DeviceHeader(Memory.PhysMake(this.rootDriverHeaderSeg, 0));
                int off = 22;
                devHeader.SetStrategy(off + 4);
                devHeader.SetInterrupt(off + 4);
                devHeader.SetDriveLetter(0);
            } else if (idx == 0) {
                DOS_DeviceHeader devHeader = new DOS_DeviceHeader(Memory.PhysMake(this.rootDriverHeaderSeg, 0));
                devHeader.SetDriveLetter(this.GetFirstDrive() + 1);
            }
            return 1;
        }

        int AddDrive(int _drive, String physicalPath, ShortRef subUnit) {
            subUnit.value = 0;
            if (this.GetNumDrives() + 1 >= 8) {
                return 4;
            }
            if (this.GetNumDrives() != 0 && this.dinfo[0].drive - 1 != _drive && this.dinfo[this.numDrives - 1].drive + 1 != _drive) {
                return 1;
            }
            int result = 0;
            switch (Dos_cdrom.CDROM_GetMountType(physicalPath, forceCD)) {
                case 0: {
                    Log.log(21, 2, "MSCDEX: Mounting physical cdrom not supported: " + physicalPath);
                    break;
                }
                case 1: {
                    this.cdrom[this.numDrives] = new CDROM_Interface_Image((short)this.numDrives);
                    break;
                }
                case 2: {
                    this.cdrom[this.numDrives] = new CDROM_Interface_Fake();
                    result = 5;
                    break;
                }
                default: {
                    return 6;
                }
            }
            if (!this.cdrom[this.numDrives].SetDevice(physicalPath, forceCD)) {
                return 3;
            }
            if (this.rootDriverHeaderSeg == 0) {
                int driverSize = 32;
                int seg = Dos_tables.DOS_GetMemory((driverSize + 15) / 16);
                DOS_DeviceHeader devHeader = new DOS_DeviceHeader(Memory.PhysMake(seg, 0));
                devHeader.SetNextDeviceHeader(-1);
                devHeader.SetAttribute(51200);
                devHeader.SetDriveLetter(_drive + 1);
                devHeader.SetNumSubUnits((short)1);
                devHeader.SetName("MSCD001 ");
                long start = (long)Dos.dos_infoblock.GetDeviceChain() & 0xFFFFFFFFL;
                int segm = (int)(start >> 16);
                int offm = (int)(start & 0xFFFFL);
                while (start != 0xFFFFFFFFL) {
                    segm = (int)(start >>> 16);
                    offm = (int)(start & 0xFFFFL);
                    start = (long)Memory.real_readd(segm, offm) & 0xFFFFFFFFL;
                }
                Memory.real_writed(segm, offm, seg << 16);
                int off = 22;
                int call_strategy = Callback.CALLBACK_Allocate();
                Callback.CallBack_Handlers[call_strategy] = MSCDEX_Strategy_Handler;
                Memory.real_writeb(seg, off + 0, 254);
                Memory.real_writeb(seg, off + 1, 56);
                Memory.real_writew(seg, off + 2, call_strategy);
                Memory.real_writeb(seg, off + 4, 203);
                devHeader.SetStrategy(off);
                int call_interrupt = Callback.CALLBACK_Allocate();
                Callback.CallBack_Handlers[call_interrupt] = MSCDEX_Interrupt_Handler;
                Memory.real_writeb(seg, (off += 5) + 0, 254);
                Memory.real_writeb(seg, off + 1, 56);
                Memory.real_writew(seg, off + 2, call_interrupt);
                Memory.real_writeb(seg, off + 4, 203);
                devHeader.SetInterrupt(off);
                this.rootDriverHeaderSeg = seg;
            } else if (this.GetNumDrives() == 0) {
                DOS_DeviceHeader devHeader = new DOS_DeviceHeader(Memory.PhysMake(this.rootDriverHeaderSeg, 0));
                int off = 22;
                devHeader.SetDriveLetter(_drive + 1);
                devHeader.SetStrategy(off);
                devHeader.SetInterrupt(off + 5);
            }
            DOS_DeviceHeader devHeader = new DOS_DeviceHeader(Memory.PhysMake(this.rootDriverHeaderSeg, 0));
            devHeader.SetNumSubUnits((short)(devHeader.GetNumSubUnits() + 1));
            if (this.dinfo[0].drive - 1 == _drive) {
                Dos_cdrom.CDROM_Interface _cdrom = this.cdrom[this.numDrives];
                CDROM_Interface_Image _cdimg = CDROM_Interface_Image.images[this.numDrives];
                for (int i = this.GetNumDrives(); i > 0; --i) {
                    this.dinfo[i] = this.dinfo[i - 1];
                    this.cdrom[i] = this.cdrom[i - 1];
                    CDROM_Interface_Image.images[i] = CDROM_Interface_Image.images[i - 1];
                }
                this.cdrom[0] = _cdrom;
                CDROM_Interface_Image.images[0] = _cdimg;
                this.dinfo[0].drive = (short)_drive;
                this.dinfo[0].physDrive = (short)physicalPath.toUpperCase().charAt(0);
                subUnit.value = 0;
            } else {
                this.dinfo[this.numDrives].drive = (short)_drive;
                this.dinfo[this.numDrives].physDrive = (short)physicalPath.toUpperCase().charAt(0);
                subUnit.value = (short)this.numDrives;
            }
            ++this.numDrives;
            for (int chan = 0; chan < 4; ++chan) {
                this.dinfo[subUnit.value].audioCtrl.out[chan] = chan;
                this.dinfo[subUnit.value].audioCtrl.vol[chan] = 255;
            }
            this.StopAudio(subUnit.value);
            return result;
        }

        boolean HasDrive(int drive) {
            return this.GetSubUnit(drive) != 255;
        }

        void ReplaceDrive(Dos_cdrom.CDROM_Interface newCdrom, short subUnit) {
            this.cdrom[subUnit].close();
            this.cdrom[subUnit] = newCdrom;
            this.StopAudio(subUnit);
        }

        int GetDefaultBuffer() {
            if (this.defaultBufSeg == 0) {
                int size = 294;
                this.defaultBufSeg = Dos_tables.DOS_GetMemory(size);
            }
            return Memory.PhysMake(this.defaultBufSeg, 2352);
        }

        int GetTempBuffer() {
            if (this.defaultBufSeg == 0) {
                int size = 294;
                this.defaultBufSeg = Dos_tables.DOS_GetMemory(size);
            }
            return Memory.PhysMake(this.defaultBufSeg, 0);
        }

        void GetDriverInfo(int data) {
            for (int i = 0; i < this.GetNumDrives(); ++i) {
                Memory.mem_writeb(data, (short)i);
                Memory.mem_writed(data + 1, Memory.RealMake(this.rootDriverHeaderSeg, 0));
                data += 5;
            }
        }

        boolean GetCDInfo(short subUnit, ShortRef tr1, ShortRef tr2, Dos_cdrom.TMSF leadOut) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            IntRef tr1i = new IntRef(0);
            IntRef tr2i = new IntRef(0);
            this.cdrom[subUnit].InitNewMedia();
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].GetAudioTracks(tr1i, tr2i, leadOut);
            if (!this.dinfo[subUnit].lastResult) {
                tr2.value = 0;
                tr1.value = 0;
                leadOut.clear();
            } else {
                tr1.value = (short)tr1i.value;
                tr2.value = (short)tr2i.value;
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean GetTrackInfo(short subUnit, short track2, ShortRef attr, Dos_cdrom.TMSF start) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].GetAudioTrackInfo(track2, start, attr);
            if (!this.dinfo[subUnit].lastResult) {
                attr.value = 0;
                start.clear();
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean PlayAudioSector(short subUnit, long sector, long length) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.dinfo[subUnit].audioPaused && sector == this.dinfo[subUnit].audioStart && this.dinfo[subUnit].audioEnd != 0L ? this.cdrom[subUnit].PauseAudio(true) : this.cdrom[subUnit].PlayAudioSector(sector, length);
            if (this.dinfo[subUnit].lastResult) {
                this.dinfo[subUnit].audioPlay = true;
                this.dinfo[subUnit].audioPaused = false;
                this.dinfo[subUnit].audioStart = sector;
                this.dinfo[subUnit].audioEnd = length;
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean PlayAudioMSF(short subUnit, long start, long length) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            short min = (short)(start >> 16 & 0xFFL);
            short sec = (short)(start >> 8 & 0xFFL);
            short fr = (short)(start >> 0 & 0xFFL);
            long sector = min * 60 * 75 + sec * 75 + fr - 150;
            this.dinfo[subUnit].lastResult = this.PlayAudioSector(subUnit, sector, length);
            return this.dinfo[subUnit].lastResult;
        }

        boolean GetSubChannelData(short subUnit, ShortRef attr, ShortRef track2, ShortRef index, Dos_cdrom.TMSF rel, Dos_cdrom.TMSF abs) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].GetAudioSub(attr, track2, index, rel, abs);
            if (!this.dinfo[subUnit].lastResult) {
                index.value = 0;
                track2.value = 0;
                attr.value = 0;
                rel.clear();
                abs.clear();
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean GetAudioStatus(short subUnit, BooleanRef playing, BooleanRef pause, Dos_cdrom.TMSF start, Dos_cdrom.TMSF end) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].GetAudioStatus(playing, pause);
            if (this.dinfo[subUnit].lastResult) {
                long addr = this.dinfo[subUnit].audioStart + 150L;
                start.fr = (short)(addr % 75L);
                start.sec = (short)((addr /= 75L) % 60L);
                start.min = (short)(addr / 60L);
                addr = this.dinfo[subUnit].audioEnd + 150L;
                end.fr = (short)(addr % 75L);
                end.sec = (short)((addr /= 75L) % 60L);
                end.min = (short)(addr / 60L);
            } else {
                playing.value = false;
                pause.value = false;
                start.clear();
                end.clear();
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean StopAudio(short subUnit) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.dinfo[subUnit].audioPlay ? this.cdrom[subUnit].PauseAudio(false) : this.cdrom[subUnit].StopAudio();
            if (this.dinfo[subUnit].lastResult) {
                if (this.dinfo[subUnit].audioPlay) {
                    Dos_cdrom.TMSF pos = new Dos_cdrom.TMSF();
                    this.GetCurrentPos(subUnit, pos);
                    this.dinfo[subUnit].audioStart = pos.min * 60 * 75 + pos.sec * 75 + pos.fr - 150;
                    this.dinfo[subUnit].audioPaused = true;
                } else {
                    this.dinfo[subUnit].audioPaused = false;
                    this.dinfo[subUnit].audioStart = 0L;
                    this.dinfo[subUnit].audioEnd = 0L;
                }
                this.dinfo[subUnit].audioPlay = false;
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean ResumeAudio(short subUnit) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.PlayAudioSector(subUnit, this.dinfo[subUnit].audioStart, this.dinfo[subUnit].audioEnd);
            return this.dinfo[subUnit].lastResult;
        }

        long GetVolumeSize(short subUnit) {
            if (subUnit >= this.numDrives) {
                return 0L;
            }
            ShortRef tr1 = new ShortRef(0);
            ShortRef tr2 = new ShortRef(0);
            Dos_cdrom.TMSF leadOut = new Dos_cdrom.TMSF();
            this.dinfo[subUnit].lastResult = this.GetCDInfo(subUnit, tr1, tr2, leadOut);
            if (this.dinfo[subUnit].lastResult) {
                return leadOut.min * 60 * 75 + leadOut.sec * 75 + leadOut.fr;
            }
            return 0L;
        }

        boolean ReadVTOC(int drive, int volume, int data, IntRef error) {
            short subunit = this.GetSubUnit(drive);
            if (!this.ReadSectors(subunit, false, 16 + volume, 1, data)) {
                error.value = 21;
                return false;
            }
            byte[] id = new byte[5];
            Memory.MEM_BlockRead(data + 1, id, 5);
            if (!"CD001".equals(new String(id))) {
                error.value = 11;
                return false;
            }
            short type = Memory.mem_readb(data);
            error.value = type == 1 ? 1 : (type == 255 ? 255 : 0);
            return true;
        }

        boolean GetVolumeName(short subUnit, StringRef data) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            short drive = this.dinfo[subUnit].drive;
            IntRef error = new IntRef(0);
            boolean success = false;
            int ptoc = this.GetTempBuffer();
            success = this.ReadVTOC(drive, 0, ptoc, error);
            if (success) {
                data.value = Memory.MEM_StrCopy(ptoc + 40, 31);
                data.value = data.value.trim();
            }
            return success;
        }

        boolean GetCopyrightName(int drive, int data) {
            IntRef error = new IntRef(0);
            boolean success = false;
            int ptoc = this.GetTempBuffer();
            success = this.ReadVTOC(drive, 0, ptoc, error);
            if (success) {
                Memory.MEM_BlockCopy(data, ptoc + 702, 37);
                Memory.mem_writeb(data + 37, 0);
            }
            return success;
        }

        boolean GetAbstractName(int drive, int data) {
            IntRef error = new IntRef(0);
            boolean success = false;
            int ptoc = this.GetTempBuffer();
            success = this.ReadVTOC(drive, 0, ptoc, error);
            if (success) {
                Memory.MEM_BlockCopy(data, ptoc + 739, 37);
                Memory.mem_writeb(data + 37, 0);
            }
            return success;
        }

        boolean GetDocumentationName(int drive, int data) {
            IntRef error = new IntRef(0);
            boolean success = false;
            int ptoc = this.GetTempBuffer();
            success = this.ReadVTOC(drive, 0, ptoc, error);
            if (success) {
                Memory.MEM_BlockCopy(data, ptoc + 776, 37);
                Memory.mem_writeb(data + 37, 0);
            }
            return success;
        }

        boolean GetUPC(short subUnit, ShortRef attr, StringRef upc) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].GetUPC(attr, upc);
            return this.dinfo[subUnit].lastResult;
        }

        boolean ReadSectors(short subUnit, boolean raw, long sector, int num, int data) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            CPU.CPU_Cycles = 4 * num * 2048 + 5 < CPU.CPU_Cycles ? (CPU.CPU_Cycles -= 4 * num * 2048) : 5;
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].ReadSectors(data, raw, sector, num);
            return this.dinfo[subUnit].lastResult;
        }

        boolean ReadSectorsMSF(short subUnit, boolean raw, long start, int num, int data) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            short min = (short)(start >> 16 & 0xFFL);
            short sec = (short)(start >> 8 & 0xFFL);
            short fr = (short)(start >> 0 & 0xFFL);
            long sector = min * 60 * 75 + sec * 75 + fr - 150;
            return this.ReadSectors(subUnit, raw, sector, num, data);
        }

        boolean ReadSectors(int drive, long sector, int num, int data) {
            return this.ReadSectors(this.GetSubUnit(drive), false, sector, num, data);
        }

        boolean GetDirectoryEntry(int drive, boolean copyFlag, int pathname, int buffer, IntRef error) {
            String searchName;
            boolean foundComplete = false;
            boolean nextPart = true;
            String useName = "";
            error.value = 0;
            String searchPos = searchName = Memory.MEM_StrCopy(pathname + 1, Memory.mem_readb(pathname)).toUpperCase();
            int searchlen = searchName.length();
            if (searchlen > 1 && searchName.indexOf("..") >= 0 && searchName.charAt(searchlen - 1) == '.') {
                searchName = searchName.substring(0, searchlen - 1);
            }
            int defBuffer = this.GetDefaultBuffer();
            if (!this.ReadSectors(this.GetSubUnit(drive), false, 16L, 1, defBuffer)) {
                return false;
            }
            String volumeID = Memory.MEM_StrCopy(defBuffer + 1, 5);
            boolean iso = "CD001".equals(volumeID);
            if (!iso) {
                Log.exit("MSCDEX: GetDirEntry: Not an ISO 9960 CD.");
            }
            int dirEntrySector = Memory.mem_readd(defBuffer + 156 + 2);
            int dirSize = Memory.mem_readd(defBuffer + 156 + 10);
            while (dirSize > 0) {
                short entryLength;
                int index = 0;
                if (!this.ReadSectors(this.GetSubUnit(drive), false, dirEntrySector, 1, defBuffer)) {
                    return false;
                }
                boolean foundName = false;
                if (nextPart) {
                    if (searchPos.length() > 0) {
                        useName = searchPos;
                        int pos = searchPos.indexOf("\\");
                        searchPos = pos >= 0 ? searchPos.substring(pos + 1) : "";
                    }
                    if (searchPos.length() == 0) {
                        foundComplete = true;
                    }
                }
                while ((entryLength = Memory.mem_readb(defBuffer + index)) != 0) {
                    short nameLength = Memory.mem_readb(defBuffer + index + 32);
                    String entryName = Memory.MEM_StrCopy(defBuffer + index + 33, nameLength);
                    if (entryName.equals(useName)) {
                        foundName = true;
                        break;
                    }
                    int longername = entryName.indexOf(59);
                    if (longername >= 0 && entryName.substring(0, longername).equals(useName)) {
                        foundName = true;
                        break;
                    }
                    if ((index += entryLength) + 33 <= 2048) continue;
                }
                if (foundName) {
                    if (foundComplete) {
                        if (copyFlag) {
                            Log.log(21, 1, "MSCDEX: GetDirEntry: Copyflag structure not entirely accurate maybe");
                            byte[] readBuf = new byte[256];
                            byte[] writeBuf = new byte[256];
                            if (entryLength > 256) {
                                return false;
                            }
                            Memory.MEM_BlockRead(defBuffer + index, readBuf, (int)entryLength);
                            writeBuf[0] = readBuf[1];
                            System.arraycopy(readBuf, 2, writeBuf, 1, 4);
                            writeBuf[5] = 0;
                            writeBuf[6] = 8;
                            System.arraycopy(readBuf, 10, writeBuf, 7, 4);
                            System.arraycopy(readBuf, 18, writeBuf, 11, 7);
                            writeBuf[18] = readBuf[25];
                            writeBuf[19] = readBuf[26];
                            writeBuf[20] = readBuf[27];
                            System.arraycopy(readBuf, 28, writeBuf, 21, 2);
                            writeBuf[23] = readBuf[32];
                            System.arraycopy(readBuf, 33, writeBuf, 24, readBuf[32] <= 38 ? readBuf[32] : 38);
                            Memory.MEM_BlockWrite(buffer, writeBuf, 64);
                        } else {
                            Memory.MEM_BlockCopy(buffer, defBuffer + index, entryLength);
                        }
                        error.value = iso ? 1 : 0;
                        return true;
                    }
                    dirEntrySector = Memory.mem_readd(defBuffer + index + 2);
                    dirSize = Memory.mem_readd(defBuffer + index + 10);
                    nextPart = true;
                    continue;
                }
                dirSize -= 2048;
                ++dirEntrySector;
                nextPart = false;
            }
            error.value = 2;
            return false;
        }

        boolean GetCurrentPos(short subUnit, Dos_cdrom.TMSF pos) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            Dos_cdrom.TMSF rel = new Dos_cdrom.TMSF();
            ShortRef attr = new ShortRef(0);
            ShortRef track2 = new ShortRef(0);
            ShortRef index = new ShortRef(0);
            this.dinfo[subUnit].lastResult = this.GetSubChannelData(subUnit, attr, track2, index, rel, pos);
            if (!this.dinfo[subUnit].lastResult) {
                pos.clear();
            }
            return this.dinfo[subUnit].lastResult;
        }

        boolean GetMediaStatus(short subUnit, BooleanRef media, BooleanRef changed, BooleanRef trayOpen) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].GetMediaTrayStatus(media, changed, trayOpen);
            return this.dinfo[subUnit].lastResult;
        }

        long GetDeviceStatus(short subUnit) {
            if (subUnit >= this.numDrives) {
                return 0L;
            }
            BooleanRef media = new BooleanRef();
            BooleanRef changed = new BooleanRef();
            BooleanRef trayOpen = new BooleanRef();
            this.dinfo[subUnit].lastResult = this.GetMediaStatus(subUnit, media, changed, trayOpen);
            long status = (trayOpen.value ? 1 : 0) << 0 | (this.dinfo[subUnit].locked ? 1 : 0) << 1 | 4 | 0x10 | 0x100 | 0x200 | (!media.value ? 1 : 0) << 11;
            return status;
        }

        boolean GetMediaStatus(short subUnit, ShortRef status) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            status.value = (short)(Bios_disk.getSwapRequest() ? 255 : 1);
            return true;
        }

        boolean LoadUnloadMedia(short subUnit, boolean unload) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            this.dinfo[subUnit].lastResult = this.cdrom[subUnit].LoadUnloadMedia(unload);
            return this.dinfo[subUnit].lastResult;
        }

        boolean SendDriverRequest(int drive, int data) {
            short subUnit = this.GetSubUnit(drive);
            if (subUnit >= this.numDrives) {
                return false;
            }
            Memory.mem_writeb(data + 1, subUnit);
            MSCDEX_Strategy_Handler.call();
            MSCDEX_Interrupt_Handler.call();
            return true;
        }

        int GetStatusWord(short subUnit, int status) {
            if (subUnit >= this.numDrives) {
                return 32770;
            }
            status = this.dinfo[subUnit].lastResult ? (status |= 0x100) : (status |= 0x8000);
            if (this.dinfo[subUnit].audioPlay) {
                BooleanRef playing = new BooleanRef();
                BooleanRef pause = new BooleanRef();
                Dos_cdrom.TMSF start = new Dos_cdrom.TMSF();
                Dos_cdrom.TMSF end = new Dos_cdrom.TMSF();
                this.dinfo[subUnit].audioPlay = this.GetAudioStatus(subUnit, playing, pause, start, end) ? playing.value : false;
                status |= (this.dinfo[subUnit].audioPlay ? 1 : 0) << 9;
            }
            this.dinfo[subUnit].lastResult = true;
            return status;
        }

        void InitNewMedia(short subUnit) {
            if (subUnit < this.numDrives) {
                this.cdrom[subUnit].InitNewMedia();
            }
        }

        boolean ChannelControl(int subUnit, Dos_cdrom.TCtrl ctrl) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            if (ctrl.out[0] > 1) {
                ctrl.out[0] = 0;
            }
            if (ctrl.out[1] > 1) {
                ctrl.out[1] = 1;
            }
            this.dinfo[subUnit].audioCtrl = ctrl;
            this.cdrom[subUnit].ChannelControl(ctrl);
            return true;
        }

        boolean GetChannelControl(int subUnit, Dos_cdrom.TCtrl ctrl) {
            if (subUnit >= this.numDrives) {
                return false;
            }
            ctrl.copy(this.dinfo[subUnit].audioCtrl);
            return true;
        }

        public static class TDriveInfo {
            short drive;
            short physDrive;
            boolean audioPlay;
            boolean audioPaused;
            long audioStart;
            long audioEnd;
            boolean locked;
            boolean lastResult;
            long volumeSize;
            Dos_cdrom.TCtrl audioCtrl = new Dos_cdrom.TCtrl();
        }
    }

    private static class DOS_DeviceHeader
    extends MemStruct {
        public static final int size = 22;

        public DOS_DeviceHeader(int ptr) {
            this.pt = ptr;
        }

        public void SetNextDeviceHeader(int ptr) {
            this.SaveIt(4, 0, ptr);
        }

        public int GetNextDeviceHeader() {
            return this.GetIt(4, 0);
        }

        public void SetAttribute(int atr) {
            this.SaveIt(2, 4, atr);
        }

        public void SetDriveLetter(int letter) {
            this.SaveIt(1, 20, letter);
        }

        public void SetNumSubUnits(short num) {
            this.SaveIt(1, 21, num);
        }

        public short GetNumSubUnits() {
            return (short)this.GetIt(1, 21);
        }

        public void SetName(String _name) {
            Memory.MEM_BlockWrite(this.pt + 10, _name, 8);
        }

        public void SetInterrupt(int ofs) {
            this.SaveIt(2, 8, ofs);
        }

        public void SetStrategy(int ofs) {
            this.SaveIt(2, 6, ofs);
        }
    }
}

