/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import jdos.dos.MemStruct;
import jdos.hardware.Memory;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Dos_DTA
extends MemStruct {
    public Dos_DTA(int addr) {
        this.SetRealPt(addr);
    }

    public void SetupSearch(int _sdrive, int _sattr, String _pattern) {
        this.SaveIt(1, 0, _sdrive);
        this.SaveIt(1, 12, _sattr);
        for (int i = 0; i < 11; ++i) {
            Memory.mem_writeb(this.pt + 1 + i, 32);
        }
        int pos = _pattern.indexOf(46);
        if (pos >= 0) {
            Memory.MEM_BlockWrite(this.pt + 1, _pattern.substring(0, pos), 8);
            Memory.MEM_BlockWrite(this.pt + 9, _pattern.substring(pos + 1), 3);
        } else {
            Memory.MEM_BlockWrite(this.pt + 1, _pattern, 8);
        }
    }

    public void SetResult(String name, long size, int date, int time, short attr) {
        Memory.MEM_BlockWrite(this.pt + 30, name, 13);
        this.SaveIt(4, 26, (int)size);
        this.SaveIt(2, 24, date);
        this.SaveIt(2, 22, time);
        this.SaveIt(1, 21, attr);
    }

    public short GetSearchDrive() {
        return (short)this.GetIt(1, 0);
    }

    public void GetSearchParams(ShortRef attr, StringRef pattern) {
        attr.value = (short)this.GetIt(1, 12);
        byte[] temp = new byte[11];
        Memory.MEM_BlockRead(this.pt + 1, temp, 11);
        pattern.value = StringHelper.toString(temp, 0, 8);
        pattern.value = pattern.value + '.';
        pattern.value = pattern.value + StringHelper.toString(temp, 8, 3);
    }

    public void GetResult(StringRef _name, LongRef _size, IntRef _date, IntRef _time, ShortRef _attr) {
        byte[] name = new byte[13];
        Memory.MEM_BlockRead(this.pt + 30, name, name.length);
        _name.value = StringHelper.toString(name);
        _size.value = this.GetIt(4, 26);
        _date.value = this.GetIt(2, 24);
        _time.value = this.GetIt(2, 22);
        _attr.value = (short)this.GetIt(1, 21);
    }

    public void SetDirID(int entry) {
        this.SaveIt(2, 13, entry);
    }

    public void SetDirIDCluster(int entry) {
        this.SaveIt(2, 15, entry);
    }

    public int GetDirID() {
        return this.GetIt(2, 13);
    }

    public int GetDirIDCluster() {
        return this.GetIt(2, 15);
    }
}

