/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import jdos.Dosbox;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.DOS_Device;
import jdos.dos.Dos;
import jdos.dos.Dos_files;
import jdos.dos.Drives;
import jdos.hardware.Memory;
import jdos.ints.Bios_keyboard;
import jdos.ints.Int10;
import jdos.ints.Int10_char;
import jdos.misc.Log;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringRef;

public class Dos_devices {
    public static final int DOS_DEVICES = 10;
    public static DOS_Device[] Devices;
    private static final int NUMBER_ANSI_DATA = 10;

    public static short DOS_FindDevice(String name) {
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return 10;
        }
        int pos = fullname.value.lastIndexOf(92);
        String name_part = null;
        if (pos >= 0) {
            name_part = fullname.value.substring(pos + 1);
        }
        if (name_part != null) {
            if (!Dos_files.Drives[drive.value].TestDir(fullname.value.substring(0, pos))) {
                return 10;
            }
        } else {
            name_part = fullname.value;
        }
        if ((pos = name_part.indexOf(46)) >= 0) {
            name_part = name_part.substring(0, pos);
        }
        String com = "COM1";
        String lpt = "LPT1";
        if (name_part.equals("AUX")) {
            name_part = "COM1";
        }
        if (name_part.equals("PRN")) {
            name_part = "LPT1";
        }
        for (short index = 0; index < 10; index = (short)((short)(index + 1))) {
            if (Devices[index] == null || !Drives.WildFileCmp(name_part, Dos_devices.Devices[index].name)) continue;
            return index;
        }
        return 10;
    }

    public static void DOS_AddDevice(DOS_Device adddev) {
        for (int i = 0; i < 10; ++i) {
            if (Devices[i] != null) continue;
            Dos_devices.Devices[i] = adddev;
            Devices[i].SetDeviceNumber(i);
            return;
        }
        Log.exit("DOS:Too many devices added");
    }

    public static void DOS_DelDevice(DOS_Device dev) {
        for (int i = 0; i < 10; ++i) {
            if (Devices[i] == null || Dos_devices.Devices[i].name.compareToIgnoreCase(dev.name) != 0) continue;
            Dos_devices.Devices[i] = null;
            return;
        }
    }

    public static void DOS_SetupDevices() {
        Devices = new DOS_Device[10];
        Dos_devices.DOS_AddDevice(new device_CON());
        Dos_devices.DOS_AddDevice(new device_NUL());
        Dos_devices.DOS_AddDevice(new device_LPT1());
    }

    private static class device_CON
    extends DOS_Device {
        private byte readcache;
        private byte lastwrite;
        private Ansi ansi = new Ansi();

        public device_CON() {
            this.SetName("CON");
            this.readcache = 0;
            this.lastwrite = 0;
            this.ansi.enabled = false;
            this.ansi.attr = (short)7;
            this.ansi.ncols = Memory.real_readw(64, 74);
            this.ansi.nrows = Memory.real_readb(64, 132) + 1;
            this.ansi.saverow = 0;
            this.ansi.savecol = 0;
            this.ansi.warned = false;
            this.ClearAnsi();
        }

        public boolean Read(byte[] data, IntRef size) {
            int oldax = CPU_Regs.reg_eax.word();
            int count = 0;
            if (this.readcache != 0 && size.value != 0) {
                data[count++] = this.readcache;
                if (Dos.dos.echo) {
                    Int10_char.INT10_TeletypeOutput(this.readcache, 7);
                }
                this.readcache = 0;
            }
            block6: while (size.value > count) {
                CPU_Regs.reg_eax.high(Dosbox.IS_EGAVGA_ARCH() ? 16 : 0);
                Callback.CALLBACK_RunRealInt(22);
                switch (CPU_Regs.reg_eax.low() & 0xFF) {
                    case 13: {
                        data[count++] = 13;
                        if (size.value > count) {
                            data[count++] = 10;
                        }
                        size.value = count;
                        CPU_Regs.reg_eax.word(oldax);
                        if (Dos.dos.echo) {
                            Int10_char.INT10_TeletypeOutput(13, 7);
                            Int10_char.INT10_TeletypeOutput(10, 7);
                        }
                        return true;
                    }
                    case 8: {
                        if (size.value == 1) {
                            data[count++] = (byte)CPU_Regs.reg_eax.low();
                            break;
                        }
                        if (count == 0) continue block6;
                        data[count--] = 0;
                        Int10_char.INT10_TeletypeOutput(8, 7);
                        Int10_char.INT10_TeletypeOutput(32, 7);
                        break;
                    }
                    case 224: {
                        if (CPU_Regs.reg_eax.high() == 0) {
                            data[count++] = (byte)CPU_Regs.reg_eax.low();
                            break;
                        }
                        data[count++] = 0;
                        if (size.value > count) {
                            data[count++] = (byte)CPU_Regs.reg_eax.high();
                            break;
                        }
                        this.readcache = (byte)CPU_Regs.reg_eax.high();
                        break;
                    }
                    case 0: {
                        data[count++] = (byte)CPU_Regs.reg_eax.low();
                        if (size.value > count) {
                            data[count++] = (byte)CPU_Regs.reg_eax.high();
                            break;
                        }
                        this.readcache = (byte)CPU_Regs.reg_eax.high();
                        break;
                    }
                    default: {
                        data[count++] = (byte)CPU_Regs.reg_eax.low();
                    }
                }
                if (!Dos.dos.echo) continue;
                Int10_char.INT10_TeletypeOutput(CPU_Regs.reg_eax.low(), 7);
            }
            size.value = count;
            CPU_Regs.reg_eax.word(oldax);
            return true;
        }

        public boolean Write(byte[] data, IntRef size) {
            int count = 0;
            while (size.value > count) {
                if (!this.ansi.esc) {
                    if (data[count] == 27) {
                        this.ClearAnsi();
                        this.ansi.esc = true;
                        ++count;
                        continue;
                    }
                    if (data[count] == 10 && this.lastwrite != 13) {
                        Int10_char.INT10_TeletypeOutputAttr(13, this.ansi.attr, this.ansi.enabled);
                    }
                    Int10_char.INT10_TeletypeOutputAttr(data[count] & 0xFF, this.ansi.attr, this.ansi.enabled);
                    this.lastwrite = data[count++];
                    continue;
                }
                if (!this.ansi.sci) {
                    switch (data[count]) {
                        case 91: {
                            this.ansi.sci = true;
                            break;
                        }
                        default: {
                            this.ClearAnsi();
                        }
                    }
                    ++count;
                    continue;
                }
                short page = Memory.real_readb(64, 98);
                switch (data[count]) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.ansi.data[this.ansi.numberofarg] = (byte)(10 * this.ansi.data[this.ansi.numberofarg] + (data[count] - 48));
                        break;
                    }
                    case 59: {
                        this.ansi.numberofarg = (short)(this.ansi.numberofarg + 1);
                        break;
                    }
                    case 109: {
                        block43: for (int i = 0; i <= this.ansi.numberofarg; ++i) {
                            this.ansi.enabled = true;
                            switch (this.ansi.data[i]) {
                                case 0: {
                                    this.ansi.attr = (short)7;
                                    this.ansi.enabled = false;
                                    continue block43;
                                }
                                case 1: {
                                    this.ansi.attr = (short)(this.ansi.attr | 8);
                                    continue block43;
                                }
                                case 4: {
                                    Log.log(12, 0, "ANSI:no support for underline yet");
                                    continue block43;
                                }
                                case 5: {
                                    this.ansi.attr = (short)(this.ansi.attr | 0x80);
                                    continue block43;
                                }
                                case 7: {
                                    this.ansi.attr = (short)112;
                                    continue block43;
                                }
                                case 30: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 0);
                                    continue block43;
                                }
                                case 31: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 4);
                                    continue block43;
                                }
                                case 32: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 2);
                                    continue block43;
                                }
                                case 33: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 6);
                                    continue block43;
                                }
                                case 34: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 1);
                                    continue block43;
                                }
                                case 35: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 5);
                                    continue block43;
                                }
                                case 36: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 3);
                                    continue block43;
                                }
                                case 37: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0xF8);
                                    this.ansi.attr = (short)(this.ansi.attr | 7);
                                    continue block43;
                                }
                                case 40: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0);
                                    continue block43;
                                }
                                case 41: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x40);
                                    continue block43;
                                }
                                case 42: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x20);
                                    continue block43;
                                }
                                case 43: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x60);
                                    continue block43;
                                }
                                case 44: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x10);
                                    continue block43;
                                }
                                case 45: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x50);
                                    continue block43;
                                }
                                case 46: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x30);
                                    continue block43;
                                }
                                case 47: {
                                    this.ansi.attr = (short)(this.ansi.attr & 0x8F);
                                    this.ansi.attr = (short)(this.ansi.attr | 0x70);
                                    continue block43;
                                }
                            }
                        }
                        this.ClearAnsi();
                        break;
                    }
                    case 72: 
                    case 102: {
                        if (!this.ansi.warned) {
                            this.ansi.warned = true;
                            Log.log(12, 1, "ANSI SEQUENCES USED");
                        }
                        if (this.ansi.data[0] == 0) {
                            this.ansi.data[0] = 1;
                        }
                        if (this.ansi.data[1] == 0) {
                            this.ansi.data[1] = 1;
                        }
                        if (this.ansi.data[0] > this.ansi.nrows) {
                            this.ansi.data[0] = (byte)this.ansi.nrows;
                        }
                        if (this.ansi.data[1] > this.ansi.ncols) {
                            this.ansi.data[1] = (byte)this.ansi.ncols;
                        }
                        this.ansi.data[0] = (byte)(this.ansi.data[0] - 1);
                        this.ansi.data[1] = (byte)(this.ansi.data[1] - 1);
                        Int10_char.INT10_SetCursorPos(this.ansi.data[0], this.ansi.data[1], page);
                        this.ClearAnsi();
                        break;
                    }
                    case 65: {
                        short col = Int10.CURSOR_POS_COL(page);
                        short row = Int10.CURSOR_POS_ROW(page);
                        short tempdata = this.ansi.data[0] != 0 ? this.ansi.data[0] : (byte)1;
                        row = tempdata > row ? (short)0 : (short)(row - tempdata);
                        Int10_char.INT10_SetCursorPos(row, col, page);
                        this.ClearAnsi();
                        break;
                    }
                    case 66: {
                        short col = Int10.CURSOR_POS_COL(page);
                        short row = Int10.CURSOR_POS_ROW(page);
                        short tempdata = this.ansi.data[0] != 0 ? this.ansi.data[0] : (byte)1;
                        row = tempdata + row >= this.ansi.nrows ? (short)(this.ansi.nrows - 1) : (short)(row + tempdata);
                        Int10_char.INT10_SetCursorPos(row, col, page);
                        this.ClearAnsi();
                        break;
                    }
                    case 67: {
                        short col = Int10.CURSOR_POS_COL(page);
                        short row = Int10.CURSOR_POS_ROW(page);
                        short tempdata = this.ansi.data[0] != 0 ? this.ansi.data[0] : (byte)1;
                        col = tempdata + col >= this.ansi.ncols ? (short)(this.ansi.ncols - 1) : (short)(col + tempdata);
                        Int10_char.INT10_SetCursorPos(row, col, page);
                        this.ClearAnsi();
                        break;
                    }
                    case 68: {
                        short col = Int10.CURSOR_POS_COL(page);
                        short row = Int10.CURSOR_POS_ROW(page);
                        short tempdata = this.ansi.data[0] != 0 ? this.ansi.data[0] : (byte)1;
                        col = tempdata > col ? (short)0 : (short)(col - tempdata);
                        Int10_char.INT10_SetCursorPos(row, col, page);
                        this.ClearAnsi();
                        break;
                    }
                    case 74: {
                        if (this.ansi.data[0] == 0) {
                            this.ansi.data[0] = 2;
                        }
                        if (this.ansi.data[0] != 2) {
                            // empty if block
                        }
                        Int10_char.INT10_ScrollWindow((short)0, (short)0, (short)255, (short)255, (byte)0, this.ansi.attr, page);
                        this.ClearAnsi();
                        Int10_char.INT10_SetCursorPos((short)0, (short)0, page);
                        break;
                    }
                    case 73: 
                    case 104: {
                        Log.log(12, 0, "ANSI: set/reset mode called(not supported)");
                        this.ClearAnsi();
                        break;
                    }
                    case 117: {
                        Int10_char.INT10_SetCursorPos(this.ansi.saverow, this.ansi.savecol, page);
                        this.ClearAnsi();
                        break;
                    }
                    case 115: {
                        this.ansi.savecol = (byte)Int10.CURSOR_POS_COL(page);
                        this.ansi.saverow = (byte)Int10.CURSOR_POS_ROW(page);
                        this.ClearAnsi();
                        break;
                    }
                    case 75: {
                        short col = Int10.CURSOR_POS_COL(page);
                        short row = Int10.CURSOR_POS_ROW(page);
                        Int10_char.INT10_WriteChar((short)32, this.ansi.attr, page, this.ansi.ncols - col, true);
                        Int10_char.INT10_SetCursorPos(row, col, page);
                        this.ClearAnsi();
                        break;
                    }
                    case 77: {
                        short col = Int10.CURSOR_POS_COL(page);
                        short row = Int10.CURSOR_POS_ROW(page);
                        Int10_char.INT10_ScrollWindow(row, (short)0, (short)(this.ansi.nrows - 1), (short)(this.ansi.ncols - 1), (byte)(this.ansi.data[0] != 0 ? -this.ansi.data[0] : -1), this.ansi.attr, (short)255);
                        this.ClearAnsi();
                        break;
                    }
                    default: {
                        this.ClearAnsi();
                    }
                }
                ++count;
            }
            size.value = count;
            return true;
        }

        public boolean Seek(LongRef pos, int type) {
            pos.value = 0L;
            return true;
        }

        public boolean Close() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int GetInformation() {
            Object object = Bios_keyboard.lock;
            synchronized (object) {
                int head = Memory.mem_readw(1050);
                int tail = Memory.mem_readw(1052);
                if (head == tail && this.readcache == 0) {
                    return 32979;
                }
                if (this.readcache != 0 || Memory.real_readw(64, head) != 0) {
                    return 32915;
                }
                int start = Memory.mem_readw(1152);
                int end = Memory.mem_readw(1154);
                if ((head += 2) >= end) {
                    head = start;
                }
                Memory.mem_writew(1050, head);
            }
            return 32979;
        }

        public boolean ReadFromControlChannel(int bufptr, int size, IntRef retcode) {
            return false;
        }

        public boolean WriteToControlChannel(int bufptr, int size, IntRef retcode) {
            return false;
        }

        public void ClearAnsi() {
            for (int i = 0; i < 10; i = (int)((short)(i + 1))) {
                this.ansi.data[i] = 0;
            }
            this.ansi.esc = false;
            this.ansi.sci = false;
            this.ansi.numberofarg = 0;
        }

        private static class Ansi {
            boolean esc;
            boolean sci;
            boolean enabled;
            short attr;
            byte[] data = new byte[10];
            short numberofarg;
            int nrows;
            int ncols;
            byte savecol;
            byte saverow;
            boolean warned;

            private Ansi() {
            }
        }
    }

    private static class device_LPT1
    extends device_NUL {
        public device_LPT1() {
            this.SetName("LPT1");
        }

        public int GetInformation() {
            return 32928;
        }
    }

    private static class device_NUL
    extends DOS_Device {
        public device_NUL() {
            this.SetName("NUL");
        }

        public boolean Read(byte[] data, IntRef size) {
            for (int i = 0; i < size.value; ++i) {
                data[i] = 0;
            }
            return true;
        }

        public boolean Write(byte[] data, IntRef size) {
            return true;
        }

        public boolean Seek(LongRef pos, int type) {
            return true;
        }

        public boolean Close() {
            return true;
        }

        public int GetInformation() {
            return 32900;
        }

        public boolean ReadFromControlChannel(int bufptr, int size, IntRef retcode) {
            return false;
        }

        public boolean WriteToControlChannel(int bufptr, int size, IntRef retcode) {
            return false;
        }
    }
}

