/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import java.io.File;
import java.util.Vector;
import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos;
import jdos.dos.DosMSCDEX;
import jdos.dos.Dos_Drive;
import jdos.dos.Dos_MCB;
import jdos.dos.Dos_PSP;
import jdos.dos.Dos_files;
import jdos.dos.Dos_keyboard_layout;
import jdos.dos.Dos_memory;
import jdos.dos.DriveManager;
import jdos.dos.drives.Drive_fat;
import jdos.dos.drives.Drive_iso;
import jdos.dos.drives.Drive_local;
import jdos.dos.drives.Drive_local_cdrom;
import jdos.hardware.Memory;
import jdos.ints.Bios_disk;
import jdos.misc.Cross;
import jdos.misc.Log;
import jdos.misc.Msg;
import jdos.misc.Program;
import jdos.misc.setup.Section;
import jdos.shell.Dos_shell;
import jdos.util.BooleanRef;
import jdos.util.FileHelper;
import jdos.util.FileIO;
import jdos.util.FileIOFactory;
import jdos.util.IntPtr;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Dos_programs {
    private static Program.PROGRAMS_Main MOUNT_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new MOUNT();
        }
    };
    private static Program.PROGRAMS_Main REBOOT_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            throw new RebootException();
        }
    };
    private static Program.PROGRAMS_Main MEM_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new MEM();
        }
    };
    private static Program.PROGRAMS_Main BOOT_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new BOOT();
        }
    };
    private static Program.PROGRAMS_Main LOADFIX_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new LOADFIX();
        }
    };
    private static Program.PROGRAMS_Main RESCAN_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new RESCAN();
        }
    };
    private static Program.PROGRAMS_Main INTRO_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new INTRO();
        }
    };
    private static Program.PROGRAMS_Main IMGMOUNT_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new IMGMOUNT();
        }
    };
    private static Program.PROGRAMS_Main KEYB_ProgramStart = new Program.PROGRAMS_Main(){

        public Program call() {
            return new KEYB();
        }
    };

    public static void DOS_SetupPrograms() {
        Msg.add("PROGRAM_MOUNT_CDROMS_FOUND", "CDROMs found: %d\n");
        Msg.add("PROGRAM_MOUNT_STATUS_2", "Drive %c is mounted as %s\n");
        Msg.add("PROGRAM_MOUNT_STATUS_1", "Current mounted drives are:\n");
        Msg.add("PROGRAM_MOUNT_ERROR_1", "Directory %s doesn't exist.\n");
        Msg.add("PROGRAM_MOUNT_ERROR_2", "%s isn't a directory\n");
        Msg.add("PROGRAM_MOUNT_ILL_TYPE", "Illegal type %s\n");
        Msg.add("PROGRAM_MOUNT_ALREADY_MOUNTED", "Drive %c already mounted with %s\n");
        Msg.add("PROGRAM_MOUNT_USAGE", "Usage \u001b[34;1mMOUNT Drive-Letter Local-Directory\u001b[0m\nFor example: MOUNT c %s\nThis makes the directory %s act as the C: drive inside DOSBox.\nThe directory has to exist.\n");
        Msg.add("PROGRAM_MOUNT_UMOUNT_NOT_MOUNTED", "Drive %c isn't mounted.\n");
        Msg.add("PROGRAM_MOUNT_UMOUNT_SUCCESS", "Drive %c has successfully been removed.\n");
        Msg.add("PROGRAM_MOUNT_UMOUNT_NO_VIRTUAL", "Virtual Drives can not be unMOUNTed.\n");
        Msg.add("PROGRAM_MOUNT_WARNING_WIN", "\u001b[31;1mMounting c:\\ is NOT recommended. Please mount a (sub)directory next time.\u001b[0m\n");
        Msg.add("PROGRAM_MOUNT_WARNING_OTHER", "\u001b[31;1mMounting / is NOT recommended. Please mount a (sub)directory next time.\u001b[0m\n");
        Msg.add("PROGRAM_MEM_CONVEN", "%10d Kb free conventional memory\n");
        Msg.add("PROGRAM_MEM_EXTEND", "%10d Kb free extended memory\n");
        Msg.add("PROGRAM_MEM_EXPAND", "%10d Kb free expanded memory\n");
        Msg.add("PROGRAM_MEM_UPPER", "%10d Kb free upper memory in %d blocks (largest UMB %d Kb)\n");
        Msg.add("PROGRAM_LOADFIX_ALLOC", "%d kb allocated.\n");
        Msg.add("PROGRAM_LOADFIX_DEALLOC", "%d kb freed.\n");
        Msg.add("PROGRAM_LOADFIX_DEALLOCALL", "Used memory freed.\n");
        Msg.add("PROGRAM_LOADFIX_ERROR", "Memory allocation error.\n");
        Msg.add("MSCDEX_SUCCESS", "MSCDEX installed.\n");
        Msg.add("MSCDEX_ERROR_MULTIPLE_CDROMS", "MSCDEX: Failure: Drive-letters of multiple CDRom-drives have to be continuous.\n");
        Msg.add("MSCDEX_ERROR_NOT_SUPPORTED", "MSCDEX: Failure: Not yet supported.\n");
        Msg.add("MSCDEX_ERROR_OPEN", "MSCDEX: Failure: Invalid file or unable to open.\n");
        Msg.add("MSCDEX_TOO_MANY_DRIVES", "MSCDEX: Failure: Too many CDRom-drives (max: 5). MSCDEX Installation failed.\n");
        Msg.add("MSCDEX_LIMITED_SUPPORT", "MSCDEX: Mounted subdirectory: limited support.\n");
        Msg.add("MSCDEX_INVALID_FILEFORMAT", "MSCDEX: Failure: File is either no iso/cue image or contains errors.\n");
        Msg.add("MSCDEX_UNKNOWN_ERROR", "MSCDEX: Failure: Unknown error.\n");
        Msg.add("PROGRAM_RESCAN_SUCCESS", "Drive cache cleared.\n");
        Msg.add("PROGRAM_INTRO", "\u001b[2J\u001b[32;1mWelcome to DOSBox\u001b[0m, an x86 emulator with sound and graphics.\nDOSBox creates a shell for you which looks like old plain DOS.\n\nFor information about basic mount type \u001b[34;1mintro mount\u001b[0m\nFor information about CD-ROM support type \u001b[34;1mintro cdrom\u001b[0m\nFor information about special keys type \u001b[34;1mintro special\u001b[0m\nFor more information about DOSBox, go to \u001b[34;1mhttp://www.dosbox.com/wiki\u001b[0m\n\n\u001b[31;1mDOSBox will stop/exit without a warning if an error occured!\u001b[0m\n\n\n");
        Msg.add("PROGRAM_INTRO_MOUNT_START", "\u001b[32;1mHere are some commands to get you started:\u001b[0m\nBefore you can use the files located on your own filesystem,\nYou have to mount the directory containing the files.\n\n");
        Msg.add("PROGRAM_INTRO_MOUNT_WINDOWS", "\u001b[44;1m\u00c9\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00bb\n\u00ba \u001b[32mmount c c:\\dosprogs\\\u001b[37m will create a C drive with c:\\dosprogs as contents.\u00ba\n\u00ba                                                                         \u00ba\n\u00ba \u001b[32mc:\\dosprogs\\\u001b[37m is an example. Replace it with your own games directory.  \u001b[37m \u00ba\n\u00c8\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00bc\u001b[0m\n");
        Msg.add("PROGRAM_INTRO_MOUNT_OTHER", "\u001b[44;1m\u00c9\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00bb\n\u00ba \u001b[32mmount c ~/dosprogs\u001b[37m will create a C drive with ~/dosprogs as contents.\u00ba\n\u00ba                                                                      \u00ba\n\u00ba \u001b[32m~/dosprogs\u001b[37m is an example. Replace it with your own games directory.\u001b[37m  \u00ba\n\u00c8\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00cd\u00bc\u001b[0m\n");
        Msg.add("PROGRAM_INTRO_MOUNT_END", "When the mount has successfully completed you can type \u001b[34;1mc:\u001b[0m to go to your freshly\nmounted C-drive. Typing \u001b[34;1mdir\u001b[0m there will show its contents. \u001b[34;1mcd\u001b[0m will allow you to\nenter a directory (recognised by the \u001b[33;1m[]\u001b[0m in a directory listing).\nYou can run programs/files which end with \u001b[31m.exe .bat\u001b[0m and \u001b[31m.com\u001b[0m.\n");
        Msg.add("PROGRAM_INTRO_CDROM", "\u001b[2J\u001b[32;1mHow to mount a Real/Virtual CD-ROM Drive in DOSBox:\u001b[0m\nDOSBox provides CD-ROM emulation on several levels.\n\nThe \u001b[33mbasic\u001b[0m level works on all CD-ROM drives and normal directories.\nIt installs MSCDEX and marks the files read-only.\nUsually this is enough for most games:\n\u001b[34;1mmount d \u001b[0;31mD:\\\u001b[34;1m -t cdrom\u001b[0m   or   \u001b[34;1mmount d C:\\example -t cdrom\u001b[0m\nIf it doesn't work you might have to tell DOSBox the label of the CD-ROM:\n\u001b[34;1mmount d C:\\example -t cdrom -label CDLABEL\u001b[0m\n\nThe \u001b[33mnext\u001b[0m level adds some low-level support.\nTherefore only works on CD-ROM drives:\n\u001b[34;1mmount d \u001b[0;31mD:\\\u001b[34;1m -t cdrom -usecd \u001b[33m0\u001b[0m\n\nThe \u001b[33mlast\u001b[0m level of support depends on your Operating System:\nFor \u001b[1mWindows 2000\u001b[0m, \u001b[1mWindows XP\u001b[0m and \u001b[1mLinux\u001b[0m:\n\u001b[34;1mmount d \u001b[0;31mD:\\\u001b[34;1m -t cdrom -usecd \u001b[33m0 \u001b[34m-ioctl\u001b[0m\nFor \u001b[1mWindows 9x\u001b[0m with a ASPI layer installed:\n\u001b[34;1mmount d \u001b[0;31mD:\\\u001b[34;1m -t cdrom -usecd \u001b[33m0 \u001b[34m-aspi\u001b[0m\n\nReplace \u001b[0;31mD:\\\u001b[0m with the location of your CD-ROM.\nReplace the \u001b[33;1m0\u001b[0m in \u001b[34;1m-usecd \u001b[33m0\u001b[0m with the number reported for your CD-ROM if you type:\n\u001b[34;1mmount -cd\u001b[0m\n");
        Msg.add("PROGRAM_INTRO_SPECIAL", "\u001b[2J\u001b[32;1mSpecial keys:\u001b[0m\nThese are the default keybindings.\nThey can be changed in the \u001b[33mkeymapper\u001b[0m.\n\n\u001b[33;1mALT-ENTER\u001b[0m   : Go full screen and back.\n\u001b[33;1mALT-PAUSE\u001b[0m   : Pause DOSBox.\n\u001b[33;1mCTRL-F1\u001b[0m     : Start the \u001b[33mkeymapper\u001b[0m.\n\u001b[33;1mCTRL-F4\u001b[0m     : Update directory cache for all drives! Swap mounted disk-image.\n\u001b[33;1mCTRL-ALT-F5\u001b[0m : Start/Stop creating a movie of the screen.\n\u001b[33;1mCTRL-F5\u001b[0m     : Save a screenshot.\n\u001b[33;1mCTRL-F6\u001b[0m     : Start/Stop recording sound output to a wave file.\n\u001b[33;1mCTRL-ALT-F7\u001b[0m : Start/Stop recording of OPL commands.\n\u001b[33;1mCTRL-ALT-F8\u001b[0m : Start/Stop the recording of raw MIDI commands.\n\u001b[33;1mCTRL-F7\u001b[0m     : Decrease frameskip.\n\u001b[33;1mCTRL-F8\u001b[0m     : Increase frameskip.\n\u001b[33;1mCTRL-F9\u001b[0m     : Kill DOSBox.\n\u001b[33;1mCTRL-F10\u001b[0m    : Capture/Release the mouse.\n\u001b[33;1mCTRL-F11\u001b[0m    : Slow down emulation (Decrease DOSBox Cycles).\n\u001b[33;1mCTRL-F12\u001b[0m    : Speed up emulation (Increase DOSBox Cycles).\n\u001b[33;1mALT-F12\u001b[0m     : Unlock speed (turbo button/fast forward).\n");
        Msg.add("PROGRAM_BOOT_NOT_EXIST", "Bootdisk file does not exist.  Failing.\n");
        Msg.add("PROGRAM_BOOT_NOT_OPEN", "Cannot open bootdisk file.  Failing.\n");
        Msg.add("PROGRAM_BOOT_WRITE_PROTECTED", "Image file is read-only! Might create problems.\n");
        Msg.add("PROGRAM_BOOT_PRINT_ERROR", "This command boots DOSBox from either a floppy or hard disk image.\n\nFor this command, one can specify a succession of floppy disks swappable\nby pressing Ctrl-F4, and -l specifies the mounted drive to boot from.  If\nno drive letter is specified, this defaults to booting from the A drive.\nThe only bootable drive letters are A, C, and D.  For booting from a hard\ndrive (C or D), the image should have already been mounted using the\n\u001b[34;1mIMGMOUNT\u001b[0m command.\n\nThe syntax of this command is:\n\n\u001b[34;1mBOOT [diskimg1.img diskimg2.img] [-l driveletter]\u001b[0m\n");
        Msg.add("PROGRAM_BOOT_UNABLE", "Unable to boot off of drive %c");
        Msg.add("PROGRAM_BOOT_IMAGE_OPEN", "Opening image file: %s\n");
        Msg.add("PROGRAM_BOOT_IMAGE_NOT_OPEN", "Cannot open %s");
        Msg.add("PROGRAM_BOOT_BOOT", "Booting from drive %c...\n");
        Msg.add("PROGRAM_BOOT_CART_WO_PCJR", "PCjr cartridge found, but machine is not PCjr");
        Msg.add("PROGRAM_BOOT_CART_LIST_CMDS", "Available PCjr cartridge commandos:%s");
        Msg.add("PROGRAM_BOOT_CART_NO_CMDS", "No PCjr cartridge commandos found");
        Msg.add("PROGRAM_IMGMOUNT_SPECIFY_DRIVE", "Must specify drive letter to mount image at.\n");
        Msg.add("PROGRAM_IMGMOUNT_SPECIFY2", "Must specify drive number (0 or 3) to mount image at (0,1=fda,fdb;2,3=hda,hdb).\n");
        Msg.add("PROGRAM_IMGMOUNT_SPECIFY_GEOMETRY", "For \u001b[33mCD-ROM\u001b[0m images:   \u001b[34;1mIMGMOUNT drive-letter location-of-image -t iso\u001b[0m\n\nFor \u001b[33mhardrive\u001b[0m images: Must specify drive geometry for hard drives:\nbytes_per_sector, sectors_per_cylinder, heads_per_cylinder, cylinder_count.\n\u001b[34;1mIMGMOUNT drive-letter location-of-image -size bps,spc,hpc,cyl\u001b[0m\n");
        Msg.add("PROGRAM_IMGMOUNT_INVALID_IMAGE", "Could not load image file.\nCheck that the path is correct and the image is accessible.\n");
        Msg.add("PROGRAM_IMGMOUNT_INVALID_GEOMETRY", "Could not extract drive geometry from image.\nUse parameter -size bps,spc,hpc,cyl to specify the geometry.\n");
        Msg.add("PROGRAM_IMGMOUNT_AUTODET_VALUES", "Image geometry auto detection: -size %d,%d,%d,%d\n");
        Msg.add("PROGRAM_IMGMOUNT_TYPE_UNSUPPORTED", "Type \"%s\" is unsupported. Specify \"hdd\" or \"floppy\" or\"iso\".\n");
        Msg.add("PROGRAM_IMGMOUNT_FORMAT_UNSUPPORTED", "Format \"%s\" is unsupported. Specify \"fat\" or \"iso\" or \"none\".\n");
        Msg.add("PROGRAM_IMGMOUNT_SPECIFY_FILE", "Must specify file-image to mount.\n");
        Msg.add("PROGRAM_IMGMOUNT_FILE_NOT_FOUND", "Image file not found.\n");
        Msg.add("PROGRAM_IMGMOUNT_MOUNT", "To mount directories, use the \u001b[34;1mMOUNT\u001b[0m command, not the \u001b[34;1mIMGMOUNT\u001b[0m command.\n");
        Msg.add("PROGRAM_IMGMOUNT_ALREADY_MOUNTED", "Drive already mounted at that letter.\n");
        Msg.add("PROGRAM_IMGMOUNT_CANT_CREATE", "Can't create drive from file.\n");
        Msg.add("PROGRAM_IMGMOUNT_MOUNT_NUMBER", "Drive number %d mounted as %s\n");
        Msg.add("PROGRAM_IMGMOUNT_NON_LOCAL_DRIVE", "The image must be on a host or local drive.\n");
        Msg.add("PROGRAM_IMGMOUNT_MULTIPLE_NON_CUEISO_FILES", "Using multiple files is only supported for cue/iso images.\n");
        Msg.add("PROGRAM_KEYB_INFO", "Codepage %i has been loaded\n");
        Msg.add("PROGRAM_KEYB_INFO_LAYOUT", "Codepage %i has been loaded for layout %s\n");
        Msg.add("PROGRAM_KEYB_SHOWHELP", "\u001b[32;1mKEYB\u001b[0m [keyboard layout ID[ codepage number[ codepage file]]]\n\nSome examples:\n  \u001b[32;1mKEYB\u001b[0m: Display currently loaded codepage.\n  \u001b[32;1mKEYB\u001b[0m sp: Load the spanish (SP) layout, use an appropriate codepage.\n  \u001b[32;1mKEYB\u001b[0m sp 850: Load the spanish (SP) layout, use codepage 850.\n  \u001b[32;1mKEYB\u001b[0m sp 850 mycp.cpi: Same as above, but use file mycp.cpi.\n");
        Msg.add("PROGRAM_KEYB_NOERROR", "Keyboard layout %s loaded for codepage %i\n");
        Msg.add("PROGRAM_KEYB_FILENOTFOUND", "Keyboard file %s not found\n\n");
        Msg.add("PROGRAM_KEYB_INVALIDFILE", "Keyboard file %s invalid\n");
        Msg.add("PROGRAM_KEYB_LAYOUTNOTFOUND", "No layout in %s for codepage %i\n");
        Msg.add("PROGRAM_KEYB_INVCPFILE", "None or invalid codepage file for layout %s\n\n");
        Program.PROGRAMS_MakeFile("MOUNT.COM", MOUNT_ProgramStart);
        Program.PROGRAMS_MakeFile("MEM.COM", MEM_ProgramStart);
        Program.PROGRAMS_MakeFile("LOADFIX.COM", LOADFIX_ProgramStart);
        Program.PROGRAMS_MakeFile("RESCAN.COM", RESCAN_ProgramStart);
        Program.PROGRAMS_MakeFile("INTRO.COM", INTRO_ProgramStart);
        Program.PROGRAMS_MakeFile("BOOT.COM", BOOT_ProgramStart);
        Program.PROGRAMS_MakeFile("IMGMOUNT.COM", IMGMOUNT_ProgramStart);
        Program.PROGRAMS_MakeFile("KEYB.COM", KEYB_ProgramStart);
        Program.PROGRAMS_MakeFile("REBOOT.COM", REBOOT_ProgramStart);
    }

    private static class KEYB
    extends Program {
        private KEYB() {
        }

        public void Run() {
            this.temp_line = this.cmd.FindCommand(1);
            if (this.temp_line != null) {
                this.temp_line = this.cmd.FindString("?", false);
                if (this.temp_line != null) {
                    this.WriteOut(Msg.get("PROGRAM_KEYB_SHOWHELP"));
                } else {
                    int keyb_error = 0;
                    IntRef tried_cp = new IntRef(-1);
                    String cp_string = this.cmd.FindCommand(2);
                    if (cp_string != null) {
                        try {
                            tried_cp.value = Integer.parseInt(cp_string);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        cp_string = this.cmd.FindCommand(3);
                        String cp_file_name = cp_string != null ? cp_string : "auto";
                        keyb_error = Dos_keyboard_layout.DOS_LoadKeyboardLayout(this.temp_line, tried_cp.value, cp_file_name);
                    } else {
                        keyb_error = Dos_keyboard_layout.DOS_SwitchKeyboardLayout(this.temp_line, tried_cp);
                    }
                    switch (keyb_error) {
                        case 0: {
                            this.WriteOut(Msg.get("PROGRAM_KEYB_NOERROR"), new Object[]{this.temp_line, new Integer(Dos.dos.loaded_codepage)});
                            break;
                        }
                        case 1: {
                            this.WriteOut(Msg.get("PROGRAM_KEYB_FILENOTFOUND"), new Object[]{this.temp_line});
                            this.WriteOut(Msg.get("PROGRAM_KEYB_SHOWHELP"));
                            break;
                        }
                        case 2: {
                            this.WriteOut(Msg.get("PROGRAM_KEYB_INVALIDFILE"), new Object[]{this.temp_line});
                            break;
                        }
                        case 3: {
                            this.WriteOut(Msg.get("PROGRAM_KEYB_LAYOUTNOTFOUND"), new Object[]{this.temp_line, new Integer(tried_cp.value)});
                            break;
                        }
                        case 4: {
                            this.WriteOut(Msg.get("PROGRAM_KEYB_INVCPFILE"), new Object[]{this.temp_line});
                            this.WriteOut(Msg.get("PROGRAM_KEYB_SHOWHELP"));
                            break;
                        }
                        default: {
                            Log.log(14, 2, "KEYB:Invalid returncode " + Integer.toString(keyb_error, 16));
                            break;
                        }
                    }
                }
            } else {
                String layout_name = Dos_keyboard_layout.DOS_GetLoadedLayout();
                if (layout_name == null) {
                    this.WriteOut(Msg.get("PROGRAM_KEYB_INFO"), new Object[]{new Integer(Dos.dos.loaded_codepage)});
                } else {
                    this.WriteOut(Msg.get("PROGRAM_KEYB_INFO_LAYOUT"), new Object[]{new Integer(Dos.dos.loaded_codepage), layout_name});
                }
            }
        }
    }

    private static class IMGMOUNT
    extends Program {
        private IMGMOUNT() {
        }

        public void Run() {
            char drive;
            short mediaid;
            this.ChangeToLongCmd();
            if (Dosbox.control.SecureMode()) {
                this.WriteOut(Msg.get("PROGRAM_CONFIG_SECURE_DISALLOW"));
                return;
            }
            Drive_fat newdrive = null;
            Bios_disk.imageDisk newImage = null;
            Vector<String> paths = new Vector<String>();
            String umount = this.cmd.FindString("-u", false);
            if (umount != null) {
                int i_drive = umount.toUpperCase().charAt(0) - 65;
                if (i_drive < 26 && i_drive >= 0 && Dos_files.Drives[i_drive] != null) {
                    switch (DriveManager.UnmountDrive(i_drive)) {
                        case 0: {
                            Dos_files.Drives[i_drive] = null;
                            if (i_drive == Dos_files.DOS_GetDefaultDrive()) {
                                Dos_files.DOS_SetDrive((short)25);
                            }
                            this.WriteOut(Msg.get("PROGRAM_MOUNT_UMOUNT_SUCCESS"), new Object[]{new Character(umount.charAt(0))});
                            break;
                        }
                        case 1: {
                            this.WriteOut(Msg.get("PROGRAM_MOUNT_UMOUNT_NO_VIRTUAL"));
                            break;
                        }
                        case 2: {
                            this.WriteOut(Msg.get("MSCDEX_ERROR_MULTIPLE_CDROMS"));
                        }
                    }
                } else {
                    this.WriteOut(Msg.get("PROGRAM_MOUNT_UMOUNT_NOT_MOUNTED"), new Object[]{new Character(umount.charAt(0))});
                }
                return;
            }
            String type = this.cmd.FindString("-t", true);
            type = type == null ? "hdd" : type.toLowerCase();
            String fstype = this.cmd.FindString("-fs", true);
            if (fstype == null) {
                fstype = "fat";
            }
            if (type.equals("cdrom")) {
                type = "iso";
            }
            if (type.equals("floppy") || type.equals("hdd") || type.equals("iso")) {
                int[] sizes = new int[4];
                boolean imgsizedetect = false;
                String str_size = "";
                mediaid = 248;
                if (type.equals("floppy")) {
                    mediaid = 240;
                } else if (type.equals("iso")) {
                    str_size = "650,127,16513,1700";
                    mediaid = 248;
                    fstype = "iso";
                }
                String s = this.cmd.FindString("-size", true);
                if (s != null) {
                    str_size = s;
                }
                if (type.equals("hdd") && str_size.length() == 0) {
                    imgsizedetect = true;
                } else {
                    String[] ss = StringHelper.split(str_size, ",");
                    for (int i = 0; i < ss.length && i < sizes.length; ++i) {
                        try {
                            sizes[i] = Integer.parseInt(ss[i]);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (fstype.equals("fat") || fstype.equals("iso")) {
                    this.temp_line = this.cmd.FindCommand(1);
                    if (this.temp_line == null || this.temp_line.length() > 2 || this.temp_line.length() > 1 && this.temp_line.charAt(1) != ':') {
                        this.WriteOut_NoParsing(Msg.get("PROGRAM_IMGMOUNT_SPECIFY_DRIVE"));
                        return;
                    }
                    drive = this.temp_line.toUpperCase().charAt(0);
                    if (!StringHelper.isalpha(drive)) {
                        this.WriteOut_NoParsing(Msg.get("PROGRAM_IMGMOUNT_SPECIFY_DRIVE"));
                        return;
                    }
                } else if (fstype.equals("none")) {
                    this.temp_line = this.cmd.FindCommand(1);
                    if (this.temp_line.length() > 1 || !StringHelper.isdigit(this.temp_line.charAt(0))) {
                        this.WriteOut_NoParsing(Msg.get("PROGRAM_IMGMOUNT_SPECIFY2"));
                        return;
                    }
                    drive = this.temp_line.charAt(0);
                    if (drive < '0' || drive > '3') {
                        this.WriteOut_NoParsing(Msg.get("PROGRAM_IMGMOUNT_SPECIFY2"));
                        return;
                    }
                } else {
                    this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_FORMAT_UNSUPPORTED"), new Object[]{fstype});
                    return;
                }
                while ((this.temp_line = this.cmd.FindCommand(paths.size() + 2)) != null && this.temp_line.length() > 0) {
                    if (FileIOFactory.isRemote(this.temp_line)) {
                        paths.add(this.temp_line);
                        continue;
                    }
                    File f = new File(this.temp_line);
                    if (!f.exists()) {
                        String homedir = Cross.ResolveHomedir(this.temp_line);
                        f = new File(homedir);
                        if (f.exists()) {
                            this.temp_line = homedir;
                        } else {
                            String tmp = this.temp_line;
                            StringRef fullname = new StringRef();
                            ShortRef dummy = new ShortRef();
                            if (!Dos_files.DOS_MakeName(tmp, fullname, dummy) || !Dos_files.Drives[dummy.value].GetInfo().startsWith("local directory")) {
                                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_NON_LOCAL_DRIVE"));
                                return;
                            }
                            if (!(Dos_files.Drives[dummy.value] instanceof Drive_local)) {
                                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_FILE_NOT_FOUND"));
                                return;
                            }
                            Drive_local ldp = (Drive_local)Dos_files.Drives[dummy.value];
                            StringRef t = new StringRef(tmp);
                            ldp.GetSystemFilename(t, fullname.value);
                            this.temp_line = t.value;
                            if (!new File(this.temp_line).exists()) {
                                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_FILE_NOT_FOUND") + "    " + this.temp_line);
                                return;
                            }
                        }
                    }
                    if (new File(this.temp_line).isDirectory()) {
                        this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_MOUNT"));
                        return;
                    }
                    paths.add(this.temp_line);
                }
                if (paths.size() == 0) {
                    this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_SPECIFY_FILE"));
                    return;
                }
                if (paths.size() == 1) {
                    this.temp_line = (String)paths.elementAt(0);
                }
                if (paths.size() > 1 && !fstype.equals("iso")) {
                    this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_MULTIPLE_NON_CUEISO_FILES"));
                    return;
                }
                if (fstype.equals("fat")) {
                    if (imgsizedetect) {
                        FileIO diskfile = null;
                        try {
                            int cylinders;
                            int part_start;
                            int part_end;
                            int part_len;
                            diskfile = FileIOFactory.open(this.temp_line, 3);
                            long fcsize = diskfile.length() / 512L;
                            byte[] buf = new byte[512];
                            if (diskfile.read(buf) < 512) {
                                diskfile.close();
                                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_INVALID_IMAGE"));
                                return;
                            }
                            diskfile.close();
                            if (buf[510] != 85 || buf[511] != -86) {
                                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_INVALID_GEOMETRY"));
                                return;
                            }
                            int starthead = buf[447] & 0xFF;
                            int startsect = buf[448] & 0x3E;
                            int startcyl = buf[449] | (buf[448] & 0xC0) << 2;
                            int endcyl = buf[453] | (buf[452] & 0xC0) << 2;
                            int heads = (buf[451] & 0xFF) + 1;
                            int sectors = buf[452] & 0x3F;
                            long pe1_size = new IntPtr(buf, 458).readd(0);
                            boolean yet_detected = false;
                            if (pe1_size != 0L && (part_len = (part_end = heads * sectors * endcyl) - (part_start = startsect + sectors * starthead + startcyl * sectors * heads)) >= 0 && (long)part_len <= pe1_size && pe1_size <= fcsize && (pe1_size - (long)part_len) / (long)(sectors * heads) <= 2L && pe1_size / (long)(heads * sectors) <= 1023L) {
                                sizes[0] = 512;
                                sizes[1] = sectors;
                                sizes[2] = heads;
                                sizes[3] = (int)(fcsize / (long)(heads * sectors));
                                if (sizes[3] > 1023) {
                                    sizes[3] = 1023;
                                }
                                yet_detected = true;
                            }
                            if (!yet_detected && (long)((cylinders = (int)(fcsize / 1008L)) * 16 * 63) == fcsize && cylinders < 1024) {
                                yet_detected = true;
                                sizes[0] = 512;
                                sizes[1] = 63;
                                sizes[2] = 16;
                                sizes[3] = cylinders;
                            }
                            if (!yet_detected) {
                                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_INVALID_GEOMETRY"));
                                return;
                            }
                            this.WriteOut(StringHelper.sprintf(Msg.get("PROGRAM_IMGMOUNT_AUTODET_VALUES"), new Object[]{new Integer(sizes[0]), new Integer(sizes[1]), new Integer(sizes[2]), new Integer(sizes[3])}));
                        }
                        catch (Exception e) {
                            this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_INVALID_IMAGE"));
                            return;
                        }
                    }
                    newdrive = new Drive_fat(this.temp_line, sizes[0], sizes[1], sizes[2], sizes[3], 0L);
                    if (!newdrive.created_successfully) {
                        newdrive = null;
                    }
                } else if (!fstype.equals("iso")) {
                    long imagesize;
                    FileIO newDisk = null;
                    try {
                        newDisk = FileIOFactory.open(this.temp_line, 3);
                        imagesize = newDisk.length() / 1024L;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    newImage = new Bios_disk.imageDisk(newDisk, this.temp_line, imagesize, imagesize > 2880L);
                    if (imagesize > 2880L) {
                        newImage.Set_Geometry(sizes[2], sizes[3], sizes[1], sizes[0]);
                    }
                }
            } else {
                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_TYPE_UNSUPPORTED"), new Object[]{type});
                return;
            }
            if (fstype.equals("fat")) {
                if (Dos_files.Drives[drive - 65] != null) {
                    this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_ALREADY_MOUNTED"));
                    return;
                }
                if (newdrive == null) {
                    this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_CANT_CREATE"));
                    return;
                }
                Dos_files.Drives[drive - 65] = newdrive;
                Memory.mem_writeb(Memory.Real2Phys(Dos.dos.tables.mediaid) + (drive - 65) * 2, mediaid);
                this.WriteOut(Msg.get("PROGRAM_MOUNT_STATUS_2"), new Object[]{new Character(drive), this.temp_line});
                if (newdrive.loadedDisk.hardDrive) {
                    if (Bios_disk.imageDiskList[2] == null) {
                        Bios_disk.imageDiskList[2] = newdrive.loadedDisk;
                        Bios_disk.updateDPT();
                        return;
                    }
                    if (Bios_disk.imageDiskList[3] == null) {
                        Bios_disk.imageDiskList[3] = newdrive.loadedDisk;
                        Bios_disk.updateDPT();
                        return;
                    }
                }
                if (!newdrive.loadedDisk.hardDrive) {
                    Bios_disk.imageDiskList[0] = newdrive.loadedDisk;
                }
            } else if (fstype.equals("iso")) {
                int i;
                if (Dos_files.Drives[drive - 65] != null) {
                    this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_ALREADY_MOUNTED"));
                    return;
                }
                DosMSCDEX.MSCDEX_SetCDInterface(0, -1);
                Vector<Drive_iso> isoDisks = new Vector<Drive_iso>();
                for (i = 0; i < paths.size(); ++i) {
                    IntRef error = new IntRef(-1);
                    Drive_iso newDrive = new Drive_iso(drive, (String)paths.elementAt(i), mediaid, error);
                    isoDisks.add(newDrive);
                    switch (error.value) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.WriteOut(Msg.get("MSCDEX_ERROR_MULTIPLE_CDROMS"));
                            break;
                        }
                        case 2: {
                            this.WriteOut(Msg.get("MSCDEX_ERROR_NOT_SUPPORTED"));
                            break;
                        }
                        case 3: {
                            this.WriteOut(Msg.get("MSCDEX_ERROR_OPEN"));
                            break;
                        }
                        case 4: {
                            this.WriteOut(Msg.get("MSCDEX_TOO_MANY_DRIVES"));
                            break;
                        }
                        case 5: {
                            this.WriteOut(Msg.get("MSCDEX_LIMITED_SUPPORT"));
                            break;
                        }
                        case 6: {
                            this.WriteOut(Msg.get("MSCDEX_INVALID_FILEFORMAT"));
                            break;
                        }
                        default: {
                            this.WriteOut(Msg.get("MSCDEX_UNKNOWN_ERROR"));
                        }
                    }
                    if (error.value == 0) continue;
                    return;
                }
                for (int ct = 0; ct < isoDisks.size(); ++ct) {
                    DriveManager.AppendDisk(drive - 65, (Dos_Drive)isoDisks.elementAt(ct));
                }
                DriveManager.InitializeDrive(drive - 65);
                Memory.mem_writeb(Memory.Real2Phys(Dos.dos.tables.mediaid) + (drive - 65) * 2, mediaid);
                this.WriteOut(Msg.get("MSCDEX_SUCCESS"));
                String tmp = (String)paths.elementAt(0);
                for (i = 1; i < paths.size(); ++i) {
                    tmp = tmp + "; " + paths.elementAt(i);
                }
                this.WriteOut(Msg.get("PROGRAM_MOUNT_STATUS_2"), new Object[]{new Character(drive), tmp});
            } else if (fstype.equals("none")) {
                Bios_disk.imageDiskList[drive - 48] = newImage;
                Bios_disk.updateDPT();
                this.WriteOut(Msg.get("PROGRAM_IMGMOUNT_MOUNT_NUMBER"), new Object[]{new Integer(drive - 48), this.temp_line});
            }
        }
    }

    private static class INTRO
    extends Program {
        private INTRO() {
        }

        void DisplayMount() {
            this.WriteOut(Msg.get("PROGRAM_INTRO_MOUNT_START"));
            this.WriteOut(Msg.get("PROGRAM_INTRO_MOUNT_OTHER"));
            this.WriteOut(Msg.get("PROGRAM_INTRO_MOUNT_END"));
        }

        public void Run() {
            if (new Dos_PSP(Dos.dos.psp()).GetParent() != new Dos_PSP(new Dos_PSP(Dos.dos.psp()).GetParent()).GetParent()) {
                return;
            }
            if (this.cmd.FindExist("cdrom", false)) {
                this.WriteOut(Msg.get("PROGRAM_INTRO_CDROM"));
                return;
            }
            if (this.cmd.FindExist("mount", false)) {
                this.WriteOut("\u001b[2J");
                this.DisplayMount();
                return;
            }
            if (this.cmd.FindExist("special", false)) {
                this.WriteOut(Msg.get("PROGRAM_INTRO_SPECIAL"));
                return;
            }
            this.WriteOut(Msg.get("PROGRAM_INTRO"));
            byte[] c = new byte[1];
            IntRef n = new IntRef(1);
            Dos_files.DOS_ReadFile(0, c, n);
            this.DisplayMount();
            Dos_files.DOS_ReadFile(0, c, n);
            this.WriteOut(Msg.get("PROGRAM_INTRO_CDROM"));
            Dos_files.DOS_ReadFile(0, c, n);
            this.WriteOut(Msg.get("PROGRAM_INTRO_SPECIAL"));
        }
    }

    private static class RESCAN
    extends Program {
        private RESCAN() {
        }

        public void Run() {
            short drive = Dos_files.DOS_GetDefaultDrive();
            if (Dos_files.Drives[drive] != null) {
                Dos_files.Drives[drive].EmptyCache();
                this.WriteOut(Msg.get("PROGRAM_RESCAN_SUCCESS"));
            }
        }
    }

    private static class LOADFIX
    extends Program {
        private LOADFIX() {
        }

        public void Run() {
            IntRef blocks;
            IntRef segment;
            int commandNr = 1;
            int kb = 64;
            this.temp_line = this.cmd.FindCommand(commandNr);
            if (this.temp_line != null && this.temp_line.startsWith("-") && this.temp_line.length() > 1) {
                char ch = this.temp_line.toUpperCase().charAt(1);
                if (ch == 'D' || ch == 'F') {
                    Dos_memory.DOS_FreeProcessMemory(64);
                    this.WriteOut(Msg.get("PROGRAM_LOADFIX_DEALLOCALL"), new Object[]{new Integer(kb)});
                    return;
                }
                kb = Integer.parseInt(this.temp_line.substring(1));
                if (kb == 0) {
                    kb = 64;
                }
                ++commandNr;
            }
            if (Dos_memory.DOS_AllocateMemory(segment = new IntRef(0), blocks = new IntRef(kb * 1024 / 16))) {
                Dos_MCB mcb = new Dos_MCB(segment.value - 1);
                mcb.SetPSPSeg(64);
                this.WriteOut(Msg.get("PROGRAM_LOADFIX_ALLOC"), new Object[]{new Integer(kb)});
                this.temp_line = this.cmd.FindCommand(commandNr++);
                if (this.temp_line != null) {
                    boolean ok;
                    String filename = this.temp_line;
                    String args = "";
                    do {
                        ok = (this.temp_line = this.cmd.FindCommand(commandNr++)) != null;
                        args = args + this.temp_line;
                        args = args + " ";
                    } while (ok);
                    Dos_shell shell = new Dos_shell();
                    shell.Execute(filename, args);
                    Dos_memory.DOS_FreeMemory(segment.value);
                    this.WriteOut(Msg.get("PROGRAM_LOADFIX_DEALLOC"), new Object[]{new Integer(kb)});
                }
            } else {
                this.WriteOut(Msg.get("PROGRAM_LOADFIX_ERROR"), new Object[]{new Integer(kb)});
            }
        }
    }

    private static class BOOT
    extends Program {
        private BOOT() {
        }

        private FileIO getFSFile_mounted(String filename, LongRef ksize, LongRef bsize, BooleanRef error) {
            boolean tryload = error.value;
            error.value = false;
            StringRef fullname = new StringRef();
            ShortRef drive = new ShortRef();
            if (!Dos_files.DOS_MakeName(filename, fullname, drive)) {
                return null;
            }
            try {
                if (!(Dos_files.Drives[drive.value] instanceof Drive_local)) {
                    return null;
                }
                Drive_local ldp = (Drive_local)Dos_files.Drives[drive.value];
                FileIO tmpfile = ldp.GetSystemFilePtr(fullname.value, "rb");
                if (tmpfile == null) {
                    if (!tryload) {
                        error.value = true;
                    }
                    return null;
                }
                bsize.value = tmpfile.length();
                ksize.value = bsize.value / 1024L;
                tmpfile.close();
                tmpfile = ldp.GetSystemFilePtr(fullname.value, "rb+");
                if (tmpfile == null) {
                    this.WriteOut(Msg.get("PROGRAM_BOOT_WRITE_PROTECTED"));
                    tmpfile = ldp.GetSystemFilePtr(fullname.value, "rb");
                    if (tmpfile == null) {
                        if (!tryload) {
                            error.value = true;
                        }
                        return null;
                    }
                }
                return tmpfile;
            }
            catch (Exception e) {
                return null;
            }
        }

        FileIO getFSFile(String filename, LongRef ksize, LongRef bsize) {
            return this.getFSFile(filename, ksize, bsize, false);
        }

        FileIO getFSFile(String filename, LongRef ksize, LongRef bsize, boolean tryload) {
            BooleanRef error = new BooleanRef(tryload);
            FileIO tmpfile = this.getFSFile_mounted(filename, ksize, bsize, error);
            if (tmpfile != null) {
                return tmpfile;
            }
            filename = FileHelper.resolve_path(filename);
            try {
                tmpfile = FileIOFactory.open(filename, 3);
            }
            catch (Exception e) {
                try {
                    tmpfile = FileIOFactory.open(filename, 1);
                    this.WriteOut(Msg.get("PROGRAM_BOOT_WRITE_PROTECTED"));
                }
                catch (Exception e1) {
                    this.WriteOut(Msg.get("PROGRAM_BOOT_NOT_EXIST"));
                    return null;
                }
            }
            try {
                bsize.value = tmpfile.length();
                ksize.value = bsize.value / 1024L;
            }
            catch (Exception e) {
                // empty catch block
            }
            return tmpfile;
        }

        private void printError() {
            this.WriteOut(Msg.get("PROGRAM_BOOT_PRINT_ERROR"));
        }

        private void disable_umb_ems_xms() {
            Section dos_sec = Dosbox.control.GetSection("dos");
            dos_sec.ExecuteDestroy(false);
            dos_sec.HandleInputline("umb=false");
            dos_sec.HandleInputline("xms=false");
            dos_sec.HandleInputline("ems=false");
            dos_sec.ExecuteInit(false);
        }

        public void Run() {
            this.ChangeToLongCmd();
            if (Dosbox.control.SecureMode()) {
                this.WriteOut(Msg.get("PROGRAM_CONFIG_SECURE_DISALLOW"));
                return;
            }
            FileIO usefile_1 = null;
            FileIO usefile_2 = null;
            int i = 0;
            LongRef floppysize = new LongRef(0L);
            LongRef rombytesize_1 = new LongRef(0L);
            LongRef rombytesize_2 = new LongRef(0L);
            char drive = 'A';
            String cart_cmd = "";
            if (this.cmd.GetCount() == 0) {
                this.printError();
                return;
            }
            while (i < this.cmd.GetCount()) {
                this.temp_line = this.cmd.FindCommand(i + 1);
                if (this.temp_line != null) {
                    if (this.temp_line.equalsIgnoreCase("-l")) {
                        if ((this.temp_line = this.cmd.FindCommand(++i + 1)) != null) {
                            drive = this.temp_line.toUpperCase().charAt(0);
                            if (drive != 'A' && drive != 'C' && drive != 'D') {
                                this.printError();
                                return;
                            }
                        } else {
                            this.printError();
                            return;
                        }
                        ++i;
                        continue;
                    }
                    if (this.temp_line.equalsIgnoreCase("-e")) {
                        if ((this.temp_line = this.cmd.FindCommand(++i + 1)) == null) {
                            this.printError();
                            return;
                        }
                        cart_cmd = this.temp_line.toUpperCase();
                        ++i;
                        continue;
                    }
                    this.WriteOut(Msg.get("PROGRAM_BOOT_IMAGE_OPEN"), new Object[]{this.temp_line});
                    LongRef rombytesize = new LongRef(0L);
                    FileIO usefile = this.getFSFile(this.temp_line, floppysize, rombytesize);
                    if (usefile != null) {
                        Bios_disk.diskSwap[i] = new Bios_disk.imageDisk(usefile, this.temp_line, floppysize.value, false);
                        if (usefile_1 == null) {
                            usefile_1 = usefile;
                            rombytesize_1 = rombytesize;
                        } else {
                            usefile_2 = usefile;
                            rombytesize_2 = rombytesize;
                        }
                    } else {
                        this.WriteOut(Msg.get("PROGRAM_BOOT_IMAGE_NOT_OPEN"), new Object[]{this.temp_line});
                        return;
                    }
                }
                ++i;
            }
            Bios_disk.swapPosition = 0;
            Bios_disk.swapInDisks();
            if (Bios_disk.imageDiskList[drive - 65] == null) {
                this.WriteOut(Msg.get("PROGRAM_BOOT_UNABLE"), new Object[]{new Character(drive)});
                return;
            }
            bootSector bootarea = new bootSector();
            Bios_disk.imageDiskList[drive - 65].Read_Sector(0L, 0L, 1L, bootarea.rawdata);
            if (bootarea.rawdata[0] == 80 && bootarea.rawdata[1] == 67 && bootarea.rawdata[2] == 106 && bootarea.rawdata[3] == 114) {
                if (Dosbox.machine != 3) {
                    this.WriteOut(Msg.get("PROGRAM_BOOT_CART_WO_PCJR"));
                }
            } else {
                this.disable_umb_ems_xms();
                Memory.RemoveEMSPageFrame();
                this.WriteOut(Msg.get("PROGRAM_BOOT_BOOT"), new Object[]{new Character(drive)});
                for (i = 0; i < 512; ++i) {
                    Memory.real_writeb(0, 31744 + i, bootarea.rawdata[i]);
                }
                Memory.real_writed(0, 4, -268370093);
                Memory.real_writed(0, 12, -268370093);
                CPU_Regs.SegSet16CS(0);
                CPU_Regs.reg_eip = 31744;
                CPU_Regs.SegSet16DS(0);
                CPU_Regs.SegSet16ES(0);
                CPU_Regs.SegSet16SS(28672);
                CPU_Regs.reg_esp.dword = 256;
                CPU_Regs.reg_esi.dword = 0;
                CPU_Regs.reg_ecx.dword = 1;
                CPU_Regs.reg_ebp.dword = 0;
                CPU_Regs.reg_eax.dword = 0;
                CPU_Regs.reg_edx.dword = 0;
                CPU_Regs.reg_ebx.dword = 31744;
            }
        }

        private static class bootSector {
            byte[] rawdata = new byte[512];

            private bootSector() {
            }
        }
    }

    public static class RebootException
    extends RuntimeException {
    }

    private static class MEM
    extends Program {
        private MEM() {
        }

        public void Run() {
            IntRef handle;
            String emm;
            this.WriteOut("\n");
            int umb_start = Dos.dos_infoblock.GetStartOfUMBChain();
            short umb_flag = Dos.dos_infoblock.GetUMBChainState();
            int old_memstrat = Dos_memory.DOS_GetMemAllocStrategy() & 0xFF;
            if (umb_start != 65535) {
                if ((umb_flag & 1) == 1) {
                    Dos_memory.DOS_LinkUMBsToMemChain(0);
                }
                Dos_memory.DOS_SetMemAllocStrategy(0);
            }
            IntRef seg = new IntRef(0);
            IntRef blocks = new IntRef(65535);
            Dos_memory.DOS_AllocateMemory(seg, blocks);
            if (Dosbox.machine == 3 && Memory.real_readb(8192, 0) == 90 && Memory.real_readw(8192, 1) == 0 && Memory.real_readw(8192, 3) == 32766) {
                this.WriteOut(Msg.get("PROGRAM_MEM_CONVEN"), new Object[]{new Integer(511)});
            } else {
                this.WriteOut(Msg.get("PROGRAM_MEM_CONVEN"), new Object[]{new Integer(blocks.value * 16 / 1024)});
            }
            if (umb_start != 65535) {
                Dos_memory.DOS_LinkUMBsToMemChain(1);
                Dos_memory.DOS_SetMemAllocStrategy(64);
                int largest_block = 0;
                int total_blocks = 0;
                int block_count = 0;
                while (true) {
                    blocks.value = 65535;
                    Dos_memory.DOS_AllocateMemory(seg, blocks);
                    if (blocks.value == 0) break;
                    total_blocks += blocks.value;
                    if (blocks.value > largest_block) {
                        largest_block = blocks.value;
                    }
                    Dos_memory.DOS_AllocateMemory(seg, blocks);
                    ++block_count;
                }
                short current_umb_flag = Dos.dos_infoblock.GetUMBChainState();
                if ((current_umb_flag & 1) != (umb_flag & 1)) {
                    Dos_memory.DOS_LinkUMBsToMemChain(umb_flag);
                }
                Dos_memory.DOS_SetMemAllocStrategy(old_memstrat);
                if (block_count > 0) {
                    this.WriteOut(Msg.get("PROGRAM_MEM_UPPER"), new Object[]{new Integer(total_blocks * 16 / 1024), new Integer(block_count), new Integer(largest_block * 16 / 1024)});
                }
            }
            CPU_Regs.reg_eax.word(17152);
            Callback.CALLBACK_RunRealInt(47);
            if (CPU_Regs.reg_eax.low() == 128) {
                CPU_Regs.reg_eax.word(17168);
                Callback.CALLBACK_RunRealInt(47);
                int xms_seg = CPU.Segs_ESval;
                int xms_off = CPU_Regs.reg_ebx.word();
                CPU_Regs.reg_eax.high(8);
                Callback.CALLBACK_RunRealFar(xms_seg, xms_off);
                if (CPU_Regs.reg_ebx.low() == 0) {
                    this.WriteOut(Msg.get("PROGRAM_MEM_EXTEND"), new Object[]{new Long(CPU_Regs.reg_edx.word())});
                }
            }
            if (Dos_files.DOS_OpenFile(emm = "EMMXXXX0", 0, handle = new IntRef(0))) {
                Dos_files.DOS_CloseFile(handle.value);
                CPU_Regs.reg_eax.high(66);
                Callback.CALLBACK_RunRealInt(103);
                this.WriteOut(Msg.get("PROGRAM_MEM_EXPAND"), new Object[]{new Long(CPU_Regs.reg_ebx.word() * 16)});
            }
        }
    }

    private static class MOUNT
    extends Program {
        private MOUNT() {
        }

        public void Run() {
            block62: {
                boolean iscdrom;
                String type;
                char drive;
                Drive_local newdrive;
                block63: {
                    block61: {
                        String[] s;
                        short mediaid;
                        newdrive = null;
                        drive = 'C';
                        this.ChangeToLongCmd();
                        if (this.cmd.GetCount() == 0) {
                            this.WriteOut(Msg.get("PROGRAM_MOUNT_STATUS_1"));
                            for (int d = 0; d < 26; ++d) {
                                if (Dos_files.Drives[d] == null) continue;
                                this.WriteOut(Msg.get("PROGRAM_MOUNT_STATUS_2"), new Object[]{new Character((char)(d + 65)), Dos_files.Drives[d].GetInfo()});
                            }
                            return;
                        }
                        if (Dosbox.control.SecureMode()) {
                            this.WriteOut(Msg.get("PROGRAM_CONFIG_SECURE_DISALLOW"));
                            return;
                        }
                        String umount = this.cmd.FindString("-u", false);
                        if (umount != null) {
                            int i_drive = (umount = umount.toUpperCase()).charAt(0) - 65;
                            if (i_drive < 26 && i_drive >= 0 && Dos_files.Drives[i_drive] != null) {
                                switch (DriveManager.UnmountDrive(i_drive)) {
                                    case 0: {
                                        Dos_files.Drives[i_drive] = null;
                                        if (i_drive == Dos_files.DOS_GetDefaultDrive()) {
                                            Dos_files.DOS_SetDrive((short)25);
                                        }
                                        this.WriteOut(Msg.get("PROGRAM_MOUNT_UMOUNT_SUCCESS"), new Object[]{umount});
                                        break;
                                    }
                                    case 1: {
                                        this.WriteOut(Msg.get("PROGRAM_MOUNT_UMOUNT_NO_VIRTUAL"));
                                        break;
                                    }
                                    case 2: {
                                        this.WriteOut(Msg.get("MSCDEX_ERROR_MULTIPLE_CDROMS"));
                                    }
                                }
                            } else {
                                this.WriteOut(Msg.get("PROGRAM_MOUNT_UMOUNT_NOT_MOUNTED"), new Object[]{new Character(umount.charAt(0))});
                            }
                            return;
                        }
                        if (this.cmd.FindExist("-cd", false)) {
                            File[] roots = File.listRoots();
                            this.WriteOut(Msg.get("PROGRAM_MOUNT_CDROMS_FOUND"), new Object[]{new Integer(roots.length)});
                            for (int i = 0; i < roots.length; ++i) {
                                this.WriteOut("%2d. %s\n", new Object[]{new Integer(i), roots[i].getAbsolutePath()});
                            }
                            return;
                        }
                        type = this.cmd.FindString("-t", true);
                        if (type == null || type.length() == 0) {
                            type = "dir";
                        }
                        iscdrom = type.equals("cdrom");
                        if (!type.equals("floppy") && !type.equals("dir") && !type.equals("cdrom")) break block61;
                        int[] sizes = new int[4];
                        Object str_size = "";
                        if (type.equals("floppy")) {
                            str_size = "512,1,2880,2880";
                            mediaid = 240;
                        } else if (type.equals("dir")) {
                            str_size = "512,127,16383,4031";
                            mediaid = 248;
                        } else if (type.equals("cdrom")) {
                            str_size = "2048,1,65535,0";
                            mediaid = 248;
                        } else {
                            this.WriteOut(Msg.get("PROGAM_MOUNT_ILL_TYPE"), new Object[]{type});
                            return;
                        }
                        String mb_size = this.cmd.FindString("-freesize", true);
                        if (mb_size != null) {
                            int sizemb = 0;
                            try {
                                Integer.parseInt(mb_size);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            str_size = type.equals("floppy") ? "512,1,2880," + String.valueOf(sizemb * 1024 / 512) : "512,127,16513," + String.valueOf(sizemb * 1024 * 1024 / 65024);
                        }
                        if ((s = this.cmd.FindString("-size", true)) != null && s.length() != 0) {
                            str_size = s;
                        }
                        s = StringHelper.split((String)str_size, ",");
                        for (int i = 0; i < s.length; ++i) {
                            sizes[i] = 0;
                            try {
                                sizes[i] = Integer.parseInt(s[i]);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.temp_line = this.cmd.FindCommand(1);
                        if (this.temp_line == null || this.temp_line.length() > 2 || this.temp_line.length() > 1 && this.temp_line.charAt(1) != ':' || (drive = (char)this.temp_line.toUpperCase().charAt(0)) < 'A' || drive > 'Z') break block62;
                        this.temp_line = this.cmd.FindCommand(2);
                        if (this.temp_line == null || this.temp_line.length() == 0) break block62;
                        this.temp_line = FileHelper.resolve_path(this.temp_line);
                        File temp_file = new File(this.temp_line);
                        if (!temp_file.exists()) {
                            this.WriteOut(Msg.get("PROGRAM_MOUNT_ERROR_1"), new Object[]{this.temp_line});
                            return;
                        }
                        if (!temp_file.isDirectory()) {
                            this.WriteOut(Msg.get("PROGRAM_MOUNT_ERROR_2"), new Object[]{this.temp_line});
                            return;
                        }
                        int bit8size = sizes[1];
                        if (type.equals("cdrom")) {
                            int num = -1;
                            Integer tmp_num = this.cmd.FindInt("-usecd", true);
                            if (tmp_num != null) {
                                num = tmp_num;
                            }
                            IntRef error = new IntRef(0);
                            if (this.cmd.FindExist("-aspi", false)) {
                                this.WriteOut("Direct CDRom support not supported in Java.  Will use local director access");
                            } else if (this.cmd.FindExist("-ioctl_dio", false)) {
                                this.WriteOut("Direct CDRom support not supported in Java.  Will use local director access");
                            } else if (this.cmd.FindExist("-ioctl_dx", false)) {
                                this.WriteOut("Direct CDRom support not supported in Java.  Will use local director access");
                            } else if (this.cmd.FindExist("-ioctl_mci", false)) {
                                this.WriteOut("Direct CDRom support not supported in Java.  Will use local director access");
                            } else if (this.cmd.FindExist("-noioctl", false)) {
                                this.WriteOut("Direct CDRom support not supported in Java.  Will use local director access");
                            }
                            newdrive = new Drive_local_cdrom(drive, this.temp_line, sizes[0], (short)bit8size, sizes[2], 0, mediaid, error);
                            switch (error.value) {
                                case 0: {
                                    this.WriteOut(Msg.get("MSCDEX_SUCCESS"));
                                    break;
                                }
                                case 1: {
                                    this.WriteOut(Msg.get("MSCDEX_ERROR_MULTIPLE_CDROMS"));
                                    break;
                                }
                                case 2: {
                                    this.WriteOut(Msg.get("MSCDEX_ERROR_NOT_SUPPORTED"));
                                    break;
                                }
                                case 3: {
                                    this.WriteOut(Msg.get("MSCDEX_ERROR_PATH"));
                                    break;
                                }
                                case 4: {
                                    this.WriteOut(Msg.get("MSCDEX_TOO_MANY_DRIVES"));
                                    break;
                                }
                                case 5: {
                                    this.WriteOut(Msg.get("MSCDEX_LIMITED_SUPPORT"));
                                    break;
                                }
                                default: {
                                    this.WriteOut(Msg.get("MSCDEX_UNKNOWN_ERROR"));
                                }
                            }
                            if (error.value != 0 && error.value != 5) {
                                return;
                            }
                        } else {
                            if (this.temp_line.equals("c:\\") || this.temp_line.equals("C:\\") || this.temp_line.equals("c:/") || this.temp_line.equals("C:/")) {
                                this.WriteOut(Msg.get("PROGRAM_MOUNT_WARNING_WIN"));
                            }
                            if (this.temp_line.equals("/")) {
                                this.WriteOut(Msg.get("PROGRAM_MOUNT_WARNING_OTHER"));
                            }
                            if (!this.temp_line.endsWith("\\") && !this.temp_line.endsWith("/")) {
                                this.temp_line = this.temp_line + File.separator;
                            }
                            newdrive = new Drive_local(this.temp_line, sizes[0], (short)bit8size, sizes[2], sizes[3], mediaid);
                        }
                        break block63;
                    }
                    this.WriteOut(Msg.get("PROGRAM_MOUNT_ILL_TYPE"), new Object[]{type});
                    return;
                }
                if (Dos_files.Drives[drive - 65] != null) {
                    this.WriteOut(Msg.get("PROGRAM_MOUNT_ALREADY_MOUNTED"), new Object[]{new Character(drive), Dos_files.Drives[drive - 65].GetInfo()});
                    return;
                }
                if (newdrive == null) {
                    Log.exit("DOS:Can't create drive");
                }
                Dos_files.Drives[drive - 65] = newdrive;
                Memory.mem_writeb(Memory.Real2Phys(Dos.dos.tables.mediaid) + (drive - 65) * 2, ((Dos_Drive)newdrive).GetMediaByte());
                this.WriteOut(Msg.get("PROGRAM_MOUNT_STATUS_2"), new Object[]{new Character(drive), newdrive.GetInfo()});
                String label = this.cmd.FindString("-label", true);
                if (label != null) {
                    newdrive.dirCache.SetLabel(label, iscdrom, false);
                } else if (type.equals("dir")) {
                    label = drive + "_DRIVE";
                    newdrive.dirCache.SetLabel(label, iscdrom, true);
                } else if (type.equals("floppy")) {
                    label = drive + "_FLOPPY";
                    newdrive.dirCache.SetLabel(label, iscdrom, true);
                }
                return;
            }
            this.WriteOut(Msg.get("PROGRAM_MOUNT_USAGE"), new Object[]{"d:\\dosprogs", "d:\\dosprogs"});
            this.WriteOut(Msg.get("PROGRAM_MOUNT_USAGE"), new Object[]{"~/dosprogs", "~/dosprogs"});
        }
    }
}

