/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import jdos.hardware.Memory;

public class MemStruct {
    protected int pt;

    public int GetIt(int size, int addr) {
        switch (size) {
            case 1: {
                return Memory.mem_readb(this.pt + addr);
            }
            case 2: {
                return Memory.mem_readw(this.pt + addr);
            }
            case 4: {
                return Memory.mem_readd(this.pt + addr);
            }
        }
        return 0;
    }

    public void SaveIt(int size, int addr, int val) {
        switch (size) {
            case 1: {
                Memory.mem_writeb(this.pt + addr, val);
                break;
            }
            case 2: {
                Memory.mem_writew(this.pt + addr, (short)val);
                break;
            }
            case 4: {
                Memory.mem_writed(this.pt + addr, val);
            }
        }
    }

    void SetPt(int seg) {
        this.pt = Memory.PhysMake(seg, 0);
    }

    void SetPt(int seg, int off) {
        this.pt = Memory.PhysMake(seg, off);
    }

    void SetRealPt(int addr) {
        this.pt = Memory.Real2Phys(addr);
    }
}

