/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos.drives;

import java.io.File;
import java.util.Arrays;
import jdos.dos.DOS_File;
import jdos.dos.Dos;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_Drive;
import jdos.dos.Dos_tables;
import jdos.dos.Drives;
import jdos.dos.FileStat_Block;
import jdos.dos.drives.Bootstrap;
import jdos.dos.drives.DirEntry;
import jdos.dos.drives.PartTable;
import jdos.hardware.Memory;
import jdos.ints.Bios_disk;
import jdos.misc.Log;
import jdos.util.FileIO;
import jdos.util.FileIOFactory;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.Ptr;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Drive_fat
extends Dos_Drive {
    private static final int IMGTYPE_FLOPPY = 0;
    private static final int IMGTYPE_ISO = 1;
    private static final int IMGTYPE_HDD = 2;
    private static final int FAT12 = 0;
    private static final int FAT16 = 1;
    private static final int FAT32 = 2;
    private byte[] fatSectBuffer = new byte[1024];
    private Ptr pfatSectBuffer = new Ptr(this.fatSectBuffer, 0);
    long curFatSect;
    String[] srchInfo = new String[2048];
    private Allocation allocation = new Allocation();
    private Bootstrap bootbuffer = new Bootstrap();
    private short fattype;
    private long CountOfClusters;
    private long partSectOff;
    private long firstDataSector;
    private long firstRootDirSect;
    private long cwdDirCluster;
    private long dirPosition;
    public Bios_disk.imageDisk loadedDisk;
    public boolean created_successfully = true;

    static void convToDirFile(String filename, byte[] filearray) {
        int charidx = 0;
        int flen = filename.length();
        Arrays.fill(filearray, (byte)32);
        for (int i = 0; i < flen && charidx < 11; ++i) {
            if (filename.charAt(i) != '.') {
                filearray[charidx] = (byte)filename.charAt(i);
                ++charidx;
                continue;
            }
            charidx = 8;
        }
    }

    private long getClustFirstSect(long clustNum) {
        return (clustNum - 2L) * (long)this.bootbuffer.sectorspercluster + this.firstDataSector;
    }

    private long getClusterValue(long clustNum) {
        long fatoffset = 0L;
        long clustValue = 0L;
        switch (this.fattype) {
            case 0: {
                fatoffset = clustNum + clustNum / 2L;
                break;
            }
            case 1: {
                fatoffset = clustNum * 2L;
                break;
            }
            case 2: {
                fatoffset = clustNum * 4L;
            }
        }
        long fatsectnum = (long)this.bootbuffer.reservedsectors + fatoffset / (long)this.bootbuffer.bytespersector + this.partSectOff;
        long fatentoff = fatoffset % (long)this.bootbuffer.bytespersector;
        if (this.curFatSect != fatsectnum) {
            this.loadedDisk.Read_AbsoluteSector(fatsectnum, this.fatSectBuffer, 0);
            if (this.fattype == 0) {
                this.loadedDisk.Read_AbsoluteSector(fatsectnum + 1L, this.fatSectBuffer, 512);
            }
            this.curFatSect = fatsectnum;
        }
        switch (this.fattype) {
            case 0: {
                clustValue = this.pfatSectBuffer.readw((int)fatentoff);
                if ((clustNum & 1L) != 0L) {
                    clustValue >>= 4;
                    break;
                }
                clustValue &= 0xFFFL;
                break;
            }
            case 1: {
                clustValue = this.pfatSectBuffer.readw((int)fatentoff);
                break;
            }
            case 2: {
                clustValue = this.pfatSectBuffer.readd((int)fatentoff);
            }
        }
        return clustValue;
    }

    private void setClusterValue(long clustNum, long clustValue) {
        long fatoffset = 0L;
        switch (this.fattype) {
            case 0: {
                fatoffset = clustNum + clustNum / 2L;
                break;
            }
            case 1: {
                fatoffset = clustNum * 2L;
                break;
            }
            case 2: {
                fatoffset = clustNum * 4L;
            }
        }
        long fatsectnum = (long)this.bootbuffer.reservedsectors + fatoffset / (long)this.bootbuffer.bytespersector + this.partSectOff;
        long fatentoff = fatoffset % (long)this.bootbuffer.bytespersector;
        if (this.curFatSect != fatsectnum) {
            this.loadedDisk.Read_AbsoluteSector(fatsectnum, this.fatSectBuffer, 0);
            if (this.fattype == 0) {
                this.loadedDisk.Read_AbsoluteSector(fatsectnum + 1L, this.fatSectBuffer, 512);
            }
            this.curFatSect = fatsectnum;
        }
        switch (this.fattype) {
            case 0: {
                int tmpValue = this.pfatSectBuffer.readw((int)fatentoff);
                if ((clustNum & 1L) != 0L) {
                    clustValue &= 0xFFFL;
                    tmpValue &= 0xF;
                    tmpValue |= (int)(clustValue <<= 4);
                } else {
                    tmpValue &= 0xF000;
                    tmpValue |= (int)(clustValue &= 0xFFFL);
                }
                this.pfatSectBuffer.writew((int)fatentoff, tmpValue);
                break;
            }
            case 1: {
                this.pfatSectBuffer.writew((int)fatentoff, (int)clustValue);
                break;
            }
            case 2: {
                this.pfatSectBuffer.writed((int)fatentoff, clustValue);
            }
        }
        for (int fc = 0; fc < this.bootbuffer.fatcopies; ++fc) {
            this.loadedDisk.Write_AbsoluteSector(fatsectnum + (long)(fc * this.bootbuffer.sectorsperfat), this.fatSectBuffer, 0);
            if (this.fattype != 0 || fatentoff < 511L) continue;
            this.loadedDisk.Write_AbsoluteSector(fatsectnum + 1L + (long)(fc * this.bootbuffer.sectorsperfat), this.fatSectBuffer, 512);
        }
    }

    private String getEntryName(String fullname) {
        return new File(fullname).getName();
    }

    private boolean getFileDirEntry(String filename, DirEntry useEntry, LongRef dirClust, LongRef subEntry) {
        String[] parts = StringHelper.split(filename, "\\");
        long currentClust = 0L;
        DirEntry foundEntry = new DirEntry();
        String findFile = filename;
        if (!filename.endsWith("\\")) {
            for (int index = 0; parts.length > index; ++index) {
                Bios_disk.imgDTA.SetupSearch(0, 16, parts[index]);
                Bios_disk.imgDTA.SetDirID(0);
                findFile = parts[index];
                if (!this.FindNextInternal(currentClust, Bios_disk.imgDTA, foundEntry)) break;
                StringRef find_name = new StringRef();
                IntRef find_date = new IntRef(0);
                IntRef find_time = new IntRef(0);
                LongRef find_size = new LongRef(0L);
                ShortRef find_attr = new ShortRef();
                Bios_disk.imgDTA.GetResult(find_name, find_size, find_date, find_time, find_attr);
                if ((find_attr.value & 0x10) == 0) break;
                currentClust = foundEntry.loFirstClust;
            }
        }
        Bios_disk.imgDTA.SetupSearch(0, 7, findFile);
        Bios_disk.imgDTA.SetDirID(0);
        if (!this.FindNextInternal(currentClust, Bios_disk.imgDTA, foundEntry)) {
            return false;
        }
        useEntry.copy(foundEntry);
        dirClust.value = currentClust;
        subEntry.value = (long)Bios_disk.imgDTA.GetDirID() - 1L;
        return true;
    }

    private boolean getDirClustNum(String dir, LongRef clustNum, boolean parDir) {
        if (!dir.endsWith("\\")) {
            String[] parts = StringHelper.split(dir, "\\");
            long currentClust = 0L;
            DirEntry foundEntry = new DirEntry();
            for (int index = 0; parts.length > index; ++index) {
                Bios_disk.imgDTA.SetupSearch(0, 16, parts[index]);
                Bios_disk.imgDTA.SetDirID(0);
                if (parDir && index + 1 >= parts.length) break;
                if (!this.FindNextInternal(currentClust, Bios_disk.imgDTA, foundEntry)) {
                    return false;
                }
                StringRef find_name = new StringRef();
                IntRef find_date = new IntRef(0);
                IntRef find_time = new IntRef(0);
                LongRef find_size = new LongRef(0L);
                ShortRef find_attr = new ShortRef();
                Bios_disk.imgDTA.GetResult(find_name, find_size, find_date, find_time, find_attr);
                if ((find_attr.value & 0x10) == 0) {
                    return false;
                }
                currentClust = foundEntry.loFirstClust;
            }
            clustNum.value = currentClust;
        } else {
            clustNum.value = 0L;
        }
        return true;
    }

    public long getSectorSize() {
        return this.bootbuffer.bytespersector;
    }

    public long getAbsoluteSectFromBytePos(long startClustNum, long bytePos) {
        return this.getAbsoluteSectFromChain(startClustNum, bytePos / (long)this.bootbuffer.bytespersector);
    }

    public long getAbsoluteSectFromChain(long startClustNum, long logicalSector) {
        long sectClust = logicalSector % (long)this.bootbuffer.sectorspercluster;
        long currentClust = startClustNum;
        for (long skipClust = logicalSector / (long)this.bootbuffer.sectorspercluster; skipClust != 0L; --skipClust) {
            boolean isEOF = false;
            long testvalue = this.getClusterValue(currentClust);
            switch (this.fattype) {
                case 0: {
                    if (testvalue < 4088L) break;
                    isEOF = true;
                    break;
                }
                case 1: {
                    if (testvalue < 65528L) break;
                    isEOF = true;
                    break;
                }
                case 2: {
                    if (testvalue < 0xFFFFFFF8L) break;
                    isEOF = true;
                }
            }
            if (isEOF && skipClust >= 1L) {
                return 0L;
            }
            currentClust = testvalue;
        }
        return this.getClustFirstSect(currentClust) + sectClust;
    }

    public void deleteClustChain(long startCluster) {
        long testvalue;
        long currentClust = startCluster;
        boolean isEOF = false;
        while (!isEOF && (testvalue = this.getClusterValue(currentClust)) != 0L) {
            this.setClusterValue(currentClust, 0L);
            switch (this.fattype) {
                case 0: {
                    if (testvalue < 4088L) break;
                    isEOF = true;
                    break;
                }
                case 1: {
                    if (testvalue < 65528L) break;
                    isEOF = true;
                    break;
                }
                case 2: {
                    if (testvalue < 0xFFFFFFF8L) break;
                    isEOF = true;
                }
            }
            if (isEOF) break;
            currentClust = testvalue;
        }
    }

    public long appendCluster(long startCluster) {
        long newClust;
        long currentClust = startCluster;
        boolean isEOF = false;
        while (!isEOF) {
            long testvalue = this.getClusterValue(currentClust);
            switch (this.fattype) {
                case 0: {
                    if (testvalue < 4088L) break;
                    isEOF = true;
                    break;
                }
                case 1: {
                    if (testvalue < 65528L) break;
                    isEOF = true;
                    break;
                }
                case 2: {
                    if (testvalue < 0xFFFFFFF8L) break;
                    isEOF = true;
                }
            }
            if (isEOF) break;
            currentClust = testvalue;
        }
        if ((newClust = this.getFirstFreeClust()) == 0L) {
            return 0L;
        }
        if (!this.allocateCluster(newClust, currentClust)) {
            return 0L;
        }
        this.zeroOutCluster(newClust);
        return newClust;
    }

    public boolean allocateCluster(long useCluster, long prevCluster) {
        if (useCluster == 0L) {
            return false;
        }
        if (prevCluster != 0L) {
            if (this.getClusterValue(prevCluster) == 0L) {
                return false;
            }
            this.setClusterValue(prevCluster, useCluster);
        }
        switch (this.fattype) {
            case 0: {
                this.setClusterValue(useCluster, 4095L);
                break;
            }
            case 1: {
                this.setClusterValue(useCluster, 65535L);
                break;
            }
            case 2: {
                this.setClusterValue(useCluster, 0xFFFFFFFFL);
            }
        }
        return true;
    }

    public Drive_fat(String sysFilename, long bytesector, long cylsector, long headscyl, long cylinders, long startSector) {
        long filesize;
        FileIO diskfile;
        PartTable mbrData = new PartTable();
        if (Bios_disk.imgDTASeg == 0) {
            Bios_disk.imgDTASeg = Dos_tables.DOS_GetMemory(2);
            Bios_disk.imgDTAPtr = Memory.RealMake(Bios_disk.imgDTASeg, 0);
            Bios_disk.imgDTA = new Dos_DTA(Bios_disk.imgDTAPtr);
        }
        try {
            diskfile = FileIOFactory.open(sysFilename, 3);
            filesize = diskfile.length() / 1024L;
        }
        catch (Exception e) {
            this.created_successfully = false;
            return;
        }
        this.loadedDisk = new Bios_disk.imageDisk(diskfile, sysFilename, filesize, filesize > 2880L);
        byte[] d = new byte[(int)this.loadedDisk.sector_size];
        if (filesize > 2880L) {
            int m;
            this.loadedDisk.Set_Geometry(headscyl, cylinders, cylsector, bytesector);
            this.loadedDisk.Read_Sector(0L, 0L, 1L, d);
            mbrData.load(d);
            if (mbrData.magic1 != 85 || mbrData.magic2 != -86) {
                Log.log_msg("Possibly invalid partition table in disk image.");
            }
            startSector = 63L;
            for (m = 0; m < 4; ++m) {
                if (mbrData.pentry[m].partSize == 0L) continue;
                Log.log_msg("Using partition " + m + " on drive; skipping " + mbrData.pentry[m].absSectStart + " sectors");
                startSector = mbrData.pentry[m].absSectStart;
                break;
            }
            if (m == 4) {
                Log.log_msg("No good partiton found in image.");
            }
            this.partSectOff = startSector;
        } else {
            this.partSectOff = 0L;
        }
        this.loadedDisk.Read_AbsoluteSector(0L + this.partSectOff, d, 0);
        this.bootbuffer.load(d);
        if (this.bootbuffer.magic1 != 85 || this.bootbuffer.magic2 != -86) {
            Log.log_msg("Loaded image has no valid magicnumbers at the end!");
        }
        if (this.bootbuffer.sectorsperfat == 0) {
            this.created_successfully = false;
            return;
        }
        long RootDirSectors = (this.bootbuffer.rootdirentries * 32 + (this.bootbuffer.bytespersector - 1)) / this.bootbuffer.bytespersector;
        long DataSectors = this.bootbuffer.totalsectorcount != 0 ? (long)this.bootbuffer.totalsectorcount - ((long)(this.bootbuffer.reservedsectors + this.bootbuffer.fatcopies * this.bootbuffer.sectorsperfat) + RootDirSectors) : this.bootbuffer.totalsecdword - ((long)(this.bootbuffer.reservedsectors + this.bootbuffer.fatcopies * this.bootbuffer.sectorsperfat) + RootDirSectors);
        this.CountOfClusters = DataSectors / (long)this.bootbuffer.sectorspercluster;
        this.firstDataSector = (long)(this.bootbuffer.reservedsectors + this.bootbuffer.fatcopies * this.bootbuffer.sectorsperfat) + RootDirSectors + this.partSectOff;
        this.firstRootDirSect = (long)(this.bootbuffer.reservedsectors + this.bootbuffer.fatcopies * this.bootbuffer.sectorsperfat) + this.partSectOff;
        if (this.CountOfClusters < 4085L) {
            Log.log_msg("Mounted FAT volume is FAT12 with " + this.CountOfClusters + " clusters");
            this.fattype = 0;
        } else if (this.CountOfClusters < 65525L) {
            Log.log_msg("Mounted FAT volume is FAT16 with " + this.CountOfClusters + " clusters");
            this.fattype = 1;
        } else {
            Log.log_msg("Mounted FAT volume is FAT32 with " + this.CountOfClusters + " clusters");
            this.fattype = (short)2;
        }
        this.cwdDirCluster = 0L;
        this.curFatSect = 0xFFFFFFFFL;
    }

    public boolean AllocationInfo(IntRef _bytes_sector, ShortRef _sectors_cluster, IntRef _total_clusters, IntRef _free_clusters) {
        LongRef hs = new LongRef(0L);
        LongRef cy = new LongRef(0L);
        LongRef sect = new LongRef(0L);
        LongRef sectsize = new LongRef(0L);
        long countFree = 0L;
        this.loadedDisk.Get_Geometry(hs, cy, sect, sectsize);
        _bytes_sector.value = (int)sectsize.value;
        _sectors_cluster.value = this.bootbuffer.sectorspercluster;
        _total_clusters.value = this.CountOfClusters < 65536L ? (int)this.CountOfClusters : -1;
        for (long i = 0L; i < this.CountOfClusters; ++i) {
            if (this.getClusterValue(i + 2L) != 0L) continue;
            ++countFree;
        }
        _free_clusters.value = countFree < 65536L ? (int)countFree : 65535;
        return true;
    }

    public long getFirstFreeClust() {
        for (long i = 0L; i < this.CountOfClusters; ++i) {
            if (this.getClusterValue(i + 2L) != 0L) continue;
            return i + 2L;
        }
        return 0L;
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isRemovable() {
        return false;
    }

    public int UnMount() {
        return 0;
    }

    public short GetMediaByte() {
        return this.loadedDisk.GetBiosType();
    }

    public DOS_File FileCreate(String name, int attributes) {
        DirEntry fileEntry = new DirEntry();
        LongRef dirClust = new LongRef(0L);
        LongRef subEntry = new LongRef(0L);
        byte[] pathName = new byte[11];
        int save_errorcode = Dos.dos.errorcode;
        if (this.getFileDirEntry(name, fileEntry, dirClust, subEntry)) {
            fileEntry.entrysize = 0L;
            this.directoryChange(dirClust.value, fileEntry, (int)subEntry.value);
        } else {
            String dirName = this.getEntryName(name);
            if (dirName == null) {
                return null;
            }
            Drive_fat.convToDirFile(dirName, pathName);
            if (!this.getDirClustNum(name, dirClust, true)) {
                return null;
            }
            fileEntry = new DirEntry();
            fileEntry.entryname = pathName;
            fileEntry.attrib = (short)(attributes & 0xFF);
            this.addDirectoryEntry(dirClust.value, fileEntry);
            if (!this.getFileDirEntry(name, fileEntry, dirClust, subEntry)) {
                return null;
            }
        }
        fatFile file = new fatFile(name, fileEntry.loFirstClust, fileEntry.entrysize, this);
        file.flags = 2L;
        file.dirCluster = dirClust.value;
        file.dirIndex = subEntry.value;
        file.time = fileEntry.crtTime;
        file.date = fileEntry.crtDate;
        Dos.dos.errorcode = save_errorcode;
        return file;
    }

    public boolean FileExists(String name) {
        DirEntry fileEntry = new DirEntry();
        LongRef dummy1 = new LongRef(0L);
        LongRef dummy2 = new LongRef(0L);
        return this.getFileDirEntry(name, fileEntry, dummy1, dummy2);
    }

    public DOS_File FileOpen(String name, int flags) {
        DirEntry fileEntry = new DirEntry();
        LongRef dirClust = new LongRef(0L);
        LongRef subEntry = new LongRef(0L);
        if (!this.getFileDirEntry(name, fileEntry, dirClust, subEntry)) {
            return null;
        }
        fatFile file = new fatFile(name, fileEntry.loFirstClust, fileEntry.entrysize, this);
        file.flags = flags;
        file.dirCluster = dirClust.value;
        file.dirIndex = subEntry.value;
        file.time = fileEntry.crtTime;
        file.date = fileEntry.crtDate;
        return file;
    }

    public boolean FileStat(String name, FileStat_Block stat_block) {
        return false;
    }

    public boolean FileUnlink(String name) {
        DirEntry fileEntry = new DirEntry();
        LongRef dirClust = new LongRef(0L);
        LongRef subEntry = new LongRef(0L);
        if (!this.getFileDirEntry(name, fileEntry, dirClust, subEntry)) {
            return false;
        }
        fileEntry.entryname[0] = -27;
        this.directoryChange(dirClust.value, fileEntry, (int)subEntry.value);
        if (fileEntry.loFirstClust != 0) {
            this.deleteClustChain(fileEntry.loFirstClust);
        }
        return true;
    }

    public boolean FindFirst(String _dir, Dos_DTA dta, boolean fcb_findfirst) {
        LongRef c;
        ShortRef attr = new ShortRef();
        StringRef pattern = new StringRef();
        dta.GetSearchParams(attr, pattern);
        if (attr.value == 8) {
            if (this.GetLabel().length() == 0) {
                Dos.DOS_SetError(18);
                return false;
            }
            dta.SetResult(this.GetLabel(), 0L, 0, 0, (short)8);
            return true;
        }
        if ((attr.value & 8) != 0) {
            Log.log(14, 1, "findfirst for volumelabel used on fatDrive. Unhandled!!!!!");
        }
        if (!this.getDirClustNum(_dir, c = new LongRef(this.cwdDirCluster), false)) {
            Dos.DOS_SetError(3);
            return false;
        }
        this.cwdDirCluster = c.value;
        dta.SetDirID(0);
        dta.SetDirIDCluster((int)(this.cwdDirCluster & 0xFFFFL));
        DirEntry dummyClust = new DirEntry();
        return this.FindNextInternal(this.cwdDirCluster, dta, dummyClust);
    }

    private boolean FindNextInternal(long dirClustNumber, Dos_DTA dta, DirEntry foundEntry) {
        int entryoffset;
        DirEntry[] sectbuf = new DirEntry[16];
        ShortRef attrs = new ShortRef();
        StringRef srch_pattern = new StringRef();
        byte[] d = new byte[(int)this.loadedDisk.sector_size];
        dta.GetSearchParams(attrs, srch_pattern);
        int dirPos = dta.GetDirID();
        for (int i = 0; i < sectbuf.length; ++i) {
            sectbuf[i] = new DirEntry();
        }
        String find_name = "";
        while (true) {
            long logentsector = dirPos / 16;
            entryoffset = dirPos % 16;
            if (dirClustNumber == 0L) {
                this.loadedDisk.Read_AbsoluteSector(this.firstRootDirSect + logentsector, d, 0);
            } else {
                long tmpsector = this.getAbsoluteSectFromChain(dirClustNumber, logentsector);
                if (tmpsector == 0L) {
                    Dos.DOS_SetError(18);
                    return false;
                }
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            }
            for (int i = 0; i < sectbuf.length; ++i) {
                sectbuf[i].load(d, i * 32);
            }
            dta.SetDirID(++dirPos);
            if (sectbuf[entryoffset].entryname[0] == -27) continue;
            if (sectbuf[entryoffset].entryname[0] == 0) {
                Dos.DOS_SetError(18);
                return false;
            }
            find_name = StringHelper.toString(sectbuf[entryoffset].entryname, 0, 8).trim();
            if ((sectbuf[entryoffset].attrib & 0x10) == 0 || sectbuf[entryoffset].entryname[8] != 32) {
                find_name = find_name + ".";
                find_name = find_name + StringHelper.toString(sectbuf[entryoffset].entryname, 8, 3).trim();
            }
            if ((sectbuf[entryoffset].attrib & 8) == 0 && (~attrs.value & sectbuf[entryoffset].attrib & 0x16) == 0 && Drives.WildFileCmp(find_name, srch_pattern.value)) break;
        }
        dta.SetResult(find_name, sectbuf[entryoffset].entrysize, sectbuf[entryoffset].crtDate, sectbuf[entryoffset].crtTime, sectbuf[entryoffset].attrib);
        foundEntry.copy(sectbuf[entryoffset]);
        return true;
    }

    public boolean FindNext(Dos_DTA dta) {
        DirEntry dummyClust = new DirEntry();
        return this.FindNextInternal(dta.GetDirIDCluster(), dta, dummyClust);
    }

    public boolean GetFileAttr(String name, IntRef attr) {
        DirEntry fileEntry = new DirEntry();
        LongRef dirClust = new LongRef(0L);
        LongRef subEntry = new LongRef(0L);
        if (!this.getFileDirEntry(name, fileEntry, dirClust, subEntry)) {
            byte[] pathName = new byte[11];
            String dirName = this.getEntryName(name);
            if (dirName == null) {
                return false;
            }
            Drive_fat.convToDirFile(dirName, pathName);
            if (!this.getDirClustNum(name, dirClust, true)) {
                return false;
            }
            int fileidx = 2;
            if (dirClust.value == 0L) {
                fileidx = 0;
            }
            while (this.directoryBrowse(dirClust.value, fileEntry, fileidx)) {
                if (StringHelper.memcmp(fileEntry.entryname, pathName, 11) == 0) {
                    attr.value = fileEntry.attrib;
                    return true;
                }
                ++fileidx;
            }
            return false;
        }
        attr.value = fileEntry.attrib;
        return true;
    }

    public boolean directoryBrowse(long dirClustNumber, DirEntry useEntry, int entNum) {
        DirEntry[] sectbuf = new DirEntry[16];
        int entryoffset = 0;
        int dirPos = 0;
        for (int i = 0; i < sectbuf.length; ++i) {
            sectbuf[i] = new DirEntry();
        }
        byte[] d = new byte[(int)this.loadedDisk.sector_size];
        while (entNum >= 0) {
            long tmpsector;
            long logentsector = dirPos / 16;
            entryoffset = dirPos % 16;
            if (dirClustNumber == 0L) {
                if (dirPos >= this.bootbuffer.rootdirentries) {
                    return false;
                }
                tmpsector = this.firstRootDirSect + logentsector;
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            } else {
                tmpsector = this.getAbsoluteSectFromChain(dirClustNumber, logentsector);
                if (tmpsector == 0L) {
                    return false;
                }
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            }
            for (int i = 0; i < sectbuf.length; ++i) {
                sectbuf[i].load(d, i * 32);
            }
            ++dirPos;
            if (sectbuf[entryoffset].entryname[0] == 0) {
                return false;
            }
            --entNum;
        }
        useEntry.copy(sectbuf[entryoffset]);
        return true;
    }

    public boolean directoryChange(long dirClustNumber, DirEntry useEntry, int entNum) {
        DirEntry[] sectbuf = new DirEntry[16];
        int entryoffset = 0;
        long tmpsector = 0L;
        int dirPos = 0;
        for (int i = 0; i < sectbuf.length; ++i) {
            sectbuf[i] = new DirEntry();
        }
        byte[] d = new byte[(int)this.loadedDisk.sector_size];
        while (entNum >= 0) {
            long logentsector = dirPos / 16;
            entryoffset = dirPos % 16;
            if (dirClustNumber == 0L) {
                if (dirPos >= this.bootbuffer.rootdirentries) {
                    return false;
                }
                tmpsector = this.firstRootDirSect + logentsector;
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            } else {
                tmpsector = this.getAbsoluteSectFromChain(dirClustNumber, logentsector);
                if (tmpsector == 0L) {
                    return false;
                }
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            }
            for (int i = 0; i < sectbuf.length; ++i) {
                sectbuf[i].load(d, i * 32);
            }
            ++dirPos;
            if (sectbuf[entryoffset].entryname[0] == 0) {
                return false;
            }
            --entNum;
        }
        if (tmpsector != 0L) {
            useEntry.save(d, entryoffset * 32);
            this.loadedDisk.Write_AbsoluteSector(tmpsector, d, 0);
            return true;
        }
        return false;
    }

    private boolean addDirectoryEntry(long dirClustNumber, DirEntry useEntry) {
        long tmpsector;
        int entryoffset;
        DirEntry[] sectbuf = new DirEntry[16];
        int dirPos = 0;
        for (int i = 0; i < sectbuf.length; ++i) {
            sectbuf[i] = new DirEntry();
        }
        byte[] d = new byte[(int)this.loadedDisk.sector_size];
        do {
            long logentsector = dirPos / 16;
            entryoffset = dirPos % 16;
            if (dirClustNumber == 0L) {
                if (dirPos >= this.bootbuffer.rootdirentries) {
                    return false;
                }
                tmpsector = this.firstRootDirSect + logentsector;
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            } else {
                tmpsector = this.getAbsoluteSectFromChain(dirClustNumber, logentsector);
                if (tmpsector == 0L) {
                    long newClust = this.appendCluster(dirClustNumber);
                    if (newClust == 0L) {
                        return false;
                    }
                    tmpsector = this.getAbsoluteSectFromChain(dirClustNumber, logentsector);
                    if (tmpsector == 0L) {
                        return false;
                    }
                }
                this.loadedDisk.Read_AbsoluteSector(tmpsector, d, 0);
            }
            for (int i = 0; i < sectbuf.length; ++i) {
                sectbuf[i].load(d, i * 32);
            }
            ++dirPos;
        } while (sectbuf[entryoffset].entryname[0] != -27 && sectbuf[entryoffset].entryname[0] != 0);
        useEntry.save(d, entryoffset * 32);
        this.loadedDisk.Write_AbsoluteSector(tmpsector, d, 0);
        return true;
    }

    private void zeroOutCluster(long clustNumber) {
        byte[] secBuffer = new byte[512];
        for (int i = 0; i < this.bootbuffer.sectorspercluster; ++i) {
            this.loadedDisk.Write_AbsoluteSector(this.getAbsoluteSectFromChain(clustNumber, i), secBuffer, 0);
        }
    }

    public boolean MakeDir(String dir) {
        LongRef dummyClust = new LongRef(0L);
        LongRef dirClust = new LongRef(0L);
        DirEntry tmpentry = new DirEntry();
        byte[] pathName = new byte[11];
        String dirName = this.getEntryName(dir);
        if (dirName == null) {
            return false;
        }
        Drive_fat.convToDirFile(dirName, pathName);
        if (this.getDirClustNum(dir, dummyClust, false)) {
            return false;
        }
        dummyClust.value = this.getFirstFreeClust();
        if (dummyClust.value == 0L) {
            return false;
        }
        if (!this.allocateCluster(dummyClust.value, 0L)) {
            return false;
        }
        this.zeroOutCluster(dummyClust.value);
        if (!this.getDirClustNum(dir, dirClust, true)) {
            return false;
        }
        tmpentry.entryname = pathName;
        tmpentry.loFirstClust = (int)(dummyClust.value & 0xFFFFL);
        tmpentry.hiFirstClust = (int)(dummyClust.value >>> 16);
        tmpentry.attrib = (short)16;
        this.addDirectoryEntry(dirClust.value, tmpentry);
        tmpentry = new DirEntry();
        tmpentry.entryname = ".          ".getBytes();
        tmpentry.loFirstClust = (int)(dummyClust.value & 0xFFFFL);
        tmpentry.hiFirstClust = (int)(dummyClust.value >>> 16);
        tmpentry.attrib = (short)16;
        this.addDirectoryEntry(dummyClust.value, tmpentry);
        tmpentry = new DirEntry();
        tmpentry.entryname = "..         ".getBytes();
        tmpentry.loFirstClust = (int)(dirClust.value & 0xFFFFL);
        tmpentry.hiFirstClust = (int)(dirClust.value >>> 16);
        tmpentry.attrib = (short)16;
        this.addDirectoryEntry(dummyClust.value, tmpentry);
        return true;
    }

    public boolean RemoveDir(String dir) {
        LongRef dummyClust = new LongRef(0L);
        LongRef dirClust = new LongRef(0L);
        DirEntry tmpentry = new DirEntry();
        byte[] pathName = new byte[11];
        String dirName = this.getEntryName(dir);
        if (dirName == null) {
            return false;
        }
        Drive_fat.convToDirFile(dirName, pathName);
        if (!this.getDirClustNum(dir, dummyClust, false)) {
            return false;
        }
        if (dummyClust.value == 0L) {
            return false;
        }
        if (!this.getDirClustNum(dir, dirClust, true)) {
            return false;
        }
        long filecount = 0L;
        int fileidx = 2;
        while (this.directoryBrowse(dummyClust.value, tmpentry, fileidx)) {
            if (tmpentry.entryname[0] != -27) {
                ++filecount;
            }
            ++fileidx;
        }
        if (filecount > 0L) {
            return false;
        }
        fileidx = dirClust.value == 0L ? 0 : 2;
        boolean found = false;
        while (this.directoryBrowse(dirClust.value, tmpentry, fileidx)) {
            if (StringHelper.memcmp(tmpentry.entryname, pathName, 11) == 0) {
                found = true;
                tmpentry.entryname[0] = -27;
                this.directoryChange(dirClust.value, tmpentry, fileidx);
                this.deleteClustChain(dummyClust.value);
                break;
            }
            ++fileidx;
        }
        return found;
    }

    public boolean Rename(String oldname, String newname) {
        DirEntry fileEntry1 = new DirEntry();
        LongRef dirClust1 = new LongRef(0L);
        LongRef subEntry1 = new LongRef(0L);
        if (!this.getFileDirEntry(oldname, fileEntry1, dirClust1, subEntry1)) {
            return false;
        }
        DirEntry fileEntry2 = new DirEntry();
        LongRef dirClust2 = new LongRef(0L);
        LongRef subEntry2 = new LongRef(0L);
        if (!this.getFileDirEntry(newname, fileEntry2, dirClust2, subEntry2)) {
            byte[] pathName2 = new byte[11];
            String dirName2 = this.getEntryName(newname);
            if (dirName2 == null) {
                return false;
            }
            Drive_fat.convToDirFile(dirName2, pathName2);
            if (!this.getDirClustNum(newname, dirClust2, true)) {
                return false;
            }
            fileEntry2.copy(fileEntry1);
            fileEntry2.entryname = pathName2;
            this.addDirectoryEntry(dirClust2.value, fileEntry2);
            if (!this.getFileDirEntry(newname, fileEntry2, dirClust2, subEntry2)) {
                return false;
            }
            fileEntry1.entryname[0] = -27;
            this.directoryChange(dirClust1.value, fileEntry1, (int)subEntry1.value);
            return true;
        }
        return false;
    }

    public boolean TestDir(String dir) {
        LongRef dummyClust = new LongRef(0L);
        return this.getDirClustNum(dir, dummyClust, false);
    }

    private static class Allocation {
        int bytes_sector;
        short sectors_cluster;
        int total_clusters;
        int free_clusters;
        short mediaid;

        private Allocation() {
        }
    }

    private static class fatFile
    extends DOS_File {
        public long firstCluster;
        public long seekpos;
        public long filelength;
        public long currentSector;
        public int curSectOff;
        public byte[] sectorBuffer = new byte[512];
        public long dirCluster;
        public long dirIndex;
        public boolean loadedSector;
        public Drive_fat myDrive;
        private static final int NONE = 0;
        private static final int READ = 1;
        private static final int WRITE = 2;
        private int last_action;
        private int info;

        public fatFile(String name, long startCluster, long fileLen, Drive_fat useDrive) {
            LongRef seekto = new LongRef(0L);
            this.firstCluster = startCluster;
            this.myDrive = useDrive;
            this.filelength = fileLen;
            this.open = true;
            this.loadedSector = false;
            this.curSectOff = 0;
            this.seekpos = 0L;
            if (this.filelength > 0L) {
                this.Seek(seekto, 0);
                this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                this.loadedSector = true;
            }
        }

        public boolean Read(byte[] data, IntRef size) {
            if ((this.flags & 0xFL) == 1L) {
                Dos.DOS_SetError(5);
                return false;
            }
            if (this.seekpos >= this.filelength) {
                size.value = 0;
                return true;
            }
            if (!this.loadedSector) {
                this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                if (this.currentSector == 0L) {
                    size.value = 0;
                    this.loadedSector = false;
                    return true;
                }
                this.curSectOff = 0;
                this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                this.loadedSector = true;
            }
            int sizecount = 0;
            for (int sizedec = size.value; sizedec != 0; --sizedec) {
                if (this.seekpos >= this.filelength) {
                    size.value = sizecount;
                    return true;
                }
                data[sizecount++] = this.sectorBuffer[this.curSectOff++];
                ++this.seekpos;
                if ((long)this.curSectOff < this.myDrive.getSectorSize()) continue;
                this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                if (this.currentSector == 0L) {
                    size.value = sizecount;
                    this.loadedSector = false;
                    return true;
                }
                this.curSectOff = 0;
                this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                this.loadedSector = true;
            }
            size.value = sizecount;
            return true;
        }

        public boolean Write(byte[] data, IntRef size) {
            if ((this.flags & 0xFL) == 0L) {
                Dos.DOS_SetError(5);
                return false;
            }
            DirEntry tmpentry = new DirEntry();
            int sizecount = 0;
            boolean finalizeWrite = false;
            for (int sizedec = size.value; sizedec != 0; --sizedec) {
                if (this.seekpos >= this.filelength) {
                    if (this.filelength == 0L) {
                        this.firstCluster = this.myDrive.getFirstFreeClust();
                        this.myDrive.allocateCluster(this.firstCluster, 0L);
                        this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                        this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                        this.loadedSector = true;
                    }
                    this.filelength = this.seekpos + 1L;
                    if (!this.loadedSector) {
                        this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                        if (this.currentSector == 0L) {
                            this.myDrive.appendCluster(this.firstCluster);
                            this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                            if (this.currentSector == 0L) {
                                finalizeWrite = true;
                                break;
                            }
                        }
                        this.curSectOff = 0;
                        this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                        this.loadedSector = true;
                    }
                }
                this.sectorBuffer[this.curSectOff++] = data[sizecount++];
                ++this.seekpos;
                if ((long)this.curSectOff < this.myDrive.getSectorSize()) continue;
                if (this.loadedSector) {
                    this.myDrive.loadedDisk.Write_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                }
                this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                if (this.currentSector == 0L) {
                    this.myDrive.appendCluster(this.firstCluster);
                    this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
                    if (this.currentSector == 0L) {
                        this.loadedSector = false;
                        finalizeWrite = true;
                        break;
                    }
                }
                this.curSectOff = 0;
                this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
                this.loadedSector = true;
            }
            if (!finalizeWrite && this.curSectOff > 0 && this.loadedSector) {
                this.myDrive.loadedDisk.Write_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
            }
            this.myDrive.directoryBrowse(this.dirCluster, tmpentry, (int)this.dirIndex);
            tmpentry.entrysize = this.filelength;
            tmpentry.loFirstClust = (int)this.firstCluster;
            this.myDrive.directoryChange(this.dirCluster, tmpentry, (int)this.dirIndex);
            size.value = sizecount;
            return true;
        }

        public boolean Seek(LongRef pos, int type) {
            int seekto = 0;
            switch (type) {
                case 0: {
                    seekto = (int)pos.value;
                    break;
                }
                case 1: {
                    seekto = (int)pos.value + (int)this.seekpos;
                    break;
                }
                case 2: {
                    seekto = (int)this.filelength + (int)pos.value;
                }
            }
            if ((long)seekto > this.filelength) {
                seekto = (int)this.filelength;
            }
            if (seekto < 0) {
                seekto = 0;
            }
            this.seekpos = seekto;
            this.currentSector = this.myDrive.getAbsoluteSectFromBytePos(this.firstCluster, this.seekpos);
            if (this.currentSector == 0L) {
                this.loadedSector = false;
            } else {
                this.curSectOff = (int)(this.seekpos % this.myDrive.getSectorSize());
                this.myDrive.loadedDisk.Read_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
            }
            pos.value = this.seekpos;
            return true;
        }

        public boolean Close() {
            if (this.loadedSector) {
                this.myDrive.loadedDisk.Write_AbsoluteSector(this.currentSector, this.sectorBuffer, 0);
            }
            return false;
        }

        public int GetInformation() {
            return 0;
        }

        public boolean UpdateDateTimeFromHost() {
            return true;
        }
    }
}

