/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos.drives;

import jdos.dos.DOS_File;
import jdos.dos.Dos;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_Drive;
import jdos.dos.Drives;
import jdos.dos.FileStat_Block;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringRef;

public class Drive_virtual
extends Dos_Drive {
    private static VFILE_Block first_file;
    private VFILE_Block search_file;

    public static void VFILE_Register(String name, byte[] data, int len) {
        VFILE_Block new_file = new VFILE_Block();
        new_file.name = name;
        new_file.data = data;
        new_file.size = len;
        new_file.date = Dos.DOS_PackDate(2002, 10, 1);
        new_file.time = Dos.DOS_PackTime(12, 34, 56);
        new_file.next = first_file;
        first_file = new_file;
    }

    public static void VFILE_Remove(String name) {
        VFILE_Block chan = first_file;
        VFILE_Block where = first_file;
        while (chan != null) {
            if (name.equals(chan.name)) {
                where.next = chan.next;
                if (chan == first_file) {
                    first_file = chan.next;
                }
                return;
            }
            where = chan;
            chan = chan.next;
        }
    }

    public Drive_virtual() {
        this.info = "Internal Virtual Drive";
    }

    public DOS_File FileOpen(String name, int flags) {
        VFILE_Block cur_file = first_file;
        while (cur_file != null) {
            if (name.compareToIgnoreCase(cur_file.name) == 0) {
                Virtual_File file = new Virtual_File(cur_file.data, cur_file.size);
                file.flags = flags;
                return file;
            }
            cur_file = cur_file.next;
        }
        return null;
    }

    public DOS_File FileCreate(String name, int attributes) {
        return null;
    }

    public boolean FileUnlink(String _name) {
        return false;
    }

    public boolean RemoveDir(String _dir) {
        return false;
    }

    public boolean MakeDir(String _dir) {
        return false;
    }

    public boolean TestDir(String _dir) {
        return _dir.length() == 0;
    }

    public boolean FindFirst(String _dir, Dos_DTA dta, boolean fcb_findfirst) {
        this.search_file = first_file;
        ShortRef attr = new ShortRef();
        StringRef pattern = new StringRef();
        dta.GetSearchParams(attr, pattern);
        if (attr.value == 8) {
            dta.SetResult("DOSBOX", 0L, 0, 0, (short)8);
            return true;
        }
        if ((attr.value & 8) != 0 && !fcb_findfirst && Drives.WildFileCmp("DOSBOX", pattern.value)) {
            dta.SetResult("DOSBOX", 0L, 0, 0, (short)8);
            return true;
        }
        return this.FindNext(dta);
    }

    public boolean FindNext(Dos_DTA dta) {
        ShortRef attr = new ShortRef();
        StringRef pattern = new StringRef();
        dta.GetSearchParams(attr, pattern);
        while (this.search_file != null) {
            if (Drives.WildFileCmp(this.search_file.name, pattern.value)) {
                dta.SetResult(this.search_file.name, this.search_file.size, this.search_file.date, this.search_file.time, (short)32);
                this.search_file = this.search_file.next;
                return true;
            }
            this.search_file = this.search_file.next;
        }
        Dos.DOS_SetError(18);
        return false;
    }

    public boolean GetFileAttr(String name, IntRef attr) {
        VFILE_Block cur_file = first_file;
        while (cur_file != null) {
            if (name.compareToIgnoreCase(cur_file.name) == 0) {
                attr.value = 32;
                return true;
            }
            cur_file = cur_file.next;
        }
        return false;
    }

    public boolean Rename(String oldname, String newname) {
        return false;
    }

    public boolean AllocationInfo(IntRef _bytes_sector, ShortRef _sectors_cluster, IntRef _total_clusters, IntRef _free_clusters) {
        _bytes_sector.value = 512;
        _sectors_cluster.value = (short)127;
        _total_clusters.value = 16513;
        _free_clusters.value = 0;
        return true;
    }

    public boolean FileExists(String name) {
        VFILE_Block cur_file = first_file;
        while (cur_file != null) {
            if (name.compareToIgnoreCase(cur_file.name) == 0) {
                return true;
            }
            cur_file = cur_file.next;
        }
        return false;
    }

    public boolean FileStat(String name, FileStat_Block stat_block) {
        VFILE_Block cur_file = first_file;
        while (cur_file != null) {
            if (name.compareToIgnoreCase(cur_file.name) == 0) {
                stat_block.attr = 32;
                stat_block.size = cur_file.size;
                stat_block.date = Dos.DOS_PackDate(2002, 10, 1);
                stat_block.time = Dos.DOS_PackTime(12, 34, 56);
                return true;
            }
            cur_file = cur_file.next;
        }
        return false;
    }

    public short GetMediaByte() {
        return 248;
    }

    public void EmptyCache() {
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isRemovable() {
        return false;
    }

    public int UnMount() {
        first_file = null;
        return 1;
    }

    private static class Virtual_File
    extends DOS_File {
        private int file_size;
        private int file_pos;
        private byte[] file_data;

        public Virtual_File(byte[] in_data, long in_size) {
            this.file_size = (int)in_size;
            this.file_data = in_data;
            this.file_pos = 0;
            this.date = Dos.DOS_PackDate(2002, 10, 1);
            this.time = Dos.DOS_PackTime(12, 34, 56);
            this.open = true;
        }

        public boolean Read(byte[] data, IntRef size) {
            int left = this.file_size - this.file_pos;
            if (left <= size.value) {
                System.arraycopy(this.file_data, this.file_pos, data, 0, left);
                size.value = left;
            } else {
                System.arraycopy(this.file_data, this.file_pos, data, 0, size.value);
            }
            this.file_pos += size.value;
            return true;
        }

        public boolean Write(byte[] data, IntRef size) {
            return false;
        }

        public boolean Seek(LongRef new_pos, int type) {
            switch (type) {
                case 0: {
                    if (new_pos.value <= (long)this.file_size) {
                        this.file_pos = (int)new_pos.value;
                        break;
                    }
                    return false;
                }
                case 1: {
                    if (new_pos.value + (long)this.file_pos <= (long)this.file_size) {
                        this.file_pos = (int)(new_pos.value + (long)this.file_pos);
                        break;
                    }
                    return false;
                }
                case 2: {
                    if (new_pos.value <= (long)this.file_size) {
                        this.file_pos = (int)((long)this.file_size - new_pos.value);
                        break;
                    }
                    return false;
                }
            }
            new_pos.value = this.file_pos;
            return true;
        }

        public boolean Close() {
            return true;
        }

        public int GetInformation() {
            return 64;
        }
    }

    private static class VFILE_Block {
        String name;
        byte[] data;
        long size;
        int date;
        int time;
        VFILE_Block next;

        private VFILE_Block() {
        }
    }
}

