/*
 * Decompiled with CFR 0.152.
 */
package jdos.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jdos.Dosbox;
import jdos.gui.Main;
import jdos.gui.Render;
import jdos.ints.Mouse;
import jdos.sdl.GUI;

public class MainFrame
implements GUI {
    int[] pixels = new int[256];
    Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, this.pixels, 0, 16));
    Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.image, new Point(0, 0), "invisibleCursor");
    static Robot robot;
    private static boolean eatNextMouseMove;
    private static int last_x;
    private static int last_y;
    private static boolean fullscreen;
    private static int fullscreen_cx;
    private static int fullscreen_cy;
    private static int fullscreen_cx_offset;
    private static int cx;
    private static int cy;
    static BufferedImage tmpImage;
    private static Thread mainThread;
    private static JFrame frame;
    private static JPanel panel;

    public void showProgress(String msg, int percent) {
    }

    public static void robotMouse(MouseEvent e, Point rel, int offX, int offY) {
        if (eatNextMouseMove) {
            last_x = e.getX() - offX;
            last_y = e.getY() - offY;
            eatNextMouseMove = false;
            return;
        }
        if (!Main.mouse_locked || robot == null) {
            Main.addEvent(new Main.MouseEvent1(e, offX, offY));
        } else {
            int rel_x = e.getX() - last_x - offX;
            int rel_y = e.getY() - last_y - offY;
            float abs_x = (Mouse.mouse.x + (float)rel_x * Main.mouse_sensitivity / 100.0f) / (float)Mouse.mouse.max_x;
            float abs_y = (Mouse.mouse.y + (float)rel_y * Main.mouse_sensitivity / 100.0f) / (float)Mouse.mouse.max_y;
            Main.addEvent(new Main.MouseEvent2(e, rel_x, rel_y, abs_x, abs_y, offX, offY));
            MainFrame.robotCenter(rel);
        }
    }

    public static void robotCenter(Point rel) {
        eatNextMouseMove = true;
        robot.mouseMove(rel.x + 200, rel.y + 200);
    }

    public void captureMouse(boolean on) {
        if (robot != null) {
            MainFrame.robotCenter(panel.getLocationOnScreen());
        }
    }

    public void showCursor(boolean on) {
        if (on) {
            frame.setCursor(Cursor.getDefaultCursor());
        } else {
            frame.setCursor(this.transparentCursor);
        }
    }

    public void fullScreenToggle() {
        if (fullscreen) {
            frame.setVisible(false);
            fullscreen = false;
            frame.setUndecorated(false);
            frame.setExtendedState(0);
            this.setSize(cx, cy);
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            fullscreen_cx = (int)tk.getScreenSize().getWidth();
            fullscreen_cy = (int)tk.getScreenSize().getHeight();
            frame.setVisible(false);
            frame.setUndecorated(true);
            frame.setResizable(false);
            frame.setExtendedState(6);
            this.setSize(fullscreen_cx, fullscreen_cy);
            fullscreen_cx_offset = 0;
            if ((double)((float)fullscreen_cx / (float)fullscreen_cy) > 1.3333333333333333) {
                int new_fullscreen_cx = fullscreen_cy * 4 / 3;
                fullscreen_cx_offset = (fullscreen_cx - new_fullscreen_cx) / 2;
                fullscreen_cx = new_fullscreen_cx;
            }
            fullscreen = true;
        }
    }

    public void setSize(int width, int height) {
        cx = width;
        cy = height;
        if (fullscreen) {
            return;
        }
        panel.setMinimumSize(new Dimension(width, height));
        panel.setMaximumSize(new Dimension(width, height));
        panel.setPreferredSize(new Dimension(width, height));
        frame.getContentPane().doLayout();
        frame.pack();
        if (!frame.isVisible()) {
            frame.setVisible(true);
        }
    }

    public void dopaint() {
        panel.repaint();
    }

    public void setTitle(String title) {
        if (frame != null) {
            frame.setTitle(title);
        }
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage resizeImage(BufferedImage source, int destWidth, int destHeight, Object interpolation) {
        if (source == null) {
            throw new NullPointerException("source image is NULL!");
        }
        if (destWidth <= 0 && destHeight <= 0) {
            throw new IllegalArgumentException("destination width & height are both <=0!");
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        double xScale = (double)destWidth / (double)sourceWidth;
        double yScale = (double)destHeight / (double)sourceHeight;
        if (destWidth <= 0) {
            xScale = yScale;
            destWidth = (int)Math.rint(xScale * (double)sourceWidth);
        }
        if (destHeight <= 0) {
            yScale = xScale;
            destHeight = (int)Math.rint(yScale * (double)sourceHeight);
        }
        if (tmpImage == null) {
            try {
                GraphicsConfiguration gc = MainFrame.getDefaultConfiguration();
                tmpImage = gc.createCompatibleImage(destWidth, destHeight, source.getColorModel().getTransparency());
            }
            catch (Throwable e) {
                tmpImage = new BufferedImage(destWidth, destHeight, source.getColorModel().getTransparency());
            }
        }
        Graphics2D g2d = null;
        try {
            g2d = tmpImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
            AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
            g2d.drawRenderedImage(source, at);
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
        return tmpImage;
    }

    public static void main(final String[] args) {
        if (args.length > 1 && args[0].equalsIgnoreCase("-pcap")) {
            String nic = args[1];
            int port = 15654;
            if (args.length > 3 && args[2].equalsIgnoreCase("-pcapport")) {
                try {
                    port = Integer.parseInt(args[3]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                Class<?> c = Class.forName("jdos.host.FowardPCapEthernet");
                Method method = c.getDeclaredMethod("startServer", String.class, Integer.TYPE);
                method.invoke(null, nic, new Integer(port));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            robot = new Robot();
        }
        catch (Throwable e) {
            System.out.println("Applet is not signed, mouse capture will not work");
        }
        frame = new MyFrame();
        frame.setFocusTraversalKeysEnabled(false);
        frame.addFocusListener(new FocusListener(){
            private final KeyEventDispatcher altDisabler = new KeyEventDispatcher(){

                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getKeyCode() == 18) {
                        Main.addEvent(e);
                        return true;
                    }
                    return false;
                }
            };

            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.altDisabler);
            }

            public void focusLost(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.altDisabler);
            }
        });
        panel = new JPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics g) {
                if (Main.buffer != null) {
                    Object object = Main.paintMutex;
                    synchronized (object) {
                        if (fullscreen) {
                            g.drawImage(Main.buffer, fullscreen_cx_offset, 0, fullscreen_cx + fullscreen_cx_offset, fullscreen_cy, 0, 0, Main.buffer_width, Main.buffer_height, null);
                        } else if (Render.render.aspect && Main.screen_height % Main.buffer_height != 0) {
                            BufferedImage resized = MainFrame.resizeImage(Main.buffer, Main.screen_width, Main.screen_height, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                            g.drawImage(resized, 0, 0, Main.screen_width, Main.screen_height, 0, 0, Main.screen_width, Main.screen_height, null);
                        } else {
                            g.drawImage(Main.buffer, 0, 0, Main.screen_width, Main.screen_height, 0, 0, Main.buffer_width, Main.buffer_height, null);
                        }
                    }
                }
            }
        };
        panel.addMouseMotionListener((MyFrame)frame);
        panel.addMouseListener((MyFrame)frame);
        frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent e) {
                Object object = Main.pauseMutex;
                synchronized (object) {
                    Main.pauseMutex.notify();
                }
                Main.addEvent(null);
                try {
                    mainThread.join(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Dosbox.applet) {
                    System.exit(0);
                }
            }
        });
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        frame.getContentPane().add((Component)panel, "First");
        mainThread = new Thread(new Runnable(){

            public void run() {
                Main.main(new MainFrame(), args);
            }
        });
        mainThread.start();
    }

    static {
        eatNextMouseMove = false;
        fullscreen = false;
        fullscreen_cx = 0;
        fullscreen_cy = 0;
        fullscreen_cx_offset = 0;
        cx = 0;
        cy = 0;
    }

    private static class MyFrame
    extends JFrame
    implements KeyListener,
    WindowFocusListener,
    WindowListener,
    MouseListener,
    MouseMotionListener {
        public MyFrame() {
            this.addKeyListener(this);
            this.addWindowFocusListener(this);
            this.addWindowListener(this);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            Main.addEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            Main.addEvent(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowGainedFocus(WindowEvent e) {
            Main.addEvent(new Main.FocusChangeEvent(true));
            Object object = Main.pauseMutex;
            synchronized (object) {
                Main.pauseMutex.notify();
            }
        }

        public void windowLostFocus(WindowEvent e) {
            Main.addEvent(new Main.FocusChangeEvent(false));
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Main.addEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            Main.addEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 3) {
                Main.GFX_CaptureMouse();
            }
        }

        public void mouseMoved(MouseEvent e) {
            MainFrame.robotMouse(e, panel.getLocationOnScreen(), 0, 0);
        }

        public void mouseDragged(MouseEvent e) {
            MainFrame.robotMouse(e, panel.getLocationOnScreen(), 0, 0);
        }
    }
}

