/*
 * Decompiled with CFR 0.152.
 */
package jdos.gui;

import java.io.InputStream;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.SysexMessage;
import jdos.Dosbox;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;

public class Midi
extends Module_base {
    private static final int SYSEX_SIZE = 1024;
    private static final int RAWBUF = 1024;
    private static final byte[] MIDI_evt_len = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 3, 2, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0};
    private static _midi midi;
    private static ShortMessage msg;
    private static SysexMessage sysex_msg;
    private static Midi test;
    public static Section.SectionFunction MIDI_Destroy;
    public static Section.SectionFunction MIDI_Init;

    public static void MIDI_RawOutByte(int data) {
        if (data >= 248) {
            try {
                msg.setMessage(data);
            }
            catch (Exception e) {
                // empty catch block
            }
            Midi.midi.handler.send(msg, -1L);
            return;
        }
        if (Midi.midi.status == 240) {
            if ((data & 0x80) == 0) {
                if (Midi.midi.sysex.used < 1023) {
                    Midi.midi.sysex.buf[Midi.midi.sysex.used++] = (byte)data;
                }
                return;
            }
            Midi.midi.sysex.buf[Midi.midi.sysex.used++] = -9;
            try {
                sysex_msg.setMessage(Midi.midi.sysex.buf, Midi.midi.sysex.used);
            }
            catch (Exception e) {
                // empty catch block
            }
            Midi.midi.handler.send(sysex_msg, -1L);
        }
        if ((data & 0x80) != 0) {
            Midi.midi.status = data;
            Midi.midi.cmd_pos = 0;
            Midi.midi.cmd_len = MIDI_evt_len[data];
            if (Midi.midi.status == 240) {
                Midi.midi.sysex.buf[0] = -16;
                Midi.midi.sysex.used = 1;
            }
        }
        if (Midi.midi.cmd_len != 0) {
            Midi.midi.cmd_buf[Midi.midi.cmd_pos++] = (byte)data;
            if (Midi.midi.cmd_pos >= Midi.midi.cmd_len) {
                try {
                    msg.setMessage(Midi.midi.cmd_buf[0], Midi.midi.cmd_buf[1], Midi.midi.cmd_buf[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Midi.midi.handler.send(msg, -1L);
                Midi.midi.cmd_pos = 1;
            }
        }
    }

    public static boolean MIDI_Available() {
        return Midi.midi.device != null;
    }

    public Midi(Section configuration) {
        super(configuration);
        MidiDevice device;
        int i;
        Section_prop section = (Section_prop)configuration;
        String dev = section.Get_string("mididevice");
        Midi.midi.status = 0;
        Midi.midi.cmd_pos = 0;
        Midi.midi.cmd_len = 0;
        MidiDevice.Info[] devices = MidiSystem.getMidiDeviceInfo();
        boolean def = dev.equalsIgnoreCase("default");
        if (!def) {
            for (i = 0; i < devices.length; ++i) {
                if (!devices[i].getName().equalsIgnoreCase(dev)) continue;
                try {
                    device = MidiSystem.getMidiDevice(devices[0]);
                    device.open();
                    Midi.midi.handler = device.getReceiver();
                    Midi.midi.device = device;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Midi.midi.handler == null) {
                Log.log_msg("MIDI:Can't find device:" + dev + ", finding default handler.");
            }
        }
        if (Midi.midi.handler == null) {
            Synthesizer synth = null;
            Soundbank soundbank = null;
            try {
                synth = MidiSystem.getSynthesizer();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (synth != null) {
                String fileName = "default";
                soundbank = synth.getDefaultSoundbank();
                if (soundbank == null) {
                    InputStream is = Dosbox.class.getResourceAsStream(fileName = "soundbank-deluxe.gm");
                    if (is == null) {
                        fileName = "soundbank-mid.gm";
                        is = Dosbox.class.getResourceAsStream("soundbank-mid.gm");
                    }
                    if (is == null) {
                        fileName = "soundbank-min.gm";
                        is = Dosbox.class.getResourceAsStream("soundbank-min.gm");
                    }
                    if (is != null) {
                        try {
                            soundbank = MidiSystem.getSoundbank(is);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (soundbank != null) {
                    try {
                        synth.open();
                        if (synth.isSoundbankSupported(soundbank) && synth.loadAllInstruments(soundbank)) {
                            Log.log_msg("Using Soundbank: " + fileName);
                            Midi.midi.handler = synth.getReceiver();
                            Midi.midi.device = synth;
                        } else {
                            synth.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        for (i = 0; i < devices.length && Midi.midi.handler == null; ++i) {
            try {
                device = MidiSystem.getMidiDevice(devices[i]);
                device.open();
                Midi.midi.handler = device.getReceiver();
                Midi.midi.device = device;
                Log.log_msg("MIDI:Opened device:" + devices[i].getName());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        msg = new ShortMessage();
        sysex_msg = new SysexMessage();
        MIDI_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                if (midi.device != null) {
                    midi.handler.close();
                    midi.device.close();
                }
                test = null;
                midi = null;
            }
        };
        MIDI_Init = new Section.SectionFunction(){

            public void call(Section section) {
                midi = new _midi();
                test = new Midi(section);
                section.AddDestroyFunction(MIDI_Destroy);
            }
        };
    }

    private static class _midi {
        int status;
        int cmd_len;
        int cmd_pos;
        byte[] cmd_buf = new byte[8];
        byte[] rt_buf = new byte[8];
        public Sysex sysex = new Sysex();
        Receiver handler;
        MidiDevice device;

        private _midi() {
        }

        public static class Sysex {
            byte[] buf = new byte[1024];
            int used;
        }
    }
}

