/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.DbOPL;
import jdos.hardware.IoHandler;
import jdos.hardware.Mixer;
import jdos.hardware.Pic;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;

public class Adlib {
    private static final int HW_OPL2 = 0;
    private static final int HW_DUALOPL2 = 1;
    private static final int HW_OPL3 = 2;
    private static final int MODE_OPL2 = 0;
    private static final int MODE_DUALOPL2 = 1;
    private static final int MODE_OPL3 = 2;
    private static Module module = null;
    private static final Mixer.MIXER_Handler OPL_CallBack = new Mixer.MIXER_Handler(){

        public void call(int len) {
            module.handler.Generate(module.mixerChan, len);
            if ((long)Pic.PIC_Ticks - module.lastUsed > 30000L) {
                int i;
                for (i = 176; i < 185 && (module.cache[i] & 0x20) == 0 && (module.cache[i + 256] & 0x20) == 0; ++i) {
                }
                if (i == 185) {
                    module.mixerChan.Enable(false);
                } else {
                    module.lastUsed = Pic.PIC_Ticks;
                }
            }
        }
    };
    private static final IoHandler.IO_ReadHandler OPL_Read = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return module.PortRead(port, iolen);
        }
    };
    private static final IoHandler.IO_WriteHandler OPL_Write = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            module.PortWrite(port, (short)val, iolen);
        }
    };

    public static void OPL_Init(Section sec, int oplmode) {
        Module.oplmode = oplmode;
        module = new Module(sec);
    }

    public static void OPL_ShutDown(Section sec) {
        module = null;
    }

    private static class Module
    extends Module_base {
        private IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[3];
        private IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[3];
        private Mixer.MixerObject mixerObject = new Mixer.MixerObject();
        private int mode;
        private static Reg reg = new Reg();
        public static int oplmode = 0;
        public Mixer.MixerChannel mixerChan;
        public long lastUsed;
        public Handler handler;
        public short[] cache = new short[512];
        public Chip[] chip = new Chip[2];

        public Module(Section configuration) {
            super(configuration);
            int i;
            for (i = 0; i < this.ReadHandler.length; ++i) {
                this.ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
            }
            for (i = 0; i < this.WriteHandler.length; ++i) {
                this.WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
            }
            for (i = 0; i < this.chip.length; ++i) {
                this.chip[i] = new Chip();
            }
            Module.reg.normal = 0;
            Section_prop section = (Section_prop)configuration;
            int base = section.Get_hex("sbbase").toInt();
            int rate = section.Get_int("oplrate");
            if (rate < 8000) {
                rate = 8000;
            }
            String oplemu = section.Get_string("oplemu");
            this.mixerChan = this.mixerObject.Install(OPL_CallBack, rate, "FM");
            this.mixerChan.SetScale(2.0f);
            if (oplemu.equals("fast")) {
                this.handler = new DbOPL.Handler();
            } else if (oplemu.equals("compat")) {
                System.out.println("OPLEMU compat not implemented");
                this.handler = new DbOPL.Handler();
            } else {
                this.handler = new DbOPL.Handler();
            }
            this.handler.Init(rate);
            boolean single = false;
            switch (oplmode) {
                case 2: {
                    single = true;
                    this.Init(0);
                    break;
                }
                case 3: {
                    this.Init(1);
                    break;
                }
                case 4: {
                    this.Init(2);
                }
            }
            this.WriteHandler[0].Install(904, OPL_Write, 1, 4);
            this.ReadHandler[0].Install(904, OPL_Read, 1, 4);
            if (!single) {
                this.WriteHandler[1].Install(base, OPL_Write, 1, 4);
                this.ReadHandler[1].Install(base, OPL_Read, 1, 4);
            }
            this.WriteHandler[2].Install(base + 8, OPL_Write, 1, 2);
            this.ReadHandler[2].Install(base + 8, OPL_Read, 1, 1);
        }

        private void CacheWrite(int reg, short val) {
            this.cache[reg] = val;
        }

        private void DualWrite(short index, short reg, short val) {
            if (reg == 5) {
                return;
            }
            if (reg >= 224) {
                val = (short)(val & 3);
            }
            if (this.chip[index].Write(reg, val)) {
                return;
            }
            if (reg >= 192 && reg <= 200) {
                val = (short)(val & 0xF);
                val = (short)(val | (index != 0 ? 160 : 80));
            }
            int fullReg = reg + (index != 0 ? 256 : 0);
            this.handler.WriteReg(fullReg, val);
            this.CacheWrite(fullReg, val);
        }

        public void PortWrite(int port, short val, int iolen) {
            this.lastUsed = Pic.PIC_Ticks;
            if (!this.mixerChan.enabled) {
                this.mixerChan.Enable(true);
            }
            if ((port & 1) != 0) {
                switch (this.mode) {
                    case 0: 
                    case 2: {
                        if (this.chip[0].Write(Module.reg.normal, val)) break;
                        this.handler.WriteReg(Module.reg.normal, val);
                        this.CacheWrite(Module.reg.normal, val);
                        break;
                    }
                    case 1: {
                        if ((port & 8) == 0) {
                            short index = (short)((port & 2) >> 1);
                            this.DualWrite(index, reg.dual(index), val);
                            break;
                        }
                        this.DualWrite((short)0, reg.dual(0), val);
                        this.DualWrite((short)1, reg.dual(1), val);
                    }
                }
            } else {
                switch (this.mode) {
                    case 0: {
                        Module.reg.normal = (int)this.handler.WriteAddr(port, val) & 0xFF;
                        break;
                    }
                    case 2: {
                        Module.reg.normal = (int)this.handler.WriteAddr(port, val) & 0x1FF;
                        break;
                    }
                    case 1: {
                        if ((port & 8) == 0) {
                            int index = (port & 2) >> 1;
                            reg.dual(index, val & 0xFF);
                            break;
                        }
                        reg.dual(0, val & 0xFF);
                        reg.dual(1, val & 0xFF);
                    }
                }
            }
        }

        public int PortRead(int port, int iolen) {
            switch (this.mode) {
                case 0: {
                    if ((port & 3) == 0) {
                        return this.chip[0].Read() | 6;
                    }
                    return 255;
                }
                case 2: {
                    if ((port & 3) == 0) {
                        return this.chip[0].Read();
                    }
                    return 255;
                }
                case 1: {
                    if ((port & 1) != 0) {
                        return 255;
                    }
                    return this.chip[port >> 1 & 1].Read() | 6;
                }
            }
            return 0;
        }

        public void Init(int m) {
            this.mode = m;
            switch (this.mode) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: {
                    this.handler.WriteReg(261, (short)1);
                    this.CacheWrite(261, (short)1);
                }
            }
        }

        private static class Reg {
            int normal;

            private Reg() {
            }

            short dual(int index) {
                if (index == 0) {
                    return (short)(this.normal & 0xFF);
                }
                return (short)(this.normal >> 8 & 0xFF);
            }

            void dual(int index, int value) {
                if (index == 0) {
                    this.normal &= 0xFFFFFF00;
                    this.normal |= value & 0xFF;
                } else {
                    this.normal &= 0xFFFF00FF;
                    this.normal |= value << 8 & 0xFF;
                }
            }
        }
    }

    public static interface Handler {
        public long WriteAddr(int var1, short var2);

        public void WriteReg(int var1, short var2);

        public void Generate(Mixer.MixerChannel var1, int var2);

        public void Init(long var1);
    }

    private static final class Chip {
        Timer[] timer = new Timer[2];

        public Chip() {
            for (int i = 0; i < this.timer.length; ++i) {
                this.timer[i] = new Timer();
            }
        }

        boolean Write(int addr, short val) {
            switch (addr) {
                case 2: {
                    this.timer[0].counter = val;
                    return true;
                }
                case 3: {
                    this.timer[1].counter = val;
                    return true;
                }
                case 4: {
                    double time = Pic.PIC_FullIndex();
                    if ((val & 0x80) != 0) {
                        this.timer[0].Reset(time);
                        this.timer[1].Reset(time);
                    } else {
                        this.timer[0].Update(time);
                        this.timer[1].Update(time);
                        if ((val & 1) != 0) {
                            this.timer[0].Start(time, 80);
                        } else {
                            this.timer[0].Stop();
                        }
                        boolean bl = this.timer[0].masked = (val & 0x40) > 0;
                        if (this.timer[0].masked) {
                            this.timer[0].overflow = false;
                        }
                        if ((val & 2) != 0) {
                            this.timer[1].Start(time, 320);
                        } else {
                            this.timer[1].Stop();
                        }
                        boolean bl2 = this.timer[1].masked = (val & 0x20) > 0;
                        if (this.timer[1].masked) {
                            this.timer[1].overflow = false;
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        short Read() {
            double time = Pic.PIC_FullIndex();
            this.timer[0].Update(time);
            this.timer[1].Update(time);
            short ret = 0;
            if (this.timer[0].overflow) {
                ret = (short)(ret | 0x40);
                ret = (short)(ret | 0x80);
            }
            if (this.timer[1].overflow) {
                ret = (short)(ret | 0x20);
                ret = (short)(ret | 0x80);
            }
            return ret;
        }
    }

    private static final class Timer {
        double start;
        double delay = 0.0;
        boolean enabled = false;
        boolean overflow = false;
        boolean masked = false;
        short counter = 0;

        Timer() {
        }

        void Update(double time) {
            if (!this.enabled || this.delay == 0.0) {
                return;
            }
            double deltaStart = time - this.start;
            if (deltaStart >= 0.0 && !this.masked) {
                this.overflow = true;
            }
        }

        void Reset(double time) {
            this.overflow = false;
            if (this.delay == 0.0 || !this.enabled) {
                return;
            }
            double delta = time - this.start;
            double rem = delta % this.delay;
            double next = this.delay - rem;
            this.start = time + next;
        }

        void Stop() {
            this.enabled = false;
        }

        void Start(double time, int scale) {
            if (this.enabled) {
                return;
            }
            this.enabled = true;
            this.delay = 0.001 * (double)(256 - this.counter) * (double)scale;
            this.start = time + this.delay;
        }
    }

    private static class RawHeader {
        byte[] id = new byte[8];
        int versionHigh;
        int versionLow;
        long commands;
        long milliseconds;
        short hardware;
        short format;
        short compression;
        short delay256;
        short delayShift8;
        short conversionTableSize;

        private RawHeader() {
        }
    }
}

