/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import java.util.Calendar;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.ints.Bios_disk;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;

public class Cmos
extends Module_base {
    private static CMOS cmos = new CMOS();
    private static Pic.PIC_EventHandler cmos_timerevent = new Pic.PIC_EventHandler(){

        public void call(int val) {
            if (cmos.timer.acknowledged) {
                cmos.timer.acknowledged = false;
                Pic.PIC_ActivateIRQ(8);
            }
            if (cmos.timer.enabled) {
                Pic.PIC_AddEvent(cmos_timerevent, cmos.timer.delay);
                cmos.regs[12] = -64;
            }
        }

        public String toString() {
            return "cmos_timerevent";
        }
    };
    private static IoHandler.IO_WriteHandler cmos_selreg = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            cmos.reg = (byte)(val & 0x3F);
            cmos.nmi = (val & 0x80) > 0;
        }
    };
    private static IoHandler.IO_WriteHandler cmos_writereg = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (cmos.reg) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 50: {
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    Log.log(19, 0, "CMOS:Trying to set alarm");
                    cmos.regs[cmos.reg] = (byte)val;
                    break;
                }
                case 10: {
                    cmos.regs[cmos.reg] = (byte)(val & 0x7F);
                    if ((val & 0x70) != 32) {
                        Log.log(19, 2, "CMOS Illegal 22 stage divider value");
                    }
                    cmos.timer.div = (byte)(val & 0xF);
                    Cmos.cmos_checktimer();
                    break;
                }
                case 11: {
                    cmos.bcd = (val & 4) == 0;
                    cmos.regs[cmos.reg] = (byte)(val & 0x7F);
                    boolean bl = cmos.timer.enabled = (val & 0x40) > 0;
                    if ((val & 0x10) != 0) {
                        Log.log(19, 2, "CMOS:Updated ended interrupt not supported yet");
                    }
                    Cmos.cmos_checktimer();
                    break;
                }
                case 13: {
                    cmos.regs[cmos.reg] = (byte)(val & 0x80);
                    break;
                }
                case 15: {
                    cmos.regs[cmos.reg] = (byte)(val & 0x7F);
                    break;
                }
                default: {
                    cmos.regs[cmos.reg] = (byte)(val & 0x7F);
                    Log.log(19, 2, "CMOS:WRite to unhandled register " + Integer.toString(cmos.reg, 16));
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler cmos_readreg = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            if (cmos.reg > 63) {
                Log.log(19, 2, "CMOS:Read from illegal register " + Integer.toString(cmos.reg, 16));
                return 255;
            }
            Calendar c = Calendar.getInstance();
            switch (cmos.reg) {
                case 0: {
                    return Cmos.MAKE_RETURN(c.get(13));
                }
                case 2: {
                    return Cmos.MAKE_RETURN(c.get(12));
                }
                case 4: {
                    return Cmos.MAKE_RETURN(c.get(10));
                }
                case 6: {
                    return Cmos.MAKE_RETURN(c.get(7));
                }
                case 7: {
                    return Cmos.MAKE_RETURN(c.get(5));
                }
                case 8: {
                    return Cmos.MAKE_RETURN(c.get(2) + 1);
                }
                case 9: {
                    return Cmos.MAKE_RETURN(c.get(1) % 100);
                }
                case 50: {
                    return Cmos.MAKE_RETURN(c.get(1) / 100 + 19);
                }
                case 1: 
                case 3: 
                case 5: {
                    return cmos.regs[cmos.reg];
                }
                case 10: {
                    if ((double)Pic.PIC_TickIndex() < 0.002) {
                        return cmos.regs[10] & 0x7F | 0x80;
                    }
                    return cmos.regs[10] & 0x7F;
                }
                case 12: {
                    cmos.timer.acknowledged = true;
                    if (cmos.timer.enabled) {
                        byte val = cmos.regs[12];
                        cmos.regs[12] = 0;
                        return val;
                    }
                    int val = 0;
                    double index = Pic.PIC_FullIndex();
                    if (index >= cmos.last.timer + (double)cmos.timer.delay) {
                        cmos.last.timer = index;
                        val = (byte)(val | 0x40);
                    }
                    if (index >= cmos.last.ended + 1000.0) {
                        cmos.last.ended = index;
                        val = (byte)(val | 0x10);
                    }
                    return val;
                }
                case 16: {
                    short drive_a = 0;
                    short drive_b = 0;
                    if (Bios_disk.imageDiskList[0] != null) {
                        drive_a = Bios_disk.imageDiskList[0].GetBiosType();
                    }
                    if (Bios_disk.imageDiskList[1] != null) {
                        drive_b = Bios_disk.imageDiskList[1].GetBiosType();
                    }
                    return drive_a << 4 | drive_b;
                }
                case 18: {
                    int hdparm = 0;
                    if (Bios_disk.imageDiskList[2] != null) {
                        hdparm = (short)(hdparm | 0xF);
                    }
                    if (Bios_disk.imageDiskList[3] != null) {
                        hdparm = (short)(hdparm | 0xF0);
                    }
                    return hdparm;
                }
                case 25: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return 47;
                    }
                    return 0;
                }
                case 27: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return (int)(Bios_disk.imageDiskList[2].cylinders & 0xFFL);
                    }
                    return 0;
                }
                case 28: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return (int)((Bios_disk.imageDiskList[2].cylinders & 0xFF00L) >> 8);
                    }
                    return 0;
                }
                case 29: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return (int)Bios_disk.imageDiskList[2].heads;
                    }
                    return 0;
                }
                case 30: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return 255;
                    }
                    return 0;
                }
                case 31: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return 255;
                    }
                    return 0;
                }
                case 32: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return 0xC0 | (Bios_disk.imageDiskList[2].heads > 8L ? 1 : 0);
                    }
                    return 0;
                }
                case 33: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return (int)(Bios_disk.imageDiskList[2].cylinders & 0xFFL);
                    }
                    return 0;
                }
                case 34: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return (int)((Bios_disk.imageDiskList[2].cylinders & 0xFF00L) >> 8);
                    }
                    return 0;
                }
                case 35: {
                    if (Bios_disk.imageDiskList[2] != null) {
                        return (int)Bios_disk.imageDiskList[2].sectors;
                    }
                    return 0;
                }
                case 26: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return 47;
                    }
                    return 0;
                }
                case 36: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return (int)(Bios_disk.imageDiskList[3].cylinders & 0xFFL);
                    }
                    return 0;
                }
                case 37: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return (int)((Bios_disk.imageDiskList[3].cylinders & 0xFF00L) >> 8);
                    }
                    return 0;
                }
                case 38: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return (int)Bios_disk.imageDiskList[3].heads;
                    }
                    return 0;
                }
                case 39: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return 255;
                    }
                    return 0;
                }
                case 40: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return 255;
                    }
                    return 0;
                }
                case 41: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return 0xC0 | (Bios_disk.imageDiskList[3].heads > 8L ? 1 : 0);
                    }
                    return 0;
                }
                case 42: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return (int)(Bios_disk.imageDiskList[3].cylinders & 0xFFL);
                    }
                    return 0;
                }
                case 43: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return (int)((Bios_disk.imageDiskList[3].cylinders & 0xFF00L) >> 8);
                    }
                    return 0;
                }
                case 44: {
                    if (Bios_disk.imageDiskList[3] != null) {
                        return (int)Bios_disk.imageDiskList[3].sectors;
                    }
                    return 0;
                }
                case 57: {
                    return 0;
                }
                case 58: {
                    return 0;
                }
                case 11: 
                case 13: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 48: 
                case 49: {
                    return cmos.regs[cmos.reg];
                }
            }
            return cmos.regs[cmos.reg];
        }
    };
    private static IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[2];
    private static IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[2];
    static Cmos test;
    private static Section.SectionFunction CMOS_Destroy;
    public static Section.SectionFunction CMOS_Init;

    private static void cmos_checktimer() {
        Pic.PIC_RemoveEvents(cmos_timerevent);
        if (Cmos.cmos.timer.div <= 2) {
            Cmos.cmos.timer.div = (byte)(Cmos.cmos.timer.div + 7);
        }
        Cmos.cmos.timer.delay = 1000.0f / (32768.0f / (float)(1 << Cmos.cmos.timer.div - 1));
        if (Cmos.cmos.timer.div == 0 || !Cmos.cmos.timer.enabled) {
            return;
        }
        double remd = Pic.PIC_FullIndex() % (double)Cmos.cmos.timer.delay;
        Pic.PIC_AddEvent(cmos_timerevent, (float)((double)Cmos.cmos.timer.delay - remd));
    }

    private static int MAKE_RETURN(int _VAL) {
        return Cmos.cmos.bcd ? _VAL / 10 << 4 | _VAL % 10 : _VAL;
    }

    public static void CMOS_SetRegister(int regNr, short val) {
        Cmos.cmos.regs[regNr] = (byte)val;
    }

    public Cmos(Section configuration) {
        super(configuration);
        WriteHandler[0].Install(112, cmos_selreg, 1);
        WriteHandler[1].Install(113, cmos_writereg, 1);
        ReadHandler[0].Install(113, cmos_readreg, 1);
        Cmos.cmos.timer.enabled = false;
        Cmos.cmos.timer.acknowledged = true;
        Cmos.cmos.reg = (byte)10;
        cmos_writereg.call(113, 38, 1);
        Cmos.cmos.reg = (byte)11;
        cmos_writereg.call(113, 2, 1);
        Cmos.cmos.reg = (byte)13;
        cmos_writereg.call(113, 128, 1);
        Cmos.cmos.regs[21] = -128;
        Cmos.cmos.regs[22] = 2;
        int exsize = Memory.MEM_TotalPages() * 4 - 1024;
        Cmos.cmos.regs[23] = (byte)exsize;
        Cmos.cmos.regs[24] = (byte)(exsize >> 8);
        Cmos.cmos.regs[48] = (byte)exsize;
        Cmos.cmos.regs[49] = (byte)(exsize >> 8);
    }

    static {
        CMOS_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                int i;
                test = null;
                for (i = 0; i < ReadHandler.length; ++i) {
                    ReadHandler[i] = null;
                }
                for (i = 0; i < WriteHandler.length; ++i) {
                    WriteHandler[i] = null;
                }
            }
        };
        CMOS_Init = new Section.SectionFunction(){

            public void call(Section section) {
                int i;
                for (i = 0; i < ReadHandler.length; ++i) {
                    ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
                }
                for (i = 0; i < WriteHandler.length; ++i) {
                    WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
                }
                test = new Cmos(section);
                section.AddDestroyFunction(CMOS_Destroy, true);
            }
        };
    }

    private static class CMOS {
        public byte[] regs = new byte[64];
        boolean nmi;
        boolean bcd;
        byte reg;
        public Timer timer = new Timer();
        public Last last = new Last();
        boolean update_ended;

        private CMOS() {
        }

        public static class Last {
            double timer;
            double ended;
            double alarm;
        }

        public static class Timer {
            boolean enabled;
            byte div;
            float delay;
            boolean acknowledged;
        }
    }
}

