/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.cpu.Core_full;
import jdos.cpu.Flags;
import jdos.cpu.LazyFlags;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;

public class IO
extends Module_base {
    private static final int IOF_QUEUESIZE = 16;
    private static IOF_Queue iof_queue;
    private static CPU.CPU_Decoder IOFaultCore;
    private static final float IODELAY_READ_MICROS = 1.0f;
    private static final float IODELAY_WRITE_MICROS = 0.75f;
    private static final int IODELAY_READ_MICROSk = 1024;
    private static final int IODELAY_WRITE_MICROSk = 1365;
    static IO test;
    public static Section.SectionFunction IO_Destroy;
    public static Section.SectionFunction IO_Init;

    private static void IO_USEC_read_delay_old() {
        if (CPU.CPU_CycleMax > 1000) {
            int delaycyc = (int)((float)(CPU.CPU_CycleMax / 1000) * 1.0f);
            CPU.CPU_Cycles = CPU.CPU_Cycles > delaycyc ? (CPU.CPU_Cycles -= delaycyc) : 0;
        }
    }

    private static void IO_USEC_write_delay_old() {
        if (CPU.CPU_CycleMax > 750) {
            int delaycyc = (int)((float)(CPU.CPU_CycleMax / 1000) * 0.75f);
            CPU.CPU_Cycles = CPU.CPU_Cycles > delaycyc ? (CPU.CPU_Cycles -= delaycyc) : 0;
        }
    }

    private static void IO_USEC_read_delay() {
        int delaycyc = CPU.CPU_CycleMax / 1024;
        if (CPU.CPU_Cycles < 3 * delaycyc) {
            delaycyc = 0;
        }
        CPU.CPU_Cycles -= delaycyc;
        CPU.CPU_IODelayRemoved += delaycyc;
    }

    private static void IO_USEC_write_delay() {
        int delaycyc = CPU.CPU_CycleMax / 1365;
        if (CPU.CPU_Cycles < 3 * delaycyc) {
            delaycyc = 0;
        }
        CPU.CPU_Cycles -= delaycyc;
        CPU.CPU_IODelayRemoved += delaycyc;
    }

    private static void log_io(int width, boolean write, int port, long val) {
    }

    public static void IO_WriteB(int port, int val) {
        IO.log_io(0, true, port, val);
        if (CPU_Regs.GETFLAG(131072) != 0 && CPU.CPU_IO_Exception(port, 1)) {
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = IOFaultCore;
            IOF_Entry entry = IO.iof_queue.entries[IO.iof_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            CPU.CPU_Push16(CPU.Segs_CSval);
            CPU.CPU_Push16(CPU_Regs.reg_ip());
            short old_al = CPU_Regs.reg_eax.low();
            int old_dx = CPU_Regs.reg_edx.word();
            CPU_Regs.reg_eax.low(val);
            CPU_Regs.reg_edx.word(port);
            int icb = Callback.CALLBACK_RealPointer(Callback.call_priv_io);
            CPU_Regs.SegSet16CS(Memory.RealSeg(icb));
            CPU_Regs.reg_eip = Memory.RealOff(icb) + 8;
            CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
            Dosbox.DOSBOX_RunMachine();
            --IO.iof_queue.used;
            CPU_Regs.reg_eax.low(old_al);
            CPU_Regs.reg_edx.word(old_dx);
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
        } else {
            IO.IO_USEC_write_delay();
            IoHandler.io_writehandlers[0][port].call(port, val, 1);
        }
    }

    public static void IO_WriteW(int port, int val) {
        IO.log_io(1, true, port, val);
        if (CPU_Regs.GETFLAG(131072) != 0 && CPU.CPU_IO_Exception(port, 2)) {
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = IOFaultCore;
            IOF_Entry entry = IO.iof_queue.entries[IO.iof_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            CPU.CPU_Push16(CPU.Segs_CSval);
            CPU.CPU_Push16(CPU_Regs.reg_ip());
            int old_ax = CPU_Regs.reg_eax.word();
            int old_dx = CPU_Regs.reg_edx.word();
            CPU_Regs.reg_eax.word(val);
            CPU_Regs.reg_edx.word(port);
            int icb = Callback.CALLBACK_RealPointer(Callback.call_priv_io);
            CPU_Regs.SegSet16CS(Memory.RealSeg(icb));
            CPU_Regs.reg_eip = Memory.RealOff(icb) + 10;
            CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
            Dosbox.DOSBOX_RunMachine();
            --IO.iof_queue.used;
            CPU_Regs.reg_eax.word(old_ax);
            CPU_Regs.reg_edx.word(old_dx);
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
        } else {
            IO.IO_USEC_write_delay();
            IoHandler.io_writehandlers[1][port].call(port, val, 2);
        }
    }

    public static void IO_WriteD(int port, int val) {
        IO.log_io(2, true, port, val);
        if (CPU_Regs.GETFLAG(131072) != 0 && CPU.CPU_IO_Exception(port, 4)) {
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = IOFaultCore;
            IOF_Entry entry = IO.iof_queue.entries[IO.iof_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            CPU.CPU_Push16(CPU.Segs_CSval);
            CPU.CPU_Push16(CPU_Regs.reg_ip());
            int old_eax = CPU_Regs.reg_eax.dword;
            int old_dx = CPU_Regs.reg_edx.word();
            CPU_Regs.reg_eax.dword = val;
            CPU_Regs.reg_edx.word(port);
            int icb = Callback.CALLBACK_RealPointer(Callback.call_priv_io);
            CPU_Regs.SegSet16CS(Memory.RealSeg(icb));
            CPU_Regs.reg_eip = Memory.RealOff(icb) + 12;
            CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
            Dosbox.DOSBOX_RunMachine();
            --IO.iof_queue.used;
            CPU_Regs.reg_eax.dword = old_eax;
            CPU_Regs.reg_edx.word(old_dx);
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
        } else {
            IoHandler.io_writehandlers[2][port].call(port, val, 4);
        }
    }

    public static int IO_ReadB(int port) {
        if (CPU_Regs.GETFLAG(131072) != 0 && CPU.CPU_IO_Exception(port, 1)) {
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = IOFaultCore;
            IOF_Entry entry = IO.iof_queue.entries[IO.iof_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            CPU.CPU_Push16(CPU.Segs_CSval);
            CPU.CPU_Push16(CPU_Regs.reg_ip());
            int old_dx = CPU_Regs.reg_edx.word();
            CPU_Regs.reg_edx.word(port);
            int icb = Callback.CALLBACK_RealPointer(Callback.call_priv_io);
            CPU_Regs.SegSet16CS(Memory.RealSeg(icb));
            CPU_Regs.reg_eip = Memory.RealOff(icb) + 0;
            CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
            Dosbox.DOSBOX_RunMachine();
            --IO.iof_queue.used;
            short retval = CPU_Regs.reg_eax.low();
            CPU_Regs.reg_edx.word(old_dx);
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
            return retval;
        }
        IO.IO_USEC_read_delay();
        int retval = IoHandler.io_readhandlers[0][port].call(port, 1);
        IO.log_io(0, false, port, retval);
        return retval;
    }

    public static int IO_ReadW(int port) {
        int retval;
        if (CPU_Regs.GETFLAG(131072) != 0 && CPU.CPU_IO_Exception(port, 2)) {
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = IOFaultCore;
            IOF_Entry entry = IO.iof_queue.entries[IO.iof_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            CPU.CPU_Push16(CPU.Segs_CSval);
            CPU.CPU_Push16(CPU_Regs.reg_ip());
            int old_dx = CPU_Regs.reg_edx.word();
            CPU_Regs.reg_edx.word(port);
            int icb = Callback.CALLBACK_RealPointer(Callback.call_priv_io);
            CPU_Regs.SegSet16CS(Memory.RealSeg(icb));
            CPU_Regs.reg_eip = Memory.RealOff(icb) + 2;
            CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
            Dosbox.DOSBOX_RunMachine();
            --IO.iof_queue.used;
            retval = CPU_Regs.reg_eax.word();
            CPU_Regs.reg_edx.word(old_dx);
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
        } else {
            IO.IO_USEC_read_delay();
            retval = IoHandler.io_readhandlers[1][port].call(port, 2);
        }
        IO.log_io(1, false, port, retval);
        return retval;
    }

    public static int IO_ReadD(int port) {
        int retval;
        if (CPU_Regs.GETFLAG(131072) != 0 && CPU.CPU_IO_Exception(port, 4)) {
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = IOFaultCore;
            IOF_Entry entry = IO.iof_queue.entries[IO.iof_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            CPU.CPU_Push16(CPU.Segs_CSval);
            CPU.CPU_Push16(CPU_Regs.reg_ip());
            int old_dx = CPU_Regs.reg_edx.word();
            CPU_Regs.reg_edx.word(port);
            int icb = Callback.CALLBACK_RealPointer(Callback.call_priv_io);
            CPU_Regs.SegSet16CS(Memory.RealSeg(icb));
            CPU_Regs.reg_eip = Memory.RealOff(icb) + 4;
            CPU.CPU_Exception(CPU.cpu.exception.which, CPU.cpu.exception.error);
            Dosbox.DOSBOX_RunMachine();
            --IO.iof_queue.used;
            retval = CPU_Regs.reg_eax.dword;
            CPU_Regs.reg_edx.word(old_dx);
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
        } else {
            retval = IoHandler.io_readhandlers[2][port].call(port, 4);
        }
        IO.log_io(2, false, port, retval);
        return retval;
    }

    public IO(Section configuration) {
        super(configuration);
        IO.iof_queue.used = 0;
        IoHandler.IO_FreeReadHandler(0, 7, 65539);
        IoHandler.IO_FreeWriteHandler(0, 7, 65539);
    }

    static {
        IOFaultCore = new CPU.CPU_Decoder(){

            public int call() {
                CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                CPU.CPU_Cycles = 1;
                int ret = Core_full.CPU_Core_Full_Run.call();
                CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                if (ret < 0) {
                    Log.exit("Got a dosbox close machine in IO-fault core?");
                }
                if (ret != 0) {
                    return ret;
                }
                if (iof_queue.used == 0) {
                    Log.exit("IO-faul Core without IO-faul");
                }
                IOF_Entry entry = iof_queue.entries[iof_queue.used - 1];
                if (entry.cs == CPU.Segs_CSval && entry.eip == (long)CPU_Regs.reg_eip) {
                    return -1;
                }
                return 0;
            }
        };
        IO_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                test = null;
                iof_queue = null;
            }
        };
        IO_Init = new Section.SectionFunction(){

            public void call(Section sec) {
                iof_queue = new IOF_Queue();
                test = new IO(sec);
                sec.AddDestroyFunction(IO_Destroy);
            }
        };
    }

    private static class IOF_Queue {
        int used;
        IOF_Entry[] entries = new IOF_Entry[16];

        public IOF_Queue() {
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i] = new IOF_Entry();
            }
        }
    }

    private static class IOF_Entry {
        int cs;
        long eip;

        private IOF_Entry() {
        }
    }
}

