/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import jdos.hardware.IPX;
import jdos.hardware.Timer;
import jdos.misc.Log;

public class IPXServer {
    private static IPX.IPXAddress ipxServerIp;
    private static DatagramSocket ipxServerSocket;
    private static final IPX.packetBuffer[] connBuffer;
    private static final IPX.IPXAddress[] ipconn;
    private static final DatagramSocket[] tcpconn;
    private static Timer.TIMER_TickHandler serverTimer;
    private static final Thread serverThread;

    private static byte packetCRC(byte[] buffer, int bufSize) {
        byte tmpCRC = 0;
        for (int i = 0; i < bufSize; ++i) {
            tmpCRC = (byte)(tmpCRC ^ buffer[i]);
        }
        return tmpCRC;
    }

    private static void sendIPXPacket(byte[] buffer, int bufSize) {
        IPX.IPXHeader tmpHeader = new IPX.IPXHeader();
        tmpHeader.load(buffer);
        int srchost = tmpHeader.src.addr.host();
        int desthost = tmpHeader.dest.addr.host();
        int srcport = tmpHeader.src.addr.port();
        int destport = tmpHeader.dest.addr.port();
        if (desthost == -1) {
            for (int i = 0; i < 150; ++i) {
                if (!IPXServer.connBuffer[i].connected || IPXServer.ipconn[i].host == srchost && IPXServer.ipconn[i].port == srcport) continue;
                DatagramPacket outPacket = new DatagramPacket(buffer, bufSize, IPXServer.ipconn[i].address, IPXServer.ipconn[i].port);
                try {
                    ipxServerSocket.send(outPacket);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < 150; ++i) {
                if (!IPXServer.connBuffer[i].connected || IPXServer.ipconn[i].host != desthost || IPXServer.ipconn[i].port != destport) continue;
                DatagramPacket outPacket = new DatagramPacket(buffer, bufSize, IPXServer.ipconn[i].address, IPXServer.ipconn[i].port);
                try {
                    ipxServerSocket.send(outPacket);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static IPX.IPXAddress IPX_isConnectedToServer(int tableNum) {
        if (tableNum >= 150) {
            return null;
        }
        if (!IPXServer.connBuffer[tableNum].connected) {
            return null;
        }
        return ipconn[tableNum];
    }

    private static void ackClient(IPX.IPXAddress clientAddr) {
        IPX.IPXHeader regHeader = new IPX.IPXHeader();
        regHeader.checkSum = (short)-1;
        regHeader.dest.network = 0;
        regHeader.dest.addr.setHost(clientAddr.host);
        regHeader.dest.addr.setPort(clientAddr.port);
        regHeader.dest.socket = (short)2;
        regHeader.src.network = 1;
        regHeader.src.addr.setHost(IPXServer.ipxServerIp.host);
        regHeader.src.addr.setPort(IPXServer.ipxServerIp.port);
        regHeader.src.socket = (short)2;
        regHeader.transControl = 0;
        byte[] outbuffer = regHeader.toByteArray();
        DatagramPacket outPacket = new DatagramPacket(outbuffer, outbuffer.length, clientAddr.address, clientAddr.port);
        try {
            ipxServerSocket.send(outPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void IPX_StopServer() {
        ipxServerSocket.close();
        try {
            serverThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean IPX_StartServer(int portnum) {
        try {
            ipxServerIp = new IPX.IPXAddress();
            IPXServer.ipxServerIp.address = InetAddress.getByName(null);
            IPXServer.ipxServerIp.port = portnum;
            ipxServerSocket = new DatagramSocket(portnum);
            serverThread.start();
        }
        catch (Exception e) {
            return false;
        }
        for (int i = 0; i < 150; ++i) {
            if (connBuffer[i] == null) {
                IPXServer.connBuffer[i] = new IPX.packetBuffer();
            }
            IPXServer.connBuffer[i].connected = false;
        }
        return true;
    }

    static {
        connBuffer = new IPX.packetBuffer[150];
        ipconn = new IPX.IPXAddress[150];
        tcpconn = new DatagramSocket[150];
        serverThread = new Thread(){

            public void run() {
                byte[] tmpBuffer = new byte[1424];
                while (true) {
                    try {
                        block3: while (true) {
                            DatagramPacket receivePacket = new DatagramPacket(tmpBuffer, tmpBuffer.length);
                            ipxServerSocket.receive(receivePacket);
                            IPX.IPXHeader tmpHeader = new IPX.IPXHeader();
                            tmpHeader.load(tmpBuffer);
                            if (tmpHeader.dest.socket == 2 && tmpHeader.dest.addr.host() == 0) {
                                int i = 0;
                                while (true) {
                                    if (i >= 150) continue block3;
                                    if (!connBuffer[i].connected) {
                                        ipconn[i] = new IPX.IPXAddress();
                                        ipconn[i].address = receivePacket.getAddress();
                                        byte[] b = ipconn[i].address.getAddress();
                                        ipconn[i].host = (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
                                        ipconn[i].port = receivePacket.getPort();
                                        connBuffer[i].connected = true;
                                        Log.log_msg("IPXSERVER: Connect from " + receivePacket.getAddress().getHostAddress());
                                        IPXServer.ackClient(ipconn[i]);
                                        continue block3;
                                    }
                                    if (ipconn[i].host == tmpHeader.src.addr.host() && ipconn[i].port == tmpHeader.src.addr.port()) {
                                        Log.log_msg("IPXSERVER: Reconnect from " + receivePacket.getAddress().getHostAddress());
                                        ipconn[i].port = receivePacket.getPort();
                                        IPXServer.ackClient(ipconn[i]);
                                        continue block3;
                                    }
                                    ++i;
                                }
                            }
                            IPXServer.sendIPXPacket(tmpBuffer, receivePacket.getLength());
                        }
                    }
                    catch (Exception e) {
                        if (!ipxServerSocket.isClosed()) {
                            e.printStackTrace();
                            continue;
                        }
                        return;
                    }
                    break;
                }
            }
        };
    }
}

