/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.IO;
import jdos.misc.Log;

public class IoHandler {
    public static final int IO_MAX = 65539;
    public static final int IO_MB = 1;
    public static final int IO_MW = 2;
    public static final int IO_MD = 4;
    public static final int IO_MA = 7;
    public static IO_WriteHandler[][] io_writehandlers = new IO_WriteHandler[3][65539];
    public static IO_ReadHandler[][] io_readhandlers = new IO_ReadHandler[3][65539];
    private static IO_ReadHandler IO_ReadBlocked = new IO_ReadHandler(){

        public int call(int port, int iolen) {
            return -1;
        }
    };
    private static IO_WriteHandler IO_WriteBlocked = new IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
        }
    };
    private static IO_ReadHandler IO_ReadDefault = new IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (iolen) {
                case 1: {
                    Log.log(22, 1, "Read from port " + Integer.toString(port, 16));
                    IoHandler.io_readhandlers[0][port] = IO_ReadBlocked;
                    return 255;
                }
                case 2: {
                    return io_readhandlers[0][port].call(port, 1) | io_readhandlers[0][port + 1].call(port + 1, 1) << 8;
                }
                case 4: {
                    return io_readhandlers[1][port].call(port, 2) | io_readhandlers[1][port + 2].call(port + 2, 2) << 16;
                }
            }
            return 0;
        }
    };
    private static IO_WriteHandler IO_WriteDefault = new IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (iolen) {
                case 1: {
                    Log.log(22, 1, "Writing " + Integer.toString(val, 16) + " to port " + Integer.toString(port, 16));
                    IoHandler.io_writehandlers[0][port] = IO_WriteBlocked;
                    break;
                }
                case 2: {
                    io_writehandlers[0][port].call(port, val & 0xFF, 1);
                    io_writehandlers[0][port + 1].call(port + 1, val >> 8 & 0xFF, 1);
                    break;
                }
                case 4: {
                    io_writehandlers[1][port].call(port, val & 0xFFFF, 2);
                    io_writehandlers[1][port + 2].call(port + 2, val >> 16 & 0xFFFF, 2);
                }
            }
        }
    };

    public static void IO_Write(int port, int val) {
        IO.IO_WriteB(port, val & 0xFF);
    }

    public static short IO_Read(int port) {
        return (short)(IO.IO_ReadB(port) & 0xFF);
    }

    public static void IO_RegisterReadHandler(int port, IO_ReadHandler handler2, int mask) {
        IoHandler.IO_RegisterReadHandler(port, handler2, mask, 1);
    }

    public static void IO_RegisterReadHandler(int port, IO_ReadHandler handler2, int mask, int range) {
        while (range-- != 0) {
            if ((mask & 1) != 0) {
                IoHandler.io_readhandlers[0][port] = handler2;
            }
            if ((mask & 2) != 0) {
                IoHandler.io_readhandlers[1][port] = handler2;
            }
            if ((mask & 4) != 0) {
                IoHandler.io_readhandlers[2][port] = handler2;
            }
            ++port;
        }
    }

    public static void IO_RegisterWriteHandler(int port, IO_WriteHandler handler2, int mask) {
        IoHandler.IO_RegisterWriteHandler(port, handler2, mask, 1);
    }

    public static void IO_RegisterWriteHandler(int port, IO_WriteHandler handler2, int mask, int range) {
        while (range-- != 0) {
            if ((mask & 1) != 0) {
                IoHandler.io_writehandlers[0][port] = handler2;
            }
            if ((mask & 2) != 0) {
                IoHandler.io_writehandlers[1][port] = handler2;
            }
            if ((mask & 4) != 0) {
                IoHandler.io_writehandlers[2][port] = handler2;
            }
            ++port;
        }
    }

    public static void IO_FreeReadHandler(int port, int mask) {
        IoHandler.IO_FreeReadHandler(port, mask, 1);
    }

    public static void IO_FreeReadHandler(int port, int mask, int range) {
        while (range-- != 0) {
            if ((mask & 1) != 0) {
                IoHandler.io_readhandlers[0][port] = IO_ReadDefault;
            }
            if ((mask & 2) != 0) {
                IoHandler.io_readhandlers[1][port] = IO_ReadDefault;
            }
            if ((mask & 4) != 0) {
                IoHandler.io_readhandlers[2][port] = IO_ReadDefault;
            }
            ++port;
        }
    }

    public static void IO_FreeWriteHandler(int port, int mask) {
        IoHandler.IO_FreeWriteHandler(port, mask, 1);
    }

    public static void IO_FreeWriteHandler(int port, int mask, int range) {
        while (range-- != 0) {
            if ((mask & 1) != 0) {
                IoHandler.io_writehandlers[0][port] = IO_WriteDefault;
            }
            if ((mask & 2) != 0) {
                IoHandler.io_writehandlers[1][port] = IO_WriteDefault;
            }
            if ((mask & 4) != 0) {
                IoHandler.io_writehandlers[2][port] = IO_WriteDefault;
            }
            ++port;
        }
    }

    public static class IO_WriteHandleObject
    extends IO_Base {
        public void Install(int port, IO_WriteHandler handler2, int mask) {
            this.Install(port, handler2, mask, 1);
        }

        public void Install(int port, IO_WriteHandler handler2, int mask, int range) {
            if (!this.installed) {
                this.installed = true;
                this.m_port = port;
                this.m_mask = mask;
                this.m_range = range;
                IoHandler.IO_RegisterWriteHandler(port, handler2, mask, range);
            } else {
                Log.exit("IO_writeHandler allready installed port " + Integer.toString(port, 16));
            }
        }

        public void destroy() {
            if (!this.installed) {
                return;
            }
            IoHandler.IO_FreeWriteHandler(this.m_port, this.m_mask, this.m_range);
        }
    }

    public static class IO_ReadHandleObject
    extends IO_Base {
        public void Install(int port, IO_ReadHandler handler2, int mask) {
            this.Install(port, handler2, mask, 1);
        }

        public void Install(int port, IO_ReadHandler handler2, int mask, int range) {
            if (!this.installed) {
                this.installed = true;
                this.m_port = port;
                this.m_mask = mask;
                this.m_range = range;
                IoHandler.IO_RegisterReadHandler(port, handler2, mask, range);
            } else {
                Log.exit("IO_readHandler allready installed port " + Integer.toString(port, 16));
            }
        }

        public void destroy() {
            if (!this.installed) {
                return;
            }
            IoHandler.IO_FreeReadHandler(this.m_port, this.m_mask, this.m_range);
        }
    }

    private static class IO_Base {
        protected boolean installed = false;
        protected int m_port;
        protected int m_mask;
        protected int m_range;

        private IO_Base() {
        }
    }

    public static interface IO_WriteHandler {
        public void call(int var1, int var2, int var3);
    }

    public static interface IO_ReadHandler {
        public int call(int var1, int var2);
    }
}

