/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.PCSpeaker;
import jdos.hardware.Pic;
import jdos.hardware.Timer;
import jdos.misc.Log;
import jdos.misc.setup.Section;

public class Keyboard {
    private static final int KEYBUFSIZE = 32;
    private static final float KEYDELAY = 0.3f;
    private static Keyb keyb = new Keyb();
    private static Pic.PIC_EventHandler KEYBOARD_TransferBuffer = new Pic.PIC_EventHandler(){

        public void call(int val) {
            keyb.scheduled = false;
            if (keyb.used == 0) {
                Log.log(16, 0, "Transfer started with empty buffer");
                return;
            }
            Keyboard.KEYBOARD_SetPort60((short)(keyb.buffer[keyb.pos] & 0xFF));
            if (++keyb.pos >= 32) {
                keyb.pos -= 32;
            }
            --keyb.used;
        }

        public String toString() {
            return "KEYBOARD_TransferBuffer";
        }
    };
    private static IoHandler.IO_ReadHandler read_p60 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            keyb.p60changed = false;
            if (!keyb.scheduled && keyb.used != 0) {
                keyb.scheduled = true;
                Pic.PIC_AddEvent(KEYBOARD_TransferBuffer, 0.3f);
            }
            return keyb.p60data;
        }
    };
    private static IoHandler.IO_WriteHandler write_p60 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (keyb.command) {
                case 0: {
                    Keyboard.KEYBOARD_ClrBuffer();
                    switch (val) {
                        case 237: {
                            keyb.command = 1;
                            Keyboard.KEYBOARD_AddBuffer(250);
                            break;
                        }
                        case 238: {
                            Keyboard.KEYBOARD_AddBuffer(250);
                            break;
                        }
                        case 242: {
                            Keyboard.KEYBOARD_AddBuffer(250);
                            break;
                        }
                        case 243: {
                            keyb.command = 2;
                            Keyboard.KEYBOARD_AddBuffer(250);
                            break;
                        }
                        case 244: {
                            Log.log(16, 0, "Clear buffer,enable Scaning");
                            Keyboard.KEYBOARD_AddBuffer(250);
                            keyb.scanning = true;
                            break;
                        }
                        case 245: {
                            Log.log(16, 0, "Reset, disable scanning");
                            keyb.scanning = false;
                            Keyboard.KEYBOARD_AddBuffer(250);
                            break;
                        }
                        case 246: {
                            Log.log(16, 0, "Reset, enable scanning");
                            Keyboard.KEYBOARD_AddBuffer(250);
                            keyb.scanning = false;
                            break;
                        }
                        default: {
                            Log.log(16, 2, "60:Unhandled command " + Integer.toString(val, 16));
                            Keyboard.KEYBOARD_AddBuffer(250);
                        }
                    }
                    return;
                }
                case 3: {
                    Memory.MEM_A20_Enable((val & 2) > 0);
                    keyb.command = 0;
                    break;
                }
                case 2: {
                    int[] delay = new int[]{250, 500, 750, 1000};
                    int[] repeat = new int[]{33, 37, 42, 46, 50, 54, 58, 63, 67, 75, 83, 92, 100, 109, 118, 125, 133, 149, 167, 182, 200, 217, 233, 250, 270, 303, 333, 370, 400, 435, 476, 500};
                    keyb.repeat.pause = delay[val >> 5 & 3];
                    keyb.repeat.rate = repeat[val & 0x1F];
                    keyb.command = 0;
                }
                case 1: {
                    keyb.command = 0;
                    Keyboard.KEYBOARD_ClrBuffer();
                    Keyboard.KEYBOARD_AddBuffer(250);
                }
            }
        }
    };
    static short port_61_data = 0;
    private static IoHandler.IO_ReadHandler read_p61 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            port_61_data = (short)(port_61_data ^ 0x20);
            port_61_data = (short)(port_61_data ^ 0x10);
            return port_61_data;
        }
    };
    private static IoHandler.IO_WriteHandler write_p61 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            if (((port_61_data ^ val) & 3) != 0) {
                if (((port_61_data ^ val) & 1) != 0) {
                    Timer.TIMER_SetGate2((val & 1) != 0);
                }
                PCSpeaker.PCSPEAKER_SetType(val & 3);
            }
            port_61_data = (short)val;
        }
    };
    private static IoHandler.IO_WriteHandler write_p64 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (val) {
                case 174: {
                    keyb.active = true;
                    if (keyb.used != 0 && !keyb.scheduled && !keyb.p60changed) {
                        keyb.scheduled = true;
                        Pic.PIC_AddEvent(KEYBOARD_TransferBuffer, 0.3f);
                    }
                    Log.log(16, 0, "Activated");
                    break;
                }
                case 173: {
                    keyb.active = false;
                    Log.log(16, 0, "De-Activated");
                    break;
                }
                case 208: {
                    Keyboard.KEYBOARD_SetPort60((short)(Memory.MEM_A20_Enabled() ? 2 : 0));
                    break;
                }
                case 209: {
                    keyb.command = 3;
                    break;
                }
                default: {
                    Log.log(16, 2, "Port 64 write with val " + val);
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p64 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int status = 0x1C | (keyb.p60changed ? 1 : 0);
            return status;
        }
    };
    private static Timer.TIMER_TickHandler KEYBOARD_TickHandler = new Timer.TIMER_TickHandler(){

        public void call() {
            if (keyb.repeat.wait != 0) {
                --keyb.repeat.wait;
                if (keyb.repeat.wait == 0) {
                    Keyboard.KEYBOARD_AddKey(keyb.repeat.key, true);
                }
            }
        }
    };
    public static Section.SectionFunction KEYBOARD_ShutDown = new Section.SectionFunction(){

        public void call(Section section) {
            keyb = null;
        }
    };
    public static Section.SectionFunction KEYBOARD_Init = new Section.SectionFunction(){

        public void call(Section section) {
            keyb = new Keyb();
            IoHandler.IO_RegisterWriteHandler(96, write_p60, 1);
            IoHandler.IO_RegisterReadHandler(96, read_p60, 1);
            IoHandler.IO_RegisterWriteHandler(97, write_p61, 1);
            IoHandler.IO_RegisterReadHandler(97, read_p61, 1);
            IoHandler.IO_RegisterWriteHandler(100, write_p64, 1);
            IoHandler.IO_RegisterReadHandler(100, read_p64, 1);
            Timer.TIMER_AddTickHandler(KEYBOARD_TickHandler);
            write_p61.call(0, 0, 0);
            keyb.active = true;
            keyb.scanning = true;
            keyb.command = 0;
            keyb.p60changed = false;
            keyb.repeat.key = 0;
            keyb.repeat.pause = 500;
            keyb.repeat.rate = 33;
            keyb.repeat.wait = 0;
            Keyboard.KEYBOARD_ClrBuffer();
            section.AddDestroyFunction(KEYBOARD_ShutDown, false);
        }
    };

    private static void KEYBOARD_SetPort60(short val) {
        Keyboard.keyb.p60changed = true;
        Keyboard.keyb.p60data = val;
        if (Dosbox.machine == 3) {
            Pic.PIC_ActivateIRQ(6);
        } else {
            Pic.PIC_ActivateIRQ(1);
        }
    }

    public static void KEYBOARD_ClrBuffer() {
        Keyboard.keyb.used = 0;
        Keyboard.keyb.pos = 0;
        Pic.PIC_RemoveEvents(KEYBOARD_TransferBuffer);
        Keyboard.keyb.scheduled = false;
    }

    private static void KEYBOARD_AddBuffer(int data) {
        if (Keyboard.keyb.used >= 32) {
            Log.log(16, 0, "Buffer full, dropping code");
            return;
        }
        int start = Keyboard.keyb.pos + Keyboard.keyb.used;
        if (start >= 32) {
            start -= 32;
        }
        Keyboard.keyb.buffer[start] = (byte)data;
        ++Keyboard.keyb.used;
        if (!Keyboard.keyb.scheduled && !Keyboard.keyb.p60changed) {
            Keyboard.keyb.scheduled = true;
            Pic.PIC_AddEvent(KEYBOARD_TransferBuffer, 0.3f);
        }
    }

    public static void KEYBOARD_AddKey(int keytype, boolean pressed) {
        int ret = 0;
        boolean extend = false;
        switch (keytype) {
            case 49: {
                ret = 1;
                break;
            }
            case 1: {
                ret = 2;
                break;
            }
            case 2: {
                ret = 3;
                break;
            }
            case 3: {
                ret = 4;
                break;
            }
            case 4: {
                ret = 5;
                break;
            }
            case 5: {
                ret = 6;
                break;
            }
            case 6: {
                ret = 7;
                break;
            }
            case 7: {
                ret = 8;
                break;
            }
            case 8: {
                ret = 9;
                break;
            }
            case 9: {
                ret = 10;
                break;
            }
            case 10: {
                ret = 11;
                break;
            }
            case 64: {
                ret = 12;
                break;
            }
            case 65: {
                ret = 13;
                break;
            }
            case 51: {
                ret = 14;
                break;
            }
            case 50: {
                ret = 15;
                break;
            }
            case 11: {
                ret = 16;
                break;
            }
            case 12: {
                ret = 17;
                break;
            }
            case 13: {
                ret = 18;
                break;
            }
            case 14: {
                ret = 19;
                break;
            }
            case 15: {
                ret = 20;
                break;
            }
            case 16: {
                ret = 21;
                break;
            }
            case 17: {
                ret = 22;
                break;
            }
            case 18: {
                ret = 23;
                break;
            }
            case 19: {
                ret = 24;
                break;
            }
            case 20: {
                ret = 25;
                break;
            }
            case 67: {
                ret = 26;
                break;
            }
            case 68: {
                ret = 27;
                break;
            }
            case 52: {
                ret = 28;
                break;
            }
            case 56: {
                ret = 29;
                break;
            }
            case 21: {
                ret = 30;
                break;
            }
            case 22: {
                ret = 31;
                break;
            }
            case 23: {
                ret = 32;
                break;
            }
            case 24: {
                ret = 33;
                break;
            }
            case 25: {
                ret = 34;
                break;
            }
            case 26: {
                ret = 35;
                break;
            }
            case 27: {
                ret = 36;
                break;
            }
            case 28: {
                ret = 37;
                break;
            }
            case 29: {
                ret = 38;
                break;
            }
            case 69: {
                ret = 39;
                break;
            }
            case 70: {
                ret = 40;
                break;
            }
            case 63: {
                ret = 41;
                break;
            }
            case 58: {
                ret = 42;
                break;
            }
            case 66: {
                ret = 43;
                break;
            }
            case 30: {
                ret = 44;
                break;
            }
            case 31: {
                ret = 45;
                break;
            }
            case 32: {
                ret = 46;
                break;
            }
            case 33: {
                ret = 47;
                break;
            }
            case 34: {
                ret = 48;
                break;
            }
            case 35: {
                ret = 49;
                break;
            }
            case 36: {
                ret = 50;
                break;
            }
            case 72: {
                ret = 51;
                break;
            }
            case 71: {
                ret = 52;
                break;
            }
            case 73: {
                ret = 53;
                break;
            }
            case 59: {
                ret = 54;
                break;
            }
            case 98: {
                ret = 55;
                break;
            }
            case 54: {
                ret = 56;
                break;
            }
            case 53: {
                ret = 57;
                break;
            }
            case 60: {
                ret = 58;
                break;
            }
            case 37: {
                ret = 59;
                break;
            }
            case 38: {
                ret = 60;
                break;
            }
            case 39: {
                ret = 61;
                break;
            }
            case 40: {
                ret = 62;
                break;
            }
            case 41: {
                ret = 63;
                break;
            }
            case 42: {
                ret = 64;
                break;
            }
            case 43: {
                ret = 65;
                break;
            }
            case 44: {
                ret = 66;
                break;
            }
            case 45: {
                ret = 67;
                break;
            }
            case 46: {
                ret = 68;
                break;
            }
            case 62: {
                ret = 69;
                break;
            }
            case 61: {
                ret = 70;
                break;
            }
            case 93: {
                ret = 71;
                break;
            }
            case 94: {
                ret = 72;
                break;
            }
            case 95: {
                ret = 73;
                break;
            }
            case 99: {
                ret = 74;
                break;
            }
            case 90: {
                ret = 75;
                break;
            }
            case 91: {
                ret = 76;
                break;
            }
            case 92: {
                ret = 77;
                break;
            }
            case 100: {
                ret = 78;
                break;
            }
            case 87: {
                ret = 79;
                break;
            }
            case 88: {
                ret = 80;
                break;
            }
            case 89: {
                ret = 81;
                break;
            }
            case 96: {
                ret = 82;
                break;
            }
            case 102: {
                ret = 83;
                break;
            }
            case 74: {
                ret = 86;
                break;
            }
            case 47: {
                ret = 87;
                break;
            }
            case 48: {
                ret = 88;
                break;
            }
            case 101: {
                extend = true;
                ret = 28;
                break;
            }
            case 57: {
                extend = true;
                ret = 29;
                break;
            }
            case 97: {
                extend = true;
                ret = 53;
                break;
            }
            case 55: {
                extend = true;
                ret = 56;
                break;
            }
            case 78: {
                extend = true;
                ret = 71;
                break;
            }
            case 84: {
                extend = true;
                ret = 72;
                break;
            }
            case 79: {
                extend = true;
                ret = 73;
                break;
            }
            case 83: {
                extend = true;
                ret = 75;
                break;
            }
            case 86: {
                extend = true;
                ret = 77;
                break;
            }
            case 81: {
                extend = true;
                ret = 79;
                break;
            }
            case 85: {
                extend = true;
                ret = 80;
                break;
            }
            case 82: {
                extend = true;
                ret = 81;
                break;
            }
            case 77: {
                extend = true;
                ret = 82;
                break;
            }
            case 80: {
                extend = true;
                ret = 83;
                break;
            }
            case 76: {
                Keyboard.KEYBOARD_AddBuffer(225);
                Keyboard.KEYBOARD_AddBuffer(0x1D | (pressed ? 0 : 128));
                Keyboard.KEYBOARD_AddBuffer(0x45 | (pressed ? 0 : 128));
                return;
            }
            case 75: {
                return;
            }
            default: {
                Log.exit("Unsupported key press");
            }
        }
        if (pressed) {
            Keyboard.keyb.repeat.wait = Keyboard.keyb.repeat.key == keytype ? Keyboard.keyb.repeat.rate : Keyboard.keyb.repeat.pause;
            Keyboard.keyb.repeat.key = keytype;
        } else {
            Keyboard.keyb.repeat.key = 0;
            Keyboard.keyb.repeat.wait = 0;
            ret = (short)(ret + 128);
        }
        if (extend) {
            Keyboard.KEYBOARD_AddBuffer(224);
        }
        Keyboard.KEYBOARD_AddBuffer(ret);
    }

    private static class Keyb {
        byte[] buffer = new byte[32];
        int used;
        int pos;
        Repeat repeat = new Repeat();
        int command;
        short p60data;
        boolean p60changed;
        boolean active;
        boolean scanning;
        boolean scheduled;

        private Keyb() {
        }

        public static class Repeat {
            int key;
            int wait;
            int pause;
            int rate;
        }
    }

    private static final class KeyCommands {
        public static final int CMD_NONE = 0;
        public static final int CMD_SETLEDS = 1;
        public static final int CMD_SETTYPERATE = 2;
        public static final int CMD_SETOUTPORT = 3;

        private KeyCommands() {
        }
    }

    public static final class KBD_KEYS {
        public static final int KBD_NONE = 0;
        public static final int KBD_1 = 1;
        public static final int KBD_2 = 2;
        public static final int KBD_3 = 3;
        public static final int KBD_4 = 4;
        public static final int KBD_5 = 5;
        public static final int KBD_6 = 6;
        public static final int KBD_7 = 7;
        public static final int KBD_8 = 8;
        public static final int KBD_9 = 9;
        public static final int KBD_0 = 10;
        public static final int KBD_q = 11;
        public static final int KBD_w = 12;
        public static final int KBD_e = 13;
        public static final int KBD_r = 14;
        public static final int KBD_t = 15;
        public static final int KBD_y = 16;
        public static final int KBD_u = 17;
        public static final int KBD_i = 18;
        public static final int KBD_o = 19;
        public static final int KBD_p = 20;
        public static final int KBD_a = 21;
        public static final int KBD_s = 22;
        public static final int KBD_d = 23;
        public static final int KBD_f = 24;
        public static final int KBD_g = 25;
        public static final int KBD_h = 26;
        public static final int KBD_j = 27;
        public static final int KBD_k = 28;
        public static final int KBD_l = 29;
        public static final int KBD_z = 30;
        public static final int KBD_x = 31;
        public static final int KBD_c = 32;
        public static final int KBD_v = 33;
        public static final int KBD_b = 34;
        public static final int KBD_n = 35;
        public static final int KBD_m = 36;
        public static final int KBD_f1 = 37;
        public static final int KBD_f2 = 38;
        public static final int KBD_f3 = 39;
        public static final int KBD_f4 = 40;
        public static final int KBD_f5 = 41;
        public static final int KBD_f6 = 42;
        public static final int KBD_f7 = 43;
        public static final int KBD_f8 = 44;
        public static final int KBD_f9 = 45;
        public static final int KBD_f10 = 46;
        public static final int KBD_f11 = 47;
        public static final int KBD_f12 = 48;
        public static final int KBD_esc = 49;
        public static final int KBD_tab = 50;
        public static final int KBD_backspace = 51;
        public static final int KBD_enter = 52;
        public static final int KBD_space = 53;
        public static final int KBD_leftalt = 54;
        public static final int KBD_rightalt = 55;
        public static final int KBD_leftctrl = 56;
        public static final int KBD_rightctrl = 57;
        public static final int KBD_leftshift = 58;
        public static final int KBD_rightshift = 59;
        public static final int KBD_capslock = 60;
        public static final int KBD_scrolllock = 61;
        public static final int KBD_numlock = 62;
        public static final int KBD_grave = 63;
        public static final int KBD_minus = 64;
        public static final int KBD_equals = 65;
        public static final int KBD_backslash = 66;
        public static final int KBD_leftbracket = 67;
        public static final int KBD_rightbracket = 68;
        public static final int KBD_semicolon = 69;
        public static final int KBD_quote = 70;
        public static final int KBD_period = 71;
        public static final int KBD_comma = 72;
        public static final int KBD_slash = 73;
        public static final int KBD_extra_lt_gt = 74;
        public static final int KBD_printscreen = 75;
        public static final int KBD_pause = 76;
        public static final int KBD_insert = 77;
        public static final int KBD_home = 78;
        public static final int KBD_pageup = 79;
        public static final int KBD_delete = 80;
        public static final int KBD_end = 81;
        public static final int KBD_pagedown = 82;
        public static final int KBD_left = 83;
        public static final int KBD_up = 84;
        public static final int KBD_down = 85;
        public static final int KBD_right = 86;
        public static final int KBD_kp1 = 87;
        public static final int KBD_kp2 = 88;
        public static final int KBD_kp3 = 89;
        public static final int KBD_kp4 = 90;
        public static final int KBD_kp5 = 91;
        public static final int KBD_kp6 = 92;
        public static final int KBD_kp7 = 93;
        public static final int KBD_kp8 = 94;
        public static final int KBD_kp9 = 95;
        public static final int KBD_kp0 = 96;
        public static final int KBD_kpdivide = 97;
        public static final int KBD_kpmultiply = 98;
        public static final int KBD_kpminus = 99;
        public static final int KBD_kpplus = 100;
        public static final int KBD_kpenter = 101;
        public static final int KBD_kpperiod = 102;
        public static final int KBD_LAST = 103;
    }
}

