/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import java.util.Arrays;
import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Paging;
import jdos.hardware.IoHandler;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;
import jdos.util.Ptr;
import jdos.util.StringHelper;

public class Memory
extends Module_base {
    public static final int MEM_PAGESIZE = 4096;
    static final int EXTRA_MEM = 8196;
    static int highwaterMark;
    static Ptr host_memory;
    private static int[] direct;
    private static final int PAGES_IN_BLOCK = 256;
    private static final int SAFE_MEMORY = 32;
    private static final int MAX_MEMORY = 64;
    private static final int MAX_PAGE_ENTRIES = 16384;
    private static final int LFB_PAGES = 512;
    private static final int MAX_LINKS = 20480;
    private static MemoryBlock memory;
    static Ptr MemBase;
    private static IllegalPageHandler illegal_page_handler;
    private static RAMPageHandler ram_page_handler;
    private static ROMPageHandler rom_page_handler;
    private static IoHandler.IO_WriteHandler write_p92;
    private static IoHandler.IO_ReadHandler read_p92;
    private IoHandler.IO_ReadHandleObject ReadHandler = new IoHandler.IO_ReadHandleObject();
    private IoHandler.IO_WriteHandleObject WriteHandler = new IoHandler.IO_WriteHandleObject();
    static Memory test;
    public static Section.SectionFunction MEM_ShutDown;
    public static Section.SectionFunction MEM_Init;

    public static int allocate(int size) {
        int result = highwaterMark;
        highwaterMark += size;
        return result;
    }

    public static byte host_readbs(int address) {
        return (byte)(direct[address >> 2] >>> ((address & 3) << 3));
    }

    public static short host_readb(int address) {
        return (short)(direct[address >> 2] >>> ((address & 3) << 3) & 0xFF);
    }

    public static int host_readw(int address) {
        int rem = address & 3;
        int[] local = direct;
        int index = address >>> 2;
        int val = local[index] >>> (rem << 3);
        if (rem == 3) {
            val |= local[index + 1] << 8;
        }
        return val & 0xFFFF;
    }

    public static int host_readd(int address) {
        int rem = address & 3;
        if (rem == 0) {
            return direct[address >>> 2];
        }
        int off = rem << 3;
        int[] local = direct;
        int index = address >>> 2;
        return local[index] >>> off | local[index + 1] << 32 - off;
    }

    public static void host_writeb(int address, short value) {
        int val;
        int off = (address & 3) << 3;
        int[] local = direct;
        int mask = ~(255 << off);
        int index = address >>> 2;
        local[index] = val = local[index] & mask | (value & 0xFF) << off;
    }

    public static void host_writebs(int address, byte value) {
        int val;
        int off = (address & 3) << 3;
        int[] local = direct;
        int mask = ~(255 << off);
        int index = address >>> 2;
        local[index] = val = local[index] & mask | (value & 0xFF) << off;
    }

    public static void host_writew(int address, int value) {
        int rem = address & 3;
        int[] local = direct;
        int index = address >>> 2;
        value &= 0xFFFF;
        if (rem == 3) {
            local[index] = local[index] & 0xFFFFFF | value << 24;
            local[++index] = local[index] & 0xFFFFFF00 | value >>> 8;
        } else {
            int off = rem << 3;
            int mask = ~(65535 << off);
            local[index] = local[index] & mask | value << off;
        }
    }

    public static void host_writed(int address, int val) {
        int rem = address & 3;
        if (rem == 0) {
            Memory.direct[address >>> 2] = val;
        } else {
            int index = address >>> 2;
            int[] local = direct;
            int off = rem << 3;
            int mask = -1 << off;
            local[index] = local[index] & ~mask | val << off;
            local[++index] = local[index] & mask | val >>> 32 - off;
        }
    }

    public static void host_memcpy(byte[] dest, int dest_offset, int src, int size) {
        int i;
        int begin = src & 3;
        int end = size & 0xFFFFFFFC;
        for (int i2 = 0; i2 < begin && i2 < size; ++i2) {
            dest[i2 + dest_offset] = Memory.host_readbs(src + i2);
        }
        int off = dest_offset + begin;
        int index = src + begin >> 2;
        for (i = begin; i < end && i + 3 < size; i += 4) {
            int v = direct[index++];
            dest[off++] = (byte)v;
            dest[off++] = (byte)(v >> 8);
            dest[off++] = (byte)(v >> 16);
            dest[off++] = (byte)(v >> 24);
        }
        for (i = end; i < size; ++i) {
            dest[i + dest_offset] = Memory.host_readbs(src + i);
        }
    }

    public static void host_memcpy(int[] dest, int dest_offset, int src, int size) {
        System.arraycopy(direct, src >> 2, dest, dest_offset >> 2, size >> 2);
    }

    public static void host_memcpy(int dst, int src, int amount) {
        int src_align = src & 3;
        int dst_align = dst & 3;
        if (src_align == dst_align) {
            while ((src & 3) > 0 && amount > 0) {
                Memory.host_writeb(dst++, Memory.host_readb(src++));
                --amount;
            }
            int len = amount >>> 2;
            if (len > 0) {
                System.arraycopy(direct, src >>> 2, direct, dst >>> 2, len);
            }
            if ((len <<= 2) == amount) {
                return;
            }
            dst += len;
            src += len;
            amount -= len;
        }
        for (int i = 0; i < amount; ++i) {
            Memory.host_writeb(dst++, Memory.host_readb(src++));
        }
    }

    public static void host_zeroset(int dest, int size) {
        if ((dest & 3) == 0) {
            int index = dest >>> 2;
            int len = size >>> 2;
            Arrays.fill(direct, index, index + len, 0);
            size = (size & 3) << 3;
            dest += len << 2;
        }
        boolean b = false;
        for (int i = 0; i < size; ++i) {
            Memory.host_writeb(dest++, (short)(b ? 1 : 0));
        }
    }

    public static void phys_writes(int addr, String s) {
        int i;
        byte[] b = s.getBytes();
        for (i = 0; i < s.length(); ++i) {
            Memory.host_writeb(addr + i, b[i]);
        }
        Memory.host_writeb(addr + i, (short)0);
    }

    public static void phys_writeb(int addr, int val) {
        Memory.host_writeb(addr, (short)val);
    }

    public static void phys_writew(int addr, int val) {
        Memory.host_writew(addr, val);
    }

    public static void phys_writed(int addr, int val) {
        Memory.host_writed(addr, val);
    }

    public static short phys_readb(int addr) {
        return Memory.host_readb(addr);
    }

    public static int phys_readw(int addr) {
        return Memory.host_readw(addr);
    }

    public static int phys_readd(int addr) {
        return Memory.host_readd(addr);
    }

    public static short real_readb(int seg, int off) {
        return Memory.mem_readb((seg << 4) + off);
    }

    public static int real_readw(int seg, int off) {
        return Memory.mem_readw((seg << 4) + off);
    }

    public static int real_readd(int seg, int off) {
        return Memory.mem_readd((seg << 4) + off);
    }

    public static void real_writeb(int seg, int off, int val) {
        Memory.mem_writeb((seg << 4) + off, val);
    }

    public static void real_writew(int seg, int off, int val) {
        Memory.mem_writew((seg << 4) + off, val);
    }

    public static void real_writed(int seg, int off, int val) {
        Memory.mem_writed((seg << 4) + off, val);
    }

    public static int RealSeg(int pt) {
        return pt >>> 16 & 0xFFFF;
    }

    public static int RealOff(int pt) {
        return pt & 0xFFFF;
    }

    public static int Real2Phys(int pt) {
        return (Memory.RealSeg(pt) << 4) + Memory.RealOff(pt);
    }

    public static int PhysMake(int seg, int off) {
        return (seg << 4) + off;
    }

    public static int RealMake(int seg, int off) {
        return (seg << 16) + off;
    }

    public static void RealSetVec(int vec, int pt) {
        Memory.mem_writed(vec << 2, pt);
    }

    public static void RealSetVec(int vec, int pt, IntRef old) {
        old.value = Memory.mem_readd(vec << 2);
        Memory.mem_writed(vec << 2, pt);
    }

    public static int RealSetVec2(int vec, int pt) {
        int ret = Memory.mem_readd(vec << 2);
        Memory.mem_writed(vec << 2, pt);
        return ret;
    }

    public static int RealGetVec(int vec) {
        return Memory.mem_readd(vec << 2);
    }

    public static void MEM_SetLFB(int page, int pages, Paging.PageHandler handler2, Paging.PageHandler mmiohandler) {
        Memory.memory.lfb.handler = handler2;
        Memory.memory.lfb.mmiohandler = mmiohandler;
        Memory.memory.lfb.start_page = page;
        Memory.memory.lfb.end_page = page + pages;
        Memory.memory.lfb.pages = pages;
        Paging.PAGING_ClearTLB();
    }

    public static Paging.PageHandler MEM_GetPageHandler(int phys_page) {
        if (phys_page < Memory.memory.pages) {
            return Memory.memory.phandlers[phys_page];
        }
        if (phys_page >= Memory.memory.lfb.start_page && phys_page < Memory.memory.lfb.end_page) {
            return Memory.memory.lfb.handler;
        }
        if (phys_page >= Memory.memory.lfb.start_page + 4096 && phys_page < Memory.memory.lfb.start_page + 4096 + 16) {
            return Memory.memory.lfb.mmiohandler;
        }
        return illegal_page_handler;
    }

    public static void MEM_SetPageHandler(int phys_page, int pages, Paging.PageHandler handler2) {
        while (pages > 0) {
            Memory.memory.phandlers[phys_page] = handler2;
            ++phys_page;
            --pages;
        }
    }

    public static void MEM_ResetPageHandler(int phys_page, int pages) {
        while (pages > 0) {
            Memory.memory.phandlers[phys_page] = ram_page_handler;
            ++phys_page;
            --pages;
        }
    }

    public static int mem_strlen(int pt) {
        for (int x = 0; x < 1024; ++x) {
            if (Paging.mem_readb_inline(pt + x) != 0) continue;
            return x;
        }
        return 0;
    }

    private static void mem_strcpy(int dest, int src) {
        short r;
        while ((r = Memory.mem_readb(src++)) != 0) {
            Paging.mem_writeb_inline(dest++, r);
        }
        Paging.mem_writeb_inline(dest, (short)0);
    }

    public static void mem_memcpy(int dest, int src, int size) {
        while (size-- != 0) {
            Paging.mem_writeb_inline(dest++, Paging.mem_readb_inline(src++));
        }
    }

    public static void MEM_BlockRead(int pt, short[] data, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            short v1 = Paging.mem_readb_inline(pt++);
            short v2 = Paging.mem_readb_inline(pt++);
            data[i + offset] = (short)(v1 & 0xFF | (v2 & 0xFF) << 16);
        }
    }

    public static void MEM_BlockRead16u(int pt, int[] data, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            short v1 = Paging.mem_readb_inline(pt++);
            short v2 = Paging.mem_readb_inline(pt++);
            data[i + offset] = v1 & 0xFF | (v2 & 0xFF) << 16;
        }
    }

    public static void MEM_BlockRead(int pt, short[] data, int size) {
        for (int i = 0; i < size; ++i) {
            short v1 = Paging.mem_readb_inline(pt++);
            short v2 = Paging.mem_readb_inline(pt++);
            data[i] = (short)(v1 & 0xFF | (v2 & 0xFF) << 16);
        }
    }

    public static String MEM_BlockRead(int pt, int size) {
        byte[] b = new byte[size];
        Memory.MEM_BlockRead(pt, b, size);
        return new String(b, 0, StringHelper.strlen(b));
    }

    public static void MEM_BlockRead(int pt, byte[] data, int size) {
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)(Paging.mem_readb_inline(pt++) & 0xFF);
        }
    }

    public static void MEM_BlockRead(int pt, byte[] data, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            data[i + offset] = (byte)(Paging.mem_readb_inline(pt++) & 0xFF);
        }
    }

    public static void MEM_BlockWrite(int pt, byte[] read, int size) {
        int i;
        for (i = 0; i < size && i < read.length; ++i) {
            Paging.mem_writeb_inline(pt++, read[i]);
        }
        while (i < size) {
            Paging.mem_writeb_inline(pt++, (short)0);
            ++i;
        }
    }

    public static void MEM_BlockWrite(int pt, byte[] read, int offset, int size) {
        int i;
        for (i = 0; i < size && i < read.length; ++i) {
            Paging.mem_writeb_inline(pt++, read[i + offset]);
        }
        while (i < size) {
            Paging.mem_writeb_inline(pt++, (short)0);
            ++i;
        }
    }

    public static void MEM_BlockWrite(int pt, String data, int size) {
        byte[] read = data.getBytes();
        Memory.MEM_BlockWrite(pt, read, size);
    }

    public static void MEM_BlockCopy(int dest, int src, int size) {
        Memory.mem_memcpy(dest, src, size);
    }

    public static String MEM_StrCopy(int pt, int size) {
        short r;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < size && (r = Paging.mem_readb_inline(pt++)) != 0; ++i) {
            buf.append((char)r);
        }
        return buf.toString();
    }

    public static int MEM_TotalPages() {
        return Memory.memory.pages;
    }

    public static int MEM_FreeLargest() {
        int size = 0;
        int largest = 0;
        for (int index = 272; index < Memory.memory.pages; ++index) {
            if (Memory.memory.mhandles[index] == 0) {
                ++size;
                continue;
            }
            if (size > largest) {
                largest = size;
            }
            size = 0;
        }
        if (size > largest) {
            largest = size;
        }
        return largest;
    }

    public static int MEM_FreeTotal() {
        int free = 0;
        for (int index = 272; index < Memory.memory.pages; ++index) {
            if (Memory.memory.mhandles[index] != 0) continue;
            ++free;
        }
        return free;
    }

    private static int MEM_AllocatedPages(int handle) {
        int pages = 0;
        while (handle > 0) {
            ++pages;
            handle = Memory.memory.mhandles[handle];
        }
        return pages;
    }

    private static int BestMatch(int size) {
        int index;
        int first = 0;
        int best = 0xFFFFFFF;
        int best_first = 0;
        for (index = 272; index < Memory.memory.pages; ++index) {
            if (first == 0) {
                if (Memory.memory.mhandles[index] != 0) continue;
                first = index;
                continue;
            }
            if (Memory.memory.mhandles[index] == 0) continue;
            int pages = index - first;
            if (pages == size) {
                return first;
            }
            if (pages > size && pages < best) {
                best = pages;
                best_first = first;
            }
            first = 0;
        }
        if (first != 0 && index - first >= size && index - first < best) {
            return first;
        }
        return best_first;
    }

    public static int MEM_AllocatePages(int pages, boolean sequence) {
        int ret = -1;
        if (pages == 0) {
            return 0;
        }
        if (sequence) {
            int index = Memory.BestMatch(pages);
            if (index == 0) {
                return 0;
            }
            while (pages != 0) {
                if (ret == -1) {
                    ret = index;
                } else {
                    Memory.memory.mhandles[index - 1] = index;
                }
                ++index;
                --pages;
            }
            Memory.memory.mhandles[index - 1] = -1;
        } else {
            if (Memory.MEM_FreeTotal() < pages) {
                return 0;
            }
            int lastIndex = -1;
            while (pages != 0) {
                int index = Memory.BestMatch(1);
                if (index == 0) {
                    Log.exit("MEM:corruption during allocate");
                }
                while (pages != 0 && Memory.memory.mhandles[index] == 0) {
                    if (ret == -1) {
                        ret = index;
                    } else {
                        Memory.memory.mhandles[lastIndex] = index;
                    }
                    lastIndex = index++;
                    --pages;
                }
                Memory.memory.mhandles[lastIndex] = -1;
            }
        }
        return ret;
    }

    public static int MEM_GetNextFreePage() {
        return Memory.BestMatch(1);
    }

    public static void MEM_ReleasePages(int handle) {
        while (handle > 0) {
            int next = Memory.memory.mhandles[handle];
            Memory.memory.mhandles[handle] = 0;
            handle = next;
        }
    }

    public static boolean MEM_ReAllocatePages(IntRef handle, int pages, boolean sequence) {
        if (handle.value <= 0) {
            if (pages == 0) {
                return true;
            }
            handle.value = Memory.MEM_AllocatePages(pages, sequence);
            return handle.value > 0;
        }
        if (pages == 0) {
            Memory.MEM_ReleasePages(handle.value);
            handle.value = -1;
            return true;
        }
        int index = handle.value;
        int last = 0;
        int old_pages = 0;
        while (index > 0) {
            ++old_pages;
            last = index;
            index = Memory.memory.mhandles[index];
        }
        if (old_pages == pages) {
            return true;
        }
        if (old_pages > pages) {
            --pages;
            index = handle.value;
            --old_pages;
            while (pages != 0) {
                index = Memory.memory.mhandles[index];
                --pages;
                --old_pages;
            }
            int next = Memory.memory.mhandles[index];
            Memory.memory.mhandles[index] = -1;
            index = next;
            while (old_pages != 0) {
                next = Memory.memory.mhandles[index];
                Memory.memory.mhandles[index] = 0;
                index = next;
                --old_pages;
            }
            return true;
        }
        int need = pages - old_pages;
        if (sequence) {
            index = last + 1;
            int free = 0;
            while (index < Memory.memory.pages && Memory.memory.mhandles[index] == 0) {
                ++index;
                ++free;
            }
            if (free >= need) {
                index = last;
                while (need != 0) {
                    Memory.memory.mhandles[index] = index + 1;
                    --need;
                    ++index;
                }
                Memory.memory.mhandles[index] = -1;
                return true;
            }
            int newhandle = Memory.MEM_AllocatePages(pages, true);
            if (newhandle == 0) {
                return false;
            }
            Memory.MEM_BlockCopy(newhandle * 4096, handle.value * 4096, old_pages * 4096);
            Memory.MEM_ReleasePages(handle.value);
            handle.value = newhandle;
            return true;
        }
        int rem = Memory.MEM_AllocatePages(need, false);
        if (rem == 0) {
            return false;
        }
        Memory.memory.mhandles[last] = rem;
        return true;
    }

    public static int MEM_NextHandle(int handle) {
        return Memory.memory.mhandles[handle];
    }

    public static int MEM_NextHandleAt(int handle, int where) {
        while (where != 0) {
            --where;
            handle = Memory.memory.mhandles[handle];
        }
        return handle;
    }

    public static boolean MEM_A20_Enabled() {
        return Memory.memory.a20.enabled;
    }

    public static void MEM_A20_Enable(boolean enabled) {
        int phys_base = enabled ? 256 : 0;
        for (int i = 0; i < 16; ++i) {
            Paging.PAGING_MapPage(256 + i, phys_base + i);
        }
        Memory.memory.a20.enabled = enabled;
    }

    public static int mem_unalignedreadw(int address) {
        return Paging.mem_readb_inline(address) | Paging.mem_readb_inline(address + 1) << 8;
    }

    public static int mem_unalignedreadd(int address) {
        return Paging.mem_readb_inline(address) | Paging.mem_readb_inline(address + 1) << 8 | Paging.mem_readb_inline(address + 2) << 16 | Paging.mem_readb_inline(address + 3) << 24;
    }

    public static void mem_unalignedwritew(int address, int val) {
        Paging.mem_writeb_inline(address, (short)val);
        Paging.mem_writeb_inline(address + 1, (short)(val >>= 8));
    }

    public static void mem_unalignedwrited(int address, int val) {
        Paging.mem_writeb_inline(address, (short)val);
        Paging.mem_writeb_inline(address + 1, (short)(val >>= 8));
        Paging.mem_writeb_inline(address + 2, (short)(val >>= 8));
        Paging.mem_writeb_inline(address + 3, (short)(val >>= 8));
    }

    public static short mem_readb(int address) {
        return Paging.mem_readb_inline(address);
    }

    public static int mem_readw(int address) {
        return Paging.mem_readw_inline(address);
    }

    public static int mem_readd(int address) {
        return Paging.mem_readd_inline(address);
    }

    public static void mem_writeb(int address, int val) {
        Paging.mem_writeb_inline(address, (short)val);
    }

    public static void mem_writew(int address, int val) {
        Paging.mem_writew_inline(address, val);
    }

    public static void mem_writed(int address, int val) {
        Paging.mem_writed_inline(address, val);
    }

    public static void RemoveEMSPageFrame() {
        for (int ct = 224; ct < 240; ++ct) {
            Memory.memory.phandlers[ct] = rom_page_handler;
        }
    }

    void PreparePCJRCartRom() {
        for (int ct = 208; ct < 224; ++ct) {
            Memory.memory.phandlers[ct] = rom_page_handler;
        }
    }

    public Memory(Section configuration) {
        super(configuration);
        int i;
        Section_prop section = (Section_prop)configuration;
        int memsize = section.Get_int("memsize");
        if (memsize < 1) {
            memsize = 1;
        }
        if (memsize > 63) {
            Log.log_msg("Maximum memory size is 63 MB");
            memsize = 63;
        }
        if (memsize > 31) {
            Log.log_msg("Memory sizes above 31 MB are NOT recommended.");
            Log.log_msg("Stick with the default values unless you are absolutely certain.");
        }
        try {
            Runtime.getRuntime().gc();
            highwaterMark = memsize * 1024 * 1024;
            int videosize = section.Get_int("vmemsize");
            if (videosize == 0) {
                videosize = 2;
            }
            System.out.println("About to allocate memory " + String.valueOf((highwaterMark + 8196 + 7680 + (videosize *= 0x300000)) / 1024) + "kb: " + String.valueOf(Runtime.getRuntime().freeMemory() / 1024L) + "kb free");
            direct = new int[highwaterMark + 8196 + videosize + 7680 + 3 >> 2];
        }
        catch (OutOfMemoryError e) {
            Log.exit("Can't allocate main memory of " + memsize + " MB");
        }
        Memory.memory.pages = memsize * 1024 * 1024 / 4096;
        Memory.memory.phandlers = new Paging.PageHandler[Memory.memory.pages];
        Memory.memory.mhandles = new int[Memory.memory.pages];
        for (i = 0; i < Memory.memory.pages; ++i) {
            Memory.memory.phandlers[i] = ram_page_handler;
            Memory.memory.mhandles[i] = 0;
        }
        for (i = 192; i < 200; ++i) {
            Memory.memory.phandlers[i] = rom_page_handler;
        }
        for (i = 240; i < 256; ++i) {
            Memory.memory.phandlers[i] = rom_page_handler;
        }
        if (Dosbox.machine == 3) {
            for (i = 224; i < 240; ++i) {
                Memory.memory.phandlers[i] = rom_page_handler;
            }
        }
        Memory.memory.links.used = 0;
        this.WriteHandler.Install(146, write_p92, 1);
        this.ReadHandler.Install(146, read_p92, 1);
        Memory.MEM_A20_Enable(false);
    }

    static /* synthetic */ int[] access$302(int[] x0) {
        direct = x0;
        return x0;
    }

    static {
        memory = new MemoryBlock();
        illegal_page_handler = new IllegalPageHandler();
        ram_page_handler = new RAMPageHandler();
        rom_page_handler = new ROMPageHandler();
        write_p92 = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                if ((val & 1) != 0) {
                    Log.exit("XMS: CPU reset via port 0x92 not supported.");
                }
                memory.a20.controlport = (short)(val & 0xFFFFFFFD);
                Memory.MEM_A20_Enable((val & 2) > 0);
            }
        };
        read_p92 = new IoHandler.IO_ReadHandler(){

            public int call(int port, int iolen) {
                return memory.a20.controlport | (memory.a20.enabled ? 2 : 0);
            }
        };
        MEM_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                MemBase = null;
                host_memory = null;
                Memory.access$302(null);
                test = null;
            }
        };
        MEM_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new Memory(section);
                section.AddDestroyFunction(MEM_ShutDown);
            }
        };
    }

    private static class ROMPageHandler
    extends RAMPageHandler {
        public ROMPageHandler() {
            this.flags = 5;
        }

        public void writeb(int addr, int val) {
            Log.log(8, 2, "Write " + Integer.toString(val, 16) + " to rom at " + Integer.toString(addr, 16));
        }

        public void writew(int addr, int val) {
            Log.log(8, 2, "Write " + Integer.toString(val, 16) + " to rom at " + Integer.toString(addr, 16));
        }

        public void writed(int addr, int val) {
            Log.log(8, 2, "Write " + Integer.toString(val, 16) + " to rom at " + Integer.toString(addr, 16));
        }
    }

    private static class RAMPageHandler
    extends Paging.PageHandler {
        public RAMPageHandler() {
            this.flags = 3;
        }

        public int GetHostReadPt(int phys_page) {
            return phys_page * 4096;
        }

        public int GetHostWritePt(int phys_page) {
            return phys_page * 4096;
        }
    }

    private static class IllegalPageHandler
    extends Paging.PageHandler {
        static int r_lcount = 0;
        static int w_lcount = 0;

        public IllegalPageHandler() {
            this.flags = 48;
        }

        public int readb(int addr) {
            if (r_lcount < 1000) {
                ++r_lcount;
                Log.log_msg(StringHelper.sprintf("Illegal read from %x, CS:IP %8x:%8x", new Object[]{new Integer(addr), new Integer(CPU.Segs_CSval), new Integer(CPU_Regs.reg_eip)}));
            }
            return 0;
        }

        public void writeb(int addr, int val) {
            if (w_lcount < 1000) {
                ++w_lcount;
                Log.log_msg(StringHelper.sprintf("Illegal write to %x, CS:IP %8x:%8x", new Object[]{new Integer(addr), new Integer(CPU.Segs_CSval), new Integer(CPU_Regs.reg_eip)}));
            }
        }
    }

    private static class MemoryBlock {
        public int pages;
        Paging.PageHandler[] phandlers;
        int[] mhandles;
        LinkBlock links = new LinkBlock();
        public Lfb lfb = new Lfb();
        A20 a20 = new A20();

        private MemoryBlock() {
        }

        public static class A20 {
            boolean enabled;
            short controlport;
        }

        public static class Lfb {
            int start_page;
            int end_page;
            int pages;
            Paging.PageHandler handler;
            Paging.PageHandler mmiohandler;
        }
    }

    private static class LinkBlock {
        public int used;
        public long[] pages = new long[20480];

        private LinkBlock() {
        }
    }
}

