/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jdos.Dosbox;
import jdos.hardware.Hardware;
import jdos.hardware.Pic;
import jdos.hardware.Timer;
import jdos.misc.Log;
import jdos.misc.Program;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.FloatRef;
import jdos.util.Ptr;
import jdos.util.ShortPtr;

public class Mixer
extends Program {
    private static final int MIXER_BUFSIZE = 16384;
    private static final int MIXER_BUFMASK = 16383;
    public static final int MAX_AUDIO = Short.MAX_VALUE;
    public static final int MIN_AUDIO = Short.MIN_VALUE;
    private static final int MIXER_SSIZE = 4;
    private static final int MIXER_SHIFT = 14;
    private static final int MIXER_REMAIN = 16383;
    private static final int MIXER_VOLSHIFT = 13;
    private static _Mixer mixer;
    public static byte[] MixTemp8;
    public static short[] MixTemp16;
    private static Timer.TIMER_TickHandler MIXER_Mix;
    private static Timer.TIMER_TickHandler MIXER_Mix_NoSound;
    private static Program.PROGRAMS_Main MIXER_ProgramStart;
    public static Section.SectionFunction MIXER_Stop;
    public static SourceDataLine line;
    private static final Object audioMutex;
    private static byte[] audioBuffer;
    private static boolean audioThreadExit;
    private static Thread audioThread;
    public static Section.SectionFunction MIXER_Init;

    public static void PCSPEAKER_SetCounter(int cntr, int mode) {
    }

    public static void PCSPEAKER_SetType(int mode) {
    }

    static short MIXER_CLIP(int SAMP) {
        if (SAMP < Short.MAX_VALUE) {
            if (SAMP > Short.MIN_VALUE) {
                return (short)SAMP;
            }
            return Short.MIN_VALUE;
        }
        return Short.MAX_VALUE;
    }

    public static MixerChannel MIXER_AddChannel(MIXER_Handler handler2, int freq, String name) {
        MixerChannel chan = new MixerChannel();
        chan.scale = 1.0f;
        chan.handler = handler2;
        chan.name = name;
        chan.SetFreq(freq);
        chan.next = Mixer.mixer.channels;
        chan.SetVolume(1.0f, 1.0f);
        chan.enabled = false;
        Mixer.mixer.channels = chan;
        return chan;
    }

    public static MixerChannel MIXER_FindChannel(String name) {
        MixerChannel chan = Mixer.mixer.channels;
        while (chan != null && !chan.name.equalsIgnoreCase(name)) {
            chan = chan.next;
        }
        return chan;
    }

    public static void MIXER_DelChannel(MixerChannel delchan) {
        MixerChannel chan = Mixer.mixer.channels;
        MixerChannel where = Mixer.mixer.channels;
        while (chan != null) {
            if (chan == delchan) {
                where.next = chan.next;
                return;
            }
            where = chan;
            chan = chan.next;
        }
    }

    private static boolean Mixer_irq_important() {
        return Dosbox.ticksLocked || (Hardware.CaptureState & 0x11) != 0;
    }

    private static void MIXER_MixData(int needed) {
        MixerChannel chan = Mixer.mixer.channels;
        while (chan != null) {
            chan.Mix(needed);
            chan = chan.next;
        }
        if ((Hardware.CaptureState & 0x11) != 0) {
            short[] convert = new short[2048];
            int added = needed - Mixer.mixer.done;
            if (added > 1024) {
                added = 1024;
            }
            int readpos = Mixer.mixer.pos + Mixer.mixer.done & 0x3FFF;
            for (int i = 0; i < added; ++i) {
                int sample = Mixer.mixer.work[readpos][0] >> 13;
                convert[i * 2] = Mixer.MIXER_CLIP(sample);
                sample = Mixer.mixer.work[readpos][1] >> 13;
                convert[i * 2 + 1] = Mixer.MIXER_CLIP(sample);
                readpos = readpos + 1 & 0x3FFF;
            }
            Hardware.CAPTURE_AddWave(Mixer.mixer.freq, added, convert);
        }
        if (Mixer.Mixer_irq_important()) {
            Mixer.mixer.tick_add = (Mixer.mixer.freq << 14) / 1000L;
        }
        Mixer.mixer.done = needed;
    }

    static boolean MIXER_CallBack(int userdata, byte[] stream, int len) {
        int index_add;
        int reduce;
        int need = len / 4;
        ShortPtr output = new ShortPtr(stream, 0);
        if (Mixer.mixer.done < need) {
            if (need - Mixer.mixer.done > need >> 7) {
                return false;
            }
            reduce = Mixer.mixer.done;
            index_add = (reduce << 14) / need;
            Mixer.mixer.tick_add = (Mixer.mixer.freq + (long)Mixer.mixer.min_needed << 14) / 1000L;
        } else if (Mixer.mixer.done < Mixer.mixer.max_needed) {
            int left = Mixer.mixer.done - need;
            if (left < Mixer.mixer.min_needed) {
                if (!Mixer.Mixer_irq_important()) {
                    int needed = Mixer.mixer.needed - need;
                    int diff = (Mixer.mixer.min_needed > needed ? Mixer.mixer.min_needed : needed) - left;
                    Mixer.mixer.tick_add = (Mixer.mixer.freq + (long)(diff * 3) << 14) / 1000L;
                    left = 0;
                } else {
                    left = Mixer.mixer.min_needed - left;
                    left = 1 + 2 * left / Mixer.mixer.min_needed;
                }
                reduce = need - left;
                index_add = (reduce << 14) / need;
            } else {
                reduce = need;
                index_add = 16384;
                int diff = left - Mixer.mixer.min_needed;
                if (diff > Mixer.mixer.min_needed << 1) {
                    diff = Mixer.mixer.min_needed << 1;
                }
                Mixer.mixer.tick_add = diff > Mixer.mixer.min_needed >> 1 ? (Mixer.mixer.freq - (long)(diff / 5) << 14) / 1000L : (diff > Mixer.mixer.min_needed >> 4 ? (Mixer.mixer.freq - (long)(diff >> 3) << 14) / 1000L : (Mixer.mixer.freq << 14) / 1000L);
            }
        } else {
            index_add = Mixer.mixer.done > 16384 ? 16384 - 2 * Mixer.mixer.min_needed : Mixer.mixer.done - 2 * Mixer.mixer.min_needed;
            index_add = (index_add << 14) / need;
            reduce = Mixer.mixer.done - 2 * Mixer.mixer.min_needed;
            Mixer.mixer.tick_add = (Mixer.mixer.freq - (long)(Mixer.mixer.min_needed / 5) << 14) / 1000L;
        }
        MixerChannel chan = Mixer.mixer.channels;
        while (chan != null) {
            chan.done = chan.done > reduce ? (chan.done -= reduce) : 0;
            chan = chan.next;
        }
        if (Mixer.Mixer_irq_important()) {
            Mixer.mixer.tick_add = (Mixer.mixer.freq << 14) / 1000L;
        }
        Mixer.mixer.done -= reduce;
        Mixer.mixer.needed -= reduce;
        int pos = Mixer.mixer.pos;
        Mixer.mixer.pos = Mixer.mixer.pos + reduce & 0x3FFF;
        int index = 0;
        if (need != reduce) {
            while (need-- != 0) {
                int i = pos + (index >> 14) & 0x3FFF;
                index += index_add;
                int sample = Mixer.mixer.work[i][0] >> 13;
                output.setInc(Mixer.MIXER_CLIP(sample));
                sample = Mixer.mixer.work[i][1] >> 13;
                output.setInc(Mixer.MIXER_CLIP(sample));
            }
            while (reduce-- != 0) {
                Mixer.mixer.work[pos &= 0x3FFF][0] = 0;
                Mixer.mixer.work[pos][1] = 0;
                ++pos;
            }
        } else {
            while (reduce-- != 0) {
                int sample = Mixer.mixer.work[pos &= 0x3FFF][0] >> 13;
                output.setInc(Mixer.MIXER_CLIP(sample));
                sample = Mixer.mixer.work[pos][1] >> 13;
                output.setInc(Mixer.MIXER_CLIP(sample));
                Mixer.mixer.work[pos][0] = 0;
                Mixer.mixer.work[pos][1] = 0;
                ++pos;
            }
        }
        return true;
    }

    public void MakeVolume(String scan, FloatRef vol0, FloatRef vol1) {
        boolean db;
        boolean w = false;
        boolean bl = db = scan.toUpperCase().charAt(0) == 'D';
        if (db) {
            scan = scan.substring(1);
        }
        while (scan.length() > 0) {
            if (scan.charAt(0) == ':') {
                scan = scan.substring(0);
                w = true;
            }
            String before = scan;
            float val = 0.0f;
            try {
                int pos = scan.indexOf(32);
                val = pos > 0 ? Float.parseFloat(scan.substring(0, pos)) : Float.parseFloat(scan);
            }
            catch (Exception e) {
                scan = scan.substring(1);
            }
            val = !db ? (val /= 100.0f) : (float)Math.pow(10.0, val / 20.0f);
            if (val < 0.0f) {
                val = 1.0f;
            }
            if (!w) {
                vol0.value = val;
                continue;
            }
            vol1.value = val;
        }
        if (!w) {
            vol1.value = vol0.value;
        }
    }

    public void Run() {
        if (this.cmd.FindExist("/LISTMIDI")) {
            this.ListMidi();
            return;
        }
        this.temp_line = this.cmd.FindString("MASTER", false);
        if (this.temp_line != null) {
            this.MakeVolume(this.temp_line, Mixer.mixer.mastervol[0], Mixer.mixer.mastervol[1]);
        }
        MixerChannel chan = Mixer.mixer.channels;
        while (chan != null) {
            this.temp_line = this.cmd.FindString(chan.name, false);
            if (this.temp_line != null) {
                this.MakeVolume(this.temp_line, chan.volmain[0], chan.volmain[1]);
            }
            chan.UpdateVolume();
            chan = chan.next;
        }
        if (this.cmd.FindExist("/NOSHOW")) {
            return;
        }
        chan = Mixer.mixer.channels;
        this.WriteOut("Channel  Main    Main(dB)\n");
        this.ShowVolume("MASTER", Mixer.mixer.mastervol[0], Mixer.mixer.mastervol[1]);
        chan = Mixer.mixer.channels;
        while (chan != null) {
            this.ShowVolume(chan.name, chan.volmain[0], chan.volmain[1]);
            chan = chan.next;
        }
    }

    private void ShowVolume(String name, FloatRef vol0, FloatRef vol1) {
        this.WriteOut("%-8s %3.0f:%-3.0f  %+3.2f:%-+3.2f \n", new Object[]{name, new Float(vol0.value * 100.0f), new Float(vol1.value * 100.0f), new Float(20.0 * Math.log(vol0.value) / Math.log(10.0)), new Float(20.0 * Math.log(vol1.value) / Math.log(10.0))});
    }

    private void ListMidi() {
        MidiDevice.Info[] devices = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < devices.length; ++i) {
            this.WriteOut("%2d\t \"%s\"\n", new Object[]{new Integer(i), devices[i].getName()});
        }
    }

    private static boolean open(int bufferSize, AudioFormat format) {
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format, bufferSize);
            line.start();
            audioThreadExit = false;
            audioThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!audioThreadExit) {
                        boolean result;
                        Object object = audioMutex;
                        synchronized (object) {
                            result = Mixer.MIXER_CallBack(0, audioBuffer, audioBuffer.length);
                        }
                        if (result) {
                            line.write(audioBuffer, 0, audioBuffer.length);
                            continue;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            audioBuffer = new byte[512];
            audioThread.start();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        MixTemp8 = new byte[16384];
        MixTemp16 = new short[16384];
        MIXER_Mix = new Timer.TIMER_TickHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                Object object = audioMutex;
                synchronized (object) {
                    Mixer.MIXER_MixData(mixer.needed);
                    mixer.tick_remain += mixer.tick_add;
                    mixer.needed = (int)((long)mixer.needed + (mixer.tick_remain >> 14));
                    mixer.tick_remain &= 0x3FFFL;
                }
            }
        };
        MIXER_Mix_NoSound = new Timer.TIMER_TickHandler(){

            public void call() {
                Mixer.MIXER_MixData(mixer.needed);
                for (int i = 0; i < mixer.needed; ++i) {
                    mixer.work[mixer.pos][0] = 0;
                    mixer.work[mixer.pos][1] = 0;
                    mixer.pos = mixer.pos + 1 & 0x3FFF;
                }
                MixerChannel chan = mixer.channels;
                while (chan != null) {
                    chan.done = chan.done > mixer.needed ? (chan.done -= mixer.needed) : 0;
                    chan = chan.next;
                }
                mixer.tick_remain += mixer.tick_add;
                mixer.needed = (int)(mixer.tick_remain >> 14);
                mixer.tick_remain &= 0x3FFFL;
                mixer.done = 0;
            }
        };
        MIXER_ProgramStart = new Program.PROGRAMS_Main(){

            public Program call() {
                return new Mixer();
            }
        };
        MIXER_Stop = new Section.SectionFunction(){

            public void call(Section section) {
                audioThreadExit = true;
                try {
                    audioThread.join(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                line.drain();
                line.stop();
                mixer = null;
            }
        };
        audioMutex = new Object();
        audioThreadExit = false;
        MIXER_Init = new Section.SectionFunction(){

            public void call(Section sec) {
                mixer = new _Mixer();
                sec.AddDestroyFunction(MIXER_Stop);
                Section_prop section = (Section_prop)sec;
                mixer.freq = section.Get_int("rate");
                mixer.nosound = section.Get_bool("nosound");
                mixer.blocksize = section.Get_int("blocksize");
                mixer.channels = null;
                mixer.pos = 0;
                mixer.done = 0;
                mixer.mastervol[0].value = 1.0f;
                mixer.mastervol[1].value = 1.0f;
                mixer.tick_remain = 0L;
                mixer.min_needed = section.Get_int("prebuffer");
                if (mixer.min_needed > 100) {
                    mixer.min_needed = 100;
                }
                mixer.min_needed = (int)(mixer.freq * (long)mixer.min_needed) / 1000;
                mixer.max_needed = mixer.blocksize * 2 + 2 * mixer.min_needed;
                mixer.needed = mixer.min_needed + 1;
                if (mixer.nosound) {
                    Log.log_msg("MIXER:No Sound Mode Selected.");
                    mixer.tick_add = (mixer.freq << 14) / 1000L;
                    Timer.TIMER_AddTickHandler(MIXER_Mix_NoSound);
                } else if (Mixer.open(section.Get_int("javabuffer"), new AudioFormat(mixer.freq, 16, 2, true, false))) {
                    mixer.tick_add = (mixer.freq << 14) / 1000L;
                    Timer.TIMER_AddTickHandler(MIXER_Mix);
                }
                Program.PROGRAMS_MakeFile("MIXER.COM", MIXER_ProgramStart);
            }
        };
    }

    static class _Mixer {
        int[][] work = new int[16384][2];
        int pos;
        int done;
        int needed;
        int min_needed;
        int max_needed;
        long tick_add;
        long tick_remain;
        FloatRef[] mastervol = new FloatRef[2];
        MixerChannel channels;
        boolean nosound;
        long freq;
        int blocksize;

        public _Mixer() {
            for (int i = 0; i < this.mastervol.length; ++i) {
                this.mastervol[i] = new FloatRef();
            }
        }
    }

    public static class MixerObject {
        private boolean installed = false;
        private String m_name;

        public MixerChannel Install(MIXER_Handler handler2, int freq, String name) {
            if (!this.installed) {
                if (name.length() > 31) {
                    Log.exit("Too long mixer channel name");
                }
                this.m_name = name;
                this.installed = true;
                return Mixer.MIXER_AddChannel(handler2, freq, name);
            }
            Log.exit("allready added mixer channel.");
            return null;
        }

        public void destroy() {
            if (!this.installed) {
                return;
            }
            Mixer.MIXER_DelChannel(Mixer.MIXER_FindChannel(this.m_name));
        }
    }

    public static class MixerChannel {
        public MIXER_Handler handler;
        public FloatRef[] volmain = new FloatRef[2];
        public float scale;
        public int[] volmul = new int[2];
        public int freq_add;
        public int freq_index;
        public int done;
        public int needed;
        public int[] last = new int[2];
        public String name;
        public boolean enabled;
        public MixerChannel next;

        public void SetVolume(float _left, float _right) {
            this.volmain[0].value = _left;
            this.volmain[1].value = _right;
            this.UpdateVolume();
        }

        public void SetScale(float f) {
            this.scale = f;
            this.UpdateVolume();
        }

        public void UpdateVolume() {
            this.volmul[0] = (int)(8192.0f * this.scale * this.volmain[0].value * mixer.mastervol[0].value);
            this.volmul[1] = (int)(8192.0f * this.scale * this.volmain[1].value * mixer.mastervol[1].value);
        }

        public void SetFreq(int _freq) {
            this.freq_add = (int)((long)(_freq << 14) / mixer.freq);
        }

        public void Mix(int _needed) {
            this.needed = _needed;
            while (this.enabled && this.needed > this.done) {
                int todo = this.needed - this.done;
                todo = (todo >> 14) + (((todo *= this.freq_add) & 0x3FFF) != 0 ? 1 : 0);
                this.handler.call(todo);
            }
        }

        public void AddSilence() {
            if (this.done < this.needed) {
                this.done = this.needed;
                this.last[1] = 0;
                this.last[0] = 0;
                this.freq_index = 16383;
            }
        }

        public void AddSamples(int len, Ptr data, boolean stereo, boolean signeddata, boolean nativeorder) {
            int[] diff = new int[2];
            int mixpos = mixer.pos + this.done;
            this.freq_index &= 0x3FFF;
            int pos = 0;
            int new_pos = 0;
            boolean starting = true;
            while (true) {
                if (!starting) {
                    new_pos = this.freq_index >> 14;
                }
                if (starting || pos < new_pos) {
                    if (!starting) {
                        this.last[0] = this.last[0] + diff[0];
                        if (stereo) {
                            this.last[1] = this.last[1] + diff[1];
                        }
                        pos = new_pos;
                    } else {
                        starting = false;
                    }
                    if (pos >= len) {
                        return;
                    }
                    if (data.dataWidth() == 1) {
                        if (!signeddata) {
                            if (stereo) {
                                diff[0] = ((byte)(data.get(pos * 2 + 0) ^ 0x80) << 8) - this.last[0];
                                diff[1] = ((byte)(data.get(pos * 2 + 1) ^ 0x80) << 8) - this.last[1];
                            } else {
                                diff[0] = ((byte)(data.get(pos) ^ 0x80) << 8) - this.last[0];
                            }
                        } else if (stereo) {
                            diff[0] = (data.get(pos * 2 + 0) << 8) - this.last[0];
                            diff[1] = (data.get(pos * 2 + 1) << 8) - this.last[1];
                        } else {
                            diff[0] = (data.get(pos) << 8) - this.last[0];
                        }
                    } else if (signeddata) {
                        if (stereo) {
                            if (nativeorder) {
                                diff[0] = (short)data.get(pos * 2 + 0) - this.last[0];
                                diff[1] = (short)data.get(pos * 2 + 1) - this.last[1];
                            } else {
                                diff[0] = data.get(pos * 2) - this.last[0];
                                diff[1] = data.get(pos * 2 + 1) - this.last[1];
                            }
                        } else {
                            diff[0] = nativeorder ? (short)data.get(pos) - this.last[0] : data.get(pos) - this.last[0];
                        }
                    } else if (stereo) {
                        if (nativeorder) {
                            diff[0] = data.get(pos * 2 + 0) - 32768 - this.last[0];
                            diff[1] = data.get(pos * 2 + 1) - 32768 - this.last[1];
                        } else {
                            diff[0] = data.get(pos * 2) - 32768 - this.last[0];
                            diff[1] = data.get(pos * 2 + 1) - 32768 - this.last[1];
                        }
                    } else {
                        diff[0] = nativeorder ? data.get(pos) - 32768 - this.last[0] : data.get(pos) - 32768 - this.last[0];
                    }
                }
                int diff_mul = this.freq_index & 0x3FFF;
                this.freq_index += this.freq_add;
                int sample = this.last[0] + (diff[0] * diff_mul >> 14);
                int[] nArray = mixer.work[mixpos &= 0x3FFF];
                nArray[0] = nArray[0] + sample * this.volmul[0];
                if (stereo) {
                    sample = this.last[1] + (diff[1] * diff_mul >> 14);
                }
                int[] nArray2 = mixer.work[mixpos];
                nArray2[1] = nArray2[1] + sample * this.volmul[1];
                ++mixpos;
                ++this.done;
            }
        }

        public void AddSamples(int len, short[] data, boolean stereo, boolean signeddata) {
            int[] diff = new int[2];
            int mixpos = mixer.pos + this.done;
            this.freq_index &= 0x3FFF;
            int pos = 0;
            int new_pos = 0;
            boolean starting = true;
            while (true) {
                if (!starting) {
                    new_pos = this.freq_index >> 14;
                }
                if (starting || pos < new_pos) {
                    if (!starting) {
                        this.last[0] = this.last[0] + diff[0];
                        if (stereo) {
                            this.last[1] = this.last[1] + diff[1];
                        }
                        pos = new_pos;
                    } else {
                        starting = false;
                    }
                    if (pos >= len) {
                        return;
                    }
                    if (signeddata) {
                        if (stereo) {
                            diff[0] = data[pos * 2 + 0] - this.last[0];
                            diff[1] = data[pos * 2 + 1] - this.last[1];
                        } else {
                            diff[0] = data[pos] - this.last[0];
                        }
                    } else if (stereo) {
                        diff[0] = data[pos * 2 + 0] - 32768 - this.last[0];
                        diff[1] = data[pos * 2 + 1] - 32768 - this.last[1];
                    } else {
                        diff[0] = data[pos] - 32768 - this.last[0];
                    }
                }
                int diff_mul = this.freq_index & 0x3FFF;
                this.freq_index += this.freq_add;
                int sample = this.last[0] + (diff[0] * diff_mul >> 14);
                int[] nArray = mixer.work[mixpos &= 0x3FFF];
                nArray[0] = nArray[0] + sample * this.volmul[0];
                if (stereo) {
                    sample = this.last[1] + (diff[1] * diff_mul >> 14);
                }
                int[] nArray2 = mixer.work[mixpos];
                nArray2[1] = nArray2[1] + sample * this.volmul[1];
                ++mixpos;
                ++this.done;
            }
        }

        public void AddSamples(int len, int[] data, boolean stereo, boolean signeddata) {
            int[] diff = new int[2];
            int mixpos = mixer.pos + this.done;
            this.freq_index &= 0x3FFF;
            int pos = 0;
            int new_pos = 0;
            boolean starting = true;
            while (true) {
                if (!starting) {
                    new_pos = this.freq_index >> 14;
                }
                if (starting || pos < new_pos) {
                    if (!starting) {
                        this.last[0] = this.last[0] + diff[0];
                        if (stereo) {
                            this.last[1] = this.last[1] + diff[1];
                        }
                        pos = new_pos;
                    } else {
                        starting = false;
                    }
                    if (pos >= len) {
                        return;
                    }
                    if (signeddata) {
                        if (stereo) {
                            diff[0] = data[pos * 2 + 0] - this.last[0];
                            diff[1] = data[pos * 2 + 1] - this.last[1];
                        } else {
                            diff[0] = data[pos] - this.last[0];
                        }
                    } else if (stereo) {
                        diff[0] = data[pos * 2 + 0] - 32768 - this.last[0];
                        diff[1] = data[pos * 2 + 1] - 32768 - this.last[1];
                    } else {
                        diff[0] = data[pos] - 32768 - this.last[0];
                    }
                }
                int diff_mul = this.freq_index & 0x3FFF;
                this.freq_index += this.freq_add;
                int sample = this.last[0] + (diff[0] * diff_mul >> 14);
                int[] nArray = mixer.work[mixpos &= 0x3FFF];
                nArray[0] = nArray[0] + sample * this.volmul[0];
                if (stereo) {
                    sample = this.last[1] + (diff[1] * diff_mul >> 14);
                }
                int[] nArray2 = mixer.work[mixpos];
                nArray2[1] = nArray2[1] + sample * this.volmul[1];
                ++mixpos;
                ++this.done;
            }
        }

        public void AddSamples(int len, byte[] data, boolean stereo, boolean signeddata) {
            int[] diff = new int[2];
            int mixpos = mixer.pos + this.done;
            this.freq_index &= 0x3FFF;
            int pos = 0;
            int new_pos = 0;
            boolean starting = true;
            while (true) {
                if (!starting) {
                    new_pos = this.freq_index >> 14;
                }
                if (starting || pos < new_pos) {
                    if (!starting) {
                        this.last[0] = this.last[0] + diff[0];
                        if (stereo) {
                            this.last[1] = this.last[1] + diff[1];
                        }
                        pos = new_pos;
                    } else {
                        starting = false;
                    }
                    if (pos >= len) {
                        return;
                    }
                    if (!signeddata) {
                        if (stereo) {
                            diff[0] = ((byte)(data[pos * 2 + 0] ^ 0x80) << 8) - this.last[0];
                            diff[1] = ((byte)(data[pos * 2 + 1] ^ 0x80) << 8) - this.last[1];
                        } else {
                            diff[0] = ((byte)(data[pos] ^ 0x80) << 8) - this.last[0];
                        }
                    } else if (stereo) {
                        diff[0] = (data[pos * 2 + 0] << 8) - this.last[0];
                        diff[1] = (data[pos * 2 + 1] << 8) - this.last[1];
                    } else {
                        diff[0] = (data[pos] << 8) - this.last[0];
                    }
                }
                int diff_mul = this.freq_index & 0x3FFF;
                this.freq_index += this.freq_add;
                int sample = this.last[0] + (diff[0] * diff_mul >> 14);
                int[] nArray = mixer.work[mixpos &= 0x3FFF];
                nArray[0] = nArray[0] + sample * this.volmul[0];
                if (stereo) {
                    sample = this.last[1] + (diff[1] * diff_mul >> 14);
                }
                int[] nArray2 = mixer.work[mixpos];
                nArray2[1] = nArray2[1] + sample * this.volmul[1];
                ++mixpos;
                ++this.done;
            }
        }

        public void AddSamples_m8(int len, byte[] data) {
            this.AddSamples(len, data, false, false);
        }

        public void AddSamples_s8(int len, byte[] data) {
            this.AddSamples(len, data, true, false);
        }

        public void AddSamples_m8s(int len, byte[] data) {
            this.AddSamples(len, data, false, true);
        }

        public void AddSamples_s8s(int len, byte[] data) {
            this.AddSamples(len, data, true, true);
        }

        public void AddSamples_m16(int len, short[] data) {
            this.AddSamples(len, data, false, true);
        }

        public void AddSamples_s16(int len, short[] data) {
            this.AddSamples(len, data, true, true);
        }

        public void AddSamples_m16u(int len, short[] data) {
            this.AddSamples(len, data, false, false);
        }

        public void AddSamples_s16u(int len, short[] data) {
            this.AddSamples(len, data, true, false);
        }

        public void AddSamples_m32(int len, int[] data) {
            this.AddSamples(len, data, false, true);
        }

        public void AddSamples_s32(int len, int[] data) {
            this.AddSamples(len, data, true, true);
        }

        public void AddStretched(int len, short[] data) {
            if (this.done >= this.needed) {
                Log.log_msg("Can't add, buffer full");
                return;
            }
            int outlen = this.needed - this.done;
            this.freq_index = 0;
            int temp_add = (len << 14) / outlen;
            int mixpos = mixer.pos + this.done;
            this.done = this.needed;
            int pos = 0;
            int diff = data[0] - this.last[0];
            while (outlen-- != 0) {
                int new_pos = this.freq_index >> 14;
                if (pos < new_pos) {
                    pos = new_pos;
                    this.last[0] = this.last[0] + diff;
                    diff = data[pos] - this.last[0];
                }
                int diff_mul = this.freq_index & 0x3FFF;
                this.freq_index += temp_add;
                int sample = this.last[0] + (diff * diff_mul >> 14);
                int[] nArray = mixer.work[mixpos &= 0x3FFF];
                nArray[0] = nArray[0] + sample * this.volmul[0];
                int[] nArray2 = mixer.work[mixpos];
                nArray2[1] = nArray2[1] + sample * this.volmul[1];
                ++mixpos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void FillUp() {
            Object object = audioMutex;
            synchronized (object) {
                if (!this.enabled || this.done < mixer.done) {
                    return;
                }
                float index = Pic.PIC_TickIndex();
                this.Mix((int)(index * (float)mixer.needed));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Enable(boolean _yesno) {
            if (_yesno == this.enabled) {
                return;
            }
            this.enabled = _yesno;
            if (this.enabled) {
                this.freq_index = 16383;
                Object object = audioMutex;
                synchronized (object) {
                    if (this.done < mixer.done) {
                        this.done = mixer.done;
                    }
                }
            }
        }

        public MixerChannel() {
            for (int i = 0; i < this.volmain.length; ++i) {
                this.volmain[i] = new FloatRef();
            }
        }

        private static interface getSample {
            public int call(int var1);
        }

        public static class Type {
        }
    }

    private static final class MixerModes {
        public static final int M_8M = 0;
        public static final int M_8S = 1;
        public static final int M_16M = 2;
        public static final int M_16S = 3;

        private MixerModes() {
        }
    }

    private static final class BlahModes {
        public static final int MIXER_8MONO = 0;
        public static final int MIXER_8STEREO = 1;
        public static final int MIXER_16MONO = 2;
        public static final int MIXER_16STEREO = 3;

        private BlahModes() {
        }
    }

    public static interface MIXER_Handler {
        public void call(int var1);
    }

    public static interface MIXER_MixHandler {
        public void call(short[] var1, int var2);
    }
}

