/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core_normal;
import jdos.hardware.IoHandler;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;

public class Pic
extends Module_base {
    public static final int PIC_MAXIRQ = 15;
    public static final int PIC_NOIRQ = 255;
    private static int PIC_QUEUESIZE = 512;
    public static int PIC_Ticks;
    public static int PIC_IRQCheck;
    public static int PIC_IRQOnSecondPicActive;
    public static int PIC_IRQActive;
    private static IRQ_Block[] irqs;
    private static PIC_Controller[] pics;
    private static boolean PIC_Special_Mode;
    public static Pic_queue pic_queue;
    private static IoHandler.IO_WriteHandler write_command;
    private static IoHandler.IO_WriteHandler write_data;
    private static IoHandler.IO_ReadHandler read_command;
    private static IoHandler.IO_ReadHandler read_data;
    static boolean InEventService;
    static double srv_lag;
    IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[4];
    IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[4];
    static Pic test;
    public static Section.SectionFunction PIC_Destroy;
    public static Section.SectionFunction PIC_Init;

    public static float PIC_TickIndex() {
        return (float)(CPU.CPU_CycleMax - CPU.CPU_CycleLeft - CPU.CPU_Cycles) / (float)CPU.CPU_CycleMax;
    }

    public static int PIC_TickIndexND() {
        return CPU.CPU_CycleMax - CPU.CPU_CycleLeft - CPU.CPU_Cycles;
    }

    public static int PIC_MakeCycles(double amount) {
        return (int)((double)CPU.CPU_CycleMax * amount);
    }

    public static double PIC_FullIndex() {
        return (double)PIC_Ticks + (double)Pic.PIC_TickIndex();
    }

    public static void PIC_ActivateIRQ(int irq) {
        if (irq < 8) {
            Pic.irqs[irq].active = true;
            if (!Pic.irqs[irq].masked) {
                PIC_IRQCheck |= 1 << irq;
            }
        } else if (irq < 16) {
            Pic.irqs[irq].active = true;
            PIC_IRQOnSecondPicActive |= 1 << irq;
            if (!Pic.irqs[irq].masked && !Pic.irqs[2].masked) {
                PIC_IRQCheck |= 1 << irq;
            }
        }
    }

    public static void PIC_DeActivateIRQ(int irq) {
        if (irq < 16) {
            Pic.irqs[irq].active = false;
            PIC_IRQCheck &= ~(1 << irq);
            PIC_IRQOnSecondPicActive &= ~(1 << irq);
        }
    }

    public static void PIC_runIRQs() {
        if (CPU_Regs.GETFLAG(512) == 0) {
            return;
        }
        if (PIC_IRQCheck == 0) {
            return;
        }
        if (CPU.cpudecoder == Core_normal.CPU_Core_Normal_Trap_Run) {
            return;
        }
        int[] IRQ_priority_order = new int[]{0, 1, 2, 8, 9, 10, 11, 12, 13, 14, 15, 3, 4, 5, 6, 7};
        int[] IRQ_priority_lookup = new int[]{0, 1, 2, 11, 12, 13, 14, 15, 3, 4, 5, 6, 7, 8, 9, 10, 16};
        int activeIRQ = PIC_IRQActive;
        if (activeIRQ == 255) {
            activeIRQ = 16;
        }
        int Priority_Active_IRQ = IRQ_priority_lookup[activeIRQ];
        if (!PIC_Special_Mode) {
            for (int j = 0; j < Priority_Active_IRQ; ++j) {
                int i = IRQ_priority_order[j];
                if (Pic.irqs[i].masked || !Pic.irqs[i].active || !Pic.PIC_startIRQ(i)) continue;
                return;
            }
        } else {
            for (int j = 0; j <= 15; ++j) {
                int i = IRQ_priority_order[j];
                if (j >= Priority_Active_IRQ && !Pic.pics[(i & 8) >> 3].special || Pic.irqs[i].masked || !Pic.irqs[i].active || !Pic.PIC_startIRQ(i)) continue;
                return;
            }
        }
    }

    public static boolean PIC_RunQueue() {
        CPU.CPU_CycleLeft += CPU.CPU_Cycles;
        CPU.CPU_Cycles = 0;
        if (CPU.CPU_CycleLeft <= 0) {
            return false;
        }
        int index_nd = Pic.PIC_TickIndexND();
        InEventService = true;
        while (Pic.pic_queue.next_entry != null && Pic.pic_queue.next_entry.index * (double)CPU.CPU_CycleMax <= (double)index_nd) {
            PICEntry entry = Pic.pic_queue.next_entry;
            Pic.pic_queue.next_entry = entry.next;
            srv_lag = entry.index;
            entry.pic_event.call(entry.value);
            entry.next = Pic.pic_queue.free_entry;
            Pic.pic_queue.free_entry = entry;
        }
        InEventService = false;
        if (Pic.pic_queue.next_entry != null) {
            int cycles = (int)(Pic.pic_queue.next_entry.index * (double)CPU.CPU_CycleMax - (double)index_nd);
            if (cycles == 0) {
                cycles = 1;
            }
            CPU.CPU_Cycles = cycles < CPU.CPU_CycleLeft ? cycles : CPU.CPU_CycleLeft;
        } else {
            CPU.CPU_Cycles = CPU.CPU_CycleLeft;
        }
        CPU.CPU_CycleLeft -= CPU.CPU_Cycles;
        if (PIC_IRQCheck != 0) {
            Pic.PIC_runIRQs();
        }
        return true;
    }

    public static void PIC_AddEvent(PIC_EventHandler handler2, float delay) {
        Pic.PIC_AddEvent(handler2, delay, 0);
    }

    public static void PIC_AddEvent(PIC_EventHandler handler2, float delay, int val) {
        if (Pic.pic_queue.free_entry == null) {
            Log.log(17, 2, "Event queue full");
            return;
        }
        PICEntry entry = Pic.pic_queue.free_entry;
        entry.index = InEventService ? (double)delay + srv_lag : (double)(delay + Pic.PIC_TickIndex());
        entry.pic_event = handler2;
        entry.value = val;
        Pic.pic_queue.free_entry = Pic.pic_queue.free_entry.next;
        Pic.AddEntry(entry);
    }

    public static void PIC_RemoveEvents(PIC_EventHandler handler2) {
        PICEntry entry = Pic.pic_queue.next_entry;
        PICEntry prev_entry = null;
        while (entry != null) {
            if (entry.pic_event == handler2) {
                if (prev_entry != null) {
                    prev_entry.next = entry.next;
                    entry.next = Pic.pic_queue.free_entry;
                    Pic.pic_queue.free_entry = entry;
                    entry = prev_entry.next;
                    continue;
                }
                Pic.pic_queue.next_entry = entry.next;
                entry.next = Pic.pic_queue.free_entry;
                Pic.pic_queue.free_entry = entry;
                entry = Pic.pic_queue.next_entry;
                continue;
            }
            prev_entry = entry;
            entry = entry.next;
        }
    }

    public static void PIC_RemoveSpecificEvents(PIC_EventHandler handler2, int val) {
        PICEntry entry = Pic.pic_queue.next_entry;
        PICEntry prev_entry = null;
        while (entry != null) {
            if (entry.pic_event == handler2 && entry.value == val) {
                if (prev_entry != null) {
                    prev_entry.next = entry.next;
                    entry.next = Pic.pic_queue.free_entry;
                    Pic.pic_queue.free_entry = entry;
                    entry = prev_entry.next;
                    continue;
                }
                Pic.pic_queue.next_entry = entry.next;
                entry.next = Pic.pic_queue.free_entry;
                Pic.pic_queue.free_entry = entry;
                entry = Pic.pic_queue.next_entry;
                continue;
            }
            prev_entry = entry;
            entry = entry.next;
        }
    }

    public static void PIC_SetIRQMask(int irq, boolean masked) {
        if (Pic.irqs[irq].masked == masked) {
            return;
        }
        boolean old_irq2_mask = Pic.irqs[2].masked;
        Pic.irqs[irq].masked = masked;
        PIC_IRQCheck = irq < 8 ? (Pic.irqs[irq].active && !Pic.irqs[irq].masked ? (PIC_IRQCheck |= 1 << irq) : (PIC_IRQCheck &= ~(1 << irq))) : (Pic.irqs[irq].active && !Pic.irqs[irq].masked && !Pic.irqs[2].masked ? (PIC_IRQCheck |= 1 << irq) : (PIC_IRQCheck &= ~(1 << irq)));
        if (Pic.irqs[2].masked != old_irq2_mask) {
            for (int i = 8; i <= 15; ++i) {
                if (Pic.irqs[i].active && !Pic.irqs[i].masked && !Pic.irqs[2].masked) {
                    PIC_IRQCheck |= 1 << i;
                    continue;
                }
                PIC_IRQCheck &= ~(1 << i);
            }
        }
        if (PIC_IRQCheck != 0) {
            CPU.CPU_CycleLeft += CPU.CPU_Cycles;
            CPU.CPU_Cycles = 0;
        }
    }

    private static boolean PIC_startIRQ(int i) {
        if (i > 7 && Pic.irqs[2].masked) {
            return false;
        }
        Pic.irqs[i].active = false;
        PIC_IRQCheck &= ~(1 << i);
        PIC_IRQOnSecondPicActive &= ~(1 << i);
        CPU.CPU_HW_Interrupt(Pic.irqs[i].vector);
        int pic = (i & 8) >> 3;
        if (!Pic.pics[pic].auto_eoi) {
            PIC_IRQActive = i;
            Pic.irqs[i].inservice = true;
        } else if (Pic.pics[pic].rotate_on_auto_eoi) {
            Log.exit("rotate on auto EOI not handled");
        }
        return true;
    }

    private static void AddEntry(PICEntry entry) {
        PICEntry find_entry = Pic.pic_queue.next_entry;
        if (find_entry == null) {
            entry.next = null;
            Pic.pic_queue.next_entry = entry;
        } else if (find_entry.index > entry.index) {
            Pic.pic_queue.next_entry = entry;
            entry.next = find_entry;
        } else {
            while (find_entry != null) {
                if (find_entry.next != null) {
                    if (find_entry.next.index > entry.index) {
                        entry.next = find_entry.next;
                        find_entry.next = entry;
                        break;
                    }
                    find_entry = find_entry.next;
                    continue;
                }
                entry.next = find_entry.next;
                find_entry.next = entry;
                break;
            }
        }
        int cycles = Pic.PIC_MakeCycles(Pic.pic_queue.next_entry.index - (double)Pic.PIC_TickIndex());
        if (cycles < CPU.CPU_Cycles) {
            CPU.CPU_CycleLeft += CPU.CPU_Cycles;
            CPU.CPU_Cycles = 0;
        }
    }

    public Pic(Section configuration) {
        super(configuration);
        int i;
        PIC_IRQCheck = 0;
        PIC_IRQActive = 255;
        PIC_Ticks = 0;
        for (i = 0; i < this.ReadHandler.length; ++i) {
            this.ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
        }
        for (i = 0; i < this.WriteHandler.length; ++i) {
            this.WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
        }
        for (i = 0; i < 2; ++i) {
            Pic.pics[i].masked = 255;
            Pic.pics[i].auto_eoi = false;
            Pic.pics[i].rotate_on_auto_eoi = false;
            Pic.pics[i].request_issr = false;
            Pic.pics[i].special = false;
            Pic.pics[i].single = false;
            Pic.pics[i].icw_index = 0;
            Pic.pics[i].icw_words = 0;
        }
        for (i = 0; i <= 7; ++i) {
            Pic.irqs[i].active = false;
            Pic.irqs[i].masked = true;
            Pic.irqs[i].inservice = false;
            Pic.irqs[i + 8].active = false;
            Pic.irqs[i + 8].masked = true;
            Pic.irqs[i + 8].inservice = false;
            Pic.irqs[i].vector = 8 + i;
            Pic.irqs[i + 8].vector = 112 + i;
        }
        Pic.irqs[0].masked = false;
        Pic.irqs[1].masked = false;
        Pic.irqs[2].masked = false;
        Pic.irqs[8].masked = false;
        if (Dosbox.machine == 3) {
            Pic.irqs[6].masked = false;
        }
        this.ReadHandler[0].Install(32, read_command, 1);
        this.ReadHandler[1].Install(33, read_data, 1);
        this.WriteHandler[0].Install(32, write_command, 1);
        this.WriteHandler[1].Install(33, write_data, 1);
        this.ReadHandler[2].Install(160, read_command, 1);
        this.ReadHandler[3].Install(161, read_data, 1);
        this.WriteHandler[2].Install(160, write_command, 1);
        this.WriteHandler[3].Install(161, write_data, 1);
        for (i = 0; i < PIC_QUEUESIZE - 1; ++i) {
            Pic.pic_queue.entries[i].next = Pic.pic_queue.entries[i + 1];
        }
        Pic.pic_queue.entries[Pic.PIC_QUEUESIZE - 1].next = null;
        Pic.pic_queue.free_entry = Pic.pic_queue.entries[0];
        Pic.pic_queue.next_entry = null;
    }

    static /* synthetic */ int access$000() {
        return PIC_QUEUESIZE;
    }

    static {
        irqs = new IRQ_Block[16];
        pics = new PIC_Controller[2];
        PIC_Special_Mode = false;
        write_command = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                PIC_Controller pic = pics[port == 32 ? 0 : 1];
                int irq_base = port == 32 ? 0 : 8;
                int[] IRQ_priority_table = new int[]{0, 1, 2, 8, 9, 10, 11, 12, 13, 14, 15, 3, 4, 5, 6, 7};
                if ((val & 0x10) != 0) {
                    if ((val & 4) != 0) {
                        Log.exit("PIC: 4 byte interval not handled");
                    }
                    if ((val & 8) != 0) {
                        Log.exit("PIC: level triggered mode not handled");
                    }
                    if ((val & 0xE0) != 0) {
                        Log.exit("PIC: 8080/8085 mode not handled");
                    }
                    pic.single = (val & 2) == 2;
                    pic.icw_index = 1;
                    pic.icw_words = 2 + (val & 1);
                } else if ((val & 8) != 0) {
                    if ((val & 4) != 0) {
                        Log.exit("PIC: poll command not handled");
                    }
                    if ((val & 2) != 0) {
                        pic.request_issr = (val & 1) != 0;
                    }
                    if ((val & 0x40) != 0) {
                        pic.special = (val & 0x20) != 0;
                        if (pics[0].special || pics[1].special) {
                            PIC_Special_Mode = true;
                        } else {
                            PIC_Special_Mode = false;
                        }
                        if (PIC_IRQCheck != 0) {
                            CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                            CPU.CPU_Cycles = 0;
                        }
                    }
                } else if ((val & 0x20) != 0) {
                    if ((val & 0x80) != 0) {
                        Log.exit("rotate mode not supported");
                    }
                    if ((val & 0x40) != 0) {
                        if (PIC_IRQActive == irq_base + val - 96) {
                            irqs[Pic.PIC_IRQActive].inservice = false;
                            PIC_IRQActive = 255;
                            for (int i = 0; i <= 15; ++i) {
                                if (!irqs[IRQ_priority_table[i]].inservice) continue;
                                PIC_IRQActive = IRQ_priority_table[i];
                                break;
                            }
                        }
                    } else if (PIC_IRQActive < irq_base + 8) {
                        irqs[Pic.PIC_IRQActive].inservice = false;
                        PIC_IRQActive = 255;
                        for (int i = 0; i <= 15; ++i) {
                            if (!irqs[IRQ_priority_table[i]].inservice) continue;
                            PIC_IRQActive = IRQ_priority_table[i];
                            break;
                        }
                    }
                } else if ((val & 0x40) == 0) {
                    pic.rotate_on_auto_eoi = (val & 0x80) != 0;
                } else if ((val & 0x80) != 0) {
                    Log.log(17, 0, "set priority command not handled");
                }
            }
        };
        write_data = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                PIC_Controller pic = pics[port == 33 ? 0 : 1];
                int irq_base = port == 33 ? 0 : 8;
                boolean old_irq2_mask = irqs[2].masked;
                switch (pic.icw_index) {
                    case 0: {
                        int i;
                        for (i = 0; i <= 7; ++i) {
                            boolean bl = irqs[i + irq_base].masked = (val & 1 << i) > 0;
                            if (port == 33) {
                                if (irqs[i + irq_base].active && !irqs[i + irq_base].masked) {
                                    PIC_IRQCheck |= 1 << i + irq_base;
                                    continue;
                                }
                                PIC_IRQCheck &= ~(1 << i + irq_base);
                                continue;
                            }
                            if (irqs[i + irq_base].active && !irqs[i + irq_base].masked && !irqs[2].masked) {
                                PIC_IRQCheck |= 1 << i + irq_base;
                                continue;
                            }
                            PIC_IRQCheck &= ~(1 << i + irq_base);
                        }
                        if (Dosbox.machine == 3) {
                            irqs[6].masked = false;
                        }
                        if (irqs[2].masked != old_irq2_mask) {
                            for (i = 8; i <= 15; ++i) {
                                if (irqs[i].active && !irqs[i].masked && !irqs[2].masked) {
                                    PIC_IRQCheck |= 1 << i;
                                    continue;
                                }
                                PIC_IRQCheck &= ~(1 << i);
                            }
                        }
                        if (PIC_IRQCheck == 0) break;
                        CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                        CPU.CPU_Cycles = 0;
                        break;
                    }
                    case 1: {
                        for (int i = 0; i <= 7; ++i) {
                            irqs[i + irq_base].vector = (val & 0xF8) + i;
                        }
                        if (pic.icw_index++ >= pic.icw_words) {
                            pic.icw_index = 0;
                            break;
                        }
                        if (!pic.single) break;
                        pic.icw_index = 3;
                        break;
                    }
                    case 2: {
                        if (pic.icw_index++ < pic.icw_words) break;
                        pic.icw_index = 0;
                        break;
                    }
                    case 3: {
                        boolean bl = pic.auto_eoi = (val & 2) > 0;
                        if ((val & 1) == 0) {
                            Log.exit("PIC:ICW4: " + Integer.toString(val, 16) + ", 8085 mode not handled");
                        }
                        if ((val & 0x10) != 0) {
                            Log.log_msg("PIC:ICW4: " + Integer.toString(val, 16) + ", special fully-nested mode not handled");
                        }
                        if (pic.icw_index++ < pic.icw_words) break;
                        pic.icw_index = 0;
                        break;
                    }
                }
            }
        };
        read_command = new IoHandler.IO_ReadHandler(){

            public int call(int port, int iolen) {
                PIC_Controller pic = pics[port == 32 ? 0 : 1];
                int irq_base = port == 32 ? 0 : 8;
                int ret = 0;
                int b = 1;
                if (pic.request_issr) {
                    for (int i = irq_base; i < irq_base + 8; ++i) {
                        if (irqs[i].inservice) {
                            ret |= b;
                        }
                        b <<= 1;
                    }
                } else {
                    for (int i = irq_base; i < irq_base + 8; ++i) {
                        if (irqs[i].active) {
                            ret |= b;
                        }
                        b <<= 1;
                    }
                    if (irq_base == 0 && (PIC_IRQCheck & 0xFF00) != 0) {
                        ret |= 4;
                    }
                }
                return ret;
            }
        };
        read_data = new IoHandler.IO_ReadHandler(){

            public int call(int port, int iolen) {
                int irq_base = port == 33 ? 0 : 8;
                int ret = 0;
                int b = 1;
                for (int i = irq_base; i <= irq_base + 7; ++i) {
                    if (irqs[i].masked) {
                        ret |= b;
                    }
                    b <<= 1;
                }
                return ret;
            }
        };
        InEventService = false;
        srv_lag = 0.0;
        PIC_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                int i;
                test = null;
                for (i = 0; i < irqs.length; ++i) {
                    irqs[i] = null;
                }
                for (i = 0; i < pics.length; ++i) {
                    pics[i] = null;
                }
                pic_queue = null;
            }
        };
        PIC_Init = new Section.SectionFunction(){

            public void call(Section section) {
                int i;
                pic_queue = new Pic_queue();
                for (i = 0; i < irqs.length; ++i) {
                    irqs[i] = new IRQ_Block();
                }
                for (i = 0; i < pics.length; ++i) {
                    pics[i] = new PIC_Controller();
                }
                test = new Pic(section);
                section.AddDestroyFunction(PIC_Destroy);
            }
        };
    }

    public static class Pic_queue {
        PICEntry[] entries = new PICEntry[Pic.access$000()];
        PICEntry free_entry;
        PICEntry next_entry;

        public Pic_queue() {
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i] = new PICEntry();
            }
        }
    }

    public static class PICEntry {
        double index;
        int value;
        PIC_EventHandler pic_event;
        PICEntry next;
    }

    private static class PIC_Controller {
        int icw_words;
        int icw_index;
        int masked;
        boolean special;
        boolean auto_eoi;
        boolean rotate_on_auto_eoi;
        boolean single;
        boolean request_issr;
        short vector_base;

        private PIC_Controller() {
        }
    }

    private static class IRQ_Block {
        boolean masked;
        boolean active;
        boolean inservice;
        int vector;

        private IRQ_Block() {
        }
    }

    public static interface PIC_EventHandler {
        public void call(int var1);
    }

    public static interface PIC_EOIHandler {
        public void call();
    }
}

