/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.gui.Midi;
import jdos.hardware.Adlib;
import jdos.hardware.DMA;
import jdos.hardware.Gameblaster;
import jdos.hardware.Gus;
import jdos.hardware.IoHandler;
import jdos.hardware.Mixer;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.shell.AutoexecObject;
import jdos.util.IntRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;

public class SBlaster
extends Module_base {
    private static final int SB_PIC_EVENTS = 0;
    private static final int DSP_MAJOR = 3;
    private static final int DSP_MINOR = 1;
    private static final int MIXER_INDEX = 4;
    private static final int MIXER_DATA = 5;
    private static final int DSP_RESET = 6;
    private static final int DSP_READ_DATA = 10;
    private static final int DSP_WRITE_DATA = 12;
    private static final int DSP_WRITE_STATUS = 12;
    private static final int DSP_READ_STATUS = 14;
    private static final int DSP_ACK_16BIT = 15;
    private static final int DSP_NO_COMMAND = 0;
    private static final int DMA_BUFSIZE = 1024;
    private static final int DSP_BUFSIZE = 64;
    private static final int DSP_DACSIZE = 512;
    private static final int SB_BUF_SIZE = 8096;
    private static final int SB_SH = 14;
    private static final int SB_SH_MASK = 16383;
    private static final int DSP_S_RESET = 0;
    private static final int DSP_S_RESET_WAIT = 1;
    private static final int DSP_S_NORMAL = 2;
    private static final int DSP_S_HIGHSPEED = 3;
    private static final int SBT_NONE = 0;
    private static final int SBT_1 = 1;
    private static final int SBT_PRO1 = 2;
    private static final int SBT_2 = 3;
    private static final int SBT_PRO2 = 4;
    private static final int SBT_16 = 6;
    private static final int SBT_GB = 7;
    private static final int SB_IRQ_8 = 0;
    private static final int SB_IRQ_16 = 1;
    private static final int SB_IRQ_MPU = 2;
    private static final int MODE_NONE = 0;
    private static final int MODE_DAC = 1;
    private static final int MODE_DMA = 2;
    private static final int MODE_DMA_PAUSE = 3;
    private static final int MODE_DMA_MASKED = 4;
    private static final int DSP_DMA_NONE = 0;
    private static final int DSP_DMA_2 = 1;
    private static final int DSP_DMA_3 = 2;
    private static final int DSP_DMA_4 = 3;
    private static final int DSP_DMA_8 = 4;
    private static final int DSP_DMA_16 = 5;
    private static final int DSP_DMA_16_ALIASED = 6;
    private static final int PLAY_MONO = 0;
    private static final int PLAY_STEREO = 1;
    private static SB_INFO sb;
    private static final String copyright_string = "COPYRIGHT (C) CREATIVE TECHNOLOGY LTD, 1992.";
    private static final byte[] DSP_cmd_len_sb;
    private static final byte[] DSP_cmd_len_sb16;
    private static short[] ASP_regs;
    private static boolean ASP_init_in_progress;
    private static final int[][] E2_incr_table;
    private static DMA.DMA_CallBack DSP_DMA_CallBack;
    private static final int MIN_ADAPTIVE_STEP_SIZE = 0;
    private static final int MAX_ADAPTIVE_STEP_SIZE = Short.MAX_VALUE;
    private static final int DC_OFFSET_FADE = 254;
    private static final byte[] scaleMap1;
    private static final short[] adjustMap1;
    private static final byte[] scaleMap2;
    private static final short[] adjustMap2;
    private static final byte[] scaleMap3;
    private static final short[] adjustMap3;
    private static Pic.PIC_EventHandler DMA_Silent_Event;
    private static Pic.PIC_EventHandler END_DMA_Event;
    private static Pic.PIC_EventHandler DSP_RaiseIRQEvent;
    private static Pic.PIC_EventHandler DSP_FinishReset;
    private static DMA.DMA_CallBack DSP_E2_DMA_CallBack;
    private static DMA.DMA_CallBack DSP_ADC_CallBack;
    private static IoHandler.IO_ReadHandler read_sb;
    private static IoHandler.IO_WriteHandler write_sb;
    private static IoHandler.IO_WriteHandler adlib_gusforward;
    private static Mixer.MIXER_Handler SBLASTER_CallBack;
    private IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[16];
    private IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[16];
    private AutoexecObject autoexecline = new AutoexecObject();
    private Mixer.MixerObject MixerChan = new Mixer.MixerObject();
    private int oplmode;
    private static SBlaster test;
    public static Section.SectionFunction SBLASTER_ShutDown;
    public static Section.SectionFunction SBLASTER_Init;

    private static void DSP_SetSpeaker(boolean how) {
        if (SBlaster.sb.speaker == how) {
            return;
        }
        SBlaster.sb.speaker = how;
        if (SBlaster.sb.type == 6) {
            return;
        }
        SBlaster.sb.chan.Enable(how);
        if (SBlaster.sb.speaker) {
            Pic.PIC_RemoveEvents(DMA_Silent_Event);
            SBlaster.CheckDMAEnd();
        }
    }

    private static void SB_RaiseIRQ(int type) {
        switch (type) {
            case 0: {
                if (SBlaster.sb.irq.pending_8bit) {
                    return;
                }
                SBlaster.sb.irq.pending_8bit = true;
                Pic.PIC_ActivateIRQ(SBlaster.sb.hw.irq);
                break;
            }
            case 1: {
                if (SBlaster.sb.irq.pending_16bit) {
                    return;
                }
                SBlaster.sb.irq.pending_16bit = true;
                Pic.PIC_ActivateIRQ(SBlaster.sb.hw.irq);
                break;
            }
        }
    }

    private static void DSP_FlushData() {
        SBlaster.sb.dsp.out.used = 0;
        SBlaster.sb.dsp.out.pos = 0;
    }

    private static byte decode_ADPCM_4_sample(int sample, ShortRef reference, IntRef scale) {
        int ref;
        int samp = sample + scale.value;
        if (samp < 0 || samp > 63) {
            Log.log(5, 2, "Bad ADPCM-4 sample");
            if (samp < 0) {
                samp = 0;
            }
            if (samp > 63) {
                samp = 63;
            }
        }
        reference.value = (ref = reference.value + scaleMap1[samp]) > 255 ? (short)255 : (ref < 0 ? (short)0 : (short)(ref & 0xFF));
        scale.value = scale.value + adjustMap1[samp] & 0xFF;
        return (byte)reference.value;
    }

    private static byte decode_ADPCM_2_sample(int sample, ShortRef reference, IntRef scale) {
        int ref;
        int samp = sample + scale.value;
        if (samp < 0 || samp > 23) {
            Log.log(5, 2, "Bad ADPCM-2 sample");
            if (samp < 0) {
                samp = 0;
            }
            if (samp > 23) {
                samp = 23;
            }
        }
        reference.value = (ref = reference.value + scaleMap2[samp]) > 255 ? (short)255 : (ref < 0 ? (short)0 : (short)(ref & 0xFF));
        scale.value = scale.value + adjustMap2[samp] & 0xFF;
        return (byte)reference.value;
    }

    private static byte decode_ADPCM_3_sample(int sample, ShortRef reference, IntRef scale) {
        int ref;
        int samp = sample + scale.value;
        if (samp < 0 || samp > 39) {
            Log.log(5, 2, "Bad ADPCM-3 sample");
            if (samp < 0) {
                samp = 0;
            }
            if (samp > 39) {
                samp = 39;
            }
        }
        reference.value = (ref = reference.value + scaleMap3[samp]) > 255 ? (short)255 : (ref < 0 ? (short)0 : (short)(ref & 0xFF));
        scale.value = scale.value + adjustMap3[samp] & 0xFF;
        return (byte)reference.value;
    }

    private static void GenerateDMASound(int size) {
        int read = 0;
        int done = 0;
        int i = 0;
        if (SBlaster.sb.dma.autoinit) {
            if (SBlaster.sb.dma.left <= size) {
                size = SBlaster.sb.dma.left;
            }
        } else if (SBlaster.sb.dma.left <= SBlaster.sb.dma.min) {
            size = SBlaster.sb.dma.left;
        }
        switch (SBlaster.sb.dma.mode) {
            case 1: {
                read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b8, 0);
                if (read != 0 && SBlaster.sb.adpcm.haveref) {
                    SBlaster.sb.adpcm.haveref = false;
                    SBlaster.sb.adpcm.reference.value = (short)(SBlaster.sb.dma.buf.b8[0] & 0xFF);
                    SBlaster.sb.adpcm.stepsize.value = 0;
                    ++i;
                }
                while (i < read) {
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_2_sample(SBlaster.sb.dma.buf.b8[i] >> 6 & 3, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_2_sample(SBlaster.sb.dma.buf.b8[i] >> 4 & 3, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_2_sample(SBlaster.sb.dma.buf.b8[i] >> 2 & 3, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_2_sample(SBlaster.sb.dma.buf.b8[i] >> 0 & 3, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    ++i;
                }
                SBlaster.sb.chan.AddSamples_m8(done, Mixer.MixTemp8);
                break;
            }
            case 2: {
                read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b8, 0);
                if (read != 0 && SBlaster.sb.adpcm.haveref) {
                    SBlaster.sb.adpcm.haveref = false;
                    SBlaster.sb.adpcm.reference.value = (short)(SBlaster.sb.dma.buf.b8[0] & 0xFF);
                    SBlaster.sb.adpcm.stepsize.value = 0;
                    ++i;
                }
                while (i < read) {
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_3_sample(SBlaster.sb.dma.buf.b8[i] >>> 5 & 7, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_3_sample(SBlaster.sb.dma.buf.b8[i] >> 2 & 7, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_3_sample((SBlaster.sb.dma.buf.b8[i] & 3) << 1, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    ++i;
                }
                SBlaster.sb.chan.AddSamples_m8(done, Mixer.MixTemp8);
                break;
            }
            case 3: {
                read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b8, 0);
                if (read != 0 && SBlaster.sb.adpcm.haveref) {
                    SBlaster.sb.adpcm.haveref = false;
                    SBlaster.sb.adpcm.reference.value = (short)(SBlaster.sb.dma.buf.b8[0] & 0xFF);
                    SBlaster.sb.adpcm.stepsize.value = 0;
                    ++i;
                }
                while (i < read) {
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_4_sample(SBlaster.sb.dma.buf.b8[i] >>> 4, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    Mixer.MixTemp8[done++] = SBlaster.decode_ADPCM_4_sample(SBlaster.sb.dma.buf.b8[i] & 0xF, SBlaster.sb.adpcm.reference, SBlaster.sb.adpcm.stepsize);
                    ++i;
                }
                SBlaster.sb.chan.AddSamples_m8(done, Mixer.MixTemp8);
                break;
            }
            case 4: {
                if (SBlaster.sb.dma.stereo) {
                    read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b8, SBlaster.sb.dma.remain_size);
                    int total = read + SBlaster.sb.dma.remain_size;
                    if (!SBlaster.sb.dma.sign) {
                        SBlaster.sb.chan.AddSamples_s8(total >> 1, SBlaster.sb.dma.buf.b8);
                    } else {
                        SBlaster.sb.chan.AddSamples_s8s(total >>> 1, SBlaster.sb.dma.buf.b8);
                    }
                    if ((total & 1) != 0) {
                        SBlaster.sb.dma.remain_size = 1;
                        SBlaster.sb.dma.buf.b8[0] = SBlaster.sb.dma.buf.b8[total - 1];
                        break;
                    }
                    SBlaster.sb.dma.remain_size = 0;
                    break;
                }
                read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b8, 0);
                if (!SBlaster.sb.dma.sign) {
                    SBlaster.sb.chan.AddSamples_m8(read, SBlaster.sb.dma.buf.b8);
                    break;
                }
                SBlaster.sb.chan.AddSamples_m8s(read, SBlaster.sb.dma.buf.b8);
                break;
            }
            case 5: 
            case 6: {
                if (SBlaster.sb.dma.stereo) {
                    read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b16, SBlaster.sb.dma.remain_size) >> (SBlaster.sb.dma.mode == 6 ? 1 : 0);
                    int total = read + SBlaster.sb.dma.remain_size;
                    if (SBlaster.sb.dma.sign) {
                        SBlaster.sb.chan.AddSamples_s16(total >>> 1, SBlaster.sb.dma.buf.b16);
                    } else {
                        SBlaster.sb.chan.AddSamples_s16u(total >>> 1, SBlaster.sb.dma.buf.b16);
                    }
                    if ((total & 1) != 0) {
                        SBlaster.sb.dma.remain_size = 1;
                        SBlaster.sb.dma.buf.b16[0] = SBlaster.sb.dma.buf.b16[total - 1];
                    } else {
                        SBlaster.sb.dma.remain_size = 0;
                    }
                } else {
                    read = SBlaster.sb.dma.chan.Read(size, SBlaster.sb.dma.buf.b16, 0) >> (SBlaster.sb.dma.mode == 6 ? 1 : 0);
                    if (SBlaster.sb.dma.sign) {
                        SBlaster.sb.chan.AddSamples_m16(read, SBlaster.sb.dma.buf.b16);
                    } else {
                        SBlaster.sb.chan.AddSamples_m16u(read, SBlaster.sb.dma.buf.b16);
                    }
                }
                if (SBlaster.sb.dma.mode != 6) break;
                read <<= 1;
                break;
            }
            default: {
                Log.log_msg("Unhandled dma mode " + SBlaster.sb.dma.mode);
                SBlaster.sb.mode = 0;
                return;
            }
        }
        SBlaster.sb.dma.left -= read;
        if (SBlaster.sb.dma.left == 0) {
            Pic.PIC_RemoveEvents(END_DMA_Event);
            if (SBlaster.sb.dma.mode >= 5) {
                SBlaster.SB_RaiseIRQ(1);
            } else {
                SBlaster.SB_RaiseIRQ(0);
            }
            if (!SBlaster.sb.dma.autoinit) {
                Log.log(5, 0, "Single cycle transfer ended");
                SBlaster.sb.mode = 0;
                SBlaster.sb.dma.mode = 0;
            } else {
                SBlaster.sb.dma.left = SBlaster.sb.dma.total;
                if (SBlaster.sb.dma.left == 0) {
                    Log.log(5, 0, "Auto-init transfer with 0 size");
                    SBlaster.sb.mode = 0;
                }
            }
        }
    }

    private static void CheckDMAEnd() {
        if (SBlaster.sb.dma.left == 0) {
            return;
        }
        if (!SBlaster.sb.speaker && SBlaster.sb.type != 6) {
            int bigger = SBlaster.sb.dma.left > SBlaster.sb.dma.min ? SBlaster.sb.dma.min : SBlaster.sb.dma.left;
            float delay = (float)bigger * 1000.0f / (float)SBlaster.sb.dma.rate;
            Pic.PIC_AddEvent(DMA_Silent_Event, delay, bigger);
        } else if (SBlaster.sb.dma.left < SBlaster.sb.dma.min) {
            float delay = (float)SBlaster.sb.dma.left * 1000.0f / (float)SBlaster.sb.dma.rate;
            Pic.PIC_AddEvent(END_DMA_Event, delay, SBlaster.sb.dma.left);
        }
    }

    private static void DSP_ChangeMode(int mode) {
        if (SBlaster.sb.mode == mode) {
            return;
        }
        SBlaster.sb.chan.FillUp();
        SBlaster.sb.mode = mode;
    }

    static void DSP_DoDMATransfer(int mode, int freq, boolean stereo) {
        SBlaster.sb.mode = 4;
        SBlaster.sb.chan.FillUp();
        SBlaster.sb.dma.left = SBlaster.sb.dma.total;
        SBlaster.sb.dma.mode = mode;
        SBlaster.sb.dma.stereo = stereo;
        SBlaster.sb.irq.pending_8bit = false;
        SBlaster.sb.irq.pending_16bit = false;
        switch (mode) {
            case 1: {
                String type = "2-bits ADPCM";
                SBlaster.sb.dma.mul = 4096;
                break;
            }
            case 2: {
                String type = "3-bits ADPCM";
                SBlaster.sb.dma.mul = 5461;
                break;
            }
            case 3: {
                String type = "4-bits ADPCM";
                SBlaster.sb.dma.mul = 8192;
                break;
            }
            case 4: {
                String type = "8-bits PCM";
                SBlaster.sb.dma.mul = 16384;
                break;
            }
            case 6: {
                String type = "16-bits(aliased) PCM";
                SBlaster.sb.dma.mul = 32768;
                break;
            }
            case 5: {
                String type = "16-bits PCM";
                SBlaster.sb.dma.mul = 16384;
                break;
            }
            default: {
                Log.log(5, 2, "DSP:Illegal transfer mode " + mode);
                return;
            }
        }
        if (SBlaster.sb.dma.stereo) {
            SBlaster.sb.dma.mul *= 2;
        }
        SBlaster.sb.dma.rate = SBlaster.sb.freq * SBlaster.sb.dma.mul >> 14;
        SBlaster.sb.dma.min = SBlaster.sb.dma.rate * 3 / 1000;
        SBlaster.sb.chan.SetFreq(freq);
        SBlaster.sb.dma.mode = mode;
        Pic.PIC_RemoveEvents(END_DMA_Event);
        SBlaster.sb.dma.chan.Register_Callback(DSP_DMA_CallBack);
    }

    private static void DSP_PrepareDMA_Old(int mode, boolean autoinit, boolean sign) {
        SBlaster.sb.dma.autoinit = autoinit;
        SBlaster.sb.dma.sign = sign;
        if (!autoinit) {
            SBlaster.sb.dma.total = 1 + SBlaster.sb.dsp.in.data[0] + (SBlaster.sb.dsp.in.data[1] << 8);
        }
        SBlaster.sb.dma.chan = DMA.GetDMAChannel(SBlaster.sb.hw.dma8);
        SBlaster.DSP_DoDMATransfer(mode, SBlaster.sb.freq / (SBlaster.sb.mixer.stereo ? 2 : 1), SBlaster.sb.mixer.stereo);
    }

    private static void DSP_PrepareDMA_New(int mode, int length, boolean autoinit, boolean stereo) {
        int freq = SBlaster.sb.freq;
        SBlaster.sb.dma.total = length;
        SBlaster.sb.dma.autoinit = autoinit;
        if (mode == 5) {
            if (SBlaster.sb.hw.dma16 != 255) {
                SBlaster.sb.dma.chan = DMA.GetDMAChannel(SBlaster.sb.hw.dma16);
                if (SBlaster.sb.dma.chan == null) {
                    SBlaster.sb.dma.chan = DMA.GetDMAChannel(SBlaster.sb.hw.dma8);
                    mode = 6;
                    SBlaster.sb.dma.total <<= 1;
                }
            } else {
                SBlaster.sb.dma.chan = DMA.GetDMAChannel(SBlaster.sb.hw.dma8);
                mode = 6;
                SBlaster.sb.dma.total <<= 1;
            }
        } else {
            SBlaster.sb.dma.chan = DMA.GetDMAChannel(SBlaster.sb.hw.dma8);
        }
        SBlaster.DSP_DoDMATransfer(mode, freq, stereo);
    }

    private static void DSP_AddData(int val) {
        if (SBlaster.sb.dsp.out.used < 64) {
            int start = SBlaster.sb.dsp.out.used + SBlaster.sb.dsp.out.pos;
            if (start >= 64) {
                start -= 64;
            }
            SBlaster.sb.dsp.out.data[start] = (short)val;
            ++SBlaster.sb.dsp.out.used;
        } else {
            Log.log(5, 2, "DSP:Data Output buffer full");
        }
    }

    private static void DSP_Reset() {
        Log.log(5, 2, "DSP:Reset");
        Pic.PIC_DeActivateIRQ(SBlaster.sb.hw.irq);
        SBlaster.DSP_ChangeMode(0);
        SBlaster.DSP_FlushData();
        SBlaster.sb.dsp.cmd_len = 0;
        SBlaster.sb.dsp.in.pos = 0;
        SBlaster.sb.dsp.write_busy = 0;
        Pic.PIC_RemoveEvents(DSP_FinishReset);
        SBlaster.sb.dma.left = 0;
        SBlaster.sb.dma.total = 0;
        SBlaster.sb.dma.stereo = false;
        SBlaster.sb.dma.sign = false;
        SBlaster.sb.dma.autoinit = false;
        SBlaster.sb.dma.mode = 0;
        SBlaster.sb.dma.remain_size = 0;
        if (SBlaster.sb.dma.chan != null) {
            SBlaster.sb.dma.chan.Clear_Request();
        }
        SBlaster.sb.freq = 22050;
        SBlaster.sb.time_constant = (short)45;
        SBlaster.sb.dac.used = 0;
        SBlaster.sb.dac.last = 0;
        SBlaster.sb.e2.value = 170;
        SBlaster.sb.e2.count = 0;
        SBlaster.sb.irq.pending_8bit = false;
        SBlaster.sb.irq.pending_16bit = false;
        SBlaster.sb.chan.SetFreq(22050);
        Pic.PIC_RemoveEvents(END_DMA_Event);
    }

    private static void DSP_DoReset(short val) {
        if ((val & 1) != 0 && SBlaster.sb.dsp.state != 0) {
            SBlaster.DSP_Reset();
            SBlaster.sb.dsp.state = 0;
        } else if ((val & 1) == 0 && SBlaster.sb.dsp.state == 0) {
            SBlaster.sb.dsp.state = 1;
            Pic.PIC_RemoveEvents(DSP_FinishReset);
            Pic.PIC_AddEvent(DSP_FinishReset, 0.02f, 0);
        }
    }

    private static boolean DSP_SB16_ONLY() {
        if (SBlaster.sb.type != 6) {
            Log.log(5, 2, "DSP:Command " + Integer.toString(SBlaster.sb.dsp.cmd, 16) + " requires SB16");
            return true;
        }
        return false;
    }

    private static boolean DSP_SB2_ABOVE() {
        if (SBlaster.sb.type <= 1) {
            Log.log(5, 2, "DSP:Command " + Integer.toString(SBlaster.sb.dsp.cmd, 16) + " requires SB2 or above");
            return true;
        }
        return false;
    }

    private static void DSP_DoCommand() {
        block0 : switch (SBlaster.sb.dsp.cmd) {
            case 4: {
                if (SBlaster.sb.type == 6) {
                    if ((SBlaster.sb.dsp.in.data[0] & 0xF1) == 241) {
                        ASP_init_in_progress = true;
                        break;
                    }
                    ASP_init_in_progress = false;
                    break;
                }
                SBlaster.DSP_FlushData();
                if (SBlaster.sb.type == 3) {
                    SBlaster.DSP_AddData(136);
                    break;
                }
                if (SBlaster.sb.type == 2 || SBlaster.sb.type == 4) {
                    SBlaster.DSP_AddData(123);
                    break;
                }
                SBlaster.DSP_AddData(255);
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                if (SBlaster.sb.type != 6) break;
                switch (SBlaster.sb.dsp.in.data[0]) {
                    case 3: {
                        SBlaster.DSP_AddData(24);
                        break block0;
                    }
                }
                break;
            }
            case 14: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.ASP_regs[SBlaster.sb.dsp.in.data[0]] = SBlaster.sb.dsp.in.data[1];
                break;
            }
            case 15: {
                if (SBlaster.sb.type != 6) break;
                if (ASP_init_in_progress && SBlaster.sb.dsp.in.data[0] == 131) {
                    SBlaster.ASP_regs[131] = ~ASP_regs[131];
                }
                SBlaster.DSP_AddData(ASP_regs[SBlaster.sb.dsp.in.data[0]]);
                break;
            }
            case 16: {
                SBlaster.DSP_ChangeMode(1);
                if (SBlaster.sb.dac.used >= 512) break;
                SBlaster.sb.dac.data[SBlaster.sb.dac.used++] = (short)((SBlaster.sb.dsp.in.data[0] ^ 0x80) << 8);
                SBlaster.sb.dac.data[SBlaster.sb.dac.used++] = (short)((SBlaster.sb.dsp.in.data[0] ^ 0x80) << 8);
                break;
            }
            case 36: {
                SBlaster.sb.dma.left = SBlaster.sb.dma.total = 1 + SBlaster.sb.dsp.in.data[0] + (SBlaster.sb.dsp.in.data[1] << 8);
                SBlaster.sb.dma.sign = false;
                Log.log(5, 2, "DSP:Faked ADC for " + SBlaster.sb.dma.total + " bytes");
                DMA.GetDMAChannel(SBlaster.sb.hw.dma8).Register_Callback(DSP_ADC_CallBack);
                break;
            }
            case 20: 
            case 21: 
            case 145: {
                SBlaster.DSP_PrepareDMA_Old(4, false, false);
                break;
            }
            case 28: 
            case 144: {
                if (SBlaster.DSP_SB2_ABOVE()) break;
                SBlaster.DSP_PrepareDMA_Old(4, true, false);
                break;
            }
            case 56: {
                if (!SBlaster.sb.midi) break;
                Midi.MIDI_RawOutByte(SBlaster.sb.dsp.in.data[0]);
                break;
            }
            case 64: {
                SBlaster.sb.freq = 1000000 / (256 - SBlaster.sb.dsp.in.data[0]);
                if (SBlaster.sb.dma.mode == 0 || !SBlaster.sb.dma.autoinit) break;
                SBlaster.DSP_PrepareDMA_Old(SBlaster.sb.dma.mode, SBlaster.sb.dma.autoinit, SBlaster.sb.dma.sign);
                break;
            }
            case 65: 
            case 66: {
                if (SBlaster.DSP_SB16_ONLY()) break;
                SBlaster.sb.freq = SBlaster.sb.dsp.in.data[0] << 8 | SBlaster.sb.dsp.in.data[1];
                break;
            }
            case 72: {
                if (SBlaster.DSP_SB2_ABOVE()) break;
                SBlaster.sb.dma.total = 1 + SBlaster.sb.dsp.in.data[0] + (SBlaster.sb.dsp.in.data[1] << 8);
                break;
            }
            case 117: {
                SBlaster.sb.adpcm.haveref = true;
            }
            case 116: {
                SBlaster.DSP_PrepareDMA_Old(3, false, false);
                break;
            }
            case 119: {
                SBlaster.sb.adpcm.haveref = true;
            }
            case 118: {
                SBlaster.DSP_PrepareDMA_Old(2, false, false);
                break;
            }
            case 23: {
                SBlaster.sb.adpcm.haveref = true;
            }
            case 22: {
                SBlaster.DSP_PrepareDMA_Old(1, false, false);
                break;
            }
            case 128: {
                Pic.PIC_AddEvent(DSP_RaiseIRQEvent, 1000.0f * (float)(1 + SBlaster.sb.dsp.in.data[0] + (SBlaster.sb.dsp.in.data[1] << 8)) / (float)SBlaster.sb.freq);
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                if (SBlaster.DSP_SB16_ONLY()) break;
                SBlaster.sb.dma.sign = (SBlaster.sb.dsp.in.data[0] & 0x10) > 0;
                SBlaster.DSP_PrepareDMA_New((SBlaster.sb.dsp.cmd & 0x10) != 0 ? 5 : 4, 1 + SBlaster.sb.dsp.in.data[1] + (SBlaster.sb.dsp.in.data[2] << 8), (SBlaster.sb.dsp.cmd & 4) > 0, (SBlaster.sb.dsp.in.data[0] & 0x20) > 0);
                break;
            }
            case 213: {
                if (SBlaster.DSP_SB16_ONLY()) break;
            }
            case 208: {
                SBlaster.sb.mode = 3;
                Pic.PIC_RemoveEvents(END_DMA_Event);
                break;
            }
            case 209: {
                SBlaster.DSP_SetSpeaker(true);
                break;
            }
            case 211: {
                SBlaster.DSP_SetSpeaker(false);
                break;
            }
            case 216: {
                if (SBlaster.DSP_SB2_ABOVE()) break;
                SBlaster.DSP_FlushData();
                if (SBlaster.sb.speaker) {
                    SBlaster.DSP_AddData(255);
                    break;
                }
                SBlaster.DSP_AddData(0);
                break;
            }
            case 214: {
                if (SBlaster.DSP_SB16_ONLY()) break;
            }
            case 212: {
                if (SBlaster.sb.mode != 3) break;
                SBlaster.sb.mode = 4;
                SBlaster.sb.dma.chan.Register_Callback(DSP_DMA_CallBack);
                break;
            }
            case 217: {
                if (SBlaster.DSP_SB16_ONLY()) break;
            }
            case 218: {
                if (SBlaster.DSP_SB2_ABOVE()) break;
                SBlaster.sb.dma.autoinit = false;
                break;
            }
            case 224: {
                SBlaster.DSP_FlushData();
                SBlaster.DSP_AddData(~SBlaster.sb.dsp.in.data[0]);
                break;
            }
            case 225: {
                SBlaster.DSP_FlushData();
                switch (SBlaster.sb.type) {
                    case 1: {
                        SBlaster.DSP_AddData(1);
                        SBlaster.DSP_AddData(5);
                        break block0;
                    }
                    case 3: {
                        SBlaster.DSP_AddData(2);
                        SBlaster.DSP_AddData(1);
                        break block0;
                    }
                    case 2: {
                        SBlaster.DSP_AddData(3);
                        SBlaster.DSP_AddData(0);
                        break block0;
                    }
                    case 4: {
                        SBlaster.DSP_AddData(3);
                        SBlaster.DSP_AddData(2);
                        break block0;
                    }
                    case 6: {
                        SBlaster.DSP_AddData(4);
                        SBlaster.DSP_AddData(5);
                        break block0;
                    }
                }
                break;
            }
            case 226: {
                Log.log(5, 0, "DSP Function 0xe2");
                for (int i = 0; i < 8; ++i) {
                    if ((SBlaster.sb.dsp.in.data[0] >> i & 1) == 0) continue;
                    SBlaster.sb.e2.value += E2_incr_table[SBlaster.sb.e2.count % 4][i];
                }
                SBlaster.sb.e2.value += E2_incr_table[SBlaster.sb.e2.count % 4][8];
                ++SBlaster.sb.e2.count;
                DMA.GetDMAChannel(SBlaster.sb.hw.dma8).Register_Callback(DSP_E2_DMA_CallBack);
                break;
            }
            case 227: {
                SBlaster.DSP_FlushData();
                byte[] b = copyright_string.getBytes();
                for (int i = 0; i < b.length; ++i) {
                    SBlaster.DSP_AddData(b[i]);
                }
                SBlaster.DSP_AddData(0);
                break;
            }
            case 228: {
                SBlaster.sb.dsp.test_register = SBlaster.sb.dsp.in.data[0];
                break;
            }
            case 232: {
                SBlaster.DSP_FlushData();
                SBlaster.DSP_AddData(SBlaster.sb.dsp.test_register);
                break;
            }
            case 242: {
                SBlaster.SB_RaiseIRQ(0);
                break;
            }
            case 248: {
                SBlaster.DSP_FlushData();
                SBlaster.DSP_AddData(0);
                break;
            }
            case 48: 
            case 49: {
                Log.log(5, 2, "DSP:Unimplemented MIDI I/O command " + Integer.toString(SBlaster.sb.dsp.cmd, 16));
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                if (SBlaster.DSP_SB2_ABOVE()) break;
                Log.log(5, 2, "DSP:Unimplemented MIDI UART command " + Integer.toString(SBlaster.sb.dsp.cmd, 16));
                break;
            }
            case 31: 
            case 125: 
            case 127: {
                if (SBlaster.DSP_SB2_ABOVE()) break;
                Log.log(5, 2, "DSP:Unimplemented auto-init DMA ADPCM command " + Integer.toString(SBlaster.sb.dsp.cmd, 16));
                break;
            }
            case 32: {
                SBlaster.DSP_AddData(127);
                break;
            }
            case 44: 
            case 152: 
            case 153: 
            case 160: 
            case 168: {
                Log.log(5, 2, "DSP:Unimplemented input command " + Integer.toString(SBlaster.sb.dsp.cmd, 16));
                break;
            }
            case 249: {
                if (SBlaster.sb.type == 6) {
                    Log.log(5, 0, "SB16 ASP unknown function " + Integer.toString(SBlaster.sb.dsp.in.data[0], 16));
                    switch (SBlaster.sb.dsp.in.data[0]) {
                        case 11: {
                            SBlaster.DSP_AddData(0);
                            break block0;
                        }
                        case 14: {
                            SBlaster.DSP_AddData(255);
                            break block0;
                        }
                        case 15: {
                            SBlaster.DSP_AddData(7);
                            break block0;
                        }
                        case 35: {
                            SBlaster.DSP_AddData(0);
                            break block0;
                        }
                        case 36: {
                            SBlaster.DSP_AddData(0);
                            break block0;
                        }
                        case 43: {
                            SBlaster.DSP_AddData(0);
                            break block0;
                        }
                        case 44: {
                            SBlaster.DSP_AddData(0);
                            break block0;
                        }
                        case 45: {
                            SBlaster.DSP_AddData(0);
                            break block0;
                        }
                        case 55: {
                            SBlaster.DSP_AddData(56);
                            break block0;
                        }
                    }
                    SBlaster.DSP_AddData(0);
                    break;
                }
                Log.log(5, 0, "SB16 ASP unknown function " + Integer.toString(SBlaster.sb.dsp.cmd, 16));
                break;
            }
            default: {
                Log.log(5, 2, "DSP:Unhandled (undocumented) command " + Integer.toString(SBlaster.sb.dsp.cmd, 16));
            }
        }
        SBlaster.sb.dsp.cmd = 0;
        SBlaster.sb.dsp.cmd_len = 0;
        SBlaster.sb.dsp.in.pos = 0;
    }

    private static void DSP_DoWrite(short val) {
        switch (SBlaster.sb.dsp.cmd) {
            case 0: {
                SBlaster.sb.dsp.cmd = val;
                SBlaster.sb.dsp.cmd_len = SBlaster.sb.type == 6 ? (short)DSP_cmd_len_sb16[val] : (short)DSP_cmd_len_sb[val];
                SBlaster.sb.dsp.in.pos = 0;
                if (SBlaster.sb.dsp.cmd_len != 0) break;
                SBlaster.DSP_DoCommand();
                break;
            }
            default: {
                SBlaster.sb.dsp.in.data[SBlaster.sb.dsp.in.pos] = val;
                ++SBlaster.sb.dsp.in.pos;
                if (SBlaster.sb.dsp.in.pos < SBlaster.sb.dsp.cmd_len) break;
                SBlaster.DSP_DoCommand();
            }
        }
    }

    private static short DSP_ReadData() {
        if (SBlaster.sb.dsp.out.used != 0) {
            SBlaster.sb.dsp.out.lastval = SBlaster.sb.dsp.out.data[SBlaster.sb.dsp.out.pos];
            ++SBlaster.sb.dsp.out.pos;
            if (SBlaster.sb.dsp.out.pos >= 64) {
                SBlaster.sb.dsp.out.pos -= 64;
            }
            --SBlaster.sb.dsp.out.used;
        }
        return SBlaster.sb.dsp.out.lastval;
    }

    private static float CALCVOL(float _VAL) {
        return (float)Math.pow(10.0, (31.0f - _VAL) * -1.3f / 20.0f);
    }

    private static void CTMIXER_UpdateVolumes() {
        if (!SBlaster.sb.mixer.enabled) {
            return;
        }
        Mixer.MixerChannel chan = Mixer.MIXER_FindChannel("SB");
        if (chan != null) {
            chan.SetVolume((float)SBlaster.sb.mixer.master[0] / 31.0f * SBlaster.CALCVOL(SBlaster.sb.mixer.dac[0]), (float)SBlaster.sb.mixer.master[1] / 31.0f * SBlaster.CALCVOL(SBlaster.sb.mixer.dac[1]));
        }
        if ((chan = Mixer.MIXER_FindChannel("FM")) != null) {
            chan.SetVolume((float)SBlaster.sb.mixer.master[0] / 31.0f * SBlaster.CALCVOL(SBlaster.sb.mixer.fm[0]), (float)SBlaster.sb.mixer.master[1] / 31.0f * SBlaster.CALCVOL(SBlaster.sb.mixer.fm[1]));
        }
    }

    private static void CTMIXER_Reset() {
        SBlaster.sb.mixer.dac[1] = 31;
        SBlaster.sb.mixer.dac[0] = 31;
        SBlaster.sb.mixer.fm[1] = 31;
        SBlaster.sb.mixer.fm[0] = 31;
        SBlaster.sb.mixer.master[1] = 31;
        SBlaster.sb.mixer.master[0] = 31;
        SBlaster.CTMIXER_UpdateVolumes();
    }

    private static void SETPROVOL(short[] _WHICH_, int _VAL_) {
        _WHICH_[0] = (short)((_VAL_ & 0xF0) >> 3 | (SBlaster.sb.type == 6 ? 1 : 3));
        _WHICH_[1] = (short)((_VAL_ & 0xF) << 1 | (SBlaster.sb.type == 6 ? 1 : 3));
    }

    private static int MAKEPROVOL(short[] _WHICH_) {
        return ((_WHICH_[0] & 0x1E) << 3 | (_WHICH_[1] & 0x1E) >> 1) & (SBlaster.sb.type == 6 ? 255 : 238);
    }

    private static void DSP_ChangeStereo(boolean stereo) {
        if (!SBlaster.sb.dma.stereo && stereo) {
            SBlaster.sb.chan.SetFreq(SBlaster.sb.freq / 2);
            SBlaster.sb.dma.mul *= 2;
            SBlaster.sb.dma.rate = SBlaster.sb.freq * SBlaster.sb.dma.mul >> 14;
            SBlaster.sb.dma.min = SBlaster.sb.dma.rate * 3 / 1000;
        } else if (SBlaster.sb.dma.stereo && !stereo) {
            SBlaster.sb.chan.SetFreq(SBlaster.sb.freq);
            SBlaster.sb.dma.mul /= 2;
            SBlaster.sb.dma.rate = SBlaster.sb.freq * SBlaster.sb.dma.mul >> 14;
            SBlaster.sb.dma.min = SBlaster.sb.dma.rate * 3 / 1000;
        }
        SBlaster.sb.dma.stereo = stereo;
    }

    private static void CTMIXER_Write(short val) {
        switch (SBlaster.sb.mixer.index) {
            case 0: {
                SBlaster.CTMIXER_Reset();
                Log.log(5, 1, "Mixer reset value " + Integer.toString(val, 16));
                break;
            }
            case 2: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.master, val & 0xF | val << 4);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 4: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.dac, val);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 6: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.fm, val & 0xF | val << 4);
                SBlaster.CTMIXER_UpdateVolumes();
                if ((val & 0x60) == 0) break;
                Log.log(5, 1, "Turned FM one channel off. not implemented " + Integer.toString(val, 16));
                break;
            }
            case 8: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.cda, val & 0xF | val << 4);
                break;
            }
            case 10: {
                if (SBlaster.sb.type == 3) {
                    SBlaster.sb.mixer.dac[0] = SBlaster.sb.mixer.dac[1] = (short)((val & 6) << 2 | 3);
                    break;
                }
                SBlaster.sb.mixer.mic = (short)((val & 7) << 2 | (SBlaster.sb.type == 6 ? 1 : 3));
                break;
            }
            case 14: {
                SBlaster.sb.mixer.stereo = (val & 2) > 0;
                SBlaster.sb.mixer.filtered = (val & 0x20) > 0;
                SBlaster.DSP_ChangeStereo(SBlaster.sb.mixer.stereo);
                Log.log(5, 1, "Mixer set to " + (SBlaster.sb.dma.stereo ? "STEREO" : "MONO"));
                break;
            }
            case 34: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.master, val);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 38: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.fm, val);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 40: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.cda, val);
                break;
            }
            case 46: {
                SBlaster.SETPROVOL(SBlaster.sb.mixer.lin, val);
                break;
            }
            case 48: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.master[0] = (short)(val >>> 3);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 49: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.master[1] = (short)(val >>> 3);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 50: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.dac[0] = (short)(val >>> 3);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 51: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.dac[1] = (short)(val >>> 3);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 52: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.fm[0] = (short)(val >>> 3);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 53: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.fm[1] = (short)(val >>> 3);
                SBlaster.CTMIXER_UpdateVolumes();
                break;
            }
            case 54: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.cda[0] = (short)(val >>> 3);
                break;
            }
            case 55: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.cda[1] = (short)(val >>> 3);
                break;
            }
            case 56: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.lin[0] = (short)(val >>> 3);
                break;
            }
            case 57: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.lin[1] = (short)(val >>> 3);
                break;
            }
            case 58: {
                if (SBlaster.sb.type != 6) break;
                SBlaster.sb.mixer.mic = (short)(val >>> 3);
                break;
            }
            case 128: {
                SBlaster.sb.hw.irq = 255;
                if ((val & 1) != 0) {
                    SBlaster.sb.hw.irq = 2;
                    break;
                }
                if ((val & 2) != 0) {
                    SBlaster.sb.hw.irq = 5;
                    break;
                }
                if ((val & 4) != 0) {
                    SBlaster.sb.hw.irq = 7;
                    break;
                }
                if ((val & 8) == 0) break;
                SBlaster.sb.hw.irq = 10;
                break;
            }
            case 129: {
                SBlaster.sb.hw.dma8 = (short)255;
                SBlaster.sb.hw.dma16 = (short)255;
                if ((val & 1) != 0) {
                    SBlaster.sb.hw.dma8 = 0;
                } else if ((val & 2) != 0) {
                    SBlaster.sb.hw.dma8 = 1;
                } else if ((val & 8) != 0) {
                    SBlaster.sb.hw.dma8 = (short)3;
                }
                if ((val & 0x20) != 0) {
                    SBlaster.sb.hw.dma16 = (short)5;
                    break;
                }
                if ((val & 0x40) != 0) {
                    SBlaster.sb.hw.dma16 = (short)6;
                    break;
                }
                if ((val & 0x80) == 0) break;
                SBlaster.sb.hw.dma16 = (short)7;
                break;
            }
            default: {
                if ((SBlaster.sb.type == 2 || SBlaster.sb.type == 4) && SBlaster.sb.mixer.index == 12 || SBlaster.sb.type == 6 && SBlaster.sb.mixer.index >= 59 && SBlaster.sb.mixer.index <= 71) {
                    SBlaster.sb.mixer.unhandled[SBlaster.sb.mixer.index] = val;
                }
                Log.log(5, 1, "MIXER:Write " + Integer.toString(val, 16) + " to unhandled index " + Integer.toString(SBlaster.sb.mixer.index, 16));
            }
        }
    }

    private static int CTMIXER_Read() {
        int ret2;
        switch (SBlaster.sb.mixer.index) {
            case 0: {
                return 0;
            }
            case 2: {
                return SBlaster.sb.mixer.master[1] >>> 1 & 0xE;
            }
            case 34: {
                return SBlaster.MAKEPROVOL(SBlaster.sb.mixer.master);
            }
            case 4: {
                return SBlaster.MAKEPROVOL(SBlaster.sb.mixer.dac);
            }
            case 6: {
                return SBlaster.sb.mixer.fm[1] >>> 1 & 0xE;
            }
            case 8: {
                return SBlaster.sb.mixer.cda[1] >>> 1 & 0xE;
            }
            case 10: {
                if (SBlaster.sb.type == 3) {
                    return SBlaster.sb.mixer.dac[0] >>> 2;
                }
                return SBlaster.sb.mixer.mic >>> 2 & (SBlaster.sb.type == 6 ? 7 : 6);
            }
            case 14: {
                return 0x11 | (SBlaster.sb.mixer.stereo ? 2 : 0) | (SBlaster.sb.mixer.filtered ? 32 : 0);
            }
            case 38: {
                return SBlaster.MAKEPROVOL(SBlaster.sb.mixer.fm);
            }
            case 40: {
                return SBlaster.MAKEPROVOL(SBlaster.sb.mixer.cda);
            }
            case 46: {
                return SBlaster.MAKEPROVOL(SBlaster.sb.mixer.lin);
            }
            case 48: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.master[0] << 3;
                }
                ret2 = 10;
                break;
            }
            case 49: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.master[1] << 3;
                }
                ret2 = 10;
                break;
            }
            case 50: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.dac[0] << 3;
                }
                ret2 = 10;
                break;
            }
            case 51: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.dac[1] << 3;
                }
                ret2 = 10;
                break;
            }
            case 52: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.fm[0] << 3;
                }
                ret2 = 10;
                break;
            }
            case 53: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.fm[1] << 3;
                }
                ret2 = 10;
                break;
            }
            case 54: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.cda[0] << 3;
                }
                ret2 = 10;
                break;
            }
            case 55: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.cda[1] << 3;
                }
                ret2 = 10;
                break;
            }
            case 56: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.lin[0] << 3;
                }
                ret2 = 10;
                break;
            }
            case 57: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.lin[1] << 3;
                }
                ret2 = 10;
                break;
            }
            case 58: {
                if (SBlaster.sb.type == 6) {
                    return SBlaster.sb.mixer.mic << 3;
                }
                ret2 = 10;
                break;
            }
            case 128: {
                switch (SBlaster.sb.hw.irq) {
                    case 2: {
                        return 1;
                    }
                    case 5: {
                        return 2;
                    }
                    case 7: {
                        return 4;
                    }
                    case 10: {
                        return 8;
                    }
                }
            }
            case 129: {
                int ret2 = 0;
                switch (SBlaster.sb.hw.dma8) {
                    case 0: {
                        ret2 = (short)(ret2 | 1);
                        break;
                    }
                    case 1: {
                        ret2 = (short)(ret2 | 2);
                        break;
                    }
                    case 3: {
                        ret2 = (short)(ret2 | 8);
                    }
                }
                switch (SBlaster.sb.hw.dma16) {
                    case 5: {
                        ret2 = (short)(ret2 | 0x20);
                        break;
                    }
                    case 6: {
                        ret2 = (short)(ret2 | 0x40);
                        break;
                    }
                    case 7: {
                        ret2 = (short)(ret2 | 0x80);
                    }
                }
                return ret2;
            }
            case 130: {
                return (SBlaster.sb.irq.pending_8bit ? 1 : 0) | (SBlaster.sb.irq.pending_16bit ? 2 : 0) | (SBlaster.sb.type == 6 ? 32 : 0);
            }
            default: {
                ret2 = (SBlaster.sb.type == 2 || SBlaster.sb.type == 4) && SBlaster.sb.mixer.index == 12 || SBlaster.sb.type == 6 && SBlaster.sb.mixer.index >= 59 && SBlaster.sb.mixer.index <= 71 ? SBlaster.sb.mixer.unhandled[SBlaster.sb.mixer.index] : 10;
                Log.log(5, 1, "MIXER:Read from unhandled index " + Integer.toString(SBlaster.sb.mixer.index, 16));
            }
        }
        return ret2;
    }

    public static boolean SB_Get_Address(IntRef sbaddr, IntRef sbirq, IntRef sbdma) {
        sbaddr.value = 0;
        sbirq.value = 0;
        sbdma.value = 0;
        if (SBlaster.sb.type == 0) {
            return false;
        }
        sbaddr.value = SBlaster.sb.hw.base;
        sbirq.value = SBlaster.sb.hw.irq;
        sbdma.value = SBlaster.sb.hw.dma8;
        return true;
    }

    private void Find_Type_And_Opl(Section_prop config, IntRef type, IntRef opl_mode) {
        String omode;
        String sbtype = config.Get_string("sbtype");
        type.value = sbtype.equalsIgnoreCase("sb1") ? 1 : (sbtype.equalsIgnoreCase("sb2") ? 3 : (sbtype.equalsIgnoreCase("sbpro1") ? 2 : (sbtype.equalsIgnoreCase("sbpro2") ? 4 : (sbtype.equalsIgnoreCase("sb16") ? 6 : (sbtype.equalsIgnoreCase("gb") ? 7 : (sbtype.equalsIgnoreCase("none") ? 0 : 6))))));
        if (!(type.value != 6 || Dosbox.IS_EGAVGA_ARCH() && DMA.SecondDMAControllerAvailable())) {
            type.value = 4;
        }
        if ((omode = config.Get_string("oplmode")).equalsIgnoreCase("none")) {
            opl_mode.value = 0;
        } else if (omode.equalsIgnoreCase("cms")) {
            opl_mode.value = 1;
        } else if (omode.equalsIgnoreCase("opl2")) {
            opl_mode.value = 2;
        } else if (omode.equalsIgnoreCase("dualopl2")) {
            opl_mode.value = 3;
        } else if (omode.equalsIgnoreCase("opl3")) {
            opl_mode.value = 4;
        } else {
            switch (type.value) {
                case 0: {
                    opl_mode.value = 0;
                    break;
                }
                case 7: {
                    opl_mode.value = 1;
                    break;
                }
                case 1: 
                case 3: {
                    opl_mode.value = 2;
                    break;
                }
                case 2: {
                    opl_mode.value = 3;
                    break;
                }
                case 4: 
                case 6: {
                    opl_mode.value = 4;
                }
            }
        }
    }

    private void close() {
        switch (this.oplmode) {
            case 0: {
                break;
            }
            case 1: {
                Gameblaster.CMS_ShutDown(this.m_configuration);
                break;
            }
            case 2: {
                Gameblaster.CMS_ShutDown(this.m_configuration);
            }
            case 3: 
            case 4: {
                Adlib.OPL_ShutDown(this.m_configuration);
            }
        }
        if (SBlaster.sb.type == 0 || SBlaster.sb.type == 7) {
            return;
        }
        SBlaster.DSP_Reset();
    }

    public SBlaster(Section configuration) {
        super(configuration);
        int i;
        Section_prop section = (Section_prop)configuration;
        for (i = 0; i < this.WriteHandler.length; ++i) {
            this.WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
        }
        for (i = 0; i < this.ReadHandler.length; ++i) {
            this.ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
        }
        SBlaster.sb.hw.base = section.Get_hex("sbbase").toInt();
        SBlaster.sb.hw.irq = section.Get_int("irq");
        int dma8bit = section.Get_int("dma");
        if (dma8bit > 255) {
            dma8bit = 255;
        }
        SBlaster.sb.hw.dma8 = (short)(dma8bit & 0xFF);
        int dma16bit = section.Get_int("hdma");
        if (dma16bit > 255) {
            dma16bit = 255;
        }
        SBlaster.sb.hw.dma16 = (short)(dma16bit & 0xFF);
        SBlaster.sb.mixer.enabled = section.Get_bool("sbmixer");
        SBlaster.sb.mixer.stereo = false;
        IntRef t = new IntRef(SBlaster.sb.type);
        IntRef o = new IntRef(this.oplmode);
        this.Find_Type_And_Opl(section, t, o);
        SBlaster.sb.type = t.value;
        this.oplmode = o.value;
        switch (this.oplmode) {
            case 0: {
                this.WriteHandler[0].Install(904, adlib_gusforward, 1);
                break;
            }
            case 1: {
                this.WriteHandler[0].Install(904, adlib_gusforward, 1);
                Gameblaster.CMS_Init(section);
                break;
            }
            case 2: {
                Gameblaster.CMS_Init(section);
            }
            case 3: 
            case 4: {
                Adlib.OPL_Init(section, this.oplmode);
            }
        }
        if (SBlaster.sb.type == 0 || SBlaster.sb.type == 7) {
            return;
        }
        SBlaster.sb.chan = this.MixerChan.Install(SBLASTER_CallBack, 22050, "SB");
        SBlaster.sb.dsp.state = (short)2;
        SBlaster.sb.dsp.out.lastval = (short)170;
        SBlaster.sb.dma.chan = null;
        for (i = 4; i <= 15; ++i) {
            if (i == 8 || i == 9 || (SBlaster.sb.type == 1 || SBlaster.sb.type == 3) && (i == 4 || i == 5)) continue;
            this.ReadHandler[i].Install(SBlaster.sb.hw.base + i, read_sb, 1);
            this.WriteHandler[i].Install(SBlaster.sb.hw.base + i, write_sb, 1);
        }
        for (i = 0; i < 256; ++i) {
            SBlaster.ASP_regs[i] = 0;
        }
        SBlaster.ASP_regs[5] = 1;
        SBlaster.ASP_regs[9] = 248;
        SBlaster.DSP_Reset();
        SBlaster.CTMIXER_Reset();
        SBlaster.sb.speaker = false;
        if (SBlaster.sb.type == 6) {
            SBlaster.sb.chan.Enable(true);
        } else {
            SBlaster.sb.chan.Enable(false);
        }
        String line = StringHelper.sprintf("SET BLASTER=A%3x I%d D%d", new Object[]{new Integer(SBlaster.sb.hw.base), new Integer(SBlaster.sb.hw.irq), new Integer(SBlaster.sb.hw.dma8)});
        if (SBlaster.sb.type == 6) {
            line = line + " H" + SBlaster.sb.hw.dma16;
        }
        line = line + " T" + SBlaster.sb.type;
        this.autoexecline.Install(line);
        SBlaster.sb.midi = Midi.MIDI_Available();
    }

    static {
        DSP_cmd_len_sb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        DSP_cmd_len_sb16 = new byte[]{0, 0, 0, 0, 1, 2, 0, 0, 1, 0, 0, 0, 0, 0, 2, 1, 1, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
        ASP_regs = new short[256];
        ASP_init_in_progress = false;
        E2_incr_table = new int[][]{{1, -2, -4, 8, -16, 32, 64, -128, -106}, {-1, 2, -4, 8, 16, -32, 64, -128, 165}, {-1, 2, 4, -8, 16, -32, -64, 128, -151}, {1, -2, 4, -8, -16, 32, -64, 128, 90}};
        DSP_DMA_CallBack = new DMA.DMA_CallBack(){

            public void call(DMA.DmaChannel chan, int event) {
                if (event == 0) {
                    return;
                }
                if (event == 1) {
                    if (sb.mode == 2) {
                        SBlaster.GenerateDMASound(sb.dma.min);
                        sb.mode = 4;
                    }
                } else if (event == 2 && sb.mode == 4 && sb.dma.mode != 0) {
                    SBlaster.DSP_ChangeMode(2);
                    SBlaster.CheckDMAEnd();
                }
            }
        };
        scaleMap1 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 0, -1, -2, -3, -4, -5, -6, -7, 1, 3, 5, 7, 9, 11, 13, 15, -1, -3, -5, -7, -9, -11, -13, -15, 2, 6, 10, 14, 18, 22, 26, 30, -2, -6, -10, -14, -18, -22, -26, -30, 4, 12, 20, 28, 36, 44, 52, 60, -4, -12, -20, -28, -36, -44, -52, -60};
        adjustMap1 = new short[]{0, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 16, 16, 16, 240, 0, 0, 0, 0, 16, 16, 16, 240, 0, 0, 0, 0, 16, 16, 16, 240, 0, 0, 0, 0, 16, 16, 16, 240, 0, 0, 0, 0, 16, 16, 16, 240, 0, 0, 0, 0, 0, 0, 0, 240, 0, 0, 0, 0, 0, 0, 0};
        scaleMap2 = new byte[]{0, 1, 0, -1, 1, 3, -1, -3, 2, 6, -2, -6, 4, 12, -4, -12, 8, 24, -8, -24, 6, 48, -16, -48};
        adjustMap2 = new short[]{0, 4, 0, 4, 252, 4, 252, 4, 252, 4, 252, 4, 252, 4, 252, 4, 252, 4, 252, 4, 252, 0, 252, 0};
        scaleMap3 = new byte[]{0, 1, 2, 3, 0, -1, -2, -3, 1, 3, 5, 7, -1, -3, -5, -7, 2, 6, 10, 14, -2, -6, -10, -14, 4, 12, 20, 28, -4, -12, -20, -28, 5, 15, 25, 35, -5, -15, -25, -35};
        adjustMap3 = new short[]{0, 0, 0, 8, 0, 0, 0, 8, 248, 0, 0, 8, 248, 0, 0, 8, 248, 0, 0, 8, 248, 0, 0, 8, 248, 0, 0, 8, 248, 0, 0, 8, 248, 0, 0, 0, 248, 0, 0, 0};
        DMA_Silent_Event = new Pic.PIC_EventHandler(){

            public void call(int val) {
                if (sb.dma.left < val) {
                    val = sb.dma.left;
                }
                int read = sb.dma.chan.Read(val, sb.dma.buf.b8, 0);
                sb.dma.left -= read;
                if (sb.dma.left == 0) {
                    if (sb.dma.mode >= 5) {
                        SBlaster.SB_RaiseIRQ(1);
                    } else {
                        SBlaster.SB_RaiseIRQ(0);
                    }
                    if (sb.dma.autoinit) {
                        sb.dma.left = sb.dma.total;
                    } else {
                        sb.mode = 0;
                        sb.dma.mode = 0;
                    }
                }
                if (sb.dma.left != 0) {
                    int bigger = sb.dma.left > sb.dma.min ? sb.dma.min : sb.dma.left;
                    float delay = (float)bigger * 1000.0f / (float)sb.dma.rate;
                    Pic.PIC_AddEvent(DMA_Silent_Event, delay, bigger);
                }
            }
        };
        END_DMA_Event = new Pic.PIC_EventHandler(){

            public void call(int val) {
                SBlaster.GenerateDMASound(val);
            }
        };
        DSP_RaiseIRQEvent = new Pic.PIC_EventHandler(){

            public void call(int val) {
                SBlaster.SB_RaiseIRQ(0);
            }
        };
        DSP_FinishReset = new Pic.PIC_EventHandler(){

            public void call(int val) {
                SBlaster.DSP_FlushData();
                SBlaster.DSP_AddData(170);
                sb.dsp.state = (short)2;
            }
        };
        DSP_E2_DMA_CallBack = new DMA.DMA_CallBack(){

            public void call(DMA.DmaChannel c, int event) {
                if (event == 2) {
                    byte[] val = new byte[]{(byte)(sb.e2.value & 0xFF)};
                    DMA.DmaChannel chan = DMA.GetDMAChannel(sb.hw.dma8);
                    chan.Register_Callback(null);
                    chan.Write(1, val, 0);
                }
            }
        };
        DSP_ADC_CallBack = new DMA.DMA_CallBack(){

            public void call(DMA.DmaChannel chan, int event) {
                if (event != 2) {
                    return;
                }
                byte[] val = new byte[]{-128};
                DMA.DmaChannel ch = DMA.GetDMAChannel(sb.hw.dma8);
                while (sb.dma.left-- != 0) {
                    ch.Write(1, val, 0);
                }
                SBlaster.SB_RaiseIRQ(0);
                ch.Register_Callback(null);
            }
        };
        read_sb = new IoHandler.IO_ReadHandler(){

            public int call(int port, int iolen) {
                switch (port - sb.hw.base) {
                    case 4: {
                        return sb.mixer.index;
                    }
                    case 5: {
                        return SBlaster.CTMIXER_Read();
                    }
                    case 10: {
                        return SBlaster.DSP_ReadData();
                    }
                    case 14: {
                        if (sb.irq.pending_8bit) {
                            sb.irq.pending_8bit = false;
                            Pic.PIC_DeActivateIRQ(sb.hw.irq);
                        }
                        if (sb.dsp.out.used != 0) {
                            return 255;
                        }
                        return 127;
                    }
                    case 15: {
                        sb.irq.pending_16bit = false;
                        break;
                    }
                    case 12: {
                        switch (sb.dsp.state) {
                            case 2: {
                                ++sb.dsp.write_busy;
                                if ((sb.dsp.write_busy & 8) != 0) {
                                    return 255;
                                }
                                return 127;
                            }
                            case 0: 
                            case 1: {
                                return 255;
                            }
                        }
                        return 255;
                    }
                    case 6: {
                        return 255;
                    }
                }
                return 255;
            }
        };
        write_sb = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                short val8 = (short)(val & 0xFF);
                switch (port - sb.hw.base) {
                    case 6: {
                        SBlaster.DSP_DoReset(val8);
                        break;
                    }
                    case 12: {
                        SBlaster.DSP_DoWrite(val8);
                        break;
                    }
                    case 4: {
                        sb.mixer.index = val8;
                        break;
                    }
                    case 5: {
                        SBlaster.CTMIXER_Write(val8);
                        break;
                    }
                }
            }
        };
        adlib_gusforward = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                Gus.adlib_commandreg = (short)(val & 0xFF);
            }
        };
        SBLASTER_CallBack = new Mixer.MIXER_Handler(){

            public void call(int len) {
                switch (sb.mode) {
                    case 0: 
                    case 3: 
                    case 4: {
                        sb.chan.AddSilence();
                        break;
                    }
                    case 1: {
                        if (sb.dac.used == 0) {
                            sb.mode = 0;
                            return;
                        }
                        sb.chan.AddStretched(sb.dac.used, sb.dac.data);
                        sb.dac.used = 0;
                        break;
                    }
                    case 2: {
                        if (((len *= sb.dma.mul) & 0x3FFF) != 0) {
                            len += 16384;
                        }
                        if ((len >>= 14) > sb.dma.left) {
                            len = sb.dma.left;
                        }
                        SBlaster.GenerateDMASound(len);
                    }
                }
            }
        };
        SBLASTER_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                test.close();
                test = null;
                sb = null;
            }
        };
        SBLASTER_Init = new Section.SectionFunction(){

            public void call(Section section) {
                sb = new SB_INFO();
                test = new SBlaster(section);
                section.AddDestroyFunction(SBLASTER_ShutDown, true);
            }
        };
    }

    private static class SB_INFO {
        int freq;
        Dma dma = new Dma();
        boolean speaker;
        boolean midi;
        short time_constant;
        int mode;
        int type;
        Irq irq = new Irq();
        Dsp dsp = new Dsp();
        Dac dac = new Dac();
        _Mixer mixer = new _Mixer();
        Adpcm adpcm = new Adpcm();
        Hw hw = new Hw();
        E2 e2 = new E2();
        Mixer.MixerChannel chan;

        private SB_INFO() {
        }

        private static class E2 {
            int value;
            int count;

            private E2() {
            }
        }

        private static class Hw {
            int base;
            int irq;
            short dma8;
            short dma16;

            private Hw() {
            }
        }

        private static class Adpcm {
            ShortRef reference = new ShortRef();
            IntRef stepsize = new IntRef(0);
            boolean haveref;

            private Adpcm() {
            }
        }

        private static class _Mixer {
            short index;
            short[] dac = new short[2];
            short[] fm = new short[2];
            short[] cda = new short[2];
            short[] master = new short[2];
            short[] lin = new short[2];
            short mic;
            boolean stereo;
            boolean enabled;
            boolean filtered;
            short[] unhandled = new short[72];

            private _Mixer() {
            }
        }

        private static class Dac {
            short[] data = new short[513];
            int used;
            short last;

            private Dac() {
            }
        }

        private static class Dsp {
            short state;
            short cmd;
            short cmd_len;
            short cmd_in_pos;
            short[] cmd_in = new short[64];
            Data in = new Data();
            Data out = new Data();
            short test_register;
            int write_busy;

            private Dsp() {
            }

            private static class Data {
                short lastval;
                short[] data = new short[64];
                int pos;
                int used;

                private Data() {
                }
            }
        }

        private static class Irq {
            boolean pending_8bit;
            boolean pending_16bit;

            private Irq() {
            }
        }

        private static class Dma {
            boolean stereo;
            boolean sign;
            boolean autoinit;
            int mode;
            int rate;
            int mul;
            int total;
            int left;
            int min;
            long start;
            Buf buf = new Buf();
            int bits;
            DMA.DmaChannel chan;
            int remain_size;

            private Dma() {
            }

            private static class Buf {
                byte[] b8 = new byte[1024];
                short[] b16 = new short[1024];

                private Buf() {
                }
            }
        }
    }
}

