/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.VGA;
import jdos.hardware.VGA_dac;
import jdos.hardware.VGA_draw;

public class VGA_attr {
    private static IoHandler.IO_ReadHandler read_p3c0 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int retval = VGA.vga.attr.index & 0x1F;
            if (VGA.vga.attr.disabled == 0) {
                retval |= 0x20;
            }
            return retval;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c0 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            if (!VGA.vga.internal.attrindex) {
                VGA.vga.attr.index = (short)(val & 0x1F);
                VGA.vga.internal.attrindex = true;
                VGA.vga.attr.disabled = (val & 0x20) != 0 ? (short)(VGA.vga.attr.disabled & 0xFFFFFFFE) : (short)(VGA.vga.attr.disabled | 1);
                return;
            }
            VGA.vga.internal.attrindex = false;
            switch (VGA.vga.attr.index) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    if ((VGA.vga.attr.disabled & 1) == 0) break;
                    VGA_attr.VGA_ATTR_SetPalette(VGA.vga.attr.index, (short)val);
                    break;
                }
                case 16: {
                    if (!Dosbox.IS_VGA_ARCH()) {
                        val &= 0x1F;
                    }
                    int difference = VGA.vga.attr.mode_control ^ val;
                    VGA.vga.attr.mode_control = (short)val;
                    if ((difference & 0x80) != 0) {
                        for (int i = 0; i < 16; ++i) {
                            VGA_attr.VGA_ATTR_SetPalette(i, VGA.vga.attr.palette[i]);
                        }
                    }
                    if ((difference & 8) != 0) {
                        VGA_draw.VGA_SetBlinking(val & 8);
                    }
                    if ((difference & 0x41) != 0) {
                        VGA.VGA_DetermineMode();
                    }
                    if ((difference & 4) == 0 || VGA.vga.mode != 9) break;
                    short pan_reg = VGA.vga.attr.horizontal_pel_panning;
                    if (pan_reg > 7) {
                        VGA.vga.config.pel_panning = 0;
                        break;
                    }
                    if ((val & 4) != 0) {
                        VGA.vga.config.pel_panning = (short)(pan_reg + 1);
                        break;
                    }
                    VGA.vga.config.pel_panning = pan_reg;
                    break;
                }
                case 17: {
                    VGA.vga.attr.overscan_color = (short)val;
                    break;
                }
                case 18: {
                    VGA.vga.attr.color_plane_enable = (short)val;
                    break;
                }
                case 19: {
                    VGA.vga.attr.horizontal_pel_panning = (short)(val & 0xF);
                    switch (VGA.vga.mode) {
                        case 9: {
                            if (val == 7 && Dosbox.svgaCard == 0) {
                                VGA.vga.config.pel_panning = (short)7;
                            }
                            if (val > 7) {
                                VGA.vga.config.pel_panning = 0;
                                break;
                            }
                            VGA.vga.config.pel_panning = (short)(val + 1);
                            break;
                        }
                        case 3: 
                        case 5: {
                            VGA.vga.config.pel_panning = (short)((val & 7) / 2);
                            break;
                        }
                        default: {
                            VGA.vga.config.pel_panning = (short)(val & 7);
                        }
                    }
                    if (Dosbox.machine != 4) break;
                    VGA.vga.draw.panning = VGA.vga.config.pel_panning;
                    break;
                }
                case 20: {
                    if (!Dosbox.IS_VGA_ARCH()) {
                        VGA.vga.attr.color_select = 0;
                        break;
                    }
                    if ((VGA.vga.attr.color_select ^ val) == 0) break;
                    VGA.vga.attr.color_select = (short)val;
                    for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
                        VGA_attr.VGA_ATTR_SetPalette(i, VGA.vga.attr.palette[i]);
                    }
                    break;
                }
                default: {
                    if (VGA.svga.write_p3c0 == null) break;
                    VGA.svga.write_p3c0.call(VGA.vga.attr.index, val, iolen);
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c1 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (VGA.vga.attr.index) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return VGA.vga.attr.palette[VGA.vga.attr.index];
                }
                case 16: {
                    return VGA.vga.attr.mode_control;
                }
                case 17: {
                    return VGA.vga.attr.overscan_color;
                }
                case 18: {
                    return VGA.vga.attr.color_plane_enable;
                }
                case 19: {
                    return VGA.vga.attr.horizontal_pel_panning;
                }
                case 20: {
                    return VGA.vga.attr.color_select;
                }
            }
            if (VGA.svga.read_p3c1 != null) {
                return VGA.svga.read_p3c1.call(VGA.vga.attr.index, iolen);
            }
            return 0;
        }
    };

    public static void VGA_ATTR_SetPalette(int index, int val) {
        VGA.vga.attr.palette[index] = (short)val;
        if ((VGA.vga.attr.mode_control & 0x80) != 0) {
            val = val & 0xF | VGA.vga.attr.color_select << 4;
        }
        val &= 0x3F;
        val |= (VGA.vga.attr.color_select & 0xC) << 4;
        if (Dosbox.machine == 4 && (VGA.vga.crtc.vertical_total | (VGA.vga.crtc.overflow & 1) << 8) == 260) {
            if ((val & 0x10) != 0) {
                val |= 0x38;
            } else if ((val &= 7) == 6) {
                val = 20;
            }
        }
        VGA_dac.VGA_DAC_CombineColor(index, val);
    }

    public static void VGA_SetupAttr() {
        if (Dosbox.IS_EGAVGA_ARCH()) {
            IoHandler.IO_RegisterWriteHandler(960, write_p3c0, 1);
            if (Dosbox.IS_VGA_ARCH()) {
                IoHandler.IO_RegisterReadHandler(960, read_p3c0, 1);
                IoHandler.IO_RegisterReadHandler(961, read_p3c1, 1);
            }
        }
    }
}

