/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.Pic;
import jdos.hardware.VGA;
import jdos.hardware.VGA_draw;

public class VGA_crtc {
    public static IoHandler.IO_WriteHandler vga_write_p3d4 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.crtc.index = (short)val;
        }
    };
    public static IoHandler.IO_ReadHandler vga_read_p3d4 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.crtc.index;
        }
    };
    public static IoHandler.IO_WriteHandler vga_write_p3d5 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (VGA.vga.crtc.index) {
                case 0: {
                    if (VGA.vga.crtc.read_only) break;
                    VGA.vga.crtc.horizontal_total = (short)val;
                    break;
                }
                case 1: {
                    if (VGA.vga.crtc.read_only || val == VGA.vga.crtc.horizontal_display_end) break;
                    VGA.vga.crtc.horizontal_display_end = (short)val;
                    VGA.VGA_StartResize();
                    break;
                }
                case 2: {
                    if (VGA.vga.crtc.read_only) break;
                    VGA.vga.crtc.start_horizontal_blanking = (short)val;
                    break;
                }
                case 3: {
                    if (VGA.vga.crtc.read_only) break;
                    VGA.vga.crtc.end_horizontal_blanking = (short)val;
                    break;
                }
                case 4: {
                    if (VGA.vga.crtc.read_only) break;
                    VGA.vga.crtc.start_horizontal_retrace = (short)val;
                    break;
                }
                case 5: {
                    if (VGA.vga.crtc.read_only) break;
                    VGA.vga.crtc.end_horizontal_retrace = (short)val;
                    break;
                }
                case 6: {
                    if (VGA.vga.crtc.read_only || val == VGA.vga.crtc.vertical_total) break;
                    VGA.vga.crtc.vertical_total = (short)val;
                    VGA.VGA_StartResize();
                    break;
                }
                case 7: {
                    VGA.vga.config.line_compare = VGA.vga.config.line_compare & 0x6FF | (val & 0x10) << 4;
                    if (VGA.vga.crtc.read_only) break;
                    if (((VGA.vga.crtc.overflow ^ val) & 0xD6) != 0) {
                        VGA.vga.crtc.overflow = (short)val;
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.crtc.overflow = (short)val;
                    break;
                }
                case 8: {
                    VGA.vga.crtc.preset_row_scan = (short)val;
                    VGA.vga.config.hlines_skip = (short)(val & 0x1F);
                    if (Dosbox.IS_VGA_ARCH()) {
                        VGA.vga.config.bytes_skip = (short)(val >> 5 & 3);
                        break;
                    }
                    VGA.vga.config.bytes_skip = 0;
                    break;
                }
                case 9: {
                    if (Dosbox.IS_VGA_ARCH()) {
                        VGA.vga.config.line_compare = VGA.vga.config.line_compare & 0x5FF | (val & 0x40) << 3;
                    }
                    if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 0 && (VGA.vga.mode == 2 || VGA.vga.mode == 3)) {
                        if (((VGA.vga.crtc.maximum_scan_line ^ val) & 0x20) != 0) {
                            VGA.vga.crtc.maximum_scan_line = (short)val;
                            VGA.VGA_StartResize();
                        } else {
                            VGA.vga.crtc.maximum_scan_line = (short)val;
                        }
                        VGA.vga.draw.address_line_total = (val & 0x1F) + 1;
                        if ((val & 0x80) == 0) break;
                        VGA.vga.draw.address_line_total *= 2;
                        break;
                    }
                    if (((VGA.vga.crtc.maximum_scan_line ^ val) & 0xBF) != 0) {
                        VGA.vga.crtc.maximum_scan_line = (short)val;
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.crtc.maximum_scan_line = (short)val;
                    break;
                }
                case 10: {
                    VGA.vga.crtc.cursor_start = (short)val;
                    VGA.vga.draw.cursor.sline = (short)(val & 0x1F);
                    if (Dosbox.IS_VGA_ARCH()) {
                        VGA.vga.draw.cursor.enabled = (val & 0x20) == 0;
                        break;
                    }
                    VGA.vga.draw.cursor.enabled = true;
                    break;
                }
                case 11: {
                    VGA.vga.crtc.cursor_end = (short)val;
                    VGA.vga.draw.cursor.eline = (short)(val & 0x1F);
                    VGA.vga.draw.cursor.delay = (short)(val >> 5 & 3);
                    break;
                }
                case 12: {
                    VGA.vga.crtc.start_address_high = (short)val;
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFF00FF | val << 8;
                    break;
                }
                case 13: {
                    VGA.vga.crtc.start_address_low = (short)val;
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFFFF00 | val;
                    break;
                }
                case 14: {
                    VGA.vga.crtc.cursor_location_high = (short)val;
                    VGA.vga.config.cursor_start &= 0xFF00FF;
                    VGA.vga.config.cursor_start |= val << 8;
                    break;
                }
                case 15: {
                    VGA.vga.crtc.cursor_location_low = (short)val;
                    VGA.vga.config.cursor_start &= 0xFFFF00;
                    VGA.vga.config.cursor_start |= val;
                    break;
                }
                case 16: {
                    VGA.vga.crtc.vertical_retrace_start = (short)val;
                    break;
                }
                case 17: {
                    VGA.vga.crtc.vertical_retrace_end = (short)val;
                    if (Dosbox.IS_EGAVGA_ARCH() && (val & 0x10) == 0) {
                        VGA.vga.draw.vret_triggered = false;
                        if (Dosbox.machine == 4) {
                            Pic.PIC_DeActivateIRQ(9);
                        }
                    }
                    if (Dosbox.IS_VGA_ARCH()) {
                        VGA.vga.crtc.read_only = (val & 0x80) > 0;
                        break;
                    }
                    VGA.vga.crtc.read_only = false;
                    break;
                }
                case 18: {
                    if (val == VGA.vga.crtc.vertical_display_end) break;
                    if (Math.abs(val - VGA.vga.crtc.vertical_display_end) < 3) {
                        Pic.PIC_RemoveEvents(VGA_draw.VGA_SetupDrawing);
                        VGA.vga.draw.resizing = false;
                        VGA.vga.crtc.vertical_display_end = (short)val;
                        VGA.VGA_StartResize(150);
                        break;
                    }
                    VGA.vga.crtc.vertical_display_end = (short)val;
                    VGA.VGA_StartResize();
                    break;
                }
                case 19: {
                    VGA.vga.crtc.offset = (short)val;
                    VGA.vga.config.scan_len &= 0x300;
                    VGA.vga.config.scan_len |= val;
                    VGA_draw.VGA_CheckScanLength();
                    break;
                }
                case 20: {
                    VGA.vga.crtc.underline_location = (short)val;
                    if (Dosbox.IS_VGA_ARCH()) {
                        if ((VGA.vga.crtc.underline_location & 0x20) != 0) {
                            VGA.vga.config.addr_shift = (short)2;
                            break;
                        }
                        if ((VGA.vga.crtc.mode_control & 0x40) != 0) {
                            VGA.vga.config.addr_shift = 0;
                            break;
                        }
                        VGA.vga.config.addr_shift = 1;
                        break;
                    }
                    VGA.vga.config.addr_shift = 1;
                    break;
                }
                case 21: {
                    if (val == VGA.vga.crtc.start_vertical_blanking) break;
                    VGA.vga.crtc.start_vertical_blanking = (short)val;
                    VGA.VGA_StartResize();
                    break;
                }
                case 22: {
                    VGA.vga.crtc.end_vertical_blanking = (short)val;
                    break;
                }
                case 23: {
                    VGA.vga.crtc.mode_control = (short)val;
                    VGA.vga.tandy.line_mask = (short)(~val & 3);
                    VGA.vga.config.addr_shift = (VGA.vga.crtc.underline_location & 0x20) != 0 ? (short)2 : ((VGA.vga.crtc.mode_control & 0x40) != 0 ? (short)0 : 1);
                    if (VGA.vga.tandy.line_mask != 0) {
                        VGA.vga.tandy.line_shift = (short)13;
                        VGA.vga.tandy.addr_mask = 8191;
                        break;
                    }
                    VGA.vga.tandy.addr_mask = -1;
                    VGA.vga.tandy.line_shift = 0;
                    break;
                }
                case 24: {
                    VGA.vga.crtc.line_compare = (short)val;
                    VGA.vga.config.line_compare = VGA.vga.config.line_compare & 0x700 | val;
                    break;
                }
                default: {
                    if (VGA.svga.write_p3d5 == null) break;
                    VGA.svga.write_p3d5.call(VGA.vga.crtc.index, val, iolen);
                }
            }
        }
    };
    public static IoHandler.IO_ReadHandler vga_read_p3d5 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (VGA.vga.crtc.index) {
                case 0: {
                    return VGA.vga.crtc.horizontal_total;
                }
                case 1: {
                    return VGA.vga.crtc.horizontal_display_end;
                }
                case 2: {
                    return VGA.vga.crtc.start_horizontal_blanking;
                }
                case 3: {
                    return VGA.vga.crtc.end_horizontal_blanking;
                }
                case 4: {
                    return VGA.vga.crtc.start_horizontal_retrace;
                }
                case 5: {
                    return VGA.vga.crtc.end_horizontal_retrace;
                }
                case 6: {
                    return VGA.vga.crtc.vertical_total;
                }
                case 7: {
                    return VGA.vga.crtc.overflow;
                }
                case 8: {
                    return VGA.vga.crtc.preset_row_scan;
                }
                case 9: {
                    return VGA.vga.crtc.maximum_scan_line;
                }
                case 10: {
                    return VGA.vga.crtc.cursor_start;
                }
                case 11: {
                    return VGA.vga.crtc.cursor_end;
                }
                case 12: {
                    return VGA.vga.crtc.start_address_high;
                }
                case 13: {
                    return VGA.vga.crtc.start_address_low;
                }
                case 14: {
                    return VGA.vga.crtc.cursor_location_high;
                }
                case 15: {
                    return VGA.vga.crtc.cursor_location_low;
                }
                case 16: {
                    return VGA.vga.crtc.vertical_retrace_start;
                }
                case 17: {
                    return VGA.vga.crtc.vertical_retrace_end;
                }
                case 18: {
                    return VGA.vga.crtc.vertical_display_end;
                }
                case 19: {
                    return VGA.vga.crtc.offset;
                }
                case 20: {
                    return VGA.vga.crtc.underline_location;
                }
                case 21: {
                    return VGA.vga.crtc.start_vertical_blanking;
                }
                case 22: {
                    return VGA.vga.crtc.end_vertical_blanking;
                }
                case 23: {
                    return VGA.vga.crtc.mode_control;
                }
                case 24: {
                    return VGA.vga.crtc.line_compare;
                }
            }
            if (VGA.svga.read_p3d5 != null) {
                return VGA.svga.read_p3d5.call(VGA.vga.crtc.index, iolen);
            }
            return 0;
        }
    };
}

