/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.gui.Render;
import jdos.hardware.IoHandler;
import jdos.hardware.VGA;
import jdos.misc.Log;

public class VGA_dac {
    private static final int DAC_READ = 0;
    private static final int DAC_WRITE = 1;
    private static IoHandler.IO_WriteHandler write_p3c6 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            if (VGA.vga.dac.pel_mask != val) {
                VGA.vga.dac.pel_mask = (short)val;
                for (int i = 0; i < 256; ++i) {
                    VGA_dac.VGA_DAC_UpdateColor(i);
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c6 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.dac.pel_mask;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c7 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.dac.read_index = (short)(val & 0xFF);
            VGA.vga.dac.pel_index = 0;
            VGA.vga.dac.state = 0;
            VGA.vga.dac.write_index = (short)(val + 1 & 0xFF);
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c7 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            if (VGA.vga.dac.state == 0) {
                return 3;
            }
            return 0;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c8 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.dac.write_index = (short)(val & 0xFF);
            VGA.vga.dac.pel_index = 0;
            VGA.vga.dac.state = 1;
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c8 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.dac.write_index;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c9 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            val &= 0x3F;
            switch (VGA.vga.dac.pel_index) {
                case 0: {
                    VGA.vga.dac.rgb[VGA.vga.dac.write_index].red = (short)val;
                    VGA.vga.dac.pel_index = 1;
                    break;
                }
                case 1: {
                    VGA.vga.dac.rgb[VGA.vga.dac.write_index].green = (short)val;
                    VGA.vga.dac.pel_index = (short)2;
                    break;
                }
                case 2: {
                    VGA.vga.dac.rgb[VGA.vga.dac.write_index].blue = (short)val;
                    switch (VGA.vga.mode) {
                        case 3: 
                        case 5: {
                            short index;
                            VGA_dac.VGA_DAC_UpdateColor(VGA.vga.dac.write_index);
                            if (VGA.vga.dac.pel_mask == 255 || ((index = VGA.vga.dac.write_index) & VGA.vga.dac.pel_mask) != index) break;
                            for (int i = index + 1; i < 256; ++i) {
                                if ((i & VGA.vga.dac.pel_mask) != index) continue;
                                VGA_dac.VGA_DAC_UpdateColor(i);
                            }
                            break;
                        }
                        default: {
                            for (int i = 0; i < 16; ++i) {
                                if (VGA.vga.dac.combine[i] != VGA.vga.dac.write_index) continue;
                                VGA_dac.VGA_DAC_SendColor(i, VGA.vga.dac.write_index);
                            }
                        }
                    }
                    VGA.vga.dac.write_index = (short)(VGA.vga.dac.write_index + 1);
                    VGA.vga.dac.write_index = (short)(VGA.vga.dac.write_index & 0xFF);
                    VGA.vga.dac.pel_index = 0;
                    break;
                }
                default: {
                    Log.log(2, 0, "VGA:DAC:Illegal Pel Index");
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c9 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int ret;
            switch (VGA.vga.dac.pel_index) {
                case 0: {
                    ret = VGA.vga.dac.rgb[VGA.vga.dac.read_index].red;
                    VGA.vga.dac.pel_index = 1;
                    break;
                }
                case 1: {
                    ret = VGA.vga.dac.rgb[VGA.vga.dac.read_index].green;
                    VGA.vga.dac.pel_index = (short)2;
                    break;
                }
                case 2: {
                    ret = VGA.vga.dac.rgb[VGA.vga.dac.read_index].blue;
                    VGA.vga.dac.read_index = (short)(VGA.vga.dac.read_index + 1);
                    VGA.vga.dac.read_index = (short)(VGA.vga.dac.read_index & 0xFF);
                    VGA.vga.dac.pel_index = 0;
                    break;
                }
                default: {
                    Log.log(3, 0, "VGA:DAC:Illegal Pel Index");
                    ret = 0;
                }
            }
            return ret;
        }
    };

    private static void VGA_DAC_SendColor(int index, int src) {
        short red = VGA.vga.dac.rgb[src].red;
        short green = VGA.vga.dac.rgb[src].green;
        short blue = VGA.vga.dac.rgb[src].blue;
        VGA.vga.dac.xlat16[index] = blue >> 1 & 0x1F | (green & 0x3F) << 5 | (red >> 1 & 0x1F) << 11;
        Render.RENDER_SetPal(index, red << 2 | red >> 4, green << 2 | green >> 4, blue << 2 | blue >> 4);
    }

    private static void VGA_DAC_UpdateColor(int index) {
        int maskIndex = index & VGA.vga.dac.pel_mask;
        VGA_dac.VGA_DAC_SendColor(index, maskIndex);
    }

    public static void VGA_DAC_CombineColor(int attr, int pal) {
        VGA.vga.dac.combine[attr] = (short)pal;
        switch (VGA.vga.mode) {
            case 5: {
                break;
            }
            case 3: {
                if (!Dosbox.IS_VGA_ARCH() || Dosbox.svgaCard != 0) break;
            }
            default: {
                VGA_dac.VGA_DAC_SendColor(attr, pal);
            }
        }
    }

    public static void VGA_DAC_SetEntry(int entry, int red, int green, int blue) {
        VGA.vga.dac.rgb[entry].red = (short)red;
        VGA.vga.dac.rgb[entry].green = (short)green;
        VGA.vga.dac.rgb[entry].blue = (short)blue;
        for (int i = 0; i < 16; ++i) {
            if (VGA.vga.dac.combine[i] != entry) continue;
            VGA_dac.VGA_DAC_SendColor(i, i);
        }
    }

    public static void VGA_SetupDAC() {
        VGA.vga.dac.first_changed = 256;
        VGA.vga.dac.bits = (short)6;
        VGA.vga.dac.pel_mask = (short)255;
        VGA.vga.dac.pel_index = 0;
        VGA.vga.dac.state = 0;
        VGA.vga.dac.read_index = 0;
        VGA.vga.dac.write_index = 0;
        if (Dosbox.IS_VGA_ARCH()) {
            IoHandler.IO_RegisterWriteHandler(966, write_p3c6, 1);
            IoHandler.IO_RegisterReadHandler(966, read_p3c6, 1);
            IoHandler.IO_RegisterWriteHandler(967, write_p3c7, 1);
            IoHandler.IO_RegisterReadHandler(967, read_p3c7, 1);
            IoHandler.IO_RegisterWriteHandler(968, write_p3c8, 1);
            IoHandler.IO_RegisterReadHandler(968, read_p3c8, 1);
            IoHandler.IO_RegisterWriteHandler(969, write_p3c9, 1);
            IoHandler.IO_RegisterReadHandler(969, read_p3c9, 1);
        } else if (Dosbox.machine == 4) {
            for (int i = 0; i < 64; ++i) {
                VGA.vga.dac.rgb[i].red = (i & 4) > 0 ? (short)42 : (short)0;
                if ((i & 0x20) > 0) {
                    VGA.vga.dac.rgb[i].red = (short)(VGA.vga.dac.rgb[i].red + 21);
                }
                VGA.vga.dac.rgb[i].green = (i & 2) > 0 ? (short)42 : (short)0;
                if ((i & 0x10) > 0) {
                    VGA.vga.dac.rgb[i].green = (short)(VGA.vga.dac.rgb[i].green + 21);
                }
                VGA.vga.dac.rgb[i].blue = (i & 1) > 0 ? (short)42 : (short)0;
                if ((i & 8) <= 0) continue;
                VGA.vga.dac.rgb[i].blue = (short)(VGA.vga.dac.rgb[i].blue + 21);
            }
        }
    }
}

