/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.cpu.Paging;
import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.hardware.VGA_draw;
import jdos.hardware.VGA_xga;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.util.Ptr;

public class VGA_memory {
    public static boolean VGA_KEEP_CHANGES = false;
    private static final int VGA_PAGES = 32;
    private static final int VGA_PAGE_A0 = 160;
    private static final int VGA_PAGE_B0 = 176;
    private static final int VGA_PAGE_B8 = 184;
    private static VGAPages vgapages = new VGAPages();
    private static vg vgaph = new vg();
    public static Section.SectionFunction VGA_Memory_ShutDown = new Section.SectionFunction(){

        public void call(Section section) {
            VGA.vga.mem.linear_orgptr = 0;
            VGA.vga.mem.linear = 0;
            VGA.vga.fastmem_orgptr = 0;
            VGA.vga.fastmem = 0;
        }
    };
    public static Section.SectionFunction VGA_SetupMemory = new Section.SectionFunction(){

        public void call(Section sec) {
            VGA.vga.svga.bank_write = 0;
            VGA.vga.svga.bank_read = 0;
            VGA.vga.svga.bank_write_full = 0;
            VGA.vga.svga.bank_read_full = 0;
            int vga_allocsize = VGA.vga.vmemsize;
            if (vga_allocsize < 524288) {
                vga_allocsize = 524288;
            }
            VGA.vga.mem.linear = VGA.vga.mem.linear_orgptr = Memory.allocate((vga_allocsize += 2048) + 16);
            VGA.vga.fastmem = VGA.vga.fastmem_orgptr = Memory.allocate((VGA.vga.vmemsize << 1) + 4096 + 16);
            VGA_draw.TempLine = Memory.allocate(7680);
            VGA.vga.vmemwrap = VGA.vga.vmemsize;
            if (VGA_KEEP_CHANGES) {
                VGA.vga.changes = new VGA.VGA_Changes();
                int changesMapSize = (VGA.vga.vmemsize >> 9) + 32;
                VGA.vga.changes.map = new Ptr(changesMapSize);
            }
            VGA.vga.svga.bank_write = 0;
            VGA.vga.svga.bank_read = 0;
            VGA.vga.svga.bank_write_full = 0;
            VGA.vga.svga.bank_read_full = 0;
            VGA.vga.svga.bank_size = 65536;
            sec.AddDestroyFunction(VGA_Memory_ShutDown);
            if (Dosbox.machine == 3) {
                // empty if block
            }
        }
    };

    private static long RasterOp(long input, int mask) {
        switch (VGA.vga.config.raster_op) {
            case 0: {
                return input & (long)mask | (long)(VGA.vga.latch.d & ~mask);
            }
            case 1: {
                return (input | (long)(~mask)) & (long)VGA.vga.latch.d;
            }
            case 2: {
                return input & (long)mask | (long)VGA.vga.latch.d;
            }
            case 3: {
                return input & (long)mask ^ (long)VGA.vga.latch.d;
            }
        }
        return 0L;
    }

    private static long ModeOperation(int val) {
        long full;
        switch (VGA.vga.config.write_mode) {
            case 0: {
                val = (val >> VGA.vga.config.data_rotate | val << 8 - VGA.vga.config.data_rotate) & 0xFF;
                full = VGA.ExpandTable[val];
                full = full & VGA.vga.config.full_not_enable_set_reset | VGA.vga.config.full_enable_and_set_reset;
                full = VGA_memory.RasterOp(full, VGA.vga.config.full_bit_mask);
                break;
            }
            case 1: {
                full = VGA.vga.latch.d;
                break;
            }
            case 2: {
                full = VGA_memory.RasterOp(VGA.FillTable[val & 0xF], VGA.vga.config.full_bit_mask);
                break;
            }
            case 3: {
                val = (val >> VGA.vga.config.data_rotate | val << 8 - VGA.vga.config.data_rotate) & 0xFF;
                full = VGA_memory.RasterOp(VGA.vga.config.full_set_reset, VGA.ExpandTable[val] & VGA.vga.config.full_bit_mask);
                break;
            }
            default: {
                full = 0L;
            }
        }
        return full;
    }

    private static void VGA_ChangedBank() {
        VGA_memory.VGA_SetupHandlers();
    }

    private static void rangeDone() {
        Paging.PAGING_ClearTLB();
    }

    public static void VGA_SetupHandlers() {
        Paging.PageHandler newHandler;
        VGA.vga.svga.bank_read_full = VGA.vga.svga.bank_read * VGA.vga.svga.bank_size;
        VGA.vga.svga.bank_write_full = VGA.vga.svga.bank_write * VGA.vga.svga.bank_size;
        switch (Dosbox.machine) {
            case 1: 
            case 3: {
                Memory.MEM_SetPageHandler(184, 8, VGA_memory.vgaph.pcjr);
                VGA_memory.rangeDone();
                return;
            }
            case 0: {
                VGA_memory.vgapages.base = 176;
                if ((VGA.vga.herc.enable_bits & 2) != 0) {
                    VGA_memory.vgapages.mask = 65535;
                    Memory.MEM_SetPageHandler(176, 16, VGA_memory.vgaph.map);
                } else {
                    VGA_memory.vgapages.mask = Short.MAX_VALUE;
                    Memory.MEM_SetPageHandler(176, 8, VGA_memory.vgaph.map);
                    Memory.MEM_SetPageHandler(184, 8, VGA_memory.vgaph.empty);
                }
                VGA_memory.rangeDone();
                return;
            }
            case 2: {
                VGA_memory.vgapages.base = 160;
                VGA_memory.vgapages.mask = 131071;
                Memory.MEM_SetPageHandler(160, 32, VGA_memory.vgaph.map);
                if ((VGA.vga.tandy.extended_ram & 1) != 0) {
                    VGA.vga.tandy.draw_base = VGA.vga.mem.linear;
                    VGA.vga.tandy.mem_base = VGA.vga.mem.linear;
                } else {
                    VGA.vga.tandy.draw_base = 524288 + VGA.vga.tandy.draw_bank * 16 * 1024;
                    VGA.vga.tandy.mem_base = 524288 + VGA.vga.tandy.mem_bank * 16 * 1024;
                    Memory.MEM_SetPageHandler(184, 8, VGA_memory.vgaph.tandy);
                }
                VGA_memory.rangeDone();
                return;
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                Log.log_msg("Illegal machine type " + Dosbox.machine);
                return;
            }
        }
        switch (VGA.vga.mode) {
            default: {
                return;
            }
            case 4: {
                newHandler = VGA_memory.vgaph.lin4;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                newHandler = VGA_memory.vgaph.map;
                break;
            }
            case 3: 
            case 5: {
                if (VGA.vga.config.chained) {
                    if (VGA.vga.config.compatible_chain4) {
                        newHandler = VGA_memory.vgaph.cvga;
                        break;
                    }
                    newHandler = VGA_memory.vgaph.map;
                    break;
                }
                newHandler = VGA_memory.vgaph.uvga;
                break;
            }
            case 2: {
                if (VGA.vga.config.chained) {
                    newHandler = VGA_memory.vgaph.cega;
                    break;
                }
                newHandler = VGA_memory.vgaph.uega;
                break;
            }
            case 9: {
                if ((VGA.vga.gfx.miscellaneous & 2) != 0) {
                    newHandler = VGA_memory.vgaph.map;
                    break;
                }
                newHandler = VGA_memory.vgaph.text;
                break;
            }
            case 0: 
            case 1: {
                newHandler = VGA_memory.vgaph.map;
            }
        }
        switch (VGA.vga.gfx.miscellaneous >> 2 & 3) {
            case 0: {
                VGA_memory.vgapages.base = 160;
                switch (Dosbox.svgaCard) {
                    case 2: 
                    case 3: {
                        VGA_memory.vgapages.mask = 65535;
                        break;
                    }
                    default: {
                        VGA_memory.vgapages.mask = 131071;
                    }
                }
                Memory.MEM_SetPageHandler(160, 32, newHandler);
                break;
            }
            case 1: {
                VGA_memory.vgapages.base = 160;
                VGA_memory.vgapages.mask = 65535;
                Memory.MEM_SetPageHandler(160, 16, newHandler);
                Memory.MEM_ResetPageHandler(176, 16);
                break;
            }
            case 2: {
                VGA_memory.vgapages.base = 176;
                VGA_memory.vgapages.mask = Short.MAX_VALUE;
                Memory.MEM_SetPageHandler(176, 8, newHandler);
                Memory.MEM_ResetPageHandler(160, 16);
                Memory.MEM_ResetPageHandler(184, 8);
                break;
            }
            case 3: {
                VGA_memory.vgapages.base = 184;
                VGA_memory.vgapages.mask = Short.MAX_VALUE;
                Memory.MEM_SetPageHandler(184, 8, newHandler);
                Memory.MEM_ResetPageHandler(160, 16);
                Memory.MEM_ResetPageHandler(176, 8);
            }
        }
        if (Dosbox.svgaCard == 1 && (VGA.vga.s3.ext_mem_ctrl & 0x10) != 0) {
            Memory.MEM_SetPageHandler(160, 16, VGA_memory.vgaph.mmio);
        }
        VGA_memory.rangeDone();
    }

    public static void VGA_StartUpdateLFB() {
        VGA.vga.lfb.page = VGA.vga.s3.la_window << 4;
        VGA.vga.lfb.addr = VGA.vga.s3.la_window << 16;
        VGA.vga.lfb.handler = VGA_memory.vgaph.lfb;
        Memory.MEM_SetLFB(VGA.vga.s3.la_window << 4, VGA.vga.vmemsize / 4096, VGA.vga.lfb.handler, VGA_memory.vgaph.mmio);
    }

    private static class vg {
        public VGA_Map_Handler map = new VGA_Map_Handler();
        public VGA_Changes_Handler changes = new VGA_Changes_Handler();
        public VGA_TEXT_PageHandler text = new VGA_TEXT_PageHandler();
        public VGA_TANDY_PageHandler tandy = new VGA_TANDY_PageHandler();
        public VGA_ChainedEGA_Handler cega = new VGA_ChainedEGA_Handler();
        public VGA_ChainedVGA_Handler cvga = new VGA_ChainedVGA_Handler();
        public VGA_UnchainedEGA_Handler uega = new VGA_UnchainedEGA_Handler();
        public VGA_UnchainedVGA_Handler uvga = new VGA_UnchainedVGA_Handler();
        public VGA_PCJR_Handler pcjr = new VGA_PCJR_Handler();
        public VGA_LIN4_Handler lin4 = new VGA_LIN4_Handler();
        public VGA_LFB_Handler lfb = new VGA_LFB_Handler();
        public VGA_LFBChanges_Handler lfbchanges = new VGA_LFBChanges_Handler();
        public VGA_MMIO_Handler mmio = new VGA_MMIO_Handler();
        public VGA_Empty_Handler empty = new VGA_Empty_Handler();

        private vg() {
        }
    }

    private static class VGA_Empty_Handler
    extends Paging.PageHandler {
        public VGA_Empty_Handler() {
            this.flags = 16;
        }

        public int readb(int addr) {
            return 255;
        }

        public void writeb(int addr, int val) {
        }
    }

    private static class VGA_PCJR_Handler
    extends Paging.PageHandler {
        public VGA_PCJR_Handler() {
            this.flags = 3;
        }

        public int GetHostReadPt(int phys_page) {
            phys_page -= 184;
            if ((VGA.vga.tandy.mem_bank & 1) != 0) {
                phys_page &= 3;
            }
            return VGA.vga.mem.linear + phys_page * 4096;
        }

        public int GetHostWritePt(int phys_page) {
            return this.GetHostReadPt(phys_page);
        }
    }

    private static class VGA_TANDY_PageHandler
    extends Paging.PageHandler {
        public VGA_TANDY_PageHandler() {
            this.flags = 3;
        }

        public int GetHostReadPt(int phys_page) {
            phys_page = (VGA.vga.tandy.mem_bank & 1) != 0 ? (phys_page &= 3) : (phys_page &= 7);
            return VGA.vga.mem.linear + phys_page * 4096;
        }

        public int GetHostWritePt(int phys_page) {
            return this.GetHostReadPt(phys_page);
        }
    }

    private static class VGA_MMIO_Handler
    extends Paging.PageHandler {
        public VGA_MMIO_Handler() {
            this.flags = 16;
        }

        public void writeb(int addr, int val) {
            int port = Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF;
            VGA_xga.XGA_Write.call(port, val, 1);
        }

        public void writew(int addr, int val) {
            int port = Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF;
            VGA_xga.XGA_Write.call(port, val, 2);
        }

        public void writed(int addr, int val) {
            int port = Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF;
            VGA_xga.XGA_Write.call(port, val, 4);
        }

        public int readb(int addr) {
            int port = Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF;
            return VGA_xga.XGA_Read.call(port, 1);
        }

        public int readw(int addr) {
            int port = Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF;
            return VGA_xga.XGA_Read.call(port, 2);
        }

        public int readd(int addr) {
            int port = Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF;
            return VGA_xga.XGA_Read.call(port, 4);
        }
    }

    private static class VGA_LFB_Handler
    extends Paging.PageHandler {
        public VGA_LFB_Handler() {
            this.flags = 19;
        }

        public int GetHostReadPt(int phys_page) {
            return VGA.vga.mem.linear + ((phys_page -= VGA.vga.lfb.page) * 4096 & VGA.vga.vmemwrap - 1);
        }

        public int GetHostWritePt(int phys_page) {
            return this.GetHostReadPt(phys_page);
        }
    }

    private static class VGA_LFBChanges_Handler
    extends Paging.PageHandler {
        public VGA_LFBChanges_Handler() {
            this.flags = 16;
        }

        public int readb(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) - VGA.vga.lfb.addr;
            return Memory.host_readb(VGA.vga.mem.linear + addr);
        }

        public int readw(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) - VGA.vga.lfb.addr;
            return Memory.host_readw(VGA.vga.mem.linear + addr);
        }

        public int readd(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) - VGA.vga.lfb.addr;
            return Memory.host_readd(VGA.vga.mem.linear + addr);
        }

        public void writeb(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) - VGA.vga.lfb.addr;
            Memory.host_writeb(VGA.vga.mem.linear + addr, (short)val);
        }

        public void writew(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) - VGA.vga.lfb.addr;
            Memory.host_writew(VGA.vga.mem.linear + addr, val);
        }

        public void writed(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) - VGA.vga.lfb.addr;
            Memory.host_writed(VGA.vga.mem.linear + addr, val);
        }
    }

    private static class VGA_LIN4_Handler
    extends VGA_UnchainedEGA_Handler {
        public VGA_LIN4_Handler() {
            this.flags = 16;
        }

        public void writeb(int addr, int val) {
            addr = VGA.vga.svga.bank_write_full + (Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF);
            this.writeHandler((addr &= (VGA.vga.vmemwrap >> 2) - 1) + 0, (short)(val >> 0));
        }

        public void writew(int addr, int val) {
            addr = VGA.vga.svga.bank_write_full + (Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF);
            this.writeHandler((addr &= (VGA.vga.vmemwrap >> 2) - 1) + 0, (short)(val >> 0));
            this.writeHandler(addr + 1, (short)(val >> 8));
        }

        public void writed(int addr, int val) {
            addr = VGA.vga.svga.bank_write_full + (Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF);
            this.writeHandler((addr &= (VGA.vga.vmemwrap >> 2) - 1) + 0, (short)(val >> 0));
            this.writeHandler(addr + 1, (short)(val >> 8));
            this.writeHandler(addr + 2, (short)(val >> 16));
            this.writeHandler(addr + 3, (short)(val >> 24));
        }

        public int readb(int addr) {
            addr = VGA.vga.svga.bank_read_full + (Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF);
            return this.readHandler(addr &= (VGA.vga.vmemwrap >> 2) - 1);
        }

        public int readw(int addr) {
            addr = VGA.vga.svga.bank_read_full + (Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF);
            return this.readHandler((addr &= (VGA.vga.vmemwrap >> 2) - 1) + 0) << 0 | this.readHandler(addr + 1) << 8;
        }

        public int readd(int addr) {
            addr = VGA.vga.svga.bank_read_full + (Paging.PAGING_GetPhysicalAddress(addr) & 0xFFFF);
            return this.readHandler((addr &= (VGA.vga.vmemwrap >> 2) - 1) + 0) << 0 | this.readHandler(addr + 1) << 8 | this.readHandler(addr + 2) << 16 | this.readHandler(addr + 3) << 24;
        }
    }

    private static class VGA_Changes_Handler
    extends Paging.PageHandler {
        public VGA_Changes_Handler() {
            this.flags = 16;
        }

        public int readb(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return Memory.host_readb(VGA.vga.mem.linear + (addr += VGA.vga.svga.bank_read_full));
        }

        public int readw(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return Memory.host_readw(VGA.vga.mem.linear + (addr += VGA.vga.svga.bank_read_full));
        }

        public int readd(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return Memory.host_readd(VGA.vga.mem.linear + (addr += VGA.vga.svga.bank_read_full));
        }

        public void writeb(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            Memory.host_writeb(VGA.vga.mem.linear + (addr += VGA.vga.svga.bank_write_full), (short)val);
        }

        public void writew(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            Memory.host_writew(VGA.vga.mem.linear + (addr += VGA.vga.svga.bank_write_full), val);
        }

        public void writed(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            Memory.host_writed(VGA.vga.mem.linear + (addr += VGA.vga.svga.bank_write_full), val);
        }
    }

    private static class VGA_Map_Handler
    extends Paging.PageHandler {
        public VGA_Map_Handler() {
            this.flags = 19;
        }

        public int GetHostReadPt(int phys_page) {
            return VGA.vga.mem.linear + (VGA.vga.svga.bank_read_full + (phys_page -= vgapages.base) * 4096 & VGA.vga.vmemwrap - 1);
        }

        public int GetHostWritePt(int phys_page) {
            return VGA.vga.mem.linear + (VGA.vga.svga.bank_write_full + (phys_page -= vgapages.base) * 4096 & VGA.vga.vmemwrap - 1);
        }
    }

    private static class VGA_TEXT_PageHandler
    extends Paging.PageHandler {
        public VGA_TEXT_PageHandler() {
            this.flags = 16;
        }

        public int readb(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return VGA.vga.draw.font[addr];
        }

        public void writeb(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            if ((VGA.vga.seq.map_mask & 4) != 0) {
                VGA.vga.draw.font[addr] = (byte)val;
            }
        }
    }

    private static class VGA_UnchainedVGA_Handler
    extends VGA_UnchainedRead_Handler {
        public void writeHandler(int addr, int val) {
            long data = VGA_memory.ModeOperation(val);
            int d = Memory.host_readd(VGA.vga.mem.linear + (addr <<= 2));
            d = (int)((long)d & VGA.vga.config.full_not_map_mask);
            d = (int)((long)d | data & VGA.vga.config.full_map_mask);
            Memory.host_writed(VGA.vga.mem.linear + addr, d);
        }

        public VGA_UnchainedVGA_Handler() {
            this.flags = 16;
        }

        public void writeb(int addr, int val) {
            int a = addr & vgapages.mask;
            this.writeHandler(a += VGA.vga.svga.bank_write_full, val);
        }

        public void writew(int addr, int val) {
            int a = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            addr += VGA.vga.svga.bank_write_full;
            this.writeHandler(a, val);
            this.writeHandler(a + 1, val >> 8);
        }

        public void writed(int addr, int val) {
            int a = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            addr += VGA.vga.svga.bank_write_full;
            this.writeHandler(a, val);
            this.writeHandler(a + 1, val >> 8);
            this.writeHandler(a + 2, val >> 16);
            this.writeHandler(a + 3, val >>> 24);
        }
    }

    private static class VGA_ChainedVGA_Handler
    extends Paging.PageHandler {
        VGA_ChainedVGA_Handler() {
            this.flags = 16;
        }

        public int readb(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return Memory.host_readb(VGA.vga.mem.linear + (((addr += VGA.vga.svga.bank_read_full) & 0xFFFFFFFC) << 2) + (addr & 3));
        }

        public int readw(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            if (((addr += VGA.vga.svga.bank_read_full) & 1) != 0) {
                short a = Memory.host_readb(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3));
                short b = Memory.host_readb(VGA.vga.mem.linear + ((addr + 1 & 0xFFFFFFFC) << 2) + (addr + 1 & 3));
                return a | b << 8;
            }
            return Memory.host_readw(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3));
        }

        public int readd(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            if (((addr += VGA.vga.svga.bank_read_full) & 3) != 0) {
                short a = Memory.host_readb(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3));
                short b = Memory.host_readb(VGA.vga.mem.linear + ((addr + 1 & 0xFFFFFFFC) << 2) + (addr + 1 & 3));
                short c = Memory.host_readb(VGA.vga.mem.linear + ((addr + 2 & 0xFFFFFFFC) << 2) + (addr + 2 & 3));
                short d = Memory.host_readb(VGA.vga.mem.linear + ((addr + 3 & 0xFFFFFFFC) << 2) + (addr + 3 & 3));
                return a | b << 8 | c << 16 | d << 24;
            }
            return Memory.host_readd(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3));
        }

        public void writeb(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            Memory.host_writeb(VGA.vga.mem.linear + (((addr += VGA.vga.svga.bank_write_full) & 0xFFFFFFFC) << 2) + (addr & 3), (short)val);
            Memory.host_writeb(VGA.vga.fastmem + addr, (short)val);
            if (addr < 320) {
                Memory.host_writeb(VGA.vga.fastmem + addr + 65536, (short)val);
            }
        }

        public void writew(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            if (((addr += VGA.vga.svga.bank_write_full) & 1) != 0) {
                Memory.host_writebs(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3), (byte)val);
                Memory.host_writebs(VGA.vga.mem.linear + ((addr + 1 & 0xFFFFFFFC) << 2) + (addr + 1 & 3), (byte)(val >> 8));
            } else {
                Memory.host_writew(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3), val);
            }
            Memory.host_writew(VGA.vga.fastmem + addr, val);
            if (addr < 320) {
                Memory.host_writew(VGA.vga.fastmem + addr + 65536, val);
            }
        }

        public void writed(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            if (((addr += VGA.vga.svga.bank_write_full) & 3) != 0) {
                Memory.host_writebs(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3), (byte)val);
                Memory.host_writebs(VGA.vga.mem.linear + ((addr + 1 & 0xFFFFFFFC) << 2) + (addr + 1 & 3), (byte)(val >> 8));
                Memory.host_writebs(VGA.vga.mem.linear + ((addr + 2 & 0xFFFFFFFC) << 2) + (addr + 2 & 3), (byte)(val >> 16));
                Memory.host_writebs(VGA.vga.mem.linear + ((addr + 3 & 0xFFFFFFFC) << 2) + (addr + 3 & 3), (byte)(val >> 24));
            } else {
                Memory.host_writed(VGA.vga.mem.linear + ((addr & 0xFFFFFFFC) << 2) + (addr & 3), val);
            }
            Memory.host_writed(VGA.vga.fastmem + addr, val);
            if (addr < 320) {
                Memory.host_writed(VGA.vga.fastmem + addr + 65536, val);
            }
        }
    }

    private static class VGA_UnchainedEGA_Handler
    extends VGA_UnchainedRead_Handler {
        public void writeHandler(int start, short val) {
            long data = VGA_memory.ModeOperation(val);
            VGA.VGA_Latch pixels = new VGA.VGA_Latch();
            pixels.d = Memory.host_readd(VGA.vga.mem.linear + start * 4);
            pixels.d = (int)((long)pixels.d & VGA.vga.config.full_not_map_mask);
            pixels.d = (int)((long)pixels.d | data & VGA.vga.config.full_map_mask);
            Memory.host_writed(VGA.vga.mem.linear + start * 4, pixels.d);
            VGA.VGA_Latch temp = new VGA.VGA_Latch();
            temp.d = pixels.d >> 4 & 0xF0F0F0F;
            int colors0_3 = VGA.Expand16Table[0][temp.b(0)] | VGA.Expand16Table[1][temp.b(1)] | VGA.Expand16Table[2][temp.b(2)] | VGA.Expand16Table[3][temp.b(3)];
            Memory.host_writed(VGA.vga.fastmem + (start << 3), colors0_3);
            temp.d = pixels.d & 0xF0F0F0F;
            int colors4_7 = VGA.Expand16Table[0][temp.b(0)] | VGA.Expand16Table[1][temp.b(1)] | VGA.Expand16Table[2][temp.b(2)] | VGA.Expand16Table[3][temp.b(3)];
            Memory.host_writed(VGA.vga.fastmem + (start << 3) + 4, colors4_7);
        }

        public VGA_UnchainedEGA_Handler() {
            this.flags = 16;
        }

        public void writeb(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            this.writeHandler((addr += VGA.vga.svga.bank_write_full) + 0, (short)(val >> 0));
        }

        public void writew(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            this.writeHandler((addr += VGA.vga.svga.bank_write_full) + 0, (short)(val >> 0));
            this.writeHandler(addr + 1, (short)(val >> 8));
        }

        public void writed(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            this.writeHandler((addr += VGA.vga.svga.bank_write_full) + 0, (short)(val >> 0));
            this.writeHandler(addr + 1, (short)(val >> 8));
            this.writeHandler(addr + 2, (short)(val >> 16));
            this.writeHandler(addr + 3, (short)(val >> 24));
        }
    }

    private static class VGA_ChainedEGA_Handler
    extends Paging.PageHandler {
        public int readHandler(int addr) {
            return Memory.host_readb(VGA.vga.mem.linear + addr);
        }

        public void writeHandler(int s, int val) {
            int start = s;
            VGA_memory.ModeOperation(val);
            VGA.VGA_Latch pixels = new VGA.VGA_Latch();
            Memory.host_writeb(VGA.vga.mem.linear + start, (short)val);
            pixels.d = Memory.host_readd(VGA.vga.mem.linear + (start >>= 2) * 4);
            VGA.VGA_Latch temp = new VGA.VGA_Latch();
            temp.d = pixels.d >> 4 & 0xF0F0F0F;
            int colors0_3 = VGA.Expand16Table[0][temp.b(0)] | VGA.Expand16Table[1][temp.b(1)] | VGA.Expand16Table[2][temp.b(2)] | VGA.Expand16Table[3][temp.b(3)];
            Memory.host_writed(VGA.vga.fastmem + start << 3, colors0_3);
            temp.d = pixels.d & 0xF0F0F0F;
            int colors4_7 = VGA.Expand16Table[0][temp.b(0)] | VGA.Expand16Table[1][temp.b(1)] | VGA.Expand16Table[2][temp.b(2)] | VGA.Expand16Table[3][temp.b(3)];
            Memory.host_writed(VGA.vga.fastmem + (start << 3) + 4, colors4_7);
        }

        public VGA_ChainedEGA_Handler() {
            this.flags = 16;
        }

        public void writeb(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            this.writeHandler((addr += VGA.vga.svga.bank_write_full) + 0, (short)(val >> 0));
        }

        public void writew(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            this.writeHandler((addr += VGA.vga.svga.bank_write_full) + 0, (short)(val >> 0));
            this.writeHandler(addr + 1, (short)(val >> 8));
        }

        public void writed(int addr, int val) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            this.writeHandler((addr += VGA.vga.svga.bank_write_full) + 0, (short)(val >> 0));
            this.writeHandler(addr + 1, (short)(val >> 8));
            this.writeHandler(addr + 2, (short)(val >> 16));
            this.writeHandler(addr + 3, (short)(val >> 24));
        }

        public int readb(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return this.readHandler(addr += VGA.vga.svga.bank_read_full);
        }

        public int readw(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return this.readHandler((addr += VGA.vga.svga.bank_read_full) + 0) << 0 | this.readHandler(addr + 1) << 8;
        }

        public int readd(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return this.readHandler((addr += VGA.vga.svga.bank_read_full) + 0) << 0 | this.readHandler(addr + 1) << 8 | this.readHandler(addr + 2) << 16 | this.readHandler(addr + 3) << 24;
        }
    }

    private static class VGA_UnchainedRead_Handler
    extends Paging.PageHandler {
        private VGA_UnchainedRead_Handler() {
        }

        public int readHandler(int start) {
            VGA.vga.latch.d = Memory.host_readd(VGA.vga.mem.linear + start * 4);
            switch (VGA.vga.config.read_mode) {
                case 0: {
                    return VGA.vga.latch.b(VGA.vga.config.read_map_select);
                }
                case 1: {
                    VGA.VGA_Latch templatch = new VGA.VGA_Latch();
                    templatch.d = VGA.vga.latch.d & VGA.FillTable[VGA.vga.config.color_dont_care] ^ VGA.FillTable[VGA.vga.config.color_compare & VGA.vga.config.color_dont_care];
                    return (short)(~(templatch.b(0) | templatch.b(1) | templatch.b(2) | templatch.b(3)));
                }
            }
            return 0;
        }

        public int readb(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return this.readHandler(addr += VGA.vga.svga.bank_read_full);
        }

        public int readw(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return this.readHandler((addr += VGA.vga.svga.bank_read_full) + 0) << 0 | this.readHandler(addr + 1) << 8;
        }

        public int readd(int addr) {
            addr = Paging.PAGING_GetPhysicalAddress(addr) & vgapages.mask;
            return this.readHandler((addr += VGA.vga.svga.bank_read_full) + 0) << 0 | this.readHandler(addr + 1) << 8 | this.readHandler(addr + 2) << 16 | this.readHandler(addr + 3) << 24;
        }
    }

    private static class VGAPages {
        int base;
        int mask;

        private VGAPages() {
        }
    }
}

