/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.Pic;
import jdos.hardware.VGA;
import jdos.hardware.VGA_crtc;

public class VGA_misc {
    public static IoHandler.IO_ReadHandler vga_read_p3da = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int retval = 0;
            double timeInFrame = Pic.PIC_FullIndex() - VGA.vga.draw.delay.framestart;
            VGA.vga.internal.attrindex = false;
            VGA.vga.tandy.pcjr_flipflop = false;
            if (timeInFrame >= VGA.vga.draw.delay.vrstart && timeInFrame <= VGA.vga.draw.delay.vrend) {
                retval |= 8;
            }
            if (timeInFrame >= VGA.vga.draw.delay.vdend) {
                retval |= 1;
            } else {
                double timeInLine = timeInFrame % VGA.vga.draw.delay.htotal;
                if (timeInLine >= VGA.vga.draw.delay.hblkstart && timeInLine <= VGA.vga.draw.delay.hblkend) {
                    retval |= 1;
                }
            }
            return retval;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c2 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.misc_output = (short)val;
            if ((val & 1) != 0) {
                IoHandler.IO_RegisterWriteHandler(980, VGA_crtc.vga_write_p3d4, 1);
                IoHandler.IO_RegisterReadHandler(980, VGA_crtc.vga_read_p3d4, 1);
                IoHandler.IO_RegisterReadHandler(986, vga_read_p3da, 1);
                IoHandler.IO_RegisterWriteHandler(981, VGA_crtc.vga_write_p3d5, 1);
                IoHandler.IO_RegisterReadHandler(981, VGA_crtc.vga_read_p3d5, 1);
                IoHandler.IO_FreeWriteHandler(948, 1);
                IoHandler.IO_FreeReadHandler(948, 1);
                IoHandler.IO_FreeWriteHandler(949, 1);
                IoHandler.IO_FreeReadHandler(949, 1);
                IoHandler.IO_FreeReadHandler(954, 1);
            } else {
                IoHandler.IO_RegisterWriteHandler(948, VGA_crtc.vga_write_p3d4, 1);
                IoHandler.IO_RegisterReadHandler(948, VGA_crtc.vga_read_p3d4, 1);
                IoHandler.IO_RegisterReadHandler(954, vga_read_p3da, 1);
                IoHandler.IO_RegisterWriteHandler(949, VGA_crtc.vga_write_p3d5, 1);
                IoHandler.IO_RegisterReadHandler(949, VGA_crtc.vga_read_p3d5, 1);
                IoHandler.IO_FreeWriteHandler(980, 1);
                IoHandler.IO_FreeReadHandler(980, 1);
                IoHandler.IO_FreeWriteHandler(981, 1);
                IoHandler.IO_FreeReadHandler(981, 1);
                IoHandler.IO_FreeReadHandler(986, 1);
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p3cc = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.misc_output;
        }
    };
    private static IoHandler.IO_ReadHandler read_p3ca = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return 0;
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c8 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return 16;
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c2 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int retval = 0;
            if (Dosbox.machine == 4) {
                retval = 15;
            } else if (Dosbox.IS_VGA_ARCH()) {
                retval = 96;
            }
            if (Dosbox.machine == 5 || (VGA.vga.misc_output >> 2 & 3) == 0 || (VGA.vga.misc_output >> 2 & 3) == 3) {
                retval |= 0x10;
            }
            if (VGA.vga.draw.vret_triggered) {
                retval |= 0x80;
            }
            return retval;
        }
    };

    public static void VGA_SetupMisc() {
        if (Dosbox.IS_EGAVGA_ARCH()) {
            VGA.vga.draw.vret_triggered = false;
            IoHandler.IO_RegisterReadHandler(962, read_p3c2, 1);
            IoHandler.IO_RegisterWriteHandler(962, write_p3c2, 1);
            if (Dosbox.IS_VGA_ARCH()) {
                IoHandler.IO_RegisterReadHandler(970, read_p3ca, 1);
                IoHandler.IO_RegisterReadHandler(972, read_p3cc, 1);
            } else {
                IoHandler.IO_RegisterReadHandler(968, read_p3c8, 1);
            }
        } else if (Dosbox.machine == 1 || Dosbox.IS_TANDY_ARCH()) {
            IoHandler.IO_RegisterReadHandler(986, vga_read_p3da, 1);
        }
    }
}

