/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.gui.Mapper;
import jdos.gui.Render;
import jdos.hardware.IoHandler;
import jdos.hardware.Pic;
import jdos.hardware.VGA;
import jdos.hardware.VGA_attr;
import jdos.hardware.VGA_dac;
import jdos.hardware.VGA_draw;
import jdos.hardware.VGA_memory;
import jdos.ints.Int10_memory;
import jdos.misc.Log;
import jdos.util.Ptr;

public class VGA_other {
    private static IoHandler.IO_WriteHandler write_crtc_index_other = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.other.index = (short)val;
        }
    };
    private static IoHandler.IO_ReadHandler read_crtc_index_other = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.other.index;
        }
    };
    private static IoHandler.IO_WriteHandler write_crtc_data_other = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (VGA.vga.other.index) {
                case 0: {
                    if ((VGA.vga.other.htotal ^ val) != 0) {
                        VGA.VGA_StartResize();
                    }
                    VGA.vga.other.htotal = (short)val;
                    break;
                }
                case 1: {
                    if ((VGA.vga.other.hdend ^ val) != 0) {
                        VGA.VGA_StartResize();
                    }
                    VGA.vga.other.hdend = (short)val;
                    break;
                }
                case 2: {
                    VGA.vga.other.hsyncp = (short)val;
                    break;
                }
                case 3: {
                    VGA.vga.other.vsyncw = Dosbox.machine == 2 ? (short)(val >> 4) : (short)16;
                    VGA.vga.other.hsyncw = (short)(val & 0xF);
                    break;
                }
                case 4: {
                    if ((VGA.vga.other.vtotal ^ val) != 0) {
                        VGA.VGA_StartResize();
                    }
                    VGA.vga.other.vtotal = (short)val;
                    break;
                }
                case 5: {
                    if ((VGA.vga.other.vadjust ^ val) != 0) {
                        VGA.VGA_StartResize();
                    }
                    VGA.vga.other.vadjust = (short)val;
                    break;
                }
                case 6: {
                    if ((VGA.vga.other.vdend ^ val) != 0) {
                        VGA.VGA_StartResize();
                    }
                    VGA.vga.other.vdend = (short)val;
                    break;
                }
                case 7: {
                    VGA.vga.other.vsyncp = (short)val;
                    break;
                }
                case 9: {
                    if ((VGA.vga.other.max_scanline ^ (val &= 0x1F)) != 0) {
                        VGA.VGA_StartResize();
                    }
                    VGA.vga.other.max_scanline = (short)val;
                    break;
                }
                case 10: {
                    VGA.vga.other.cursor_start = (short)(val & 0x3F);
                    VGA.vga.draw.cursor.sline = (short)(val & 0x1F);
                    VGA.vga.draw.cursor.enabled = (val & 0x60) != 32;
                    break;
                }
                case 11: {
                    VGA.vga.other.cursor_end = (short)(val & 0x1F);
                    VGA.vga.draw.cursor.eline = (short)(val & 0x1F);
                    break;
                }
                case 12: {
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFF | val << 8;
                    break;
                }
                case 13: {
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFF00 | val;
                    break;
                }
                case 14: {
                    VGA.vga.config.cursor_start &= 0xFF;
                    VGA.vga.config.cursor_start |= (short)val << 8;
                    break;
                }
                case 15: {
                    VGA.vga.config.cursor_start &= 0xFF00;
                    VGA.vga.config.cursor_start |= (short)val;
                    break;
                }
                case 16: {
                    VGA.vga.other.lightpen &= 0xFF;
                    VGA.vga.other.lightpen |= (val & 0x3F) << 8;
                    break;
                }
                case 17: {
                    VGA.vga.other.lightpen &= 0xFF00;
                    VGA.vga.other.lightpen |= (short)val;
                    break;
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_crtc_data_other = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (VGA.vga.other.index) {
                case 0: {
                    return VGA.vga.other.htotal;
                }
                case 1: {
                    return VGA.vga.other.hdend;
                }
                case 2: {
                    return VGA.vga.other.hsyncp;
                }
                case 3: {
                    if (Dosbox.machine == 2) {
                        return VGA.vga.other.hsyncw | VGA.vga.other.vsyncw << 4;
                    }
                    return VGA.vga.other.hsyncw;
                }
                case 4: {
                    return VGA.vga.other.vtotal;
                }
                case 5: {
                    return VGA.vga.other.vadjust;
                }
                case 6: {
                    return VGA.vga.other.vdend;
                }
                case 7: {
                    return VGA.vga.other.vsyncp;
                }
                case 9: {
                    return VGA.vga.other.max_scanline;
                }
                case 10: {
                    return VGA.vga.other.cursor_start;
                }
                case 11: {
                    return VGA.vga.other.cursor_end;
                }
                case 12: {
                    return (short)(VGA.vga.config.display_start >> 8);
                }
                case 13: {
                    return (short)(VGA.vga.config.display_start & 0xFF);
                }
                case 14: {
                    return (short)(VGA.vga.config.cursor_start >> 8);
                }
                case 15: {
                    return (short)(VGA.vga.config.cursor_start & 0xFF);
                }
                case 16: {
                    return (short)(VGA.vga.other.lightpen >> 8);
                }
                case 17: {
                    return (short)(VGA.vga.other.lightpen & 0xFF);
                }
            }
            return -1;
        }
    };
    private static double hue_offset = 0.0;
    private static short cga16_val = 0;
    private static short herc_pal = 0;
    private static Mapper.MAPPER_Handler IncreaseHue = new Mapper.MAPPER_Handler(){

        public void call(boolean pressed) {
            if (!pressed) {
                return;
            }
            hue_offset += 5.0;
            VGA_other.update_cga16_color();
            Log.log_msg("Hue at " + hue_offset);
        }
    };
    private static Mapper.MAPPER_Handler DecreaseHue = new Mapper.MAPPER_Handler(){

        public void call(boolean pressed) {
            if (!pressed) {
                return;
            }
            hue_offset -= 5.0;
            VGA_other.update_cga16_color();
            Log.log_msg("Hue at %f" + hue_offset);
        }
    };
    private static IoHandler.IO_WriteHandler write_cga = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (port) {
                case 984: {
                    VGA.vga.tandy.mode_control = (short)val;
                    VGA.vga.attr.disabled = (short)((val & 8) == 0 ? 1 : 0);
                    if ((VGA.vga.tandy.mode_control & 2) != 0) {
                        if ((VGA.vga.tandy.mode_control & 0x10) != 0) {
                            if ((val & 4) == 0 && Dosbox.machine == 1) {
                                VGA.VGA_SetMode(12);
                            } else {
                                VGA.VGA_SetMode(13);
                            }
                        } else {
                            VGA.VGA_SetMode(14);
                        }
                        VGA_other.write_color_select(VGA.vga.tandy.color_select);
                    } else {
                        VGA.VGA_SetMode(16);
                    }
                    VGA_draw.VGA_SetBlinking(val & 0x20);
                    break;
                }
                case 985: {
                    VGA_other.write_color_select((short)val);
                }
            }
        }
    };
    private static IoHandler.IO_WriteHandler write_tandy = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (port) {
                case 984: {
                    VGA.vga.tandy.mode_control = (short)val;
                    VGA_other.TandyCheckLineMask();
                    VGA_draw.VGA_SetBlinking(val & 0x20);
                    VGA_other.TANDY_FindMode();
                    break;
                }
                case 985: {
                    VGA_other.write_color_select((short)val);
                    break;
                }
                case 986: {
                    VGA.vga.tandy.reg_index = (short)val;
                    break;
                }
                case 987: {
                    VGA.vga.other.lightpen_triggered = false;
                    break;
                }
                case 988: {
                    if (VGA.vga.other.lightpen_triggered) break;
                    VGA.vga.other.lightpen_triggered = true;
                    double timeInFrame = Pic.PIC_FullIndex() - VGA.vga.draw.delay.framestart;
                    double timeInLine = timeInFrame % VGA.vga.draw.delay.htotal;
                    int current_scanline = (int)(timeInFrame / VGA.vga.draw.delay.htotal);
                    VGA.vga.other.lightpen = VGA.vga.draw.address_add / 2 * (current_scanline / 2);
                    VGA.vga.other.lightpen = (int)((double)VGA.vga.other.lightpen + timeInLine / VGA.vga.draw.delay.hdend * (double)(VGA.vga.draw.address_add / 2));
                    break;
                }
                case 990: {
                    VGA_other.write_tandy_reg((short)val);
                    break;
                }
                case 991: {
                    VGA.vga.tandy.line_mask = (short)(val >> 6);
                    VGA.vga.tandy.draw_bank = (short)(val & ((VGA.vga.tandy.line_mask & 2) != 0 ? 6 : 7));
                    VGA.vga.tandy.mem_bank = (short)(val >> 3 & ((VGA.vga.tandy.line_mask & 2) != 0 ? 6 : 7));
                    VGA_other.TandyCheckLineMask();
                    VGA_memory.VGA_SetupHandlers();
                }
            }
        }
    };
    private static IoHandler.IO_WriteHandler write_pcjr = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (port) {
                case 985: {
                    VGA_other.write_color_select((short)val);
                    break;
                }
                case 986: {
                    if (VGA.vga.tandy.pcjr_flipflop) {
                        VGA_other.write_tandy_reg((short)val);
                    } else {
                        VGA.vga.tandy.reg_index = (short)val;
                    }
                    VGA.vga.tandy.pcjr_flipflop = !VGA.vga.tandy.pcjr_flipflop;
                    break;
                }
                case 991: {
                    VGA.vga.tandy.line_mask = (short)(val >> 6);
                    VGA.vga.tandy.draw_bank = (short)(val & ((VGA.vga.tandy.line_mask & 2) != 0 ? 6 : 7));
                    VGA.vga.tandy.mem_bank = (short)(val >> 3 & ((VGA.vga.tandy.line_mask & 2) != 0 ? 6 : 7));
                    VGA.vga.tandy.draw_base = VGA.vga.tandy.draw_bank * 16 * 1024;
                    VGA.vga.tandy.mem_base = VGA.vga.tandy.mem_bank * 16 * 1024;
                    VGA_other.TandyCheckLineMask();
                    VGA_memory.VGA_SetupHandlers();
                }
            }
        }
    };
    private static Mapper.MAPPER_Handler CycleHercPal = new Mapper.MAPPER_Handler(){

        public void call(boolean pressed) {
            if (!pressed) {
                return;
            }
            if ((herc_pal = (short)(herc_pal + 1)) > 2) {
                herc_pal = (short)0;
            }
            VGA_other.Herc_Palette();
            VGA_dac.VGA_DAC_CombineColor(1, 7);
        }
    };
    private static IoHandler.IO_WriteHandler write_hercules = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (port) {
                case 952: {
                    if ((VGA.vga.herc.mode_control & 2) != 0) {
                        if ((val & 2) == 0) {
                            VGA.vga.herc.mode_control = (short)(VGA.vga.herc.mode_control & 0xFFFFFFFD);
                            VGA.VGA_SetMode(11);
                        }
                    } else if ((val & 2) != 0 && (VGA.vga.herc.enable_bits & 1) != 0) {
                        VGA.vga.herc.mode_control = (short)(VGA.vga.herc.mode_control | 2);
                        VGA.VGA_SetMode(10);
                    }
                    if ((VGA.vga.herc.mode_control & 0x80) != 0) {
                        if ((val & 0x80) == 0) {
                            VGA.vga.herc.mode_control = (short)(VGA.vga.herc.mode_control & 0xFFFFFF7F);
                            VGA.vga.tandy.draw_base = VGA.vga.mem.linear;
                        }
                    } else if ((val & 0x80) != 0 && (VGA.vga.herc.enable_bits & 2) != 0) {
                        VGA.vga.herc.mode_control = (short)(VGA.vga.herc.mode_control | 0x80);
                        VGA.vga.tandy.draw_base = VGA.vga.mem.linear + 32768;
                    }
                    VGA.vga.draw.blinking = (val & 0x20) != 0;
                    VGA.vga.herc.mode_control = (short)(VGA.vga.herc.mode_control & 0x82);
                    VGA.vga.herc.mode_control = (short)(VGA.vga.herc.mode_control | val & 0xFFFFFF7D);
                    break;
                }
                case 959: {
                    if ((VGA.vga.herc.enable_bits ^ val) == 0) break;
                    VGA.vga.herc.enable_bits = (short)val;
                    VGA_memory.VGA_SetupHandlers();
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_herc_status = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            double timeInLine;
            double timeInFrame = Pic.PIC_FullIndex() - VGA.vga.draw.delay.framestart;
            int retval = 114;
            if (timeInFrame < VGA.vga.draw.delay.vrstart || timeInFrame > VGA.vga.draw.delay.vrend) {
                retval = (short)(retval | 0x80);
            }
            if ((timeInLine = timeInFrame % VGA.vga.draw.delay.htotal) >= VGA.vga.draw.delay.hrstart && timeInLine <= VGA.vga.draw.delay.hrend) {
                retval = (short)(retval | 1);
            }
            if ((retval & 0x81) == 128) {
                retval = (short)(retval | 8);
            }
            return retval;
        }
    };

    private static void cga16_color_select(short val) {
        cga16_val = val;
        VGA_other.update_cga16_color();
    }

    private static void update_cga16_color() {
        int baseR = 0;
        int baseG = 0;
        int baseB = 0;
        double basehue = 50.0;
        if ((cga16_val & 1) != 0) {
            baseB += 168;
        }
        if ((cga16_val & 2) != 0) {
            baseG += 168;
        }
        if ((cga16_val & 4) != 0) {
            baseR += 168;
        }
        if ((cga16_val & 8) != 0) {
            baseR += 87;
            baseG += 87;
            baseB += 87;
        }
        if ((cga16_val & 0x20) != 0) {
            basehue = 35.0;
        }
        double hue = (basehue + hue_offset) * 0.017453239;
        double sinhue = Math.sin(hue);
        double coshue = Math.cos(hue);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 5; ++j) {
                double B;
                double G;
                int index = 0x80 | j << 4 | i;
                int colorBit4 = (i & 1) >> 0;
                int colorBit3 = (i & 2) >> 1;
                int colorBit2 = (i & 4) >> 2;
                int colorBit1 = (i & 8) >> 3;
                double I = 0.0;
                double Q = 0.0;
                I += (double)colorBit1;
                Q += (double)colorBit2;
                I -= (double)colorBit3;
                Q -= (double)colorBit4;
                double Y = (double)j / 4.0;
                double pixelI = I * 1.0 / 3.0;
                double pixelQ = Q * 1.0 / 3.0;
                double R = Y + 0.956 * (I = pixelI * coshue + pixelQ * sinhue) + 0.621 * (Q = pixelQ * coshue - pixelI * sinhue);
                if (R < 0.0) {
                    R = 0.0;
                }
                if (R > 1.0) {
                    R = 1.0;
                }
                if ((G = Y - 0.272 * I - 0.647 * Q) < 0.0) {
                    G = 0.0;
                }
                if (G > 1.0) {
                    G = 1.0;
                }
                if ((B = Y - 1.105 * I + 1.702 * Q) < 0.0) {
                    B = 0.0;
                }
                if (B > 1.0) {
                    B = 1.0;
                }
                Render.RENDER_SetPal(index, (short)(R * (double)baseR), (short)(G * (double)baseG), (short)(B * (double)baseB));
            }
        }
    }

    private static void write_color_select(short val) {
        VGA.vga.tandy.color_select = val;
        switch (VGA.vga.mode) {
            case 13: {
                VGA.VGA_SetCGA2Table(0, (short)(val & 0xF));
                break;
            }
            case 14: {
                int base;
                if (Dosbox.machine == 2 && (VGA.vga.tandy.gfx_control & 8) != 0 || Dosbox.machine == 3 && VGA.vga.tandy.mode_control == 11) {
                    VGA.VGA_SetCGA4Table(0, 1, 2, 3);
                    return;
                }
                int n = base = (val & 0x10) != 0 ? 8 : 0;
                if ((VGA.vga.tandy.mode_control & 4) != 0) {
                    VGA.VGA_SetCGA4Table(val & 0xF, 3 + base, 4 + base, 7 + base);
                    break;
                }
                if ((val & 0x20) != 0) {
                    VGA.VGA_SetCGA4Table(val & 0xF, 3 + base, 5 + base, 7 + base);
                    break;
                }
                VGA.VGA_SetCGA4Table(val & 0xF, 2 + base, 4 + base, 6 + base);
                break;
            }
            case 12: {
                VGA_other.cga16_color_select(val);
                break;
            }
        }
    }

    private static void TANDY_FindMode() {
        if ((VGA.vga.tandy.mode_control & 2) != 0) {
            if ((VGA.vga.tandy.gfx_control & 0x10) != 0) {
                VGA.VGA_SetMode(15);
            } else if ((VGA.vga.tandy.gfx_control & 8) != 0) {
                VGA.VGA_SetMode(14);
            } else if ((VGA.vga.tandy.mode_control & 0x10) != 0) {
                VGA.VGA_SetMode(13);
            } else {
                VGA.VGA_SetMode(14);
            }
            VGA_other.write_color_select(VGA.vga.tandy.color_select);
        } else {
            VGA.VGA_SetMode(16);
        }
    }

    private static void PCJr_FindMode() {
        if ((VGA.vga.tandy.mode_control & 2) != 0) {
            if ((VGA.vga.tandy.mode_control & 0x10) != 0) {
                if (VGA.vga.mode == 14) {
                    VGA.VGA_SetModeNow(15);
                } else {
                    VGA.VGA_SetMode(15);
                }
            } else if ((VGA.vga.tandy.gfx_control & 8) != 0) {
                VGA.VGA_SetMode(13);
            } else if (VGA.vga.mode == 15) {
                VGA.VGA_SetModeNow(14);
            } else {
                VGA.VGA_SetMode(14);
            }
            VGA_other.write_color_select(VGA.vga.tandy.color_select);
        } else {
            VGA.VGA_SetMode(16);
        }
    }

    private static void TandyCheckLineMask() {
        if ((VGA.vga.tandy.extended_ram & 1) != 0) {
            VGA.vga.tandy.line_mask = 0;
        } else if ((VGA.vga.tandy.mode_control & 2) != 0) {
            VGA.vga.tandy.line_mask = (short)(VGA.vga.tandy.line_mask | 1);
        }
        if (VGA.vga.tandy.line_mask != 0) {
            VGA.vga.tandy.line_shift = (short)13;
            VGA.vga.tandy.addr_mask = 8191;
        } else {
            VGA.vga.tandy.addr_mask = -1;
            VGA.vga.tandy.line_shift = 0;
        }
    }

    private static void write_tandy_reg(short val) {
        switch (VGA.vga.tandy.reg_index) {
            case 0: {
                if (Dosbox.machine != 3) break;
                VGA.vga.tandy.mode_control = val;
                VGA_draw.VGA_SetBlinking(val & 0x20);
                VGA_other.PCJr_FindMode();
                VGA.vga.attr.disabled = (short)((val & 8) == 0 ? 1 : 0);
                break;
            }
            case 2: {
                VGA.vga.tandy.border_color = val;
                break;
            }
            case 3: {
                VGA.vga.tandy.gfx_control = val;
                if (Dosbox.machine == 2) {
                    VGA_other.TANDY_FindMode();
                    break;
                }
                VGA_other.PCJr_FindMode();
                break;
            }
            case 5: {
                VGA.vga.tandy.extended_ram = val;
                VGA_other.TandyCheckLineMask();
                VGA_memory.VGA_SetupHandlers();
                break;
            }
            case 8: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                VGA_attr.VGA_ATTR_SetPalette(VGA.vga.tandy.reg_index - 16, val & 0xF);
                break;
            }
        }
    }

    public static void Herc_Palette() {
        switch (herc_pal) {
            case 0: {
                VGA_dac.VGA_DAC_SetEntry(7, 42, 42, 42);
                VGA_dac.VGA_DAC_SetEntry(15, 63, 63, 63);
                break;
            }
            case 1: {
                VGA_dac.VGA_DAC_SetEntry(7, 52, 32, 0);
                VGA_dac.VGA_DAC_SetEntry(15, 63, 52, 0);
                break;
            }
            case 2: {
                VGA_dac.VGA_DAC_SetEntry(7, 0, 38, 0);
                VGA_dac.VGA_DAC_SetEntry(15, 0, 63, 0);
            }
        }
    }

    public static void VGA_SetupOther() {
        int base;
        int i;
        VGA.vga.tandy = new VGA.VGA_TANDY();
        VGA.vga.attr.disabled = 0;
        VGA.vga.config.bytes_skip = 0;
        VGA.vga.tandy.draw_base = VGA.vga.mem.linear;
        VGA.vga.tandy.mem_base = VGA.vga.mem.linear;
        VGA.vga.tandy.addr_mask = 8191;
        VGA.vga.tandy.line_mask = (short)3;
        VGA.vga.tandy.line_shift = (short)13;
        if (Dosbox.machine == 1 || Dosbox.IS_TANDY_ARCH()) {
            for (i = 0; i < 256; ++i) {
                System.arraycopy(Int10_memory.int10_font_08, i * 8, VGA.vga.draw.font, i * 32, 8);
            }
            VGA.vga.draw.font_tables[0] = VGA.vga.draw.font_tables[1] = new Ptr(VGA.vga.draw.font, 0);
        }
        if (Dosbox.machine == 0) {
            for (i = 0; i < 256; ++i) {
                System.arraycopy(Int10_memory.int10_font_14, i * 14, VGA.vga.draw.font, i * 32, 14);
            }
            VGA.vga.draw.font_tables[0] = VGA.vga.draw.font_tables[1] = new Ptr(VGA.vga.draw.font, 0);
            Mapper.MAPPER_AddHandler(CycleHercPal, 10, 0, "hercpal", "Herc Pal");
        }
        if (Dosbox.machine == 1) {
            IoHandler.IO_RegisterWriteHandler(984, write_cga, 1);
            IoHandler.IO_RegisterWriteHandler(985, write_cga, 1);
            IoHandler.IO_RegisterWriteHandler(987, write_tandy, 1);
            IoHandler.IO_RegisterWriteHandler(988, write_tandy, 1);
            Mapper.MAPPER_AddHandler(IncreaseHue, 10, 2, "inchue", "Inc Hue");
            Mapper.MAPPER_AddHandler(DecreaseHue, 10, 0, "dechue", "Dec Hue");
        }
        if (Dosbox.machine == 2) {
            write_tandy.call(991, 0, 0);
            IoHandler.IO_RegisterWriteHandler(984, write_tandy, 1);
            IoHandler.IO_RegisterWriteHandler(985, write_tandy, 1);
            IoHandler.IO_RegisterWriteHandler(990, write_tandy, 1);
            IoHandler.IO_RegisterWriteHandler(991, write_tandy, 1);
            IoHandler.IO_RegisterWriteHandler(986, write_tandy, 1);
        }
        if (Dosbox.machine == 3) {
            write_pcjr.call(991, 63, 0);
            IoHandler.IO_RegisterWriteHandler(985, write_pcjr, 1);
            IoHandler.IO_RegisterWriteHandler(986, write_pcjr, 1);
            IoHandler.IO_RegisterWriteHandler(991, write_pcjr, 1);
        }
        if (Dosbox.machine == 0) {
            base = 944;
            for (int i2 = 0; i2 < 4; ++i2) {
                IoHandler.IO_RegisterWriteHandler(base + i2 * 2, write_crtc_index_other, 1);
                IoHandler.IO_RegisterWriteHandler(base + i2 * 2 + 1, write_crtc_data_other, 1);
                IoHandler.IO_RegisterReadHandler(base + i2 * 2, read_crtc_index_other, 1);
                IoHandler.IO_RegisterReadHandler(base + i2 * 2 + 1, read_crtc_data_other, 1);
            }
            VGA.vga.herc.enable_bits = 0;
            VGA.vga.herc.mode_control = (short)10;
            VGA.vga.crtc.underline_location = (short)13;
            IoHandler.IO_RegisterWriteHandler(952, write_hercules, 1);
            IoHandler.IO_RegisterWriteHandler(959, write_hercules, 1);
            IoHandler.IO_RegisterReadHandler(954, read_herc_status, 1);
        }
        if (Dosbox.machine == 1) {
            base = 976;
            for (int port_ct = 0; port_ct < 4; ++port_ct) {
                IoHandler.IO_RegisterWriteHandler(base + port_ct * 2, write_crtc_index_other, 1);
                IoHandler.IO_RegisterWriteHandler(base + port_ct * 2 + 1, write_crtc_data_other, 1);
                IoHandler.IO_RegisterReadHandler(base + port_ct * 2, read_crtc_index_other, 1);
                IoHandler.IO_RegisterReadHandler(base + port_ct * 2 + 1, read_crtc_data_other, 1);
            }
        }
        if (Dosbox.IS_TANDY_ARCH()) {
            base = 980;
            IoHandler.IO_RegisterWriteHandler(base, write_crtc_index_other, 1);
            IoHandler.IO_RegisterWriteHandler(base + 1, write_crtc_data_other, 1);
            IoHandler.IO_RegisterReadHandler(base, read_crtc_index_other, 1);
            IoHandler.IO_RegisterReadHandler(base + 1, read_crtc_data_other, 1);
        }
    }
}

