/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.hardware.VGA_crtc;
import jdos.hardware.VGA_misc;
import jdos.misc.Log;

public class VGA_xga {
    private static final boolean XGA_SHOW_COMMAND_TRACE = false;
    private static XGAStatus xga;
    public static IoHandler.IO_WriteHandler XGA_Write;
    public static IoHandler.IO_ReadHandler XGA_Read;

    private static int XGA_SCREEN_WIDTH() {
        return VGA.vga.s3.xga_screen_width;
    }

    private static int XGA_COLOR_MODE() {
        return VGA.vga.s3.xga_color_mode;
    }

    private static void XGA_Write_Multifunc(int val, int len) {
        int regselect = val >>> 12;
        int dataval = val & 0xFFF;
        switch (regselect) {
            case 0: {
                VGA_xga.xga.MIPcount = dataval;
                break;
            }
            case 1: {
                VGA_xga.xga.scissors.y1 = dataval;
                break;
            }
            case 2: {
                VGA_xga.xga.scissors.x1 = dataval;
                break;
            }
            case 3: {
                VGA_xga.xga.scissors.y2 = dataval;
                break;
            }
            case 4: {
                VGA_xga.xga.scissors.x2 = dataval;
                break;
            }
            case 10: {
                VGA_xga.xga.pix_cntl = dataval;
                break;
            }
            case 13: {
                VGA_xga.xga.control2 = dataval;
                break;
            }
            case 14: {
                VGA_xga.xga.control1 = dataval;
                break;
            }
            case 15: {
                VGA_xga.xga.read_sel = dataval;
                break;
            }
            default: {
                Log.log_msg("XGA: Unhandled multifunction command " + Integer.toString(regselect, 16));
            }
        }
    }

    private static int XGA_Read_Multifunc() {
        switch (VGA_xga.xga.read_sel++) {
            case 0: {
                return VGA_xga.xga.MIPcount;
            }
            case 1: {
                return VGA_xga.xga.scissors.y1;
            }
            case 2: {
                return VGA_xga.xga.scissors.x1;
            }
            case 3: {
                return VGA_xga.xga.scissors.y2;
            }
            case 4: {
                return VGA_xga.xga.scissors.x2;
            }
            case 5: {
                return VGA_xga.xga.pix_cntl;
            }
            case 6: {
                return VGA_xga.xga.control1;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return VGA_xga.xga.control2;
            }
        }
        return 0;
    }

    private static void XGA_DrawPoint(int x, int y, int c) {
        if ((VGA_xga.xga.curcommand & 1) == 0) {
            return;
        }
        if ((VGA_xga.xga.curcommand & 0x10) == 0) {
            return;
        }
        if (x < VGA_xga.xga.scissors.x1) {
            return;
        }
        if (x > VGA_xga.xga.scissors.x2) {
            return;
        }
        if (y < VGA_xga.xga.scissors.y1) {
            return;
        }
        if (y > VGA_xga.xga.scissors.y2) {
            return;
        }
        int memaddr = y * VGA_xga.XGA_SCREEN_WIDTH() + x;
        switch (VGA_xga.XGA_COLOR_MODE()) {
            case 5: {
                if (memaddr >= VGA.vga.vmemsize) break;
                Memory.host_writeb(VGA.vga.mem.linear + memaddr, (short)c);
                break;
            }
            case 6: {
                if (memaddr * 2 >= VGA.vga.vmemsize) break;
                Memory.host_writew(VGA.vga.mem.linear + memaddr * 2, c & Short.MAX_VALUE);
                break;
            }
            case 7: {
                if (memaddr * 2 >= VGA.vga.vmemsize) break;
                Memory.host_writew(VGA.vga.mem.linear + memaddr * 2, c & 0xFFFF);
                break;
            }
            case 8: {
                if (memaddr * 4 >= VGA.vga.vmemsize) break;
                Memory.host_writed(VGA.vga.mem.linear + memaddr * 4, c);
                break;
            }
        }
    }

    private static int XGA_GetPoint(int x, int y) {
        int memaddr = y * VGA_xga.XGA_SCREEN_WIDTH() + x;
        switch (VGA_xga.XGA_COLOR_MODE()) {
            case 5: {
                if (memaddr >= VGA.vga.vmemsize) break;
                return Memory.host_readb(VGA.vga.mem.linear + memaddr);
            }
            case 6: 
            case 7: {
                if (memaddr * 2 >= VGA.vga.vmemsize) break;
                return Memory.host_readw(VGA.vga.mem.linear + memaddr * 2);
            }
            case 8: {
                if (memaddr * 4 >= VGA.vga.vmemsize) break;
                return Memory.host_readd(VGA.vga.mem.linear + memaddr * 4);
            }
        }
        return 0;
    }

    private static int XGA_GetMixResult(int mixmode, int srcval, int dstdata) {
        int destval = 0;
        switch (mixmode & 0xF) {
            case 0: {
                destval = ~dstdata;
                break;
            }
            case 1: {
                destval = 0;
                break;
            }
            case 2: {
                destval = -1;
                break;
            }
            case 3: {
                destval = dstdata;
                break;
            }
            case 4: {
                destval = ~srcval;
                break;
            }
            case 5: {
                destval = srcval ^ dstdata;
                break;
            }
            case 6: {
                destval = ~(srcval ^ dstdata);
                break;
            }
            case 7: {
                destval = srcval;
                break;
            }
            case 8: {
                destval = ~(srcval & dstdata);
                break;
            }
            case 9: {
                destval = ~srcval | dstdata;
                break;
            }
            case 10: {
                destval = srcval | ~dstdata;
                break;
            }
            case 11: {
                destval = srcval | dstdata;
                break;
            }
            case 12: {
                destval = srcval & dstdata;
                break;
            }
            case 13: {
                destval = srcval & ~dstdata;
                break;
            }
            case 14: {
                destval = ~srcval & dstdata;
                break;
            }
            case 15: {
                destval = ~(srcval | dstdata);
                break;
            }
            default: {
                Log.log_msg("XGA: GetMixResult: Unknown mix.  Shouldn't be able to get here!");
            }
        }
        return destval;
    }

    private static void XGA_DrawLineVector(int val) {
        int sy;
        int sx;
        int srcval = 0;
        int dx = VGA_xga.xga.MAPcount;
        int xat = VGA_xga.xga.curx;
        int yat = VGA_xga.xga.cury;
        switch (val >> 5 & 7) {
            case 0: {
                sx = 1;
                sy = 0;
                break;
            }
            case 1: {
                sx = 1;
                sy = -1;
                break;
            }
            case 2: {
                sx = 0;
                sy = -1;
                break;
            }
            case 3: {
                sx = -1;
                sy = -1;
                break;
            }
            case 4: {
                sx = -1;
                sy = 0;
                break;
            }
            case 5: {
                sx = -1;
                sy = 1;
                break;
            }
            case 6: {
                sx = 0;
                sy = 1;
                break;
            }
            case 7: {
                sx = 1;
                sy = 1;
                break;
            }
            default: {
                sx = 0;
                sy = 0;
            }
        }
        for (int i = 0; i <= dx; ++i) {
            int mixmode = VGA_xga.xga.pix_cntl >> 6 & 3;
            switch (mixmode) {
                case 0: {
                    mixmode = VGA_xga.xga.foremix;
                    switch (mixmode >> 5 & 3) {
                        case 0: {
                            srcval = VGA_xga.xga.backcolor;
                            break;
                        }
                        case 1: {
                            srcval = VGA_xga.xga.forecolor;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            Log.log_msg("XGA: DrawRect: Wants data from srcdata");
                            break;
                        }
                        default: {
                            Log.log_msg("XGA: DrawRect: Shouldn't be able to get here!");
                        }
                    }
                    int dstdata = VGA_xga.XGA_GetPoint(xat, yat);
                    int destval = VGA_xga.XGA_GetMixResult(mixmode, srcval, dstdata);
                    VGA_xga.XGA_DrawPoint(xat, yat, destval);
                    break;
                }
                default: {
                    Log.log_msg("XGA: DrawLine: Needs mixmode " + Integer.toString(mixmode, 16));
                }
            }
            xat += sx;
            yat += sy;
        }
        VGA_xga.xga.curx = xat - 1;
        VGA_xga.xga.cury = yat;
    }

    private static void XGA_DrawLineBresenham(int val) {
        boolean steep;
        int dmajor;
        int srcval = 0;
        int dminor = VGA_xga.xga.desty;
        if ((VGA_xga.xga.desty & 0x2000) != 0) {
            dminor |= 0xFFFFE000;
        }
        dminor >>= 1;
        int destxtmp = VGA_xga.xga.destx;
        if ((VGA_xga.xga.destx & 0x2000) != 0) {
            destxtmp |= 0xFFFFE000;
        }
        int dx = dmajor = -(destxtmp - (dminor << 1)) >> 1;
        int sx = (val >> 5 & 1) != 0 ? 1 : -1;
        int dy = dminor;
        int sy = (val >> 7 & 1) != 0 ? 1 : -1;
        int e = VGA_xga.xga.ErrTerm;
        if ((VGA_xga.xga.ErrTerm & 0x2000) != 0) {
            e |= 0xFFFFE000;
        }
        int xat = VGA_xga.xga.curx;
        int yat = VGA_xga.xga.cury;
        if ((val >> 6 & 1) != 0) {
            steep = false;
            int t = xat;
            xat = yat;
            yat = t;
            t = sx;
            sx = sy;
            sy = t;
        } else {
            steep = true;
        }
        for (int i = 0; i <= VGA_xga.xga.MAPcount; ++i) {
            int mixmode = VGA_xga.xga.pix_cntl >> 6 & 3;
            switch (mixmode) {
                case 0: {
                    mixmode = VGA_xga.xga.foremix;
                    switch (mixmode >> 5 & 3) {
                        case 0: {
                            srcval = VGA_xga.xga.backcolor;
                            break;
                        }
                        case 1: {
                            srcval = VGA_xga.xga.forecolor;
                            break;
                        }
                        case 2: {
                            Log.log_msg("XGA: DrawRect: Wants data from PIX_TRANS register");
                            break;
                        }
                        case 3: {
                            Log.log_msg("XGA: DrawRect: Wants data from srcdata");
                            break;
                        }
                        default: {
                            Log.log_msg("XGA: DrawRect: Shouldn't be able to get here!");
                        }
                    }
                    int dstdata = steep ? VGA_xga.XGA_GetPoint(xat, yat) : VGA_xga.XGA_GetPoint(yat, xat);
                    int destval = VGA_xga.XGA_GetMixResult(mixmode, srcval, dstdata);
                    if (steep) {
                        VGA_xga.XGA_DrawPoint(xat, yat, destval);
                        break;
                    }
                    VGA_xga.XGA_DrawPoint(yat, xat, destval);
                    break;
                }
                default: {
                    Log.log_msg("XGA: DrawLine: Needs mixmode " + Integer.toString(mixmode, 16));
                }
            }
            while (e > 0) {
                yat += sy;
                e -= dx << 1;
            }
            xat += sx;
            e += dy << 1;
        }
        if (steep) {
            VGA_xga.xga.curx = xat;
            VGA_xga.xga.cury = yat;
        } else {
            VGA_xga.xga.curx = yat;
            VGA_xga.xga.cury = xat;
        }
    }

    private static void XGA_DrawRectangle(int val) {
        int srcval = 0;
        int srcx = 0;
        int dx = -1;
        int dy = -1;
        if ((val >> 5 & 1) != 0) {
            dx = 1;
        }
        if ((val >> 7 & 1) != 0) {
            dy = 1;
        }
        int srcy = VGA_xga.xga.cury;
        for (long yat = 0L; yat <= (long)VGA_xga.xga.MIPcount; ++yat) {
            srcx = VGA_xga.xga.curx;
            for (long xat = 0L; xat <= (long)VGA_xga.xga.MAPcount; ++xat) {
                int mixmode = VGA_xga.xga.pix_cntl >> 6 & 3;
                switch (mixmode) {
                    case 0: {
                        mixmode = VGA_xga.xga.foremix;
                        switch (mixmode >> 5 & 3) {
                            case 0: {
                                srcval = VGA_xga.xga.backcolor;
                                break;
                            }
                            case 1: {
                                srcval = VGA_xga.xga.forecolor;
                                break;
                            }
                            case 2: {
                                Log.log_msg("XGA: DrawRect: Wants data from PIX_TRANS register");
                                break;
                            }
                            case 3: {
                                Log.log_msg("XGA: DrawRect: Wants data from srcdata");
                                break;
                            }
                            default: {
                                Log.log_msg("XGA: DrawRect: Shouldn't be able to get here!");
                            }
                        }
                        int dstdata = VGA_xga.XGA_GetPoint(srcx, srcy);
                        int destval = VGA_xga.XGA_GetMixResult(mixmode, srcval, dstdata);
                        VGA_xga.XGA_DrawPoint(srcx, srcy, destval);
                        break;
                    }
                    default: {
                        Log.log_msg("XGA: DrawRect: Needs mixmode " + Integer.toString(mixmode, 16));
                    }
                }
                srcx += dx;
            }
            srcy += dy;
        }
        VGA_xga.xga.curx = srcx;
        VGA_xga.xga.cury = srcy;
    }

    private static boolean XGA_CheckX() {
        boolean newline = false;
        if (!VGA_xga.xga.waitcmd.newline) {
            if (VGA_xga.xga.waitcmd.curx < 2048 && VGA_xga.xga.waitcmd.curx > VGA_xga.xga.waitcmd.x2) {
                VGA_xga.xga.waitcmd.curx = VGA_xga.xga.waitcmd.x1;
                ++VGA_xga.xga.waitcmd.cury;
                VGA_xga.xga.waitcmd.cury &= 0xFFF;
                newline = true;
                VGA_xga.xga.waitcmd.newline = true;
                if (VGA_xga.xga.waitcmd.cury < 2048 && VGA_xga.xga.waitcmd.cury > VGA_xga.xga.waitcmd.y2) {
                    VGA_xga.xga.waitcmd.wait = false;
                }
            } else if (VGA_xga.xga.waitcmd.curx >= 2048) {
                int realx = 4096 - VGA_xga.xga.waitcmd.curx;
                if (VGA_xga.xga.waitcmd.x2 > 2047) {
                    int realxend = 4096 - VGA_xga.xga.waitcmd.x2;
                    if (realx == realxend) {
                        VGA_xga.xga.waitcmd.curx = VGA_xga.xga.waitcmd.x1;
                        ++VGA_xga.xga.waitcmd.cury;
                        VGA_xga.xga.waitcmd.cury &= 0xFFF;
                        newline = true;
                        VGA_xga.xga.waitcmd.newline = true;
                        if (VGA_xga.xga.waitcmd.cury < 2048 && VGA_xga.xga.waitcmd.cury > VGA_xga.xga.waitcmd.y2) {
                            VGA_xga.xga.waitcmd.wait = false;
                        }
                    }
                } else if (realx == VGA_xga.xga.waitcmd.x2) {
                    VGA_xga.xga.waitcmd.curx = VGA_xga.xga.waitcmd.x1;
                    ++VGA_xga.xga.waitcmd.cury;
                    VGA_xga.xga.waitcmd.cury &= 0xFFF;
                    newline = true;
                    VGA_xga.xga.waitcmd.newline = true;
                    if (VGA_xga.xga.waitcmd.cury < 2048 && VGA_xga.xga.waitcmd.cury > VGA_xga.xga.waitcmd.y2) {
                        VGA_xga.xga.waitcmd.wait = false;
                    }
                }
            }
        } else {
            VGA_xga.xga.waitcmd.newline = false;
        }
        return newline;
    }

    private static void XGA_DrawWaitSub(int mixmode, int srcval) {
        int dstdata = VGA_xga.XGA_GetPoint(VGA_xga.xga.waitcmd.curx, VGA_xga.xga.waitcmd.cury);
        int destval = VGA_xga.XGA_GetMixResult(mixmode, srcval, dstdata);
        VGA_xga.XGA_DrawPoint(VGA_xga.xga.waitcmd.curx, VGA_xga.xga.waitcmd.cury, destval);
        ++VGA_xga.xga.waitcmd.curx;
        VGA_xga.xga.waitcmd.curx &= 0xFFF;
        VGA_xga.XGA_CheckX();
    }

    private static void XGA_DrawWait(int val, int len) {
        if (!VGA_xga.xga.waitcmd.wait) {
            return;
        }
        int mixmode = VGA_xga.xga.pix_cntl >> 6 & 3;
        block0 : switch (VGA_xga.xga.waitcmd.cmd) {
            case 2: {
                switch (mixmode) {
                    case 0: {
                        mixmode = VGA_xga.xga.foremix;
                        if ((mixmode >> 5 & 3) != 2) {
                            Log.log_msg("XGA: unsupported drawwait operation");
                            break;
                        }
                        block7 : switch (VGA_xga.xga.waitcmd.buswidth) {
                            case 5: {
                                VGA_xga.XGA_DrawWaitSub(mixmode, val);
                                break;
                            }
                            case 37: {
                                for (int i = 0; i < len; ++i) {
                                    VGA_xga.XGA_DrawWaitSub(mixmode, val >> 8 * i & 0xFF);
                                    if (VGA_xga.xga.waitcmd.newline) break block7;
                                }
                                break block0;
                            }
                            case 69: {
                                for (int i = 0; i < 4; ++i) {
                                    VGA_xga.XGA_DrawWaitSub(mixmode, val >> 8 * i & 0xFF);
                                }
                                break block0;
                            }
                            case 40: {
                                if (len != 4) {
                                    if (VGA_xga.xga.waitcmd.datasize == 0) {
                                        VGA_xga.xga.waitcmd.data = val;
                                        VGA_xga.xga.waitcmd.datasize = 2;
                                        return;
                                    }
                                    int srcval = (int)((long)(val << 16) | VGA_xga.xga.waitcmd.data);
                                    VGA_xga.xga.waitcmd.data = 0L;
                                    VGA_xga.xga.waitcmd.datasize = 0;
                                    VGA_xga.XGA_DrawWaitSub(mixmode, srcval);
                                    break;
                                }
                            }
                            case 72: {
                                VGA_xga.XGA_DrawWaitSub(mixmode, val);
                                break;
                            }
                            case 38: 
                            case 39: {
                                VGA_xga.XGA_DrawWaitSub(mixmode, val);
                                break;
                            }
                            case 70: 
                            case 71: {
                                VGA_xga.XGA_DrawWaitSub(mixmode, val & 0xFFFF);
                                if (VGA_xga.xga.waitcmd.newline) break block0;
                                VGA_xga.XGA_DrawWaitSub(mixmode, val >> 16);
                                break;
                            }
                            default: {
                                Log.log_msg("XGA: unsupported bpp / datawidth combination " + Integer.toString(VGA_xga.xga.waitcmd.buswidth, 16));
                                break;
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        int chunksize = 0;
                        int chunks = 0;
                        switch (VGA_xga.xga.waitcmd.buswidth & 0x60) {
                            case 0: {
                                chunksize = 8;
                                chunks = 1;
                                break;
                            }
                            case 32: {
                                chunksize = 16;
                                if (len == 4) {
                                    chunks = 2;
                                    break;
                                }
                                chunks = 1;
                                break;
                            }
                            case 64: {
                                chunksize = 16;
                                if (len == 4) {
                                    chunks = 2;
                                    break;
                                }
                                chunks = 1;
                                break;
                            }
                            case 96: {
                                chunksize = 8;
                                chunks = 4;
                            }
                        }
                        block28: for (int k = 0; k < chunks; ++k) {
                            VGA_xga.xga.waitcmd.newline = false;
                            for (int n = 0; n < chunksize; ++n) {
                                int srcval;
                                int mask = 1 << (n & 0xF8) + (8 - (n & 7)) - 1 + chunksize * k;
                                int mixmode1 = (val & mask) != 0 ? VGA_xga.xga.foremix : VGA_xga.xga.backmix;
                                switch (mixmode1 >> 5 & 3) {
                                    case 0: {
                                        srcval = VGA_xga.xga.backcolor;
                                        break;
                                    }
                                    case 1: {
                                        srcval = VGA_xga.xga.forecolor;
                                        break;
                                    }
                                    default: {
                                        Log.log_msg("XGA: DrawBlitWait: Unsupported src " + Integer.toString(mixmode1 >> 5 & 3, 16));
                                        srcval = 0;
                                    }
                                }
                                VGA_xga.XGA_DrawWaitSub(mixmode1, srcval);
                                if (VGA_xga.xga.waitcmd.cury < 2048 && VGA_xga.xga.waitcmd.cury >= VGA_xga.xga.waitcmd.y2) {
                                    VGA_xga.xga.waitcmd.wait = false;
                                    k = 1000;
                                    continue block28;
                                }
                                if (VGA_xga.xga.waitcmd.newline) continue block28;
                            }
                        }
                        break block0;
                    }
                    default: {
                        Log.log_msg("XGA: DrawBlitWait: Unhandled mixmode: " + mixmode);
                        break;
                    }
                }
                break;
            }
            default: {
                Log.log_msg("XGA: Unhandled draw command " + Integer.toString(VGA_xga.xga.waitcmd.cmd, 16));
            }
        }
    }

    private static void XGA_BlitRect(int val) {
        int srcval = 0;
        int dx = -1;
        int dy = -1;
        if ((val >> 5 & 1) != 0) {
            dx = 1;
        }
        if ((val >> 7 & 1) != 0) {
            dy = 1;
        }
        int srcx = VGA_xga.xga.curx;
        int srcy = VGA_xga.xga.cury;
        int tarx = VGA_xga.xga.destx;
        int tary = VGA_xga.xga.desty;
        int mixselect = VGA_xga.xga.pix_cntl >> 6 & 3;
        int mixmode = 103;
        switch (mixselect) {
            case 0: {
                mixmode = VGA_xga.xga.foremix;
                break;
            }
            case 2: {
                Log.log_msg("XGA: DrawPattern: Mixselect data from PIX_TRANS register");
                break;
            }
            case 3: {
                break;
            }
            default: {
                Log.log_msg("XGA: BlitRect: Unknown mix select register");
            }
        }
        for (long yat = 0L; yat <= (long)VGA_xga.xga.MIPcount; ++yat) {
            srcx = VGA_xga.xga.curx;
            tarx = VGA_xga.xga.destx;
            for (long xat = 0L; xat <= (long)VGA_xga.xga.MAPcount; ++xat) {
                int srcdata = VGA_xga.XGA_GetPoint(srcx, srcy);
                int dstdata = VGA_xga.XGA_GetPoint(tarx, tary);
                if (mixselect == 3) {
                    mixmode = srcdata == VGA_xga.xga.forecolor ? VGA_xga.xga.foremix : (srcdata == VGA_xga.xga.backcolor ? VGA_xga.xga.backmix : 103);
                }
                switch (mixmode >> 5 & 3) {
                    case 0: {
                        srcval = VGA_xga.xga.backcolor;
                        break;
                    }
                    case 1: {
                        srcval = VGA_xga.xga.forecolor;
                        break;
                    }
                    case 2: {
                        Log.log_msg("XGA: DrawPattern: Wants data from PIX_TRANS register");
                        break;
                    }
                    case 3: {
                        srcval = srcdata;
                        break;
                    }
                    default: {
                        Log.log_msg("XGA: DrawPattern: Shouldn't be able to get here!");
                        srcval = 0;
                    }
                }
                int destval = VGA_xga.XGA_GetMixResult(mixmode, srcval, dstdata);
                VGA_xga.XGA_DrawPoint(tarx, tary, destval);
                srcx += dx;
                tarx += dx;
            }
            srcy += dy;
            tary += dy;
        }
    }

    private static void XGA_DrawPattern(int val) {
        int srcval = 0;
        int dx = -1;
        int dy = -1;
        if ((val >> 5 & 1) != 0) {
            dx = 1;
        }
        if ((val >> 7 & 1) != 0) {
            dy = 1;
        }
        int srcx = VGA_xga.xga.curx;
        int srcy = VGA_xga.xga.cury;
        int tary = VGA_xga.xga.desty;
        int mixselect = VGA_xga.xga.pix_cntl >> 6 & 3;
        int mixmode = 103;
        switch (mixselect) {
            case 0: {
                mixmode = VGA_xga.xga.foremix;
                break;
            }
            case 2: {
                Log.log_msg("XGA: DrawPattern: Mixselect data from PIX_TRANS register");
                break;
            }
            case 3: {
                break;
            }
            default: {
                Log.log_msg("XGA: DrawPattern: Unknown mix select register");
            }
        }
        for (int yat = 0; yat <= VGA_xga.xga.MIPcount; ++yat) {
            int tarx = VGA_xga.xga.destx;
            for (int xat = 0; xat <= VGA_xga.xga.MAPcount; ++xat) {
                int srcdata = VGA_xga.XGA_GetPoint(srcx + (tarx & 7), srcy + (tary & 7));
                int dstdata = VGA_xga.XGA_GetPoint(tarx, tary);
                if (mixselect == 3) {
                    mixmode = VGA_xga.xga.foremix;
                    if (srcdata == VGA_xga.xga.backcolor || srcdata == 0) {
                        mixmode = VGA_xga.xga.backmix;
                    }
                }
                switch (mixmode >> 5 & 3) {
                    case 0: {
                        srcval = VGA_xga.xga.backcolor;
                        break;
                    }
                    case 1: {
                        srcval = VGA_xga.xga.forecolor;
                        break;
                    }
                    case 2: {
                        Log.log_msg("XGA: DrawPattern: Wants data from PIX_TRANS register");
                        break;
                    }
                    case 3: {
                        srcval = srcdata;
                        break;
                    }
                    default: {
                        Log.log_msg("XGA: DrawPattern: Shouldn't be able to get here!");
                        srcval = 0;
                    }
                }
                int destval = VGA_xga.XGA_GetMixResult(mixmode, srcval, dstdata);
                VGA_xga.XGA_DrawPoint(tarx, tary, destval);
                tarx += dx;
            }
            tary += dy;
        }
    }

    private static void XGA_DrawCmd(int val, int len) {
        int cmd = val >> 13;
        VGA_xga.xga.curcommand = val;
        switch (cmd) {
            case 1: {
                if ((val & 0x100) == 0) {
                    if ((val & 8) == 0) {
                        VGA_xga.XGA_DrawLineBresenham(val);
                        break;
                    }
                    VGA_xga.XGA_DrawLineVector(val);
                    break;
                }
                Log.log_msg("XGA: Wants line drawn from PIX_TRANS register!");
                break;
            }
            case 2: {
                if ((val & 0x100) == 0) {
                    VGA_xga.xga.waitcmd.wait = false;
                    VGA_xga.XGA_DrawRectangle(val);
                    break;
                }
                VGA_xga.xga.waitcmd.newline = true;
                VGA_xga.xga.waitcmd.wait = true;
                VGA_xga.xga.waitcmd.curx = VGA_xga.xga.curx;
                VGA_xga.xga.waitcmd.cury = VGA_xga.xga.cury;
                VGA_xga.xga.waitcmd.x1 = VGA_xga.xga.curx;
                VGA_xga.xga.waitcmd.y1 = VGA_xga.xga.cury;
                VGA_xga.xga.waitcmd.x2 = VGA_xga.xga.curx + VGA_xga.xga.MAPcount & 0xFFF;
                VGA_xga.xga.waitcmd.y2 = VGA_xga.xga.cury + VGA_xga.xga.MIPcount + 1 & 0xFFF;
                VGA_xga.xga.waitcmd.sizex = VGA_xga.xga.MAPcount;
                VGA_xga.xga.waitcmd.sizey = VGA_xga.xga.MIPcount + 1;
                VGA_xga.xga.waitcmd.cmd = 2;
                VGA_xga.xga.waitcmd.buswidth = VGA.vga.mode | (val & 0x600) >> 4;
                VGA_xga.xga.waitcmd.data = 0L;
                VGA_xga.xga.waitcmd.datasize = 0;
                break;
            }
            case 6: {
                VGA_xga.XGA_BlitRect(val);
                break;
            }
            case 7: {
                VGA_xga.XGA_DrawPattern(val);
                break;
            }
            default: {
                Log.log_msg("XGA: Unhandled draw command " + Integer.toString(cmd, 16));
            }
        }
    }

    private static long XGA_SetDualReg(long reg, int val) {
        long result = reg;
        switch (VGA_xga.XGA_COLOR_MODE()) {
            case 5: {
                result = val & 0xFF;
                break;
            }
            case 6: 
            case 7: {
                result = val & 0xFFFF;
                break;
            }
            case 8: {
                result = (VGA_xga.xga.control1 & 0x200) != 0 ? (long)val : ((VGA_xga.xga.control1 & 0x10) != 0 ? result & 0xFFFFL | (long)(val << 16) : result & 0xFFFF0000L | (long)(val & 0xFFFF));
                VGA_xga.xga.control1 ^= 0x10;
            }
        }
        return result;
    }

    private static int XGA_GetDualReg(long reg) {
        switch (VGA_xga.XGA_COLOR_MODE()) {
            case 5: {
                return (int)(reg & 0xFFL);
            }
            case 6: 
            case 7: {
                return (int)(reg & 0xFFFFL);
            }
            case 8: {
                if ((VGA_xga.xga.control1 & 0x200) != 0) {
                    return (int)reg;
                }
                VGA_xga.xga.control1 ^= 0x10;
                if ((VGA_xga.xga.control1 & 0x10) != 0) {
                    return (int)reg & 0xFFFF;
                }
                return (int)(reg >>> 16);
            }
        }
        return 0;
    }

    public static void VGA_SetupXGA() {
        if (!Dosbox.IS_VGA_ARCH()) {
            return;
        }
        xga = new XGAStatus();
        VGA_xga.xga.scissors.y1 = 0;
        VGA_xga.xga.scissors.x1 = 0;
        VGA_xga.xga.scissors.y2 = 4095;
        VGA_xga.xga.scissors.x2 = 4095;
        IoHandler.IO_RegisterWriteHandler(17128, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(17128, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(18152, XGA_Write, 7);
        IoHandler.IO_RegisterWriteHandler(19176, XGA_Write, 7);
        IoHandler.IO_RegisterWriteHandler(33512, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(33512, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(33513, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(33513, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(34536, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(34536, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(34537, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(34537, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(35560, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(35560, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(36584, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(36584, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(36585, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(36585, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(37608, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(37608, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(37609, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(37609, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(38632, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(38632, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(38633, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(38633, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(39656, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(39656, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(39657, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(39657, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(40680, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(40680, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(40681, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(40681, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(41704, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(41704, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(42728, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(42728, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(42729, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(42729, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(43752, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(43752, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(43753, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(43753, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(44776, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(44776, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(44777, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(44777, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(45800, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(45800, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(45801, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(45801, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(46824, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(46824, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(48872, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(48872, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(48873, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(48873, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(47848, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(47848, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(47849, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(47849, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(58088, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(58088, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(58080, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(58080, XGA_Read, 7);
        IoHandler.IO_RegisterWriteHandler(58090, XGA_Write, 7);
        IoHandler.IO_RegisterReadHandler(58090, XGA_Read, 7);
    }

    static {
        XGA_Write = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int len) {
                switch (port) {
                    case 33024: {
                        xga.cury = val & 0xFFF;
                        if (len != 4) break;
                        xga.curx = val >> 16 & 0xFFF;
                        break;
                    }
                    case 33026: {
                        xga.curx = val & 0xFFF;
                        break;
                    }
                    case 33032: {
                        xga.desty = val & 0x3FFF;
                        if (len != 4) break;
                        xga.destx = val >> 16 & 0x3FFF;
                        break;
                    }
                    case 33034: {
                        xga.destx = val & 0x3FFF;
                        break;
                    }
                    case 33040: {
                        xga.ErrTerm = val & 0x3FFF;
                        break;
                    }
                    case 33056: {
                        xga.backcolor = val;
                        break;
                    }
                    case 33060: {
                        xga.forecolor = val;
                        break;
                    }
                    case 33064: {
                        xga.writemask = val;
                        break;
                    }
                    case 33068: {
                        xga.readmask = val;
                        break;
                    }
                    case 33076: {
                        xga.backmix = val & 0xFFFF;
                        if (len != 4) break;
                        xga.foremix = val >> 16;
                        break;
                    }
                    case 33078: {
                        xga.foremix = val;
                        break;
                    }
                    case 33080: {
                        xga.scissors.y1 = val & 0xFFF;
                        if (len != 4) break;
                        xga.scissors.x1 = val >> 16 & 0xFFF;
                        break;
                    }
                    case 33082: {
                        xga.scissors.x1 = val & 0xFFF;
                        break;
                    }
                    case 33084: {
                        xga.scissors.y2 = val & 0xFFF;
                        if (len != 4) break;
                        xga.scissors.x2 = val >> 16 & 0xFFF;
                        break;
                    }
                    case 33086: {
                        xga.scissors.x2 = val & 0xFFF;
                        break;
                    }
                    case 33088: {
                        xga.pix_cntl = val & 0xFFFF;
                        if (len != 4) break;
                        xga.control2 = val >> 16 & 0xFFF;
                        break;
                    }
                    case 33092: {
                        xga.control1 = val & 0xFFFF;
                        if (len != 4) break;
                        xga.read_sel = val >> 16 & 7;
                        break;
                    }
                    case 33096: {
                        xga.MIPcount = val & 0xFFF;
                        if (len != 4) break;
                        xga.MAPcount = val >> 16 & 0xFFF;
                        break;
                    }
                    case 33098: {
                        xga.MAPcount = val & 0xFFF;
                        break;
                    }
                    case 37608: {
                        xga.ErrTerm = val & 0x3FFF;
                        break;
                    }
                    case 38632: {
                        xga.MAPcount = val & 0xFFF;
                        break;
                    }
                    case 33048: 
                    case 39656: {
                        VGA_xga.XGA_DrawCmd(val, len);
                        break;
                    }
                    case 41704: {
                        xga.backcolor = (int)VGA_xga.XGA_SetDualReg(xga.backcolor, val);
                        break;
                    }
                    case 42728: {
                        xga.forecolor = (int)VGA_xga.XGA_SetDualReg(xga.forecolor, val);
                        break;
                    }
                    case 43752: {
                        xga.writemask = (int)VGA_xga.XGA_SetDualReg(xga.writemask, val);
                        break;
                    }
                    case 44776: {
                        xga.readmask = (int)VGA_xga.XGA_SetDualReg(xga.readmask, val);
                        break;
                    }
                    case 33512: {
                        xga.cury = val & 0xFFF;
                        break;
                    }
                    case 34536: {
                        xga.curx = val & 0xFFF;
                        break;
                    }
                    case 35560: {
                        xga.desty = val & 0x3FFF;
                        break;
                    }
                    case 36584: {
                        xga.destx = val & 0x3FFF;
                        break;
                    }
                    case 45800: {
                        Log.log_msg("COLOR_CMP not implemented");
                        break;
                    }
                    case 46824: {
                        xga.backmix = val;
                        break;
                    }
                    case 47848: {
                        xga.foremix = val;
                        break;
                    }
                    case 48872: {
                        VGA_xga.XGA_Write_Multifunc(val, len);
                        break;
                    }
                    case 58088: {
                        xga.waitcmd.newline = false;
                        VGA_xga.XGA_DrawWait(val, len);
                        break;
                    }
                    case 33748: {
                        if (len == 1) {
                            VGA_crtc.vga_write_p3d4.call(0, val, 1);
                            break;
                        }
                        if (len == 2) {
                            VGA_crtc.vga_write_p3d4.call(0, val & 0xFF, 1);
                            VGA_crtc.vga_write_p3d5.call(0, val >> 8, 1);
                            break;
                        }
                        Log.exit("unimplemented XGA MMIO");
                        break;
                    }
                    case 33749: {
                        if (len == 1) {
                            VGA_crtc.vga_write_p3d5.call(0, val, 1);
                            break;
                        }
                        Log.exit("unimplemented XGA MMIO");
                        break;
                    }
                    default: {
                        if (port <= 16384) {
                            xga.waitcmd.newline = false;
                            VGA_xga.XGA_DrawWait(val, len);
                            break;
                        }
                        Log.log_msg("XGA: Wrote to port " + Integer.toString(port, 16) + " with " + Integer.toString(val, 16) + ", len " + Integer.toString(len));
                    }
                }
            }
        };
        XGA_Read = new IoHandler.IO_ReadHandler(){

            public int call(int port, int len) {
                switch (port) {
                    case 33048: 
                    case 39656: {
                        return 1024;
                    }
                    case 33260: {
                        return 28672;
                    }
                    case 33754: {
                        int delaycyc = CPU.CPU_CycleMax / 5000;
                        if (CPU.CPU_Cycles < 3 * delaycyc) {
                            delaycyc = 0;
                        }
                        CPU.CPU_Cycles -= delaycyc;
                        CPU.CPU_IODelayRemoved += delaycyc;
                        return VGA_misc.vga_read_p3da.call(0, 0);
                    }
                    case 33748: {
                        if (len == 1) {
                            return VGA_crtc.vga_read_p3d4.call(0, 0);
                        }
                        Log.exit("unimplemented XGA MMIO");
                        break;
                    }
                    case 33749: {
                        if (len == 1) {
                            return VGA_crtc.vga_read_p3d5.call(0, 0);
                        }
                        Log.exit("unimplemented XGA MMIO");
                        break;
                    }
                    case 39657: {
                        if (xga.waitcmd.wait) {
                            return 4;
                        }
                        return 0;
                    }
                    case 48872: {
                        return VGA_xga.XGA_Read_Multifunc();
                    }
                    case 41704: {
                        return VGA_xga.XGA_GetDualReg(xga.backcolor);
                    }
                    case 42728: {
                        return VGA_xga.XGA_GetDualReg(xga.forecolor);
                    }
                    case 43752: {
                        return VGA_xga.XGA_GetDualReg(xga.writemask);
                    }
                    case 44776: {
                        return VGA_xga.XGA_GetDualReg(xga.readmask);
                    }
                }
                return -1;
            }
        };
    }

    private static class XGAStatus {
        public scissorreg scissors = new scissorreg();
        long readmask;
        long writemask;
        int forecolor;
        int backcolor;
        int curcommand;
        int foremix;
        int backmix;
        int curx;
        int cury;
        int destx;
        int desty;
        int ErrTerm;
        int MIPcount;
        int MAPcount;
        int pix_cntl;
        int control1;
        int control2;
        int read_sel;
        public XGA_WaitCmd waitcmd = new XGA_WaitCmd();

        private XGAStatus() {
        }

        public static class XGA_WaitCmd {
            boolean newline;
            boolean wait;
            int cmd;
            int curx;
            int cury;
            int x1;
            int y1;
            int x2;
            int y2;
            int sizex;
            int sizey;
            long data;
            int datasize;
            int buswidth;
        }

        public static class scissorreg {
            int x1;
            int y1;
            int x2;
            int y2;
        }
    }
}

