/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware.serialport;

import jdos.gui.Main;
import jdos.hardware.Pic;
import jdos.misc.setup.CommandLine;
import jdos.util.FileIO;
import jdos.util.IntRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;

public class Serial {
    private static final boolean SERIAL_DEBUG = false;
    FileIO debugfp;
    boolean dbg_modemcontrol;
    boolean dbg_serialtraffic;
    boolean dbg_register;
    boolean dbg_interrupt;
    boolean dbg_aux;
    boolean InstallationSuccessful;

    public boolean Getchar(ShortRef data, ShortRef lsr, boolean wait_dsr, int timeout) {
        return false;
    }

    public boolean Putchar(short data, boolean wait_dtr, boolean wait_rts, int timeout) {
        return false;
    }

    void log_ser(boolean active, String format) {
        if (active) {
            String buf = StringHelper.format(Pic.PIC_FullIndex(), 3) + " [" + StringHelper.format(Main.GetTicks(), 7) + "] ";
            if (!(buf = buf + format).endsWith("\n")) {
                buf = buf + "\r\n";
            }
            try {
                this.debugfp.write(buf.getBytes());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    static boolean getBituSubstring(String name, IntRef data, CommandLine cmd) {
        String tmpstring = cmd.FindStringBegin(name, false);
        if (tmpstring == null) {
            return false;
        }
        try {
            data.value = Integer.parseInt(tmpstring);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class MyFifo {
        short[] data;
        int maxsize;
        int size;
        int pos;
        int used;

        MyFifo(int maxsize_) {
            this.maxsize = this.size = maxsize_;
            this.used = 0;
            this.pos = 0;
            this.data = new short[this.size];
        }

        int getFree() {
            return this.size - this.used;
        }

        boolean isEmpty() {
            return this.used == 0;
        }

        boolean isFull() {
            return this.size - this.used == 0;
        }

        int getUsage() {
            return this.used;
        }

        void setSize(int newsize) {
            this.size = newsize;
            this.used = 0;
            this.pos = 0;
        }

        void clear() {
            this.used = 0;
            this.pos = 0;
            this.data[0] = 0;
        }

        boolean addb(short _val) {
            int where = this.pos + this.used;
            if (where >= this.size) {
                where -= this.size;
            }
            if (this.used >= this.size) {
                where = where == 0 ? this.size - 1 : --where;
                this.data[where] = _val;
                return false;
            }
            this.data[where] = _val;
            ++this.used;
            return true;
        }

        short getb() {
            if (this.used == 0) {
                return this.data[this.pos];
            }
            int where = this.pos++;
            --this.used;
            if (this.used != 0) {
                // empty if block
            }
            if (this.pos >= this.size) {
                this.pos -= this.size;
            }
            return this.data[where];
        }

        short getTop() {
            int where = this.pos + this.used;
            if (where >= this.size) {
                where -= this.size;
            }
            if (this.used >= this.size) {
                where = where == 0 ? this.size - 1 : --where;
            }
            return this.data[where];
        }

        short probeByte() {
            return this.data[this.pos];
        }
    }
}

