/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos_programs;
import jdos.dos.Dos_tables;
import jdos.hardware.Cmos;
import jdos.hardware.IO;
import jdos.hardware.IoHandler;
import jdos.hardware.Joystick;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.hardware.SBlaster;
import jdos.ints.Bios_disk;
import jdos.ints.Bios_keyboard;
import jdos.ints.Mouse;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.util.IntRef;

public class Bios
extends Module_base {
    public static final int BIOS_BASE_ADDRESS_COM1 = 1024;
    public static final int BIOS_BASE_ADDRESS_COM2 = 1026;
    public static final int BIOS_BASE_ADDRESS_COM3 = 1028;
    public static final int BIOS_BASE_ADDRESS_COM4 = 1030;
    public static final int BIOS_ADDRESS_LPT1 = 1032;
    public static final int BIOS_ADDRESS_LPT2 = 1034;
    public static final int BIOS_ADDRESS_LPT3 = 1036;
    public static final int BIOS_CONFIGURATION = 1040;
    public static final int BIOS_MEMORY_SIZE = 1043;
    public static final int BIOS_TRUE_MEMORY_SIZE = 1045;
    public static final int BIOS_KEYBOARD_STATE = 1047;
    public static final int BIOS_KEYBOARD_FLAGS1 = 1047;
    public static final int BIOS_KEYBOARD_FLAGS2 = 1048;
    public static final int BIOS_KEYBOARD_TOKEN = 1049;
    public static final int BIOS_KEYBOARD_BUFFER_HEAD = 1050;
    public static final int BIOS_KEYBOARD_BUFFER_TAIL = 1052;
    public static final int BIOS_KEYBOARD_BUFFER = 1054;
    public static final int BIOS_DRIVE_ACTIVE = 1086;
    public static final int BIOS_DRIVE_RUNNING = 1087;
    public static final int BIOS_DISK_MOTOR_TIMEOUT = 1088;
    public static final int BIOS_DISK_STATUS = 1089;
    public static final int BIOS_VIDEO_MODE = 1097;
    public static final int BIOS_SCREEN_COLUMNS = 1098;
    public static final int BIOS_VIDEO_MEMORY_USED = 1100;
    public static final int BIOS_VIDEO_MEMORY_ADDRESS = 1102;
    public static final int BIOS_VIDEO_CURSOR_POS = 1104;
    public static final int BIOS_CURSOR_SHAPE = 1120;
    public static final int BIOS_CURSOR_LAST_LINE = 1120;
    public static final int BIOS_CURSOR_FIRST_LINE = 1121;
    public static final int BIOS_CURRENT_SCREEN_PAGE = 1122;
    public static final int BIOS_VIDEO_PORT = 1123;
    public static final int BIOS_VDU_CONTROL = 1125;
    public static final int BIOS_VDU_COLOR_REGISTER = 1126;
    public static final int BIOS_TIMER = 1132;
    public static final int BIOS_24_HOURS_FLAG = 1136;
    public static final int BIOS_KEYBOARD_FLAGS = 1137;
    public static final int BIOS_CTRL_ALT_DEL_FLAG = 1138;
    public static final int BIOS_HARDDISK_COUNT = 1141;
    public static final int BIOS_LPT1_TIMEOUT = 1144;
    public static final int BIOS_LPT2_TIMEOUT = 1145;
    public static final int BIOS_LPT3_TIMEOUT = 1146;
    public static final int BIOS_COM1_TIMEOUT = 1148;
    public static final int BIOS_COM2_TIMEOUT = 1149;
    public static final int BIOS_COM3_TIMEOUT = 1150;
    public static final int BIOS_COM4_TIMEOUT = 1151;
    public static final int BIOS_KEYBOARD_BUFFER_START = 1152;
    public static final int BIOS_KEYBOARD_BUFFER_END = 1154;
    public static final int BIOS_ROWS_ON_SCREEN_MINUS_1 = 1156;
    public static final int BIOS_FONT_HEIGHT = 1157;
    public static final int BIOS_VIDEO_INFO_0 = 1159;
    public static final int BIOS_VIDEO_INFO_1 = 1160;
    public static final int BIOS_VIDEO_INFO_2 = 1161;
    public static final int BIOS_VIDEO_COMBO = 1162;
    public static final int BIOS_KEYBOARD_FLAGS3 = 1174;
    public static final int BIOS_KEYBOARD_LEDS = 1175;
    public static final int BIOS_WAIT_FLAG_POINTER = 1176;
    public static final int BIOS_WAIT_FLAG_COUNT = 1180;
    public static final int BIOS_WAIT_FLAG_ACTIVE = 1184;
    public static final int BIOS_WAIT_FLAG_TEMP = 1185;
    public static final int BIOS_PRINT_SCREEN_FLAG = 1280;
    public static final int BIOS_VIDEO_SAVEPTR = 1192;
    public static final int MAX_SCAN_CODE = 88;
    static int size_extended;
    static int other_memsystems;
    private static Callback.Handler INT70_Handler;
    private static Callback[] tandy_DAC_callback;
    private static Tandy_sb tandy_sb;
    private static Tandy_dac tandy_dac;
    private static Callback.Handler IRQ_TandyDAC;
    private static Callback.Handler INT1A_Handler;
    private static Callback.Handler INT11_Handler;
    private static Callback.Handler INT8_Handler;
    private static Callback.Handler INT1C_Handler;
    private static Callback.Handler INT12_Handler;
    private static Callback.Handler INT17_Handler;
    private static Callback.Handler INT14_Handler;
    private static int biosConfigSeg;
    private static boolean apm_realmode_connected;
    private static Callback.Handler INT15_Handler;
    private static Callback.Handler Reboot_Handler;
    private Callback[] callback = new Callback[11];
    static Bios test;
    public static Section.SectionFunction BIOS_Destroy;
    public static Section.SectionFunction BIOS_Init;

    public static int BIOS_DEFAULT_HANDLER_LOCATION() {
        return Memory.RealMake(61440, 65363);
    }

    public static int BIOS_DEFAULT_IRQ0_LOCATION() {
        return Memory.RealMake(61440, 65189);
    }

    public static int BIOS_DEFAULT_IRQ1_LOCATION() {
        return Memory.RealMake(61440, 59783);
    }

    public static int BIOS_DEFAULT_IRQ2_LOCATION() {
        return Memory.RealMake(61440, 65365);
    }

    private static boolean Tandy_InitializeSB() {
        IntRef sbport = new IntRef(0);
        IntRef sbirq = new IntRef(0);
        IntRef sbdma = new IntRef(0);
        if (SBlaster.SB_Get_Address(sbport, sbirq, sbdma)) {
            Bios.tandy_sb.port = sbport.value & 0xFFFF;
            Bios.tandy_sb.irq = (short)(sbirq.value & 0xFF);
            Bios.tandy_sb.dma = (short)(sbdma.value & 0xFF);
            return true;
        }
        Bios.tandy_sb.port = 0;
        return false;
    }

    private static boolean Tandy_InitializeTS() {
        Bios.tandy_dac.port = 0;
        return false;
    }

    private static boolean Tandy_TransferInProgress() {
        if (Memory.real_readw(64, 208) != 0) {
            return true;
        }
        if (Memory.real_readb(64, 212) == 255) {
            return false;
        }
        short tandy_dma = 1;
        if (Bios.tandy_sb.port != 0) {
            tandy_dma = Bios.tandy_sb.dma;
        } else if (Bios.tandy_dac.port != 0) {
            tandy_dma = Bios.tandy_dac.dma;
        }
        IoHandler.IO_Write(12, 0);
        int datalen = IO.IO_ReadB(tandy_dma * 2 + 1) & 0xFF;
        if ((datalen |= IO.IO_ReadB(tandy_dma * 2 + 1) << 8) == 65535) {
            return false;
        }
        return datalen >= 16 || Memory.real_readb(64, 212) != 15 || Memory.real_readw(64, 210) != 28;
    }

    private static void Tandy_SetupTransfer(int bufpt, boolean isplayback) {
        int length = Memory.real_readw(64, 208);
        if (length == 0) {
            return;
        }
        if (Bios.tandy_sb.port == 0 && Bios.tandy_dac.port == 0) {
            return;
        }
        int tandy_irq = 7;
        if (Bios.tandy_sb.port != 0) {
            tandy_irq = Bios.tandy_sb.irq;
        } else if (Bios.tandy_dac.port != 0) {
            tandy_irq = Bios.tandy_dac.irq;
        }
        int tandy_irq_vector = tandy_irq;
        tandy_irq_vector = tandy_irq_vector < 8 ? (int)((short)(tandy_irq_vector + 8)) : (int)((short)(tandy_irq_vector + 104));
        int current_irq = Memory.RealGetVec(tandy_irq_vector);
        if (current_irq != tandy_DAC_callback[0].Get_RealPointer()) {
            Memory.real_writed(64, 214, current_irq);
            Memory.RealSetVec(tandy_irq_vector, tandy_DAC_callback[0].Get_RealPointer());
        }
        short tandy_dma = 1;
        if (Bios.tandy_sb.port != 0) {
            tandy_dma = Bios.tandy_sb.dma;
        } else if (Bios.tandy_dac.port != 0) {
            tandy_dma = Bios.tandy_dac.dma;
        }
        if (Bios.tandy_sb.port != 0) {
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, 208);
            IoHandler.IO_Write(33, IoHandler.IO_Read(33) & ~(1 << tandy_irq));
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, 209);
        } else {
            IoHandler.IO_Write(Bios.tandy_dac.port, IoHandler.IO_Read(Bios.tandy_dac.port) & 0x60);
            IoHandler.IO_Write(33, IoHandler.IO_Read(33) & ~(1 << tandy_irq));
        }
        IoHandler.IO_Write(10, 4 | tandy_dma);
        IoHandler.IO_Write(12, 0);
        if (isplayback) {
            IoHandler.IO_Write(11, 0x48 | tandy_dma);
        } else {
            IoHandler.IO_Write(11, 0x44 | tandy_dma);
        }
        short bufpage = (short)(bufpt >> 16 & 0xFF);
        IoHandler.IO_Write(tandy_dma * 2, (short)(bufpt & 0xFF));
        IoHandler.IO_Write(tandy_dma * 2, (short)(bufpt >> 8 & 0xFF));
        switch (tandy_dma) {
            case 0: {
                IoHandler.IO_Write(135, bufpage);
                break;
            }
            case 1: {
                IoHandler.IO_Write(131, bufpage);
                break;
            }
            case 2: {
                IoHandler.IO_Write(129, bufpage);
                break;
            }
            case 3: {
                IoHandler.IO_Write(130, bufpage);
            }
        }
        Memory.real_writeb(64, 212, bufpage);
        long tlength = length;
        if (tlength + (long)(bufpt & 0xFFFF) > 65536L) {
            tlength = 65536 - (bufpt & 0xFFFF);
        }
        Memory.real_writew(64, 208, (int)((long)length - tlength));
        IoHandler.IO_Write(tandy_dma * 2 + 1, (short)(--tlength & 0xFFL));
        IoHandler.IO_Write(tandy_dma * 2 + 1, (short)(tlength >> 8 & 0xFFL));
        int delay = Memory.real_readw(64, 210) & 0xFFF;
        short amplitude = (short)(Memory.real_readw(64, 210) >> 13 & 7);
        if (Bios.tandy_sb.port != 0) {
            IoHandler.IO_Write(10, tandy_dma);
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, 64);
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, 256 - delay * 100 / 358);
            if (isplayback) {
                IoHandler.IO_Write(Bios.tandy_sb.port + 12, 20);
            } else {
                IoHandler.IO_Write(Bios.tandy_sb.port + 12, 36);
            }
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, (short)(tlength & 0xFFL));
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, (short)(tlength >> 8 & 0xFFL));
        } else {
            if (isplayback) {
                IoHandler.IO_Write(Bios.tandy_dac.port, IoHandler.IO_Read(Bios.tandy_dac.port) & 0x7C | 3);
            } else {
                IoHandler.IO_Write(Bios.tandy_dac.port, IoHandler.IO_Read(Bios.tandy_dac.port) & 0x7C | 2);
            }
            IoHandler.IO_Write(Bios.tandy_dac.port + 2, (short)(delay & 0xFF));
            IoHandler.IO_Write(Bios.tandy_dac.port + 3, (short)(delay >> 8 & 0xF | amplitude << 5));
            if (isplayback) {
                IoHandler.IO_Write(Bios.tandy_dac.port, IoHandler.IO_Read(Bios.tandy_dac.port) & 0x7C | 0x1F);
            } else {
                IoHandler.IO_Write(Bios.tandy_dac.port, IoHandler.IO_Read(Bios.tandy_dac.port) & 0x7C | 0x1E);
            }
            IoHandler.IO_Write(10, tandy_dma);
        }
        if (!isplayback) {
            Memory.real_writew(64, 210, delay | 0x1000);
        }
    }

    static void TandyDAC_Handler(short tfunction) {
        if (Bios.tandy_sb.port == 0 && Bios.tandy_dac.port == 0) {
            return;
        }
        switch (tfunction) {
            case 129: {
                if (Bios.tandy_dac.port != 0) {
                    CPU_Regs.reg_eax.word(Bios.tandy_dac.port);
                } else {
                    CPU_Regs.reg_eax.word(196);
                }
                Callback.CALLBACK_SCF(Bios.Tandy_TransferInProgress());
                break;
            }
            case 130: 
            case 131: {
                if (Bios.Tandy_TransferInProgress()) {
                    CPU_Regs.reg_eax.high(0);
                    Callback.CALLBACK_SCF(true);
                    break;
                }
                Memory.real_writew(64, 208, CPU_Regs.reg_ecx.word());
                Memory.real_writew(64, 210, CPU_Regs.reg_edx.word() & 0xFFF | (CPU_Regs.reg_eax.low() & 7) << 13);
                Bios.Tandy_SetupTransfer(Memory.PhysMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word()), CPU_Regs.reg_eax.high() == 131);
                CPU_Regs.reg_eax.high(0);
                Callback.CALLBACK_SCF(false);
                break;
            }
            case 132: {
                CPU_Regs.reg_eax.high(0);
                Memory.real_writew(64, 208, 10);
                Memory.real_writew(64, 210, 28);
                Bios.Tandy_SetupTransfer(Memory.PhysMake(61440, 41092), true);
                Callback.CALLBACK_SCF(false);
                break;
            }
            case 133: {
                if (Bios.tandy_dac.port != 0) {
                    IoHandler.IO_Write(Bios.tandy_dac.port, (short)(IoHandler.IO_Read(Bios.tandy_dac.port) & 0xE0));
                }
                CPU_Regs.reg_eax.high(0);
                Callback.CALLBACK_SCF(false);
            }
        }
    }

    private static boolean INT14_Wait(int port, short mask, short timeout, IntRef retval) {
        double starttime = Pic.PIC_FullIndex();
        double timeout_f = (double)timeout * 1000.0;
        while (((retval.value = IO.IO_ReadB(port)) & mask) != mask) {
            if (starttime < Pic.PIC_FullIndex() - timeout_f) {
                return false;
            }
            Callback.CALLBACK_Idle();
        }
        return true;
    }

    public static void BIOS_ZeroExtendedSize(boolean in) {
        other_memsystems = in ? ++other_memsystems : --other_memsystems;
        if (other_memsystems < 0) {
            other_memsystems = 0;
        }
    }

    public Bios(Section configuration) {
        super(configuration);
        for (int i = 0; i < this.callback.length; ++i) {
            this.callback[i] = new Callback();
        }
        boolean use_tandyDAC = Memory.real_readb(64, 212) == 255;
        for (int i = 0; i < 512; ++i) {
            Memory.real_writeb(64, i, 0);
        }
        int call_irq0 = Callback.CALLBACK_Allocate();
        Callback.CALLBACK_Setup(call_irq0, INT8_Handler, 7, Memory.Real2Phys(Bios.BIOS_DEFAULT_IRQ0_LOCATION()), "IRQ 0 Clock");
        Memory.RealSetVec(8, Bios.BIOS_DEFAULT_IRQ0_LOCATION());
        Memory.mem_writed(1132, 0);
        this.callback[1].Install(INT11_Handler, 3, "Int 11 Equipment");
        this.callback[1].Set_RealVec(17);
        this.callback[2].Install(INT12_Handler, 3, "Int 12 Memory");
        this.callback[2].Set_RealVec(18);
        if (Dosbox.IS_TANDY_ARCH()) {
            if (Dosbox.machine == 2) {
                Memory.mem_writew(1043, 624);
            } else {
                Memory.mem_writew(1043, 640);
            }
            Memory.mem_writew(1045, 640);
        } else {
            Memory.mem_writew(1043, 640);
        }
        Bios_disk.BIOS_SetupDisks();
        this.callback[3].Install(INT14_Handler, 5, "Int 14 COM-port");
        this.callback[3].Set_RealVec(20);
        this.callback[4].Install(INT15_Handler, 3, "Int 15 Bios");
        this.callback[4].Set_RealVec(21);
        Bios_keyboard.BIOS_SetupKeyboard();
        this.callback[5].Install(INT17_Handler, 5, "Int 17 Printer");
        this.callback[5].Set_RealVec(23);
        this.callback[6].Install(INT1A_Handler, 5, "Int 1a Time");
        this.callback[6].Set_RealVec(26);
        this.callback[7].Install(INT1C_Handler, 3, "Int 1c Timer");
        this.callback[7].Set_RealVec(28);
        this.callback[8].Install(INT70_Handler, 3, "Int 70 RTC");
        this.callback[8].Set_RealVec(112);
        this.callback[9].Install(null, 9, "irq 9 bios");
        this.callback[9].Set_RealVec(113);
        this.callback[10].Install(Reboot_Handler, 3, "reboot");
        this.callback[10].Set_RealVec(24);
        int rptr = this.callback[10].Get_RealPointer();
        Memory.RealSetVec(25, rptr);
        Memory.phys_writeb(1048560, 234);
        Memory.phys_writew(1048561, Memory.RealOff(rptr));
        Memory.phys_writew(1048563, Memory.RealSeg(rptr));
        int call_irq2 = Callback.CALLBACK_Allocate();
        Callback.CALLBACK_Setup(call_irq2, null, 6, Memory.Real2Phys(Bios.BIOS_DEFAULT_IRQ2_LOCATION()), "irq 2 bios");
        Memory.RealSetVec(10, Bios.BIOS_DEFAULT_IRQ2_LOCATION());
        Memory.phys_writeb(Memory.Real2Phys(Bios.BIOS_DEFAULT_HANDLER_LOCATION()), 207);
        Memory.phys_writew(Memory.Real2Phys(Memory.RealGetVec(18)) + 18, 32);
        if (Dosbox.machine == 2) {
            Memory.phys_writeb(1048574, 255);
        } else if (Dosbox.machine == 3) {
            Memory.phys_writeb(1048574, 253);
        } else {
            Memory.phys_writeb(1048574, 252);
        }
        byte[] b_type = "IBM COMPATIBLE 486 BIOS COPYRIGHT The DOSBox Team.".getBytes();
        for (int i = 0; i < b_type.length; ++i) {
            Memory.phys_writeb(1040398 + i, b_type[i]);
        }
        byte[] b_vers = "DOSBox FakeBIOS v1.0".getBytes();
        for (int i = 0; i < b_vers.length; ++i) {
            Memory.phys_writeb(1040481 + i, b_vers[i]);
        }
        byte[] b_date = "01/01/92".getBytes();
        for (int i = 0; i < b_date.length; ++i) {
            Memory.phys_writeb(1048565 + i, b_date[i]);
        }
        Memory.phys_writeb(1048575, 85);
        Bios.tandy_sb.port = 0;
        Bios.tandy_dac.port = 0;
        if (use_tandyDAC) {
            int tandy_dac_type = 0;
            if (Bios.Tandy_InitializeSB()) {
                tandy_dac_type = 1;
            } else if (Bios.Tandy_InitializeTS()) {
                tandy_dac_type = 2;
            }
            if (tandy_dac_type != 0) {
                Memory.real_writew(64, 208, 0);
                Memory.real_writew(64, 210, 0);
                Memory.real_writeb(64, 212, 255);
                Memory.real_writed(64, 214, 0);
                Bios.tandy_DAC_callback[0] = new Callback();
                Bios.tandy_DAC_callback[1] = new Callback();
                tandy_DAC_callback[0].Install(IRQ_TandyDAC, 3, "Tandy DAC IRQ");
                tandy_DAC_callback[1].Install(null, 17, "Tandy DAC end transfer");
                int tandy_irq = 7;
                if (tandy_dac_type == 1) {
                    tandy_irq = Bios.tandy_sb.irq;
                } else if (tandy_dac_type == 2) {
                    tandy_irq = Bios.tandy_dac.irq;
                }
                int tandy_irq_vector = tandy_irq;
                tandy_irq_vector = tandy_irq_vector < 8 ? (int)((short)(tandy_irq_vector + 8)) : (int)((short)(tandy_irq_vector + 104));
                int current_irq = Memory.RealGetVec(tandy_irq_vector);
                Memory.real_writed(64, 214, current_irq);
                for (int i = 0; i < 16; ++i) {
                    Memory.phys_writeb(Memory.PhysMake(61440, 41092 + i), 128);
                }
            } else {
                Memory.real_writeb(64, 212, 0);
            }
        }
        Memory.mem_writeb(1144, 1);
        Memory.mem_writeb(1145, 1);
        Memory.mem_writeb(1146, 1);
        Memory.mem_writeb(1148, 1);
        Memory.mem_writeb(1149, 1);
        Memory.mem_writeb(1150, 1);
        Memory.mem_writeb(1151, 1);
        int ppindex = 0;
        if (IoHandler.IO_Read(888) != 255 | IoHandler.IO_Read(889) != 255) {
            Memory.mem_writew(1032, 888);
            ++ppindex;
            if (IoHandler.IO_Read(632) != 255 | IoHandler.IO_Read(633) != 255) {
                Memory.mem_writew(1034, 632);
                ++ppindex;
                if (IoHandler.IO_Read(956) != 255 | IoHandler.IO_Read(958) != 255) {
                    Memory.mem_writew(1036, 956);
                    ++ppindex;
                }
            } else if (IoHandler.IO_Read(956) != 255 | IoHandler.IO_Read(958) != 255) {
                Memory.mem_writew(1034, 956);
                ++ppindex;
            }
        } else if (IoHandler.IO_Read(956) != 255 | IoHandler.IO_Read(958) != 255) {
            Memory.mem_writew(1032, 956);
            ++ppindex;
            if (IoHandler.IO_Read(632) != 255 | IoHandler.IO_Read(633) != 255) {
                Memory.mem_writew(1034, 632);
                ++ppindex;
            }
        } else if (IoHandler.IO_Read(632) != 255 | IoHandler.IO_Read(633) != 255) {
            Memory.mem_writew(1032, 632);
            ++ppindex;
        }
        int config = 0;
        config = ppindex == 2 ? (config |= 0x4000) : (config |= 0xC000);
        config |= 2;
        switch (Dosbox.machine) {
            case 0: {
                config |= 0x30;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                config |= 0x20;
                break;
            }
            default: {
                config |= 0;
            }
        }
        config |= 4;
        Memory.mem_writew(1040, config |= 0x1000);
        Cmos.CMOS_SetRegister(20, (short)(config & 0xFF));
        IoHandler.IO_Write(112, 48);
        size_extended = IoHandler.IO_Read(113);
        IoHandler.IO_Write(112, 49);
        size_extended |= IoHandler.IO_Read(113) << 8;
    }

    private void destroy() {
        if (Bios.tandy_sb.port != 0) {
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, 211);
            IoHandler.IO_Write(Bios.tandy_sb.port + 12, 208);
        }
        Memory.real_writeb(64, 212, 0);
        if (tandy_DAC_callback[0] != null) {
            long orig_vector = Memory.real_readd(64, 214);
            if (orig_vector == (long)tandy_DAC_callback[0].Get_RealPointer()) {
                int tandy_irq = 7;
                if (Bios.tandy_sb.port != 0) {
                    tandy_irq = Bios.tandy_sb.irq;
                } else if (Bios.tandy_dac.port != 0) {
                    tandy_irq = Bios.tandy_dac.irq;
                }
                int tandy_irq_vector = tandy_irq;
                tandy_irq_vector = tandy_irq_vector < 8 ? (int)((short)(tandy_irq_vector + 8)) : (int)((short)(tandy_irq_vector + 104));
                Memory.RealSetVec(tandy_irq_vector, Memory.real_readd(64, 214));
                Memory.real_writed(64, 214, 0);
            }
            Bios.tandy_DAC_callback[0] = null;
            Bios.tandy_DAC_callback[1] = null;
        }
        Bios_disk.BIOS_CloseDisks();
    }

    public static void BIOS_SetComPorts(int[] baseaddr) {
        int portcount = 0;
        for (int i = 0; i < 4; ++i) {
            if (baseaddr[i] != 0) {
                ++portcount;
            }
            if (i == 0) {
                Memory.mem_writew(1024, baseaddr[i]);
                continue;
            }
            if (i == 1) {
                Memory.mem_writew(1026, baseaddr[i]);
                continue;
            }
            if (i == 2) {
                Memory.mem_writew(1028, baseaddr[i]);
                continue;
            }
            Memory.mem_writew(1030, baseaddr[i]);
        }
        int equipmentword = Memory.mem_readw(1040);
        equipmentword &= 0xFFFFF1FF;
        Memory.mem_writew(1040, equipmentword |= portcount << 9);
        Cmos.CMOS_SetRegister(20, (short)(equipmentword & 0xFF));
    }

    static {
        other_memsystems = 0;
        INT70_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT70_Handler";
            }

            public int call() {
                IoHandler.IO_Write(112, 12);
                IoHandler.IO_Read(113);
                if (Memory.mem_readb(1184) != 0) {
                    long count = (long)Memory.mem_readd(1180) & 0xFFFFFFFFL;
                    if (count > 997L) {
                        Memory.mem_writed(1180, (int)count - 997);
                    } else {
                        Memory.mem_writed(1180, 0);
                        int where = Memory.Real2Phys(Memory.mem_readd(1176));
                        Memory.mem_writeb(where, (short)(Memory.mem_readb(where) | 0x80));
                        Memory.mem_writeb(1184, 0);
                        Memory.mem_writed(1176, Memory.RealMake(0, 1185));
                        IoHandler.IO_Write(112, 11);
                        IoHandler.IO_Write(113, IoHandler.IO_Read(113) & 0xFFFFFFBF);
                    }
                }
                IoHandler.IO_Write(160, 32);
                IoHandler.IO_Write(32, 32);
                return 0;
            }
        };
        tandy_DAC_callback = new Callback[2];
        IRQ_TandyDAC = new Callback.Handler(){

            public String getName() {
                return "Bios.IRQ_TandyDAC";
            }

            public int call() {
                if (tandy_dac.port != 0) {
                    IoHandler.IO_Read(tandy_dac.port);
                }
                if (Memory.real_readw(64, 208) != 0) {
                    IoHandler.IO_Write(32, 32);
                    if (tandy_sb.port != 0) {
                        IoHandler.IO_Read(tandy_sb.port + 14);
                    }
                    short npage = (short)(Memory.real_readb(64, 212) + 1);
                    Memory.real_writeb(64, 212, npage);
                    short rb = Memory.real_readb(64, 211);
                    if ((rb & 0x10) != 0) {
                        Memory.real_writeb(64, 211, rb & 0xEF);
                        Bios.Tandy_SetupTransfer(npage << 16, false);
                    } else {
                        Bios.Tandy_SetupTransfer(npage << 16, true);
                    }
                } else {
                    int tandy_irq = 7;
                    if (tandy_sb.port != 0) {
                        tandy_irq = tandy_sb.irq;
                    } else if (tandy_dac.port != 0) {
                        tandy_irq = tandy_dac.irq;
                    }
                    int tandy_irq_vector = tandy_irq;
                    tandy_irq_vector = tandy_irq_vector < 8 ? (int)((short)(tandy_irq_vector + 8)) : (int)((short)(tandy_irq_vector + 104));
                    Memory.RealSetVec(tandy_irq_vector, Memory.real_readd(64, 214));
                    if (tandy_sb.port != 0) {
                        IoHandler.IO_Write(tandy_sb.port + 12, 211);
                        IoHandler.IO_Read(tandy_sb.port + 14);
                    }
                    CPU_Regs.SegSet16CS(Memory.RealSeg(tandy_DAC_callback[1].Get_RealPointer()));
                    CPU_Regs.reg_ip((short)Memory.RealOff(tandy_DAC_callback[1].Get_RealPointer()));
                }
                return 0;
            }
        };
        INT1A_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT1A_Handler";
            }

            public int call() {
                switch (CPU_Regs.reg_eax.high() & 0xFF) {
                    case 0: {
                        int ticks = Memory.mem_readd(1132);
                        CPU_Regs.reg_eax.low(0);
                        CPU_Regs.reg_ecx.word(ticks >> 16);
                        CPU_Regs.reg_edx.word(ticks & 0xFFFF);
                        break;
                    }
                    case 1: {
                        Memory.mem_writed(1132, CPU_Regs.reg_ecx.word() << 16 | CPU_Regs.reg_edx.word());
                        break;
                    }
                    case 2: {
                        IoHandler.IO_Write(112, 4);
                        CPU_Regs.reg_ecx.high(IoHandler.IO_Read(113));
                        IoHandler.IO_Write(112, 2);
                        CPU_Regs.reg_ecx.low(IoHandler.IO_Read(113));
                        IoHandler.IO_Write(112, 0);
                        CPU_Regs.reg_edx.high(IoHandler.IO_Read(113));
                        CPU_Regs.reg_edx.low(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 4: {
                        IoHandler.IO_Write(112, 50);
                        CPU_Regs.reg_ecx.high(IoHandler.IO_Read(113));
                        IoHandler.IO_Write(112, 9);
                        CPU_Regs.reg_ecx.low(IoHandler.IO_Read(113));
                        IoHandler.IO_Write(112, 8);
                        CPU_Regs.reg_edx.high(IoHandler.IO_Read(113));
                        IoHandler.IO_Write(112, 7);
                        CPU_Regs.reg_edx.low(IoHandler.IO_Read(113));
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 128: {
                        Log.log(19, 2, "INT1A:80:Setup tandy sound multiplexer to " + Integer.toString(CPU_Regs.reg_eax.low()));
                        break;
                    }
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: {
                        Bios.TandyDAC_Handler(CPU_Regs.reg_eax.high());
                        break;
                    }
                    case 177: {
                        Log.log(19, 2, "INT1A:PCI bios call " + Integer.toString(CPU_Regs.reg_eax.low(), 16));
                        Callback.CALLBACK_SCF(true);
                        break;
                    }
                    default: {
                        Log.log(19, 2, "INT1A:Undefined call " + Integer.toString(CPU_Regs.reg_eax.high(), 16));
                    }
                }
                return 0;
            }
        };
        INT11_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT11_Handler";
            }

            public int call() {
                CPU_Regs.reg_eax.word(Memory.mem_readw(1040));
                return 0;
            }
        };
        INT8_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT8_Handler";
            }

            public int call() {
                int value = Memory.mem_readd(1132) + 1;
                Memory.mem_writed(1132, value);
                short val = Memory.mem_readb(1088);
                if (val != 0) {
                    Memory.mem_writeb(1088, (short)(val - 1));
                }
                Memory.mem_writeb(1087, Memory.mem_readb(1087) & 0xF0);
                return 0;
            }
        };
        INT1C_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT1C_Handler";
            }

            public int call() {
                return 0;
            }
        };
        INT12_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT12_Handler";
            }

            public int call() {
                CPU_Regs.reg_eax.word(Memory.mem_readw(1043));
                return 0;
            }
        };
        INT17_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT17_Handler";
            }

            public int call() {
                switch (CPU_Regs.reg_eax.high()) {
                    case 0: {
                        CPU_Regs.reg_eax.high(1);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 32: {
                        break;
                    }
                    default: {
                        Log.exit("Unhandled INT 17 call " + Integer.toString(CPU_Regs.reg_eax.high(), 16));
                    }
                }
                return 0;
            }
        };
        INT14_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT14_Handler";
            }

            public int call() {
                if (CPU_Regs.reg_eax.high() > 3 || CPU_Regs.reg_edx.word() > 3) {
                    Log.log_msg("BIOS INT14: Unhandled call AH=" + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " DX=" + Integer.toString(CPU_Regs.reg_edx.word(), 16));
                    return 0;
                }
                int port = Memory.real_readw(64, CPU_Regs.reg_edx.word() * 2);
                short timeout = Memory.mem_readb(1148 + CPU_Regs.reg_edx.word());
                if (port == 0) {
                    return 0;
                }
                switch (CPU_Regs.reg_eax.high()) {
                    case 0: {
                        int baudrate = 9600;
                        int rawbaud = CPU_Regs.reg_eax.low() >> 5;
                        if (rawbaud == 0) {
                            baudrate = 110;
                        } else if (rawbaud == 1) {
                            baudrate = 150;
                        } else if (rawbaud == 2) {
                            baudrate = 300;
                        } else if (rawbaud == 3) {
                            baudrate = 600;
                        } else if (rawbaud == 4) {
                            baudrate = 1200;
                        } else if (rawbaud == 5) {
                            baudrate = 2400;
                        } else if (rawbaud == 6) {
                            baudrate = 4800;
                        } else if (rawbaud == 7) {
                            baudrate = 9600;
                        }
                        int baudresult = 115200 / baudrate;
                        IO.IO_WriteB(port + 3, 128);
                        IO.IO_WriteB(port, (short)baudresult & 0xFF);
                        IO.IO_WriteB(port + 1, (short)(baudresult >> 8));
                        IO.IO_WriteB(port + 3, CPU_Regs.reg_eax.low() & 0x1F);
                        IO.IO_WriteB(port + 1, 0);
                        CPU_Regs.reg_eax.high(IO.IO_ReadB(port + 5) & 0xFF);
                        CPU_Regs.reg_eax.low(IO.IO_ReadB(port + 6) & 0xFF);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 1: {
                        IO.IO_WriteB(port + 4, 3);
                        IntRef result = new IntRef(CPU_Regs.reg_eax.high());
                        if (Bios.INT14_Wait(port + 6, (short)48, timeout, result)) {
                            if (Bios.INT14_Wait(port + 5, (short)32, timeout, result)) {
                                CPU_Regs.reg_eax.high(result.value);
                                IO.IO_WriteB(port, CPU_Regs.reg_eax.low());
                            } else {
                                CPU_Regs.reg_eax.high(result.value |= 0x80);
                            }
                        } else {
                            CPU_Regs.reg_eax.high(result.value |= 0x80);
                        }
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 2: {
                        IO.IO_WriteB(port + 4, 1);
                        IntRef result = new IntRef(CPU_Regs.reg_eax.high());
                        if (Bios.INT14_Wait(port + 6, (short)32, timeout, result)) {
                            if (Bios.INT14_Wait(port + 5, (short)1, timeout, result)) {
                                CPU_Regs.reg_eax.high(result.value & 0x1E);
                                CPU_Regs.reg_eax.low(IO.IO_ReadB(port));
                            } else {
                                CPU_Regs.reg_eax.high(result.value |= 0x80);
                            }
                        } else {
                            CPU_Regs.reg_eax.high(result.value |= 0x80);
                        }
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 3: {
                        CPU_Regs.reg_eax.high(IO.IO_ReadB(port + 5) & 0xFF);
                        CPU_Regs.reg_eax.low(IO.IO_ReadB(port + 6) & 0xFF);
                        Callback.CALLBACK_SCF(false);
                    }
                }
                return 0;
            }
        };
        biosConfigSeg = 0;
        apm_realmode_connected = false;
        INT15_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT15_Handler";
            }

            public int call() {
                block0 : switch (CPU_Regs.reg_eax.high() & 0xFF) {
                    case 6: {
                        Log.log(19, 0, "INT15 Unkown Function 6");
                        break;
                    }
                    case 192: {
                        if (biosConfigSeg == 0) {
                            biosConfigSeg = Dos_tables.DOS_GetMemory(1);
                        }
                        int data = Memory.PhysMake(biosConfigSeg, 0);
                        Memory.mem_writew(data, 8);
                        if (Dosbox.IS_TANDY_ARCH()) {
                            if (Dosbox.machine == 2) {
                                Memory.mem_writeb(data + 2, 255);
                            } else {
                                Memory.mem_writeb(data + 2, 253);
                            }
                            Memory.mem_writeb(data + 3, 10);
                            Memory.mem_writeb(data + 4, 16);
                            Memory.mem_writeb(data + 5, 112);
                        } else {
                            Memory.mem_writeb(data + 2, 252);
                            Memory.mem_writeb(data + 3, 0);
                            Memory.mem_writeb(data + 4, 1);
                            Memory.mem_writeb(data + 5, 112);
                        }
                        Memory.mem_writeb(data + 6, 64);
                        Memory.mem_writeb(data + 7, 0);
                        Memory.mem_writeb(data + 8, 0);
                        Memory.mem_writeb(data + 9, 0);
                        CPU.CPU_SetSegGeneralES(biosConfigSeg);
                        CPU_Regs.reg_ebx.word(0);
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 79: {
                        Callback.CALLBACK_SCF(true);
                        break;
                    }
                    case 131: {
                        if (CPU_Regs.reg_eax.low() == 1) {
                            Memory.mem_writeb(1184, 0);
                            IoHandler.IO_Write(112, 11);
                            IoHandler.IO_Write(113, IoHandler.IO_Read(113) & 0xFFFFFFBF);
                            Callback.CALLBACK_SCF(false);
                            break;
                        }
                        if (Memory.mem_readb(1184) != 0) {
                            CPU_Regs.reg_eax.high(128);
                            Callback.CALLBACK_SCF(true);
                            break;
                        }
                        long count = CPU_Regs.reg_ecx.word() << 16 | CPU_Regs.reg_edx.word();
                        Memory.mem_writed(1176, Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word()));
                        Memory.mem_writed(1180, (int)count);
                        Memory.mem_writeb(1184, 1);
                        IoHandler.IO_Write(112, 11);
                        IoHandler.IO_Write(113, IoHandler.IO_Read(113) | 0x40);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 132: {
                        if (CPU_Regs.reg_edx.word() == 0) {
                            if (Joystick.JOYSTICK_IsEnabled(0) || Joystick.JOYSTICK_IsEnabled(1)) {
                                CPU_Regs.reg_eax.low(IO.IO_ReadB(513) & 0xF0);
                                Callback.CALLBACK_SCF(false);
                                break;
                            }
                            CPU_Regs.reg_eax.word(240);
                            CPU_Regs.reg_edx.word(513);
                            Callback.CALLBACK_SCF(true);
                            break;
                        }
                        if (CPU_Regs.reg_edx.word() == 1) {
                            if (Joystick.JOYSTICK_IsEnabled(0)) {
                                CPU_Regs.reg_eax.word((int)(Joystick.JOYSTICK_GetMove_X(0) * 127.0f + 128.0f));
                                CPU_Regs.reg_ebx.word((int)(Joystick.JOYSTICK_GetMove_Y(0) * 127.0f + 128.0f));
                                if (Joystick.JOYSTICK_IsEnabled(1)) {
                                    CPU_Regs.reg_ecx.word((int)(Joystick.JOYSTICK_GetMove_X(1) * 127.0f + 128.0f));
                                    CPU_Regs.reg_edx.word((int)(Joystick.JOYSTICK_GetMove_Y(1) * 127.0f + 128.0f));
                                } else {
                                    CPU_Regs.reg_ecx.word(0);
                                    CPU_Regs.reg_edx.word(0);
                                }
                                Callback.CALLBACK_SCF(false);
                                break;
                            }
                            if (Joystick.JOYSTICK_IsEnabled(1)) {
                                CPU_Regs.reg_eax.word(0);
                                CPU_Regs.reg_ebx.word(0);
                                CPU_Regs.reg_ecx.word((int)(Joystick.JOYSTICK_GetMove_X(1) * 127.0f + 128.0f));
                                CPU_Regs.reg_edx.word((int)(Joystick.JOYSTICK_GetMove_Y(1) * 127.0f + 128.0f));
                                Callback.CALLBACK_SCF(false);
                                break;
                            }
                            CPU_Regs.reg_eax.word(0);
                            CPU_Regs.reg_ebx.word(0);
                            CPU_Regs.reg_ecx.word(0);
                            CPU_Regs.reg_edx.word(0);
                            Callback.CALLBACK_SCF(true);
                            break;
                        }
                        Log.log(19, 2, "INT15:84:Unknown Bios Joystick functionality.");
                        break;
                    }
                    case 134: {
                        if (Memory.mem_readb(1184) != 0) {
                            CPU_Regs.reg_eax.high(131);
                            Callback.CALLBACK_SCF(true);
                            break;
                        }
                        long count = CPU_Regs.reg_ecx.word() << 16 | CPU_Regs.reg_edx.word();
                        Memory.mem_writed(1176, Memory.RealMake(0, 1185));
                        Memory.mem_writed(1180, (int)count);
                        Memory.mem_writeb(1184, 1);
                        IoHandler.IO_Write(112, 11);
                        IoHandler.IO_Write(113, IoHandler.IO_Read(113) | 0x40);
                        while (Memory.mem_readd(1180) != 0) {
                            Callback.CALLBACK_Idle();
                        }
                        Callback.CALLBACK_SCF(false);
                    }
                    case 135: {
                        boolean enabled = Memory.MEM_A20_Enabled();
                        Memory.MEM_A20_Enable(true);
                        int bytes = CPU_Regs.reg_ecx.word() * 2;
                        int data = CPU.Segs_ESphys + CPU_Regs.reg_esi.word();
                        int source = (Memory.mem_readd(data + 18) & 0xFFFFFF) + (Memory.mem_readb(data + 22) << 24);
                        int dest = (Memory.mem_readd(data + 26) & 0xFFFFFF) + (Memory.mem_readb(data + 30) << 24);
                        Memory.MEM_BlockCopy(dest, source, bytes);
                        CPU_Regs.reg_eax.word(0);
                        Memory.MEM_A20_Enable(enabled);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 136: {
                        CPU_Regs.reg_eax.word(other_memsystems != 0 ? 0 : size_extended);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 137: {
                        IoHandler.IO_Write(32, 16);
                        IoHandler.IO_Write(33, CPU_Regs.reg_ebx.high());
                        IoHandler.IO_Write(33, 0);
                        IoHandler.IO_Write(160, 16);
                        IoHandler.IO_Write(161, CPU_Regs.reg_ebx.low());
                        IoHandler.IO_Write(161, 0);
                        Memory.MEM_A20_Enable(true);
                        int table = CPU.Segs_ESphys + CPU_Regs.reg_esi.word();
                        CPU.CPU_LGDT(Memory.mem_readw(table + 8), Memory.mem_readd(table + 8 + 2) & 0xFFFFFF);
                        CPU.CPU_LIDT(Memory.mem_readw(table + 16), Memory.mem_readd(table + 16 + 2) & 0xFFFFFF);
                        CPU.CPU_SET_CRX(0, CPU.CPU_GET_CRX(0) | 1);
                        CPU.CPU_SetSegGeneralDS(24);
                        CPU.CPU_SetSegGeneralES(32);
                        CPU.CPU_SetSegGeneralSS(40);
                        CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() + 6);
                        CPU.CPU_SetFlags(0, 294869);
                        CPU_Regs.reg_eax.word(0);
                        CPU.CPU_JMP(false, 48, CPU_Regs.reg_ecx.word(), 0);
                        break;
                    }
                    case 144: {
                        Callback.CALLBACK_SCF(false);
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 145: {
                        Callback.CALLBACK_SCF(false);
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 194: {
                        switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                if (CPU_Regs.reg_ebx.high() == 0) {
                                    Mouse.Mouse_SetPS2State(false);
                                    CPU_Regs.reg_eax.high(0);
                                    Callback.CALLBACK_SCF(false);
                                    break block0;
                                }
                                if (CPU_Regs.reg_ebx.high() == 1) {
                                    if (!Mouse.Mouse_SetPS2State(true)) {
                                        CPU_Regs.reg_eax.high(5);
                                        Callback.CALLBACK_SCF(true);
                                        break block0;
                                    }
                                    CPU_Regs.reg_eax.high(0);
                                    Callback.CALLBACK_SCF(false);
                                    break block0;
                                }
                                Callback.CALLBACK_SCF(true);
                                CPU_Regs.reg_eax.high(1);
                                break block0;
                            }
                            case 1: {
                                CPU_Regs.reg_ebx.word(170);
                            }
                            case 5: {
                                Mouse.Mouse_SetPS2State(false);
                                Callback.CALLBACK_SCF(false);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 2: 
                            case 3: {
                                Callback.CALLBACK_SCF(false);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 4: {
                                CPU_Regs.reg_ebx.high(0);
                                Callback.CALLBACK_SCF(false);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 6: {
                                if (CPU_Regs.reg_ebx.high() == 1 || CPU_Regs.reg_ebx.high() == 2) {
                                    Callback.CALLBACK_SCF(false);
                                    CPU_Regs.reg_eax.high(0);
                                    break block0;
                                }
                                Callback.CALLBACK_SCF(true);
                                CPU_Regs.reg_eax.high(1);
                                break block0;
                            }
                            case 7: {
                                Mouse.Mouse_ChangePS2Callback(CPU.Segs_ESval, CPU_Regs.reg_ebx.word());
                                Callback.CALLBACK_SCF(false);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                        }
                        Callback.CALLBACK_SCF(true);
                        CPU_Regs.reg_eax.high(1);
                        break;
                    }
                    case 195: {
                        CPU_Regs.reg_eax.high(134);
                        Callback.CALLBACK_SCF(true);
                        break;
                    }
                    case 196: {
                        Callback.CALLBACK_SCF(true);
                        break;
                    }
                    case 83: {
                        block26 : switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                CPU_Regs.reg_eax.high(1);
                                CPU_Regs.reg_eax.low(2);
                                CPU_Regs.reg_ebx.word(20557);
                                CPU_Regs.reg_ecx.word(0);
                                break;
                            }
                            case 1: {
                                if (CPU_Regs.reg_ebx.word() != 0) {
                                    CPU_Regs.reg_eax.high(9);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (!apm_realmode_connected) {
                                    Callback.CALLBACK_SCF(false);
                                    apm_realmode_connected = true;
                                    break;
                                }
                                CPU_Regs.reg_eax.high(2);
                                Callback.CALLBACK_SCF(true);
                                break;
                            }
                            case 4: {
                                if (CPU_Regs.reg_ebx.word() != 0) {
                                    CPU_Regs.reg_eax.high(9);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (apm_realmode_connected) {
                                    Callback.CALLBACK_SCF(false);
                                    apm_realmode_connected = false;
                                    break;
                                }
                                CPU_Regs.reg_eax.high(3);
                                Callback.CALLBACK_SCF(true);
                                break;
                            }
                            case 7: {
                                if (CPU_Regs.reg_ebx.word() != 1) {
                                    CPU_Regs.reg_eax.high(9);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (!apm_realmode_connected) {
                                    CPU_Regs.reg_eax.high(3);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                switch (CPU_Regs.reg_ecx.word()) {
                                    case 3: {
                                        Log.exit("Power Off");
                                        break block26;
                                    }
                                }
                                CPU_Regs.reg_eax.high(10);
                                Callback.CALLBACK_SCF(true);
                                break;
                            }
                            case 8: {
                                if (CPU_Regs.reg_ebx.word() != 0 && CPU_Regs.reg_ebx.word() != 1) {
                                    CPU_Regs.reg_eax.high(9);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (!apm_realmode_connected) {
                                    CPU_Regs.reg_eax.high(3);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (CPU_Regs.reg_ecx.word() == 0) {
                                    Log.log_msg("disable APM for device " + Integer.toString(CPU_Regs.reg_ebx.word(), 16));
                                    break;
                                }
                                if (CPU_Regs.reg_ecx.word() == 1) {
                                    Log.log_msg("enable APM for device " + Integer.toString(CPU_Regs.reg_ebx.word(), 16));
                                    break;
                                }
                                CPU_Regs.reg_eax.high(10);
                                Callback.CALLBACK_SCF(true);
                                break;
                            }
                            case 14: {
                                if (CPU_Regs.reg_ebx.word() != 0) {
                                    CPU_Regs.reg_eax.high(9);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (!apm_realmode_connected) {
                                    CPU_Regs.reg_eax.high(3);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (CPU_Regs.reg_eax.high() < 1) {
                                    CPU_Regs.reg_eax.high(1);
                                }
                                if (CPU_Regs.reg_eax.low() < 2) {
                                    CPU_Regs.reg_eax.low(2);
                                }
                                Callback.CALLBACK_SCF(false);
                                break;
                            }
                            case 15: {
                                if (CPU_Regs.reg_ebx.word() != 0 && CPU_Regs.reg_ebx.word() != 1) {
                                    CPU_Regs.reg_eax.high(9);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (!apm_realmode_connected) {
                                    CPU_Regs.reg_eax.high(3);
                                    Callback.CALLBACK_SCF(true);
                                    break;
                                }
                                if (CPU_Regs.reg_ecx.word() == 0) {
                                    Log.log_msg("disengage APM for device " + Integer.toString(CPU_Regs.reg_ebx.word(), 16));
                                    break;
                                }
                                if (CPU_Regs.reg_ecx.word() == 1) {
                                    Log.log_msg("engage APM for device " + Integer.toString(CPU_Regs.reg_ebx.word(), 16));
                                    break;
                                }
                                CPU_Regs.reg_eax.high(10);
                                Callback.CALLBACK_SCF(true);
                                break;
                            }
                        }
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    default: {
                        Log.log(19, 2, "INT15:Unknown call " + Integer.toString(CPU_Regs.reg_eax.word(), 16));
                        CPU_Regs.reg_eax.high(134);
                        Callback.CALLBACK_SCF(true);
                        if (!Dosbox.IS_EGAVGA_ARCH() && Dosbox.machine != 1) break;
                        Callback.CALLBACK_SZF(false);
                    }
                }
                return 0;
            }
        };
        Reboot_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios.Reboot_Handler";
            }

            public int call() {
                byte[] text = "\n\n   Reboot requested, quitting now.".getBytes();
                CPU_Regs.reg_eax.word(0);
                Callback.CALLBACK_RunRealInt(16);
                CPU_Regs.reg_eax.high(14);
                CPU_Regs.reg_ebx.word(0);
                for (int i = 0; i < text.length; ++i) {
                    CPU_Regs.reg_eax.low(text[i]);
                    Callback.CALLBACK_RunRealInt(16);
                }
                Log.log_msg(new String(text));
                double start = Pic.PIC_FullIndex();
                while (Pic.PIC_FullIndex() - start < 3000.0) {
                    Callback.CALLBACK_Idle();
                }
                throw new Dos_programs.RebootException();
            }
        };
        BIOS_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                test.destroy();
                test = null;
                tandy_dac = null;
                tandy_sb = null;
            }
        };
        BIOS_Init = new Section.SectionFunction(){

            public void call(Section section) {
                biosConfigSeg = 0;
                tandy_dac = new Tandy_dac();
                tandy_sb = new Tandy_sb();
                test = new Bios(section);
                section.AddDestroyFunction(BIOS_Destroy, false);
            }
        };
    }

    private static class Tandy_dac {
        int port;
        short irq;
        short dma;

        private Tandy_dac() {
        }
    }

    private static class Tandy_sb {
        int port;
        short irq;
        short dma;

        private Tandy_sb() {
        }
    }
}

