/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Bios;
import jdos.misc.Log;
import jdos.util.IntRef;

public class Bios_keyboard {
    private static int call_int16;
    private static int call_irq1;
    private static int call_irq6;
    private static final int none = 0;
    private static Scan[] scan_to_scanascii;
    public static final Object lock;
    private static Callback.Handler IRQ1_Handler;
    private static Callback.Handler INT16_Handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean BIOS_AddKeyToBuffer(int code) {
        Object object = lock;
        synchronized (object) {
            int end;
            int start;
            if ((Memory.mem_readb(1048) & 8) != 0) {
                return true;
            }
            if (Dosbox.machine == 3) {
                start = 30;
                end = 62;
            } else {
                start = Memory.mem_readw(1152);
                end = Memory.mem_readw(1154);
            }
            int head = Memory.mem_readw(1050);
            int tail = Memory.mem_readw(1052);
            int ttail = tail + 2;
            if (ttail >= end) {
                ttail = start;
            }
            if (ttail == head) {
                return false;
            }
            Memory.real_writew(64, tail, code);
            Memory.mem_writew(1052, ttail);
        }
        return true;
    }

    private static void add_key(int code) {
        if (code != 0) {
            Bios_keyboard.BIOS_AddKeyToBuffer(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean get_key(IntRef code) {
        Object object = lock;
        synchronized (object) {
            int end;
            int start;
            if (Dosbox.machine == 3) {
                start = 30;
                end = 62;
            } else {
                start = Memory.mem_readw(1152);
                end = Memory.mem_readw(1154);
            }
            int head = Memory.mem_readw(1050);
            int tail = Memory.mem_readw(1052);
            if (head == tail) {
                return false;
            }
            int thead = head + 2;
            if (thead >= end) {
                thead = start;
            }
            Memory.mem_writew(1050, thead);
            code.value = Memory.real_readw(64, head);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean check_key(IntRef code) {
        Object object = lock;
        synchronized (object) {
            int head = Memory.mem_readw(1050);
            int tail = Memory.mem_readw(1052);
            if (head == tail) {
                return false;
            }
            code.value = Memory.real_readw(64, head);
        }
        return true;
    }

    private static boolean IsEnhancedKey(IntRef key) {
        if (key.value >> 8 == 224) {
            key.value = (key.value & 0xFF) == 10 || (key.value & 0xFF) == 13 ? key.value & 0xFF | 0x1C00 : key.value & 0xFF | 0x3500;
            return false;
        }
        if (key.value >> 8 > 132 || (key.value & 0xFF) == 240 && key.value >> 8 != 0) {
            return true;
        }
        if (key.value >> 8 != 0 && (key.value & 0xFF) == 224) {
            key.value &= 0xFF00;
        }
        return false;
    }

    private static void InitBiosSegment() {
        Memory.mem_writew(1152, 30);
        Memory.mem_writew(1154, 62);
        Memory.mem_writew(1050, 30);
        Memory.mem_writew(1052, 30);
        int flag1 = 0;
        int leds = 16;
        Memory.mem_writeb(1047, flag1);
        Memory.mem_writeb(1048, 0);
        Memory.mem_writeb(1174, 16);
        Memory.mem_writeb(1049, 0);
        Memory.mem_writeb(1175, leds);
    }

    public static void BIOS_SetupKeyboard() {
        Bios_keyboard.InitBiosSegment();
        call_int16 = Callback.CALLBACK_Allocate();
        Callback.CALLBACK_Setup(call_int16, INT16_Handler, 15, "Keyboard");
        Memory.RealSetVec(22, Callback.CALLBACK_RealPointer(call_int16));
        call_irq1 = Callback.CALLBACK_Allocate();
        Callback.CALLBACK_Setup(call_irq1, IRQ1_Handler, 8, Memory.Real2Phys(Bios.BIOS_DEFAULT_IRQ1_LOCATION()), "IRQ 1 Keyboard");
        Memory.RealSetVec(9, Bios.BIOS_DEFAULT_IRQ1_LOCATION());
        if (Dosbox.machine == 3) {
            call_irq6 = Callback.CALLBACK_Allocate();
            Callback.CALLBACK_Setup(call_irq6, null, 12, "PCJr kb irq");
            Memory.RealSetVec(14, Callback.CALLBACK_RealPointer(call_irq6));
        }
    }

    static {
        scan_to_scanascii = new Scan[]{new Scan(0, 0, 0, 0), new Scan(283, 283, 283, 496), new Scan(561, 545, 0, 30720), new Scan(818, 832, 768, 30976), new Scan(1075, 1059, 0, 31232), new Scan(1332, 1316, 0, 31488), new Scan(1589, 1573, 0, 31744), new Scan(1846, 1886, 1822, 32000), new Scan(2103, 2086, 0, 32256), new Scan(2360, 2346, 0, 32512), new Scan(2617, 2600, 0, 32768), new Scan(2864, 2857, 0, 33024), new Scan(3117, 3167, 3103, 33280), new Scan(3389, 3371, 0, 33536), new Scan(3592, 3592, 3711, 3824), new Scan(3849, 3840, 37888, 0), new Scan(4209, 4177, 4113, 4096), new Scan(4471, 4439, 4375, 4352), new Scan(4709, 4677, 4613, 4608), new Scan(4978, 4946, 4882, 4864), new Scan(5236, 5204, 5140, 5120), new Scan(5497, 5465, 5401, 5376), new Scan(5749, 5717, 5653, 5632), new Scan(5993, 5961, 5897, 5888), new Scan(6255, 6223, 6159, 6144), new Scan(6512, 6480, 6416, 6400), new Scan(6747, 6779, 6683, 6896), new Scan(7005, 7037, 6941, 7152), new Scan(7181, 7181, 7178, 0), new Scan(0, 0, 0, 0), new Scan(7777, 7745, 7681, 7680), new Scan(8051, 8019, 7955, 7936), new Scan(8292, 8260, 8196, 8192), new Scan(8550, 8518, 8454, 8448), new Scan(8807, 8775, 8711, 8704), new Scan(9064, 9032, 8968, 8960), new Scan(9322, 9290, 9226, 9216), new Scan(9579, 9547, 9483, 9472), new Scan(9836, 9804, 9740, 9728), new Scan(10043, 10042, 0, 10224), new Scan(10279, 10274, 0, 10480), new Scan(10592, 10622, 0, 10736), new Scan(0, 0, 0, 0), new Scan(11100, 11132, 11036, 11248), new Scan(11386, 11354, 11290, 11264), new Scan(11640, 11608, 11544, 11520), new Scan(11875, 11843, 11779, 11776), new Scan(12150, 12118, 12054, 12032), new Scan(12386, 12354, 12290, 12288), new Scan(12654, 12622, 12558, 12544), new Scan(12909, 12877, 12813, 12800), new Scan(13100, 13116, 0, 13296), new Scan(13358, 13374, 0, 13552), new Scan(13615, 13631, 0, 13808), new Scan(0, 0, 0, 0), new Scan(14122, 14122, 38400, 14320), new Scan(0, 0, 0, 0), new Scan(14624, 14624, 14624, 14624), new Scan(0, 0, 0, 0), new Scan(15104, 21504, 24064, 26624), new Scan(15360, 21760, 24320, 26880), new Scan(15616, 22016, 24576, 27136), new Scan(15872, 22272, 24832, 27392), new Scan(16128, 22528, 25088, 27648), new Scan(16384, 22784, 25344, 27904), new Scan(16640, 23040, 25600, 28160), new Scan(16896, 23296, 25856, 28416), new Scan(17152, 23552, 26112, 28672), new Scan(17408, 23808, 26368, 28928), new Scan(0, 0, 0, 0), new Scan(0, 0, 0, 0), new Scan(18176, 18231, 30464, 7), new Scan(18432, 18488, 36096, 8), new Scan(18688, 18745, 33792, 9), new Scan(18989, 18989, 36352, 19184), new Scan(19200, 19252, 29440, 4), new Scan(19696, 19509, 36608, 5), new Scan(19712, 19766, 29696, 6), new Scan(20011, 20011, 36864, 20208), new Scan(20224, 20273, 29952, 1), new Scan(20480, 20530, 37120, 2), new Scan(20736, 20787, 30208, 3), new Scan(20992, 21040, 37376, 0), new Scan(21248, 21294, 37632, 0), new Scan(0, 0, 0, 0), new Scan(0, 0, 0, 0), new Scan(22108, 22140, 0, 0), new Scan(34048, 34560, 35072, 35584), new Scan(34304, 34816, 35328, 35840)};
        lock = new Object();
        IRQ1_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios_keyboard.IRQ1_Handler";
            }

            public int call() {
                short scancode = CPU_Regs.reg_eax.low();
                short flags1 = Memory.mem_readb(1047);
                short flags2 = Memory.mem_readb(1048);
                short flags3 = Memory.mem_readb(1174);
                short leds = Memory.mem_readb(1175);
                switch (scancode) {
                    case 250: {
                        break;
                    }
                    case 225: {
                        flags3 = (short)(flags3 | 1);
                        break;
                    }
                    case 224: {
                        flags3 = (short)(flags3 | 2);
                        break;
                    }
                    case 29: {
                        if ((flags3 & 1) != 0) break;
                        flags1 = (short)(flags1 | 4);
                        if ((flags3 & 2) != 0) {
                            flags3 = (short)(flags3 | 4);
                            break;
                        }
                        flags2 = (short)(flags2 | 1);
                        break;
                    }
                    case 157: {
                        if ((flags3 & 1) != 0) break;
                        if ((flags3 & 2) != 0) {
                            flags3 = (short)(flags3 & 0xFFFFFFFB);
                        } else {
                            flags2 = (short)(flags2 & 0xFFFFFFFE);
                        }
                        if ((flags3 & 4) != 0 || (flags2 & 1) != 0) break;
                        flags1 = (short)(flags1 & 0xFFFFFFFB);
                        break;
                    }
                    case 42: {
                        flags1 = (short)(flags1 | 2);
                        break;
                    }
                    case 170: {
                        flags1 = (short)(flags1 & 0xFFFFFFFD);
                        break;
                    }
                    case 54: {
                        flags1 = (short)(flags1 | 1);
                        break;
                    }
                    case 182: {
                        flags1 = (short)(flags1 & 0xFFFFFFFE);
                        break;
                    }
                    case 56: {
                        flags1 = (short)(flags1 | 8);
                        if ((flags3 & 2) != 0) {
                            flags3 = (short)(flags3 | 8);
                            break;
                        }
                        flags2 = (short)(flags2 | 2);
                        break;
                    }
                    case 184: {
                        if ((flags3 & 2) != 0) {
                            flags3 = (short)(flags3 & 0xFFFFFFF7);
                        } else {
                            flags2 = (short)(flags2 & 0xFFFFFFFD);
                        }
                        if ((flags3 & 8) != 0 || (flags2 & 2) != 0) break;
                        flags1 = (short)(flags1 & 0xFFFFFFF7);
                        short token = Memory.mem_readb(1049);
                        if (token == 0) break;
                        Bios_keyboard.add_key(token);
                        Memory.mem_writeb(1049, 0);
                        break;
                    }
                    case 58: {
                        flags2 = (short)(flags2 | 0x40);
                        break;
                    }
                    case 186: {
                        flags1 = (short)(flags1 ^ 0x40);
                        flags2 = (short)(flags2 & 0xFFFFFFBF);
                        leds = (short)(leds ^ 4);
                        break;
                    }
                    case 69: {
                        if ((flags3 & 1) != 0) {
                            flags3 = (short)(flags3 & 0xFFFFFFFE);
                            Memory.mem_writeb(1174, flags3);
                            if ((flags2 & 1) != 0 || (flags2 & 8) != 0) break;
                            Memory.mem_writeb(1048, flags2 | 8);
                            IoHandler.IO_Write(32, 32);
                            while ((Memory.mem_readb(1048) & 8) != 0) {
                                Callback.CALLBACK_Idle();
                            }
                            CPU_Regs.reg_ip(CPU_Regs.reg_ip() + 5);
                            return 0;
                        }
                        flags2 = (short)(flags2 | 0x20);
                        break;
                    }
                    case 197: {
                        if ((flags3 & 1) != 0) {
                            flags3 = (short)(flags3 & 0xFFFFFFFE);
                            break;
                        }
                        flags1 = (short)(flags1 ^ 0x20);
                        leds = (short)(leds ^ 2);
                        flags2 = (short)(flags2 & 0xFFFFFFDF);
                        break;
                    }
                    case 70: {
                        flags2 = (short)(flags2 | 0x10);
                        break;
                    }
                    case 198: {
                        flags1 = (short)(flags1 ^ 0x10);
                        flags2 = (short)(flags2 & 0xFFFFFFEF);
                        leds = (short)(leds ^ 1);
                        break;
                    }
                    case 210: {
                        if ((flags3 & 2) == 0) break;
                        flags1 = (short)(flags1 ^ 0x80);
                        flags2 = (short)(flags2 & 0xFFFFFF7F);
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: {
                        if ((flags3 & 2) != 0) {
                            if (scancode == 82) {
                                flags2 = (short)(flags2 | 0x80);
                            }
                            if ((flags1 & 8) != 0) {
                                Bios_keyboard.add_key(scan_to_scanascii[scancode].normal + 20480);
                                break;
                            }
                            if ((flags1 & 4) != 0) {
                                Bios_keyboard.add_key(scan_to_scanascii[scancode].control & 0xFF00 | 0xE0);
                                break;
                            }
                            if ((flags1 & 3) != 0 || (flags1 & 0x20) != 0) {
                                Bios_keyboard.add_key(scan_to_scanascii[scancode].shift & 0xFF00 | 0xE0);
                                break;
                            }
                            Bios_keyboard.add_key(scan_to_scanascii[scancode].normal & 0xFF00 | 0xE0);
                            break;
                        }
                        if ((flags1 & 8) != 0) {
                            short token = Memory.mem_readb(1049);
                            token = (short)(token * 10 + scan_to_scanascii[scancode].alt & 0xFF);
                            Memory.mem_writeb(1049, token);
                            break;
                        }
                        if ((flags1 & 4) != 0) {
                            Bios_keyboard.add_key(scan_to_scanascii[scancode].control);
                            break;
                        }
                        if ((flags1 & 3) != 0 || (flags1 & 0x20) != 0) {
                            Bios_keyboard.add_key(scan_to_scanascii[scancode].shift);
                            break;
                        }
                        Bios_keyboard.add_key(scan_to_scanascii[scancode].normal);
                        break;
                    }
                    default: {
                        if ((scancode & 0x80) != 0 || scancode > 88) break;
                        int asciiscan = (flags1 & 8) != 0 ? scan_to_scanascii[scancode].alt : ((flags1 & 4) != 0 ? scan_to_scanascii[scancode].control : ((flags1 & 3) != 0 ? scan_to_scanascii[scancode].shift : scan_to_scanascii[scancode].normal));
                        if ((flags1 & 0x40) != 0) {
                            if ((flags1 & 3) != 0) {
                                if ((asciiscan & 0xFF) > 64 && (asciiscan & 0xFF) < 91) {
                                    asciiscan = scan_to_scanascii[scancode].normal;
                                }
                            } else if ((asciiscan & 0xFF) > 96 && (asciiscan & 0xFF) < 123) {
                                asciiscan = scan_to_scanascii[scancode].shift;
                            }
                        }
                        if ((flags3 & 2) != 0) {
                            if (scancode == 28) {
                                asciiscan = (flags1 & 8) != 0 ? 42496 : asciiscan & 0xFF | 0xE000;
                            } else if (scancode == 53) {
                                asciiscan = (flags1 & 8) != 0 ? 41984 : ((flags1 & 4) != 0 ? 38144 : 57391);
                            }
                        }
                        Bios_keyboard.add_key(asciiscan);
                    }
                }
                if (scancode != 224) {
                    flags3 = (short)(flags3 & 0xFFFFFFFD);
                }
                Memory.mem_writeb(1047, flags1);
                if ((scancode & 0x80) == 0) {
                    flags2 = (short)(flags2 & 0xF7);
                }
                Memory.mem_writeb(1048, flags2);
                Memory.mem_writeb(1174, flags3);
                Memory.mem_writeb(1175, leds);
                return 0;
            }
        };
        INT16_Handler = new Callback.Handler(){

            public String getName() {
                return "Bios_keyboard.INT16_Handler";
            }

            public int call() {
                IntRef temp = new IntRef(0);
                block0 : switch (CPU_Regs.reg_eax.high()) {
                    case 0: {
                        if (Bios_keyboard.get_key(temp) && !Bios_keyboard.IsEnhancedKey(temp)) {
                            CPU_Regs.reg_eax.word(temp.value);
                            break;
                        }
                        CPU_Regs.reg_ip(CPU_Regs.reg_ip() + 1);
                        break;
                    }
                    case 16: {
                        if (Bios_keyboard.get_key(temp)) {
                            if ((temp.value & 0xFF) == 240 && temp.value >> 8 != 0) {
                                temp.value &= 0xFF00;
                            }
                            CPU_Regs.reg_eax.word(temp.value);
                            break;
                        }
                        CPU_Regs.reg_ip(CPU_Regs.reg_ip() + 1);
                        break;
                    }
                    case 1: {
                        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4, Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4) | 0x200);
                        while (Bios_keyboard.check_key(temp)) {
                            if (!Bios_keyboard.IsEnhancedKey(temp)) {
                                Callback.CALLBACK_SZF(false);
                                CPU_Regs.reg_eax.word(temp.value);
                                break block0;
                            }
                            Bios_keyboard.get_key(temp);
                        }
                        Callback.CALLBACK_SZF(true);
                        break;
                    }
                    case 17: {
                        if (!Bios_keyboard.check_key(temp)) {
                            Callback.CALLBACK_SZF(true);
                            break;
                        }
                        Callback.CALLBACK_SZF(false);
                        if ((temp.value & 0xFF) == 240 && temp.value >> 8 != 0) {
                            temp.value &= 0xFF00;
                        }
                        CPU_Regs.reg_eax.word(temp.value);
                        break;
                    }
                    case 2: {
                        CPU_Regs.reg_eax.low(Memory.mem_readb(1047));
                        break;
                    }
                    case 3: {
                        if (CPU_Regs.reg_eax.low() == 0) {
                            IoHandler.IO_Write(96, 243);
                            IoHandler.IO_Write(96, 32);
                            break;
                        }
                        if (CPU_Regs.reg_eax.low() == 5) {
                            IoHandler.IO_Write(96, 243);
                            IoHandler.IO_Write(96, (CPU_Regs.reg_ebx.high() & 3) << 5 | CPU_Regs.reg_ebx.low() & 0x1F);
                            break;
                        }
                        Log.log(19, 2, "INT16:Unhandled Typematic Rate Call " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " BX=" + Integer.toString(CPU_Regs.reg_ebx.word(), 16));
                        break;
                    }
                    case 5: {
                        if (Bios_keyboard.BIOS_AddKeyToBuffer(CPU_Regs.reg_ecx.word())) {
                            CPU_Regs.reg_eax.low(0);
                            break;
                        }
                        CPU_Regs.reg_eax.low(1);
                        break;
                    }
                    case 18: {
                        CPU_Regs.reg_eax.low(Memory.mem_readb(1047));
                        CPU_Regs.reg_eax.high(Memory.mem_readb(1048));
                        break;
                    }
                    case 85: {
                        Log.log(19, 0, "INT16:55:Word TSR compatible call");
                        break;
                    }
                    default: {
                        Log.log(19, 2, "INT16:Unhandled call " + Integer.toString(CPU_Regs.reg_eax.high(), 16));
                    }
                }
                return 0;
            }
        };
    }

    private static class Scan {
        int normal;
        int shift;
        int control;
        int alt;

        public Scan(int normal, int shift, int control, int alt) {
            this.normal = normal;
            this.shift = shift;
            this.control = control;
            this.alt = alt;
        }
    }
}

