/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.hardware.IO;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Int10_char;
import jdos.ints.Int10_memory;
import jdos.ints.Int10_misc;
import jdos.ints.Int10_modes;
import jdos.ints.Int10_pal;
import jdos.ints.Int10_put_pixel;
import jdos.ints.Int10_vesa;
import jdos.ints.Int10_video_state;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.util.IntRef;
import jdos.util.ShortRef;

public class Int10 {
    public static final int S3_LFB_BASE = -1073741824;
    public static final int BIOSMEM_SEG = 64;
    public static final int BIOSMEM_INITIAL_MODE = 16;
    public static final int BIOSMEM_CURRENT_MODE = 73;
    public static final int BIOSMEM_NB_COLS = 74;
    public static final int BIOSMEM_PAGE_SIZE = 76;
    public static final int BIOSMEM_CURRENT_START = 78;
    public static final int BIOSMEM_CURSOR_POS = 80;
    public static final int BIOSMEM_CURSOR_TYPE = 96;
    public static final int BIOSMEM_CURRENT_PAGE = 98;
    public static final int BIOSMEM_CRTC_ADDRESS = 99;
    public static final int BIOSMEM_CURRENT_MSR = 101;
    public static final int BIOSMEM_CURRENT_PAL = 102;
    public static final int BIOSMEM_NB_ROWS = 132;
    public static final int BIOSMEM_CHAR_HEIGHT = 133;
    public static final int BIOSMEM_VIDEO_CTL = 135;
    public static final int BIOSMEM_SWITCHES = 136;
    public static final int BIOSMEM_MODESET_CTL = 137;
    public static final int BIOSMEM_DCC_INDEX = 138;
    public static final int BIOSMEM_CRTCPU_PAGE = 138;
    public static final int BIOSMEM_VS_POINTER = 168;
    public static final int VGAREG_ACTL_ADDRESS = 960;
    public static final int VGAREG_ACTL_WRITE_DATA = 960;
    public static final int VGAREG_ACTL_READ_DATA = 961;
    public static final int VGAREG_INPUT_STATUS = 962;
    public static final int VGAREG_WRITE_MISC_OUTPUT = 962;
    public static final int VGAREG_VIDEO_ENABLE = 963;
    public static final int VGAREG_SEQU_ADDRESS = 964;
    public static final int VGAREG_SEQU_DATA = 965;
    public static final int VGAREG_PEL_MASK = 966;
    public static final int VGAREG_DAC_STATE = 967;
    public static final int VGAREG_DAC_READ_ADDRESS = 967;
    public static final int VGAREG_DAC_WRITE_ADDRESS = 968;
    public static final int VGAREG_DAC_DATA = 969;
    public static final int VGAREG_READ_FEATURE_CTL = 970;
    public static final int VGAREG_READ_MISC_OUTPUT = 972;
    public static final int VGAREG_GRDC_ADDRESS = 974;
    public static final int VGAREG_GRDC_DATA = 975;
    public static final int VGAREG_MDA_CRTC_ADDRESS = 948;
    public static final int VGAREG_MDA_CRTC_DATA = 949;
    public static final int VGAREG_VGA_CRTC_ADDRESS = 980;
    public static final int VGAREG_VGA_CRTC_DATA = 981;
    public static final int VGAREG_MDA_WRITE_FEATURE_CTL = 954;
    public static final int VGAREG_VGA_WRITE_FEATURE_CTL = 986;
    public static final int VGAREG_ACTL_RESET = 986;
    public static final int VGAREG_TDY_RESET = 986;
    public static final int VGAREG_TDY_ADDRESS = 986;
    public static final int VGAREG_TDY_DATA = 990;
    public static final int VGAREG_PCJR_DATA = 986;
    public static final int VGAREG_MDA_MODECTL = 952;
    public static final int VGAREG_CGA_MODECTL = 984;
    public static final int VGAREG_CGA_PALETTE = 985;
    public static final int VGAMEM_GRAPH = 40960;
    public static final int VGAMEM_CTEXT = 47104;
    public static final int VGAMEM_MTEXT = 45056;
    public static Int10Data int10;
    private static int call_10;
    static boolean warned_ff;
    private static Callback.Handler INT10_Handler;
    public static Section.SectionFunction INT10_Destroy;
    public static Section.SectionFunction INT10_Init;

    public static short CURSOR_POS_COL(short page) {
        return Memory.real_readb(64, 80 + page * 2);
    }

    public static short CURSOR_POS_ROW(short page) {
        return Memory.real_readb(64, 80 + page * 2 + 1);
    }

    static void graphics_chars() {
        switch (CPU_Regs.reg_ebx.low()) {
            case 0: {
                Memory.real_writeb(64, 132, (short)(CPU_Regs.reg_edx.low() - 1));
                break;
            }
            case 1: {
                Memory.real_writeb(64, 132, 13);
                break;
            }
            case 3: {
                Memory.real_writeb(64, 132, 42);
                break;
            }
            default: {
                Memory.real_writeb(64, 132, 24);
            }
        }
    }

    private static void INT10_Seg40Init() {
        Memory.real_writeb(64, 133, 16);
        Memory.real_writeb(64, 135, 96);
        Memory.real_writeb(64, 136, 249);
        Memory.real_writeb(64, 137, 81);
        Memory.real_writeb(64, 101, 9);
    }

    private static void INT10_InitVGA() {
        IoHandler.IO_Write(962, -61);
        IoHandler.IO_Write(964, 4);
        IoHandler.IO_Write(965, 2);
    }

    private static void SetupTandyBios() {
        byte[] TandyConfig = new byte[]{33, 66, 73, 79, 83, 32, 82, 79, 77, 32, 118, 101, 114, 115, 105, 111, 110, 32, 48, 50, 46, 48, 48, 46, 48, 48, 13, 10, 67, 111, 109, 112, 97, 116, 105, 98, 105, 108, 105, 116, 121, 32, 83, 111, 102, 116, 119, 97, 114, 101, 13, 10, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 40, 67, 41, 32, 49, 57, 56, 52, 44, 49, 57, 56, 53, 44, 49, 57, 56, 54, 44, 49, 57, 56, 55, 13, 10, 80, 104, 111, 101, 110, 105, 120, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 65, 115, 115, 111, 99, 105, 97, 116, 101, 115, 32, 76, 116, 100, 46, 13, 10, 97, 110, 100, 32, 84, 97, 110, 100, 121};
        if (Dosbox.machine == 2) {
            for (int i = 0; i < 130; ++i) {
                Memory.phys_writeb(983040 + i + 49152, TandyConfig[i]);
            }
        }
    }

    static {
        warned_ff = false;
        INT10_Handler = new Callback.Handler(){

            public String getName() {
                return "Int10.INT10_Handler";
            }

            public int call() {
                short c = (short)(CPU_Regs.reg_eax.high() & 0xFF);
                block0 : switch (c) {
                    case 0: {
                        Int10_modes.INT10_SetVideoMode(CPU_Regs.reg_eax.low());
                        break;
                    }
                    case 1: {
                        Int10_char.INT10_SetCursorShape(CPU_Regs.reg_ecx.high(), CPU_Regs.reg_ecx.low());
                        break;
                    }
                    case 2: {
                        Int10_char.INT10_SetCursorPos(CPU_Regs.reg_edx.high(), CPU_Regs.reg_edx.low(), CPU_Regs.reg_ebx.high());
                        break;
                    }
                    case 3: {
                        CPU_Regs.reg_edx.low(Int10.CURSOR_POS_COL(CPU_Regs.reg_ebx.high()) & 0xFF);
                        CPU_Regs.reg_edx.high(Int10.CURSOR_POS_ROW(CPU_Regs.reg_ebx.high()) & 0xFF);
                        CPU_Regs.reg_ecx.word(Memory.real_readw(64, 96));
                        break;
                    }
                    case 4: {
                        CPU_Regs.reg_eax.word(0);
                        break;
                    }
                    case 5: {
                        if ((CPU_Regs.reg_eax.low() & 0x80) != 0 && Dosbox.IS_TANDY_ARCH()) {
                            int crtcpu = Memory.real_readb(64, 138);
                            switch (CPU_Regs.reg_eax.low()) {
                                case 128: {
                                    CPU_Regs.reg_ebx.high(crtcpu & 7);
                                    CPU_Regs.reg_ebx.low(crtcpu >> 3 & 7);
                                    break;
                                }
                                case 129: {
                                    crtcpu = crtcpu & 0xC7 | (CPU_Regs.reg_ebx.low() & 7) << 3;
                                    break;
                                }
                                case 130: {
                                    crtcpu = crtcpu & 0xF8 | CPU_Regs.reg_ebx.high() & 7;
                                    break;
                                }
                                case 131: {
                                    crtcpu = crtcpu & 0xC0 | CPU_Regs.reg_ebx.high() & 7 | (CPU_Regs.reg_ebx.low() & 7) << 3;
                                }
                            }
                            if (Dosbox.machine == 3) {
                                CPU_Regs.reg_ebx.high(crtcpu & 7);
                                CPU_Regs.reg_ebx.low(crtcpu >> 3 & 7);
                            }
                            IO.IO_WriteB(991, crtcpu);
                            Memory.real_writeb(64, 138, crtcpu);
                            break;
                        }
                        Int10_char.INT10_SetActivePage(CPU_Regs.reg_eax.low());
                        break;
                    }
                    case 6: {
                        Int10_char.INT10_ScrollWindow(CPU_Regs.reg_ecx.high(), CPU_Regs.reg_ecx.low(), CPU_Regs.reg_edx.high(), CPU_Regs.reg_edx.low(), (byte)(-CPU_Regs.reg_eax.low()), CPU_Regs.reg_ebx.high(), (short)255);
                        break;
                    }
                    case 7: {
                        Int10_char.INT10_ScrollWindow(CPU_Regs.reg_ecx.high(), CPU_Regs.reg_ecx.low(), CPU_Regs.reg_edx.high(), CPU_Regs.reg_edx.low(), (byte)CPU_Regs.reg_eax.low(), CPU_Regs.reg_ebx.high(), (short)255);
                        break;
                    }
                    case 8: {
                        CPU_Regs.reg_eax.word(Int10_char.INT10_ReadCharAttr(CPU_Regs.reg_ebx.high()));
                        break;
                    }
                    case 9: {
                        if (Memory.real_readb(64, 73) == 17) {
                            Int10_char.INT10_WriteChar(CPU_Regs.reg_eax.low(), (short)(CPU_Regs.reg_ebx.low() & 0x80 | 0x3F), CPU_Regs.reg_ebx.high(), CPU_Regs.reg_ecx.word(), true);
                            break;
                        }
                        Int10_char.INT10_WriteChar(CPU_Regs.reg_eax.low(), CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ebx.high(), CPU_Regs.reg_ecx.word(), true);
                        break;
                    }
                    case 10: {
                        Int10_char.INT10_WriteChar(CPU_Regs.reg_eax.low(), CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ebx.high(), CPU_Regs.reg_ecx.word(), false);
                        break;
                    }
                    case 11: {
                        switch (CPU_Regs.reg_ebx.high()) {
                            case 0: {
                                Int10_pal.INT10_SetBackgroundBorder(CPU_Regs.reg_ebx.low());
                                break block0;
                            }
                        }
                        Int10_pal.INT10_SetColorSelect(CPU_Regs.reg_ebx.low());
                        break;
                    }
                    case 12: {
                        Int10_put_pixel.INT10_PutPixel(CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word(), CPU_Regs.reg_ebx.high(), CPU_Regs.reg_eax.low());
                        break;
                    }
                    case 13: {
                        CPU_Regs.reg_eax.low(Int10_put_pixel.INT10_GetPixel(CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word(), CPU_Regs.reg_ebx.high()) & 0xFF);
                        break;
                    }
                    case 14: {
                        Int10_char.INT10_TeletypeOutput(CPU_Regs.reg_eax.low(), CPU_Regs.reg_ebx.low());
                        break;
                    }
                    case 15: {
                        CPU_Regs.reg_ebx.high(Memory.real_readb(64, 98) & 0xFF);
                        CPU_Regs.reg_eax.low((Memory.real_readb(64, 73) | Memory.real_readb(64, 135) & 0x80) & 0xFF);
                        CPU_Regs.reg_eax.high(Memory.real_readw(64, 74) & 0xFF);
                        break;
                    }
                    case 16: {
                        if (Dosbox.machine == 1 || !Dosbox.IS_VGA_ARCH() && CPU_Regs.reg_eax.low() > 3) break;
                        switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                Int10_pal.INT10_SetSinglePaletteRegister(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ebx.high());
                                break block0;
                            }
                            case 1: {
                                Int10_pal.INT10_SetOverscanBorderColor(CPU_Regs.reg_ebx.high());
                                break block0;
                            }
                            case 2: {
                                Int10_pal.INT10_SetAllPaletteRegisters(CPU.Segs_ESphys + CPU_Regs.reg_edx.word());
                                break block0;
                            }
                            case 3: {
                                Int10_pal.INT10_ToggleBlinkingBit(CPU_Regs.reg_ebx.low());
                                break block0;
                            }
                            case 7: {
                                CPU_Regs.reg_ebx.high(Int10_pal.INT10_GetSinglePaletteRegister(CPU_Regs.reg_ebx.high(), CPU_Regs.reg_ebx.low()) & 0xFF);
                                break block0;
                            }
                            case 8: {
                                CPU_Regs.reg_ebx.high(Int10_pal.INT10_GetOverscanBorderColor() & 0xFF);
                                break block0;
                            }
                            case 9: {
                                Int10_pal.INT10_GetAllPaletteRegisters(CPU.Segs_ESphys + CPU_Regs.reg_edx.word());
                                break block0;
                            }
                            case 16: {
                                Int10_pal.INT10_SetSingleDACRegister(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_edx.high(), CPU_Regs.reg_ecx.high(), CPU_Regs.reg_ecx.low());
                                break block0;
                            }
                            case 18: {
                                Int10_pal.INT10_SetDACBlock(CPU_Regs.reg_ebx.word(), CPU_Regs.reg_ecx.word(), CPU.Segs_ESphys + CPU_Regs.reg_edx.word());
                                break block0;
                            }
                            case 19: {
                                Int10_pal.INT10_SelectDACPage(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ebx.high());
                                break block0;
                            }
                            case 21: {
                                ShortRef dh = new ShortRef();
                                ShortRef ch = new ShortRef();
                                ShortRef cl = new ShortRef();
                                Int10_pal.INT10_GetSingleDACRegister(CPU_Regs.reg_ebx.low(), dh, ch, cl);
                                CPU_Regs.reg_edx.high(dh.value & 0xFF);
                                CPU_Regs.reg_ecx.high(ch.value & 0xFF);
                                CPU_Regs.reg_ecx.low(cl.value & 0xFF);
                                break block0;
                            }
                            case 23: {
                                Int10_pal.INT10_GetDACBlock(CPU_Regs.reg_ebx.word(), CPU_Regs.reg_ecx.word(), CPU.Segs_ESphys + CPU_Regs.reg_edx.word());
                                break block0;
                            }
                            case 24: {
                                Int10_pal.INT10_SetPelMask(CPU_Regs.reg_ebx.low());
                                break block0;
                            }
                            case 25: {
                                CPU_Regs.reg_ebx.low(Int10_pal.INT10_GetPelMask() & 0xFF);
                                CPU_Regs.reg_ebx.high(0);
                                break block0;
                            }
                            case 26: {
                                ShortRef bl = new ShortRef();
                                ShortRef bh = new ShortRef();
                                Int10_pal.INT10_GetDACPage(bl, bh);
                                CPU_Regs.reg_ebx.low(bl.value & 0xFF);
                                CPU_Regs.reg_ebx.high(bh.value & 0xFF);
                                break block0;
                            }
                            case 27: {
                                Int10_pal.INT10_PerformGrayScaleSumming(CPU_Regs.reg_ebx.word(), CPU_Regs.reg_ecx.word());
                                break block0;
                            }
                        }
                        Log.log(4, 2, "Function 10:Unhandled EGA/VGA Palette Function " + Integer.toString(CPU_Regs.reg_eax.low(), 16));
                        break;
                    }
                    case 17: {
                        if (!Dosbox.IS_EGAVGA_ARCH()) break;
                        switch (CPU_Regs.reg_eax.low()) {
                            case 0: 
                            case 16: {
                                Int10_memory.INT10_LoadFont(CPU.Segs_ESphys + CPU_Regs.reg_ebp.word(), CPU_Regs.reg_eax.low() == 16, CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word(), CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ebx.high());
                                break;
                            }
                            case 1: 
                            case 17: {
                                Int10_memory.INT10_LoadFont(Memory.Real2Phys(Int10.int10.rom.font_14), CPU_Regs.reg_eax.low() == 17, 256, 0, CPU_Regs.reg_ebx.low(), 14);
                                break;
                            }
                            case 2: 
                            case 18: {
                                Int10_memory.INT10_LoadFont(Memory.Real2Phys(Int10.int10.rom.font_8_first), CPU_Regs.reg_eax.low() == 18, 256, 0, CPU_Regs.reg_ebx.low(), 8);
                                break;
                            }
                            case 3: {
                                IoHandler.IO_Write(964, 3);
                                IoHandler.IO_Write(965, CPU_Regs.reg_ebx.low());
                                break;
                            }
                            case 4: 
                            case 20: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                Int10_memory.INT10_LoadFont(Memory.Real2Phys(Int10.int10.rom.font_16), CPU_Regs.reg_eax.low() == 20, 256, 0, CPU_Regs.reg_ebx.low(), 16);
                                break;
                            }
                            case 32: {
                                Memory.RealSetVec(31, Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebp.word()));
                                break;
                            }
                            case 33: {
                                Memory.RealSetVec(67, Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebp.word()));
                                Memory.real_writew(64, 133, CPU_Regs.reg_ecx.word());
                                Int10.graphics_chars();
                                break;
                            }
                            case 34: {
                                Memory.RealSetVec(67, Int10.int10.rom.font_14);
                                Memory.real_writew(64, 133, 14);
                                Int10.graphics_chars();
                                break;
                            }
                            case 35: {
                                Memory.RealSetVec(67, Int10.int10.rom.font_8_first);
                                Memory.real_writew(64, 133, 8);
                                Int10.graphics_chars();
                                break;
                            }
                            case 36: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                Memory.RealSetVec(67, Int10.int10.rom.font_16);
                                Memory.real_writew(64, 133, 16);
                                Int10.graphics_chars();
                                break;
                            }
                            case 48: {
                                switch (CPU_Regs.reg_ebx.high()) {
                                    case 0: {
                                        int int_1f = Memory.RealGetVec(31);
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(int_1f));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(int_1f));
                                        break;
                                    }
                                    case 1: {
                                        int int_43 = Memory.RealGetVec(67);
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(int_43));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(int_43));
                                        break;
                                    }
                                    case 2: {
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.font_14));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(Int10.int10.rom.font_14));
                                        break;
                                    }
                                    case 3: {
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.font_8_first));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(Int10.int10.rom.font_8_first));
                                        break;
                                    }
                                    case 4: {
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.font_8_second));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(Int10.int10.rom.font_8_second));
                                        break;
                                    }
                                    case 5: {
                                        if (!Dosbox.IS_VGA_ARCH()) break;
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.font_14_alternate));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(Int10.int10.rom.font_14_alternate));
                                        break;
                                    }
                                    case 6: {
                                        if (!Dosbox.IS_VGA_ARCH()) break;
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.font_16));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(Int10.int10.rom.font_16));
                                        break;
                                    }
                                    case 7: {
                                        if (!Dosbox.IS_VGA_ARCH()) break;
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.font_16_alternate));
                                        CPU_Regs.reg_ebp.word(Memory.RealOff(Int10.int10.rom.font_16_alternate));
                                        break;
                                    }
                                    default: {
                                        Log.log(4, 2, "Function 11:30 Request for font " + Integer.toString(CPU_Regs.reg_ebx.high(), 16));
                                    }
                                }
                                if (CPU_Regs.reg_ebx.high() > 7 && Dosbox.svgaCard != 2) break block0;
                                CPU_Regs.reg_ecx.word(Memory.real_readw(64, 133));
                                CPU_Regs.reg_edx.low(Memory.real_readb(64, 132));
                                break;
                            }
                            default: {
                                Log.log(4, 2, "Function 11:Unsupported character generator call " + Integer.toString(CPU_Regs.reg_eax.low(), 16));
                                break;
                            }
                        }
                        break;
                    }
                    case 18: {
                        if (!Dosbox.IS_EGAVGA_ARCH()) break;
                        switch (CPU_Regs.reg_ebx.low()) {
                            case 16: {
                                CPU_Regs.reg_ebx.high(Memory.real_readw(64, 99) == 948 ? 1 : 0);
                                CPU_Regs.reg_ebx.low(3);
                                CPU_Regs.reg_ecx.low(Memory.real_readb(64, 136) & 0xF);
                                CPU_Regs.reg_ecx.high(Memory.real_readb(64, 136) >> 4);
                                break;
                            }
                            case 32: {
                                break;
                            }
                            case 48: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                Log.log(4, 1, "Function 12:Call " + Integer.toString(CPU_Regs.reg_ebx.low(), 16) + " (select vertical resolution)");
                                if (Dosbox.svgaCard != 0 && CPU_Regs.reg_eax.low() > 2) {
                                    CPU_Regs.reg_eax.low(0);
                                    break;
                                }
                                short modeset_ctl = Memory.real_readb(64, 137);
                                short video_switches = (short)(Memory.real_readb(64, 136) & 0xF0);
                                switch (CPU_Regs.reg_eax.low()) {
                                    case 0: {
                                        modeset_ctl = (short)(modeset_ctl & 0xEF);
                                        modeset_ctl = (short)(modeset_ctl | 0x80);
                                        video_switches = (short)(video_switches | 8);
                                        break;
                                    }
                                    case 1: {
                                        modeset_ctl = (short)(modeset_ctl & 0x6F);
                                        video_switches = (short)(video_switches | 9);
                                        break;
                                    }
                                    case 2: {
                                        modeset_ctl = (short)(modeset_ctl & 0x6F);
                                        modeset_ctl = (short)(modeset_ctl | 0x10);
                                        video_switches = (short)(video_switches | 9);
                                        break;
                                    }
                                    default: {
                                        modeset_ctl = (short)(modeset_ctl & 0xEF);
                                        video_switches = (short)(video_switches | 8);
                                    }
                                }
                                Memory.real_writeb(64, 137, modeset_ctl);
                                Memory.real_writeb(64, 136, video_switches);
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            case 49: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                if (Dosbox.svgaCard == 2) {
                                    CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() & 1);
                                }
                                if (CPU_Regs.reg_eax.low() > 1) {
                                    CPU_Regs.reg_eax.low(0);
                                    break;
                                }
                                short temp = (short)(Memory.real_readb(64, 137) & 0xF7);
                                if ((CPU_Regs.reg_eax.low() & 1) != 0) {
                                    temp = (short)(temp | 8);
                                }
                                Memory.real_writeb(64, 137, temp);
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            case 50: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                Log.log(4, 2, "Function 12:Call " + Integer.toString(CPU_Regs.reg_ebx.low(), 16) + " not handled");
                                if (Dosbox.svgaCard == 2) {
                                    CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() & 1);
                                }
                                if (CPU_Regs.reg_eax.low() > 1) {
                                    CPU_Regs.reg_eax.low(0);
                                    break;
                                }
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            case 51: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                if (Dosbox.svgaCard == 2) {
                                    CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() & 1);
                                }
                                if (CPU_Regs.reg_eax.low() > 1) {
                                    CPU_Regs.reg_eax.low(0);
                                    break;
                                }
                                short temp = (short)(Memory.real_readb(64, 137) & 0xFD);
                                if ((CPU_Regs.reg_eax.low() & 1) == 0) {
                                    temp = (short)(temp | 2);
                                }
                                Memory.real_writeb(64, 137, temp);
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            case 52: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                if (Dosbox.svgaCard == 2) {
                                    CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() & 1);
                                }
                                if (CPU_Regs.reg_eax.low() > 1) {
                                    CPU_Regs.reg_eax.low(0);
                                    break;
                                }
                                short temp = (short)(Memory.real_readb(64, 135) & 0xFE);
                                Memory.real_writeb(64, 135, temp | CPU_Regs.reg_eax.low());
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            case 53: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                Log.log(4, 2, "Function 12:Call " + Integer.toString(CPU_Regs.reg_ebx.low(), 16) + " not handled");
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            case 54: {
                                if (!Dosbox.IS_VGA_ARCH()) break;
                                if (Dosbox.svgaCard == 1 && CPU_Regs.reg_eax.low() > 1) {
                                    CPU_Regs.reg_eax.low(0);
                                    break;
                                }
                                IoHandler.IO_Write(964, 1);
                                short clocking = IoHandler.IO_Read(965);
                                clocking = CPU_Regs.reg_eax.low() == 0 ? (short)(clocking & 0xFFFFFFDF) : (short)(clocking | 0x20);
                                IoHandler.IO_Write(964, 1);
                                IoHandler.IO_Write(965, clocking);
                                CPU_Regs.reg_eax.low(18);
                                break;
                            }
                            default: {
                                Log.log(4, 2, "Function 12:Call " + Integer.toString(CPU_Regs.reg_ebx.low(), 16) + " not handled");
                                if (Dosbox.machine == 4) break block0;
                                CPU_Regs.reg_eax.low(0);
                                break;
                            }
                        }
                        break;
                    }
                    case 19: {
                        Int10_char.INT10_WriteString(CPU_Regs.reg_edx.high(), CPU_Regs.reg_edx.low(), CPU_Regs.reg_eax.low(), CPU_Regs.reg_ebx.low(), CPU.Segs_ESphys + CPU_Regs.reg_ebp.word(), CPU_Regs.reg_ecx.word(), CPU_Regs.reg_ebx.high());
                        break;
                    }
                    case 26: {
                        int dcctable;
                        int entries;
                        if (!Dosbox.IS_VGA_ARCH()) break;
                        if (CPU_Regs.reg_eax.low() == 0) {
                            int vsavept = Memory.real_readd(64, 168);
                            int svstable = Memory.real_readd(Memory.RealSeg(vsavept), Memory.RealOff(vsavept) + 16);
                            if (svstable != 0) {
                                int dcctable2 = Memory.real_readd(Memory.RealSeg(svstable), Memory.RealOff(svstable) + 2);
                                short entries2 = Memory.real_readb(Memory.RealSeg(dcctable2), Memory.RealOff(dcctable2) + 0);
                                short idx = Memory.real_readb(64, 138);
                                if (idx < entries2) {
                                    int dccentry = Memory.real_readw(Memory.RealSeg(dcctable2), Memory.RealOff(dcctable2) + 4 + idx * 2);
                                    if ((dccentry & 0xFF) == 0) {
                                        CPU_Regs.reg_ebx.word(dccentry >> 8);
                                    } else {
                                        CPU_Regs.reg_ebx.word(dccentry);
                                    }
                                } else {
                                    CPU_Regs.reg_ebx.word(65535);
                                }
                            } else {
                                CPU_Regs.reg_ebx.word(65535);
                            }
                            CPU_Regs.reg_eax.word(26);
                            break;
                        }
                        if (CPU_Regs.reg_eax.low() != 1) break;
                        int newidx = 255;
                        int vsavept = Memory.real_readd(64, 168);
                        int svstable = Memory.real_readd(Memory.RealSeg(vsavept), Memory.RealOff(vsavept) + 16);
                        if (svstable != 0 && (entries = Memory.real_readb(Memory.RealSeg(dcctable = Memory.real_readd(Memory.RealSeg(svstable), Memory.RealOff(svstable) + 2)), Memory.RealOff(dcctable) + 0)) != 0) {
                            int swpidx = CPU_Regs.reg_ebx.high() | CPU_Regs.reg_ebx.low() << 8;
                            for (int ct = 0; ct < entries; ++ct) {
                                int dccentry = Memory.real_readw(Memory.RealSeg(dcctable), Memory.RealOff(dcctable) + 4 + ct * 2);
                                if (dccentry != CPU_Regs.reg_ebx.word() && dccentry != swpidx) continue;
                                newidx = (short)ct;
                                break;
                            }
                        }
                        Memory.real_writeb(64, 138, newidx);
                        CPU_Regs.reg_eax.word(26);
                        break;
                    }
                    case 27: {
                        if (!Dosbox.IS_VGA_ARCH()) break;
                        switch (CPU_Regs.reg_ebx.word()) {
                            case 0: {
                                Int10_misc.INT10_GetFuncStateInformation(CPU.Segs_ESphys + CPU_Regs.reg_edi.word());
                                CPU_Regs.reg_eax.low(27);
                                break block0;
                            }
                        }
                        Log.log(4, 2, "1B:Unhandled call BX " + Integer.toString(CPU_Regs.reg_ebx.word(), 16));
                        CPU_Regs.reg_eax.low(0);
                        break;
                    }
                    case 28: {
                        if (!Dosbox.IS_VGA_ARCH()) break;
                        switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                int ret = Int10_video_state.INT10_VideoState_GetSize(CPU_Regs.reg_ecx.word());
                                if (ret != 0) {
                                    CPU_Regs.reg_eax.low(28);
                                    CPU_Regs.reg_ebx.word(ret);
                                    break block0;
                                }
                                CPU_Regs.reg_eax.low(0);
                                break block0;
                            }
                            case 1: {
                                if (Int10_video_state.INT10_VideoState_Save(CPU_Regs.reg_ecx.word(), Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word()))) {
                                    CPU_Regs.reg_eax.low(28);
                                    break block0;
                                }
                                CPU_Regs.reg_eax.low(0);
                                break block0;
                            }
                            case 2: {
                                if (Int10_video_state.INT10_VideoState_Restore(CPU_Regs.reg_ecx.word(), Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word()))) {
                                    CPU_Regs.reg_eax.low(28);
                                    break block0;
                                }
                                CPU_Regs.reg_eax.low(0);
                                break block0;
                            }
                        }
                        if (Dosbox.svgaCard == 2) {
                            CPU_Regs.reg_eax.word(0);
                            break;
                        }
                        CPU_Regs.reg_eax.low(0);
                        break;
                    }
                    case 79: {
                        if (!Dosbox.IS_VGA_ARCH() || Dosbox.svgaCard != 1) break;
                        switch ((short)(CPU_Regs.reg_eax.low() & 0xFF)) {
                            case 0: {
                                CPU_Regs.reg_eax.low(79);
                                CPU_Regs.reg_eax.high(Int10_vesa.VESA_GetSVGAInformation(CPU.Segs_ESval, CPU_Regs.reg_edi.word()));
                                break block0;
                            }
                            case 1: {
                                CPU_Regs.reg_eax.low(79);
                                CPU_Regs.reg_eax.high(Int10_vesa.VESA_GetSVGAModeInformation(CPU_Regs.reg_ecx.word(), CPU.Segs_ESval, CPU_Regs.reg_edi.word()));
                                break block0;
                            }
                            case 2: {
                                CPU_Regs.reg_eax.low(79);
                                CPU_Regs.reg_eax.high(Int10_vesa.VESA_SetSVGAMode(CPU_Regs.reg_ebx.word()));
                                break block0;
                            }
                            case 3: {
                                CPU_Regs.reg_eax.low(79);
                                CPU_Regs.reg_ebx.word(Int10_vesa.VESA_GetSVGAMode());
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 4: {
                                CPU_Regs.reg_eax.low(79);
                                switch (CPU_Regs.reg_edx.low()) {
                                    case 0: {
                                        int ret = Int10_video_state.INT10_VideoState_GetSize(CPU_Regs.reg_ecx.word());
                                        if (ret != 0) {
                                            CPU_Regs.reg_eax.high(0);
                                            CPU_Regs.reg_ebx.word(ret);
                                            break block0;
                                        }
                                        CPU_Regs.reg_eax.high(1);
                                        break block0;
                                    }
                                    case 1: {
                                        if (Int10_video_state.INT10_VideoState_Save(CPU_Regs.reg_ecx.word(), Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word()))) {
                                            CPU_Regs.reg_eax.high(0);
                                            break block0;
                                        }
                                        CPU_Regs.reg_eax.high(1);
                                        break block0;
                                    }
                                    case 2: {
                                        if (Int10_video_state.INT10_VideoState_Restore(CPU_Regs.reg_ecx.word(), Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_ebx.word()))) {
                                            CPU_Regs.reg_eax.high(0);
                                            break block0;
                                        }
                                        CPU_Regs.reg_eax.high(1);
                                        break block0;
                                    }
                                }
                                CPU_Regs.reg_eax.high(1);
                                break block0;
                            }
                            case 5: {
                                if (CPU_Regs.reg_ebx.high() == 0) {
                                    CPU_Regs.reg_eax.high(Int10_vesa.VESA_SetCPUWindow(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_edx.low()));
                                    CPU_Regs.reg_eax.low(79);
                                    break block0;
                                }
                                if (CPU_Regs.reg_ebx.high() == 1) {
                                    CPU_Regs.reg_edx.word(Int10_vesa.VESA_GetCPUWindow(CPU_Regs.reg_ebx.low()));
                                    CPU_Regs.reg_eax.high(0);
                                    CPU_Regs.reg_eax.low(79);
                                    break block0;
                                }
                                Log.log(4, 2, "Unhandled VESA Function " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_ebx.high(), 16));
                                CPU_Regs.reg_eax.high(1);
                                break block0;
                            }
                            case 6: {
                                IntRef bx = new IntRef(CPU_Regs.reg_ebx.word());
                                IntRef cx = new IntRef(CPU_Regs.reg_ecx.word());
                                IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                                CPU_Regs.reg_eax.low(79);
                                CPU_Regs.reg_eax.high(Int10_vesa.VESA_ScanLineLength(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ecx.word(), bx, cx, dx));
                                CPU_Regs.reg_ebx.word(bx.value);
                                CPU_Regs.reg_ecx.word(cx.value);
                                CPU_Regs.reg_edx.word(dx.value);
                                break block0;
                            }
                            case 7: {
                                switch ((short)(CPU_Regs.reg_ebx.low() & 0xFF)) {
                                    case 0: 
                                    case 128: {
                                        CPU_Regs.reg_eax.low(79);
                                        CPU_Regs.reg_eax.high(Int10_vesa.VESA_SetDisplayStart(CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word()));
                                        break block0;
                                    }
                                    case 1: {
                                        IntRef cx = new IntRef(CPU_Regs.reg_ecx.word());
                                        IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                                        CPU_Regs.reg_eax.low(79);
                                        CPU_Regs.reg_ebx.high(0);
                                        CPU_Regs.reg_eax.high(Int10_vesa.VESA_GetDisplayStart(cx, dx));
                                        CPU_Regs.reg_ecx.word(cx.value);
                                        CPU_Regs.reg_edx.word(dx.value);
                                        break block0;
                                    }
                                }
                                Log.log(4, 2, "Unhandled VESA Function " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_ebx.low(), 16));
                                CPU_Regs.reg_eax.high(1);
                                break block0;
                            }
                            case 9: {
                                switch ((short)(CPU_Regs.reg_ebx.low() & 0xFF)) {
                                    case 0: 
                                    case 128: {
                                        CPU_Regs.reg_eax.high(Int10_vesa.VESA_SetPalette(CPU.Segs_ESphys + CPU_Regs.reg_edi.word(), CPU_Regs.reg_edx.word(), CPU_Regs.reg_ecx.word()));
                                        CPU_Regs.reg_eax.low(79);
                                        break block0;
                                    }
                                    case 1: {
                                        CPU_Regs.reg_eax.high(Int10_vesa.VESA_GetPalette(CPU.Segs_ESphys + CPU_Regs.reg_edi.word(), CPU_Regs.reg_edx.word(), CPU_Regs.reg_ecx.word()));
                                        CPU_Regs.reg_eax.low(79);
                                        break block0;
                                    }
                                }
                                Log.log(4, 2, "Unhandled VESA Function " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_ebx.low(), 16));
                                CPU_Regs.reg_eax.high(1);
                                break block0;
                            }
                            case 10: {
                                if (Int10.int10.vesa_oldvbe) {
                                    CPU_Regs.reg_eax.word(335);
                                    break block0;
                                }
                                switch (CPU_Regs.reg_ebx.low()) {
                                    case 0: {
                                        CPU_Regs.reg_edi.dword = Memory.RealOff(Int10.int10.rom.pmode_interface);
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.pmode_interface));
                                        CPU_Regs.reg_ecx.word(Int10.int10.rom.pmode_interface_size);
                                        CPU_Regs.reg_eax.word(79);
                                        break block0;
                                    }
                                    case 1: {
                                        CPU_Regs.reg_edi.dword = Memory.RealOff(Int10.int10.rom.pmode_interface) + Int10.int10.rom.pmode_interface_window;
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.pmode_interface));
                                        CPU_Regs.reg_ecx.word(16);
                                        CPU_Regs.reg_eax.word(79);
                                        break block0;
                                    }
                                    case 2: {
                                        CPU_Regs.reg_edi.dword = Memory.RealOff(Int10.int10.rom.pmode_interface) + Int10.int10.rom.pmode_interface_start;
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.pmode_interface));
                                        CPU_Regs.reg_ecx.word(16);
                                        CPU_Regs.reg_eax.word(79);
                                        break block0;
                                    }
                                    case 3: {
                                        CPU_Regs.reg_edi.dword = Memory.RealOff(Int10.int10.rom.pmode_interface) + Int10.int10.rom.pmode_interface_palette;
                                        CPU_Regs.SegSet16ES(Memory.RealSeg(Int10.int10.rom.pmode_interface));
                                        CPU_Regs.reg_ecx.word(16);
                                        CPU_Regs.reg_eax.word(79);
                                        break block0;
                                    }
                                }
                                CPU_Regs.reg_eax.word(335);
                                break block0;
                            }
                        }
                        Log.log(4, 2, "Unhandled VESA Function " + Integer.toString(CPU_Regs.reg_eax.low(), 16));
                        CPU_Regs.reg_eax.low(0);
                        break;
                    }
                    case 240: {
                        CPU_Regs.reg_ebx.low(Int10_misc.INT10_EGA_RIL_ReadRegister(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 241: {
                        CPU_Regs.reg_ebx.low(Int10_misc.INT10_EGA_RIL_WriteRegister(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_ebx.high(), CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 242: {
                        Int10_misc.INT10_EGA_RIL_ReadRegisterRange(CPU_Regs.reg_ecx.high(), CPU_Regs.reg_ecx.low(), CPU_Regs.reg_edx.word(), CPU.Segs_ESphys + CPU_Regs.reg_ebx.word());
                        break;
                    }
                    case 243: {
                        Int10_misc.INT10_EGA_RIL_WriteRegisterRange(CPU_Regs.reg_ecx.high(), CPU_Regs.reg_ecx.low(), CPU_Regs.reg_edx.word(), CPU.Segs_ESphys + CPU_Regs.reg_ebx.word());
                        break;
                    }
                    case 244: {
                        Int10_misc.INT10_EGA_RIL_ReadRegisterSet(CPU_Regs.reg_ecx.word(), CPU.Segs_ESphys + CPU_Regs.reg_ebx.word());
                        break;
                    }
                    case 245: {
                        Int10_misc.INT10_EGA_RIL_WriteRegisterSet(CPU_Regs.reg_ecx.word(), CPU.Segs_ESphys + CPU_Regs.reg_ebx.word());
                        break;
                    }
                    case 250: {
                        int pt = Int10_misc.INT10_EGA_RIL_GetVersionPt();
                        CPU_Regs.SegSet16ES(Memory.RealSeg(pt));
                        CPU_Regs.reg_ebx.word(Memory.RealOff(pt));
                        break;
                    }
                    case 255: {
                        if (!warned_ff) {
                            Log.log(4, 0, "INT10:FF:Weird NC call");
                        }
                        warned_ff = true;
                        break;
                    }
                    default: {
                        Log.log(4, 2, "Function " + Integer.toString(CPU_Regs.reg_eax.word(), 16) + " not supported");
                    }
                }
                return 0;
            }
        };
        INT10_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                int10 = null;
            }
        };
        INT10_Init = new Section.SectionFunction(){

            public void call(Section section) {
                System.out.println("INT10_Init");
                Int10.INT10_InitVGA();
                if (Dosbox.IS_TANDY_ARCH()) {
                    Int10.SetupTandyBios();
                }
                call_10 = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_10, INT10_Handler, 3, "Int 10 video");
                Memory.RealSetVec(16, Callback.CALLBACK_RealPointer(call_10));
                Int10_memory.INT10_SetupRomMemory();
                Int10.INT10_Seg40Init();
                Int10_vesa.INT10_SetupVESA();
                Int10_memory.INT10_SetupRomMemoryChecksum();
                Int10_modes.INT10_SetVideoMode(3);
                section.AddDestroyFunction(INT10_Destroy, false);
            }
        };
    }

    public static class Int10Data {
        public Rom rom = new Rom();
        public int vesa_setmode;
        public boolean vesa_nolfb;
        public boolean vesa_oldvbe;

        public static class Rom {
            int font_8_first;
            int font_8_second;
            int font_14;
            int font_16;
            int font_14_alternate;
            int font_16_alternate;
            int static_state;
            int video_save_pointers;
            int video_parameter_table;
            int video_save_pointer_table;
            int video_dcc_table;
            int oemstring;
            int vesa_modes;
            int pmode_interface;
            int pmode_interface_size;
            int pmode_interface_start;
            int pmode_interface_window;
            int pmode_interface_palette;
            int used;
        }
    }

    public static class VideoModeBlock {
        int mode;
        int type;
        int swidth;
        int sheight;
        int twidth;
        int theight;
        int cwidth;
        int cheight;
        int ptotal;
        int pstart;
        int plength;
        int htotal;
        int vtotal;
        int hdispend;
        int vdispend;
        int special;

        public VideoModeBlock(int mode, int type, int swidth, int sheight, int twidth, int theight, int cwidth, int cheight, int ptotal, int pstart, int plength, int htotal, int vtotal, int hdispend, int vdispend, int special) {
            this.mode = mode;
            this.type = type;
            this.swidth = swidth;
            this.sheight = sheight;
            this.twidth = twidth;
            this.theight = theight;
            this.cwidth = cwidth;
            this.cheight = cheight;
            this.ptotal = ptotal;
            this.pstart = pstart;
            this.plength = plength;
            this.htotal = htotal;
            this.vtotal = vtotal;
            this.hdispend = hdispend;
            this.vdispend = vdispend;
            this.special = special;
        }
    }
}

