/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Int10;
import jdos.ints.Int10_modes;
import jdos.ints.Int10_put_pixel;
import jdos.misc.Log;

public class Int10_char {
    private static boolean warned_use = false;

    static void CGA2_CopyRow(short cleft, short cright, short rold, short rnew, int base) {
        short cheight = Memory.real_readb(64, 133);
        int dest = base + (Int10_modes.CurMode.twidth * rnew * (cheight / 2) + cleft);
        int src = base + (Int10_modes.CurMode.twidth * rold * (cheight / 2) + cleft);
        int copy = cright - cleft;
        int nextline = Int10_modes.CurMode.twidth;
        for (int i = 0; i < cheight / 2; ++i) {
            Memory.MEM_BlockCopy(dest, src, copy);
            Memory.MEM_BlockCopy(dest + 8192, src + 8192, copy);
            dest += nextline;
            src += nextline;
        }
    }

    static void CGA4_CopyRow(short cleft, short cright, short rold, short rnew, int base) {
        short cheight = Memory.real_readb(64, 133);
        int dest = base + (Int10_modes.CurMode.twidth * rnew * (cheight / 2) + cleft) * 2;
        int src = base + (Int10_modes.CurMode.twidth * rold * (cheight / 2) + cleft) * 2;
        int copy = (cright - cleft) * 2;
        int nextline = Int10_modes.CurMode.twidth * 2;
        for (int i = 0; i < cheight / 2; ++i) {
            Memory.MEM_BlockCopy(dest, src, copy);
            Memory.MEM_BlockCopy(dest + 8192, src + 8192, copy);
            dest += nextline;
            src += nextline;
        }
    }

    static void TANDY16_CopyRow(short cleft, short cright, short rold, short rnew, int base) {
        short cheight = Memory.real_readb(64, 133);
        int dest = base + (Int10_modes.CurMode.twidth * rnew * (cheight / 4) + cleft) * 4;
        int src = base + (Int10_modes.CurMode.twidth * rold * (cheight / 4) + cleft) * 4;
        int copy = (cright - cleft) * 4;
        int nextline = Int10_modes.CurMode.twidth * 4;
        for (int i = 0; i < cheight / 4; ++i) {
            Memory.MEM_BlockCopy(dest, src, copy);
            Memory.MEM_BlockCopy(dest + 8192, src + 8192, copy);
            Memory.MEM_BlockCopy(dest + 16384, src + 16384, copy);
            Memory.MEM_BlockCopy(dest + 24576, src + 24576, copy);
            dest += nextline;
            src += nextline;
        }
    }

    static void EGA16_CopyRow(short cleft, short cright, short rold, short rnew, int base) {
        int cheight = Memory.real_readb(64, 133);
        int dest = base + Int10_modes.CurMode.twidth * rnew * cheight + cleft;
        int src = base + Int10_modes.CurMode.twidth * rold * cheight + cleft;
        int nextline = Int10_modes.CurMode.twidth;
        IoHandler.IO_Write(974, 5);
        IoHandler.IO_Write(975, 1);
        IoHandler.IO_Write(964, 2);
        IoHandler.IO_Write(965, 15);
        int rowsize = cright - cleft;
        for (int copy = cheight; copy > 0; --copy) {
            for (int x = 0; x < rowsize; ++x) {
                Memory.mem_writeb(dest + x, Memory.mem_readb(src + x));
            }
            dest += nextline;
            src += nextline;
        }
        IoHandler.IO_Write(974, 5);
        IoHandler.IO_Write(975, 0);
    }

    static void VGA_CopyRow(short cleft, short cright, short rold, short rnew, int base) {
        int cheight = Memory.real_readb(64, 133);
        int dest = base + 8 * (Int10_modes.CurMode.twidth * rnew * cheight + cleft);
        int src = base + 8 * (Int10_modes.CurMode.twidth * rold * cheight + cleft);
        int nextline = 8 * Int10_modes.CurMode.twidth;
        int rowsize = 8 * (cright - cleft);
        for (int copy = cheight; copy > 0; --copy) {
            for (int x = 0; x < rowsize; ++x) {
                Memory.mem_writeb(dest + x, Memory.mem_readb(src + x));
            }
            dest += nextline;
            src += nextline;
        }
    }

    static void TEXT_CopyRow(short cleft, short cright, short rold, short rnew, int base) {
        int src = base + (rold * Int10_modes.CurMode.twidth + cleft) * 2;
        int dest = base + (rnew * Int10_modes.CurMode.twidth + cleft) * 2;
        Memory.MEM_BlockCopy(dest, src, (cright - cleft) * 2);
    }

    static void CGA2_FillRow(short cleft, short cright, short row, int base, short attr) {
        short cheight = Memory.real_readb(64, 133);
        int dest = base + (Int10_modes.CurMode.twidth * row * (cheight / 2) + cleft);
        int copy = cright - cleft;
        int nextline = Int10_modes.CurMode.twidth;
        attr = (short)(attr & 3 | (attr & 3) << 2 | (attr & 3) << 4 | (attr & 3) << 6);
        for (int i = 0; i < cheight / 2; ++i) {
            for (int x = 0; x < copy; ++x) {
                Memory.mem_writeb(dest + x, attr);
                Memory.mem_writeb(dest + 8192 + x, attr);
            }
            dest += nextline;
        }
    }

    static void CGA4_FillRow(short cleft, short cright, short row, int base, short attr) {
        short cheight = Memory.real_readb(64, 133);
        int dest = base + (Int10_modes.CurMode.twidth * row * (cheight / 2) + cleft) * 2;
        int copy = (cright - cleft) * 2;
        int nextline = Int10_modes.CurMode.twidth * 2;
        attr = (short)(attr & 3 | (attr & 3) << 2 | (attr & 3) << 4 | (attr & 3) << 6);
        for (int i = 0; i < cheight / 2; ++i) {
            for (int x = 0; x < copy; ++x) {
                Memory.mem_writeb(dest + x, attr);
                Memory.mem_writeb(dest + 8192 + x, attr);
            }
            dest += nextline;
        }
    }

    static void TANDY16_FillRow(short cleft, short cright, short row, int base, short attr) {
        short cheight = Memory.real_readb(64, 133);
        int dest = base + (Int10_modes.CurMode.twidth * row * (cheight / 4) + cleft) * 4;
        int copy = (cright - cleft) * 4;
        int nextline = Int10_modes.CurMode.twidth * 4;
        attr = (short)(attr & 0xF | (attr & 0xF) << 4);
        for (int i = 0; i < cheight / 4; ++i) {
            for (int x = 0; x < copy; ++x) {
                Memory.mem_writeb(dest + x, attr);
                Memory.mem_writeb(dest + 8192 + x, attr);
                Memory.mem_writeb(dest + 16384 + x, attr);
                Memory.mem_writeb(dest + 24576 + x, attr);
            }
            dest += nextline;
        }
    }

    static void EGA16_FillRow(short cleft, short cright, short row, int base, short attr) {
        IoHandler.IO_Write(974, 8);
        IoHandler.IO_Write(975, 255);
        IoHandler.IO_Write(974, 0);
        IoHandler.IO_Write(975, attr);
        IoHandler.IO_Write(974, 1);
        IoHandler.IO_Write(975, 15);
        int cheight = Memory.real_readb(64, 133);
        int dest = base + Int10_modes.CurMode.twidth * row * cheight + cleft;
        int nextline = Int10_modes.CurMode.twidth;
        int rowsize = cright - cleft;
        for (int copy = cheight; copy > 0; --copy) {
            for (int x = 0; x < rowsize; ++x) {
                Memory.mem_writeb(dest + x, 255);
            }
            dest += nextline;
        }
        IoHandler.IO_Write(975, 0);
    }

    static void VGA_FillRow(short cleft, short cright, short row, int base, short attr) {
        int cheight = Memory.real_readb(64, 133);
        int dest = base + 8 * (Int10_modes.CurMode.twidth * row * cheight + cleft);
        int nextline = 8 * Int10_modes.CurMode.twidth;
        int rowsize = 8 * (cright - cleft);
        for (int copy = cheight; copy > 0; --copy) {
            for (int x = 0; x < rowsize; ++x) {
                Memory.mem_writeb(dest + x, attr);
            }
            dest += nextline;
        }
    }

    static void TEXT_FillRow(short cleft, short cright, short row, int base, short attr) {
        int dest = base + (row * Int10_modes.CurMode.twidth + cleft) * 2;
        int fill = (attr << 8) + 32;
        for (int x = 0; x < cright - cleft; x = (int)((short)(x + 1))) {
            Memory.mem_writew(dest, fill);
            dest += 2;
        }
    }

    public static void INT10_ScrollWindow(short rul, short cul, short rlr, short clr, byte nlines, short attr, short page) {
        if (Int10_modes.CurMode.type != 9) {
            page = (short)255;
        }
        int ncols = Memory.real_readw(64, 74);
        int nrows = Memory.real_readb(64, 132) + 1;
        if (rul > rlr) {
            return;
        }
        if (cul > clr) {
            return;
        }
        if (rlr >= nrows) {
            rlr = (short)(nrows - 1);
        }
        if (clr >= ncols) {
            clr = (short)(ncols - 1);
        }
        clr = (short)(clr + 1);
        if (page == 255) {
            page = Memory.real_readb(64, 98);
        }
        int base = Int10_modes.CurMode.pstart + page * Memory.real_readw(64, 76);
        int start = 0;
        short end = 0;
        int next = 0;
        boolean gotofilling = false;
        if (nlines > 0) {
            start = rlr - nlines + 1;
            end = rul;
            next = -1;
        } else if (nlines < 0) {
            start = rul - nlines - 1;
            end = rlr;
            next = 1;
        } else {
            nlines = (byte)(rlr - rul + 1);
            gotofilling = true;
        }
        if (!gotofilling) {
            block18: while (start != end) {
                start += next;
                switch (Int10_modes.CurMode.type) {
                    case 9: {
                        Int10_char.TEXT_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                    case 0: {
                        Int10_char.CGA2_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                    case 1: {
                        Int10_char.CGA4_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                    case 15: {
                        Int10_char.TANDY16_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                    case 2: {
                        Int10_char.EGA16_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                    case 3: {
                        Int10_char.VGA_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                    case 4: {
                        if (Dosbox.machine != 5 || Dosbox.svgaCard != 2 || Int10_modes.CurMode.swidth > 800) break;
                        Int10_char.EGA16_CopyRow(cul, clr, (short)start, (short)(start + nlines), base);
                        continue block18;
                    }
                }
                Log.log(4, 2, "Unhandled mode " + Int10_modes.CurMode.type + " for scroll");
            }
        }
        if (nlines > 0) {
            start = rul;
        } else {
            nlines = -nlines;
            start = rlr - nlines + 1;
        }
        while (nlines > 0) {
            switch (Int10_modes.CurMode.type) {
                case 9: {
                    Int10_char.TEXT_FillRow(cul, clr, (short)start, base, attr);
                    break;
                }
                case 0: {
                    Int10_char.CGA2_FillRow(cul, clr, (short)start, base, attr);
                    break;
                }
                case 1: {
                    Int10_char.CGA4_FillRow(cul, clr, (short)start, base, attr);
                    break;
                }
                case 15: {
                    Int10_char.TANDY16_FillRow(cul, clr, (short)start, base, attr);
                    break;
                }
                case 2: {
                    Int10_char.EGA16_FillRow(cul, clr, (short)start, base, attr);
                    break;
                }
                case 3: {
                    Int10_char.VGA_FillRow(cul, clr, (short)start, base, attr);
                    break;
                }
                case 4: {
                    if (Dosbox.machine == 5 && Dosbox.svgaCard == 2 && Int10_modes.CurMode.swidth <= 800) {
                        Int10_char.EGA16_FillRow(cul, clr, (short)start, base, attr);
                        break;
                    }
                }
                default: {
                    Log.log(4, 2, "Unhandled mode " + Int10_modes.CurMode.type + " for scroll");
                }
            }
            ++start;
            nlines = (byte)(nlines - 1);
        }
    }

    public static void INT10_SetActivePage(short page) {
        if (page > 7) {
            Log.log(4, 2, "INT10_SetActivePage page " + page);
        }
        if (Dosbox.IS_EGAVGA_ARCH() && Dosbox.svgaCard == 1) {
            page = (short)(page & 7);
        }
        int mem_address = page * Memory.real_readw(64, 76);
        Memory.real_writew(64, 78, mem_address);
        if (Dosbox.IS_EGAVGA_ARCH()) {
            if (Int10_modes.CurMode.mode < 8) {
                mem_address >>= 1;
            }
        } else {
            mem_address >>= 1;
        }
        int base = Memory.real_readw(64, 99);
        IoHandler.IO_Write(base, 12);
        IoHandler.IO_Write(base + 1, mem_address >> 8);
        IoHandler.IO_Write(base, 13);
        IoHandler.IO_Write(base + 1, mem_address);
        Memory.real_writeb(64, 98, page);
        short cur_row = Int10.CURSOR_POS_ROW(page);
        short cur_col = Int10.CURSOR_POS_COL(page);
        Int10_char.INT10_SetCursorPos(cur_row, cur_col, page);
    }

    private static void dowrite(short first, short last) {
        int base = Memory.real_readw(64, 99);
        IoHandler.IO_Write(base, 10);
        IoHandler.IO_Write(base + 1, first);
        IoHandler.IO_Write(base, 11);
        IoHandler.IO_Write(base + 1, last);
    }

    public static void INT10_SetCursorShape(short first, short last) {
        Memory.real_writew(64, 96, last | first << 8);
        if (Dosbox.machine == 1) {
            Int10_char.dowrite(first, last);
            return;
        }
        if (Dosbox.IS_TANDY_ARCH()) {
            Int10_char.dowrite(first, last);
            return;
        }
        if ((Memory.real_readb(64, 135) & 8) == 0) {
            if ((first & 0x60) == 32) {
                first = (short)30;
                last = 0;
                Int10_char.dowrite(first, last);
                return;
            }
            if ((Memory.real_readb(64, 135) & 1) == 0) {
                if ((first & 0xE0) != 0 || (last & 0xE0) != 0) {
                    Int10_char.dowrite(first, last);
                    return;
                }
                short cheight = (short)(Memory.real_readb(64, 133) - 1);
                if (last < first) {
                    if (last == 0) {
                        Int10_char.dowrite(first, last);
                        return;
                    }
                    first = last;
                    last = cheight;
                } else if ((first | last) >= cheight || last != cheight - 1 || first != cheight) {
                    if (last <= 3) {
                        Int10_char.dowrite(first, last);
                        return;
                    }
                    if (first + 2 < last) {
                        if (first > 2) {
                            first = (short)((cheight + 1) / 2);
                            last = cheight;
                        } else {
                            last = cheight;
                        }
                    } else {
                        first = (short)(first - last + cheight);
                        last = cheight;
                        if (cheight > 12) {
                            first = (short)(first - 1);
                            last = (short)(last - 1);
                        }
                    }
                }
            }
        }
        Int10_char.dowrite(first, last);
    }

    public static void INT10_SetCursorPos(short row, short col, short page) {
        if (page > 7) {
            Log.log(4, 2, "INT10_SetCursorPos page " + page);
        }
        Memory.real_writeb(64, 80 + page * 2, col);
        Memory.real_writeb(64, 80 + page * 2 + 1, row);
        short current = Memory.real_readb(64, 98);
        if (page == current) {
            int ncols = Memory.real_readw(64, 74);
            int address = ncols * row + col + Memory.real_readw(64, 78) / 2;
            int base = Memory.real_readw(64, 99);
            IoHandler.IO_Write(base, 14);
            IoHandler.IO_Write(base + 1, address >> 8);
            IoHandler.IO_Write(base, 15);
            IoHandler.IO_Write(base + 1, address);
        }
    }

    public static int ReadCharAttr(int col, int row, short page) {
        short cheight = Memory.real_readb(64, 133);
        boolean split_chr = false;
        switch (Int10_modes.CurMode.type) {
            case 9: {
                int address = page * Memory.real_readw(64, 76);
                int where = Int10_modes.CurMode.pstart + (address += (row * Memory.real_readw(64, 74) + col) * 2);
                return Memory.mem_readw(where);
            }
            case 0: 
            case 1: 
            case 15: {
                split_chr = true;
            }
        }
        for (int chr = 0; chr <= 255; ++chr) {
            int fontdata = !split_chr || chr < 128 ? Memory.Real2Phys(Memory.RealGetVec(67)) + chr * cheight : Memory.Real2Phys(Memory.RealGetVec(31)) + (chr - 128) * cheight;
            int x = 8 * col;
            int y = cheight * row;
            boolean error = false;
            for (short h = 0; h < cheight; h = (short)(h + 1)) {
                short bitline = Memory.mem_readb(fontdata++);
                short res = 0;
                short vidline = 0;
                int tx = x;
                for (int bitsel = 128; bitsel != 0; bitsel = (int)((short)(bitsel >> 1))) {
                    res = Int10_put_pixel.INT10_GetPixel(tx, y, page);
                    if (res != 0) {
                        vidline = (short)(vidline | bitsel);
                    }
                    ++tx;
                }
                ++y;
                if (bitline == vidline) continue;
                error = true;
                break;
            }
            if (error) continue;
            return chr;
        }
        Log.log(4, 2, "ReadChar didn't find character");
        return 0;
    }

    public static int INT10_ReadCharAttr(short page) {
        if (page == 255) {
            page = Memory.real_readb(64, 98);
        }
        short cur_row = Int10.CURSOR_POS_ROW(page);
        short cur_col = Int10.CURSOR_POS_COL(page);
        return Int10_char.ReadCharAttr(cur_col, cur_row, page);
    }

    public static void WriteChar(int col, int row, short page, short chr, short attr, boolean useattr) {
        int fontdata;
        short cheight = Memory.real_readb(64, 133);
        switch (Int10_modes.CurMode.type) {
            case 9: {
                int address = page * Memory.real_readw(64, 76);
                int where = Int10_modes.CurMode.pstart + (address += (row * Memory.real_readw(64, 74) + col) * 2);
                Memory.mem_writeb(where, chr);
                if (useattr) {
                    Memory.mem_writeb(where + 1, attr);
                }
                return;
            }
            case 0: 
            case 1: 
            case 15: {
                if (chr < 128) {
                    fontdata = Memory.RealGetVec(67);
                } else {
                    chr = (short)(chr - 128);
                    fontdata = Memory.RealGetVec(31);
                }
                fontdata = Memory.RealMake(Memory.RealSeg(fontdata), Memory.RealOff(fontdata) + chr * cheight);
                break;
            }
            default: {
                fontdata = Memory.RealGetVec(67);
                fontdata = Memory.RealMake(Memory.RealSeg(fontdata), Memory.RealOff(fontdata) + chr * cheight);
            }
        }
        if (!useattr) {
            if (!warned_use) {
                Log.log(4, 2, "writechar used without attribute in non-textmode " + String.valueOf((char)chr) + " " + Integer.toString(chr, 16));
                warned_use = true;
            }
            switch (Int10_modes.CurMode.type) {
                case 1: {
                    attr = (short)3;
                    break;
                }
                case 0: {
                    attr = 1;
                    break;
                }
                default: {
                    attr = (short)15;
                }
            }
        }
        if (Int10_modes.CurMode.mode == 6) {
            attr = (short)(attr & 0x80 | 1);
        }
        int x = 8 * col;
        int y = cheight * row;
        short xor_mask = (short)(Int10_modes.CurMode.type == 3 ? 0 : 128);
        if (Int10_modes.CurMode.type == 2) {
            IoHandler.IO_Write(964, 2);
            IoHandler.IO_Write(965, 15);
        }
        for (short h = 0; h < cheight; h = (short)(h + 1)) {
            short bitline = Memory.mem_readb(Memory.Real2Phys(fontdata));
            fontdata = Memory.RealMake(Memory.RealSeg(fontdata), Memory.RealOff(fontdata) + 1);
            int tx = x;
            for (int bitsel = 128; bitsel != 0; bitsel = (int)((short)(bitsel >> 1))) {
                if ((bitline & bitsel) != 0) {
                    Int10_put_pixel.INT10_PutPixel(tx, y, page, attr);
                } else {
                    Int10_put_pixel.INT10_PutPixel(tx, y, page, (short)(attr & xor_mask));
                }
                ++tx;
            }
            ++y;
        }
    }

    public static void INT10_WriteChar(short chr, short attr, short page, int count, boolean showattr) {
        if (Int10_modes.CurMode.type != 9) {
            showattr = true;
            switch (Dosbox.machine) {
                case 4: 
                case 5: {
                    page = (short)(page % Int10_modes.CurMode.ptotal);
                    break;
                }
                case 1: 
                case 3: {
                    page = 0;
                }
            }
        }
        short cur_row = Int10.CURSOR_POS_ROW(page);
        short cur_col = Int10.CURSOR_POS_COL(page);
        int ncols = Memory.real_readw(64, 74);
        while (count > 0) {
            Int10_char.WriteChar(cur_col, cur_row, page, chr, attr, showattr);
            --count;
            if ((cur_col = (short)(cur_col + 1)) != ncols) continue;
            cur_col = 0;
            cur_row = (short)(cur_row + 1);
        }
    }

    static void INT10_TeletypeOutputAttr(short chr, short attr, boolean useattr, short page) {
        int ncols = Memory.real_readw(64, 74);
        int nrows = Memory.real_readb(64, 132) + 1;
        short cur_row = Int10.CURSOR_POS_ROW(page);
        short cur_col = Int10.CURSOR_POS_COL(page);
        switch (chr) {
            case 7: {
                break;
            }
            case 8: {
                if (cur_col <= 0) break;
                cur_col = (short)(cur_col - 1);
                break;
            }
            case 13: {
                cur_col = 0;
                break;
            }
            case 10: {
                cur_row = (short)(cur_row + 1);
                break;
            }
            case 9: {
                do {
                    Int10_char.INT10_TeletypeOutputAttr((short)32, attr, useattr, page);
                    cur_row = Int10.CURSOR_POS_ROW(page);
                } while ((cur_col = Int10.CURSOR_POS_COL(page)) % 8 != 0);
                break;
            }
            default: {
                Int10_char.WriteChar(cur_col, cur_row, page, chr, attr, useattr);
                cur_col = (short)(cur_col + 1);
            }
        }
        if (cur_col == ncols) {
            cur_col = 0;
            cur_row = (short)(cur_row + 1);
        }
        if (cur_row == nrows) {
            short fill = (short)(Int10_modes.CurMode.type == 9 ? 7 : 0);
            Int10_char.INT10_ScrollWindow((short)0, (short)0, (short)(nrows - 1), (short)(ncols - 1), (byte)-1, fill, page);
            cur_row = (short)(cur_row - 1);
        }
        Int10_char.INT10_SetCursorPos(cur_row, cur_col, page);
    }

    public static void INT10_TeletypeOutputAttr(int chr, int attr, boolean useattr) {
        Int10_char.INT10_TeletypeOutputAttr((short)chr, (short)attr, useattr, Memory.real_readb(64, 98));
    }

    public static void INT10_TeletypeOutput(int chr, int attr) {
        Int10_char.INT10_TeletypeOutputAttr((short)chr, (short)attr, Int10_modes.CurMode.type != 9);
    }

    public static void INT10_WriteString(short row, short col, short flag, short attr, int string, int count, short page) {
        short cur_row = Int10.CURSOR_POS_ROW(page);
        short cur_col = Int10.CURSOR_POS_COL(page);
        if (row == 255) {
            row = cur_row;
            col = cur_col;
        }
        Int10_char.INT10_SetCursorPos(row, col, page);
        while (count > 0) {
            short chr = Memory.mem_readb(string);
            ++string;
            if ((flag & 2) != 0) {
                attr = Memory.mem_readb(string);
                ++string;
            }
            Int10_char.INT10_TeletypeOutputAttr(chr, attr, true, page);
            --count;
        }
        if ((flag & 1) == 0) {
            Int10_char.INT10_SetCursorPos(cur_row, cur_col, page);
        }
    }
}

