/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Int10_modes;
import jdos.util.ShortRef;

public class Int10_pal {
    static final int ACTL_MAX_REG = 20;

    private static void ResetACTL() {
        IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
    }

    private static void WriteTandyACTL(short creg, short val) {
        IoHandler.IO_Write(986, (byte)creg);
        if (Dosbox.machine == 2) {
            IoHandler.IO_Write(990, (byte)val);
        } else {
            IoHandler.IO_Write(986, (byte)val);
        }
    }

    public static void INT10_SetSinglePaletteRegister(short reg, short val) {
        switch (Dosbox.machine) {
            case 2: 
            case 3: {
                IoHandler.IO_Read(986);
                Int10_pal.WriteTandyACTL((short)(reg + 16), val);
                break;
            }
            case 4: 
            case 5: {
                if (!Dosbox.IS_VGA_ARCH()) {
                    reg = (short)(reg & 0x1F);
                }
                if (reg <= 20) {
                    Int10_pal.ResetACTL();
                    IoHandler.IO_Write(960, (byte)reg);
                    IoHandler.IO_Write(960, (byte)val);
                }
                IoHandler.IO_Write(960, 32);
            }
        }
    }

    public static void INT10_SetOverscanBorderColor(short val) {
        switch (Dosbox.machine) {
            case 2: 
            case 3: {
                IoHandler.IO_Read(986);
                Int10_pal.WriteTandyACTL((short)2, val);
                break;
            }
            case 4: 
            case 5: {
                Int10_pal.ResetACTL();
                IoHandler.IO_Write(960, 17);
                IoHandler.IO_Write(960, (byte)val);
                IoHandler.IO_Write(960, 32);
            }
        }
    }

    public static void INT10_SetAllPaletteRegisters(int data) {
        switch (Dosbox.machine) {
            case 2: 
            case 3: {
                IoHandler.IO_Read(986);
                for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
                    Int10_pal.WriteTandyACTL((short)(i + 16), Memory.mem_readb(data));
                    ++data;
                }
                Int10_pal.WriteTandyACTL((short)2, Memory.mem_readb(data));
                break;
            }
            case 4: 
            case 5: {
                Int10_pal.ResetACTL();
                for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
                    IoHandler.IO_Write(960, (byte)i);
                    IoHandler.IO_Write(960, (byte)Memory.mem_readb(data));
                    ++data;
                }
                IoHandler.IO_Write(960, 17);
                IoHandler.IO_Write(960, (byte)Memory.mem_readb(data));
                IoHandler.IO_Write(960, 32);
            }
        }
    }

    public static void INT10_ToggleBlinkingBit(short state) {
        if (Dosbox.IS_VGA_ARCH()) {
            if (state > 1 && Dosbox.svgaCard == 1) {
                return;
            }
            Int10_pal.ResetACTL();
            IoHandler.IO_Write(960, 16);
            short value = IoHandler.IO_Read(961);
            if (state <= 1) {
                value = (short)(value & 0xF7);
                value = (short)(value | state << 3);
            }
            Int10_pal.ResetACTL();
            IoHandler.IO_Write(960, 16);
            IoHandler.IO_Write(960, value);
            IoHandler.IO_Write(960, 32);
            if (state <= 1) {
                short msrval = (short)(Memory.real_readb(64, 101) & 0xDF);
                if (state != 0) {
                    msrval = (short)(msrval | 0x20);
                }
                Memory.real_writeb(64, 101, msrval);
            }
        } else {
            if (Int10_modes.CurMode.type != 9) {
                return;
            }
            short value = (short)(Int10_modes.CurMode.cwidth == 9 ? 4 : 0);
            if (state != 0) {
                value = (short)(value | 8);
            }
            Int10_pal.ResetACTL();
            IoHandler.IO_Write(960, 16);
            IoHandler.IO_Write(960, value);
            IoHandler.IO_Write(960, 32);
            short msrval = (short)(Memory.real_readb(64, 101) & 0xFFFFFFDF);
            if (state != 0) {
                msrval = (short)(msrval | 0x20);
            }
            Memory.real_writeb(64, 101, msrval);
        }
    }

    public static short INT10_GetSinglePaletteRegister(short val, short reg) {
        if (reg <= 20) {
            Int10_pal.ResetACTL();
            IoHandler.IO_Write(960, (byte)(reg + 32));
            val = IoHandler.IO_Read(961);
            IoHandler.IO_Write(960, (byte)val);
        }
        return val;
    }

    public static short INT10_GetOverscanBorderColor() {
        Int10_pal.ResetACTL();
        IoHandler.IO_Write(960, 49);
        short val = IoHandler.IO_Read(961);
        IoHandler.IO_Write(960, (byte)val);
        return val;
    }

    public static void INT10_GetAllPaletteRegisters(int data) {
        Int10_pal.ResetACTL();
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            IoHandler.IO_Write(960, i);
            Memory.mem_writeb(data, IoHandler.IO_Read(961));
            Int10_pal.ResetACTL();
            ++data;
        }
        IoHandler.IO_Write(960, 49);
        Memory.mem_writeb(data, IoHandler.IO_Read(961));
        Int10_pal.ResetACTL();
    }

    public static void INT10_SetSingleDACRegister(short index, short red, short green, short blue) {
        IoHandler.IO_Write(968, index);
        if ((Memory.real_readb(64, 137) & 6) == 0) {
            IoHandler.IO_Write(969, red);
            IoHandler.IO_Write(969, green);
            IoHandler.IO_Write(969, blue);
        } else {
            int i = 77 * red + 151 * green + 28 * blue + 128 >> 8;
            int ic = (short)(i > 63 ? 63 : (short)(i & 0xFF));
            IoHandler.IO_Write(969, ic);
            IoHandler.IO_Write(969, ic);
            IoHandler.IO_Write(969, ic);
        }
        IoHandler.IO_Write(968, index);
        IoHandler.IO_Write(969, red);
        IoHandler.IO_Write(969, green);
        IoHandler.IO_Write(969, blue);
    }

    public static void INT10_GetSingleDACRegister(short index, ShortRef red, ShortRef green, ShortRef blue) {
        IoHandler.IO_Write(967, index);
        red.value = IoHandler.IO_Read(969);
        green.value = IoHandler.IO_Read(969);
        blue.value = IoHandler.IO_Read(969);
    }

    public static void INT10_SetDACBlock(int index, int count, int data) {
        IoHandler.IO_Write(968, index);
        if ((Memory.real_readb(64, 137) & 6) == 0) {
            while (count > 0) {
                IoHandler.IO_Write(969, Memory.mem_readb(data++));
                IoHandler.IO_Write(969, Memory.mem_readb(data++));
                IoHandler.IO_Write(969, Memory.mem_readb(data++));
                --count;
            }
        } else {
            while (count > 0) {
                short blue;
                short green;
                int i;
                short red = Memory.mem_readb(data++);
                int ic = (short)((i = 77 * red + 151 * (green = Memory.mem_readb(data++)) + 28 * (blue = Memory.mem_readb(data++)) + 128 >> 8) > 63 ? 63 : (short)(i & 0xFF));
                IoHandler.IO_Write(969, ic);
                IoHandler.IO_Write(969, ic);
                IoHandler.IO_Write(969, ic);
                --count;
            }
        }
    }

    public static void INT10_GetDACBlock(int index, int count, int data) {
        IoHandler.IO_Write(967, index);
        while (count > 0) {
            Memory.mem_writeb(data++, IoHandler.IO_Read(969));
            Memory.mem_writeb(data++, IoHandler.IO_Read(969));
            Memory.mem_writeb(data++, IoHandler.IO_Read(969));
            --count;
        }
    }

    public static void INT10_SelectDACPage(short function, short mode) {
        Int10_pal.ResetACTL();
        IoHandler.IO_Write(960, 16);
        short old10 = IoHandler.IO_Read(961);
        if (function == 0) {
            old10 = mode != 0 ? (short)(old10 | 0x80) : (short)(old10 & 0x7F);
            IoHandler.IO_Write(960, old10);
        } else {
            IoHandler.IO_Write(960, old10);
            if ((old10 & 0x80) == 0) {
                mode = (short)(mode << 2);
            }
            mode = (short)(mode & 0xF);
            IoHandler.IO_Write(960, 20);
            IoHandler.IO_Write(960, mode);
        }
        IoHandler.IO_Write(960, 32);
    }

    public static void INT10_GetDACPage(ShortRef mode, ShortRef page) {
        Int10_pal.ResetACTL();
        IoHandler.IO_Write(960, 16);
        short reg10 = IoHandler.IO_Read(961);
        IoHandler.IO_Write(960, reg10);
        mode.value = (short)((reg10 & 0x80) != 0 ? 1 : 0);
        IoHandler.IO_Write(960, 20);
        page.value = IoHandler.IO_Read(961);
        IoHandler.IO_Write(960, page.value);
        if (mode.value != 0) {
            page.value = (short)(page.value & 0xF);
        } else {
            page.value = (short)(page.value & 0xC);
            page.value = (short)(page.value >> 2);
        }
    }

    public static void INT10_SetPelMask(short mask) {
        IoHandler.IO_Write(966, mask);
    }

    public static short INT10_GetPelMask() {
        return IoHandler.IO_Read(966);
    }

    public static void INT10_SetBackgroundBorder(short val) {
        short temp = Memory.real_readb(64, 102);
        temp = (short)(temp & 0xE0 | val & 0x1F);
        Memory.real_writeb(64, 102, temp);
        if (Dosbox.machine == 1 || Dosbox.IS_TANDY_ARCH()) {
            IoHandler.IO_Write(985, temp);
        } else if (Dosbox.IS_EGAVGA_ARCH()) {
            val = (short)(val << 1 & 0x10 | val & 7);
            Int10_pal.INT10_SetSinglePaletteRegister((short)17, val);
            if (Int10_modes.CurMode.mode <= 3) {
                return;
            }
            Int10_pal.INT10_SetSinglePaletteRegister((short)0, val);
            val = (short)(temp & 0x10 | 2 | (temp & 0x20) >> 5);
            Int10_pal.INT10_SetSinglePaletteRegister((short)1, val);
            val = (short)(val + 2);
            Int10_pal.INT10_SetSinglePaletteRegister((short)2, val);
            val = (short)(val + 2);
            Int10_pal.INT10_SetSinglePaletteRegister((short)3, val);
        }
    }

    public static void INT10_SetColorSelect(short val) {
        short temp = Memory.real_readb(64, 102);
        temp = (short)(temp & 0xDF | ((val & 1) != 0 ? 32 : 0));
        Memory.real_writeb(64, 102, temp);
        if (Dosbox.machine == 1 || Dosbox.IS_TANDY_ARCH()) {
            IoHandler.IO_Write(985, temp);
        } else if (Dosbox.IS_EGAVGA_ARCH()) {
            if (Int10_modes.CurMode.mode <= 3) {
                return;
            }
            val = (short)(temp & 0x10 | 2 | val);
            Int10_pal.INT10_SetSinglePaletteRegister((short)1, val);
            val = (short)(val + 2);
            Int10_pal.INT10_SetSinglePaletteRegister((short)2, val);
            val = (short)(val + 2);
            Int10_pal.INT10_SetSinglePaletteRegister((short)3, val);
        }
    }

    public static void INT10_PerformGrayScaleSumming(int start_reg, int count) {
        if (count > 256) {
            count = 256;
        }
        for (int ct = 0; ct < count; ++ct) {
            IoHandler.IO_Write(967, start_reg + ct);
            short red = IoHandler.IO_Read(969);
            short green = IoHandler.IO_Read(969);
            short blue = IoHandler.IO_Read(969);
            int i = 77 * red + 151 * green + 28 * blue + 128 >> 8;
            short ic = (short)(i > 63 ? 63 : i & 0xFF);
            Int10_pal.INT10_SetSingleDACRegister((short)(start_reg + ct), ic, ic, ic);
        }
    }
}

