/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.ints.Int10;
import jdos.ints.Int10_modes;
import jdos.util.IntRef;
import jdos.util.Ptr;

public class Int10_vesa {
    private static Callback callback;
    private static final String string_oem = "S3 Incorporated. Trio64\u0000";
    private static final String string_vendorname = "DOSBox Development Team\u0000";
    private static final String string_productname = "DOSBox - The DOS Emulator\u0000";
    private static final String string_productrev = "DOSBox 0.74.25b\u0000";
    private static Callback.Handler VESA_SetWindow;
    private static Callback.Handler VESA_PMSetWindow;
    private static Callback.Handler VESA_PMSetPalette;
    private static Callback.Handler VESA_PMSetStart;

    public static short VESA_GetSVGAInformation(int seg, int off) {
        int i;
        int buffer = Memory.PhysMake(seg, off);
        boolean vbe2 = false;
        int vbe2_pos = 256 + off;
        int id = Memory.mem_readd(buffer);
        if (!(id != 1447183666 && id != 843399766 || Int10.int10.vesa_oldvbe)) {
            vbe2 = true;
        }
        if (vbe2) {
            for (i = 0; i < 512; ++i) {
                Memory.mem_writeb(buffer + i, 0);
            }
        } else {
            for (i = 0; i < 256; ++i) {
                Memory.mem_writeb(buffer + i, 0);
            }
        }
        Memory.MEM_BlockWrite(buffer, "VESA", 4);
        if (!Int10.int10.vesa_oldvbe) {
            Memory.mem_writew(buffer + 4, 512);
        } else {
            Memory.mem_writew(buffer + 4, 258);
        }
        if (vbe2) {
            Memory.mem_writed(buffer + 6, Memory.RealMake(seg, vbe2_pos));
            for (i = 0; i < string_oem.length(); ++i) {
                Memory.real_writeb(seg, vbe2_pos++, string_oem.charAt(i));
            }
            Memory.mem_writew(buffer + 20, 512);
            Memory.mem_writed(buffer + 22, Memory.RealMake(seg, vbe2_pos));
            for (i = 0; i < string_vendorname.length(); ++i) {
                Memory.real_writeb(seg, vbe2_pos++, string_vendorname.charAt(i));
            }
            Memory.mem_writed(buffer + 26, Memory.RealMake(seg, vbe2_pos));
            for (i = 0; i < string_productname.length(); ++i) {
                Memory.real_writeb(seg, vbe2_pos++, string_productname.charAt(i));
            }
            Memory.mem_writed(buffer + 30, Memory.RealMake(seg, vbe2_pos));
            for (i = 0; i < string_productrev.length(); ++i) {
                Memory.real_writeb(seg, vbe2_pos++, string_productrev.charAt(i));
            }
        } else {
            Memory.mem_writed(buffer + 6, Int10.int10.rom.oemstring);
        }
        Memory.mem_writed(buffer + 10, 0);
        Memory.mem_writed(buffer + 14, Int10.int10.rom.vesa_modes);
        Memory.mem_writew(buffer + 18, VGA.vga.vmemsize / 65536);
        return 0;
    }

    public static short VESA_GetSVGAModeInformation(int mode, int seg, int off) {
        int modeAttributes;
        int pageSize;
        MODE_INFO minfo = new MODE_INFO();
        int buf = Memory.PhysMake(seg, off);
        int i = 0;
        if ((mode &= 0x3FFF) < 256) {
            return 1;
        }
        if (VGA.svga.accepts_mode != null && !VGA.svga.accepts_mode.call(mode)) {
            return 1;
        }
        boolean foundit = false;
        while (Int10_modes.ModeList_VGA[i].mode != 65535) {
            if (mode == Int10_modes.ModeList_VGA[i].mode) {
                foundit = true;
                break;
            }
            ++i;
        }
        if (!foundit) {
            return 1;
        }
        if (Int10.int10.vesa_oldvbe && Int10_modes.ModeList_VGA[i].mode >= 288) {
            return 1;
        }
        Int10.VideoModeBlock mblock = Int10_modes.ModeList_VGA[i];
        switch (mblock.type) {
            case 4: {
                pageSize = mblock.sheight * mblock.swidth / 2;
                pageSize = (pageSize | 0xF) & 0xFFFFFFF0;
                minfo.BytesPerScanLine = mblock.swidth / 8;
                minfo.NumberOfPlanes = (short)4;
                minfo.BitsPerPixel = (short)4;
                minfo.MemoryModel = (short)3;
                modeAttributes = 27;
                break;
            }
            case 5: {
                pageSize = mblock.sheight * mblock.swidth;
                pageSize = (pageSize | 0xF) & 0xFFFFFFF0;
                minfo.BytesPerScanLine = mblock.swidth;
                minfo.NumberOfPlanes = 1;
                minfo.BitsPerPixel = (short)8;
                minfo.MemoryModel = (short)4;
                modeAttributes = 27;
                if (Int10.int10.vesa_nolfb) break;
                modeAttributes = (short)(modeAttributes | 0x80);
                break;
            }
            case 6: {
                pageSize = mblock.sheight * mblock.swidth * 2;
                pageSize = (pageSize | 0xF) & 0xFFFFFFF0;
                minfo.BytesPerScanLine = mblock.swidth * 2;
                minfo.NumberOfPlanes = 1;
                minfo.BitsPerPixel = (short)15;
                minfo.MemoryModel = (short)6;
                minfo.RedMaskSize = (short)5;
                minfo.RedMaskPos = (short)10;
                minfo.GreenMaskSize = (short)5;
                minfo.GreenMaskPos = (short)5;
                minfo.BlueMaskSize = (short)5;
                minfo.BlueMaskPos = 0;
                minfo.ReservedMaskSize = 1;
                minfo.ReservedMaskPos = (short)15;
                modeAttributes = 27;
                if (Int10.int10.vesa_nolfb) break;
                modeAttributes = (short)(modeAttributes | 0x80);
                break;
            }
            case 7: {
                pageSize = mblock.sheight * mblock.swidth * 2;
                pageSize = (pageSize | 0xF) & 0xFFFFFFF0;
                minfo.BytesPerScanLine = mblock.swidth * 2;
                minfo.NumberOfPlanes = 1;
                minfo.BitsPerPixel = (short)16;
                minfo.MemoryModel = (short)6;
                minfo.RedMaskSize = (short)5;
                minfo.RedMaskPos = (short)11;
                minfo.GreenMaskSize = (short)6;
                minfo.GreenMaskPos = (short)5;
                minfo.BlueMaskSize = (short)5;
                minfo.BlueMaskPos = 0;
                modeAttributes = 27;
                if (Int10.int10.vesa_nolfb) break;
                modeAttributes = (short)(modeAttributes | 0x80);
                break;
            }
            case 8: {
                pageSize = mblock.sheight * mblock.swidth * 4;
                pageSize = (pageSize | 0xF) & 0xFFFFFFF0;
                minfo.BytesPerScanLine = mblock.swidth * 4;
                minfo.NumberOfPlanes = 1;
                minfo.BitsPerPixel = (short)32;
                minfo.MemoryModel = (short)6;
                minfo.RedMaskSize = (short)8;
                minfo.RedMaskPos = (short)16;
                minfo.GreenMaskSize = (short)8;
                minfo.GreenMaskPos = (short)8;
                minfo.BlueMaskSize = (short)8;
                minfo.BlueMaskPos = 0;
                minfo.ReservedMaskSize = (short)8;
                minfo.ReservedMaskPos = (short)24;
                modeAttributes = 27;
                if (Int10.int10.vesa_nolfb) break;
                modeAttributes = (short)(modeAttributes | 0x80);
                break;
            }
            default: {
                return 1;
            }
        }
        minfo.WinAAttributes = (short)7;
        if (pageSize > VGA.vga.vmemsize) {
            minfo.ModeAttributes = modeAttributes & 0xFFFFFFFE;
            minfo.NumberOfImagePages = 0;
        } else {
            minfo.ModeAttributes = modeAttributes;
            int pages = VGA.vga.vmemsize / pageSize - 1;
            minfo.NumberOfImagePages = (short)pages;
        }
        if (mblock.type == 9) {
            minfo.WinGranularity = 32;
            minfo.WinSize = 32;
            minfo.WinASegment = 47104;
            minfo.XResolution = mblock.swidth / 8;
            minfo.YResolution = mblock.sheight / 8;
        } else {
            minfo.WinGranularity = 64;
            minfo.WinSize = 64;
            minfo.WinASegment = 40960;
            minfo.XResolution = mblock.swidth;
            minfo.YResolution = mblock.sheight;
        }
        minfo.WinFuncPtr = jdos.cpu.Callback.CALLBACK_RealPointer(Int10_vesa.callback.setwindow);
        minfo.NumberOfBanks = 1;
        minfo.Reserved_page = 1;
        minfo.XCharSize = (short)mblock.cwidth;
        minfo.YCharSize = (short)mblock.cheight;
        if (!Int10.int10.vesa_nolfb) {
            minfo.PhysBasePtr = -1073741824L;
        }
        minfo.write(buf);
        return 0;
    }

    public static short VESA_SetSVGAMode(int mode) {
        if (Int10_modes.INT10_SetVideoMode(mode)) {
            Int10.int10.vesa_setmode = mode & Short.MAX_VALUE;
            return 0;
        }
        return 1;
    }

    public static int VESA_GetSVGAMode() {
        if (Int10.int10.vesa_setmode != 65535) {
            return Int10.int10.vesa_setmode;
        }
        return Int10_modes.CurMode.mode;
    }

    public static short VESA_SetCPUWindow(short window, short address) {
        if (window != 0) {
            return 1;
        }
        if ((long)address * 64L * 1024L < (long)VGA.vga.vmemsize) {
            IoHandler.IO_Write(980, 106);
            IoHandler.IO_Write(981, address);
            return 0;
        }
        return 1;
    }

    public static int VESA_GetCPUWindow(short window) {
        if (window != 0) {
            return 1;
        }
        IoHandler.IO_Write(980, 106);
        return IoHandler.IO_Read(981);
    }

    public static short VESA_SetPalette(int data, int index, int count) {
        if (index > 255) {
            return 1;
        }
        if (index + count > 256) {
            return 1;
        }
        IoHandler.IO_Write(968, index);
        while (count != 0) {
            short b = Memory.mem_readb(data++);
            short g = Memory.mem_readb(data++);
            short r = Memory.mem_readb(data++);
            ++data;
            IoHandler.IO_Write(969, r);
            IoHandler.IO_Write(969, g);
            IoHandler.IO_Write(969, b);
            --count;
        }
        return 0;
    }

    public static short VESA_GetPalette(int data, int index, int count) {
        if (index > 255) {
            return 1;
        }
        if (index + count > 256) {
            return 1;
        }
        IoHandler.IO_Write(967, index);
        while (count != 0) {
            short r = IoHandler.IO_Read(969);
            short g = IoHandler.IO_Read(969);
            short b = IoHandler.IO_Read(969);
            Memory.mem_writeb(data++, b);
            Memory.mem_writeb(data++, g);
            Memory.mem_writeb(data++, r);
            ++data;
            --count;
        }
        return 0;
    }

    public static short VESA_ScanLineLength(short subcall, int val, IntRef bytes, IntRef pixels, IntRef lines) {
        int bpp;
        switch (Int10_modes.CurMode.type) {
            case 4: {
                bpp = 1;
                break;
            }
            case 5: {
                bpp = 1;
                break;
            }
            case 6: 
            case 7: {
                bpp = 2;
                break;
            }
            case 8: {
                bpp = 4;
                break;
            }
            default: {
                return 1;
            }
        }
        switch (subcall) {
            case 0: {
                if (Int10_modes.CurMode.type == 4) {
                    VGA.vga.config.scan_len = val / 2;
                    break;
                }
                VGA.vga.config.scan_len = val * bpp;
                break;
            }
            case 2: {
                if (Int10_modes.CurMode.type == 4) {
                    VGA.vga.config.scan_len = val * 4;
                    break;
                }
                VGA.vga.config.scan_len = val;
                break;
            }
            case 3: {
                bytes.value = 4096;
                pixels.value = bytes.value / bpp;
                lines.value = VGA.vga.vmemsize / bytes.value;
                return 0;
            }
            case 1: {
                break;
            }
            default: {
                return 1;
            }
        }
        if (subcall != 1) {
            if ((VGA.vga.config.scan_len & 7) != 0) {
                VGA.vga.config.scan_len += 8;
            }
            VGA.vga.config.scan_len /= 8;
        }
        if (Int10_modes.CurMode.type == 4) {
            pixels.value = VGA.vga.config.scan_len * 16 / bpp;
            bytes.value = VGA.vga.config.scan_len * 2;
            lines.value = VGA.vga.vmemsize / (bytes.value * 4);
        } else {
            pixels.value = VGA.vga.config.scan_len * 8 / bpp;
            bytes.value = VGA.vga.config.scan_len * 8;
            lines.value = VGA.vga.vmemsize / bytes.value;
        }
        VGA.VGA_StartResize();
        return 0;
    }

    public static short VESA_SetDisplayStart(int x, int y) {
        switch (Int10_modes.CurMode.type) {
            case 4: {
                int start = VGA.vga.config.scan_len * 16 * y + x;
                VGA.vga.config.display_start = start / 8;
                IoHandler.IO_Read(986);
                IoHandler.IO_Write(960, 51);
                IoHandler.IO_Write(960, start % 8);
                break;
            }
            case 5: {
                int start = VGA.vga.config.scan_len * 8 * y + x;
                VGA.vga.config.display_start = start / 4;
                IoHandler.IO_Read(986);
                IoHandler.IO_Write(960, 51);
                IoHandler.IO_Write(960, start % 4 * 2);
                break;
            }
            case 6: 
            case 7: {
                int start = VGA.vga.config.scan_len * 8 * y + x * 2;
                VGA.vga.config.display_start = start / 4;
                break;
            }
            case 8: {
                int start = VGA.vga.config.scan_len * 8 * y + x * 4;
                VGA.vga.config.display_start = start / 4;
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    public static short VESA_GetDisplayStart(IntRef x, IntRef y) {
        int times = VGA.vga.config.display_start * 4 / (VGA.vga.config.scan_len * 8);
        int rem = VGA.vga.config.display_start * 4 % (VGA.vga.config.scan_len * 8);
        short pan = VGA.vga.config.pel_panning;
        switch (Int10_modes.CurMode.type) {
            case 5: {
                y.value = times;
                x.value = rem + pan;
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    public static void INT10_SetupVESA() {
        callback = new Callback();
        int i = 0;
        Int10.int10.rom.vesa_modes = Memory.RealMake(49152, Int10.int10.rom.used);
        while (Int10_modes.ModeList_VGA[i].mode != 65535) {
            boolean canuse_mode = false;
            if (VGA.svga.accepts_mode == null) {
                canuse_mode = true;
            } else if (VGA.svga.accepts_mode.call(Int10_modes.ModeList_VGA[i].mode)) {
                canuse_mode = true;
            }
            if (Int10_modes.ModeList_VGA[i].mode >= 256 && canuse_mode && (!Int10.int10.vesa_oldvbe || Int10_modes.ModeList_VGA[i].mode < 288)) {
                Memory.phys_writew(Memory.PhysMake(49152, Int10.int10.rom.used), Int10_modes.ModeList_VGA[i].mode);
                Int10.int10.rom.used += 2;
            }
            ++i;
        }
        Memory.phys_writew(Memory.PhysMake(49152, Int10.int10.rom.used), 65535);
        Int10.int10.rom.used += 2;
        Int10.int10.rom.oemstring = Memory.RealMake(49152, Int10.int10.rom.used);
        Memory.phys_writes(786432 + Int10.int10.rom.used, string_oem);
        Int10.int10.rom.used += string_oem.length();
        Int10_vesa.callback.setwindow = jdos.cpu.Callback.CALLBACK_Allocate();
        Int10_vesa.callback.pmPalette = jdos.cpu.Callback.CALLBACK_Allocate();
        Int10_vesa.callback.pmStart = jdos.cpu.Callback.CALLBACK_Allocate();
        jdos.cpu.Callback.CALLBACK_Setup(Int10_vesa.callback.setwindow, VESA_SetWindow, 1, "VESA Real Set Window");
        Int10.int10.rom.pmode_interface = Memory.RealMake(49152, Int10.int10.rom.used);
        Int10.int10.rom.used += 8;
        Int10.int10.rom.pmode_interface_window = Int10.int10.rom.used - Memory.RealOff(Int10.int10.rom.pmode_interface);
        Memory.phys_writew(Memory.Real2Phys(Int10.int10.rom.pmode_interface) + 0, Int10.int10.rom.pmode_interface_window);
        Int10_vesa.callback.pmWindow = jdos.cpu.Callback.CALLBACK_Allocate();
        Int10.int10.rom.used += jdos.cpu.Callback.CALLBACK_Setup(Int10_vesa.callback.pmWindow, VESA_PMSetWindow, 0, Memory.PhysMake(49152, Int10.int10.rom.used), "VESA PM Set Window");
        Int10.int10.rom.pmode_interface_start = Int10.int10.rom.used - Memory.RealOff(Int10.int10.rom.pmode_interface);
        Memory.phys_writew(Memory.Real2Phys(Int10.int10.rom.pmode_interface) + 2, Int10.int10.rom.pmode_interface_start);
        Int10_vesa.callback.pmStart = jdos.cpu.Callback.CALLBACK_Allocate();
        Int10.int10.rom.used += jdos.cpu.Callback.CALLBACK_Setup(Int10_vesa.callback.pmStart, VESA_PMSetStart, 0, Memory.PhysMake(49152, Int10.int10.rom.used), "VESA PM Set Start");
        Int10.int10.rom.pmode_interface_palette = Int10.int10.rom.used - Memory.RealOff(Int10.int10.rom.pmode_interface);
        Memory.phys_writew(Memory.Real2Phys(Int10.int10.rom.pmode_interface) + 4, Int10.int10.rom.pmode_interface_palette);
        Int10_vesa.callback.pmPalette = jdos.cpu.Callback.CALLBACK_Allocate();
        Int10.int10.rom.used += jdos.cpu.Callback.CALLBACK_Setup(Int10_vesa.callback.pmPalette, VESA_PMSetPalette, 0, Memory.PhysMake(49152, Int10.int10.rom.used), "VESA PM Set Palette");
        Memory.phys_writew(Memory.Real2Phys(Int10.int10.rom.pmode_interface) + 6, 0);
        Int10.int10.rom.pmode_interface_size = Int10.int10.rom.used - Memory.RealOff(Int10.int10.rom.pmode_interface);
    }

    static {
        VESA_SetWindow = new Callback.Handler(){

            public String getName() {
                return "Int10_vesa.VESA_SetWindow";
            }

            public int call() {
                if (CPU_Regs.reg_ebx.high() != 0) {
                    CPU_Regs.reg_eax.high(0);
                    CPU_Regs.reg_edx.word(Int10_vesa.VESA_GetCPUWindow(CPU_Regs.reg_ebx.low()));
                } else {
                    CPU_Regs.reg_eax.high(Int10_vesa.VESA_SetCPUWindow(CPU_Regs.reg_ebx.low(), CPU_Regs.reg_edx.low()));
                }
                CPU_Regs.reg_eax.low(79);
                return 0;
            }
        };
        VESA_PMSetWindow = new Callback.Handler(){

            public String getName() {
                return "Int10_vesa.VESA_PMSetWindow";
            }

            public int call() {
                Int10_vesa.VESA_SetCPUWindow((short)0, (short)CPU_Regs.reg_edx.word());
                return 0;
            }
        };
        VESA_PMSetPalette = new Callback.Handler(){

            public String getName() {
                return "Int10_vesa.VESA_PMSetPalette";
            }

            public int call() {
                Int10_vesa.VESA_SetPalette(CPU.Segs_ESphys + CPU_Regs.reg_edi.dword, CPU_Regs.reg_edx.word(), CPU_Regs.reg_ecx.word());
                return 0;
            }
        };
        VESA_PMSetStart = new Callback.Handler(){

            public String getName() {
                return "Int10_vesa.VESA_PMSetStart";
            }

            public int call() {
                int start;
                VGA.vga.config.display_start = start = CPU_Regs.reg_edx.word() << 16 | CPU_Regs.reg_ecx.word();
                return 0;
            }
        };
    }

    private static class MODE_INFO {
        int ModeAttributes;
        short WinAAttributes;
        short WinBAttributes;
        int WinGranularity;
        int WinSize;
        int WinASegment;
        int WinBSegment;
        long WinFuncPtr;
        int BytesPerScanLine;
        int XResolution;
        int YResolution;
        short XCharSize;
        short YCharSize;
        short NumberOfPlanes;
        short BitsPerPixel;
        short NumberOfBanks;
        short MemoryModel;
        short BankSize;
        short NumberOfImagePages;
        short Reserved_page;
        short RedMaskSize;
        short RedMaskPos;
        short GreenMaskSize;
        short GreenMaskPos;
        short BlueMaskSize;
        short BlueMaskPos;
        short ReservedMaskSize;
        short ReservedMaskPos;
        short DirectColorModeInfo;
        long PhysBasePtr;
        long OffScreenMemOffset;
        int OffScreenMemSize;
        byte[] Reserved = new byte[206];

        private MODE_INFO() {
        }

        public void write(int addr) {
            byte[] data = new byte[256];
            Ptr p = new Ptr(data, 0);
            p.writew(0, this.ModeAttributes);
            p.writeb(2, this.WinAAttributes);
            p.writeb(3, this.WinBAttributes);
            p.writew(4, this.WinGranularity);
            p.writew(6, this.WinSize);
            p.writew(8, this.WinASegment);
            p.writew(10, this.WinBSegment);
            p.writed(12, (int)this.WinFuncPtr);
            p.writew(16, this.BytesPerScanLine);
            p.writew(18, this.XResolution);
            p.writew(20, this.YResolution);
            p.writeb(22, this.XCharSize);
            p.writeb(23, this.YCharSize);
            p.writeb(24, this.NumberOfPlanes);
            p.writeb(25, this.BitsPerPixel);
            p.writeb(26, this.NumberOfBanks);
            p.writeb(27, this.MemoryModel);
            p.writeb(28, this.BankSize);
            p.writeb(29, this.NumberOfImagePages);
            p.writeb(30, this.Reserved_page);
            p.writeb(31, this.RedMaskSize);
            p.writeb(32, this.RedMaskPos);
            p.writeb(33, this.GreenMaskSize);
            p.writeb(34, this.GreenMaskPos);
            p.writeb(35, this.BlueMaskSize);
            p.writeb(36, this.BlueMaskPos);
            p.writeb(37, this.ReservedMaskSize);
            p.writeb(38, this.ReservedMaskPos);
            p.writeb(39, this.DirectColorModeInfo);
            p.writed(40, (int)this.PhysBasePtr);
            p.writed(44, (int)this.OffScreenMemOffset);
            p.writew(48, this.OffScreenMemSize);
            System.arraycopy(this.Reserved, 0, data, 50, this.Reserved.length);
            Memory.MEM_BlockWrite(addr, data, data.length);
        }
    }

    private static class Callback {
        int setwindow;
        int pmStart;
        int pmWindow;
        int pmPalette;

        private Callback() {
        }
    }
}

